/* HPUX_ID: @(#)vmmac.h	27.5		85/10/09 */

/*
 * Virtual memory related conversion macros
 */

/* Core clicks to number of pages of page tables needed to map that much */
#define	ctopt(x)	(((x)+NPTEPG-1)/NPTEPG)

/* Virtual page numbers to text|data|stack segment page numbers and back */
#define	vtotp(p, v)	((int)(v)-LOWPAGES)
#define	vtodp(p, v)	((int)((v) - stoc(ctos((p)->p_tsize)) - LOWPAGES))
#ifdef	WOPR
#define	vtosp(p, v)	((int)(btop(usrstack) - 1 - (v)))
#else	not WOPR
#define	vtosp(p, v)	((int)(btop(USRSTACK) - 1 - (v)))
#endif	WOPR
#define	tptov(p, i)	((unsigned)(i) + LOWPAGES)
#define	dptov(p, i)	((unsigned)(stoc(ctos((p)->p_tsize)) + (i) + LOWPAGES))
#ifdef	WOPR
#define	sptov(p, i)	((unsigned)(btop(usrstack) - 1 - (i)))
#else	not WOPR
#define	sptov(p, i)	((unsigned)(btop(USRSTACK) - 1 - (i)))
#endif	WOPR

/* Tell whether virtual page numbers are in text|data|stack segment */
#ifdef	WOPR
#define	isassv(p, v)	((v) >= btop(usrstack) - (p)->p_ssize)
#else	not WOPR
#define	isassv(p, v)	((v) >= btop(USRSTACK) - (p)->p_ssize)
#endif	WOPR
#define	isatsv(p, v)	(((v) - LOWPAGES) < (p)->p_tsize)
/*
 * isadsv was changed and based on the fact that p_dsize is static.  4.2
 * on vax used   different  check, it was a catch-all case for them, the
 * region limit  register helps them out here.  They do not need to call
 * this to decide whether to grow stack or not but we do.  
 */
#define	isadsv(p, v)	(((v) - LOWPAGES) >= stoc(ctos((p)->p_tsize)) \
      && (((v) - LOWPAGES) < (stoc(ctos((p)->p_tsize)) + (p)->p_dsize))) 

/* Tell whether pte's are text|data|stack */
#define	isaspte(p, pte)		((pte) > sptopte(p, (p)->p_ssize))
#define	isatpte(p, pte)		((pte) < dptopte(p, 0))
#define	isadpte(p, pte)		(!isaspte(p, pte) && !isatpte(p, pte))

/* Text|data|stack pte's to segment page numbers and back */
#define	ptetotp(p, pte)		((pte) - (p)->p_p0br)
#define	ptetodp(p, pte)		((pte) - ((p)->p_p0br + (p)->p_tsize))

#ifdef	UMM
#define	ptetosp(p, pte)	\
	(((p)->p_p0br + SZPT*NPTEPG - HIGHPAGES - 1) - (pte))
#else	WOPR
#define	ptetosp(p, pte)	\
	(((p)->p_p0br + (p)->p_szpt*NPTEPG - HIGHPAGES - 1) - (pte))
#endif


#define	tptopte(p, i)		((p)->p_p0br + (i))
#define	dptopte(p, i)		((p)->p_p0br + (p)->p_tsize + (i))

#ifdef	UMM
#define	sptopte(p, i) \
	(((p)->p_p0br + SZPT*NPTEPG - HIGHPAGES - 1) - (i))
#else	WOPR
#define	sptopte(p, i)	\
	(((p)->p_p0br + (p)->p_szpt*NPTEPG - HIGHPAGES - 1) - (i))
#endif


/* pte to kernel stack segment page number.     */

/* Bytes to pages without rounding, and back */
#define	btop(x)		(((unsigned)(x)) >> PGSHIFT)
#define	ptob(x)		((caddr_t)((x) << PGSHIFT))

/* Turn virtual addresses into kernel map indices */
#define	kmxtob(a)	(usrpt + (a) * NPTEPG)
#define	btokmx(a)	(((a) - usrpt)  / NPTEPG)

/* User area address and pcb bases */
#ifdef	UMM
#define	uaddr(p)	(&((p)->p_p0br[SZPT * NPTEPG - HIGHPAGES]))
#else	WOPR
#define	uaddr(p)	(&((p)->p_p0br[(p)->p_szpt*NPTEPG - HIGHPAGES]))
#endif

/* Proc table index 
 * User area pte length (note: u_areas are not compacted below one page)
 * User area (Umap) pte address
 * User area virtual address 
 * Number of pages per user area (rounded up). 
 */

#if defined(WOPR)
#define	pcbb(p)		((p)->p_addr[0].pg_pfnum)
#endif

#ifdef	UMM
/* This is a fast findumpte !yech! it knows page table structure */
#define	pcbb(p)		((pt_entry_t *)((p)->p_addr + SZPT * NPTEPG))
#endif	UMM


/* Average new into old with aging factor time */
#define	ave(smooth, cnt, time) \
	smooth = ((time - 1) * (smooth) + (cnt)) / (time)

/* Abstract machine dependent operations */
#define	setp0br(x)	(u.u_pcb.pcb_p0br = (x)) 
#define	setp0lr(x)	(u.u_pcb.pcb_p0lr = (x)) 
#define	setp1br(x)	(u.u_pcb.pcb_p1br = (x))
#define	setp1lr(x)	(u.u_pcb.pcb_p1lr = (x))
#define	initp1br(x)	((x) - p1pages)

#define	outofmem()	wakeup((caddr_t)&proc[2])


/*
 * Page clustering macros.
 * 
 * dirtycl(pte)			is the page cluster dirty?
 * anycl(pte,fld)		does any pte in the cluster has fld set?
 * zapcl(pte,fld) = val		set all fields fld in the cluster to val
 * distcl(pte)			distribute high bits to cluster; note that
 *				distcl copies everything but pg_pfnum,
 *				INCLUDING pg_m!!!
 *
 * In all cases, pte must be the low pte in the cluster, even if
 * the segment grows backwards (e.g. the stack).
 */
#define	H(pte)	((struct hpte *)(pte))

#if CLSIZE==1
#define	dirtycl(pte)	dirty(pte)
#define	anycl(pte,fld)	((pte)->fld)
#define	zapcl(pte,fld)	(pte)->fld
#define	distcl(pte)
#endif

#if CLSIZE==2
#define	dirtycl(pte)	(dirty(pte) || dirty((pte)+1))
#define	anycl(pte,fld)	((pte)->fld || (((pte)+1)->fld))
#define	zapcl(pte,fld)	(pte)[1].fld = (pte)[0].fld
#endif

#if CLSIZE==4
#define	dirtycl(pte) \
    (dirty(pte) || dirty((pte)+1) || dirty((pte)+2) || dirty((pte)+3))
#define	anycl(pte,fld) \
    ((pte)->fld || (((pte)+1)->fld) || (((pte)+2)->fld) || (((pte)+3)->fld))
#define	zapcl(pte,fld) \
    (pte)[3].fld = (pte)[2].fld = (pte)[1].fld = (pte)[0].fld
#endif

#ifndef distcl
#define	distcl(pte)	zapcl(H(pte),pg_high)
#endif
