/* HPUX_ID:  @(#)unistd.h	27.2    85/06/27  */
/* MANX  unistd.h  7.1  10/17/84  16:24:59 */

/*
 * Unistd.h
 * symbolic constants and structures which are used
 * for support of the /usr/group standard.
 */

/* Symbolic constants for the "access" function: */
#ifndef R_OK
#define R_OK	4	/* Test for "Read" Permission */
#define W_OK	2	/* Test for "Write" Permission */
#define X_OK	1	/* Test for "Execute" (Search) Permission */
#define F_OK	0	/* Test for existence of file */
#endif

/* Symbolic constants for the "lockf" function: */
#define F_ULOCK	0	/* Unlock a previously locked region */
#define	F_LOCK	1	/* Lock a region for exclusive use */
#define	F_TLOCK	2	/* Test and lock a region for exclusive use */
#define F_TEST	3	/* Test a region for a previous lock */

/* Symbolic constants for the "lseek" function: */
#define SEEK_SET	0	/* Set file pointer to "offset" */
#define	SEEK_CUR	1	/* Set file pointer to current plus "offset" */
#define	SEEK_END	2	/* Set file pointer to EOF plus "offset" */

/* Symbolic constants for the passwd file and group file: */
#define GF_PATH	"/etc/group"	/* Path name of the "group" file */
#define PF_PATH	"/etc/passwd"	/* Path name of the "passwd" file */
#define IN_PATH	"/usr/include"	/* Path name for <...> files */

/* Structure for "utime" function: */
struct utimbuf {
	time_t	actime;		/* Date and time of last access */
	time_t	modtime;	/* Date and time of last modification */
};
