/* @(#)  HP Windows/9000  window.h  39.1  11/15/85  16:35:31 */

/*
 * HP Windows/9000 definitions useful for library calls.
 *
 * Does not include font and icon/sprite file formats (see fonticon.h).
 * Does not include Fast Alpha routines (see fa.h).
 * Does not include Font Manager routines.
 */


/************************************************************************
 * MAXIMUM NUMBER OF WINDOWS PER WINDOW MANAGER:
 *
 * ((file descriptors) - (1 for wm) - (1 for screen) - (3 for input)) / 2
 *
 * (60 - 5)/2 = 27 windows per window manager
 */

#define	WINMAX	 27

/*
 * In the future, if a window type only uses one window unit, or commands
 * work for window units, then:
 *
 * (60 - 5) = 55 windows per window manager
 */


/************************************************************************
 * MAXIMUM LENGTH OF WINDOW NAME:
 *
 * Longest (including the trailing null) a full window pathname and a
 * window unit pathname is ever allowed to be created, or returned from
 * any window routine.
 */

#define	WINNAMEMAX 40
#define	WINUNITMAX 38


/************************************************************************
 * PROCEDURE RETURN TYPES AND PARAMETERS:
 *
 * Procedures only appear here if they have associated definitions which
 * need to appear in this file; see other header files for more stuff.
 *
 * Procedure return types only appear if other than "int".
 */

/* altfont_term0  */
/* basefont_term0 */

#define	GETFONTID     (-1)		/* get id of font */

/* fontgetname_term0 */

char	*fontgetname_term0();

#define	FONTIDMIN	0		/* lowest  possible value */
#define	FONTIDMAX	7		/* highest possible value */

/* fontreplaceall_term0, see wcreate_term0 */

/* wautodestroy */

#define	GETAUTODESTROY   (-1)		/* read current state	*/
#define	SETNOAUTODESTROY   0		/* don't autodestroy	*/
#define	SETAUTODESTROY	   1		/* do autodestroy	*/

/* wautoselect */

#define	GETAUTOSELECT    (-1)		/* read current state	*/
#define	SETNOAUTOSELECT	   0		/* disable autoselect	*/
#define	SETAUTOSELECT	   1		/* enable autoselect	*/

/* wautotop */

#define	GETAUTOTOP    (-1)		/* read current state	*/
#define	SETNOAUTOTOP   	0		/* disable autotop	*/
#define	SETAUTOTOP	1		/* enable autotop	*/

/* wbanner */

#define	GETBANNER     (-1)		/* read current state	*/
#define	SETNOBANNER	0		/* don't display banner	*/
#define	SETBANNER	1		/* do display banner	*/

/* wbottom */

#define	GETBOTTOM     (-1)		/* read current state	*/
#define	SETNOBOTTOM	0		/* ignored		*/
#define	SETBOTTOM	1		/* set to bottom window	*/

/* wconceal */

#define	GETCONCEAL     (-1)		/* read current state	*/
#define	SETNOCONCEAL	0		/* ignored		*/
#define	SETCONCEAL	1		/* set to concealed	*/

/* wcreate_graphics (see also wbanner) */

#define	SETNORETAIN	0		/* set to non-retained	*/
#define	SETRETAIN	1		/* set to retained	*/

/* wcreate_term0 (see also wbanner) */

#ifndef NULL
#define NULL 0
#endif

#define	ALTFONTNULL	((char *) NULL)	/* no alternate font	*/
#define	COLORMODE	2		/* always use this	*/

/* wdfltpos */

#define	DFLT_WPOS	0x1		/* get window X,Y pos	*/
#define	DFLT_IPOS	0x2		/* get icon   X,Y pos	*/
#define	DFLT_NAME	0x4		/* get window name	*/

#define	DFLTNAMEMAX	12		/* max chars in name without null */

/* weventclear, see wgetsigmask */
/* weventpoll,  see wgetsigmask */

/* wgetecho */

#define	ECHO_DEFAULT	0		/* default at window creation	*/
#define	ECHO_BEST	1		/* device's best echo		*/
#define	ECHO_FULL	2		/* full screen cross hair	*/
#define	ECHO_SMALL	3		/* small tracking cursor	*/
#define	ECHO_RUBLINE	4		/* rubber band line		*/
#define	ECHO_RUBRECT	5		/* rubber band rectangle	*/
#define	ECHO_ALPHA	6		/* alpha digital representation	*/
#define	ECHO_USERDEF	7		/* user-defined raster cursor	*/
#define	ECHO_BOX	8		/* box of given width / height	*/
#define	ECHO_DEVDEP	9		/* device dependent form	*/

#define	ECHO_NOOPT	0		/* echo exactly as defined	*/
#define	ECHO_OPT	1		/* device-dependent optimized	*/

/* wgetrasterecho */

typedef	char re_mask  [ 128];		/* raster echo mask, bit  per pixel */
typedef	char re_image [1024];		/* raster echo mask, byte per pixel */

/* wgetsigmask */

#define EVENT_B1_DOWN	0000000001	/* button 1 pressed	   */
#define EVENT_B1_UP	0000000002	/* button 1 released	   */
#define EVENT_B2_DOWN	0000000004	/* button 2 pressed	   */
#define EVENT_B2_UP	0000000010	/* button 2 released	   */
#define EVENT_B3_DOWN	0000000020	/* button 3 pressed	   */
#define EVENT_B3_UP	0000000040	/* button 3 released	   */
#define EVENT_B4_DOWN	0000000100	/* button 4 pressed	   */
#define EVENT_B4_UP	0000000200	/* button 4 released	   */
#define EVENT_B5_DOWN	0000000400	/* button 5 pressed	   */
#define EVENT_B5_UP	0000001000	/* button 5 released	   */
#define EVENT_B6_DOWN	0000002000	/* button 6 pressed	   */
#define EVENT_B6_UP	0000004000	/* button 6 released	   */
#define EVENT_B7_DOWN	0000010000	/* button 7 pressed	   */
#define EVENT_B7_UP	0000020000	/* button 7 released	   */
#define EVENT_B8_DOWN	0000040000	/* button 8 pressed	   */
#define EVENT_B8_UP	0000100000	/* button 8 released	   */
#define EVENT_ECHO	0000200000	/* echo moved		   */
#define EVENT_MOVE	0000400000	/* window moved		   */
#define EVENT_SIZE	0001000000	/* window stretched	   */
#define EVENT_SELECT	0002000000	/* selection state changed */
#define EVENT_REPAINT	0004000000	/* repaint window	   */
#define EVENT_MENU	0010000000	/* menu data available     */

/* wiconic */

#define	GETICONIC     (-1)		/* read current state	*/
#define	SETNOICONIC	0		/* set to normal form	*/
#define	SETICONIC	1		/* set to iconic form	*/

/* wmenu_create */

/* options to cbits */
#define MENU_POPUP	0		/* popup menu */
/* options to parent_menuid */
#define MENU_NOPARENT	(-1)		/* no parent menu */

/* wmenu_item */

/* options to itemno */
#define	MENU_NEWITEM  (-1)		/* add a new item		*/
/* options to type */
#define	MENU_STRING     1		/* text string			*/
#define MENU_SEPARATOR	2		/* horizontal separator		*/
/* options to disp_sel */
#define MENU_NOTSELECTABLE     0	/* menu item isn't selectable	*/
#define	MENU_SELECTABLE 0x000001	/* menu item is selectable	*/
#define	MENU_DISPNORM   0x001000	/* display item in normal mode	*/
#define	MENU_DISPGREY   0x002000	/* display item in grey mode	*/
#define	MENU_TRACKNOCHNG 0x100000	/* don't change item during track */
#define	MENU_TRACKINV   0x400000	/* invert item during tracking	*/

/* wmenu_activate */

/* options to value */
#define	MENU_ACT_INQ  (-1)		/* read current auto poput state   */
#define	MENU_ACT_DIS    0		/* disable automatic popup of menu */
#define	MENU_ACT_AUTO   1		/* enable automatic popup of menu  */
#define	MENU_ACT_IM     2		/* popup menu immediately          */

/* wpauseoutput */

#define	GETPAUSE      (-1)		/* read current state	*/
#define	SETNOPAUSE	0		/* set to normal state	*/
#define	SETPAUSE	1		/* set to paused state	*/

/* wrecover */

#define	GETRECOVER    (-1)		/* read current state	*/
#define	SETNORECOVER	0		/* set to no-recover	*/
#define	SETRECOVER	1		/* set to recover	*/

/* wselect */

#define	GETSELECT     (-1)		/* read current state	*/
#define	SETNOSELECT	0		/* set to non-selected	*/
#define	SETSELECT	1		/* set to selected	*/

/* wsetecho, see wgetecho */

/* wseticon */

#define	IMODE_NONE	0		/* do not display icon	*/
#define	IMODE_TYPE	1		/* type-dependent icon	*/
#define	IMODE_FILE	2		/* file-based icon	*/

#define	LMODE_NONE	0		/* don't display label	*/
#define	LMODE_DISP	1		/* do display label	*/

/* wsetlabel */

#define	LABELMAX       12		/* max chars in label without null */

/* wsetrasterecho, see wgetrasterecho	*/
/* wsetsigmask,    see wgetsigmask	*/

/* wsfk_mode */

#define	SFKOFF		0		/* don't display softkeys */
#define	SFKON		1		/* do display softkeys	  */

/* wsfk_prog */

#define	SFKLABELMAX    16		/* max chars in label without null */
#define	SFKSEPOFF	0		/* don't display separator line	   */
#define	SFKSEPON	1		/* do display separator line	   */

/* wshuffle */

#define	SHUFFLEDOWN	0		/* top moves to bottom	*/
#define	SHUFFLEUP	1		/* bottom moves to top	*/

/* wtop */

#define	GETTOP	      (-1)		/* read current state	*/
#define	SETNOTOP	0		/* ignored		*/
#define	SETTOP		1		/* set to top window	*/
