
.H 1 "Strategy Overview"
All tests will be executed via a stream file.
Some tests should be made manually without executing from a stream file.
For most of the tests the output of the listing is redirected.
This was done to make checking easier.
But there should also be some tests without redirecting the listing.
Manual tests without redirecting the listing should be done for at least one
test for each test area.
.P
For the tests in the first four areas 
no special program writing is required.
To do the unit tests special programs are required.
Those programs ask for the input parameter for the routine to be tested.
They then call the routine and print out the return value and the values
of var parameters.
.P
The BACKUP program has three functions it can perform, backing up files,
restoring files and make a table of contents of a backup tape.
A restore can only be done after a previously made backup.
The same is true for table of contents.
A backup can only be proved to be correct by doing a restore, a table of
contents is only a partial proof.
Because of this connection the test cases can't be separated strictly into
different areas.
To test a specific feature of restore for example, a backup of a specific
kind has to be performed.
.P
There will be a control copy of the subdirectory that is used for backups.
Every backup gets restored into another subdirectory and compared against
this.
Only if the two match exactly we know that both backup and restore work
properly.
Each test case contains information in the detailed description, how it can
be proved.
.P
Here is a description of the different test areas.
It contains only a list of the different features that have to be tested in
each area and does not include how they are related to tests in other areas.
.BL
.LI
The first area is 'Backup'.
The tests in this area check only whether it is possible to backup all
different types of files, whether the incremental and full backups work,
whether the
file names shown in the listing are correct and whether the redirection of
the listing works.
This shows whether it is possible to open and read all files from an HFS
disc.
It doesn't say anything about the correctness of the backup tape made,
this is done with the tests of the next area.
There will also be checks against a known good image of a backup to prove
the correctness of the backup made.
Some of the tests in Backup are followed by a set of tests in Restore.
.LI
The next area is 'Restore'.
With the test in this part all possible modes of restore are tested.
An automatic restore and several restores using rename mode need to be done.
It has to be checked whether the unconditional restore works.
There are also some tests which check the redirection of the listing and
the selective restore.
Another group of tests within this area is restore a backup that was made
on HP-UX and restore a backup made on PAWS to HP-UX.
.LI
Another area is 'Table of contents'.
The tests in this area are trivial but nevertheless have to be performed for
a number of cases.
Here it has to be checked whether the listing looks nice on different types
of terminals (50 chars/line, 80 chars/line) and whether the redirection of
the listing works.
There is also a selective table of contents mode which has to be tested.
.LI
The fourth area is 'Special tests'.
This is a very important area, it checks for the special features which
are not related to only one of the above described parts.
It includes security, linked files, device special files, backup/restore
all different file types from/to all different file systems, utime,
backups/restores which require multiple tapes/floppies,
stress tests and error cases.
It also includes some tests with stream files.
All documented examples get also tested here.
The last topic in this test area is code review, which is also very important.
.LI
The last area contains the 'Unit tests'.
Here some of the routines are tested separately.
Not all routines are covered in this area, only those for which it makes
sense to do unit tests.
The routines not tested here are either trivial, or the BACKUP utility is 
the best program to do so.
.LE
.P
BACKUP supports several output medias, but there is no extra HW configuration
area.
Instead each test contains information about the output media for which it
should be performed.
Most of the tests are done with cartridge tapes, this was done because the
output of most backups doesn't fit onto one floppy.
Because the tests are executed from a stream file it is not easy to change
the output media.
Therefore some of the tests described in this document have to be executed
manually even if there exists a stream file for them.
