.H 1 "Backup"
With BACKUP it is possible to backup only those files in a given set, that
have been changed after a given date.
Tests that check this mode are described in the first section of this chapter.
The second section lists the tests that check for the different possible input
of files to back up.
Section three shows the tests for the redirection of the listing a backup
produces.
The last section contains the description for the checkread tests.
.H 2 "Incremental backup tests"
This tests are done for the three available file systems on PAWS.
For all three tests the incremental backup date has to be reasonable.
In other words some files should be older than this date and some files should
be newer.
.H 3 "Bkp.1.1"
Test incremental backup for files on a LIF volume.
One LIF volume is backed up completely .
The LIF volume should contain files of all possible types.
.TS
expand;
l l lw(4.8i).
output media	:	cartridge tape
stream file	:	SBkp1.1
log file	:	LBkp1.1
actions	:	T{
.na
run the stream file,
check the log file against the expected file list,
do a table of contents and check it against the log file.
.ad
T}
.TE
.H 3 "Bkp.1.2"
Test incremental backup for files on a SRM volume.
Backup a big directory with a lot of files and directories in it.
The depth of this directory should be at least five levels.
.TS
expand;
l l lw(4.8i).
output media	:	cartridge tape
stream file	:	SBkp1.2
log file	:	LBkp1.2
actions	:	T{
.na
run the stream file,
check the log file against the expected file list,
do a table of contents and check it against the log file.
.ad
T}
.TE
.H 3 "Bkp.1.3"
Test incremental backup for files on an HFS volume.
Backup a big directory with a lot of files and directories in it.
The depth of this directory should be at least five levels.
.TS
expand;
l l lw(4.8i).
output media	:	cartridge tape
stream file	:	SBkp1.3
log file	:	LBkp1.3
actions	:	T{
.na
run the stream file,
check the log file against the expected file list,
do a table of contents and check it against the log file.
.ad
T}
.TE
.H 2 "Backup tests"
This tests are done for the three available file systems on PAWS.
.H 3 "Bkp.2.1"
Test backup for files on a LIF volume.
.P
The LIF volume should contain files of all possible types and extensions.
The following files are backed up: 
=, =.TEXT, =.ASC, =.CODE, TST:, #11:, TST:=.ASC, A=.TEXT, A= .
.TS
expand;
l l lw(4.8i).
output media	:	cartridge tape
stream file	:	SBkp2.1
log file	:	LBkp2.1
actions	:	T{
.na
run the stream file,
check the log file against the expected file list,
do a table of contents and check it against the log file.
.ad
T}
.TE
.H 3 "Bkp.2.2"
Test backup for files on a SRM volume.
.P
The SRM volume should contain files of all possible types and extensions.
It should also contain a long directory path (see description of test
environment).
The following files are backed up: 
=, =.TEXT, =.ASC, =.CODE, PWS:, #5:, PWS:=.ASC, A=.TEXT, A=, tst (directory),
/tst, .,
../tst.
.TS
expand;
l l lw(4.8i).
output media	:	cartridge tape
stream file	:	SBkp2.2
log file	:	LBkp2.2
actions	:	T{
.na
run the stream file,
check the log file against the expected file list,
do a table of contents and check it against the log file.
.ad
T}
.TE
.H 3 "Bkp.2.3"
Test backup for files on an HFS volume.
.P
The HFS volume should contain files of all possible types and extensions.
It should also contain a long directory path (see description of test
environment).
The following files are backed up: 
=, =.TEXT, =.ASC, =.CODE, PWS:, #5:, PWS:=.ASC, A=.TEXT, A=, tst (directory),
/tst, .,
../tst.
.TS
expand;
l l lw(4.8i).
output media	:	cartridge tape
stream file	:	SBkp2.3
log file	:	LBkp2.3
actions	:	T{
.na
run the stream file,
check the log file against the expected file list,
do a table of contents and check it against the log file.
.ad
T}
.TE
.H 3 "Bkp.2.4"
Test multi volume backups.
In this test files from all three file systems are backed up onto one
output media.
It is a combination of the previous three tests.
.TS
expand;
l l lw(4.8i).
output media	:	cartridge tape
stream file	:	SBkp2.4
log file	:	LBkp2.4
actions	:	T{
.na
run the stream file,
check the log file against the expected file list,
do a table of contents and check it against the log file.
.ad
T}
.TE
.H 2 "Redirect listing"
Only some of the tests in this section have to be performed, depending
on how the previous ones have been done.
If the listing has been redirected
in previous tests only Bkp.3.5 and Bkp.3.1 have to be
executed, otherwise the first four tests must be executed.
This test is similar to Bkp.2.3 with the addition of redirecting 
respectively not redirecting the output device for the listing.
.H 3 "Bkp.3.1"
Redirect the listing to the PRINTER:.
.TS
expand;
l l lw(4.8i).
output media	:	cartridge tape
stream file	:	SBkp3.1
log file	:	PRINTER:
actions	:	T{
.na
run the stream file,
check the log file against the expected file list
.ad
T}
.TE
.H 3 "Bkp.3.2"
Redirect the listing to a LIF file.
.TS
expand;
l l lw(4.8i).
output media	:	cartridge tape
stream file	:	SBkp3.2
log file	:	LBkp3.2
actions	:	T{
.na
run the stream file,
check the log file against the expected file list
.ad
T}
.TE
.H 3 "Bkp.3.3"
Redirect the listing to a SRM file.
.TS
expand;
l l lw(4.8i).
output media	:	cartridge tape
stream file	:	SBkp3.3
log file	:	LBkp3.3
actions	:	T{
.na
run the stream file,
check the log file against the expected file list
.ad
T}
.TE
.H 3 "Bkp.3.4"
Redirect the listing to an HFS file.
.TS
expand;
l l lw(4.8i).
output media	:	cartridge tape
stream file	:	SBkp3.4
log file	:	LBkp3.4
actions	:	T{
.na
run the stream file,
check the log file against the expected file list
.ad
T}
.TE
.H 3 "Bkp.3.5"
Don't redirect the listing.
.TS
expand;
l l lw(4.8i).
output media	:	cartridge tape
stream file	:	SBkp3.4
log file	:	CONSOLE:
actions	:	T{
.na
run the stream file,
try to watch the process??
.ad
T}
.TE
.H 2 "Checkread mode"
With these tests the checkread option of BACKUP gets approved.
This option is independent of the file system the files to be backed up
are on.
.H 3 "Bkp.4.1"
Test this option for all possible types of output medias.
Make a full backup of a LIF volume in checkread mode.
.TS
expand;
l l lw(4.8i).
output media	:	different tapes/mini/micro floppies
stream file	:	SBkp4.1
log file	:	CONSOLE:
actions	:	T{
.na
run the stream file,
try to watch the process??
.ad
T}
.TE
.H 3 "Bkp.4.2"
Take known bad tapes/floppies and do the same test as in Bkp.4.1.
.TS
expand;
l l lw(4.8i).
output media	:	bad cartridge tapes/floppies
stream file	:	SBkp4.2
log file	:	CONSOLE:
actions	:	T{
.na
run the stream file,
try to watch the process??
.ad
T}
.TE
