.H 1 "Restore"
.H 2 "Create needed backups"
There are a total of six different backups needed to do the tests in this
area.
Here is a description of them:
.AL A
.LI
Backup LIF volume TSTBKP onto a tape.
Use full backup mode and label your tape with 'A'.
.LI
Make a relative backup of the SRM directory STSTBKP.
Prefix to /STSTBKP and than do a full backup of '=' (or '.') to a tape.
Label the tape with 'B'.
.LI
Make an absolute backup of the SRM directory /STSTBKP.
Prefix to /STSTBKP and than do a full backup of '/STSTBKP' to a tape.
Label the tape with 'C'.
.LI
Make a relative backup of the HFS directory HTSTBKP.
Prefix to /HTSTBKP and than do a full backup of '=' (or '.') to a tape.
Label the tape with 'D'.
.LI
Make an absolute backup of the HFS directory /HTSTBKP.
Prefix to /HTSTBKP and than do a full backup of '/HTSTBKP' to a tape.
Label the tape with 'E'.
.LI
Make a multi volume backup of a LIF volume, a SRM and an HFS directory.
Set the unit for the HFS volume to /HTSTBKP and to /STSTBKP for SRM.
Back up TSTBKP:, HTSTBKP relative and STSTBKP relative.
Label the tape with 'F'.
.LE
.H 2 "Automatic restore"
This part tests automatic restores.
The four tests described here differ only in the tape the restore is made
from.
All the other steps are identical.
Here is a description of an automatic restore:
.DL
.LI
insert the appropriate media and wait until it is ready.
.LI
invoke BACKUP
.LI
press 'R' for restore.
.LI
type in the name of the source medium
.LI
press Return (no unconditional restore)
.LI
press 'N', no rename mode
.LI
press Return (no resynchronize)
.LI
press Return (restore all files)
.LI
press 'Y' (proceed)
.LE
.P
Before running the following tests make sure that you have got a backup of 
the directories /STSTBKP, /HTSTBKP and TSTBKP: or that you have a copy
of them in other directories.
.H 3 "Rest.1.1"
Test restore to a LIF volume.
.P
Take the backup tape labeled 'A' and do an automatic restore.
.H 3 "Rest.1.2"
Test restore to a SRM volume.
.P
Set the unit on the SRM volume to /STSTBKP
Take the backup tape labeled 'C' and do an automatic restore.
.H 3 "Rest.1.3"
Test restore to an HFS volume.
.P
Set the unit on the HFS volume to /HTSTBKP
Take the backup tape labeled 'E' and do an automatic restore.
.H 3 "Rest.1.4"
Test multi volume restores.
.P
Take the backup tape labeled 'F' and do an automatic restore.
.H 2 "Rename mode"
For this test BACKUP is done with the following user input:
.DL
.LI
insert the appropriate media and wait until it is ready.
.LI
invoke BACKUP.
.LI
press 'R' for restore.
.LI
type in the name of the source medium.
.LI
press Return (no unconditionally restore).
.LI
press Return for rename mode.
.LI
press Return (no resynchronize)
.LI
press Return (restore all files).
.LI
press 'Y' (proceed).
.LE
.P
In this mode the user is asked for a destination volume or directory
each time a new volume is encountered.
This must be input according to the test case that is done.
The test person has to keep track of the directories in which Restore
puts the filess.
It is best to clean up those directories before each test.
.H 3 "Rest.2.1"
Test restore a LIF backup to another LIF volume.
The source and destination volumes must be different.
.P
Take the backup tape labeled 'A' and restore it to a LIF volume.
.H 3 "Rest.2.2"
Test restore a LIF backup to a relative SRM volume.
.P
Take the backup tape labeled 'A' and restore it to a SRM volume.
The name of the SRM volume must be given relative, for example '.', 'tst'
or '#5:'.
.H 3 "Rest.2.3"
Test restore a LIF backup to an absolute SRM volume.
.P
Take the backup tape labeled 'A' and restore it to an SRM volume.
The name of the SRM volume must be given absolute, for example '/', '/tst'
or '#5:/'.
.H 3 "Rest.2.4"
Test restore a LIF backup to a relative HFS volume.
.P
Take the backup tape labeled 'A' and restore it to an HFS volume.
The name of the HFS volume must be given relative, for example '.', 'tst'
or '#5:'.
.H 3 "Rest.2.5"
Test restore a LIF backup to an absolute HFS volume.
.P
Take the backup tape labeled 'A' and restore it to an HFS volume.
The name of the HFS volume must be given absolute, for example '/', '/tst'
or '#5:/'.
.H 3 "Rest.2.6"
Test restore a relative SRM backup to a LIF volume.
.P
Take the backup labeled 'B' and restore it to a LIF volume.
.H 3 "Rest.2.7"
Test restore a relative SRM backup to a relative HFS volume.
.P
Take the backup tape labeled 'B' and restore to an HFS volume.
The name of the HFS volume must be given relative, for example '.', 'tst'
or '#5:'.
.H 3 "Rest.2.8"
Test restore a relative SRM backup to an absolute HFS volume.
.P
Take the backup tape labeled 'B' and restore to an HFS volume.
The name of the HFS volume must be given absolute, for example '/', '/tst'
or '#5:/'.
.H 3 "Rest.2.9"
Test restore an absolute SRM backup to a relative HFS volume.
.P
Take the backup tape labeled 'C' and restore to an HFS volume.
The name of the HFS volume must be given relative, for example '.', 'tst'
or '#5:'.
.H 3 "Rest.2.10"
Test restore a relative HFS backup to a LIF volume.
.P
Take the backup labeled 'D' and restore it to a LIF volume.
.H 3 "Rest.2.11"
Test restore an absolute HFS backup to a LIF volume.
.P
Take the backup labeled 'E' and restore it to a LIF volume.
.H 3 "Rest.2.12"
Test restore a relative HFS backup to a relative SRM volume.
.P
Take the backup tape labeled 'D' and restore to an SRM volume.
The name of the SRM volume must be given relative, for example '.', 'tst'
or '#5:'.
.H 3 "Rest.2.13"
Test restore a relative HFS backup to an absolute SRM volume.
.P
Take the backup tape labeled 'D' and restore to an SRM volume.
The name of the SRM volume must be given absolute, for example '/', '/tst'
or '#5:/'.
.H 3 "Rest.2.14"
Test restore an absolute HFS backup to an absolute SRM volume.
.P
Take the backup tape labeled 'E' and restore to an SRM volume.
The name of the SRM volume must be given absolute, for example '/', '/tst'
or '#5:/'.
.H 2 "Unconditional restore"
For this test it is important to have somefiles in the directory/volume the
restore is made to.
If there are no files left this mode is not proven with the following test.
.H 3 "Rest.3.1"
Test restore unconditionally all kinds of files .
.P
Take the backup tape labeled 'F' and do an unconditional
automatic restore.
The steps required are identical to Rest.1.4, except that unconditional
restore is chosen.
.H 2 "Selective restore"
In this mode not all files from a backup tape are restored.
The files which are to be restored are explicitly named.
The question 'Files to restore' is answered with one or more file names
or patterns.
.H 3 "Rest.4.1"
Test selective restore in automatic mode.
.P
Take the backup tape labeled 'F' and do an automatic restore
but don't restore all files.
For example restore only '=.TEXT', 'TST:=' and '=A.ASC'.
.H 3 "Rest.4.2"
Test selective restore in rename mode.
.P
Take the backup tape labeled 'F' and do restore in rename mode
but don't restore all files.
For example restore only '=.TEXT', 'TST:=' and '=A.ASC'.
.H 2 "Redirect listing"
This test is similar to Rest.1.4 with the addition of redirecting the output
device for the listing.
The name of the output device for the listing can be specified together with
the name of the source medium.
This is similar to a FILER listing.
For example '#3:,PRINTER:' or '#41:,listfile'.
.P
For this group of tests the same is true af for the eqquivalent tests in 
backup.
If the previous tests used the redirect feature only Rest.5.1 and Rest.5.5
have to be performed.
If not Rest.5.1, Rest.5.2, Rest.5.3 and Rest.5.4 must be done.
.H 3 "Rest.5.1"
Redirect the listing to the PRINTER:
.H 3 "Rest.5.2"
Redirect the listing to a LIF file.
.H 3 "Rest.5.3"
Redirect the listing to a SRM file.
.H 3 "Rest.5.4"
Redirect the listing to an HFS file.
.H 3 "Rest.5.5"
.H 2 "Restore from HP-UX"
The first step for this tests is to do a relative backup on HP-UX.
For example 'find . -print | cpio -ovc | tcio -ov /dev/rct'.
Remark the '-c' option has to be used with cpio, because otherwise the
PAWS BACKUP utility can't restore it.
Don't use the rename mode of the BACKUP utility during restore.
.H 3 "Rest.6.1"
Restore a backup made on HP-UX to a LIF volume.
.H 3 "Rest.6.2"
Restore a backup made on HP-UX to a SRM volume.
.H 3 "Rest.6.3"
Restore a backup made on HP-UX to an HFS volume.
.H 2 "Restore to HP-UX"
.H 3 "Rest.7.1"
Restore a multi volume backup made on PAWS to HP-UX.
.P
Take the backup tape labeled 'F' onto HP-UX.
For example 'tcio -iv /dev/rct | cpio -ivcd '.
.H 2 "Restore in resynchronize mode"
Do a restore in resynchronizing mode and rename mode.
.H 3 "Rest.8.1"
Insert the second tape first and watch what happens.
.H 3 "Rest.8.2"
Restore a partly bad tape.
For this test the easiest thing to do is, take a backup and
overwrite the beginning of it (on HP-UX).
Then try to restore it to PAWS.
