
.H 1 "Intentionally Corrupted File Systems"
.P
We will have a series of 
tests where we create corrupted file systems, then
fix them with HFSCK.
The corruption will be done with FSDB.
.P
The tester will do the following:
.AL 1
.LI
Attach local disk and do a MKHFS to create an empty HFS
file system.  Run TABLE to get disk recognized as HFS.
.LI
Create the following standard file system on the disk:
.DS
	file name -- inumber -- size in bytes
	indentation shows structure

	/ -- 2
		file1 -- 4 -- 1536
		dir1 -- 64 
			file2 -- 65 -- 10752
			fifo1.ux -- 66 -- 0 
			dir2 -- 67
				file3 -- 68 -- 102912
				file4 -- 4 -- 1536
.DE
.P
"fifo1.ux" is created as a regular file, but is turned into a
fifo later.
.P
Note that "file4" is a link to "file1".
.P
The files and directories can be created automatically by the
following script:
.DS
	    fp/
	    mffile1[2]
	    mddir1
	    pdir1
	    mffile2[20]
	    mffifo1.ux
	    mddir2
	    pdir2
	    mffile3[2000]
	    dd/file1
	    file4
	    q
.DE
The inumbers are given to show the links.  The actual
inumbers are irrelevant, but the ones listed above are
assumed in the following discussion.
.LI
Corrupt the file system in the manner specified below.
.LI
Run HFSCK to repair the problem.
.LI
Run HFSCK again to verify that the problem is gone.
.LE
.SP
The tester should choose the mode
("ask always" or "normal confirmation") 
as indicated below.
.P
Some tests, marked with * below, corrupt the file system
in such a way that HFSCK will not restore it to its original state.
Therefore, after one of these tests, the tester must
reconstruct the file system in the same way he originally
constructed it.
.P 
Here are the tests, followed
by the HFSCK mode, then the expected action of HFSCK:
.P
cfs1: Change "fifo1" to a fifo, and set writer count to 1.
HFSCK (ask always) changes writer count to 0.
.P
cfs2: Change block count in "file1" to 3.  HFSCK (normal confirmation)
corrects block count.
.P
cfs3: Write disk address 200 in the third direct address of
the inode of "file2".  This is inconsistent with the inode
size, which requires only two disk addresses.  HFSCK (ask
always) zeroes the third address.
.P
cfs4: Change first indirect address of inode 10 (not allocated)
to 2.  HFSCK (normal confirmation) clears unreferenced
pipe.
.P
cfs5: Change third direct address of inode 10 (not allocated)
to 200.  HFSCK (ask always) clears partially allocated
inode.
.P
cfs6: Change inumber for '.' in directory "dir1" to 67.
HFSCK (normal confirmation) corrects inumber.
.P
cfs7: Change the mode of unallocated inode 10 to 0100644.
HFSCK (normal confirmation) clears the file.
.P
cfs8: Change free inode count in superblock to 100.
HFSCK (ask always) corrects it.
.P
cfs9: Corrupt bit map in cylinder group by writing a 15 to
the first byte in the bitmap that isn't 15.
HFSCK (normal confirmation) rebuilds the free map.
.P
cfs10: Corrupt csumm info in cylinder group 0 by changing the
free block count to 0.  HFSCK (ask always) corrects the
bad cylinder group.
.P
cfs11: Change link count of "file1" to 5, too high.  HFSCK (normal
confirmation) corrects it.
.P
cfs12: Change link count of "file1" to 1, too low.  HFSCK
(ask always) corrects the bad link count.
.P
cfs13: Zero the superblock.  HFSCK (use alternate superblock
at block 16) reconstructs it.
.P
*cfs14: Point two files to the same disk block by changing the first
block of "file2" to be the same as the first block of "file4".
HFSCK (normal confirmation) clears both files.
.P
*cfs15: Change first address of "file2" to 5000000, beyond the end
of the file system.  HFSCK (ask always) removes DUP/BAD file.
.P
*cfs16: Change address of indirect block of "file3" to the
address of the first data block of "file2".  HFSCK (normal
confirmation) clears DUP/BAD files.
.P
*cfs17: Change size of directory "dir2" to zero.  HFSCK (ask
always) clears file of unknown type.
.P
*cfs18: Make extra '..' entry in directory "dir1" by changing
the name of the entry for "fifo1.ux".  HFSCK
(ask always) removes it.
.P
*cfs19: Change inumber of "fifo1.ux" in directory "dir1" to
3000000, impossibly large.  HFSCK (normal confirmation)
removes the entry.
.P
*cfs20: Change inumber of "fifo1.ux" in directory "dir1" to
10, an unallocated inode.  HFSCK (normal confirmation) 
removes the directory entry.
.P
*cfs21: Disconnect directory from tree by changing inumber of
"dir2" entry in directory "dir1" to 10.  HFSCK (ask always)
reconnects the lost directory.
