			    TESTING HFSDAM
			    Hal Prince
			    Sept. 1, 1986


ABSTRACT

	This document describes how to test HFSDAM.  By HFSDAM we
mean the DAM itself, as well as the allocator, cache, and support
routines.

	We describe these tests:

	    TRECORD 	test Pascal record layout
	    TCALC 	test low-level calculation routines
	    TCACHE 	test cacher
	    TLOW 	test low-level HFS services
	    TTYPE 	test different file types
	    TDAM 	test DAM calls and error conditions
	    TSTREAM 	test FILER's use of DAM	

REGULAR USE

	HFSDAM will be used extensively in Boeblingen.

	  -System turns are done under HFS.
	  -All developers (OSINSTALL, BACKUP) use HFS.
	  -Documentation will use HFS.
	  -PAWS support will use HFS.

	Since large portions of the code are being shared with BASIC in
Fort Collins, there will also be a lot of regular use by them.


TRECORD -- TESTING PASCAL HFS RECORDS

	TRECORD is a program that compares Pascal records and C structures
for:

		inodes
		directories
		cylinder groups
		superblocks

It is written partly in C, and partly in Pascal.  For each of the
four structure types, there is both a C and a Pascal routine.  Each
routine fills an array of integers with the size of the structure, then the
offset of each member, then a -1.  The C routine gets its structure
definition from the HP-UX header files.  The Pascal routine gets its
structure definition from the HFSDAM header files.  The main program, in 
Pascal, simply calls the C and Pascal routines for each structure type, 
then compares the results.

	The goal of this test is to ensure that there is an EXACT match
between the structures used by HP-UX and those used by PAWS.

	This test needs to be run only once for each HFSDAM version.


TCALC -- TESTING HFS CALCULATION ROUTINES

	TCALC will test the module "hfscalc".  It is partly in C, and
partly in Pascal.  "Hfscalc" is a Pascal implementation of many small
C macros.  The C part of TCALC will consist of routines that implement
the macros.  For example, the C routine "Ccgtod" will implement the macro
"cgtod".

	The job of TCALC will be to call each of the hfscalc routines,
and check the result either by calling the corresponding C routine, or, 
if possible, by checking the result directly.

	The steps of TCALC follow.  "Sbp" is assumed to be a pointer
to a superblock.

	1.  Test min, max

		min(1,2) = 1
		max(1,2) = 2


	2.  Test howmany

		howmany(15,5) = 3
		howmany(16,5) = 4
		howmany(15,7) = 3
		howmany(15,8) = 2
		howmany(15,1) = 15 


	3.  Test roundup

		roundup(15,5) = 15
		roundup(16,5) = 20
		roundup(15,4) = 16
		roundup(15,8) = 16
		roundup(15,1) = 15


	4.  Test rounddownp2

		rounddownp2(15,4) = 12
		rounddownp2(16,4) = 16
		rounddownp2(13,4) = 12
		rounddownp2(15,8) = 8
		rounddownp2(15,2) = 14


	5.  Test freespace.  We set dsize and fragshift as shown.
	Then we try each nbfree/nffree combination, and check
	that the resulting freespace is as indicated.

		sbp^.dsize := 1000;
		sbp^.fragshift := 3;

		nbfree		nffree		freespace(sbp,10)
		~~~~~~		~~~~~~		~~~~~~~~~~~~~~~~~
		0		0		-100
		100		100		800
		50		50		350
		50		500		800
		10		20		0


	6.  Test bitmap manipulation.  Take 2 arrays of 50 integers.
	One is for the Pascal bit routines, the other for the C routines.
	Zero them.  Then calculate 800 random numbers between 0
	and 1599 inclusive, and call setbit and Csetbit to
	set those bits in the two arrays.  Do the same with clrbit
	and Cclrbit.  Then compare the arrays by ensuring that
	isset and Cisset give the same results.  Do the same with
	isclr and Cisclr.  Do the same with blkmap and Cblkmap.


	7.  Test btodb.  Generate 100 random numbers, and check
	that

		btodb(randnum) = randnum div DEV_BSIZE


	8.  Test fragstoblks, blkstofrags, and fragstobytes.  
	Generate 100 random numbers, and check that

		fragstoblks(sbp, randnum) = randnum div sbp^.frag
		blkstofrags(sbp, randnum) = randnum * sbp^.frag
		fragstobytes(sbp, randnum) = randnum * sbp^.fsize


	9.  Test cylinder arithmetic.  Generate 100 random
	numbers, and check that

		cgtod(sbp, randnum) = Ccgtod(sbp, randnum)
		dtog(sbp, randnum) = Cdtog(sbp, randnum)
		dtogd(sbp, randnum) = Cdtogd(sbp, randnum)
		cbtocylno(sbp, randnum) = Ccbtocylno(sbp, randnum)
		cbtorpos(sbp, randnum) = Ccbtorpos(sbp, randnum)
		itog(sbp, randnum) = Citog(sbp, randnum)


	10.  Test nspb, nspf, and maxbpc.

		nspb(sbp) = sbp^.bsize div DEV_BSIZE
		nspf(sbp) = sbp^.fsize div DEV_BSIZE
		maxbpc + sizeof(sbp^) = SBSIZE


	11.  Test fs_cs.  Assign to the ith element of sbp^.csp
	the expression

		addr(sbp^, 8*1024*i)	

	Then check that, for each cylinder group,

		fs_cs(sbp, cg) = Cfs_cs(sbp, cg)


	12.  Test offset calculations.  Generate 100 random numbers,
	then check that

		blkoff(sbp, randnum) = randnum mod sbp^.bsize
		fragoff(sbp, randnum) = randnum mod sbp^.fsize
		lblkno(sbp, randnum) = randnum div sbp^.bsize
		numfrags(sbp, randnum) = randnum div sbp^.fsize
		fragroundup(sbp, randnum) = roundup(randnum, sbp^.fsize)
		

	13.  Test the start routines.

		for each inode number
		    inode_start(...) = Cinode_start(...)

		for each fragment number
		    data_start(...) = Cdata_start(...)

		for each cylinder group number
		    cgroup_start(...) = Ccgroup_start(...)
		    super_start(...) = Csuper_start(...)


TCACHE -- TEST HFS CACHER

	TCACHE exercises the HFS cacher under controlled circumstances.
It requires a disk for testing.  It also requires that HFS be installed
in INITLIB in its unlinked state, with all its external symbols still
visible.

	TCACHE has the following parts:

	1.  Test disk accessing.  For each of these items

		cylinder group
		inode
		datablk

	do a get_* (* is cgroup, inode, or datablk) of every instance
	of this item on the disk.  Do a put_*(item, [release]) right
	after each get.


	2.  Test cache buffer management.  There is one test per item
	type above (not superblock).  The test goes as follows:

	    a) Get item numbers 0, 1, 2, etc. until the cache is
	    full.  Save the buffer ptrs in an array bufarray[0..numitems].
	    Initialize an array count[0..numitems] with 1.  The array keeps 
	    track of the use count on each buffer.  Initialize another
	    array itemnum[0..numitems] with 0..numitems.  This keeps
	    track of which item is in the bufarray.

	    b) Repeatedly generate random numbers between 0 and
	    numitems.  Then decide randomly whether to get or
	    put the item at that bufarray location, as follows:

			if count[randnum] = 0 then
			    bufarray[randnum] := get_*(new_randnum)
			    itemnum[randnum] := new_randnum
			    count[randnum] := 1
			else
			randomly do either
			    get_*(randnum)
			    ++count[randnum]
			or
			    put_*(bufarray[randnum])
			    --count[randnum] 

	    This causes a lot of random puts and gets, meanwhile
	    keeping track of exactly which pointers are valid.

	    After 1000 repetitions, go through and drop the valid
	    buffers as follows:

		for i := 0 to numitems do
		    for j := 1 to count[i] do
			put_*(bufarray[i])

	    Then call check_cache to be sure all use counts are 0.


TLOW -- CHECK LOW-LEVEL HFS SERVICES

	TLOW will check that a number of HFS services work properly.
We concentrate on the services that are sometimes difficult to check
with higher-level tests.

	Here are the parts of the test.

	1.  Corrupt the file system so that HFS recognizes the corruption.
	Be sure HFS allows reads, but not writes.  Ask the user
	to run HFSCK, then create a new file. This will work only
	if HFSCK has informed the DAM (via h_unitable) that the
	file system is no longer corrupt.

	How to corrupt it: 
		-make a file of size 512 bytes
		-get the inode for the file
		-set inode.db[0] to fs^.size
		-remove the file

	2.  Be sure that HFS can read from a write-protected disk.

	3.  Test growing a directory when it fills up a fragment
	cluster.  Set up floppy so that there is at least one
	cluster of each cluster size free (1..7 fragments).  
	Make a directory, then grow it until it is 8K big (has 254 
	entries, plus . and ..).  This causes an automatic copy of the
	directory each time it crosses a 1K boundary (every 32
	directory entries).  After each boundary crossing, do a catalog 
	of the dir.

	4.  Test growing a file when it fills up a fragment cluster.
	Set up a floppy as in (3), then grow the file with get_dbnum
	1K at a time.  The call to do this is:

		get_dbnum(ip, pos, B_WRITE, 1024)

	where ip is the inode address, and pos is the size of the
	file so far.  This routine returns a disk address of the
	next 1K segment.  This will cause a copy with each get_dbnum
	call.  After each call, write recognizeable data in the
	new fragment, then read the entire file to be sure the
	contents are OK.

	5.  Check time stamping.  Read a file, then check that only the 
	access time is changed.  Write a file, then check that only the 
	mod and ichg time are changed.  Chmod the file, then check that
	only the ichg time is changed.

	6.  Check preallocation.  On a floppy, note the number of
	full blocks left.  Call this number X.  Try to make a file with
	X, and X+1 blocks, and ensure that X succeeds,
	but X+1 fails.  Find the largest cluster of free fragments.
	Call this number Y.
	Try to make a file of X blocks plus Y frags (should succeed),
	then X blocks + (Y+1) frags (should fail).


	7.  Check holes.  Create a sparse file by doing the following:
	
		-open the file
		-seek to byte 1,000,000 (counting from 1)
		-write a byte
		-close the file
		
	Then read it back.  The first non-zero char should be
	at 1,000,000.  Now open it, and write a byte at 500,000,
	and close it.  Read it back again.  Do this on a floppy,
	where the file system could not hold a non-sparse file
	so big.

	8.  Test changing a file's size.  Write a 100,000-byte file with 
	recognizable
	data -- 1000 1's, 1000 2's, etc.  Do an open, then a seek,
	then a close(..., 'crunch') to cut the file back to each
	multiple of 1000 bytes down to 0.  Read the file each time
	to be sure it's still OK.  Now grow it in the opposite
	direction back up to 100000 again.

	9.  Make a directory and put 2,000 empty files in it.  Name
	them F1, F2, etc.  Do a catalog of the directory.  Remove
	all the files, then remove the directory.

	10.  Check permissions.  For each permission (read and write), there
	are 8 combinations, and 4 different classes that the
	user can be in, resulting in 64 different cases.  Try
	them all.

	11.  Test anonymous files.  Create one.  Write to it.  Reset it.
	Read it.  Close it.

	12.  Test temporary files.  Create a file.  Write to it, then close 
	it 'save'.  Rewrite the same file.  Write to it.  Close it 'normal'.  
	Verify that the file was not really rewritten.


TTYPE -- TEST DIFFERENT FILE TYPES

	TTYPE is a program that tests the different file types.  It
also happens to test UXTEXTAM.  It writes a textfib file with
10,000 lines, with the length varying between 0 and 200 characters.
It then translates the file, using readln and writeln, to another
file format.  It then reads both files and compares the contents.

	The formats tested are:

		TEXT
		ASCII
		data
		UX

For each format, the program generates a file in that format, then
translates and checks with the remaining three.  The contents of
the file can be random.


TDAM -- CHECK DAM CALLS

	TDAM is a Pascal program that exercises every DAM call.  It
makes both legal and illegal calls.  The goal here is call the DAM
with as many different sorts of parameters as possible, and to be sure 
that it responds correctly, even in cases where the request was
intentionally illegal.  

	For part of the test, TDAM will work on both an HFS and a LIF
or SRM volume, so that it can check the differences between the
different file systems.

	Here is a description of the tests for each DAM call.  The
program calls the DAM in each of the conditions listed, and ensures
that the noted ioresult is set.

	1.  lockfile, unlockfile.  HFSDAM should set ibadrequest.

	2.  getvolumedate, setvolumedate.  HFSDAM should set ibadrequest.
	
	3.  crunch.  HFSDAM returns no error, but does nothing.

	4.  createfile. 
	a) normal case -- no error.
	b) no write permission for parent directory -- inopermission
	c) no write permission for file -- inopermission
	d) 14-char file name -- no error
	e) 15-char file name -- ibadtitle
	f) file name containing #0 -- ibadtitle
	g) file name containing '/' -- ibadtitle
	h) file name '/a/b/c', but 'b' doesn't exist -- inofile

	5.  openfile
	a) normal case -- no error
	b) no read or write permission -- inopermission
	c) read permission, but not write permission -- no error
		1) read this file -- no error
		2) write this file -- inopermission
	d) write permission, but not read permission -- no error
		1) write this file -- no error
		2) read this file -- inopermission
	e) file not present -- inofile
	f) 15-char file name -- ibadtitle
	g) file is directory -- inotondir
	h) file is block/char special -- no error
		read or write this file -- inoaccess
	i) all other file types -- no error

	6.  overwritefile
	a) normal case -- no error
	b) file not there -- same as createfile
	c) no write permission -- inopermission	
	d) file is dir -- inotondir
	e) file is block/char special -- inoaccess  
	f) all other file types -- no error

	7.  closefile
	a) normal case -- no error
	b) file not open -- inotopen
	c) file is dir -- inotondir

	8.  purgefile
	a) normal case -- no error
	b) file is / -- inotclosed
	c) file is prefix -- inotclosed
	d) file is newly created (e.g., rewrite(f, 'foo');
	   close(f, 'purge');) -- no error	

	9.  purgename
	a) normal case -- no error
	b) file not there -- inofile
	c) no write permission on parent directory -- inopermission
	d) file is an empty directory -- no error
	e) file is a directory with 1 file -- inotempty
	f) file is a prefix dir -- inotclosed

	10.  stretchit
	a) normal case -- no error
	b) all file types stretchable except block/char, which bring
	   inoaccess
	c) file type is char/block -- inoaccess
	d) all other file types -- no error
	e) file system has 1 frag free, try to stretch 1 frag -- no error

	11.  changename
	a) normal case -- no error
	b) old file not there -- inofile
	c) new file already there -- idupfile
	d) no write perm in dir -- inopermission
	e) any kind of file -- no error
	f) file is prefix dir -- inotclosed
	g) 15-char file name -- ibadtitle

	12.  getvolumename, setvolumename
	a) set a 4-char name, then get it back -- no error
	b) set a 6-char name, then get it back -- no error
	c) turn off or pop out disk -- set shows error,
	   but get shows no error (returns '' as name)
	d) name > 6 chars -- ibadtitle 

	13.  duplicatelink
	a) normal case -- no error
	b) old file not there -- inofile
	c) new file there -- idupfile
	d) no write perm in dir -- inopermission
	e) file is dir -- inotondir
	f) any other kind of file -- no error
	g) 15-char name -- ibadtitle

	14.  stripname, catpasswords, setpasswords
	Test plans for these DAM calls will come from Angelika.

	15.  opendirectory, openparentdir
	a) normal case -- no error
	b) no x permission -- inopermission
	c) file not dir -- opens parent
	d) file not there -- opens parent

	16.  catalog
	a) normal case -- no error
	b) no read permission on dir -- inopermission
	c) set index too high -- no error, but get back no files

	17.  closedirectory.  no errors.

	18.  openvolume/openunit
	a) no errors.
	b) do TM access afterwards -- no error
	c) close fib with closefile -- no error

	19.  makedirectory
	a) normal case -- no error
	b) no write permission in parent -- inopermission
	c) name exists -- idupfile
	d) 15-char file name -- ibadtitle

	20.  setunitprefix
	a) normal case -- no error
	b) no x permission on dir -- inopermission
	c) file not there -- inofile
	d) file not dir -- ifilenotdir


TSTREAM -- A TEST STREAM FILE

	TSTREAM is a stream file that uses the FILER to perform
various operations on an empty HFS disk.  This stream file
creates files, deletes them, copies them, and in general exercises
every feature of the FILER that causes HFSDAM to be called.

	The goal of TSTREAM is to be sure HFSDAM can cope with
DAM calls from an existing program.  The FILER is a good test case,
not only because it already exists, but also because it makes several
DAM calls for each operation, and has very definite ideas about what
should come back from the DAM.

	TSTREAM will run on a scratch HFS file system set up as follows:

	/
	    SYSTEM_P
	    lost+found
	    WORKSTATIONS
		SYSTEM
		    INITLIB
		    TABLE
		    STARTUP
		    FILER
		    ASSEMBLER
		    COMPILER
		    EDITOR
		    LIBRARIAN
		    LIBRARY

There are two units: #11, the system volume, at /WORKSTATIONS/SYSTEM,
and #12, the default volume, at /.

	The steps taken by the test are:

	1.  Create the following directory and files under /.

	    FILES
		DAT0.UX	[0]	
		DAT1K   [1]
		DAT10K	[19]
		DAT100K [199]
		DAT1M   [2047]
		TXT0.TEXT
		TXT1K.TEXT
		TXT10K.TEXT
		TXT100K.TEXT
		TXT1M.TEXT

The DAT file sizes are given to the filer as indicated by the brackets.
The TXT files are generated with the editor.

	2.  Test directory creation at one level:

		p/
		mdDIR1
		md/DIR2
		pDIR2
		md../DIR3
		p..
		md#12:DIR4
		pDIR4
		md#12:../DIR5
		md#12:/DIR6

	3.  Test multi-level directory creation:

		p/
		mdLEV1
		md/LEV1/LEV2
		pLEV1
		md/LEV1/LEV2/LEV3
		md../LEV1/LEV2/LEV3/LEV4
		u#12:LEV2/LEV3
		md../LEV3A
		md#12:../LEV3B
		p..
		p..
		mdLEV2A

	4.  Test copying and removing files.

		u#12:/DIR1
		f*=, $
		r=
		fFILES/=,$
		r=

	5.  Test listing.

		l*
		e*/..
		l/FILES
		e#12:
		l/D=

	6.  Test changing names of files and directories.

		c/FILES/DAT=,dat=
		p/FILES
		cdat=,DAT=
		c#12:,foo12:
		c/DIR=,DR=
		c/DR=,DIR=

	7.  Test translating files.

		p/DIR1
		t/FILES/TXT=.TEXT,TXT=
		tTXT=,TXT=.UX
		tTXT=.UX,TXT=.ASC
		tTXT=.ASC,TXT=.TEXT

	8.  Test linking.

		r=
		dd/FILES/=,$
		dd=,/DIR1/$

	9.  Test moving.

		dm/DIR1/=,/DIR2/$

	10.  Test Krunch, then clean up everything.

		k
		p/LEV1/LEV2/LEV3
		r=
		p..
		r=
		p..
		r=
		p..
		rDIR1/=
		rDIR2/=
		rDIR=
		rFILES/=
		rFILES


	Note that TSTREAM does not exercise the HFS Access command
in the FILER.  A test for this command is being developed separately
as part of the testing of new FILER features.


WRITING THE TESTS

	Here is the estimated time to write each test:

	    TRECORD		done
	    TCALC		done
	    TCACHE		1 day
	    TLOW		3 days
	    TTYPE		1 day
	    TDAM		6 days
	    TSTREAM		1 day
				~~~~~~
	    total		12 days


RUNNING THE TESTS

	
