.H 1 "TCACHE -- Test HFS Cacher"
.P
TCACHE exercises the HFS cacher under controlled circumstances.
It requires a disk for testing.  It also requires that HFS be installed
in INITLIB in its unlinked state, with all its external symbols still
visible.
.P
TCACHE has the following parts:
.AL
.LI
Test disk accessing.  For each of these items
.BL
.LI
cylinder group
.LI
inode
.LI
datablk
.LE
.SP
do a get_* (* is cgroup, inode, or datablk) of every instance
of this item on the disk.  Do a put_*(item, [release]) right
after each get.
.LI
Test cache buffer management.  There is one test per item
type above (not superblock).  The test goes as follows:
.AL a
.LI
Get item numbers 0, 1, 2, etc. until the cache is
full.  Save the buffer ptrs in an array bufarray[0..numitems].
Initialize an array count[0..numitems] with 1.  The array keeps 
track of the use count on each buffer.  Initialize another
array itemnum[0..numitems] with 0..numitems.  This keeps
track of which item is in the bufarray.
.LI
Repeatedly generate random numbers between 0 and
numitems.  Then decide randomly whether to get or
put the item at that bufarray location, as follows:
.SP
.nf
	if count[randnum] = 0 then
	    bufarray[randnum] := get_*(new_randnum)
	    itemnum[randnum] := new_randnum
	    count[randnum] := 1
	else
	randomly do either
	    get_*(randnum)
	    ++count[randnum]
	or
	    put_*(bufarray[randnum])
	    --count[randnum] 
.fi
.SP
This causes a lot of random puts and gets, meanwhile
keeping track of exactly which pointers are valid.
.P
After 1000 repetitions, go through and drop the valid
buffers as follows:
.SP
.nf
	for i := 0 to numitems do
	    for j := 1 to count[i] do
		put_*(bufarray[i])
.fi
.SP
Then call check_cache to be sure all use counts are 0.
.LE
.LE

