.H 1 "TLOW -- Check Low-Level HFS Services"
.P
TLOW will check that a number of HFS services work properly.
We concentrate on the services that are sometimes difficult to check
with higher-level tests.
.P
Here are the parts of the test.
.AL
.LI
Corrupt the file system so that HFS recognizes the corruption.
Be sure HFS allows reads, but not writes.  Ask the user
to run HFSCK, then create a new file. This will work only
if HFSCK has informed the DAM (via h_unitable) that the
file system is no longer corrupt.
.P
How to corrupt it: 
.BL
.LI
make a file of size 512 bytes
.LI
get the inode for the file
.LI
set inode.db[0] to fs^.size
.LI
remove the file
.LE
.LI
Be sure that HFS can read from a write-protected disk.
.LI
Test growing a directory when it fills up a fragment
cluster.  Set up floppy so that there is at least one
cluster of each cluster size free (1..7 fragments).  
Make a directory, then grow it until it is 8K big (has 254 
entries, plus . and ..).  This causes an automatic copy of the
directory each time it crosses a 1K boundary (every 32
directory entries).  After each boundary crossing, do a catalog 
of the dir.
.LI
Test growing a file when it fills up a fragment cluster.
Set up a floppy as in (3), then grow the file with get_dbnum
1K at a time.  The call to do this is:
.SP
.nf
		get_dbnum(ip, pos, B_WRITE, 1024)
.fi
.SP
where ip is the inode address, and pos is the size of the
file so far.  This routine returns a disk address of the
next 1K segment.  This will cause a copy with each get_dbnum
call.  After each call, write recognizeable data in the
new fragment, then read the entire file to be sure the
contents are OK.
.LI
Check time stamping.  Read a file, then check that only the 
access time is changed.  Write a file, then check that only the 
mod and ichg time are changed.  Chmod the file, then check that
only the ichg time is changed.
.LI
Check preallocation.  On a floppy, note the number of
full blocks left.  Call this number X.  Try to make a file with
X, and X+1 blocks, and ensure that X succeeds,
but X+1 fails.  Find the largest cluster of free fragments.
Call this number Y.
Try to make a file of X blocks plus Y frags (should succeed),
then X blocks + (Y+1) frags (should fail).
.LI
Check holes.  Create a sparse file by doing the following:
.BL	
.LI
open the file
.LI
seek to byte 1,000,000 (counting from 1)
.LI
write a byte
.LI
close the file
.LE	
.SP
Then read it back.  The first non-zero char should be
at 1,000,000.  Now open it, and write a byte at 500,000,
and close it.  Read it back again.  Do this on a floppy,
where the file system could not hold a non-sparse file
so big.
.LI
Test changing a file's size.  Write a 100,000-byte file with 
recognizable
data -- 1000 1's, 1000 2's, etc.  Do an open, then a seek,
then a close(..., 'crunch') to cut the file back to each
multiple of 1000 bytes down to 0.  Read the file each time
to be sure it's still OK.  Now grow it in the opposite
direction back up to 100000 again.
.LI
Make a directory and put 2,000 empty files in it.  Name
them F1, F2, etc.  Do a catalog of the directory.  Remove
all the files, then remove the directory.
.LI
Check permissions.  For each permission (read and write), there
are 8 combinations, and 4 different classes that the
user can be in, resulting in 64 different cases.  Try
them all.
.LI
Test anonymous files.  Create one.  Write to it.  Reset it.
Read it.  Close it.
.LI
Test temporary files.  Create a file.  Write to it, then close 
it 'save'.  Rewrite the same file.  Write to it.  Close it 'normal'.  
Verify that the file was not really rewritten.
.LE
