.H 1 "OSINSTALL"

These are the specific tests for the new OSINSTALL utility.
Doing these tests will also perform some tests
on the other utilities, like MKHFS.
As a double check a S300 HP-UX system should be used
to view the files.
.P
All stream test files for the OSINSTALL tests will begin with
"sosin".
There are 2 possible suffixes, a single letter is for stream files
that setup a particular environment for a test, the two level number
is for a particular test.
The first number represents a specific area and the second number
the sequence number.

.H 2 "Check Tests"

These tests are for the check command.
The level number is 1.

.H 3 "osin.1.1"
With a good LIF directory and all coresponding bootfiles in a.out
format see that check reports all ok.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.1.1
actions	:	T{
.na
Run the setup stream file first, then the test stream file.
The test stream file should run wihout any problems.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.1.2"
With a good LIF directory and at least one boot file not in a.out
format see that a problem is reported.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.b & sosin.1.2
actions	:	T{
.na
Run the setup stream file.
The test stream file should run wihout any problems.
See that the appropriate erro message from OSINSTALL is produced.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.1.3"
With a good LIF directory and at least one boot file missing
see that a problem is reported.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.c & sosin.1.3
actions	:	T{
.na
Run the setup stream file.
The test stream file should run wihout any problems.
See that the appropriate erro message from OSINSTALL is produced.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.1.4"
With a corrupt LIF directory and the boot files there
see that a problem is reported.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.c & corrupt & sosin.1.4
actions	:	T{
.na
Run the setup stream file.
The LIF directory will have to be corrupted by a special program or
from HP-UX.
The test stream file should run wihout any problems.
See that the appropriate erro message from OSINSTALL is produced.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE

.H 2 "Install Tests"

These tests check the ability to correctly install a boot file.
The level number is 2.

.H 3 "osin.2.1"
Install a file already in a.out format.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.2.1
actions	:	T{
.na
Run the setup stream file first, then the test stream file.
The test stream file should run wihout any problems.
Use the OSINSTALL Check command to check the results.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.2.2"
Install a file NOT in a.out format, but in .SYSTM format.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.2.2
actions	:	T{
.na
Run the setup stream file.
The test stream file should run wihout any problems.
Use the OSINSTALL Check command to check the results.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.2.3"
Install a file NOT in .SYSTEM or a.out format.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.2.3
actions	:	T{
.na
Run the setup stream file.
The test stream file should produce an error.
Use the OSINSTALL Check command to check that no changes were made.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.2.4"
Install a file that does not exist in the root directory.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.2.4
actions	:	T{
.na
Run the setup stream file.
The test stream file should produce an error.
Use the OSINSTALL Check command to check that no changes were made.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE

.H 2 "Order Tests"

These tests check the ability to move a LIF entry to the first
position in the directory.
The level number is 3.

.H 3 "osin.3.1"
Move the first entry. Try with a full directory also.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.3.1
actions	:	T{
.na
Run the setup stream file first, then the test stream file.
The test stream file should run wihout any problems.
Use the OSINSTALL Check command to check the results.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.3.2"
Move the last entry. Try with a full directory also.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.3.2
actions	:	T{
.na
Run the setup stream file first, then the test stream file.
The test stream file should run wihout any problems.
Use the OSINSTALL Check command to check the results.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.3.3"
Move a non-existing entry.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.3.3
actions	:	T{
.na
Run the setup stream file.
The test stream file should produce an error.
Use the OSINSTALL Check command to check that no changes were made.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.3.4"
Move a middle entry. Try with a full directory also.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.3.4
actions	:	T{
.na
Run the setup stream file first, then the test stream file.
The test stream file should run wihout any problems.
Use the OSINSTALL Check command to check the results.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE

.H 2 "Remove Tests"

These tests check the ability to remove a LIF directory entry.
The level number is 4.

.H 3 "osin.4.1"
Remove the first entry. Try with a full directory also.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.4.1
actions	:	T{
.na
Run the setup stream file first, then the test stream file.
The test stream file should run wihout any problems.
Use the OSINSTALL Check command to check the results.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.4.2"
Remove the last entry. Try with a full directory also.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.4.2
actions	:	T{
.na
Run the setup stream file first, then the test stream file.
The test stream file should run wihout any problems.
Use the OSINSTALL Check command to check the results.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.4.3"
Remove a non-existing entry.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.4.3
actions	:	T{
.na
Run the setup stream file.
The test stream file should produce an error.
Use the OSINSTALL Check command to check that no changes were made.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.4.4"
Remove all entries.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.4.4
actions	:	T{
.na
Run the setup stream file.
Use the OSINSTALL Check command to check that no changes were made.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.4.5"
Remove a middle entry. Try with a full directory also.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.4.5
actions	:	T{
.na
Run the setup stream file first, then the test stream file.
The test stream file should run wihout any problems.
Use the OSINSTALL Check command to check the results.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE

.H 2 "Zero Tests"

These tests check the ability to re-initialize a LIF boot directory
and the HP-UX booter. 
This is the first 8KBytes of the disc.
The level number is 5.

.H 3 "osin.5.1"
Try with a good directory and boot area.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & sosin.5.1
actions	:	T{
.na
Run the setup stream file first, then the test stream file.
The test stream file should run wihout any problems.
Use the OSINSTALL Check command to check the results.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.5.2"
Try with a file system made by HP-UX with the first 8K "empty".
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.5.2
actions	:	T{
.na
The test stream file should run wihout any problems.
Use the OSINSTALL Check command to check the results.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE
.H 3 "osin.5.3"
Try with a corrupt LIF directory.
.TS
expand;
l l lw(4.8i).
stream file	:	sosin.a & corrupt LIF & sosin.5.3
actions	:	T{
.na
Run the setup stream file.
The test stream file should run wihout any problems.
Use the OSINSTALL Check command to check that no changes were made.
Use HP-UX utilities to check the LIF directory and the bootfiles.
.ad
T}
.TE

.H 2 "Special Tests"

.H 3 "osin.6.1"
This is to check that the OSINSTALL program works as needed in
an install of the PWS system on a disc.
This should be the exact procedure a customer would use.

.H 3 "osin.6.2"
This is to check that the OSINSTALL program works as needed in
an install of the PWS system on a disc where HP-UX already
exists.
This should be the exact procedure a customer would use.

.H 3 "osin.6.3"
This is to check that the OSINSTALL program works as needed in
an install of non-PWS system such as MBA.
This should be the exact procedure a customer would use.

.H 2 "Setup Streams"

The setup stream files will produce a directory structure in which
to run the automatic tests.
This structure will be produced by transforming and copying 
an existing structure to
the test area.
These setup streams will provide some test of other OSINSTALL commands
in the HFS environment.
