/*************************************************************************/
/* TEST PROGRAM                                                          */
/* unit test for BACKUP utility                                          */
/*                                                                       */
/* routine: stat                                                         */
/* file   : ppcsys.c                                                     */
/* module : ppsys  (will be part of CLIBRARY later on)                   */
/*                                                                       */
/* Author : Angelika Hierath                                             */
/*          written April 1986                                           */
/*                                                                       */
/*************************************************************************/

#include <stdio.h>
#include "/users/paws/angelika/HEADER/sys/types.h"
#include "/users/paws/angelika/HEADER/sys/stat.h"
extern int errno;

main()
{
	char path[256];
	struct stat buf;
	char tbuf[64];
	char *ctime();

	printf("Test of routine: stat\n");

	/* ask for the file name */
	printf("\nfile name: ");
	scanf("%s",path);

	if( stat(path, &buf) != 0 ){
		printf("Cannot stat file %s, errno = %d\n", path, errno);
		exit(1);
	}
        printf("stat of %s:\n",path);
	printf("st_dev   : %d\n",buf.st_dev);
	printf("st_ino   : %d\n",buf.st_ino);
	printf("           %d\n",buf.st_ino/1024);
	printf("st_mode  : %o\n",buf.st_mode);
	printf("st_nlink : %d\n",buf.st_nlink);
	printf("st_uid   : %d\n",buf.st_uid);
	printf("st_gid   : %d\n",buf.st_gid);
	printf("st_rdev  : %x\n",buf.st_rdev);
	printf("st_size  : %d\n",buf.st_size);
	printf("st_atime : %d\n",buf.st_atime);
	strcpy(tbuf, ctime(&buf.st_atime));
	printf("           %s", tbuf);
	printf("st_mtime : %d\n",buf.st_mtime);
	strcpy(tbuf,ctime(&buf.st_mtime));
	printf("           %s", tbuf);
	printf("st_ctime : %d\n",buf.st_ctime);
	strcpy(tbuf,ctime(&buf.st_ctime));
	printf("           %s", tbuf);
}
