/*
 * C file for checking structure offsets.
 * Each routine fills the array with
 *    the size of the structure,
 *    then the offset of each item,
 *    then a -1.
 * we do the same in Pascal, then compare.
 */

#include <sys/types.h>
#include <sys/inode.h>
#include <sys/ino.h>
#include <sys/fs.h>
#include <sys/dir.h>

#define setaddr(y) *ip++ = ((int)&x.y - (int)&x)  

void
Cinode(ip)
	int ip[1]; {
	struct icommon x;

	*ip++ = sizeof(struct icommon);
	setaddr(ic_mode);
	setaddr(ic_nlink);
	setaddr(ic_uid);
	setaddr(ic_gid);
	setaddr(ic_size.val[1]);
	setaddr(ic_atime);
	setaddr(ic_atspare);
	setaddr(ic_mtime);
	setaddr(ic_mtspare);
	setaddr(ic_ctime);
	setaddr(ic_ctspare);
	setaddr(ic_db);
	setaddr(ic_un.ic_ib);
	setaddr(ic_flags);
	setaddr(ic_blocks);
	setaddr(ic_spare);
	*ip = -1;
}

void
Ccgroup(ip)
	int ip[]; {
	struct cg x;

	*ip++ = sizeof(struct cg);	
	setaddr(cg_link);
	setaddr(cg_rlink);
	setaddr(cg_time);
	setaddr(cg_cgx);
	setaddr(cg_ncyl);
	setaddr(cg_niblk);
	setaddr(cg_ndblk);
	setaddr(cg_cs.cs_ndir);
	setaddr(cg_cs.cs_nbfree);
	setaddr(cg_cs.cs_nifree);
	setaddr(cg_cs.cs_nffree);
	setaddr(cg_rotor);
	setaddr(cg_frotor);
	setaddr(cg_irotor);
	setaddr(cg_frsum);
	setaddr(cg_btot);
	setaddr(cg_b);
	setaddr(cg_iused);
	setaddr(cg_magic);
	setaddr(cg_free);
	*ip = -1;
}

void
Csb(ip)
	int ip[]; {
	struct fs x;

	*ip++ = sizeof(x);
	setaddr(fs_link);
	setaddr(fs_rlink);
	setaddr(fs_sblkno);
	setaddr(fs_cblkno);
	setaddr(fs_iblkno);
	setaddr(fs_dblkno);
	setaddr(fs_cgoffset);
	setaddr(fs_cgmask);
	setaddr(fs_time);
	setaddr(fs_size);
	setaddr(fs_dsize);
	setaddr(fs_ncg);
	setaddr(fs_bsize);
	setaddr(fs_fsize);
	setaddr(fs_frag);
	setaddr(fs_minfree);
	setaddr(fs_rotdelay);
	setaddr(fs_rps);
	setaddr(fs_bmask);
	setaddr(fs_fmask);
	setaddr(fs_bshift);
	setaddr(fs_fshift);
	setaddr(fs_maxcontig);
	setaddr(fs_maxbpg);
	setaddr(fs_fragshift);
	setaddr(fs_fsbtodb);
	setaddr(fs_sbsize);
	setaddr(fs_csmask);
	setaddr(fs_csshift);
	setaddr(fs_nindir);
	setaddr(fs_inopb);
	setaddr(fs_nspf);
	setaddr(fs_sparecon);
	setaddr(fs_csaddr);
	setaddr(fs_cssize);
	setaddr(fs_cgsize);
	setaddr(fs_ntrak);
	setaddr(fs_nsect);
	setaddr(fs_spc);
	setaddr(fs_ncyl);
	setaddr(fs_cpg);
	setaddr(fs_ipg);
	setaddr(fs_fpg);
	setaddr(fs_cstotal);
	setaddr(fs_fmod);
	setaddr(fs_clean);
	setaddr(fs_ronly);
	setaddr(fs_flags);
	setaddr(fs_fsmnt);
	setaddr(fs_cgrotor);
	setaddr(fs_csp);
	setaddr(fs_cpc);
	setaddr(fs_postbl);
	setaddr(fs_magic);
	setaddr(fs_fname);
	setaddr(fs_fpack);
	setaddr(fs_rotbl);
	*ip = -1;
}

void
Cdir(ip)
	int ip[]; {
	struct direct x;

	*ip++ = sizeof(struct direct);
	setaddr(d_ino);
	setaddr(d_reclen);
	setaddr(d_namlen);
	setaddr(d_name);
	setaddr(d_pad);
	*ip = -1;
}

/*
main() {
	int ip[200], i;

	printf("inode\n");
	Cinode(ip);
	for (i=0; i<200; i++) {
		printf("%d\n", ip[i]);
		if (ip[i] == -1)
			break;
	}
	printf("dir\n");
	Cdir(ip);
	for (i=0; i<200; i++) {
		printf("%d\n", ip[i]);
		if (ip[i] == -1)
			break;
	}
	printf("cgroup\n");
	Ccgroup(ip);
	for (i=0; i<200; i++) {
		printf("%d\n", ip[i]);
		if (ip[i] == -1)
			break;
	}
	printf("sb\n");
	Csb(ip);
	for (i=0; i<200; i++) {
		printf("%d\n", ip[i]);
		if (ip[i] == -1)
			break;
	}
}
*/
