 $PASCAL '91790-1X019 REV.4010 <851212.1033> '   $STANDARD_LEVEL 'HP1000'  $debug$   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	     MODULE alloc;   $ALIAS 'N$alloc'      {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  
{     NAME:   ALLOC  
 
{     SOURCE: 91790-18019  
 	{     RELOC:  NONE 	 	{     PGMR:   EMS  	 {}      IMPORT  
$ SEARCH 'phtm/bodec.rel'$ 
    bodec,       $ SEARCH 'phtm/init_dec.rel'$      init_dec,       $ SEARCH 'phtm/dres.xpt' $      dres;      EXPORT  PROCEDURE DS_GetSMBAddr      (     numbersmbwds:  Int16;       VAR smbaddr:       Int16;       VAR ierr:          Int16 );      PROCEDURE AllocateSMB      (     sizeofsmb:     Int16;       VAR ierr:          Int16 );      PROCEDURE DeallocateSMB;      IMPLEMENT       CONST      ALLOCSMB = 0;  	   SECCODE = 3360; 	 	   DEALLOCSMB = 1; 	    EXEC10 = 10 + NOABORTBIT;     EXEC12 = 12 + NOABORTBIT;     SECS = 2;     ONCE  = 0;      ONESEC = -1;       VAR      a_reg   :            Int16;     b_reg   :            Int16;      PROCEDURE ResourceAccess        $ ALIAS '#RSAX' $      (     accesstype:       Int16;            smbsize_or_addr:  Int16;            seccode:          Int16 );      EXTERNAL;      PROCEDURE ABReg      ( VAR a_reg:   Int16;  
     VAR b_reg:   Int16 ); 
    EXTERNAL;     { get the A and B registers for errors on RTE calls }      "FUNCTION PascalStringData                $ ALIAS 'Pas.StringData1' $ "    ( VAR s:          String ):  PCharTypePtr;      EXTERNAL;     { return a packed array of char pointer to a string }      PROCEDURE RtePrint                       $ ALIAS 'XREIO' $  
$ HEAPPARMS OFF, NOABORT $ 
   ( writereq:     Int16;      conwd:        CnWdType;       msg:          PCharType;  
    msglen:       Int16 ); 
    EXTERNAL;     { Print a message on the scheduling terminal }       $SUBTITLE 'DS_GetSMBAddr', PAGE $   PROCEDURE DS_GetSMBAddr      (     numbersmbwds:  Int16;       VAR smbaddr:       Int16;       VAR ierr:          Int16 );  {}   {  This routine reserves the amount of smb the caller requested    {  by updating variables internal to the module.  This routine  {  MUST be called by all DSINIT routines that wish to use smb    {  for table storage.  The routines should not request more smb    "{  than they indicated they would use during DSINIT question-asking. " {   !{  Note that this routine does NOT do anything to the smb.  There  ! "{  is no protection on the reserved smb.  Anyone can overwrite this  " !{  space by using more smb than they requested.  Therefore checks  ! !{  should be made in the calling routine to ensure that this does  ! {  not occur.   {   {  Input:   {     numbersmbwords- amt of smb caller wants reserved  {  Output:  #{     smbaddr-        address of smb that was reserved for the caller  # {     ierr-           = 0 if no error, <> 0 otherwise   {  Module variables accessed:   !{     nextavailsmbaddr- this var is incremented by numbersmbwords  ! {   
{  Routines called:  none  
 {   {  NOTE: This routine counts on AllocateSmb to initialize   {     nextavailsmbaddr.  If this is not done  {     there is no guarrantee that the addresses returned will   {     make any sense.   {   {}  VAR      lastavailsmbaddr:    Int16;     sizeofsmb:           Int16;     startofsmb:          Int16;      $ PAGE $     BEGIN    { DS_GetSMBAddr }          DS_GetResElement( NSINIT_AdrOf( Lb_FWAM ), 0, startofsmb );     DS_GetResElement( NSINIT_AdrOf( Lb_SAVM ), 0, sizeofsmb );          lastavailsmbaddr := startofsmb + sizeofsmb;         WITH initglobals DO        BEGIN    { WITH }         IF ( IG_nextavailsmbaddr <= 0 ) OR                           ( lastavailsmbaddr <= 0 ) THEN            BEGIN    { invalid addrs }                ierr := INVSMBADDR;           END      { invalid addrs }           ELSE IF IG_nextavailsmbaddr > lastavailsmbaddr THEN               BEGIN    { too much smb requested }                   { we already used all alloc smb }               ierr := ERRNOSMBLEFT;               END      { too much smb requested }              ELSE               BEGIN    { no error }       
            ierr := GOOD;  
                 { tell caller his smb addr }              smbaddr := IG_nextavailsmbaddr;       '            { update the module ptr to indicate this smb no longer available } ' #            IG_nextavailsmbaddr := IG_nextavailsmbaddr + numbersmbwds; #                 END;     { no error }         END;     { WITH }      END;     { DS_GetSMBAddr }       $SUBTITLE 'AllocateSMB', PAGE $   PROCEDURE AllocateSMB      (     sizeofsmb:     Int16;       VAR ierr:          Int16 );      {}   {  This routine allocates smb, the DS table area for DS/1000-IV.   {   {  Input:   {     sizeofsmb- number of words of smb to allocate   {   {  Output:  {     ierr-      =0 if no error; <> 0 otherwise   {   {  Alloc variables accessed:  {     this routine initializes nextavailsmbaddr   
{     if smb is allocated. 
 {   
{  Routines called:  
 {     ResourceAccess (#RSAX), ABreg, DS_ClearRes,   	{     DS_ClearSMB. 	 {   {  Description:   {     1. Call ResourceAccess to allocate SMB.   !{        If successful do 2-4. Otherwise return with ierr = ERROR. ! {   {     2. Update nextavailsmbaddr.   "{        ResourceAccess returns value of #FWAM (nextavailsmbaddr) in " {        the a-register.  {   {     3. Clear small portion of RES.  {   {     4. Zero out all allocated smb.  {   {  Note: ResourceAccess initialized #FWAM and #SAVM in RES.   {   {}      $ PAGE $     BEGIN { Allocatesmb }         ResourceAccess( ALLOCSMB, sizeofsmb, SECCODE );  
   ABReg( a_reg, b_reg );  
 
   IF a_reg > 0 THEN 
       BEGIN    { smb alloc }            { #RSAX returns the next avail smb addr in the a-reg }        initglobals.IG_nextavailsmbaddr := a_reg;             { clear RES from #TBRN to #PNLH }   	      DS_ClearRes; 	           { zero out all allocated smb }  	      DS_ClearSMB; 	           END      { smb alloc }       ELSE         BEGIN    { could not alloc }      
      ierr := ERRALLOCSMB; 
       END;     { could not alloc }         END;  { Allocatesmb }      $ SUBTITLE 'DeallocateSMB', PAGE $  PROCEDURE DeallocateSMB;      {}  {  This routine deallocates smb, the DS/1000-IV table area.   {   {  Input:   none  {  Output:  none  {  Alloc variables accessed:  {     nextavailsmbaddr is cleared after deallocation.   
{  Routines Called:  
 {     ResourceAccess (#RSAX), DS_GetResElement, DS_ClearRES.  {   {  Description:    {     This routine gets the first word of smb from #FWAM in RES.   !{     It then calls ResourceAccess to deallocate smb.  The routine ! !{     then clears nextavailsmbaddr, the current avail smb pointer. ! {   {     DS_ClearRes is also called to clear a portion of RES.   {   {  NOTE: ResourceAccess clears #FWAM and #SAVM.   {   {}      VAR   
   firstsmbaddr :   Int16; 
     $ PAGE $         BEGIN    { deallocatesmb }          { find the first word of avail smb for #RSAX check }       DS_GetResElement( NSINIT_AdrOf( Lb_FWAM ), 0, firstsmbaddr );          IF firstsmbaddr <> 0 THEN        BEGIN    { deallocate smb }          { Only return smb if it was allocated in the first place.             It seems that the system gets confused if you deallocate   !        what you don't have.                                     } !           ResourceAccess( DEALLOCSMB, firstsmbaddr, SECCODE );        { no error returned }         END;     { deallocate smb }          { clear RES from #TBRN through #TST+1 }     DS_ClearRes;          { also clear a few other RES entry points }     DS_StoreResElement( NSINIT_AdrOf( Lb_IFPM ), 0, 0 );      DS_StoreResElement( NSINIT_AdrOf( Lb_NULL ), 0, 0 );      DS_StoreResElement( NSINIT_AdrOf( Lb_NMSC ), 0, 0 );      DS_StoreResElement( NSINIT_AdrOf( Lb_NCNT ), 0, 0 );      DS_StoreResElement( NSINIT_AdrOf( Lb_LUMP ), 0, 0 );      DS_StoreResElement( NSINIT_AdrOf( Lb_NODE ), 0, -1 );      
   { zero out alloc ptrs } 
    initglobals.IG_nextavailsmbaddr := 0;         END;     { deallocatesmb }       END   { module }  .  