 $PASCAL '91790-16032 REV.4010 <860828.1437>'  
$Standard_Level 'HP1000'$  
 $Run_String 0$  $Recursive Off$   $Private_Types$   $Debug$   $Heap 1$  $Range Off$       PROGRAM DSCOP;      {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{       NAME: DSCOP  
 
{     SOURCE: 91790-18032  
 
{      RELOC: 91790-16032  
 	{       PGMR: TDS  	 {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {   Date    PCO  Prgmr    Description   { 12/20/85  ---   EW      Delete references to IPCUABORT  { 03/26/86  2626  EW      Set timeout on VC to producer to 20   {                         minutes. SR # 34892   {                   **** 4010 *****   !{ 08/11/86  4010  EW      Use short (default) user timeout during  ! {                         connection setup.   "{ 08/14/86  4010  EW      Altered routine "InsertCommasForSpaces" to " ${                         not insert commas into quoted portions of the  $ {                         command line.   #{ 08/28/86  4010  EW      Altered routine "squezeoutquotes" delete the # %{                         quote with StrDelet rather than to substitute a  % '{                         space and then call "squezeoutspaces". Also altered  ' '{                         "squezeoutspaces". To not touch spaces within quoted ' {                         strings.  {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {   {   This is the Network File Transfer Initiator program. Its  {   purpose is to mediate the interaction between the user and  {   the NFT Producer program. The Initiator interacts with no   {   NFT process other than the Producer.  {}      $Page   #{-------------------------------------------------------------------}  # #{                          GLOBAL LABELS                            }  # #{-------------------------------------------------------------------}  #     LABEL          999;  { Labels end of the program }      #{-------------------------------------------------------------------}  # #{                              IMPORT                               }  # #{-------------------------------------------------------------------}  #     IMPORT         $SEARCH 'phtm/BODEC.REL'$  Bodec,     $SEARCH 'phtm/SODEC.REL'$  Sodec,     $SEARCH 'phtm/MMDEC.REL'$  Mmdec,     $SEARCH 'phtm/MMEXT.REL'$  Ds_mm,     $SEARCH 'phtm/TRCMOD.REL'$ Trcmod,      $SEARCH 'phtm/SIGMOD.REL'$ Sigmod;       #{-------------------------------------------------------------------}  # #{                         GLOBAL CONSTANTS                          }  # #{-------------------------------------------------------------------}  #     CONST      { Include the common NFT constant declarations }      $Include 'src/NFTCONSTS.PASI'         { NFT file transfer command options }     APPEND_OPTION        = Ord ('A') * 256 + Ord ('P');     ASCII_OPTION         = Ord ('A') * 256 + Ord ('S');     BINARY_OPTION        = Ord ('B') * 256 + Ord ('I');     COMPRESS_OPTION      = Ord ('C') * 256 + Ord ('O');     DIRECT_OPTION        = Ord ('D') * 256 + Ord ('I');     FCODE_OPTION         = Ord ('F') * 256 + Ord ('C');     FIXED_OPTION         = Ord ('F') * 256 + Ord ('I');     FSIZE_OPTION         = Ord ('F') * 256 + Ord ('S');     ICHAR_OPTION         = Ord ('I') * 256 + Ord ('C');     INTERCHANGE_OPTION   = Ord ('I') * 256 + Ord ('N');     MOVE_OPTION          = Ord ('M') * 256 + Ord ('O');     OVERWRITE_OPTION     = Ord ('O') * 256 + Ord ('V');     QUIET_OPTION         = Ord ('Q') * 256 + Ord ('U');     REPLACE_OPTION       = Ord ('R') * 256 + Ord ('E');     RSIZE_OPTION         = Ord ('R') * 256 + Ord ('S');     SCHAR_OPTION         = Ord ('S') * 256 + Ord ('C');     SEQUENTIAL_OPTION    = Ord ('S') * 256 + Ord ('E');     STRIP_OPTION         = Ord ('S') * 256 + Ord ('T');     TRANSIENT_OPTION     = Ord ('T') * 256 + Ord ('R');     VARIABLE_OPTION      = Ord ('V') * 256 + Ord ('A');         { NFT/1000 commands }     CLEAR_COMMAND        = Ord ('C') * 256 + Ord ('L');     DEFAULT_COMMAND      = Ord ('D') * 256 + Ord ('E');     ECHO_COMMAND         = Ord ('E') * 256 + Ord ('C');     EXIT_COMMAND         = Ord ('E') * 256 + Ord ('X');     LIST_FILE_COMMAND    = Ord ('L') * 256 + Ord ('L');     RUN_COMMAND          = Ord ('R') * 256 + Ord ('U');     SHOW_COMMAND         = Ord ('S') * 256 + Ord ('H');     TRANSFER_COMMAND     = Ord ('T') * 256 + Ord ('R');     WORKING_DIR_COMMAND  = Ord ('W') * 256 + Ord ('D');      #   { These limit the buffer size of the main buffer. The initiator   } # #   { program will only see control messages, never data messages.    } # #   { NFT limits the size of the largest control message to 700 bytes } #    MAX_BUFFER_WORDS      =  350;     MAX_BUFFER_BYTES      =  MAX_BUFFER_WORDS * 2;       $   { This is the size of the largest command that can be entered. It   } $ $   { was originally 700 (which is the maximum defined by NFT for the   } $ $   { RNFT message), but it was discovered that many of the NFT parsing } $ $   { routines did not work on strings of this size. This is because    } $ $   { these routines declare parmameter strings using the anonymous type} $ $   { "String" (because different size strings are passed as parms) and } $ $   { Pascal will not modify undefined length strings greater than 256  } $ $   { characters. This maximum value DOES NOT include any defaulted     } $ $   { strings (such as node names or logons). If a command was greater  } $ $   { than 256 characters, then everything but the file names could be  } $ $   { defaulted using the DE command.                                   } $    MAX_COMMAND_BYTES     =  256;      "   { These are possible events. Others are Nft msg types so these }  " "   { event numbers must not conflict with Nft message numbers     }  "    NULL_EVENT            =  -1;      USER_WANTS_ABORT      =  -2;      USER_WANTS_CANCEL     =  -3;      USER_WANTS_PROGRESS   =  -4;      USER_WANTS_HELP       =  -5;      CONNECTION_DOWN       =  -6;       
   { Character constants } 
    ASTERISK              = '*';      AT_SIGN               = '@';      COMMA                 = ',';      CONTINUATION_CHAR     = '&';      CONTROL_Y             = #Y;     EQUAL_SIGN            = '=';      PLUS_SIGN             = '+';      SEMI_COLON            = ';';      QUESTION_MARK         = '?';      QUOTE                 = '''';         { These are the break mode help messages. }  
   BREAK_MODE_HELP1      = 
 #   ' ABORT .... Interrupt the current transfer and save any new file'; # 
   BREAK_MODE_HELP2      = 
 "   ' CANCEL ... Cancel the current transfer and purge any new file'; " 
   BREAK_MODE_HELP3      = 
 "   ' STATUS ... Request the percent of the file transferred so far'; "        { Miscellaneous constants }     CONTINUE_PROMPT       =  'Continue: ';      CREATING_DIR          =  'Creating directory ';     CURRENT_DEFAULTS      =  ' ---Current Defaults---';     DOTS                  =  ' ... ';     EXEC_12               =   12;     EXEC_14               =   14;     FAILED                =  '[failed]';      FILES_IN_SET          =  ' files matched the request---';     GET_RUN_STRING        =    1;     HELLO_BANNER1         =  'Network File Transfer ';      HELLO_BANNER2         =  '- Enter ? for help.';     MESSAGE_FILE_NAME1    =  'DSCOPY.HLP::SYSTEM';      MESSAGE_FILE_NAME2    =  '"DSCOP::0';     OK                    =  '[ok]';   !   PERCENT_XFERRED       =  '% of the file has been transferred.'; !    PERIOD                =  '.';     RELATIVE_WAIT_TIME    =    4;     REV_CODE              =  'Rev 4.1 ';      SECONDS               =    2;     SOURCE_STRING         =  'Copying ';      THERE_ARE             =  '---A total of ';      TO_STRING             =  ' to ';   !   VC_PRODC_TIMEOUT      =  12000; { Timeout for VC to producer }  !     $Page   #{-------------------------------------------------------------------}  # #{                           GLOBAL TYPES                            }  # #{-------------------------------------------------------------------}  #     TYPE     ByteAsBits = PACKED RECORD         CASE BOOLEAN OF            TRUE:  (byt  : Byte);           FALSE: (bits : PACKED ARRAY [0..7] OF BOOLEAN);     END;          { These are used in the Initialize procedure }   !   CommandPacType    = PACKED ARRAY [1..MAX_BUFFER_BYTES] OF CHAR; !    CommandPacPtr     = ^CommandPacType;      CommandStringType = String [MAX_COMMAND_BYTES];      !   { These are used for the AdsErrorLookup and FmpError routines } ! !   ErrorPacType    = PACKED ARRAY [1..ERROR_STRING_SIZE] OF CHAR;  !    ErrorStringType = String [ERROR_STRING_SIZE];         { This record appears in the Rinit an Ainit messages }      CapabilityMaskRecord = RECORD        CASE BOOLEAN OF            TRUE : (word  : Int32);           FALSE: (bits  : PACKED ARRAY [0..31] OF BOOLEAN);     END;          { This is an option word in the RNFT message }      ConsumerStorageRecord = PACKED RECORD        CASE BOOLEAN OF            TRUE : (whole_byte  : Byte);            FALSE: (unused      : PACKED ARRAY [0..2] OF BOOLEAN;                   cctl        : BOOLEAN;                    transient   : BOOLEAN;                    append      : BOOLEAN;                    overwrite   : BOOLEAN;                    replace     : BOOLEAN);       { LSB }     END;       #   { This is the type of a session as defined by DsRsm/1000 software } #    DsSessionKeyType = RECORD        CASE BOOLEAN OF   $         TRUE:  (bytes : PACKED ARRAY [1..SESSION_KEY_WORDS*2] OF Byte); $           FALSE: (words : ARRAY [1..SESSION_KEY_WORDS] OF Int16);      END;          ErrorOrWarnType = (ERROR, WARN);          IcharScharType = String [MAX_IC_SC_CHARS];       "   { This record gives the value of an Ichar or Schar string as an } " "   { integer.                                                      } "    IcharScharValueType = RECORD   
      int   : Int16; 
       valid : BOOLEAN;     END;          FiveWordsType = ARRAY [0..4] OF Int16;       !   { This record is used to hold a session key for the initiator } ! !   { program. The session key is valid only if the valid flag is } ! !   { true, and invalid otherwise. For more information, refer to } ! !   { procedure FillInNullFields().                               } !    InitrSessionKeyType = RECORD         key   : DsSessionKeyType;         valid : BOOLEAN;     END;          { Following types are used by error catcher, printer }      CatchErrorType = (RUN_TIME_ERROR, EMA_ERROR, I_O_ERROR,  "                     FILE_ERROR, SEGMENTATION_ERROR, WARNING_ERROR); "        LogicalFileNameType = PACKED ARRAY [1..150] OF CHAR;          { The following declarations are for the pieces of a }      { transfer command                                   }      FileNameType   = String [MAX_NFT_FILE_CHARS];     LogonType      = String [MAX_NFT_LOGON_CHARS];      NodeNameType   = String [MAX_NODE_NAME_CHARS];   !   NodeNamePacType= PACKED ARRAY [1..MAX_NODE_NAME_CHARS] OF CHAR; !        { This record appears in UserCommandFieldsType and        }     { GlobalDefaultsType. It holds some user transfer options }     UserCommandTargOptns = PACKED RECORD         CASE BOOLEAN OF            TRUE : (whole_byte   : Byte);            FALSE: (unused       : PACKED ARRAY [0..4] OF BOOLEAN;                     append       : BOOLEAN;                   replace      : BOOLEAN;                   overwrite    : BOOLEAN);      END;       #   { This record is used to hold the global defaults which are used }  # #   { for file transfer commands. The usage of the fields is the same}  # #   { as the fields declared in global record user_command_fields.   }  # #   { See UserCommandFieldsType for more information.                }  #    GlobalDefaultsType = RECORD        gd_compress    : BOOLEAN;         gd_data_type   : Byte;        gd_fcode       : Int16;         gd_file_organ  : Byte;        gd_fsize       : Int32;         gd_ichar       : IcharScharType;        gd_ichar_value : IcharScharValueType;         gd_move        : BOOLEAN;         gd_quiet       : BOOLEAN;         gd_record_type : Byte;        gd_rsize       : Int32;         gd_schar       : IcharScharType;        gd_schar_value : IcharScharValueType;         gd_strip       : BOOLEAN;         gd_slogon      : LogonType;         gd_snode       : NodeNameType;        gd_toptns      : UserCommandTargOptns;        gd_tlogon      : LogonType;         gd_tnode       : NodeNameType;        gd_xfer_type   : Int16;      END;          { The following type is used in the Ipc calls }     IpcFlagsType = Int32;      "   { This allows for three option entries with two data bytes each } "    IpcOptionsType = PACKED ARRAY [0..33] OF Byte;          Hp1000PathNameType = String [MAX_1000_PATH_CHARS];          MiscAnftFlagsType = PACKED RECORD        CASE BOOLEAN OF            TRUE : (whole_byte   : Byte);            FALSE: (unused       : PACKED ARRAY [0..6] OF BOOLEAN;                     is_directory : BOOLEAN);      END;          { This is word two of every message }     MsgTypeRecord = PACKED RECORD        protocol_id       : Byte;           { Always 1 for NFT }        nft_type          : Byte;           { NFT message type }     END;          { This record is used by some parsing routines to return }      { the fact that some of the fields of a transfer command }      { were present but were null. For example a null logon   }      { could be "[]" which may have a different meaning from  }      { no logon given at all.                                 }      NullFieldsType = PACKED RECORD         CASE BOOLEAN OF            TRUE:  (int          : Byte);           FALSE: (nf_ichar     : BOOLEAN;                   nf_schar     : BOOLEAN;                   nf_fcode     : BOOLEAN;                   nf_fsize     : BOOLEAN;                   nf_rsize     : BOOLEAN;                   nf_slogon    : BOOLEAN;                   nf_snode     : BOOLEAN;                   nf_tlogon    : BOOLEAN;                   nf_tnode     : BOOLEAN);      END;          PointerType = ^Int16;         { Contains information about the producer }     ProducerInfoType  = RECORD         pi_connected      : BOOLEAN;        pi_logon          : LogonType;        pi_node_name      : NodeNameType;         pi_socket_descr   : Int32;     END;          { This is an option word in the RNFT message }      ProducerOptionsRecord = PACKED RECORD        CASE BOOLEAN OF            TRUE:  (whole_byte : Byte);  "         FALSE: (unused2    : PACKED ARRAY [0..2] OF BOOLEAN; {Msb}  "                  compress   : BOOLEAN;                   strip      : BOOLEAN;                   same_node  : BOOLEAN;                   unused1    : BOOLEAN;  "                 move       : BOOLEAN);                       {Lsb}  "    END;          ProgramNameType = PACKED ARRAY [1..6] OF CHAR;          { This is for the params returned to the father program }     ReturnParamsType = ARRAY [0..4] OF Int16;         SixCharsType = PACKED ARRAY [1..6] OF CHAR;         StateTypes = (WAIT_FOR_AINIT, WAIT_FOR_ANFT, IDLE);         SourceOrTargetType = (SOURCE, TARGET);       
   String2  = String [2];  
 
   String10 = String [10]; 
 
   String20 = String [20]; 
 
   String64 = String [64]; 
        TwoCharsType = PACKED RECORD         CASE BOOLEAN OF            TRUE : (char1  : CHAR;                    char2  : CHAR);           FALSE: (int    : Int16);      END;       !   { This record is used to contain the pieces of a parsed file }  ! !   { transfer command. The usage of the fields is below. For    }  ! !   { all of the boolean fields, if the conditions are not met   }  ! !   { for it to be true, it will be false.                       }  ! !   {  uc_compress       - True if COMPRESS option given         }  ! !   {  uc_data_type      - Either ASCII or BINARY or zero        }  ! !   {  uc_fcode          - Gives the FCODE value, else zero      }  ! !   {  uc_file_organ     - Either DIRECT or SEQUENTIAL or zero   }  ! !   {  uc_fsize          - Gives the FSIZE value, else zero      }  ! !   {  uc_ichar          - Gives the ICHAR string, else null     }  ! !   {  uc_ichar_value    - Gives the integer value of uc_ichar   }  ! !   {                      if the string begins with ASCII zero. }  ! !   {  uc_move           - True if the MOVE option was given     }  ! !   {  uc_quiet          - True if the QUIET option was given    }  ! !   {  uc_record_type    - Either FIXED or VARIABLE or zero      }  ! !   {  uc_rsize          - Gives the RSIZE value, else zero      }  ! !   {  uc_schar          - Gives the SCHAR string, else null     }  ! !   {  uc_schar_value    - Gives the integer value of uc_schar   }  ! !   {                      if the string begins with ASCII zero. }  ! !   {  uc_strip          - True if the STRIP option was given    }  ! !   {  uc_sfile          - Gives the name of the source file     }  ! !   {  uc_slogon         - Gives the source logon                }  ! !   {  uc_snode          - Gives the source node name            }  ! !   {  uc_snode_local    - True if the source node name given or }  ! !   {                      implied in the user copy command is   }  ! !   {                      the local node. Used only to suppress }  ! !   {                      printing of node name if local.       }  ! !   {  uc_src_session    - Gives a session key for the initiator }  ! !   {                      session that producer should attach   }  ! !   {                      to. This is not actually part of the  }  ! !   {                      user command. A value is placed here  }  ! !   {                      by the initiator when he sees that the}  ! !   {                      source logon string is null and the   }  ! !   {                      source node is the local node. IF <>  }  ! !   {                      0, this field is placed in the RINIT. }  ! !   {  uc_targ_session   - Gives a session key for the initiator }  ! !   {                      session that consumer should attach   }  ! !   {                      to. See uc_src_session for more info. }  ! !   {                      IF <> 0 this is placed in the RNFT.   }  ! !   {  uc_toptns         - Contains mutually exclusive flags for }  ! !   {                      APPEND, REPLACE or OVERWRITE if any   }  ! !   {                      of those options were give            }  ! !   {  uc_tfile          - Gives the target file name            }  ! !   {  uc_tlogon         - Gives the target logon                }  ! !   {  uc_tnode          - Gives the target node name            }  ! !   {  uc_tnode_local    - True if the target node name given or }  ! !   {                      implied in the user copy command is   }  ! !   {                      the local node. Used only to suppress }  ! !   {                      printing node name if local.          }  ! !   {  uc_xfer_type      - Either INTERCHANGE or TRANSIENT or    }  ! !   {                      zero if neither was given             }  !    {}      UserCommandFieldsType = RECORD         uc_compress     : BOOLEAN;        uc_data_type    : Byte;         uc_fcode        : Int16;        uc_file_organ   : Byte;         uc_fsize        : Int32;        uc_ichar        : IcharScharType;         uc_ichar_value  : IcharScharValueType;        uc_move         : BOOLEAN;        uc_quiet        : BOOLEAN;        uc_record_type  : Byte;         uc_rsize        : Int32;        uc_schar        : IcharScharType;         uc_schar_value  : IcharScharValueType;        uc_strip        : BOOLEAN;        uc_sfile        : FileNameType;         uc_slogon       : LogonType;        uc_snode        : NodeNameType;         uc_snode_local  : BOOLEAN;        uc_src_session  : DsSessionKeyType;         uc_targ_session : DsSessionKeyType;         uc_toptns       : UserCommandTargOptns;         uc_tfile        : FileNameType;         uc_tlogon       : LogonType;        uc_tnode        : NodeNameType;         uc_tnode_local  : BOOLEAN;        uc_xfer_type    : Int16;     END;          UserOrGlobalType = (USER_TO_GLOBAL, GLOBAL_TO_USER);           $Page   #   {------------------------NFT MESSAGE TYPES------------------------} # #   { These declarations are for the fixed length part of the message } # #   { of the message only. The Nft message header is not included in  } # #   { any of the messages since it is common to all of them. Refer to } # #   { the Nft Protocol Specification for more info on each            } #        { Ainit message fields }      AinitMsgType = PACKED RECORD         debug_flags          : ByteAsBits;        misc_flags           : ByteAsBits;        system_type          : Int16;         op_sys_version       : Int16;         buffer_size          : Int16;         capability_mask      : CapabilityMaskRecord;        sys_specif_capa_mask : Int16;         error_code           : Int16;         local_error_msg_ptr  : Int16;         error_code_enhan_ptr : Int16;         end_ptr              : Int16;      END;       
   { Anft message fields } 
    AnftMsgType = PACKED RECORD        amount_data_xferred  : Int32;         type_of_data_xferred : Byte;        misc_anft_flags      : MiscAnftFlagsType;         error_code           : Int16;         local_error_msg_ptr  : Int16;         error_code_enhan_ptr : Int16;         source_file_ptr      : Int16;         target_file_ptr      : Int16;         end_ptr              : Int16;      END;          { Anftgen message fields }      AnftgenMsgType = PACKED RECORD         amount_data_xferred  : Int32;         type_of_data_xferred : Byte;        misc_anft_flags      : MiscAnftFlagsType;         number_generic_files : Int16;         restart_id           : Int16;         nft_error_code       : Int16;         local_error_msg_ptr  : Int16;         error_code_enhan_ptr : Int16;         source_file_ptr      : Int16;         target_file_ptr      : Int16;         end_ptr              : Int16;      END;       
   { Info message fields } 
    InfoMsgType = PACKED RECORD        restart_id           : Int16;         number_generic_files : Int16;         source_file_ptr      : Int16;         target_file_ptr      : Int16;         end_ptr              : Int16;      END;          { Progress message fields }     ProgressMsgType = PACKED RECORD        percentage_xferred   : Byte;        unused_byte          : Byte;     END;          { Rinit message fileds }      RinitMsgType = PACKED RECORD         debug_flags          : ByteAsBits;        misc_flags           : ByteAsBits;        system_type          : Int16;         op_sys_version       : Int16;         buffer_size          : Int16;         capability_mask      : CapabilityMaskRecord;        sys_specif_capa_mask : Int16;         logon_ptr            : Int16;         logon_pass_ptr       : Int16;         session_id_ptr       : Int16;         shared_session_ptr   : Int16;         end_ptr              : Int16;      END;       
   { Rnft message fields } 
    RnftMsgType = PACKED RECORD        force_store_options      : Byte;        data_type                : Byte;        record_type              : Byte;        file_organiz             : Byte;        record_length            : Int32;         number_records           : Int32;         consumer_storage         : ConsumerStorageRecord;         producer_options         : ProducerOptionsRecord;         checkpoint_interval      : Int16;         schar_ptr                : Int16;         ichar_ptr                : Int16;         source_file_ptr          : Int16;         source_file_pass_ptr     : Int16;         source_file_dev_ptr      : Int16;         consumer_name_ptr        : Int16;         target_file_ptr          : Int16;         target_file_pass_ptr     : Int16;         target_file_dev_ptr      : Int16;         cons_logon_ptr           : Int16;         cons_logon_pass_ptr      : Int16;         cons_session_id_ptr      : Int16;         cons_shared_session_ptr  : Int16;         source_file_code_ptr     : Int16;         end_ptr                  : Int16;      END;          WarningMsgType = PACKED RECORD         nft_error_code           : Int16;         local_error_msg_ptr      : Int16;         error_code_enhan_ptr     : Int16;         end_ptr                  : Int16;      END;           $Page   $   {------------------------MAIN BUFFER TYPES-------------------------}  $        { This is the general format of an NFT message }      NftMessageType = PACKED RECORD         msg_length  : Int16;         { In Bytes }         msg_type    : MsgTypeRecord;      
      CASE Int16 OF  
          {----------- Incoming -----------}            0 : (ainit_msg    : AinitMsgType);            1 : (anft_msg     : AnftMsgType);           2 : (anftgen_msg  : AnftgenMsgType);            3 : (info_msg     : InfoMsgType);           4 : (progress_msg : ProgressMsgType);           5 : (warning_msg  : WarningMsgType);            {----------- Outgoing -----------}            6 : (rinit_msg    : RinitMsgType);            7 : (rnft_msg     : RnftMsgType);     END;       #   { This is the declaration for the main buffer. It is used to send } # #   { and receive all messages from the producer, and to buffer up the} # #   { user's command before being parsed. The msg variant is used to  } # #   { access the fields of any given message. The other variants are  } # #   { used to access the message fields as a whole.                   } # 
   MainBufferType = RECORD 
 
      CASE Int16 OF  
          0 : (msg     : NftMessageType);            1 : (words   : ARRAY [0..MAX_BUFFER_WORDS-1] OF Int16);   #         2 : (chars   : PACKED ARRAY [0..MAX_BUFFER_BYTES-1] OF CHAR); # #         3 : (chars1  : PACKED ARRAY [1..MAX_BUFFER_BYTES]   OF CHAR); # #         4 : (bytes   : PACKED ARRAY [0..MAX_BUFFER_BYTES-1] OF Byte); #          5 : (command : CommandStringType);      END;           $Page   #{-------------------------------------------------------------------}  # #{                         GLOBAL VARIABLES                          }  # #{-------------------------------------------------------------------}  #     VAR   "   { These are used only in InStateWaitForAinit. They are used to }  " "   { indicate that the user has requested an Abort or Cancel that }  " "   { could not be carried out immediately                         }  "    abort_requested         : BOOLEAN;      cancel_requested        : BOOLEAN;       "   { If true, this indicates that the user aborted or cancelled   }  " "   { the previous transfer. This may cause us to abort a transfer }  " "   { file if we are currently in one                              }  "    aborted_or_cancelled    : BOOLEAN;       "   { This is the descriptor to the call socket used to connect to }  " "   { the producer system                                          }  "    call_socket_descr       : Int32;       "   { This is used in the main routine only. If true, it indicates }  " "   { that the user flushed the command within GetCommand().       }  "    command_flushed         : BOOLEAN;       "   { True if the cursor is at the end of the line, that is if the }  " "   { user is waiting for 'ok' or 'failed', else this is false.    }  " "   { This only applies to the list file since that is where the   }  " "   { file names are printed.                                      }  "    cursor_end_of_line      : BOOLEAN;           { If true, these indicate we are performing some function  }        { which may cause the error handler to be invoked. If the  }        { error handler is invoked, he will see one of these flags }        { set an will return control to the point of error where   }        { we can handle the error                                  }       converting_to_integer   : BOOLEAN;      opening_file            : BOOLEAN;      reading_from_input      : BOOLEAN;       "   { If true, this indicates that the run string contained a copy }  " "   { command and therefore we should terminate after executing it }  "    copy_in_run_string      : BOOLEAN;          { These are place holders in some of the socket calls }     dummy_flags             : IpcFlagsType;     dummy_options           : IpcOptionsType;      "   { If true, this means we should echo commands to the list file }  "    echo_input              : BOOLEAN;       #   { True only if we have just reached end-of-file in the input file.} #    end_of_file             : BOOLEAN;          { If this true we have entered the error handler }      entered_error_handler   : BOOLEAN;       #   { Used to prevent us from looping infinitely in the Pascal error }  # #   { catcher. See CatchError for more info.                         }  #    entry_count             : Int16;       !   { This is a string used by the procedures which print errors. } ! !   { It may contain different types of strings                   } !    error_string            : ErrorStringType;       !   { Gives the event that occurred and will be handled by one of } ! !   { the InStateWaitForXXX procedures. This could be either a    } ! !   { constant (see constants) or an Nft message type.            } !    event                   : Int16;       #   { This flag is true only if we are making our first pass through  } # #   { the main routine. It is used in procedure GetCommand. It's sole } # #   { purpose is to cause dscopy to print his prompt if the user hits } # #   { carriage return after entering dscopy interactively. Pascal I/O } # #   { to LUs is a little wierd.                                       } #    first_pass              : BOOLEAN;       "   { This record contains the currently active global defaults for } " "   { file transfer commands                                        } "    global_defaults         : GlobalDefaultsType;      #   { This is used only in the main routine and in the Pascal error  }  # #   { handler. Whenever an error occurs that Pascal detects, he will }  # #   { call the HandleError procedure which in turn may modify this   }  #    global_fmp_error        : Int16;       $   { Gives the nft error of the last transfer or Dscopy command. Only }  $ $   { the +DE, +LL, +RU and +TR commands could generate an nft_error.  }  $ $   { For the other commands (excluding +EX), this error is cleared.   }  $ $   { This is intended to be returned to the caller via PRTN.          }  $    global_nft_error        : Int16;       #   { This is used to hold a valid session key for our session. Refer } # #   { to the type declaration for more info.                          } #    initr_session_key       : InitrSessionKeyType;          { This is used only in the main routine }     ipc_error               : Int32;       "   { These are all of the files used by this program. The input    } " "   { file is where the commands are read. The list file is where   } " "   { file names, warnings and errors are printed. The log_file     } " "   { is only used to read break-mode requests from the user. The   } " "   { message_file is used to access the file containing help info  } " "   { and error strings and warnings. The output file is where      } " "   { error info is printed (if different from the list file)       } "    input                   : Text;     log_file                : Text;     output                  : Text;      #   { We must allocate enough space in the list file buffer for the  }  # #   { largest record we will write to it. If we tried to write a     }  # #   { record larger than the default of 128 chars then Pascal would  }  # #   { issue a warning after 128 chars which is not desireable. The   }  # #   { largest record includes: 2 file names (256 chars each), 2 node }  # #   { names (50 chars each) and miscellaneous stuff (30 chars).      }  # #   { Beware that even though user commands are limited to 256 chars }  # #   { a wildcard specification could could cause the source computer }  # #   { (maybe UNIX) to return a long pathnames. In the future, an     }  # #   { output line should probably be split up in 80 character chunks }  # #   { so that records will not be truncated at a printer.            }  # 	   $LineSize 642$  	    list                    : Text;  	   $LineSize 128$  	        { A pointer to the Dcb for the input file }     input_dcb_ptr           : PointerType;          { This is true if we are in a transfer file, else false }     in_transfer_file        : BOOLEAN;          { A pointer to the Dcb for the list file }      list_dcb_ptr            : PointerType;          { This is the name of the list fle }      list_file_name          : Hp1000PathNameType;         { The logical unit returned by routine LogLu }      log_lu                  : String [6];          { This is the buffer through which all messages are sent to }       { or received from the producer. Also, the user command is  }       { placed here before being parsed.                          }      main_buffer             : MainBufferType;      !   { Used only in the main routine this indicates any Nft error }  !    nft_error               : Int16;       !   { Contains flags indicating that parts of a copy command were } ! !   { given but were null. See NullFieldsType for more info       } !    null_fields             : NullFieldsType;         { This is string always equal to '' }     null_string             : String [1];         { This is the name of our program, and its length }     our_pname               : ProgramNameType;      pname_length            : Int16;          { This is the name of the output file }     output_file_name        : Hp1000PathNameType;      !   { This is true if we are picking up the run-string parameters.} ! !   { Used only in the main routine                               } !    pickup_params           : BOOLEAN;          { Record containing information about the producer system }     producer_info           : ProducerInfoType;         { This is a Rsm/1000 error code }     rsm_error               : Int16;       "   { This is used only in the main routine. It gives the number of } " "   { characters in the parameter portion of the run-string.        } "    run_string_chars        : Int16;       "   { This gives the total number of errors that occurred since we  } " "   { were scheduled. This includes all Dscopy commands, including  } " "   { those that begin with a plus sign. For copy commands, at most } " "   { one error will be returned for each transfer attempt. This is } " "   { returned to the caller in procedure CleanupAndTerminate.      } "    total_errors            : Int16;       !   { This is a temp variable used by many routines to implement }  ! !   { triggers.                                                  }  !    trigger_temp            : Int16;          { Global record containing the parsed user command }      user_command_fields     : UserCommandFieldsType;       $Page   #{-------------------------------------------------------------------}  # #{              EXTERNAL & FORWARD ROUTINE DECLARATIONS              }  # #{-------------------------------------------------------------------}  #     PROCEDURE AddOpt     (VAR opts                : IpcOptionsType;           entry_number        : Int16;          arg_code            : Int16;          data_length         : Int16;          data                : Int16;      VAR error               : Int16);      EXTERNAL;      PROCEDURE AdsErrorLookup     (    service             : Int16;          error_number        : Int32;      VAR buffer              : ErrorPacType);     EXTERNAL;      FUNCTION BreakFlag  $ALIAS 'IFBRK'$      : Int16;      EXTERNAL;      { Never call this procedure with a null string }  	PROCEDURE CaseFold 	 
   $FIXED_STRING ON  
    (VAR buffer              : String);  
   $FIXED_STRING OFF 
    EXTERNAL;      PROCEDURE CleanupAndTerminate      (VAR total_errors        : Int16;          nft_error           : Int16);      FORWARD;       PROCEDURE CloseConnectionToProducer      (VAR producer_info       : ProducerInfoType);     FORWARD;       PROCEDURE Cnumd      (    number              : Int16;      VAR number_as_pac       : SixCharsType);     EXTERNAL;      FUNCTION Ds_Rsm_Get_Key      (    session_id          : Int16;      VAR session_key         : DsSessionKeyType)      : Int16;      EXTERNAL;      FUNCTION Ds_Rsm_Release_Key      (VAR session_key         : DsSessionKeyType)      : Int16;      EXTERNAL;      PROCEDURE DS_StoreUrec     (VAR urec_id             : Int16;      VAR urec                : Int16);      EXTERNAL;      PROCEDURE ExecGetRunString  $ALIAS 'EXEC', NOABORT$      (    exec_code           : Int16;          read_or_write       : Int16;      VAR command             : CommandPacType;           max_chars_to_read   : Int16);      EXTERNAL;      PROCEDURE ExecTimeSchedule  $ALIAS 'EXEC', NOABORT$      (    request_code        : Int16;          program_name        : Int16;          resolution          : Int16;          multiple            : Int16;          init_offset         : Int16);      EXTERNAL;      PROCEDURE FmpFileName   
   $FIXED_STRING ON  
    (VAR dcb                 : Int16;      VAR fmp_error           : Int16;      VAR full_pathname       : Hp1000PathNameType);  
   $FIXED_STRING OFF 
    EXTERNAL;      FUNCTION FmpInteractive      (VAR dcb                 : Int16)     : Int16;      EXTERNAL;      	PROCEDURE FmpError 	 
   $FIXED_STRING ON  
    (VAR fmp_error           : Int16;      VAR message             : String);  
   $FIXED_STRING Off 
    EXTERNAL;      PROCEDURE FmpParsePath  
   $FIXED_STRING ON$ 
    (VAR full_pathname       : Hp1000PathNameType;       VAR dirpath             : String2;      VAR filename            : String2;      VAR typex               : String2;      VAR qual                : String2;      VAR seccode             : Int16;      VAR filetype            : Int16;      VAR filesize            : Int16;      VAR reclen              : Int16;      VAR ds                  : String2);      $FIXED_STRING OFF$      EXTERNAL;      FUNCTION FmpRunProgram  
   $FIXED_STRING ON$ 
    (VAR prog_name           : String;       VAR return_parms        : FiveWordsType;      VAR run_name            : String)      $FIXED_STRING OFF$      : Int16;      EXTERNAL;      
FUNCTION FmpSetWorkingDir  
 
   $FIXED_STRING ON$ 
    (VAR string_parm         : String)      $FIXED_STRING OFF$      : Int16;      EXTERNAL;      FUNCTION FmpWorkingDir  
   $FIXED_STRING ON$ 
    (VAR string_parm         : String)      $FIXED_STRING OFF$      : Int16;      EXTERNAL;      
PROCEDURE HandleRunCommand 
    (VAR command_parm        : String;       VAR error_string        : String;       VAR fmp_error           : Int16;      VAR nft_error           : Int16);      FORWARD;       PROCEDURE HandleTransferCommand      (VAR command_parm        : String;       VAR error_string        : String;       VAR end_of_file         : BOOLEAN;      VAR fmp_error           : Int16;      VAR nft_error           : Int16);      FORWARD;       PROCEDURE HandleWorkingDirCommand      (VAR command_parm        : String;       VAR error_string        : String;       VAR fmp_error           : Int16);      FORWARD;       	PROCEDURE InitOpt  	    (VAR opt                 : IpcOptionsType;           total_entries       : Int16;      VAR error               : Int16);      EXTERNAL;      PROCEDURE InStateIdle      (    event               : Int16);      FORWARD;       PROCEDURE InStateWaitForAinit      (    event               : Int16;      VAR state               : StateTypes;       VAR main_buffer         : MainBufferType;       VAR ipc_error           : Int32;      VAR nft_error           : Int16);      FORWARD;       PROCEDURE InStateWaitForAnft     (    event               : Int16;      VAR state               : StateTypes;       VAR main_buffer         : MainBufferType;       VAR ipc_error           : Int32;      VAR nft_error           : Int16);      FORWARD;       
PROCEDURE IpcConnect 
    (VAR socket_descr        : Int32;          dest_descr          : Int32;      VAR flags               : IpcFlagsType;       VAR options             : IpcOptionsType;       VAR connect_descr       : Int32;      VAR result              : Int32);      EXTERNAL;      
PROCEDURE IpcControl 
    (VAR descr               : Int32;          request             : Int32;          write_data          : Int16;          write_length        : Int32;      VAR read_data           : Int16;      VAR read_length         : Int32;      VAR flags               : IpcFlagsType;       VAR result              : Int32);      EXTERNAL;      
PROCEDURE IpcCreate  
    (    socket_kind         : Int32;          protocol            : Int32;      VAR flags               : IpcFlagsType;       VAR options             : IpcOptionsType;       VAR descriptor          : Int32;      VAR result              : Int32);      EXTERNAL;      	PROCEDURE IpcDest  	    (    socket_kind         : Int32;      VAR node_name           : NodeNamePacType;          node_name_len       : Int32;          protocol            : Int32;          protocol_addr       : Int16;          protocol_length     : Int32;      VAR flags               : IpcFlagsType;       VAR options             : IpcOptionsType;       VAR path_descr          : Int32;      VAR ipc_error           : Int32);      EXTERNAL;      PROCEDURE IpcNodeName      (VAR local_node_name     : NodeNamePacType;      VAR node_name_len       : Int32;      VAR ipc_error           : Int32);      EXTERNAL;      	PROCEDURE IpcRecv  	    (VAR connect_descr       : Int32;      VAR buffer              : MainBufferType;       VAR data_length         : Int32;      VAR flags               : IpcFlagsType;       VAR options             : IpcOptionsType;       VAR result              : Int32);      EXTERNAL;      	PROCEDURE IpcSend  	    (VAR connect_descr       : Int32;      VAR buffer              : MainBufferType;           data_length         : Int32;      VAR flags               : IpcFlagsType;       VAR options             : IpcOptionsType;       VAR result              : Int32);      EXTERNAL;      PROCEDURE IpcShutDown      (    descr               : Int32;      VAR flags               : IpcFlagsType;       VAR options             : IpcOptionsType;       VAR result              : Int32);      EXTERNAL;      	PROCEDURE LogEvent 	    (    nft_log_error_code  : Int16;          instance            : Int16;          parm1               : Int32;          parm2               : Int32;          parm3               : Int32);      FORWARD;       FUNCTION LogLu     (VAR system_lu           : Int16)     : Int16;      EXTERNAL;      FUNCTION Min     (    first               : Int16;          second              : Int16)     : Int16;      FORWARD;       FUNCTION MyIdAdd     : Int16;      EXTERNAL;      
PROCEDURE ParseCopyCommand 
    (VAR command             : String;       VAR user_command_fields : UserCommandFieldsType;      VAR null_fields         : NullFieldsType;       VAR option_name         : String;       VAR nft_error           : Int16);      FORWARD;       PROCEDURE ParseOptions     (VAR command             : String;       VAR user_command_fields : UserCommandFieldsType;      VAR null_fields         : NullFieldsType;       VAR opt_name            : String;       VAR nft_error           : Int16);      FORWARD;       PROCEDURE ParseSourceOrTargetSpec      (    source_or_target    : SourceOrTargetType;       VAR command             : String;       VAR file_name           : FileNameType;       VAR logon               : LogonType;      VAR node_name           : NodeNameType;       VAR null_fields         : NullFieldsType;       VAR nft_error           : Int16);      FORWARD;       PROCEDURE PasDcbAddress1   $ALIAS 'Pas.DcbAddress1'$     (VAR input_dcb_ptr       : PointerType;      VAR file_name           : Text);     EXTERNAL;      FUNCTION PasStringData1   $ALIAS 'Pas.StringData1'$      (VAR string_var          : String)   
   : CommandPacPtr;  
    EXTERNAL;      PROCEDURE Pname      (VAR our_pname           : ProgramNameType);      EXTERNAL;      
PROCEDURE PrintErrorOrWarn 
    (    error_or_warn       : ErrorOrWarnType;      VAR which_file          : Text;           fmp_error_parm      : Int16;          nft_error           : Int16;          ipc_error           : Int32;          rsm_error           : Int16;      VAR string_parm         : String);     FORWARD;       PROCEDURE PrintMessageFields     (VAR main_buffer         : MainBufferType);     FORWARD;       PROCEDURE Prtn     (VAR return_params       : ReturnParamsType);     EXTERNAL;      PROCEDURE PromptAndGetBreakRequest     (VAR event               : Int16;      VAR cursor_end_of_line  : BOOLEAN);      FORWARD;       PROCEDURE SetUpProducerConnection      (VAR producer_info       : ProducerInfoType;       VAR user_command_fields : UserCommandFieldsType;      VAR new_connection      : BOOLEAN;      VAR ipc_error           : Int32;      VAR nft_error           : Int16);      FORWARD;       PROCEDURE ShowGlobalDefaults     (VAR global_defaults     : GlobalDefaultsType);     FORWARD;       
PROCEDURE SquezeOutSpaces  
    (VAR string_parm         : String);     FORWARD;       
PROCEDURE SquezeOutQuotes  
    (VAR string_parm         : String);     FORWARD;       PROCEDURE SubstCharUnlessQuoted      (VAR string_parm         : String;           start_pos           : Int16;          end_pos             : Int16;          old_char            : CHAR;           new_char            : CHAR);     FORWARD;           $Page   #{-------------------------------------------------------------------}  # #{                           ASSIGN FIELDS                           }  # #{-------------------------------------------------------------------}  # !{ Based on the parameter either assign the global command defaults ! { to the user_command_fields or the other way around.   {   { Parameters:   {   {     where_to_where (Input)  {        Will be either USER_TO_GLOBAL or GLOBAL_TO_USER. This  {        indicates which way the assignment is to be made   {   {     user_command_fields (Input/Output)  !{        If these fields are being assigned to the global_defaults ! {        then this will carry in info, else will be undefined   {   {     global_defaults (Input/Ouput)   {        If the global defaults are to be assigned to the    {        user_command_fields then this will carry in info, else    
{        will be undefined 
 {   
{     null_fields (Input)  
 {        This record contains flags indicating whether the  {        corresponding fields of the user command were null   {        and therefore the global default should be cleared.  {        For example, a command of:  File[]> TO File[Acct]  {        would have a flag set for the source logon and node  {        but no flags would be set for the target spec. Note  {        here that a source logon string of length 0 does not   {        tell us if the square brackets were given or not.  {}  PROCEDURE  AssignFields      (    where_to_where      : UserOrGlobalType;       VAR user_command_fields : UserCommandFieldsType;      VAR global_defaults     : GlobalDefaultsType;       VAR null_fields         : NullFieldsType);      BEGIN      WITH global_defaults, user_command_fields DO         BEGIN         IF where_to_where = GLOBAL_TO_USER THEN            BEGIN  "         { Copy fields from global_defaults to user_command_fields } "          uc_slogon      := gd_slogon;            uc_snode       := gd_snode;           uc_tlogon      := gd_tlogon;            uc_tnode       := gd_tnode;           uc_ichar       := gd_ichar;           uc_ichar_value := gd_ichar_value;           uc_schar       := gd_schar;           uc_schar_value := gd_schar_value;           uc_fcode       := gd_fcode;               uc_data_type   := gd_data_type;           uc_file_organ  := gd_file_organ;            uc_fsize       := gd_fsize;           uc_record_type := gd_record_type;           uc_rsize       := gd_rsize;           uc_toptns      := gd_toptns;            uc_xfer_type   := gd_xfer_type;               uc_compress    := gd_compress;            uc_move        := gd_move;            uc_quiet       := gd_quiet;           uc_strip       := gd_strip;           END        ELSE           BEGIN  "         { Assign user_command_fields to global_defaults. Here we  } " "         { must make use of the null_fields parameter. If the flag } " "         { in null_fields is set which corresponds to the field in } " "         { global defaults then clear that field.                  } "          IF StrLen (uc_slogon) > 0 THEN               gd_slogon := uc_slogon           ELSE IF null_fields.nf_slogon THEN               gd_slogon := '';               IF StrLen (uc_snode) > 0 THEN              gd_snode := uc_snode           ELSE IF null_fields.nf_snode THEN              gd_snode := '';                IF StrLen (uc_tlogon) > 0 THEN               gd_tlogon := uc_tlogon           ELSE IF null_fields.nf_tlogon THEN               gd_tlogon := '';               IF StrLen (uc_tnode) > 0 THEN              gd_tnode := uc_tnode           ELSE IF null_fields.nf_tnode THEN              gd_tnode := '';                IF StrLen (uc_ichar) > 0 THEN  	            BEGIN  	             gd_ichar       := uc_ichar;               gd_ichar_value := uc_ichar_value;               END            ELSE IF null_fields.nf_ichar THEN  	            BEGIN  	             gd_ichar := '';               gd_ichar_value.valid := FALSE;              END;               IF StrLen (uc_schar) > 0 THEN  	            BEGIN  	             gd_schar       := uc_schar;               gd_schar_value := uc_schar_value;               END            ELSE IF null_fields.nf_schar THEN  	            BEGIN  	             gd_schar := '';               gd_schar_value.valid := FALSE;              END;               IF uc_fcode <> 0 THEN              gd_fcode := uc_fcode           ELSE IF null_fields.nf_fcode THEN  
            gd_fcode := 0; 
              IF uc_data_type > 0 THEN               gd_data_type := uc_data_type;            IF uc_file_organ > 0 THEN              gd_file_organ := uc_file_organ;                IF uc_fsize > 0 THEN               gd_fsize := uc_fsize           ELSE IF null_fields.nf_fsize THEN  
            gd_fsize := 0; 
              IF uc_record_type > 0 THEN               gd_record_type := uc_record_type;            IF uc_rsize > 0 THEN               gd_rsize := uc_rsize           ELSE IF null_fields.nf_rsize THEN  
            gd_rsize := 0; 
              IF uc_toptns.whole_byte > 0 THEN               gd_toptns := uc_toptns;            IF uc_xfer_type > 0 THEN   	            BEGIN  	             gd_xfer_type := uc_xfer_type;               { If we are setting the global transient flag }               { then clear all interchange attributes       }               IF uc_xfer_type = TRANSIENT THEN  
               BEGIN 
                gd_record_type := 0;                  gd_file_organ  := 0;                  gd_data_type   := 0;                  gd_rsize       := 0;                  gd_fsize       := 0;                  END;  { IF }               END; { IF }                IF uc_compress THEN              gd_compress := TRUE;           IF uc_move THEN              gd_move := TRUE;  
         IF uc_quiet THEN  
             gd_quiet := TRUE;   
         IF uc_strip THEN  
             gd_strip := TRUE;            END;  { ELSE }       
      END;  { WITH } 
     END;  { AssignFields }          $Page   #{-------------------------------------------------------------------}  # #{                         BUILD AND SEND MSG                        }  # #{-------------------------------------------------------------------}  # !{ Build and send a message given by message_type. The information  ! { needed to build the message will be contained mostly in the   { user_command_fields record.   {   { Parameters:   {   
{     message_type (Input) 
 {        Gives the message type to be built   {   
{     main_buffer (Input)  
 {        This is where the message is built and sent  {   {     user_command_fields (Input)   {        Carries in the fields of the user command which are  {        used to build some messages  {   {     ipc_error (Output)   {        Returns an Ipc error in sending the message if non-zero   {   {     nft_error (Output)  {        Returns any Nft error that occurred if non-zero  {}  
PROCEDURE  BuildAndSendMsg 
    (    message_type        : Byte;       VAR main_buffer         : MainBufferType;       VAR user_command_fields : UserCommandFieldsType;      VAR ipc_error           : Int32;      VAR nft_error           : Int16);       $Page   #   {----------------------------------------------------------------}  # #   { (Local)                BUILD RINIT MSG                 (Local) }  # #   {----------------------------------------------------------------}  # "   { Build an Rinit message to be sent to the producer. Some of the  "    { information we need is in user_command_fields.      {}      PROCEDURE BuildRinitMsg;          VAR        i : Int16;         BEGIN        WITH main_buffer, msg, rinit_msg, user_command_fields DO           BEGIN           { Fill in the fixed length fields }           msg_type.nft_type    := RINIT;            msg_type.protocol_id := NFT;            debug_flags.byt      := 0;            misc_flags.byt       := 0;            system_type          := RTE;            op_sys_version       := 0;            buffer_size          := MAX_BUFFER_BYTES;           capability_mask.word := 0;            sys_specif_capa_mask := 0;                { Fill in the string fields }           logon_ptr := MIN_RINIT_BYTES;           FOR i := 1 TO StrLen (uc_slogon) DO  !            main_buffer.chars [logon_ptr + i -1] := uc_slogon [i]; !              logon_pass_ptr := logon_ptr + StrLen (uc_slogon);           session_id_ptr := logon_pass_ptr;      !         { If the uc_src_session field is non-zero (a valid key) } ! !         { then insert it into the msg. Either this OR uc_slogon } ! !         { will be inserted in the message, not both.            } !          IF (uc_src_session.words [1] <> 0) OR              (uc_src_session.words [2] <> 0) OR              (uc_src_session.words [3] <> 0) THEN  	            BEGIN  	             FOR i := 0 TO 5 DO                 main_buffer.bytes [session_id_ptr + i] :=                    uc_src_session.bytes [i + 1];               shared_session_ptr := session_id_ptr + 6;               END            ELSE   	            BEGIN  	             shared_session_ptr := session_id_ptr;   
            END;  { ELSE } 
              end_ptr := shared_session_ptr;                msg_length := end_ptr;            END;  { WITH main_buffer }       
   END;  { BuildRinitMsg } 
     $Page   #   {----------------------------------------------------------------}  # #   { (Local)                 BUILD RNFT MSG                 (Local) }  # #   {----------------------------------------------------------------}  # !   { Build an Rnft message to be sent to the producer. Almost all  !     { the info for the message is taken from user_command_fields.      {}   
   PROCEDURE BuildRnftMsg; 
        TYPE         IntAsCharsType = PACKED RECORD           CASE BOOLEAN OF              TRUE : (word  : Int16);               FALSE: (char1 : CHAR;                       char2 : CHAR);        END;         VAR        i            : Int16;         int_as_chars : IntAsCharsType;         BEGIN        WITH main_buffer, msg, rnft_msg, user_command_fields DO            BEGIN           { Fill in the fixed length fields }           msg_type.nft_type           := RNFT;            msg_type.protocol_id        := NFT;           force_store_options         := uc_xfer_type;            data_type                   := uc_data_type;            record_type                 := uc_record_type;            file_organiz                := uc_file_organ;           record_length               := uc_rsize;            number_records              := uc_fsize;            consumer_storage.whole_byte := 0;           consumer_storage.append     := uc_toptns.append;            consumer_storage.overwrite  := uc_toptns.overwrite;           consumer_storage.replace    := uc_toptns.replace;  !         consumer_storage.transient  := uc_xfer_type = TRANSIENT;  !          producer_options.whole_byte := 0;           producer_options.move       := uc_move;           producer_options.strip      := uc_strip;            producer_options.compress   := uc_compress;           checkpoint_interval         := 0;               { Fill in the SCHAR field }           schar_ptr := MIN_RNFT_BYTES;            IF uc_schar_value.valid THEN   	            BEGIN  	             chars [schar_ptr] := Chr (uc_schar_value.int);              ichar_ptr         := schar_ptr + 1;               END            ELSE   	            BEGIN  	             FOR i := 1 TO StrLen (uc_schar) DO                 chars [schar_ptr + i - 1] := uc_schar [i];               ichar_ptr := schar_ptr + StrLen (uc_schar);   
            END;  { ELSE } 
              { Fill in the ICHAR field }           IF uc_ichar_value.valid THEN   	            BEGIN  	             chars [ichar_ptr] := Chr (uc_ichar_value.int);              source_file_ptr   := ichar_ptr + 1;               END            ELSE   	            BEGIN  	             FOR i := 1 TO StrLen (uc_ichar) DO                 chars [ichar_ptr + i - 1] := uc_ichar [i];               source_file_ptr := ichar_ptr + StrLen (uc_ichar);   
            END;  { ELSE } 
              { Fill in the SOURCE FILE field }           FOR i := 1 TO StrLen (uc_sfile) DO               chars [source_file_ptr + i -1] := uc_sfile [i];       #         source_file_pass_ptr := source_file_ptr + StrLen (uc_sfile);  #          source_file_dev_ptr  := source_file_pass_ptr;               { Fill in the TARGET NODE NAME field }            consumer_name_ptr := source_file_dev_ptr;           FOR i := 1 TO StrLen (uc_tnode) DO               chars [consumer_name_ptr + i -1] := uc_tnode [i];                { Fill in the TARGET FILE field }  !         target_file_ptr := consumer_name_ptr + StrLen (uc_tnode); !          FOR i := 1 TO StrLen (uc_tfile) DO               chars [target_file_ptr + i -1] := uc_tfile [i];       #         target_file_pass_ptr := target_file_ptr + StrLen (uc_tfile);  #          target_file_dev_ptr  := target_file_pass_ptr;               { Fill in the TARGET LOGON field }            cons_logon_ptr := target_file_dev_ptr;            FOR i := 1 TO StrLen (uc_tlogon) DO              chars [cons_logon_ptr + i -1] := uc_tlogon [i];       "         cons_logon_pass_ptr := cons_logon_ptr + StrLen (uc_tlogon); "          cons_session_id_ptr := cons_logon_pass_ptr;      "         { Fill in the TARGET SESSION field. If uc_targ_session is } " "         { non-zero (a valid session key) then insert it in the    } " "         { message. Either this OR uc_tlogon will be inserted in   } " "         { the message, not both.                                  } "          IF (uc_targ_session.words [1] <> 0) OR               (uc_targ_session.words [2] <> 0) OR               (uc_targ_session.words [3] <> 0) THEN   	            BEGIN  	             FOR i := 0 TO 5 DO                 bytes [cons_session_id_ptr + i] :=                     uc_targ_session.bytes [i + 1];               cons_shared_session_ptr := cons_session_id_ptr + 6;                END            ELSE   	            BEGIN  	             cons_shared_session_ptr := cons_session_id_ptr;   
            END;  { ELSE } 
              source_file_code_ptr := cons_shared_session_ptr;                { Fill in the FCODE field if is non-zero }            IF uc_fcode = 0 THEN               end_ptr := source_file_code_ptr            ELSE   	            BEGIN  	             int_as_chars.word := uc_fcode;  !            chars [source_file_code_ptr]    := int_as_chars.char1; ! !            chars [source_file_code_ptr +1] := int_as_chars.char2; !             end_ptr := source_file_code_ptr +2;   
            END;  { ELSE } 
              msg_length := end_ptr;            END;  { WITH main_buffer }       
   END;  { BuildRnftMsg }  
     $Page   
BEGIN  { BuildAndSendMsg } 
        CASE message_type OF         RINIT:           BEGIN           BuildRinitMsg;            END;  { RINIT }            RNFT:            BEGIN           BuildRnftMsg;           END;  { RNFT }             OTHERWISE            BEGIN           { Build either: ABORTMSG, CANCEL, RPROGRESS }           WITH main_buffer.msg, msg_type DO  	            BEGIN  	             msg_length  := 4; { Bytes }               nft_type    := message_type;              protocol_id := NFT;   
            END;  { WITH } 
          END;  { OTHERWISE }      
      END;  { CASE } 
        { Now send the message we just built }   
   dummy_flags := 0; 
    IpcSend (producer_info.pi_socket_descr, main_buffer,               main_buffer.msg.msg_length, dummy_flags,              dummy_options, ipc_error);         IF ipc_error = 0 THEN  
      nft_error := 0 
    ELSE         BEGIN          { Assume that any Ipc error means the connection dropped }         nft_error := I_P_CONNECTION_DOWN;         CloseConnectionToProducer (producer_info);        LogEvent (I_LOG_CONCT_DOWN, 1, ipc_error, 0, 0);  
      END;  { ELSE } 
     
END;  { BuildAndSendMsg }  
         $Page   $Range Off  "{------------------------------------------------------------------} " "{                            CATCH ERROR                           } " "{------------------------------------------------------------------} "  { This is the Pascal error catcher procedure. If an error occurs   "{ that we can handle then just set a flag indicating that we entered " { this procedure and exit. Also, if an Fmp error occurred then  { return the Fmp error code.  {   { Parameters:   {   {    See the Pascal Reference Manual  {}  PROCEDURE  CatchError  $ALIAS 'Pas.ErrorCatcher'$      (error_type    : CatchErrorType;   
    error_number  : Int16; 
 
    line_number   : Int16; 
     file_name     : LogicalFileNameType;      file_name_len : Int16);       BEGIN      IF converting_to_integer OR        opening_file          OR        reading_from_input    THEN        BEGIN         { We can handle these errors so just return }         entered_error_handler := TRUE;            IF error_type = FILE_ERROR THEN            global_fmp_error := error_number;  	      END  { IF }  	    ELSE         BEGIN   #      { An unexpected error occurred so bombout. This first piece   }  # #      { of code prevents us from entering an infinite loop due to   }  # #      { a run-time error in PrintErrorOrWarn. In general, no Pascal }  # #      { I/O should be done from within an error catcher because of  }  # #      { this possibility. For us to check if the error catcher was  }  # #      { called in every place that it could be, and then to call    }  # #      { PrintErrorOrWarn from there would be very expensive as well }  # #      { as difficult.                                               }  #       entry_count := entry_count + 1;         IF entry_count > 1 THEN            CleanupAndTerminate (total_errors, INTERNAL_ERROR);            LogEvent (I_LOG_INTERNAL_ERROR, 1, Ord (error_type),                  error_number, line_number);             total_errors := total_errors + 1;             PrintErrorOrWarn (ERROR, list, 0, INTERNAL_ERROR,                           0, 0, null_string);         IF list_file_name <> output_file_name THEN            PrintErrorOrWarn (ERROR, output, 0, INTERNAL_ERROR, 0,                               0, null_string);             CleanupAndTerminate (total_errors, INTERNAL_ERROR);   
      END;  { ELSE } 
     
END;  { CatchError } 
         $Page   "{------------------------------------------------------------------} " "{                 CHECK FOR EXTERNAL EVENT NO WAIT                 } " "{------------------------------------------------------------------} " { Perform a non-blocking receive to determine if a message has  !{ arrived on the producer connection. May also find the connection ! !{ is down. In either case return the event if one occurred. There  ! { is no need to use IpcSelect here since there is only one  { connection.   {   { Parameters:   {   {     producer_info (Input)   {        Global record carrying the socket_descr identifying  {        the connection.  {   {     event_present (Output)   {        Returns true if an event exists. May be either an error   {        or an Nft message type   {   
{     event (Output) 
 {        Returns the event if event_present is true   {   {     ipc_error (Output)  "{        IF non-zero, returns an Ipc error that occurred. This will  " {        be non-zero if and only if event is CONNECTION_DOWN  {   
{     main_buffer (Output) 
  {        If a message was received, it is returned here in full    {}  PROCEDURE  CheckForExternalEventNoWait     (VAR producer_info : ProducerInfoType;       VAR event_present : BOOLEAN;      VAR event         : Int16;      VAR ipc_error     : Int32;      VAR main_buffer   : MainBufferType);      VAR      dummy_flags : IpcFlagsType;     data_length : Int32;      dummy       : Int16;      temp_length : Int32;       BEGIN   
   event_present := FALSE; 
        WITH producer_info DO        BEGIN         { Change socket to no-block mode for the IpcRecv call }         dummy_flags := 0;         temp_length := 0;          IpcControl (pi_socket_descr, IPC_ENABLE_ASYNCH_MODE, 0, 0,                     dummy, temp_length, dummy_flags, ipc_error);            IF ipc_error = 0 THEN            BEGIN           { Try to do a receive on the connection }           data_length := MAX_BUFFER_BYTES;   
         dummy_flags := 0; 
          IpcRecv (pi_socket_descr, main_buffer, data_length,                    dummy_flags, dummy_options, ipc_error);       #         { Ignore the Ipc error that indicates nothing was received }  #          IF ipc_error = IPC_ERR_WOULD_BLOCK THEN  
            ipc_error := 0 
          ELSE               event_present := TRUE;                   IF ipc_error = 0 THEN  	            BEGIN  	 $            { Change the socket to blocking mode. We do not want to do } $ $            { asynchronous IpcSends if needed later, and we cannot use } $ $            { IpcControl to set the socket to sync mode before IpcSend } $ $            { because IpcSend is in a different segment which has no   } $ $            { room for IpcControl.                                     } $             temp_length := 0;               dummy_flags := 0;   #            IpcControl (pi_socket_descr, IPC_ENABLE_SYNCH_MODE, 0, 0,  # "                        dummy, temp_length, dummy_flags, ipc_error); "             END;  { IF ipc_error }           END;  { IF ipc_error }       
      END;  { WITH } 
        { Set event_present for any Ipc error above }  
   IF ipc_error <> 0 THEN  
       event_present := TRUE;         IF event_present THEN        BEGIN         IF ipc_error <> 0 THEN           event := CONNECTION_DOWN         ELSE           BEGIN            { If the message length field is bad then return the }              { error, else return the Nft message type.           }             IF data_length = main_buffer.msg.msg_length THEN               event := main_buffer.msg.msg_type.nft_type           ELSE   	            BEGIN  	 "            { The message length field does not match what we got }  "              PrintErrorOrWarn (ERROR, list, 0, INTERNAL_ERROR, 0,                                 0, null_string);              IF list_file_name <> output_file_name THEN  "               PrintErrorOrWarn (ERROR, list, 0, INTERNAL_ERROR, 0,  "                                  0, null_string);               LogEvent (I_LOG_BAD_MSG_LENGTH, 1,                        main_buffer.msg.msg_type.nft_type,                         main_buffer.msg.msg_length, data_length);                total_errors := total_errors + 1;                CleanupAndTerminate (total_errors, INTERNAL_ERROR);                END;  { ELSE of IF ipc_error }           END;  { ELSE of IF ipc_error }         END;  { IF event_present }      END;  { CheckForExternalEventNoWait }           $Page   "{------------------------------------------------------------------} " "{                       CLEANUP AND TERMINATE                      } " "{------------------------------------------------------------------} " { Close connection, files, shutdown sockets and terminate.  {   {  Parameters:  {   
{     total_errors (Input) 
 {        A number to be returned to the caller. Refer to the  {        global declaration of "total_errors" for info.   {   {     nft_error (Input)   {        A Nft error code returned to the caller. It gives the  !{        result of carrying out the user command. It will only be  ! !{        picked up by the Dscopy intrinsic. If multiple transfers  ! {        were attempted then this gives the result of the last  {        transfer in the group.   {}  PROCEDURE  CleanupAndTerminate     (VAR total_errors : Int16;           nft_error    : Int16);      VAR      ipc_error    : Int32;     return_parms : ReturnParamsType;       BEGIN      CloseConnectionToProducer (producer_info);          { Shut down the call socket }  
   dummy_flags := 0; 
    IpcShutDown (call_socket_descr, dummy_flags, dummy_options,                  ipc_error);          { Close all files }     Close (list);  	   Close (input);  	 
   Close (log_file); 
 	   Close (output); 	     !   { Return the Nft error and number files transferred to father } !    return_parms [0] := total_errors;     return_parms [1] := nft_error;      Prtn (return_parms);          { Goto the end of the main routine }      GOTO 999;      END;  { CleanupAndTerminate }           $Page   #{-------------------------------------------------------------------}  # #{                      CLEAR COMMAND FIELDS                         }  # #{-------------------------------------------------------------------}  # { Clear all of the fields of the user_command_fields  {}  PROCEDURE  ClearCommandFields      (VAR user_command_fields : UserCommandFieldsType);       VAR   	   temp  : Int16;  	     BEGIN      WITH user_command_fields DO        BEGIN         uc_sfile             := '';         uc_slogon            := '';         uc_snode             := '';         uc_tfile             := '';         uc_tlogon            := '';         uc_tnode             := '';         uc_ichar             := '';         uc_ichar_value.valid := FALSE;        uc_schar             := '';         uc_schar_value.valid := FALSE;            uc_fcode             := 0;        uc_data_type         := 0;        uc_file_organ        := 0;        uc_fsize             := 0;        uc_record_type       := 0;        uc_rsize             := 0;        uc_toptns.whole_byte := 0;        uc_xfer_type         := 0;            uc_compress          := FALSE;        uc_move              := FALSE;        uc_quiet             := FALSE;        uc_strip             := FALSE;            FOR temp := 1 TO SESSION_KEY_WORDS DO            BEGIN           uc_src_session.words [temp] := 0;           uc_targ_session.words [temp] := 0;            END;  { FOR }            END;  { WITH user_command_fields }      END;  { ClearCommandFields }          $Page   #{-------------------------------------------------------------------}  # #{                      CLEAR GLOBAL DEFAULTS                        }  # #{-------------------------------------------------------------------}  # { Clear all of the fields of the global_defaults  {}  PROCEDURE  ClearGlobalDefaults     (VAR global_defaults : GlobalDefaultsType);      BEGIN   
   WITH global_defaults DO 
       BEGIN         gd_slogon            := '';         gd_snode             := '';         gd_tlogon            := '';         gd_tnode             := '';         gd_ichar             := '';         gd_ichar_value.valid := FALSE;        gd_schar             := '';         gd_schar_value.valid := FALSE;            gd_fcode             := 0;        gd_data_type         := 0;        gd_file_organ        := 0;        gd_fsize             := 0;        gd_record_type       := 0;        gd_rsize             := 0;        gd_toptns.whole_byte := 0;        gd_xfer_type         := 0;            gd_compress          := FALSE;        gd_move              := FALSE;        gd_quiet             := FALSE;        gd_strip             := FALSE;        END;  { WITH global_defaults }      END;  { ClearGlobalDefaults }           $Page   "{------------------------------------------------------------------} " "{                    CLOSE CONNECTION TO PRODUCER                  } " "{------------------------------------------------------------------} " !{ Close the connection to the producer if we are connected. If the ! "{ connection was aborted by the transport then the socket will still " { be there.   {   { Parameters:   {   {     producer_info (Input)   !{        Global record that gives info about the producer. We need ! {        the connected flag and the socket descriptor.  {}  PROCEDURE  CloseConnectionToProducer     (VAR producer_info : ProducerInfoType);      VAR      ipc_error : Int32;       BEGIN      IF producer_info.pi_connected THEN         BEGIN         { Abrupt close is the default - which is what we want }         dummy_flags := 0;         IpcShutDown (producer_info.pi_socket_descr, dummy_flags,                     dummy_options, ipc_error);         producer_info.pi_connected := FALSE;  	      END;  { IF } 	     END;  { CloseConnectionToProducer }           $Page   #{-------------------------------------------------------------------}  # #{                       FILL IN NULL FIELDS                         }  # #{-------------------------------------------------------------------}  # !{ This procedure makes interpretations of null node names and null ! #{ logons as given in a user copy command. If either node name is null  # !{ then the local node name is inserted. If either logon string is  ! { null and the associated node name is the local node then the  "{ session key associated with the initiator's session will be placed " "{ in user command fields. This will then be passed to the server in  " !{ a message. If we ever allocate a session key for the session we  !  { are running in then we will record it in our user record, and    { UPLIN will release it.  {   { Parameters:   {   {     user_command_fields (Input/Output)  "{        Carries in the fields of the user copy command. On return,  " "{        the node names and/or session keys may have been filled in. " {   {     rsm_error (Output)  {        Returns a DsRsm/1000 session error if non-zero   {   {     ipc_error (Output)  {        Returns an Ipc error if non-zero   {   {     nft_error (Output)  #{        Returns an Nft error (Nft/1000 or Nft Protocol) if non-zero.  # "{        NOTE: Any non-zero error return is to be considered fatal.  " {}  PROCEDURE  FillInNullFields      (VAR user_command_fields  : UserCommandFieldsType;       VAR rsm_error            : Int16;       VAR ipc_error            : Int32;       VAR nft_error            : Int16);      LABEL      99;   { Labels end of the procedure }      VAR   
   error          : Int16; 
    local_name     : NodeNameType;      my_urec        : UserRecord;   
   my_urec_id     : Int16; 
 
   node_length    : Int32; 
 
   temp           : Int16; 
    temp_pac       : NodeNamePacType;  
   wkmp           : Int16; 
     BEGIN   	   nft_error := 0; 	 	   rsm_error := 0; 	        { Get the local node name and convert it to a string }      IpcNodeName (temp_pac, node_length, ipc_error);  
   IF ipc_error <> 0 THEN  
       BEGIN         nft_error := UNABLE_TO_INITIALIZE;        GOTO 99;        END;     SetStrLen (local_name, node_length);      FOR temp := 1 TO node_length DO        local_name [temp] := temp_pac [temp];          WITH user_command_fields DO        BEGIN   $      { If the source node name was null then use the local node name }  $       IF StrLen (uc_snode) = 0 THEN            uc_snode := local_name         ELSE           CaseFold (uc_snode);       $      { If the target node name was null then use the local node name }  $       IF StrLen (uc_tnode) = 0 THEN            uc_tnode := local_name         ELSE           CaseFold (uc_tnode);       #      { If the user's source node name is a valid sub-portion of the } # #      { full local node name then use the full version.              } #        IF (StrLen (uc_snode) < StrLen (local_name))           AND             (uc_snode = Str (local_name, 1, StrLen (uc_snode))) AND   !         (local_name [StrLen (uc_snode) +1] = PERIOD)        THEN  !          uc_snode := local_name;      #      { If the user's target node name is a valid sub-portion of the } # #      { full local node name then use the full version.              } #        IF (StrLen (uc_tnode) < StrLen (local_name))           AND             (uc_tnode = Str (local_name, 1, StrLen (uc_tnode))) AND   !         (local_name [StrLen (uc_tnode) +1] = PERIOD)        THEN  !          uc_tnode := local_name;            { Set the flags if the node names are local }         uc_snode_local := uc_snode = local_name;        uc_tnode_local := uc_tnode = local_name;      #      { If either logon string is null and the associated node name  } # #      { is the same as the local node then get a session key for our } # #      { session that the producer or consumer can use to attach to   } # #      { our session.                                                 } #       IF ((StrLen (uc_slogon) = 0) AND uc_snode_local) OR            ((StrLen (uc_tlogon) = 0) AND uc_tnode_local) THEN            BEGIN  #         { If we've already allocated a session key then don't again } #          IF NOT initr_session_key.valid THEN  	            BEGIN  	             DS_EnterCritical (wkmp, error);               IF error <> 0 THEN  
               BEGIN 
                nft_error := UNABLE_TO_INITIALIZE;                  GOTO 99;   
               END;  
 "            rsm_error := Ds_Rsm_Get_Key (0, initr_session_key.key);  "             DS_LeaveCritical (wkmp);      $            { If we're not running under MultiUser then clear the key. } $ $            { We will pass this session key on to the server who will  } $ $            { see that the session key is invalid (all zeros) and will } $ $            { not attempt to attach to the session.                    } $             IF rsm_error = DS_RSM_NOT_MULTIUSER THEN  
               BEGIN 
                FOR temp := 1 TO SESSION_KEY_WORDS DO                    initr_session_key.key.words [temp] := 0;                 initr_session_key.valid := TRUE;                  END   { IF }               ELSE  
               BEGIN 
 $               { Now enter the session key we just allocated into our  } $ $               { user record. Since the session key is a resource that } $ $               { must be deallocated when we terminate, we must record } $ $               { it in a stable location. We will not normally release } $ $               { the entry from the DsRsm tables ourself. UPLIN will   } $ $               { see a key in our user record when we terminate, and   } $ $               { will call DS_RsmLogoff as usual. In this case however,} $ $               { there is no session that will be logged off; the only } $ $               { action will be to release the session key.            } $                IF rsm_error = 0 THEN                    BEGIN                     DS_EnterCritical (wkmp, error);                     IF error <> 0 THEN  
                     BEGIN 
                      nft_error := UNABLE_TO_INITIALIZE;                        GOTO 99;                        END;  { IF error }       $                  FindUserRecord (MyIdAdd, my_urec_id, my_urec, error);  $                   ipc_error := error;                         IF ipc_error = 0 THEN   
                     BEGIN 
 "                     { Stuff the session key into our user record }  "                      FOR temp := 1 TO SESSION_KEY_WORDS DO                          BEGIN                           my_urec.ur_sessionkey [temp] :=                              initr_session_key.key.words [temp];                          END;  { FOR }                        DS_StoreUrec (my_urec_id, my_urec.int);                       END;  { IF error }       $                  { If we could not put the key in our user record then} $ $                  { release the binding in the DsRsm tables ourself.   } $                   IF ipc_error <> 0 THEN  $                     error := Ds_Rsm_Release_Key (initr_session_key.key) $                   ELSE                       initr_session_key.valid := TRUE;                         DS_LeaveCritical (wkmp);                    END;  { IF rsm_error }                     { Bailout on any error }                  IF (rsm_error <> 0) OR (ipc_error <> 0) THEN                     BEGIN                      LogEvent (I_LOG_CANT_INITIALIZE, 1, ipc_error,                               rsm_error, 0);  #                  { Clear the rsm_error code if it contains a Memory } # #                  { Management error code since these errors are not } # #                  { documented. Note that we do log it however.      } #                   IF rsm_error < DS_RSM_ERROR_BASE THEN                        rsm_error := 0;                    nft_error := UNABLE_TO_INITIALIZE;  
                  GOTO 99; 
                   END;  { IF }                 END;  { ELSE of IF rsm_error }               END;  { IF NOT initr_session_key }      #         { If the source logon string is null and the source node is } # #         { the local node then send the session key to the producer. } #          IF (StrLen (uc_slogon) = 0) AND uc_snode_local THEN              uc_src_session := initr_session_key.key;      #         { If the target logon string is null and the target node is } # #         { the local node then send the session key to the consumer. } #          IF (StrLen (uc_tlogon) = 0) AND uc_tnode_local THEN              uc_targ_session := initr_session_key.key;                END;  { IF StrLen ( }        END;  { WITH user_command_fields }      99:   
END;  { FillInNullFields } 
         $Page   #{-------------------------------------------------------------------}  # #{                       FIND UNQUOTED CHAR                          }  # #{-------------------------------------------------------------------}  # !{ Returns a non-negative integer position of the desired character ! !{ if that character does not exist in quotes. If the character is  ! { not found then zero is returned.  {   { Parameters:   {   
{     string_parm (Input)  
 {        String that contains the character to be found.  {   {     start_pos (Input)   !{        The index of the first char where the search is to begin. ! {        Must not be positioned to a closing quote.   {   {     end_pos (Input)    {        The index of the last char where the search is to end.    {   
{     search_char (Input)  
 {        The character that is being searched for.  {}  
FUNCTION  FindUnquotedChar 
    (VAR string_parm     : String;           start_pos       : Int16;          end_pos         : Int16;          search_char     : CHAR)      : Int16;       VAR      found_pos   : Int16;       BEGIN   	   found_pos := 0; 	        WHILE start_pos <= end_pos DO        BEGIN         { Check if we are positioned to a quoted string }         IF string_parm [start_pos] = QUOTE THEN            BEGIN           { We are. Find the closing quote. The closing quote }           { must be present since that was checked before     }           REPEAT               start_pos := start_pos +1;           UNTIL string_parm [start_pos] = QUOTE;            start_pos := start_pos +1;   
         END  { IF } 
       ELSE           BEGIN            { Check if the char positioned to is the one we want }             IF string_parm [start_pos] <> search_char THEN               start_pos := start_pos +1            ELSE   	            BEGIN  	             { We found it so bailout of the loop }              found_pos := start_pos;               start_pos := end_pos +1;              END;  { ELSE of IF string_parm }               END;  { ELSE of IF string_parm }         END;  { WHILE start_pos }          FindUnquotedChar := found_pos;       
END;  { FindUnquotedChar } 
         $Page   #{-------------------------------------------------------------------}  # #{                           GET COMMAND                             }  # #{-------------------------------------------------------------------}  # !{ Read a single user command from input. The command may span more !  { one line so we may have to piece it together. If the input is    { interactive then appropriate prompts will be provided.  {   { Parameters:   {   {     command (Input/Output)  "{        This may contain a whole or partial command on entry if we  "  {        just picked up the run-string in the main routine, else   "{        this should be null. This procedure will return a complete  " "{        command in either case. The returned command may be null if " {        we reached Eof.  {   {     command_flushed (Output)  !{        Returns true only if the user flushed the command at some ! !{        point within this procedure (using control-y in response  ! !{        to the "Continue:" prompt). If true, this flag serves to  ! !{        indicate that if the command parameter carried in part of ! !{        a command, it was flushed and command is returning a new  ! 
{        command entirely. 
 {   {     nft_error (Output)  {        Returns a Nft error code if <> 0   {}  PROCEDURE  GetCommand      (VAR command         : CommandStringType;      VAR command_flushed : BOOLEAN;      VAR nft_error       : Int16);       LABEL      99;   { Labels end of the procedure }      VAR      end_of_command   : BOOLEAN;     input_line       : String [80];     interactive      : BOOLEAN;     prog_name_prompt : String [8];      prompt_string    : String [10];     temp             : Int16;      BEGIN      end_of_command  := FALSE;     command_flushed := FALSE;         { Prepare a prompt using our program name }     SetStrLen (prog_name_prompt, pname_length);     FOR temp := 1 TO pname_length DO         prog_name_prompt [temp] := our_pname [temp];     prog_name_prompt := prog_name_prompt + '> ';          { If the command is empty or there is a continuation char }     { at the end of what is there then prompt for the command }     IF (StrLen (command) = 0)                           OR         (command [StrLen (command)] = CONTINUATION_CHAR) THEN         BEGIN         { Choose the 'DSCOPY>' or the 'Continue:' prompt }        IF StrLen (command) = 0 THEN           prompt_string := prog_name_prompt        ELSE           BEGIN           { Delete the continuation char }            StrDelete (command, StrLen (command), 1);           prompt_string := CONTINUE_PROMPT;           END;  { ELSE of IF StrLen }            { Set a flag if the input file is interactive }         interactive := FmpInteractive (input_dcb_ptr^) < 0;             REPEAT           { Prompt only if interactive }            IF interactive THEN  	            BEGIN  	             IF first_pass THEN  $               writeln (output, HELLO_BANNER1, REV_CODE, HELLO_BANNER2); $             prompt (output, prompt_string);               end;  { IF }               entered_error_handler := FALSE;               IF first_pass THEN   	            BEGIN  	             first_pass := FALSE;              reading_from_input := TRUE;               read (input, input_line);               reading_from_input := FALSE;              END  { IF first_pass }           ELSE   	            BEGIN  	             IF (NOT Eof (input)) AND (Eoln (input)) THEN                 readln (input);              IF NOT Eof (input) THEN                  read (input, input_line);              END;  { ELSE of IF first_pass }                IF Eof (input) OR entered_error_handler THEN   	            BEGIN  	              { All done with the command. It still may be null }                end_of_command := TRUE;               IF interactive THEN                  writeln (output);              END   { IF }           ELSE   	            BEGIN  	 $            { If there was more on the line than we could handle then }  $ $            { bailout giving an error.                                }  $             IF NOT Eoln (input) THEN  
               BEGIN 
                nft_error := INPUT_LINE_TOO_LONG;                 WHILE NOT Eoln (input) DO                    Get (input);                 GOTO 99;                  END;  { IF NOT Eoln }                  { Trim off all spaces }               input_line := StrLTrim (input_line);              input_line := StrRTrim (input_line);                  IF StrLen (input_line) = 0 THEN   
               BEGIN 
                { The input line was null. We should return }                 { only if there is something in the command }                 { (i.e., if the prompt was 'Continue:').    }                 end_of_command := StrLen (command) > 0;                 END  { IF StrLen }               ELSE  
               BEGIN 
                 { If user gave control-y then flush the command }                  IF input_line = CONTROL_Y THEN                     BEGIN                     command         := '';                    prompt_string   := prog_name_prompt;                    command_flushed := TRUE;                    END  { IF }   
               ELSE  
                   BEGIN   !                  { If the user wants echo then do it. Done here } ! !                  { since the command we return could be large   } !                   IF echo_input THEN                       writeln (list, input_line);      !                  { If the line is not a comment then process it } !                   IF input_line [1] <> ASTERISK THEN  
                     BEGIN 
                       { Make sure the command is not too large }                          IF StrLen (input_line) + StrLen (command) >   "                        StrMax (command)                       THEN  "                         BEGIN                           nft_error := INPUT_COMMAND_TOO_BIG;                           GOTO 99;                          END;  { IF StrLen (input_line) }                           { Tack the input_line onto the command }                        command := command + input_line;                            { If we did not get a continuation char }                       { then quit, else continue              }                       IF command [StrLen (command)] <>                           CONTINUATION_CHAR          THEN                           end_of_command := TRUE  
                     ELSE  
                         BEGIN   !                        StrDelete (command, StrLen (command), 1);  !                         prompt_string := CONTINUE_PROMPT;                           END;  { ELSE of IF command }                           END;  { IF input_line [1] }                    END;  { ELSE of IF input_line = CONTROL_Y }                  END;  { ELSE of IF StrLen }              END;  { ELSE of IF entered }            UNTIL end_of_command;       
      END;  { IF (StrLen } 
     99:   
END;  { GetCommand } 
         $Page   #{-------------------------------------------------------------------}  # #{                        GET FILE TYPE NUMBER                       }  # #{-------------------------------------------------------------------}  # #{ Given an open file dcb buffer, this procedure returns the file type  # { number of the file associated with that dcb.  {   { Parameters:   {   
{     dcb_pointer (Input)  
 {        A pointer to the file dcb buffer   {   {     file_type (Output)  {        Returns the file type number   {   {     fmp_error (Output)  {        Returns any Fmp error if < 0   {}  PROCEDURE  GetFileTypeNumber     (VAR dcb_ptr   : PointerType;  
    VAR file_type : Int16; 
     VAR fmp_error : Int16);       VAR      dirpath        : String2;     ds             : String2;     filename       : String2;     full_pathname  : Hp1000PathNameType;      qual           : String2;  
   reclen         : Int16; 
 
   seccode        : Int16; 
 
   size           : Int16; 
    typex          : String2;      BEGIN      SetStrLen (full_pathname, StrMax (full_pathname));      FmpFileName (dcb_ptr^, fmp_error, full_pathname);         IF fmp_error = 0 THEN        BEGIN         dirpath  := ' ';        ds       := ' ';        filename := ' ';        qual     := ' ';        typex    := ' ';      !      FmpParsePath (full_pathname, dirpath, filename, typex, qual, !                     seccode, file_type, size, reclen, ds);        END;  { IF fmp_error }      END;  { GetFileTypeNumber }           $Page   #{-------------------------------------------------------------------}  # #{                        HANDLE COPY COMMAND                        }  # #{-------------------------------------------------------------------}  # "{ This procedure handles a single user copy command. If the command  " !{ contains wildcard characters then this may cause multiple xfers  ! !{ to take place. This procedure does not return until the command  ! { is carried out or an error occurs.  {   { Parameters:   {   {     command (Input)   {        String containing the copy command to be executed.   {   
{     option_name (Output) 
  {        When the command is being parsed, if an option is found   {        which is unknown then this returns that option name  {   {     aborted_or_cancelled (Output)   "{        Returns true if the user aborted or cancelled the transfer  " {        as opposed to it completing normally   {   {     ipc_error (Output)  {        Returns any Ipc error that occurred if non-zero  {   {     nft_error (Output)  {        Returns any Nft error that occurred if non-zero  {}  PROCEDURE  HandleCopyCommand     (VAR command              : String;      VAR option_name          : String;      VAR aborted_or_cancelled : BOOLEAN;       VAR ipc_error            : Int32;       VAR rsm_error            : Int16;       VAR nft_error            : Int16);      LABEL      99;   { Labels end of the procedure }      VAR      event_present  : BOOLEAN;     new_connection : BOOLEAN;     state          : StateTypes;       BEGIN      ClearCommandFields (user_command_fields);      "   { Assign the global defaults the the user command fields before } " "   { parsing. Parameter null_fields is not used                    } "    AssignFields (GLOBAL_TO_USER, user_command_fields,                    global_defaults, null_fields);           ParseCopyCommand (command, user_command_fields, null_fields,                         option_name, nft_error);          { Bailout on any parsing error }   
   IF nft_error <> 0 THEN  
       GOTO 99;         { If the user gave no source file name then error }     IF StrLen (user_command_fields.uc_sfile) = 0 THEN        BEGIN         nft_error := NO_SOURCE_FILE_GIVEN;        GOTO 99;  	      END;  { IF } 	     !   { If the user left any fields of the command null which have }  ! !   { implied meanings then fill them in.                        }  !     FillInNullFields (user_command_fields, rsm_error, ipc_error,                         nft_error);         { An error return here is fatal }  
   IF nft_error <> 0 THEN  
       BEGIN         PrintErrorOrWarn (ERROR, list, 0, nft_error, ipc_error,                           rsm_error, null_string);        IF list_file_name <> output_file_name THEN  !         PrintErrorOrWarn (ERROR, output, 0, nft_error, ipc_error, !                            rsm_error, null_string);         total_errors := total_errors + 1;         CleanupAndTerminate (total_errors, nft_error);        END;  { IF nft_error }         { Connect to the producer system whose name the user gave }      SetUpProducerConnection (producer_info, user_command_fields,    !                            new_connection, ipc_error, nft_error); ! 
   IF nft_error <> 0 THEN  
       GOTO 99;      "   { Check if the break flag is set before we continue. Note that }  " "   { if the user wants to abort or cancel here, the connection we }  " "   { just set up will be to the monitor, not the producer.        }  " 
   IF BreakFlag = -1 THEN  
       BEGIN         PromptAndGetBreakRequest (event, cursor_end_of_line);         aborted_or_cancelled := (event = USER_WANTS_ABORT) OR                                 (event = USER_WANTS_CANCEL);  
      InStateIdle (event); 
       IF aborted_or_cancelled THEN           BEGIN           nft_error := TRANSFER_ABORTED_BY_USER;   	         GOTO 99;  	 
         END;  { aborted } 
       END;  { IF BreakFlag }         { If a new connection was just set up then send a RINIT }     { message to initialize the producer, else send a RNFT. }  
   IF new_connection THEN  
       BEGIN          BuildAndSendMsg (RINIT, main_buffer, user_command_fields,                           ipc_error, nft_error);         IF nft_error = 0 THEN            state := WAIT_FOR_AINIT;         END  { IF new_connection }     ELSE         BEGIN         BuildAndSendMsg (RNFT, main_buffer, user_command_fields,                         ipc_error, nft_error);         IF nft_error = 0 THEN            state := WAIT_FOR_ANFT;        END;  { ELSE of IF new_connection }               { If error occurred in sending message above then bomb out }    
   IF nft_error <> 0 THEN  
       BEGIN   
      state := IDLE; 
       GOTO 99;        END;  { IF nft_error }          { This is the main loop where the user command is executed. }       { It loops checking for a message arrival or if the user    }       { set the break flag. If neither has occurred then it time  }       { schedules itself for a few seconds. The loop exits when   }       { an error occurs or the state returns to idle              }      WHILE (nft_error = 0) AND (state <> IDLE) DO         BEGIN   !      { Check if a message has arrived or an Ipc error occurred }  !        CheckForExternalEventNoWait (producer_info, event_present,   !                                   event, ipc_error, main_buffer); !       IF NOT event_present THEN            BEGIN  !         { No message arrived or error occurred. If the user has } ! !         { set the break flag then handle it                     } !          IF BreakFlag = -1 THEN   	            BEGIN  	 !            PromptAndGetBreakRequest (event, cursor_end_of_line);  ! !            aborted_or_cancelled := (event = USER_WANTS_ABORT) OR  !                                      (event = USER_WANTS_CANCEL);               END   { IF BreakFlag }           ELSE   	            BEGIN  	              { Nothing is going on so just wait a few seconds. }                 { The first zero indicates this program, and the  }                 { second zero means schedule only once            }                 ExecTimeSchedule (EXEC_12 + NO_ABORT, 0, SECONDS, 0,                                 -RELATIVE_WAIT_TIME);   	            BEGIN  	             { This is the error return }              END;                  event := NULL_EVENT;              END;  { ELSE of IF BreakFlag }  
         END;  { IF NOT }  
           IF event <> NULL_EVENT THEN            BEGIN           { Call the proper routine to handle the event }           IF state = WAIT_FOR_AINIT THEN               InStateWaitForAinit (event, state, main_buffer,                                    ipc_error, nft_error)           ELSE               InStateWaitForAnft (event, state, main_buffer,                                  ipc_error, nft_error);           END;  { IF }         END;  { WHILE }       $   { If the input is interactive then clear the break flag. The user  }  $ $   { wanted to break the last command which is now done, not the next }  $ $   { command. If in a transfer file then don't clear the break flag.  }  $ $   { The user just wants to get out of the transfer file so we will   }  $ $   { note the break flag is set above when this procedure is called   }  $ $   { again. Note the ordering of the boolean expressions in the IF    }  $ $   { statement. It must not change.                                   }  $ #   IF (FmpInteractive (input_dcb_ptr^) < 0) AND (BreakFlag = -1) THEN; #     99:   END;  { HandleCopyCommand }           $Page   #{-------------------------------------------------------------------}  # #{                     HANDLE LIST FILE COMMAND                      }  # #{-------------------------------------------------------------------}  # { Handle the user command to change the list file.  {   { Parameters:   {   
{     command_parm (Input) 
 {        Carries in the user-given list file name   {   
{     error_string (Input) 
 !{        If an error occurred in opening the list file, this will  ! {        return the name of the user-given list file  {   {     fmp_error (Output)  {        Returns any Fmp error if < 0   {   {     nft_error (Output)  {        Returns any Nft error code if <> 0   {}  PROCEDURE  HandleListFileCommand     (VAR command_parm : String;      VAR error_string : String;      VAR fmp_error    : Int16;       VAR nft_error    : Int16);      LABEL      99;   { Labels end of the procedure }      VAR      file_type       : Int16;      reset_to_log_lu : BOOLEAN;       BEGIN      { Return an error if a parameter was not given }      IF StrLen (command_parm) = 0 THEN        nft_error := ILLEGAL_COMMAND     ELSE         BEGIN         reset_to_log_lu := FALSE;             { Try to open the list file }         entered_error_handler := FALSE;         opening_file := TRUE;         rewrite (list, command_parm, 'NOCCTL, SHARED');         opening_file := FALSE;            IF entered_error_handler THEN            BEGIN  !         { An error occurred in opening the list file. Since we }  ! !         { entered the error handler, we may have gotten an Fmp }  ! !         { error from him, if not then generate an Nft error.   }  !          IF global_fmp_error = 0 THEN               nft_error := CANT_OPEN_FILE            ELSE               fmp_error := global_fmp_error;           reset_to_log_lu := TRUE;            END   { IF entered }         ELSE           BEGIN  !         { We opened the list file successfully. Verify that the } ! !         { file type is acceptable.                              } !          list_file_name := command_parm;            GetFileTypeNumber (list_dcb_ptr, file_type, fmp_error);            IF fmp_error <> 0 THEN               reset_to_log_lu := TRUE            ELSE   	            BEGIN  	 "            { File types 1 and 2 are unacceptable. We will get run } " "            { time errors if we try to write to them.              } "             IF (file_type < 1) OR (file_type > 2) THEN                 reset_to_log_lu := FALSE               ELSE  
               BEGIN 
                reset_to_log_lu := TRUE;                  nft_error       := FILE_TYPE_IS_BAD;                  END;  { IF (file }                   END;  { ELSE of IF fmp_error }           END;  { ELSE of IF entered }             IF reset_to_log_lu THEN            BEGIN  #         { Return the bad file name and reset the list file to loglu } #          IF StrLen (command_parm) > StrMax (error_string) THEN              SetStrLen (command_parm, StrMax (error_string));           error_string   := command_parm;           list_file_name := log_lu;           rewrite (list, list_file_name, 'NOCCTL, SHARED');           END;  { IF reset }             END;  { ELSE of IF StrLen }       99:   END;  { HandleListFileCommand }           $Page   #{-------------------------------------------------------------------}  # #{                     HANDLE NON COPY COMMAND                       }  # #{-------------------------------------------------------------------}  # !{ This procedure handles all commands that begin with a plus sign  !  { (e.g., +WD or +TR). The command is carried out entirely before   
{ this procedure returns.  
 {   { Parameters:   {   {     command (Input)   {        Contains the command beginning with a plus sign  {   {     error_string (Output)    {        If an error occured this may return an error string to    {        be printed along with the error message. An example  {        would be a transfer file name that can't be found  {   
{     end_of_file (Input)  
  {        True only if we have reached end-of-file. We may or may   {        not be in a transfer file. If this is true, command  "{        should be '+TR' since the TR processor handles end-of-file. " {   {     fmp_error (Output)  {        Returns an Fmp error that occurred if < 0  {   {     nft_error (Output)  {        Returns an Nft error that occurred if <> 0   {}  PROCEDURE  HandleNonCopyCommand      (VAR command      : String;      VAR error_string : String;      VAR end_of_file  : BOOLEAN;       VAR fmp_error    : Int16;       VAR nft_error    : Int16);      LABEL      99;   { Labels end of the procedure }      VAR   
   command_name16 : Int16; 
    command_parm   : CommandStringType;      $Page   #   {----------------------------------------------------------------}  # #   { (Local)                 SPLIT COMMAND                  (Local) }  # #   {----------------------------------------------------------------}  # "   { This procedure splits a command from the parameter. It returns  " #   { the first two upshifted chars of the command as an integer value, #    { and the parameter as a string.      {     { Parameters:     {     {     command (Input)  "   {        Contains the command to be split up from the parameter.  "     {        The parameter is separated by a comma and may or may   
   {        not be present 
    {     {     command_name16 (Output)  "   {        Returns the first two chars of the command as an integer "    {     {     command_parm (Ouptut)     {        Returns any parameter that followed the command      {}   
   PROCEDURE  SplitCommand 
       (VAR command         : String;         VAR command_name16  : Int16;          VAR command_parm    : String);          VAR        command_name : String [2];        index        : Int16;         two_chars    : TwoCharsType;         BEGIN  
      command_parm := '';  
 #      index := FindUnquotedChar (command, 1, StrLen (command), COMMA); #           IF index < 2 THEN            BEGIN  !         { Either there is no command parameter present, or the }  ! !         { command name is not present. In either case make the }  ! !         { command name equal to the entire command             }  !           command_name := Str (command, 1, Min (StrLen(command),    #                                               StrMax(command_name))); #          END   { IF index }         ELSE           BEGIN  !         { There are at least two chars for the command and a   }  ! !         { parameter to the command. Give command_name the part }  ! !         { before the comma and command_parm the rest           }  !          command_name := Str (command, 1,                                          Min (index -1,   #                                            StrMax (command_name)) );  #          command_parm := Str (command, index +1,  #                                       Min (StrLen (command) - index,  # #                                            StrMax (command_parm)) );  #          END;  { ELSE of IF index }             IF StrLen (command_name) > 0 THEN            CaseFold (command_name);       "      { Convert first two chars of command_name to integer. If the } " "      { length of the command is less than 2 chars then make the   } " "      { integer value of the command an illegal value              } "       IF StrLen (command_name) < 2 THEN            two_chars.int := -1        ELSE           BEGIN           two_chars.char1 := command_name [1];            two_chars.char2 := command_name [2];            END;  { ELSE }             command_name16 := two_chars.int;      
   END;  { SplitCommand }  
     $Page   BEGIN  { HandleNonCopyCommand }           { Delete the preceeding plus sign. We know it's there since }       { we would not be in this procedure otherwise               }      StrDelete (command, 1, 1);          { Split up the command and the command parameter. Also  }     { upshift and return the first two chars of the command }     SplitCommand (command, command_name16, command_parm);      
   CASE command_name16 OF  
 
      CLEAR_COMMAND: 
          BEGIN           ClearGlobalDefaults (global_defaults);            END;  { CLEAR }            DEFAULT_COMMAND:           BEGIN           { Make sure there is a parameter present }            IF StrLen (command_parm) = 0 THEN  	            BEGIN  	             nft_error := ILLEGAL_COMMAND;   
            GOTO 99; 
             END;  { IF }               ClearCommandFields (user_command_fields);               { Error string is a global here but is a dummy }            ParseCopyCommand (command_parm, user_command_fields,   !                           null_fields, error_string, nft_error);  !              { Bailout on any parsing errors }           IF nft_error <> 0 THEN   
            GOTO 99; 
              { File names are not allowed as global defaults }           IF (StrLen (user_command_fields.uc_sfile) > 0) OR              (StrLen (user_command_fields.uc_tfile) > 0) THEN  	            BEGIN  	             nft_error := CANT_DEFAULT_FILE_NAMES;   
            GOTO 99; 
             END;  { IF }                { Save the default info in the global_defaults record }            AssignFields (USER_TO_GLOBAL, user_command_fields,                          global_defaults, null_fields);   
         END;  { DEFAULT } 
     
      ECHO_COMMAND:  
          BEGIN            { If there is no parameter present then turn echo on }             IF StrLen (command_parm) = 0 THEN              echo_input := TRUE           ELSE   	            BEGIN  	             CaseFold (command_parm);              echo_input :=  NOT (command_parm = 'OFF');              END;  { ELSE of IF StrLen }            END;  { ECHO }       
      EXIT_COMMAND:  
          BEGIN           CleanupAndTerminate (total_errors, global_nft_error);           END;  { EXIT }             LIST_FILE_COMMAND:           BEGIN           SquezeOutQuotes (command_parm);           HandleListFileCommand (command_parm, error_string,                                   fmp_error, nft_error);           END;  { LIST_FILE }      	      RUN_COMMAND: 	          BEGIN           SquezeOutQuotes (command_parm);           HandleRunCommand (command_parm, error_string,                             fmp_error, nft_error);            END;  { RUN }      
      SHOW_COMMAND:  
          BEGIN           ShowGlobalDefaults (global_defaults);           END;  { SHOW }             TRANSFER_COMMAND:            BEGIN           SquezeOutQuotes (command_parm);           HandleTransferCommand (command_parm, error_string,   "                                end_of_file, fmp_error, nft_error);  "          END;  { TRANSFER }       
      WORKING_DIR_COMMAND: 
          BEGIN           SquezeOutQuotes (command_parm);           HandleWorkingDirCommand (command_parm, error_string,                                     fmp_error);            END;  { WORKING_DIR }            OTHERWISE            BEGIN           nft_error := UNKNOWN_COMMAND;           END;  { OTHERWISE }      
      END;  { CASE } 
     99:   END;  { HandleNonCopyCommand }          $Page   #{-------------------------------------------------------------------}  # #{                        HANDLE RUN COMMAND                         }  # #{-------------------------------------------------------------------}  # { Handle a user command to run a program.   {   { Parameters:   {   
{     command_parm (Input) 
 {        Carries in the name of the program to be run   {   
{     error_string (Input) 
 !{        If an error occurred in running the program, this returns ! {        the name of the program  {   {     fmp_error (Output)  {        Returns any Fmp error if < 0   {   {     nft_error (Output)  {        Returns any Nft error code if <> 0   {}  PROCEDURE  HandleRunCommand      (VAR command_parm : String;      VAR error_string : String;      VAR fmp_error    : Int16;       VAR nft_error    : Int16);      VAR      dummy1   : FiveWordsType;  
   dummy2   : String [1];  
     BEGIN      IF StrLen (command_parm) = 0 THEN        nft_error := ILLEGAL_COMMAND     ELSE         BEGIN   
      dummy2 := '';  
        fmp_error := FmpRunProgram (command_parm, dummy1, dummy2);             IF fmp_error < 0 THEN            BEGIN           IF StrLen (command_parm) > StrMax (error_string) THEN              SetStrLen (command_parm, StrMax (error_string));           error_string := command_parm;           END;         END; { ELSE of IF StrLen }      
END;  { HandleRunCommand } 
         $Page   #{-------------------------------------------------------------------}  # #{                    HANDLE TRANSFER COMMAND                        }  # #{-------------------------------------------------------------------}  # { Handle a user command to transfer to a command file or lu.  {   { Parameters:   {   
{     command_parm (Input) 
 {        Carries in the name of the file or lu to transfer to   {   {     error_string (Output)    {        If an error occurred in transferring to the file or lu    {        this returns the name of that file or lu   {   
{     end_of_file (Input)  
 !{        If true, this indicates that we have reached end-of-file  ! {        in the current command file  {   {     fmp_error (Output)  {        Returns any Fmp error if < 0   {   {     nft_error (Output)  {        Returns any Nft error code if <> 0   {}  PROCEDURE  HandleTransferCommand     (VAR command_parm : String;      VAR error_string : String;      VAR end_of_file  : BOOLEAN;       VAR fmp_error    : Int16;       VAR nft_error    : Int16);      VAR      file_type       : Int16;      reset_to_log_lu : BOOLEAN;       BEGIN      reset_to_log_lu := FALSE;         IF StrLen (command_parm) = 0 THEN        BEGIN         { If not at end-of-file then the user entered '+TR' }         IF NOT end_of_file THEN            nft_error := ILLEGAL_COMMAND         ELSE           BEGIN  #         { If we are in a transfer file then we have reached EOF in  } # #         { it so reset the input, output and log lus to the log lu.  } # #         { Otherwise terminate the program.                          } #          IF in_transfer_file THEN               reset_to_log_lu := TRUE            ELSE   !            CleanupAndTerminate (total_errors, global_nft_error);  !          END;  { ELSE of IF NOT }         END  { IF StrLen }     ELSE         BEGIN         { Try to open the new input file }        entered_error_handler := FALSE;         opening_file := TRUE;         reset (input, command_parm, 'SHARED');        opening_file := FALSE;            IF entered_error_handler THEN            BEGIN           { Error occurred in trying to open the input file }           IF global_fmp_error = 0 THEN               nft_error := CANT_OPEN_FILE            ELSE               fmp_error := global_fmp_error;               { Return the name of the input file }           IF StrLen (command_parm) > StrMax (error_string) THEN              SetStrLen (command_parm, StrMax (error_string));           error_string := command_parm;               reset_to_log_lu := TRUE;   
         END  { IF } 
       ELSE           BEGIN  "         { We opened the input file successfully. If the file type } " "         { is 1 or 2 we must reject it since we will get run time  } " "         { errors when reading from it later.                      } " !         GetFileTypeNumber (input_dcb_ptr, file_type, fmp_error);  !          IF fmp_error <> 0 THEN               reset_to_log_lu := TRUE            ELSE   	            BEGIN  	             IF (file_type = 1) OR (file_type = 2) THEN  
               BEGIN 
                reset_to_log_lu := TRUE;                  nft_error       := FILE_TYPE_IS_BAD;                  END   { IF (file_type }              ELSE  
               BEGIN 
                { The transfer file type looks ok }                 in_transfer_file := TRUE;      #               { If interactive then set the output and log files to } # #               { the new input lu also                               } #                IF FmpInteractive (input_dcb_ptr^) < 0 THEN                    BEGIN                     output_file_name := command_parm;                     rewrite (output, command_parm, 'NOCCTL');                     reset (log_file, command_parm);                     END;  { IF FmpInterective }                  END  { ELSE of IF (file_type }                   END;  { ELSE of IF fmp_error }           END;  { ELSE of IF entered }         END;  { ELSE of IF StrLen }       
   IF reset_to_log_lu THEN 
       BEGIN         in_transfer_file := FALSE;        output_file_name := log_lu;         reset (input, log_lu);        reset (log_file, log_lu);         rewrite (output, output_file_name, 'NOCCTL');         END;  { IF reset }      END;  { HandleTransferCommand }           $Page   #{-------------------------------------------------------------------}  # #{                    HANDLE WORKING DIR COMMAND                     }  # #{-------------------------------------------------------------------}  # { Handle a command to display or change the working directory   {   { Parameters:   {   
{     command_parm (Input) 
 {        Carries in any parameter after the "+WD" command   {   {     error_string (Output)   {        If an error occurred in setting the working directory  {        then this returns the name if the bad directory  {   {     fmp_error (Output)  {        Returns any Fmp error that occurred if < 0   {}  PROCEDURE  HandleWorkingDirCommand     (VAR command_parm : String;      VAR error_string : String;      VAR fmp_error    : Int16);      BEGIN      IF StrLen (command_parm) > 0 THEN        BEGIN         { Set the working directory to the command_parm }         fmp_error := FmpSetWorkingDir (command_parm);         IF fmp_error < 0 THEN            BEGIN           IF StrLen (command_parm) > StrMax (error_string) THEN              SetStrLen (command_parm, StrMax (error_string));           error_string := command_parm;           END;   
      END   { IF StrLen }  
    ELSE         BEGIN         { Display the current working directory }         SetStrLen (command_parm, StrMax (command_parm));        fmp_error := FmpWorkingDir (command_parm);            IF fmp_error = 0 THEN            BEGIN           command_parm := StrRTrim (command_parm);   !         writeln (output, ' Working directory is ', command_parm); !          END   { IF }         ELSE           BEGIN           { Catch the special case of no working directory }            IF fmp_error = FMP_NO_WORKING_DIR THEN   	            BEGIN  	             writeln (output, ' No working directory');              fmp_error := 0;               END   { IF fmp_error }           END   { ELSE of IF fmp_error }         END   { ELSE of IF StrLen }       END;  { HandleWorkingDirCommand }           $Page   #{-------------------------------------------------------------------}  # #{                             INITIALIZE                            }  # #{-------------------------------------------------------------------}  #  { Initialize by getting the parameter string, creating the call    "{ socket, initializing some global variables and opening some files. " "{ This routine will abort the program if an error occurs in creating " 	{ the call socket. 	 {   { Parameters:   {   {     command (Output)  {        Returns the parameter string   {}  PROCEDURE  Initialize      (VAR command : CommandStringType);       VAR   
   first_comma   : Int16;  
 
   init_error    : Int16;  
 
   ipc_error     : Int32;  
 
   nft_error     : Int16;  
 
   second_comma  : Int16;  
    six_chars     : SixCharsType;  
   temp          : Int16;  
     BEGIN      entry_count          := 0;      first_pass           := TRUE;     abort_requested      := FALSE;      cancel_requested     := FALSE;      aborted_or_cancelled := FALSE;      global_nft_error     := 0;      total_errors         := 0;       "   { Pickup the run string. Must do it before any other Exec call }  "    SetStrLen (command, StrMax (command));      FOR temp := 1 TO StrMax (command) DO         command [temp] := SPACE;         ExecGetRunString (EXEC_14 + NO_ABORT, GET_RUN_STRING,  "                     PasStringData1 (command)^, - StrMax (command)); "    BEGIN      { This is the error return. There isn't much we can do here }      END;          command := StrLtrim (command);      command := StrRtrim (command);       "   { Delete everything upto and including the second comma in the  } " "   { command. This should be the "RU,DSCOPY," part. Note that if   } " "   { we were scheduled from the Dscopy() intrinsic then there must } " "   { be two commas preceeding the command. The only reason we are  } " "   { using FindUnquotedChar is that is seems to do what we want.   } "    second_comma := 0;   	   first_comma  := 	       FindUnquotedChar (command, 1, StrLen (command), COMMA);   !   IF (first_comma > 0) AND (StrLen (command) > first_comma) THEN  ! !      second_comma := FindUnquotedChar (command, first_comma + 1,  ! !                                        StrLen (command), COMMA);  !     "   { If we found the second comma then do the deletion, else null }  " "   { the command (it probably was just "RU,DSCOPY"). Perhaps the  }  " "   { Dscopy() caller did not place the commas in the buffer, but  }  " "   { that's his problem.                                          }  "    IF second_comma = 0 THEN   
      command := ''  
    ELSE         BEGIN         StrDelete (command, 1, second_comma);         command := StrLTrim (command);        END;         { Get our program name and its length }     Pname (our_pname);      pname_length := 6;      WHILE our_pname [pname_length] = SPACE DO        pname_length := pname_length - 1;          { Pickup the Log Lu and convert it to a string }      Cnumd (LogLu (temp), six_chars);   
   SetStrLen (log_lu, 6);  
    FOR temp := 1 TO 6 DO        log_lu [temp] := six_chars [temp];     log_lu := StrLTrim (log_lu);      log_lu := StrRTrim (log_lu);          list_file_name       := log_lu;     output_file_name     := log_lu;      
   reset (input, log_lu);  
    reset (log_file, log_lu);     rewrite (output, output_file_name, 'NOCCTL');     rewrite (list, list_file_name, 'NOCCTL, SHARED');         converting_to_integer := FALSE;     opening_file          := FALSE;     reading_from_input    := FALSE;         echo_input            := FALSE;     in_transfer_file      := FALSE;     cursor_end_of_line    := FALSE;     null_string           := '';          initr_session_key.valid := FALSE;         InitOpt (dummy_options, 0, init_error);         { Initialize the producer_info record }     WITH producer_info DO        BEGIN         pi_connected   := FALSE;        pi_logon       := '';         pi_node_name   := '';   
      END;  { WITH } 
     !   { Ask Pascal where the input and list file Dcbs are. We will }  ! !   { need these later for the FmpInteractive call.              }  !    PasDcbAddress1 (input_dcb_ptr, input);      PasDcbAddress1 (list_dcb_ptr, list);          { Attempt to create the call socket }  
   dummy_flags := 0; 
    IpcCreate (IPC_CALL_SOCKET, 0, dummy_flags, dummy_options,                 call_socket_descr, ipc_error);             IF ipc_error = 0 THEN  
      nft_error := 0 
    ELSE         BEGIN         nft_error := UNABLE_TO_INITIALIZE;        PrintErrorOrWarn (ERROR, list, 0, nft_error, ipc_error,                           0, null_string);        IF list_file_name <> output_file_name THEN  !         PrintErrorOrWarn (ERROR, output, 0, nft_error, ipc_error, !                            0, null_string);         LogEvent (I_LOG_CANT_INITIALIZE, 2, ipc_error, 0, 0);         total_errors := total_errors + 1;         CleanupAndTerminate (total_errors, nft_error);        END;  { ELSE of IF ipc_error }      
END;  { Initialize } 
         $Page   #{-------------------------------------------------------------------}  # #{                          IN STATE IDLE                            }  # #{-------------------------------------------------------------------}  # "{ The user has set our break flag before we have begun the transfer. " { Handle all requests in this state.  {   { Parameters:   {   
{     event (Input)  
 {        Gives the user's break mode help request   {}  PROCEDURE  InStateIdle     (    event  : Int16);      BEGIN      CASE event OF        { The user just hit carriage return so do nothing }   	      NULL_EVENT:; 	           USER_WANTS_ABORT, USER_WANTS_CANCEL:           BEGIN  !         { If a connection exists to the producer then close it }  !          CloseConnectionToProducer (producer_info);            END;             USER_WANTS_HELP:           BEGIN           { User desires a break mode help message. }           writeln (output, BREAK_MODE_HELP1);           writeln (output, BREAK_MODE_HELP2);           writeln (output, BREAK_MODE_HELP3);           END;       
      USER_WANTS_PROGRESS: 
          BEGIN           { The transfer has not even started! Tell user 0% }           writeln (output, 0:2, PERCENT_XFERRED);           END;       
      END;  { CASE } 
     END;  { InStateIdle }       $Page   #{-------------------------------------------------------------------}  # #{                     IN STATE WAIT FOR AINIT                       }  # #{-------------------------------------------------------------------}  # "{ Handle all events which can occur in the Wait_For_Ainit state. If  " !{ an error occurs then return it as the caller will handle it. We  !  { are waiting for the producer's response to our Rinit message.    {   { Parameters:   {   
{     event (Input)  
 {        Gives the event that occurred  {   
{     state (Input/Output) 
 !{        Returns the next state based on the handling of the event ! {   
{     main_buffer (Input)  
 "{        May carry in a message that was received from the producer  " {   {     ipc_error (Input/Output)  #{        Inputs an Ipc error if and only if event is CONNECTION_DOWN.  # "{        On output, for some events this is returned unmodified. For " !{        others it returns an ipc_error if non-zero. Refer to each ! {        event to determine if it is modified.  {   {     nft_error (Output)  "{        Returns an Nft error which is fatal to the copy command if  " 	{        non-zero. 	 {}  PROCEDURE  InStateWaitForAinit     (    event        : Int16;       VAR state        : StateTypes;      VAR main_buffer  : MainBufferType;      VAR ipc_error    : Int32;       VAR nft_error    : Int16);      BEGIN      CASE event OF        AINIT :            BEGIN           { Check if producer was initialized ok }            IF main_buffer.msg.ainit_msg.error_code <> 0 THEN  	            BEGIN  	             { Error occurred in initializing producer }               CloseConnectionToProducer (producer_info);              PrintMessageFields (main_buffer);               total_errors     := total_errors + 1;   #            global_nft_error := main_buffer.msg.ainit_msg.error_code;  # 
            state := IDLE; 
             END   { IF buffer }            ELSE   	            BEGIN  	 "            { If user wanted abort or cancel before then do it now } "             IF abort_requested OR cancel_requested THEN   
               BEGIN 
                nft_error := TRANSFER_ABORTED_BY_USER;                  state     := IDLE;                  END  { IF abort_requested }              ELSE  
               BEGIN 
                { All is ok, send the RNFT message }   $               BuildAndSendMsg (RNFT, main_buffer, user_command_fields,  $                                 ipc_error, nft_error);                         IF nft_error <> 0 THEN                     state := IDLE   
               ELSE  
                   state := WAIT_FOR_ANFT;                  END;  { ELSE of IF abort_requested }                   END;  { ELSE of IF buffer }            END;  { AINIT }            CONNECTION_DOWN:           BEGIN           CloseConnectionToProducer (producer_info);            LogEvent (I_LOG_CONCT_DOWN, 2, ipc_error, 0, 0);            nft_error := I_P_CONNECTION_DOWN;           state     := IDLE;            END;             USER_WANTS_ABORT:            BEGIN           { Can do nothing now, must wait for AINIT to arrive }           abort_requested := TRUE;            END;             USER_WANTS_CANCEL:           BEGIN           { Can do nothing now, must wait for AINIT to arrive }           cancel_requested := TRUE;           END;       
      USER_WANTS_PROGRESS: 
          BEGIN           { The transfer has not even started! Tell user 0% }           writeln (output, 0:2, PERCENT_XFERRED);           END;             USER_WANTS_HELP:           BEGIN           { User desires a break mode help message. }           writeln (output, BREAK_MODE_HELP1);           writeln (output, BREAK_MODE_HELP2);           writeln (output, BREAK_MODE_HELP3);           END;             WARNING:           BEGIN           PrintMessageFields (main_buffer);           END;             OTHERWISE            BEGIN           { Invalid event occurred so bailout }           PrintErrorOrWarn (ERROR, list, 0,                             INTERNAL_ERROR, 0, 0, null_string);           IF list_file_name <> output_file_name THEN   !            PrintErrorOrWarn (ERROR, output, 0, INTERNAL_ERROR, 0, !                               0, null_string);            LogEvent (I_LOG_BAD_EVENT_WAIT_AINIT, 1, event, 0, 0);             total_errors := total_errors + 1;           CleanupAndTerminate (total_errors, INTERNAL_ERROR);           END;  { OTHERWISE }      
      END;  { CASE } 
        { If error occurred in this state then reset global flags }  
   IF nft_error <> 0 THEN  
       BEGIN         abort_requested  := FALSE;        cancel_requested := FALSE;        END;      END;  { InStateWaitForAinit }           $Page   "{------------------------------------------------------------------} " "{                     IN STATE WAIT FOR ANFT                       } " "{------------------------------------------------------------------} " !{ Handle all events which can occur in the Wait_For_Anft state. If ! "{ an error occurs, return an error condition. The caller will handle " !{ it. We are waiting for the ANFT to arrive which means a transfer ! "{ is in progress. When the ANFT arrives, it will give the result of  "  { the user command. An ANFTGEN would give the result of a single   { transfer with a generic file set.   {   { Parameters:   {   
{     event (Input)  
 {        Gives the event to be handled  {   
{     state (Input)  
 !{        Returns the next state based on the handling of the event ! {   
{     main_buffer (Input)  
 {        May carry in a message received from the producer  {   {     ipc_error (Input/Output)  #{        Inputs an Ipc error if and only if event is CONNECTION_DOWN.  #  {        On output, for some events this is returned unmodified.   !{        For others it returns an ipc_error if non-zero. Refer to  ! {        each event to determine if it is modified.   {   {     nft_error (Output)   {        Returns an Nft error which is fatal to the copy command   {        if non-zero.   {}  PROCEDURE  InStateWaitForAnft      (    event           : Int16;      VAR state           : StateTypes;       VAR main_buffer     : MainBufferType;       VAR ipc_error       : Int32;      VAR nft_error       : Int16);       BEGIN      CASE event OF        ANFT:            BEGIN  #         { An error code of "NULL_ANFT" indicates the fields of the }  # #         { message should be ignored. Refer to the NFT Protocol     }  # #         { Spec. for reason (at end of producer state transitions). }  #          WITH main_buffer.msg.anft_msg DO   	            BEGIN  	             IF error_code <> NULL_ANFT THEN   
               BEGIN 
                PrintMessageFields (main_buffer);                 global_nft_error := error_code;                      { If error occurred then increment total errors }                  IF (error_code <> 0) THEN                    total_errors := total_errors + 1;                  END;  { IF error_code }  
            END;  { WITH } 
     "         { The Anft signals the end of the user command so go idle } "          state := IDLE;            END;  { ANFT }             ANFTGEN:           BEGIN           PrintMessageFields (main_buffer);           WITH main_buffer.msg.anftgen_msg DO  	            BEGIN  	             global_nft_error := nft_error_code;               IF (nft_error_code <> 0) THEN                  total_errors := total_errors + 1;  
            END;  { WITH } 
 
         END;  { ANFTGEN } 
           CONNECTION_DOWN:           BEGIN           CloseConnectionToProducer (producer_info);            LogEvent (I_LOG_CONCT_DOWN, 3, ipc_error, 0, 0);       "         { Normally PrintMessageFields() prints "ok" or "failed", }  " "         { but since there is no message to receive we will have  }  " "         { to do it ourself here.                                 }  "          IF (NOT user_command_fields.uc_quiet) THEN   	            BEGIN  	             writeln (list, FAILED);               cursor_end_of_line := FALSE;              END;  { IF }               nft_error := I_P_CONNECTION_DOWN;           state     := IDLE;            END;  { CONNECTION_DOWN }            INFO:            BEGIN           PrintMessageFields (main_buffer);           END;             PROGRESS:            BEGIN           PrintMessageFields (main_buffer);           END;             USER_WANTS_ABORT:            BEGIN  #         BuildAndSendMsg (ABORTMSG, main_buffer, user_command_fields,  #                           ipc_error, nft_error);           IF nft_error <> 0 THEN   
            state := IDLE; 
          END;             USER_WANTS_CANCEL:           BEGIN  "         BuildAndSendMsg (CANCEL, main_buffer, user_command_fields,  "                           ipc_error, nft_error);           IF nft_error <> 0 THEN   
            state := IDLE; 
          END;             USER_WANTS_HELP:           BEGIN           { User desires a break mode help message. }           writeln (output, BREAK_MODE_HELP1);           writeln (output, BREAK_MODE_HELP2);           writeln (output, BREAK_MODE_HELP3);           END;       
      USER_WANTS_PROGRESS: 
          BEGIN  #         BuildAndSendMsg (RPROGRESS, main_buffer, user_command_fields, #                           ipc_error, nft_error);           IF nft_error <> 0 THEN   
            state := IDLE; 
          END;             WARNING:           BEGIN           PrintMessageFields (main_buffer);           END;             OTHERWISE            BEGIN           { Invalid event occurred so bailout }           PrintErrorOrWarn (ERROR, list, 0,                             INTERNAL_ERROR, 0, 0, null_string);           IF list_file_name <> output_file_name THEN   !            PrintErrorOrWarn (ERROR, output, 0, INTERNAL_ERROR, 0, !                               0, null_string);           LogEvent (I_LOG_BAD_EVENT_WAIT_ANFT, 1, event, 0, 0);           total_errors := total_errors +1;            CleanupAndTerminate (total_errors, INTERNAL_ERROR);           END;       
      END;  { CASE } 
     END;  { InStateWaitForAnft }          $Page   #{-------------------------------------------------------------------}  # #{                             LOG EVENT                             }  # #{-------------------------------------------------------------------}  # "{ Log an event to the log file. Currently all events are errors (no  " { warnings).  {   { Parameters:   {   {     nft_log_error_code (Input)  "{        An error code defined by NFT/1000 which indicates the cause " {        of the error.  {   {     instance (Input)  {        Gives the instance of the error code. This will be a   "{        different number for each location where LogEvent is called " {        with the given nft_log_error_code.   {   
{     parm1 (Input)  
 !{        A parameter whose usage depends on the nft_log_error_code ! {   
{     parm2 (Input)  
 !{        A parameter whose usage depends on the nft_log_error_code ! {   
{     parm3 (Input)  
 !{        A parameter whose usage depends on the nft_log_error_code ! {}  
PROCEDURE  LogEvent  
    (nft_log_error_code : Int16;       instance           : Int16;       parm1              : Int32;       parm2              : Int32;       parm3              : Int32);      VAR      dummy    : ContextWords;      info_msg : ARRAY [1..4] OF Int16;  
   result   : Int16; 
 
   wkmp     : Int16; 
     BEGIN      dummy.longint := 0;     info_msg [1]  := nft_log_error_code;   
   info_msg [2]  := parm1; 
 
   info_msg [3]  := parm2; 
 
   info_msg [4]  := parm3; 
        DS_EnterCritical (wkmp, result);          IF result = 0 THEN         BEGIN         Log_Event (EL_ERROR, HP_NFT, instance, dummy, 4,                   info_msg [1], result);         DS_LeaveCritical (wkmp);  	      END;  { IF } 	     	END;  { LogEvent } 	         $Page   #{-------------------------------------------------------------------}  # #{                              MIN                                  }  # #{-------------------------------------------------------------------}  # { Return the minimum of the two parameters  {}  FUNCTION  Min      (    first   : Int16;          second  : Int16)      : Int16;      BEGIN   
   IF first < second THEN  
 	      Min := first 	    ELSE   
      Min := second; 
     END;  { Min }           $Page   #{-------------------------------------------------------------------}  # #{                       PARSE COPY COMMAND                          }  # #{-------------------------------------------------------------------}  # #{ Parse a copy command and place the pieces into user_command_fields.  # !{ If any error is encountered in parsing, this procedure will exit ! { and the appropriate error will be returned.   {   { Parameters:   {   {     command (Input)   {        Carries in a user copy command ready to be parsed. It   {        must have been preparsed by PreparseCommand first. The    {        command cannot be null.  {   {     user_command_fields (Input/Output)   {        If some global defaults are in effect then this record    {        will carry them in, else it will be empty. The parsed  {        command will be returned here  {   
{     null_fields (Output) 
 {        Returns a flag for each field of user_command_fields   {        that was given but is null (e.g., a null logon would   {        have been given as "[]" and has different meaning  {        from no account delimiters at all).  {   
{     option_name (Output) 
 {        If an unrecognized option is found, this returns it  {   {     nft_error (Output)  {        Returns an Nft error code if is <> 0   {}  PROCEDURE  ParseCopyCommand      (VAR command             : String;       VAR user_command_fields : UserCommandFieldsType;      VAR null_fields         : NullFieldsType;       VAR option_name         : String;       VAR nft_error           : Int16);       LABEL      99;   { Labels end of the procedure }      VAR   
   comma_index    : Int16; 
 
   index          : Int16; 
 
   left_index     : Int16; 
 
   right_index    : Int16; 
 
   start_index    : Int16; 
    temp_command   : CommandStringType;     two_chars      : String2;      BEGIN      nft_error       := 0;     null_fields.int := 0;         { First trim off any spaces }     command := StrLTrim (command);      command := StrRTrim (command);       "   { This next piece of code checks if there are any commas in the } " "   { source logon string. If there are then they are ignored.      } " #   left_index  := FindUnquotedChar (command, 1, StrLen(command), '['); # #   right_index := FindUnquotedChar (command, 1, StrLen(command), ']'); # $   comma_index := FindUnquotedChar (command, 1, StrLen(command), COMMA); $     #   { If the left and right brackets are present, and the first comma } # #   { falls between them then start searching for the comma following } # #   { the last square bracket, otherwise the first comma found will   } # #   { serve to delimit the source and target specifications.          } #    IF (left_index > 0) AND (right_index > 0) AND  #      (comma_index > left_index) AND (comma_index < right_index) THEN  #       start_index := right_index     ELSE         start_index := 1;       $   { Find the comma which separates the source specification from the }  $ $   { the target. If there is one (there may only be a source spec)    }  $ $   { then make index point to previous char, else the whole string.   }  $ $   { Start searching for the comma at 'start_index'.                  }  $ #   index := FindUnquotedChar (command, start_index, StrLen (command),  #                               COMMA);      IF index <> 0 THEN         index := index -1      ELSE         index := StrLen (command);         { Copy the part of the command we are interested in }     temp_command := Str (command, 1, index);          WITH user_command_fields, null_fields DO         BEGIN         { Parse the source file, logon and node name }        ParseSourceOrTargetSpec (SOURCE, temp_command, uc_sfile,                                  uc_slogon, uc_snode, null_fields,                                  nft_error);            { If error occurred then exit }         IF nft_error <> 0 THEN  	         GOTO 99;  	     !      { If we have exhausted the command then exit, otherwise   }  ! !      { delete the part of the command we just parsed including }  ! !      { the comma following it (which must be there).           }  !       IF index = StrLen (command) THEN           GOTO 99        ELSE           StrDelete (command, 1, index +1);      #      { If the string 'TO' is present and it looks like a delimiter }  # #      { then delete it from the command.                            }  #       IF StrLen (command) > 1 THEN           BEGIN           two_chars := Str (command, 1, 2);           CaseFold (two_chars);               { Find the next unquoted comma }   !         index := FindUnquotedChar (command, 1, StrLen (command),  !                                     COMMA);       !         { If the first two chars of the command are 'TO' then   } ! !         { they may be a delimiter. They are if the index of the } ! !         { next comma is just after them ('TO,'), or there is no } ! !         { comma after (e.g., user gave 'FILE TO'). Note that    } ! !         { there will be a comma before and after the delimiter  } ! !         { 'TO' put there either by the CI or us.                } !          IF (two_chars = 'TO') AND              ( (index = 3) OR               ((index = 0) AND (StrLen (command) = 2)) ) THEN  	            BEGIN  	             { There is a 'TO' there and it is a delimiter }               IF index = 0 THEN   !               command := ''               { 'TO' was at the end } !             ELSE                 StrDelete (command, 1, 3);  { Delete 'TO,' }               END;  { IF two_chars }               END;  { IF StrLen }      #      { At this point the command may contain the target file, logon } # #      { and node name and maybe some options. The command could also } # #      { be null. Parse the target specification next.                } #     $      { This next piece of code checks if there are any commas in the }  $ $      { target logon string. If there are then they are ignored.      }  $ %      left_index  := FindUnquotedChar (command, 1, StrLen(command), '[');  % %      right_index := FindUnquotedChar (command, 1, StrLen(command), ']');  % "      comma_index := FindUnquotedChar (command, 1, StrLen(command),  "                                        COMMA);      %      { If the left and right brackets are present, and the first comma }  % %      { falls between them then start searching for the comma following }  % %      { the last square bracket, otherwise the first comma found will   }  % %      { serve to delimit the target specification from the options.     }  %       IF (left_index > 0) AND (right_index > 0) AND   $         (comma_index > left_index) AND (comma_index < right_index) THEN $          start_index := right_index         ELSE  
         start_index := 1; 
     #      { Now find the comma which separates the target specification }  # #      { from the beginning of the options starting at 'start_index'.}  # $      index := FindUnquotedChar (command, start_index, StrLen (command), $                                  COMMA);        IF index = 0 THEN            index := StrLen (command)        ELSE           index := index -1;             { Copy the part of the command we are interested in }         temp_command := Str (command, 1, index);            { Parse the target file, account and node name }        ParseSourceOrTargetSpec (TARGET, temp_command, uc_tfile,                                  uc_tlogon, uc_tnode, null_fields,                                  nft_error);      !      { If we got an error or the command is exhausted the exit }  !       IF (nft_error <> 0) OR (index = StrLen (command)) THEN  	         GOTO 99;  	           { Delete the part of the command we just parsed }         StrDelete (command, 1, index +1);             { Only the options are left so parse them }         ParseOptions (command, user_command_fields, null_fields,                      option_name, nft_error);            END;  { WITH user_command_fields }      99:   
END;  { ParseCopyCommand } 
         $Page   #{-------------------------------------------------------------------}  # #{                           PARSE OPTIONS                           }  # #{-------------------------------------------------------------------}  # #{ Given the part of the user command that contains the options, parse  #  { them and place the result in user_command_fields. If an error    !{ occurs in parsing an option then this procedure exist returning  ! { the option name and the Nft error.  {   { Parameters:   {   {     command (Input)   {        Contains the options part of a user command  {   {     user_command_fields (Input/Output)  !{        When each option is parsed, pertinent info is placed here ! {   
{     null_fields (Output) 
 "{        Returns a flag for each option that was given but is null.  "  {        For example "RSIZE=0" would set the the flag for rsize    {        indicating it was given but is null.   {   {     opt_name (Output)   {        If an unknown is found then this returns its name  {   {     nft_error (Output)  {        Returns an Nft error code if <> 0  {}  PROCEDURE  ParseOptions      (VAR command             : String;       VAR user_command_fields : UserCommandFieldsType;      VAR null_fields         : NullFieldsType;       VAR opt_name            : String;       VAR nft_error           : Int16);       LABEL      99;   { Labels end of the procedure }      VAR      index       : Int16;      opt_name16  : Int16;   
   opt_parm    : String10; 
     $Page   #   {----------------------------------------------------------------}  # #   { (Local)          CLEAR TRANSIENT SET INTERCH           (Local) }  # #   {----------------------------------------------------------------}  # !   { An interchange transfer option was requested by the user. If  ! "   { the transient option was given then we have a conflict so clear "     { the transient flag and print a warning. In either case set       { the interchange option.     {     { Parameters      {}      PROCEDURE  ClearTransientSetInterch        (VAR user_command_fields : UserCommandFieldsType);         BEGIN        WITH user_command_fields DO            BEGIN           IF uc_xfer_type = TRANSIENT THEN   	            BEGIN  	             PrintErrorOrWarn                 (WARN, list, 0, INTER_OVERRIDES_TRANSIENT,                   0, 0, null_string);               END;  { IF uc_xfer_type }                uc_xfer_type := INTERCHANGE;            END;  { WITH user_command_fields }          END;  { ClearTransientSetInterch }           $Page   #   {----------------------------------------------------------------}  # #   { (Local)                 DECODE OPTION                  (Local) }  # #   {----------------------------------------------------------------}  # "   { Decode an option whose first two chars are given as an integer, "    { and place the info in user_command_fields     {     { Parameters:     {     {     opt_name16 (Input)   !   {        Carries in the upshifted first two chars of the option !    {        name as an integer.      {  
   {     opt_name (Input)  
    {        Carries in the actual name of the option     {  
   {     opt_parm (Input)  
    {        Carries in the option parameter string     {     {     user_command_fields (Input/Output)   !   {        Fill in the field corresponding to the option decoded  !    {     {     nft_error (Output)      {        Returns the Nft error code if <> 0     {}   
   PROCEDURE  DecodeOption 
       (VAR opt_name16          : Int16;          VAR opt_name            : String;         VAR opt_parm            : String;         VAR user_command_fields : UserCommandFieldsType;          VAR nft_error           : Int16);         LABEL        99;   { Labels end of the procedure }          VAR        dummy    : Int16;         value32  : Int32;          BEGIN        nft_error := 0;       !      { Ignore null options. Could occur with successive commas }  !       IF StrLen (opt_name) < 1 THEN   	         GOTO 99;  	           WITH user_command_fields, null_fields DO           BEGIN           CASE opt_name16 OF   
            APPEND_OPTION: 
 
               BEGIN 
                 IF uc_toptns.replace OR uc_toptns.overwrite THEN                      BEGIN   "                  PrintErrorOrWarn (WARN, list, 0, APPEND_OVERRIDES, "                                     0, 0, null_string);                     uc_toptns.whole_byte := 0;                    END;  { IF }                 ClearTransientSetInterch (user_command_fields);                 uc_toptns.append := TRUE;                 END;  { APPEND }       
            ASCII_OPTION:  
 
               BEGIN 
                IF uc_data_type = BINARY THEN                    PrintErrorOrWarn                       (WARN, list, 0, DATA_TYPE_OVERRIDES,                         0, 0, opt_name);                 ClearTransientSetInterch (user_command_fields);                 uc_data_type := ASCII;                  END;  { ASCII }      
            BINARY_OPTION: 
 
               BEGIN 
                IF uc_data_type = ASCII THEN                     PrintErrorOrWarn                       (WARN, list, 0, DATA_TYPE_OVERRIDES,                         0, 0, opt_name);                 ClearTransientSetInterch (user_command_fields);                 uc_data_type := BINARY;                 END;  { BINARY }                   COMPRESS_OPTION:  
               BEGIN 
                uc_compress := TRUE;                  END;  { COMPRESS }      {}   
   {        DIRECT_OPTION: 
 
   {           BEGIN 
    {           IF uc_file_organ = SEQUENTIAL THEN      {              PrintErrorOrWarn     {                 (WARN, list, 0, FILE_TYPE_OVERRIDES,      {                  0, 0, opt_name);     {           ClearTransientSetInterch (user_command_fields);     {           uc_file_organ := DIRECT;      {           END;  { DIRECT }      {}   
            FCODE_OPTION:  
 
               BEGIN 
                entered_error_handler := FALSE;                 converting_to_integer := TRUE;                  StrRead (opt_parm, 1, dummy, value32);                  converting_to_integer := FALSE;                     IF entered_error_handler OR                    (value32 > 32767)     OR                    (value32 < -32768)    THEN                    BEGIN                     nft_error := ERROR_IN_OPTION_VALUE;   
                  GOTO 99; 
                   END;  { IF }      "               { Check if we are overriding a global specification } "                IF uc_fcode <> 0 THEN  !                  PrintErrorOrWarn (WARN, list, 0, PARM_OVERRIDES, !                                     0, 0, opt_name);                 uc_fcode := value32;                  nf_fcode := uc_fcode = 0;                 END;  { FCODE }      
            FIXED_OPTION:  
 
               BEGIN 
                IF uc_record_type = VARIABLE THEN  #                  PrintErrorOrWarn (WARN, list, 0, REC_TYPE_OVERRIDES, #                                     0, 0, opt_name);                 ClearTransientSetInterch (user_command_fields);                 uc_record_type := FIXED;                  END;  { FIXED }      
            FSIZE_OPTION:  
 
               BEGIN 
                entered_error_handler := FALSE;                 converting_to_integer := TRUE;                  StrRead (opt_parm, 1, dummy, value32);                  converting_to_integer := FALSE;                     IF entered_error_handler OR (value32 < 0) THEN                     BEGIN                     nft_error := ERROR_IN_OPTION_VALUE;   
                  GOTO 99; 
                   END; { IF }       "               { Check if we are overriding a global specification } "                IF uc_fsize <> 0 THEN  #                  PrintErrorOrWarn (WARN, list, 0, PARM_OVERRIDES, 0,  #                                     0, opt_name);                  ClearTransientSetInterch (user_command_fields);                 uc_fsize := value32;                  nf_fsize := uc_fsize = 0;                 END;  { FSIZE }      
            ICHAR_OPTION:  
 
               BEGIN 
 "               { Check if we are overriding a global specification } "                IF StrLen (uc_ichar) <> 0 THEN   #                  PrintErrorOrWarn (WARN, list, 0, PARM_OVERRIDES, 0,  #                                     0, opt_name);   "               uc_ichar := Str (opt_parm, 1, Min (StrLen (opt_parm), " #                                                  StrMax (uc_ichar))); # $               { If the first character of the string is an ASCII zero } $ $               { then convert the numeric string to an ASCII character.} $ $               IF (StrLen (uc_ichar) > 0) AND (uc_ichar [1] = '0') THEN  $                   BEGIN                     entered_error_handler := FALSE;                     converting_to_integer := TRUE;                    StrRead (opt_parm, 1, dummy, value32);                    converting_to_integer := FALSE;                         IF entered_error_handler OR                         (value32 > 255)       OR (value32 < 0) THEN   
                     BEGIN 
                      nft_error := ERROR_IN_OPTION_VALUE;                       GOTO 99;                        END;  { IF entered }                         uc_ichar_value.int   := value32;                    uc_ichar_value.valid := TRUE;                     END;  { IF (StrLen }                     nf_ichar := StrLen (uc_ichar) = 0;                  END;  { ICHAR }                  INTERCHANGE_OPTION:   
               BEGIN 
                ClearTransientSetInterch (user_command_fields);                 END;  { INTERCHANGE }                  MOVE_OPTION:  
               BEGIN 
                uc_move := TRUE;                  END;  { MOVE }                   OVERWRITE_OPTION:   
               BEGIN 
                IF uc_toptns.append OR uc_toptns.replace THEN                    BEGIN   $                  PrintErrorOrWarn (WARN, list, 0, OVERWRITE_OVERRIDES,  $                                     0, 0, null_string);                     uc_toptns.whole_byte := 0;                    END;  { IF }                 uc_toptns.overwrite := TRUE;                  END;  { OVERWRITE }      
            QUIET_OPTION:  
 
               BEGIN 
                uc_quiet := TRUE;                 END;  { QUIET }                  REPLACE_OPTION:   
               BEGIN 
                IF uc_toptns.append OR uc_toptns.overwrite THEN                    BEGIN   #                  PrintErrorOrWarn (WARN, list, 0, REPLACE_OVERRIDES,  #                                     0, 0, null_string);                     uc_toptns.whole_byte := 0;                    END;  { IF }                 uc_toptns.replace := TRUE;                  END;  { REPLACE }      
            RSIZE_OPTION:  
 
               BEGIN 
                entered_error_handler := FALSE;                 converting_to_integer := TRUE;                  StrRead (opt_parm, 1, dummy, value32);                  converting_to_integer := FALSE;                     IF entered_error_handler OR (value32 < 0) THEN                     BEGIN                     nft_error := ERROR_IN_OPTION_VALUE;   
                  GOTO 99; 
                   END;  { IF }      "               { Check if we are overriding a global specification } "                IF uc_rsize <> 0 THEN  !                  PrintErrorOrWarn (WARN, list, 0, PARM_OVERRIDES, !                                     0, 0, opt_name);                 ClearTransientSetInterch (user_command_fields);                 uc_rsize := value32;                  nf_rsize := uc_rsize = 0;                 END;  { RSIZE }      
            SCHAR_OPTION:  
 
               BEGIN 
 "               { Check if we are overriding a global specification } "                IF StrLen (uc_schar) <> 0 THEN   #                  PrintErrorOrWarn (WARN, list, 0, PARM_OVERRIDES, 0,  #                                     0, opt_name);   "               uc_schar := Str (opt_parm, 1, Min (StrLen (opt_parm), " #                                                  StrMax (uc_schar))); # $               { If the first character of the string is an ASCII zero } $ $               { then convert the numeric string to an ASCII character.} $ $               IF (StrLen (uc_schar) > 0) AND (uc_schar [1] = '0') THEN  $                   BEGIN                     entered_error_handler := FALSE;                     converting_to_integer := TRUE;                    StrRead (opt_parm, 1, dummy, value32);                    converting_to_integer := FALSE;                         IF entered_error_handler OR                         (value32 > 255)       OR (value32 < 0) THEN   
                     BEGIN 
                      nft_error := ERROR_IN_OPTION_VALUE;                       GOTO 99;                        END;  { IF entered }                         uc_schar_value.int   := value32;                    uc_schar_value.valid := TRUE;                     END;  { IF (StrLen }                     nf_schar := StrLen (uc_schar) = 0;                  END;  { SCHAR }     {}      {        SEQUENTIAL_OPTION:  
   {           BEGIN 
    {           IF uc_file_organ = DIRECT THEN   $   {              PrintErrorOrWarn (WARN, list, 0, FILE_TYPE_OVERRIDES,  $    {                                0, 0, opt_name);     {           ClearTransientSetInterch (user_command_fields);     {           uc_file_organ := SEQUENTIAL;      {           END;  { SEQUENTIAL }      {}   
            STRIP_OPTION:  
 
               BEGIN 
                ClearTransientSetInterch (user_command_fields);                 uc_strip := TRUE;                 END;  { STRIP }     {}      {        TRANSIENT_OPTION:   
   {           BEGIN 
    {           WITH user_command_fields DO     {              BEGIN      {              { If any interchange attribute is set then }     {              { clear them all, and print warning        }     {              IF (uc_data_type <> 0)          OR     {                 (uc_file_organ <> 0)         OR     {                 (uc_record_type <> 0)        OR     {                 (uc_rsize <> 0)              OR     {                 (uc_fsize <> 0)              OR     {                 (uc_xfer_type = INTERCHANGE) THEN  
   {                 BEGIN 
    {                 uc_data_type   := 0;      {                 uc_file_organ  := 0;      {                 uc_record_type := 0;      {                 uc_rsize       := 0;      {                 uc_fsize       := 0;      {                 PrintErrorOrWarn   !   {                    (WARN, list, 0, TRANSIENT_OVERRIDES_INTER, !    {                     0, 0, null_string);     {                 END;  { IF }      {     {              uc_xfer_type := TRANSIENT;     {              END;  { WITH }     {           END;  { TRANSIENT }     {}               VARIABLE_OPTION:  
               BEGIN 
                IF uc_record_type = FIXED THEN   #                  PrintErrorOrWarn (WARN, list, 0, REC_TYPE_OVERRIDES, #                                     0, 0, opt_name);                 ClearTransientSetInterch (user_command_fields);                 uc_record_type := VARIABLE;                 END;  { VARIABLE }                   OTHERWISE   
               BEGIN 
                nft_error := UNKNOWN_XFER_OPTION;                 END;  { OTHERWISE }      
            END;  { CASE } 
          END;  { WITH }          99:  
   END;  { DecodeOption }  
         $Page   #   {----------------------------------------------------------------}  # #   { (Local)                 SPLIT OPTION                   (Local) }  # #   {----------------------------------------------------------------}  # #   { Split up an option and its parameter, separated by an equal sign  #    {     { Parameters:     {     {     command (Input)     {        Contains the option and maybe a parameter      {     {     end_option (Input)      {        An index into command where the option ends      {     {     opt_name16 (Output)  "   {        Returns the upshifted first two chars of the option name "    {  
   {     opt_name (Output) 
    {        Returns the given name of the option     {  
   {     opt_parm (Output) 
    {        Returns the given option parameter     {     {     nft_error (Output)      {        Returns an Nft error code if <> 0      {}   
   PROCEDURE  SplitOption  
       (VAR command      : String;          VAR end_option   : Int16;         VAR opt_name16   : Int16;         VAR opt_name     : String;          VAR opt_parm     : String;          VAR nft_error    : Int16);          LABEL        99;   { Labels end of the procedure }          VAR  
      index       : Int16; 
       two_chars   : TwoCharsType;          BEGIN        nft_error := 0;       #      index := FindUnquotedChar (command, 1, end_option, EQUAL_SIGN);  #           IF index < 2 THEN            BEGIN            { Either there is no option parameter present, or no }              { option name (e.g., '=OPTN'). Pull out what part of }              { the option name is there                           }             opt_name := Str (command, 1, Min (end_option,                                              StrMax (opt_name)) );            opt_parm := '';           END   { IF index }         ELSE           BEGIN            { There is an option parameter present so split them }             opt_name := Str (command, 1, Min (index -1,                                              StrMax (opt_name)) );   #         opt_parm := Str (command, index +1, Min (end_option - index,  # !                                             StrMax (opt_parm)) ); !          END;  { ELSE of IF index }             IF StrLen (opt_name) > 0 THEN            CaseFold (opt_name);       "      { Convert first two chars of option name to integer. If the }  " "      { length of the option is less than 2 chars then make the   }  " "      { integer value of the command an illegal value             }  "       IF StrLen (opt_name) < 2 THEN            two_chars.int := -1        ELSE           BEGIN           two_chars.char1 := opt_name [1];            two_chars.char2 := opt_name [2];            END;  { ELSE }             opt_name16 := two_chars.int;            SquezeOutQuotes (opt_parm);          99:     END;  { SplitOption }          $Page   BEGIN  { ParseOptions }          REPEAT         { Bailout if there are no more options }        IF StrLen (command) = 0 THEN  	         GOTO 99;  	     !      { Find the end of the next option. Recall that all options } ! !      { are delimited by commas                                  } ! #      index := FindUnquotedChar (command, 1, StrLen (command), COMMA); #     !      { If no more commas then the remainder of the command must } ! !      { be an option, else we don't care about the comma         } !       IF index = 0 THEN            index := StrLen (command)        ELSE           index := index -1;       !      { Pull out any parameter, and upshift the first two chars }  !       SplitOption (command, index, opt_name16, opt_name,                     opt_parm, nft_error);            IF nft_error <> 0 THEN  	         GOTO 99;  	           { Decode the option and fill in user_command_fields }         DecodeOption (opt_name16, opt_name, opt_parm,                       user_command_fields, nft_error);            IF nft_error <> 0 THEN  	         GOTO 99;  	     !      { If the option we just decoded was the last one then exit } ! !      { else delete the option from the command                  } !       IF index = StrLen (command) THEN           GOTO 99        ELSE           StrDelete (command, 1, index +1);         UNTIL FALSE;       99:   END;  { ParseOptions }          $Page   #{-------------------------------------------------------------------}  # #{                    PARSE SOURCE OR TARGET SPEC                    }  # #{-------------------------------------------------------------------}  # !{ Parse either the source or target specification within a copy or ! "{ default command. This consists of the "File[Logon]>Node" parts of  " { the command. Return these fields separately.  {   { Parameters:   {   {     source_or_target (Input)  {        Indicates whether the spec is the source or target   {   {     command (Input)   {        Carries in either the source or target spec  {   {     file_name (Output)  {        Returns the file name part of the spec if given  {   
{     logon (Output) 
 {        Returns the logon part of the spec if given  {   {     node_name (Output)  {        Returns the node name if given   {   
{     null_fields (Output) 
 {        Returns flags indicating if a particular field was   {        given but was null (e.g. null logon would be "[]")   {   {     nft_error (Output)  {        Returns an Nft error code if <> 0  {}  PROCEDURE  ParseSourceOrTargetSpec     (    source_or_target : SourceOrTargetType;      VAR command          : String;      VAR file_name        : FileNameType;      VAR logon            : LogonType;       VAR node_name        : NodeNameType;      VAR null_fields      : NullFieldsType;      VAR nft_error        : Int16);      LABEL      99;   { Labels end of the procedure }      VAR      index       : Int16;      index1      : Int16;      warning     : Int16;   
   warn_given  : BOOLEAN;  
     BEGIN      { If the command is empty then return }     IF StrLen (command) = 0 THEN         GOTO 99;         warn_given := FALSE;          { Determine what warning to generate if necessary }     IF source_or_target = SOURCE THEN        warning := SLOGON_OR_NODE_OVERRIDES      ELSE         warning := TLOGON_OR_NODE_OVERRIDES;      !   { Parse the logon string first. Check if the logon delimiters } ! !   { (always square brackets) are present.                       } ! !   index := FindUnquotedChar (command, 1, StrLen (command), '[');  !     
   IF index > 0 THEN 
       BEGIN         { The opening bracket is present, check for the second }  #      index1 := FindUnquotedChar (command, 1, StrLen (command), ']');  #       IF index1 < index THEN           BEGIN           nft_error := NO_CLOSING_SQUARE_BRACKET;  	         GOTO 99;  	          END;  { IF index1 }      !      { If there is already a logon in the logon string then it }  ! !      { was placed there from the global specs before we were   }  ! !      { called. Print a warning since were are overriding it    }  !       IF StrLen (logon) <> 0 THEN            BEGIN  #         PrintErrorOrWarn (WARN, list, 0, warning, 0, 0, null_string); #          warn_given := TRUE;           END;  { IF }       "      { Both brackets are present. If there is nothing between    }  " "      { them then set the logon string to zero, else pull it out  }  "       IF index + 1 = index1 THEN           BEGIN           logon := null_string;           { Set the proper flag indicating no logon given }           IF source_or_target = SOURCE THEN              null_fields.nf_slogon := TRUE            ELSE               null_fields.nf_tlogon := TRUE;  
         END  { IF } 
       ELSE           BEGIN           { Make sure the logon string is not too large }           IF index1 - index - 1 > MAX_NFT_LOGON_CHARS THEN   	            BEGIN  	             nft_error := LOGON_TOO_LONG;  
            GOTO 99; 
             END;  { IF index1 }                { Pull out the string between the square brackets }           logon := Str (command, index +1, index1 - index -1);            END;  { ELSE of IF index }             { Delete the square brackets and everything between }         StrDelete (command, index, index1 - index +1);             { At this point we should check for some syntax errors.  }          { By deleting parts of the command after they are parsed,}          { some erroneous input could be missed. In particular,   }          { we will check for the following:                       }          {   1) FILE>NODE[ACCOUNT]!                               }          {   2) FILE>NODE[ACCOUNT]>                               }          {   3) FILE[ACCOUNT]!>NODE                               }          { Where ! is any char but >. Note at this point variable }          { index points to the next character after the account   }         IF index <= StrLen (command) THEN            BEGIN           { There is something after the logon string }           IF command [index] <> '>' THEN               nft_error := ILLEGAL_COMMAND  { Illegal char }           ELSE   	            BEGIN  	 #            { The char after the logon is a '>'. If there's another }  # #            { one in the string before it, then error               }  # #            IF index <> FindUnquotedChar (command, 1, index, '>') THEN #                nft_error := ILLEGAL_COMMAND;              END;  { ELSE of IF command }               IF nft_error <> 0 THEN   
            GOTO 99; 
          END;  { IF index }         END;  { IF index }          { Now the command may contain a node name, file name, both }        { or neither. Parse out the node name next.                }    !   index := FindUnquotedChar (command, 1, StrLen (command), '>');  !     
   IF index > 0 THEN 
       BEGIN          { If the node name already contains something then it is }          { a global spec that was placed there before we were     }          { called so print a warning                              }         IF (StrLen (node_name) > 0) AND (NOT warn_given) THEN   #         PrintErrorOrWarn (WARN, list, 0, warning, 0, 0, null_string); #           { Make sure the node name is not too long }         IF StrLen (command) - index > MAX_NODE_NAME_CHARS THEN           BEGIN           nft_error := NODE_NAME_TOO_LONG;   	         GOTO 99;  	          END;  { IF }             { Pull off everything after the '>' for the node name }   #      node_name := Str (command, index +1, StrLen (command) - index);  #     "      { Since the node name delimiter was given but no node name, }  " "      { set the proper null field flag                            }  "       IF StrLen (node_name) = 0 THEN           BEGIN           IF source_or_target = SOURCE THEN              null_fields.nf_snode := TRUE           ELSE               null_fields.nf_tnode := TRUE;            END;  { IF }             { Delete the '>' along with the node name }         StrDelete (command, index, StrLen (command) - index +1);        END;  { IF index }         { Now all that remains is the file name. Check its length }     IF StrLen (command) > MAX_NFT_FILE_CHARS THEN        BEGIN         nft_error := FILE_NAME_TOO_LONG;        GOTO 99;  	      END;  { IF } 	        file_name := command;          { Now that we have parsed the three string fields, each may }       { contain quotation marks so pull all of those out. Recall  }       { that two consecutive quotes means one                     }      SquezeOutQuotes (file_name);      SquezeOutQuotes (logon);      SquezeOutQuotes (node_name);       99:   END;  { ParseSourceOrTargetSpec }           $Page   #{-------------------------------------------------------------------}  # #{                         PREPARSE COMMAND                          }  # #{-------------------------------------------------------------------}  # !{ Preparse any input command. This prepares the command for later  ! "{ parsing by generalizing it. For example semi-colons are converted  "  { to commas and commas are substituted for spaces. Returned is a   { command with all spaces removed and commas as delimiters.   {   { Parameters:   {   {     command (Input/Output)   {        Carries in the command to be preparsed and returns the    {        preparsed command.   {   {     nft_error (Output)  {        Returns an Nft error code if <> 0  {}  
PROCEDURE  PreparseCommand 
    (VAR command   : String;       VAR nft_error : Int16);       LABEL      99;   { Labels end of the procedure }      VAR      index             : Int16;      number_quotes     : Int16;      semi_colon_index  : Int16;      str_index         : Int16;       $Page   #   {----------------------------------------------------------------}  # #   { (Local)            INSERT COMMAS FOR SPACES            (Local) }  # #   {----------------------------------------------------------------}  # !   { Insert a single comma in a run of spaces. A run of spaces is  !     { defined as a string of spaces without commas or semi-colons      { around it.      {     { Parameters:     {     {     string_parm (Input/Output)      {        Contains the string to be converted      {}      PROCEDURE  InsertCommasForSpaces         (VAR string_parm  : String);         VAR        all_done       : BOOLEAN;         next_non_space : Int16;         old_index      : Int16;         space_index    : Int16;          BEGIN        { First trim off all spaces from the command }        string_parm := StrLTrim (string_parm);        string_parm := StrRTrim (string_parm);            all_done    := FALSE;         space_index := 1;             REPEAT  !         { Find the next unquoted space starting at space_index }  !          old_index := space_index;  !         space_index := FindUnquotedChar(string_parm, space_index, !                                 StrLen (string_parm), SPACE);                { Check if a space was found in the string }            IF space_index = 0 THEN  	            BEGIN  	             { A space was not found so bailout }              all_done := TRUE;               END  { IF }            ELSE   	            BEGIN  	 !            { A space was found. Go ahead until finding the next } ! !            { non-space character.                               } !                 next_non_space := space_index;              WHILE string_parm [next_non_space] = SPACE DO                  next_non_space := next_non_space +1;       #            { If neither of the two non-space characters delimiting }  # #            { the space(s) is a comma, then stick one in            }  #             IF (string_parm [space_index -1] <> COMMA) AND                 (string_parm [next_non_space] <> COMMA) THEN   
               BEGIN 
                string_parm [space_index] := COMMA;                 END;  { IF (string_parm }                  space_index := next_non_space;  
            END;  { ELSE } 
           UNTIL all_done;          END;  { InsertCommasForSpaces }      $Page   
BEGIN  { PreparseCommand } 
     	   nft_error := 0; 	        { Trim off all leading and trailing spaces }      command := StrLTrim (command);      command := StrRTrim (command);          { Remove all trailing delimiters }      str_index := StrLen (command);      WHILE (str_index > 0)                      AND            ((command [str_index] = COMMA)       OR            (command [str_index] = SPACE)       OR            (command [str_index] = SEMI_COLON)) DO        BEGIN         str_index := str_index -1;        END;  { WHILE }      SetStrLen (command, str_index);         { Check for a null command }      IF StrLen (command) = 0 THEN         BEGIN         nft_error := ILLEGAL_COMMAND;         GOTO 99;  	      END;  { IF } 	         { If there are an odd number of quotation marks then one of }       { them was an unclosed quote so bomb out                    }      number_quotes := 0;     FOR index := 1 TO StrLen (command) DO        IF command [index] = QUOTE THEN            number_quotes := number_quotes +1;      IF Odd (number_quotes) THEN        BEGIN         nft_error := ODD_NUMBER_QUOTES;         GOTO 99;  	      END;  { IF } 	     #   { The following while loop will find all non-quoted semi-colons. }  # #   { All commas or spaces to the left or right of it are converted  }  # #   { into spaces. This undoes the CI's trick of inserting commas    }  # #   { for spaces when semi-colons are present with spaces. This also }  # #   { works for interactively read strings since semi-colons and     }  # #   { commas cannot be mixed together in the same sub-string.        }  #     	   str_index := 1; 	    WHILE str_index < StrLen (command) DO        BEGIN         { Find an unquoted semi-colon }   
      semi_colon_index :=  
           FindUnquotedChar (command, str_index, StrLen (command),                              SEMI_COLON);         { Check if a semi-colon was found }         IF semi_colon_index = 0 THEN           BEGIN           { No semi-colons found so bailout }           str_index := StrLen (command);   
         END  { IF } 
       ELSE           BEGIN            { Semi-colon found. Make all commas and spaces to the }             { left of the semi-colon into spaces. Beware that the }             { first character could be a delimiter.               }            str_index := semi_colon_index -1;           WHILE (str_index > 0)                 AND                 ((command [str_index] = COMMA)  OR                   (command [str_index] = SPACE)) DO   	            BEGIN  	             command [str_index] := SPACE;               str_index           := str_index -1;              END;  { WHILE }                { Make all spaces and commas to the right of the }            { semi-colon into spaces also. There can be no   }            { delimiters at the end of the command           }            str_index := semi_colon_index +1;           WHILE (command [str_index] = COMMA) OR                  (command [str_index] = SPACE) DO   	            BEGIN  	             command [str_index] := SPACE;               str_index           := str_index +1;              END;  { WHILE }                END;  { ELSE of IF semi_colon_index }        END;  { WHILE str_index }           { Now substitute commas for all of the unquoted semi-colons }      SubstCharUnlessQuoted (command, 1, StrLen (command),                             SEMI_COLON, COMMA);          { If the user just gave a string of one or more spaces as }     { any delimiter(s), then stick in commas there            }     InsertCommasForSpaces (command);          SquezeOutSpaces (command);       99:   
END;  { PreparseCommand }  
         $Page   #{-------------------------------------------------------------------}  # #{                        PRINT ERROR OR WARN                        }  # #{-------------------------------------------------------------------}  # "{ Print an error or warning on the given file. There are three types "  { of errors that could be printed: file system, NFT Protocol or    "{ NFT/1000 and IPC errors. If any of the errors is non-zero then it  " { will be mapped to a string and printed.   {   { Parameters:   {   {     error_or_warn (Input)   {        Will be either ERROR or WARN   {   {     which_file  "{        Indicates which file the error or warning should printed on " {   {     fmp_error_parm (Input)  #{        If a local Fmp error occurred then this will give that error  # {        as a negative number, else will be zero.   {   {     nft_error (Input)   !{        Gives an error or warning to be printed. If negative then ! {        it gives an NFT Protocol error code, else it gives an  {        NFT/1000 error or warning.   {   {     ipc_error (Input)   "{        If non-zero gives an IPC error that occurred that should be " {        mapped to a string and printed.  {   {     rsm_error (Input)   #{        If non-zero gives an Rsm/1000 error that occurred and should  # {        be mapped to a string and printed.   {   
{     string_parm (Input)  
 !{        This string may further qualify the nft error or warning. ! !{        It may or may not be null. If the error or warning in the !  {        error string contains a "!" in it then this string will   {        be substituted for it.   {}  PROCEDURE  PrintErrorOrWarn      (    error_or_warn   : ErrorOrWarnType;      VAR which_file      : Text;           fmp_error_parm  : Int16;          nft_error       : Int16;          ipc_error       : Int32;          rsm_error       : Int16;      VAR string_parm     : String);      LABEL      99;   { Labels end of the procedure }      VAR      error_pac      : ErrorPacType;      error_string   : ErrorStringType;  
   index          : Int16; 
     BEGIN   !   { If the message is a warning and "quiet" was given then exit } ! !   IF (error_or_warn = WARN) AND user_command_fields.uc_quiet THEN !       GOTO 99;         IF StrLen (string_parm) > 0 THEN         CaseFold (string_parm);          { If there was an Fmp error then print it }     IF fmp_error_parm <> 0 THEN        BEGIN         SetStrLen (error_string, 64);         FmpError (fmp_error_parm, error_string);        error_string := StrRTrim (error_string);        writeln (which_file, error_string, ' ', string_parm);         END;  { IF fmp_error_parm }          { If there was an Nft error then print it }  
   IF nft_error <> 0 THEN  
       BEGIN         error_pac := ' ';    { Blank fill error_pac }         AdsErrorLookup (NFT_SERVICE, nft_error, error_pac);         SetStrLen (error_string, StrMax (error_string));        FOR index := 1 TO ERROR_STRING_SIZE DO           error_string [index] := error_pac [index];         error_string := StrRtrim (error_string);             { If there was a '!' in the error string then substitute }          { string_parm for it                                     }         index := StrPos (error_string, '!');        IF index > 0 THEN            BEGIN           StrDelete (error_string, index, 1);           { Shorten string_parm if it does not fit }            IF StrLen (string_parm) + StrLen (error_string) >              StrMax (error_string)                        THEN   	            BEGIN  	             SetStrLen (string_parm, StrMax (error_string) -                                       StrLen (error_string));               END;  { IF StrLen }            StrInsert (string_parm, error_string, index);           END;  { IF index }             writeln (which_file, error_string);         END;  { IF nft_error <> 0 }       !   { If there was an Ipc error then print it. Presumably, there }  ! !   { was an Nft error printed above which this will clarify.    }  ! 
   IF ipc_error <> 0 THEN  
       BEGIN         error_pac := ' ';    { Blank fill error_pac }         AdsErrorLookup (IPC_SERVICE, ipc_error, error_pac);         SetStrLen (error_string, StrMax (error_string));        FOR index := 1 TO ERROR_STRING_SIZE DO           error_string [index] := error_pac [index];         error_string := StrRtrim (error_string);        writeln (which_file, error_string);         END;  { IF ipc_error }      !   { If there was an Rsm error then print it. Presumably, there }  ! !   { was an Nft error printed above which this will clarify.    }  ! 
   IF rsm_error <> 0 THEN  
       BEGIN         error_pac := ' ';    { Blank fill error_pac }         AdsErrorLookup (RSM_SERVICE, rsm_error, error_pac);         SetStrLen (error_string, StrMax (error_string));        FOR index := 1 TO ERROR_STRING_SIZE DO           error_string [index] := error_pac [index];         error_string := StrRtrim (error_string);        IF StrLen (error_string) > 0 THEN            writeln (which_file, error_string);        END;  { IF rsm_error }      99:   
END;  { PrintErrorOrWarn } 
         $Page   #{-------------------------------------------------------------------}  # #{                         PRINT HELP INFO                           }  # #{-------------------------------------------------------------------}  # !{ Print a help message to the output file. First open the message  ! { file and then pull out the correct message  {   { Parameters:   {   
{     help_request (Input) 
 !{        String which carries in a help request beginning with '?' ! {}  PROCEDURE  PrintHelpInfo     (VAR help_request : String);       VAR      chars_to_delete : Int16;      line            : String [80];      lookup_string   : String [2];         $BUFFERS 20$   
   message_file    : Text; 
    $BUFFERS 1$      $Page   #{-------------------------------------------------------------------}  # #{ (Local)                 OPEN MESSAGE FILE                 (Local) }  # #{-------------------------------------------------------------------}  # "{ Open the message file. It may be in two different places with two  " { different names. It could be on a new directory or on an old  { cartridge.  {   { Parameters:   {   {     entered_error_handler (Output)  {        Returns true if an error occurred in opening the file  {}  
PROCEDURE  OpenMessageFile 
    (VAR entered_error_handler : BOOLEAN);       BEGIN      entered_error_handler := FALSE;     opening_file := TRUE;         { Try to open the first message file }      reset (message_file, MESSAGE_FILE_NAME1, 'SHARED');         { If we can't find the first file then try the second }     IF entered_error_handler THEN        BEGIN         entered_error_handler := FALSE;         reset (message_file, MESSAGE_FILE_NAME2, 'SHARED');   	      END;  { IF } 	     
   opening_file := FALSE;  
     
END;  { OpenMessageFile }  
     $Page   "{------------------------------------------------------------------} " "{ (Local)               PRINT HELP SUMMARY                 (Local) } " "{------------------------------------------------------------------} " { Print a summary of all Dscopy commands and options.   {}  PROCEDURE  PrintHelpSummary;      CONST          HELP0 =  &'------------------------- NETWORK FILE TRANSFER -------------------------'; &    HELP1 =  
'Copy Descriptor Syntax:'; 
    HELP2 =   '   srcfile[logon]>node TO targfile[logon]>node opt1 opt2 ...';       HELP3 =  &'     Defaults: Logon--Current logon if node is local.  Node--local node.';  &    HELP4 =  'Commands:';     HELP5 =  '   +CL .................... CLEAR current defaults';      HELP6 =   '   +DE copydescriptor ..... Set DEFAULTs for copy descriptors';      HELP7 =  '   +EC [ON/OFF] ........... ECHO commands to list file';      HELP8 =  '   +EX .................... EXIT Dscopy';     HELP9 =  '   +LL filename ........... Set up LIST file';      HELP10 =   '   +RU progname ........... RUN a program';     HELP11 =   '   +SH .................... SHOW current defaults';     HELP12 =    '   +TR filename ........... TRANSFER control to command file';       HELP13 =   !'   +WD [directory] ........ Display or change WORKING DIRECTORY'; !    HELP14 =   'Options:';      HELP15 =   $'   APpend     COmpress    FSize        MOve         REplace     STrip'; $    HELP16 =   &'   AScii      FCode       IChar        OVerwrite    RSize       VAriable';  &    HELP17 =   '   BInary     FIxed       INterchange  QUiet        SChar';     HELP18 =   'For more help enter:';      HELP19 =   %'   ?,CD       for copy descriptors     ?,LO  for entering long commands'; %    HELP20 =   "'   ?,command  for a command            ?,RN  for run string info';  "    HELP21 =   '   ?,option   for an option';      BEGIN      writeln (output, HELP0);       writeln (output, HELP1);            writeln (output, HELP2);        writeln (output, HELP3);            writeln (output, HELP4);        writeln (output, HELP5);            writeln (output, HELP6);        writeln (output, HELP7);            writeln (output, HELP8);        writeln (output, HELP9);            writeln (output, HELP10);       writeln (output, HELP11);           writeln (output, HELP12);       writeln (output, HELP13);           writeln (output, HELP14);       writeln (output, HELP15);           writeln (output, HELP16);       writeln (output, HELP17);           writeln (output, HELP18);       writeln (output, HELP19);           writeln (output, HELP20);      writeln (output, HELP21);           writeln (output);      
END;  { PrintHelpSummary } 
     $Page   
BEGIN   { PrintHelpInfo }  
        IF StrLen (help_request) < 2 THEN        BEGIN          { The help request consisted of only a '?' so pull out a }          { summary of all commands                                }         PrintHelpSummary;   	      END   { IF } 	    ELSE         BEGIN         { There is a parameter following the question mark so }         { go into the help file and pull that out.            }         IF help_request [2] = COMMA THEN           chars_to_delete := 2    { Delete '?,' }        ELSE           chars_to_delete := 1;   { Delete '?' }              { If there is a plus sign at the beginning of the comand }          { then remove it                                         }         IF (StrLen (help_request) > chars_to_delete)        AND            (help_request [chars_to_delete + 1] = PLUS_SIGN) THEN           chars_to_delete := chars_to_delete +1;             lookup_string := '~~';        StrDelete (help_request, 1, chars_to_delete);         StrInsert (lookup_string, help_request, 1);             { Chop the string down to 4 chars and case fold it }        IF StrLen (help_request) > 4 THEN            SetStrLen (help_request, 4);         IF StrLen (help_request) > 0 THEN            CaseFold (help_request);             { Try to open the message file }        OpenMessageFile (entered_error_handler);            { Handle any errors in opening the file }         IF entered_error_handler THEN            BEGIN  #         writeln (output, ' Help unavailable. Cannot open help file ', # !                  MESSAGE_FILE_NAME1, ' or ', MESSAGE_FILE_NAME2); !          { Ignore any error generated in the error handler }           global_fmp_error := 0;   
         END  { IF } 
       ELSE           BEGIN           { File opened ok. Search for the requested string }           REPEAT               readln (message_file, line);           UNTIL (line = help_request) OR (Eof (message_file));                IF Eof (message_file) THEN   	            BEGIN  	             { Requested string not found }              StrDelete (help_request, 1, 2);   %            write (output, ' No help available for ', help_request, '. '); %             writeln (output, 'Enter ? for general help.');              END  { IF Eof }            ELSE   	            BEGIN  	 #            { We found the string. Pull out the help info and print }  # 	            REPEAT 	                read (message_file, line);                  IF (line [1] <> '~') AND (line [1] <> '*') THEN                    writeln (output, line);                  readln (message_file);               UNTIL (line [1] = '~') OR (Eof (message_file));                   END;  { ELSE of IF Eof }               Close (message_file);               END;  { ELSE of IF entered }         END;  { ELSE of IF StrLen }       END;  { PrintHelpInfo }           $Page   "{------------------------------------------------------------------} " "{                       PRINT MESSAGE FIELDS                       } " "{------------------------------------------------------------------} " "{ A message has arrived from the producer which contains info to be  " !{ given to the user. Based on the particular message, pull out the ! 
{ info and print it. 
 {   { Parameters:   {   
{     main_buffer (Input)  
 {        Carries in the message to be printed   {}  PROCEDURE  PrintMessageFields      (VAR main_buffer : MainBufferType);      VAR   	   index : Int16;  	         $Page   "   {---------------------------------------------------------------} " "   { (Local)            PRINT AMOUNT TRANSFERRED           (Local) } " "   {---------------------------------------------------------------} "    { Print the amount and type of data that was transferred.     {}      PROCEDURE  PrintAmountTransferred        (amount : Int32;         units  : Int16);          CONST        BYTE_UNITS    = 1;        BITS16        = 2;        BITS32        = 3;        LOGICAL_RECS  = 4;        PHYSICAL_RECS = 5;        PERCENT       = 6;         BEGIN        { Amount means nothing if units = 0 }         IF units <> 0 THEN           BEGIN           write (list, ' ', amount:2);            CASE units OF              BYTE_UNITS:     write (list, ' bytes were');               BITS16:         write (list, ' 16-bit words were');                 BITS32:         write (list, ' 32-bit words were');                LOGICAL_RECS:   write (list, ' records were');              PHYSICAL_RECS:  write (list, ' blocks were');   "            PERCENT:        write (list, '% of the source file was') " 
            END;  { Case } 
              writeln (list, ' written to the target file.');           END;  { If }          END;  { PrintAmountTransferred }           $Page   "   {---------------------------------------------------------------} " "   { (Local)               PRINT ERROR STRINGS             (Local) } " "   {---------------------------------------------------------------} " #   { Print the error strings returned in a message from the producer.  #    { The message is sitting in global buffer main_buffer     {     { Parameters:     {     {     which_file (Input)      {        Gives the file where the info is to be printed     {     {     local_error_msg_ptr (Input)  !   {        An index into main_buffer where the local error begins !    {     {     error_code_enhan_ptr (Input)      {        An index into main_buffer where the error code      {        enhancement string begins (and the local error ends)      {     {     end_enhan_ptr (Input)     {        An index into main_buffer where the error code     {        enhancement string ends      {}      PROCEDURE  PrintErrorStrings         (VAR which_file           : Text;              local_error_msg_ptr  : Int16;             error_code_enhan_ptr : Int16;             end_enhan_ptr        : Int16);          VAR  
      index : Int16; 
        BEGIN        { Print the local error message string }        IF local_error_msg_ptr <> error_code_enhan_ptr THEN            BEGIN  $         FOR index := local_error_msg_ptr TO error_code_enhan_ptr -1 DO  $             write (which_file, main_buffer.chars [index]);           writeln (which_file);           END;  { IF }             { Print the error code enhancement string }         IF error_code_enhan_ptr <> end_enhan_ptr THEN            BEGIN  !         FOR index := error_code_enhan_ptr TO end_enhan_ptr -1 DO  !             write (which_file, main_buffer.chars [index]);           writeln (which_file);           END;  { IF }          END;  { PrintErrorStrings }          $Page   "   {---------------------------------------------------------------} " "   { (Local)               PRINT FILE NAMES                (Local) } " "   {---------------------------------------------------------------} " !   { Print the file names in a message returned from the producer. !    { The message is sitting in the main_buffer.      {     { Parameters:     {     {     names_are_directories (Input)      {        Indicates that the names are directories, not files       {     {     source_file_ptr (Input)  !   {        An index into the main_buffer where the source file is !    {     {     target_file_ptr (Input)      {        An index into the msgh_buffer where the target file       {        is (and the source file ends)      {     {     end_target_ptr (Input)   "   {        An index into the main_buffer where the target file ends "    {     {     user_command_fields (Input)  #   {        Gives the source and target node names. We will not print  #    {        a node name if it is local.      {}      PROCEDURE  PrintFileNames        (    names_are_directories : BOOLEAN;              source_file_ptr       : Int16;              target_file_ptr       : Int16;              end_target_ptr        : Int16;          VAR user_command_fields   : UserCommandFieldsType);         VAR  
      index       : Int16; 
       interactive : BOOLEAN;  
      length      : Int16; 
 "      name        : PACKED ARRAY [0..MAX_NFT_FILE_CHARS-1] OF CHAR;  "        BEGIN        IF source_file_ptr <> target_file_ptr THEN           BEGIN           { Extract the source string and print it }            length := target_file_ptr - source_file_ptr;            IF length > MAX_NFT_FILE_CHARS THEN              length := MAX_NFT_FILE_CHARS;            FOR index := 0 TO length -1 DO   $            name [index] := main_buffer.chars [source_file_ptr + index]; $          write (list, SOURCE_STRING, name:length);               { Append the node name if it is not the local node }            IF NOT user_command_fields.uc_snode_local THEN               write (list, '>', user_command_fields.uc_snode);      "         { If by chance we did not get a target name then writeln }  "          IF target_file_ptr = end_target_ptr THEN               writeln (list);            END;  { IF source_file_ptr }             IF target_file_ptr <> end_target_ptr THEN            BEGIN           { Extract the target string and print it }            length := end_target_ptr - target_file_ptr;           IF length > MAX_NFT_FILE_CHARS THEN              length := MAX_NFT_FILE_CHARS;            FOR index := 0 TO length -1 DO   $            name [index] := main_buffer.chars [target_file_ptr + index]; $              interactive := FmpInteractive (list_dcb_ptr^) < 0;       !         { If the target name is a directory and there is no     } ! !         { source directory name then print "Creating directory" } !          IF names_are_directories               AND               (source_file_ptr = target_file_ptr) THEN  	            BEGIN  	             write (list, CREATING_DIR, name:length);              IF NOT user_command_fields.uc_tnode_local THEN                  write (list, '>', user_command_fields.uc_tnode);                write (list, DOTS);               IF interactive THEN                  prompt (list);               END   { IF }           ELSE   	            BEGIN  	 #            { If the source and target file names will not fit on a }  # #            { single line then print the target file on next line.  }  # #            { The 61 here accounts for the 'Copying', 'to', '...'.  }  #             IF (end_target_ptr - source_file_ptr) > 61 THEN   
               BEGIN 
                writeln (list);                 write (list, '    ');                 END;  { IF }               write (list, TO_STRING, name:length);               IF NOT user_command_fields.uc_tnode_local THEN                  write (list, '>', user_command_fields.uc_tnode);                write (list, DOTS);               IF interactive THEN                  prompt (list);   
            END;  { ELSE } 
              cursor_end_of_line := TRUE;           END;  { IF target_file_ptr }          END;  { PrintFileNames }           $Page   BEGIN  { PrintMessageFields }          CASE main_buffer.msg.msg_type.nft_type OF        AINIT:           BEGIN           WITH main_buffer.msg.ainit_msg DO  	            BEGIN  	             IF error_code <> 0 THEN   
               BEGIN 
 !               PrintErrorOrWarn (ERROR, list, 0, error_code, 0, 0, !                                  null_string);                 IF list_file_name <> output_file_name THEN   $                  PrintErrorOrWarn (ERROR, output, 0, error_code, 0, 0,  $                                     null_string);                  END;  { IF error_code }                  PrintErrorStrings (list, local_error_msg_ptr,                                  error_code_enhan_ptr, end_ptr);              IF list_file_name <> output_file_name THEN                 PrintErrorStrings (output, local_error_msg_ptr,  !                                  error_code_enhan_ptr, end_ptr);  ! 
            END;  { WITH } 
          END;  { AINIT }            ANFTGEN:           BEGIN           WITH main_buffer.msg.anftgen_msg DO  	            BEGIN  	             IF (NOT user_command_fields.uc_quiet) THEN  
               BEGIN 
                 { Print the number of files in the generic set }                   IF number_generic_files > 0 THEN   "                  writeln (list, THERE_ARE, number_generic_files:1,  "                                  FILES_IN_SET);                      PrintFileNames (misc_anft_flags.is_directory,                                  source_file_ptr, target_file_ptr,                                  end_ptr, user_command_fields);                      IF nft_error_code = 0 THEN                     writeln (list, OK)  
               ELSE  
                  writeln (list, FAILED);                 END;  { IF NOT }                   cursor_end_of_line := FALSE;                  IF nft_error_code <> 0 THEN   
               BEGIN 
 "               PrintErrorOrWarn (ERROR, list, 0, nft_error_code, 0,  "                                  0, null_string);                  IF list_file_name <> output_file_name THEN   #                  PrintErrorOrWarn (ERROR, output, 0, nft_error_code,  #                                     0, 0, null_string);                  END;  { IF nft_error_code }                  PrintErrorStrings (list, local_error_msg_ptr,   #                               error_code_enhan_ptr, source_file_ptr); #                 IF list_file_name <> output_file_name THEN                 PrintErrorStrings (output, local_error_msg_ptr,                                    error_code_enhan_ptr,                                     source_file_ptr);                   IF (NOT user_command_fields.uc_quiet) AND                  (nft_error_code <> 0)              THEN                 PrintAmountTransferred (amount_data_xferred,                                          type_of_data_xferred);   
            END;  { WITH } 
 
         END;  { ANFTGEN } 
           ANFT:            BEGIN           WITH main_buffer.msg.anft_msg DO   	            BEGIN  	             IF NOT user_command_fields.uc_quiet THEN  
               BEGIN 
                PrintFileNames (misc_anft_flags.is_directory,                                  source_file_ptr, target_file_ptr,                                  end_ptr, user_command_fields);                      IF error_code = 0 THEN                     writeln (list, OK)  
               ELSE  
                   writeln (list, FAILED);                  END;  { IF NOT }                   cursor_end_of_line := FALSE;                  IF error_code <> 0 THEN   
               BEGIN 
 !               PrintErrorOrWarn (ERROR, list, 0, error_code, 0, 0, !                                  null_string);                 IF list_file_name <> output_file_name THEN   "                  PrintErrorOrWarn (ERROR, output, 0, error_code, 0, "                                     0, null_string);                 END;  { IF error_code }                  PrintErrorStrings (list, local_error_msg_ptr,   #                               error_code_enhan_ptr, source_file_ptr); #                 IF list_file_name <> output_file_name THEN                 PrintErrorStrings (output, local_error_msg_ptr,                                    error_code_enhan_ptr,                                     source_file_ptr);                   IF (NOT user_command_fields.uc_quiet) AND                  (error_code <> 0)                  THEN                 PrintAmountTransferred (amount_data_xferred,                                          type_of_data_xferred);   
            END;  { WITH } 
          END;  { ANFT }             INFO:            BEGIN           WITH main_buffer.msg.info_msg DO   	            BEGIN  	             IF NOT user_command_fields.uc_quiet THEN  
               BEGIN 
                 { Print the number of files in the generic set }                   IF number_generic_files > 0 THEN   "                  writeln (list, THERE_ARE, number_generic_files:1,  "                                  FILES_IN_SET);   $               PrintFileNames (FALSE, source_file_ptr, target_file_ptr,  $                                end_ptr, user_command_fields);                  END;  { IF NOT }   
            END;  { WITH } 
          END;  { INFO }             PROGRESS:            BEGIN           { This overrides the quiet option }           writeln (output, main_buffer.msg.progress_msg.   !                          percentage_xferred:2, PERCENT_XFERRED);  !          END;  { PROGRESS }             WARNING:           BEGIN           WITH main_buffer.msg.warning_msg DO  	            BEGIN  	             IF NOT user_command_fields.uc_quiet THEN  
               BEGIN 
                { If we are waiting to print 'ok' or 'failed' }                 { then do a writeln first                     }                 IF cursor_end_of_line THEN                     BEGIN                     writeln (list);                     cursor_end_of_line := FALSE;                    END;  { IF }      #               PrintErrorOrWarn (WARN, list, 0, nft_error_code, 0, 0,  #                                  null_string);                 PrintErrorStrings (list, local_error_msg_ptr,  !                                  error_code_enhan_ptr, end_ptr);  !                END;  { IF NOT }   
            END;  { WITH } 
 
         END;  { WARNING } 
     
      END;  { CASE } 
     END;  { PrintMessageFields }          $Page   #{-------------------------------------------------------------------}  # #{                    PROMPT AND GET BREAK REQUEST                   }  # #{-------------------------------------------------------------------}  # "{ The user has set the break flag. Prompt him for a command, map it  " #{ to an event and return it. This procedure will print the break mode  # { prompt regardless of the setting of the quiet flag.   {   { Parameters:   {   
{     event (Output) 
 {        Returned event corresponding to the user request   {   {     cursor_end_of_line (Input)   {        True if we should perform a writeln before printing the   !{        break mode prompt. We don't want to print the break mode  ! {        prompt after the file names and the "..." part.  {}  PROCEDURE  PromptAndGetBreakRequest      (VAR event              : Int16;       VAR cursor_end_of_line : BOOLEAN);      VAR      break_request : String [1];      BEGIN   #   { If the file names are being printed to the output file as well }  # #   { as the list file (they are the same) then unless we're careful }  # #   { the break prompt could be printed after the file names and the }  # #   { "..." prompt.                                                  }  # #   IF cursor_end_of_line AND (list_file_name = output_file_name) THEN  #       BEGIN         writeln (output);         cursor_end_of_line := FALSE;  	      END;  { IF } 	        write (output, our_pname:pname_length, ': ');     write (output, 'Abort, Cancel, Status, Help ');     prompt (output, '(CR to continue) ');         entered_error_handler := FALSE;     reading_from_input := TRUE;     readln (log_file, break_request);     reading_from_input := FALSE;          { If user hit return do nothing, else decode char }      IF entered_error_handler OR (StrLen (break_request) = 0) THEN   
      event := NULL_EVENT  
    ELSE         BEGIN         CaseFold (break_request);             CASE break_request [1] OF            'A':  event := USER_WANTS_ABORT;     { A)bort  }            'C':  event := USER_WANTS_CANCEL;    { C)ancel }            'H':  event := USER_WANTS_HELP;      { H)elp   }            'S':  event := USER_WANTS_PROGRESS;  { S)tatus }   	         OTHERWISE 	                event := NULL_EVENT;            END;  { CASE }   
      END;  { ELSE } 
     END;  { PromptAndGetBreakRequest }          $Page   #{-------------------------------------------------------------------}  # #{                     SET UP PRODUCER CONNECTION                    }  # #{-------------------------------------------------------------------}  #  { Set up a connection to the producer system. If we are already    "{ connected to the desired producer then just return, else tear down " { the current connection and set up a new one.  {   { Parameters:   {   {     producer_info (Input/Output)  {        Global record containing info about the producer.  {   {     user_command_fields (Input)    {        Carries in the pieces of the user command. The new name   {        of the producer system is contained in here  {   {     new_connection (Input)   {        Returns true if a new connection was set up else false    {   {     ipc_error (Output)   {        Returns an Ipc error in setting up a new connection if    	{        non-zero  	 {   {     nft_error (Output)  {        Returns an Nft error if <> 0   {}  PROCEDURE  SetUpProducerConnection     (VAR producer_info         : ProducerInfoType;       VAR user_command_fields   : UserCommandFieldsType;      VAR new_connection        : BOOLEAN;      VAR ipc_error             : Int32;      VAR nft_error             : Int16);       $Page   #   {----------------------------------------------------------------}  # #   { (Local)              CONNECT TO PRODUCER               (Local) }  # #   {----------------------------------------------------------------}  # "   { We have determined that a new connection is needed. Connect to  "    { the producer system whose name is given in producer_info.     {     { Parameters:     {     {     producer_info (Input)  !   {        The name of the producer system to connect to is given !    {        in field pi_node_name      {     {     ipc_error (Output)      {        Returns an Ipc error in connecting if non-zero     {     {     nft_error (Output)      {        Returns an Nft error in connecting if non-zero     {}      PROCEDURE ConnectToProducer        (VAR producer_info   : ProducerInfoType;         VAR ipc_error       : Int32;          VAR nft_error       : Int16);         VAR        dest_descr         : Int32;         dummy              : Int16;         dummy_length       : Int32;         error              : Int16;         ipc_error1         : Int32;         ipc_options        : IpcOptionsType;        node_name          : NodeNamePacType;         loop               : Int16;          BEGIN        WITH producer_info DO            BEGIN           { Convert the node name from a string to a pac }   
         node_name := ' '; 
          FOR loop := 1 TO StrLen (pi_node_name) DO              node_name [loop] := pi_node_name [loop];               { Create a path report for the destination node }           InitOpt (ipc_options, 0, error);   "         IpcDest (IPC_CALL_SOCKET, node_name, StrLen (pi_node_name), "                   IPC_TCP_PROTOCOL, CA_HP_NFT, 2, dummy_flags,                    ipc_options, dest_descr, ipc_error);               IF ipc_error = 0 THEN  	            BEGIN  	 !            { Fill in the two option entries which indicate the }  ! !            { maximum size of my send and receive buffers.      }  !             InitOpt (ipc_options, 2, error);              AddOpt (ipc_options, 0, IPC_MAX_SEND_SIZE, 2,                       MAX_BUFFER_BYTES, error);               AddOpt (ipc_options, 1, IPC_MAX_RECEIVE_SIZE, 2,                      MAX_BUFFER_BYTES, error);               dummy_flags := IPC_MSG_MODE;      #               IpcConnect (call_socket_descr, dest_descr, dummy_flags, # "                           ipc_options, pi_socket_descr, ipc_error); "     "            { Release the path report. We will get a new one later } " "            { if we need to connect to the same node               } "             dummy_flags := 0;               InitOpt (ipc_options, 0, error);              IpcShutDown (dest_descr, dummy_flags, ipc_options,                           ipc_error1);       $            { If the Connect succeeded then wait for connect response }  $             IF ipc_error = 0 THEN                  BEGIN { complete connection }                 { Wait for the result of the connect request }                  dummy_length := 0;                  dummy_flags  := 0;   "               IpcRecv (pi_socket_descr, main_buffer, dummy_length,  "                          dummy_flags, dummy_options, ipc_error);                           IF ipc_error = 0 THEN                    BEGIN { set timeout }   &                  { If no error occured, set a long timeout on the VC     }  & &                  { socket. If we set the timeout before we complete the  }  & &                  { connection, we will cause the user to wait until TCP  }  & &                  { times out if they are attempting to connect to a node }  & &                  { which isn't responding. Once we have established a    }  & &                  { connection we will let the producer take as long as   }  & &                  { they like (up to 20 minutes) and will depend upon TCP }  & &                  { to inform us if the connection has gone down.         }  &                   dummy_length := 0;                    dummy_flags  := 0;  '                IpcControl (pi_socket_descr,IPC_SET_TIME_OUT,VC_PRODC_TIMEOUT, ' '                              2, dummy, dummy_length, dummy_flags, ipc_error); '                   END;   { set timeout }                     IF ipc_error <> 0 THEN   #                  { If an error occurred then shutdown the vc socket } #                   CloseConnectionToProducer (producer_info)   
               ELSE  
 $                  { Set the connected flag in the producer_info record } $                   pi_connected := TRUE;                          END;  { complete connection }              END;  { IF ipc_error = 0 }           END;  { WITH producer_info }             IF ipc_error = 0 THEN            nft_error := 0         ELSE           nft_error := CANT_CONNECT_SOURCE_NODE;          END;  { ConnectToProducer }      $Page   BEGIN  { SetUpProducerConnection }      	   nft_error := 0; 	        WITH producer_info, user_command_fields DO         BEGIN              { If we are currently connected to the producer and the }           { next logon and node name match those that were used   }           { to setup the current connection then we do not need   }           { to set up a new connection.                           }          IF pi_connected               AND            (pi_node_name = uc_snode)  AND            (pi_logon     = uc_slogon) THEN           BEGIN           new_connection := FALSE;   
         END  { IF } 
       ELSE           BEGIN           new_connection := TRUE;               CloseConnectionToProducer (producer_info);                { Save the new logon and node name }            pi_node_name := uc_snode;           pi_logon     := uc_slogon;       !         ConnectToProducer (producer_info, ipc_error, nft_error);  !          END;  { ELSE of IF pi_connected }            END;  { WITH producer_info }      END;  { SetUpProducerConnection }           $Page   #{-------------------------------------------------------------------}  # #{                        SHOW GLOBAL DEFAULTS                       }  # #{-------------------------------------------------------------------}  # { Print out the current state of the global defaults  {   { Parameters:   {   {     global_defaults (Input)    {        Contains all of the global defaults currently in effect   {}  PROCEDURE  ShowGlobalDefaults      (VAR global_defaults : GlobalDefaultsType);      LABEL      99;   { Labels end of the procedure }      VAR      chars_left  : Int16;   
   found_one   : BOOLEAN;  
 
   found_opt   : BOOLEAN;  
 
   write_comma : BOOLEAN;  
     $Page   #   {----------------------------------------------------------------}  # #   { (Local)                  SHOW OPTION                   (Local) }  # #   {----------------------------------------------------------------}  #    { Show a single option which currently has a default      {     { Parameters:     {     {     option_name (Input)     {        Carries in the option name to be displayed     {     {     option_value (Input)   "   {        Carries in the integer value of the option if pertinent  "    {     {     option_string (Input)  !   {        Carries in the string value of an option if pertinent  !    {}      PROCEDURE  ShowOption        (option_name   : String20;         option_value  : Int32;          option_string : IcharScharType);          VAR        option_length : Int16;         BEGIN        { Determine the length of the option strings }  #      option_length := StrLen (option_name) + StrLen (option_string);  #       { Add in the length of the integer }        IF option_value > 0 THEN           option_length := option_length + 7; { Rough guess }            { If we near the end of the line then start a new one }         IF option_length > chars_left THEN           BEGIN  
         writeln (output); 
          write (output, '                  ');           write_comma := FALSE;           chars_left := 55;    { Chars on a line after spaces }           END;       
      IF write_comma THEN  
          write (output, ', ');            { Print out the option }        write (output, option_name);        IF option_value <> 0 THEN            write (output, option_value:1);        IF StrLen (option_string) > 0 THEN           write (output, option_string);              { Subtract the length of the option from the line length }         chars_left  := chars_left - option_length - 2;      
      write_comma := TRUE; 
        END;  { ShowOption }       $Page   BEGIN  { ShowGlobalDefaults }          found_opt   := FALSE;  "   chars_left  := 55;   { Chars left on a line after 'Options .. ' } "    write_comma := FALSE;      
   WITH global_defaults DO 
       BEGIN   !      { Print out the source node, source logon, target node and } ! !      { target logon strings if any contain valid strings.       } ! 	      found_one := 	           (StrLen (gd_slogon) > 0) OR (StrLen (gd_snode)  > 0) OR            (StrLen (gd_tlogon) > 0) OR (StrLen (gd_tnode)  > 0);            IF found_one THEN            writeln (output, CURRENT_DEFAULTS);            IF StrLen (gd_slogon) > 0 THEN           writeln (output, ' Source Logon ... ', gd_slogon);         IF StrLen (gd_snode) > 0 THEN            writeln (output, ' Source Node .... ', gd_snode);        IF StrLen (gd_tlogon) > 0 THEN           writeln (output, ' Target Logon ... ', gd_tlogon);         IF StrLen (gd_tnode) > 0 THEN            writeln (output, ' Target Node .... ', gd_tnode);      !      { If any of the global option flags are set then print out } ! !      { the options prompt                                       } ! !      IF (gd_rsize > 0)          OR (gd_toptns.whole_byte > 0) OR  ! !         (gd_fsize > 0)          OR (gd_xfer_type > 0)         OR  ! !         gd_move                 OR gd_quiet                   OR  ! !         gd_strip                OR gd_compress                OR  ! !         (gd_data_type > 0)      OR (gd_file_organ > 0)        OR  ! !         (gd_record_type > 0)    OR (StrLen (gd_ichar) > 0)    OR  ! "         (StrLen (gd_schar) > 0) OR (gd_fcode <> 0)            THEN  "          BEGIN           IF NOT found_one THEN              writeln (output, CURRENT_DEFAULTS);            write (output, ' Options ........ ');           found_one := TRUE;            found_opt := TRUE;            END;       !      { If no global defaults are set then indicate so, and exit } !       IF NOT found_one THEN            BEGIN           writeln (output, ' No defaults are in effect.');   	         GOTO 99;  	          END;             { Print any options that are set }  
      IF gd_rsize > 0 THEN 
          ShowOption ('RSIZE=', gd_rsize, null_string);  
      IF gd_fsize > 0 THEN 
          ShowOption ('FSIZE=', gd_fsize, null_string);            IF gd_xfer_type > 0 THEN           BEGIN           IF gd_xfer_type = INTERCHANGE THEN               ShowOption ('INTERCHANGE', 0, null_string)           ELSE               ShowOption ('TRANSIENT', 0, null_string);            END;   {}  {     IF gd_file_organ > 0 THEN   {        BEGIN  {        IF gd_file_organ = DIRECT THEN   {           ShowOption ('DIRECT', 0, null_string)   {        ELSE   {           ShowOption ('SEQUENTIAL', 0, null_string);  {        END;   {}        IF gd_record_type > 0 THEN           BEGIN           IF gd_record_type = FIXED THEN               ShowOption ('FIXED', 0, null_string)           ELSE               ShowOption ('VARIABLE', 0, null_string);           END;             IF gd_data_type > 0 THEN           BEGIN           IF gd_data_type = ASCII THEN               ShowOption ('ASCII', 0, null_string)           ELSE               ShowOption ('BINARY', 0, null_string);           END;             IF gd_move THEN            ShowOption ('MOVE', 0, null_string);   
      IF gd_compress THEN  
          ShowOption ('COMPRESS', 0, null_string);         IF gd_quiet THEN           ShowOption ('QUIET', 0, null_string);        IF gd_strip THEN           ShowOption ('STRIP', 0, null_string);            IF gd_toptns.whole_byte > 0 THEN           BEGIN           IF gd_toptns.append THEN               ShowOption ('APPEND', 0, null_string)            ELSE IF gd_toptns.replace THEN               ShowOption ('REPLACE', 0, null_string)           ELSE               ShowOption ('OVERWRITE', 0, null_string);            END;             IF gd_fcode <> 0 THEN            ShowOption ('FCODE=', gd_fcode, null_string);            IF StrLen (gd_ichar) > 0 THEN            ShowOption ('ICHAR=', 0, gd_ichar);        IF StrLen (gd_schar) > 0 THEN            ShowOption ('SCHAR=', 0, gd_schar);        END;  { WITH global_defaults }            IF found_opt THEN   
         writeln (output); 
 99:   END;  { ShowGlobalDefaults }          $Page   #{-------------------------------------------------------------------}  # #{                        SQUEZE OUT QUOTES                          }  # #{-------------------------------------------------------------------}  # #{ Given a string containing quotation marks, pull them out and return  # #{ the resultant string. Two adjacent quotes will be converted to one.  # {   { Parameters:   {   
{     string_parm (Input)  
 {        String containing quotation marks  {}  
PROCEDURE  SquezeOutQuotes 
    (VAR string_parm  : String);       LABEL      99;   { Labels end of the procedure }      VAR      close_quote : Int16;      open_quote  : Int16;       BEGIN   
   open_quote := 1;  
        WHILE open_quote < StrLen (string_parm) DO         BEGIN         { Check if we have hit a quotation mark }         IF string_parm [open_quote] <> QUOTE THEN            open_quote := open_quote +1        ELSE           BEGIN  "         { We are positioned to an opening quote. Make it a space }  " "         { and find the closing quote. In a few bizzare cases,    }  " "         { there may not be a closing quote so bailout of the loop}  " "         { if we can't find it.                                   }  "          StrDelete (string_parm, open_quote, 1);           close_quote := open_quote -1;           REPEAT               close_quote := close_quote +1;           UNTIL (close_quote > StrLen (string_parm)) OR                 (string_parm [close_quote] = QUOTE);                 { If we could not find the closing quote then bailout }            IF close_quote > StrLen (string_parm) THEN   
            GOTO 99; 
     !         { Now if the close quote is adjacent to the open quote }  ! !         { then skip the close quote, else make it a space also }  !          IF close_quote <> open_quote THEN              StrDelete (string_parm, close_quote, 1);               open_quote := close_quote +1;           END;  { ELSE }             END;  { WHILE }       99:   
   { Trim off all spaces } 
    string_parm := StrLTrim (string_parm);      string_parm := StrRTrim (string_parm);       
END;  { SquezeOutQuotes }  
         $Page   #{-------------------------------------------------------------------}  # #{                        SQUEZE OUT SPACES                          }  # #{-------------------------------------------------------------------}  # "{ Given a string, this procedure pulls out all spaces. There should  "  { be no spaces at the start or end of the string. Note that this   { procedure will not touch spaces within quotes.  {   { Parameters:   {   
{     string_parm (Input)  
 {        String containing spaces to be removed   {}  
PROCEDURE  SquezeOutSpaces 
    (VAR string_parm  : String);       VAR      all_done       : BOOLEAN;  
   next_non_space : Int16; 
 
   space_index    : Int16; 
     BEGIN      all_done := FALSE;          REPEAT   &      space_index := FindUnQuotedChar (string_parm, 1, StrLen(string_parm),  &                         SPACE);             { Check if a space was found }        IF space_index = 0 THEN            BEGIN           { No spaces found so bailout }   
         all_done := TRUE; 
          END   { IF }         ELSE           BEGIN           { A space was found. Locate the next non-space }            next_non_space := space_index;            WHILE string_parm [next_non_space] = SPACE DO              next_non_space := next_non_space +1;               { Delete this sub-string of spaces }            StrDelete (string_parm, space_index,                       next_non_space - space_index);               END;  { ELSE of IF space_index }       	   UNTIL all_done; 	     
END;  { SquezeOutSpaces }  
         $Page   #{-------------------------------------------------------------------}  # #{                     SUBST CHAR UNLESS QUOTED                      }  # #{-------------------------------------------------------------------}  # #{ Substitute a character for another in a string unless the character  # { to be substituted is quoted.  {   { Parameters:   {   {     string_parm (Input/Output)  {        The string containing the char(s) to be substituted  {   {     start_pos (Input)   {        The index of the char in the string where the search   
{        is to begin 
 {   {     end_pos (Input)   {        The index of the char in the string where the search   	{        is to end 	 {   {     old_char (Input)  {        The char in string_parm to be converted  {   {     new_char (Input)  {        The char to be substituted for old_char  {}  PROCEDURE  SubstCharUnlessQuoted     (VAR string_parm  : String;          start_pos    : Int16;           end_pos      : Int16;           old_char     : CHAR;          new_char     : CHAR);       VAR      str_index   : Int16;       BEGIN      WHILE start_pos <= end_pos DO        BEGIN   #      str_index := FindUnquotedChar (string_parm, start_pos, end_pos,  #                                      old_char);         { Check if the char was found }         IF str_index = 0 THEN             start_pos := end_pos +1               { Nope, bailout }         ELSE  !         string_parm [str_index] := new_char;  { Yup, substitute } !           END;  { WHILE start_pos }       END;  { SubstCharUnlessQuoted }           $Page   #{-------------------------------------------------------------------}  # #{                              MAIN                                 }  # #{-------------------------------------------------------------------}  #     BEGIN      pickup_params   := TRUE;       "   { Initialize will terminate the program if an Ipc error occurs }  "    Initialize (main_buffer.command);     run_string_chars := StrLen (main_buffer.command);         ClearGlobalDefaults (global_defaults);          REPEAT         global_fmp_error := 0;        ipc_error        := 0;        nft_error        := 0;        rsm_error        := 0;        error_string     := '';         end_of_file      := FALSE;      #      { If the user aborted or cancelled the previous transfer, and }  # #      { we are in a transfer file (not transferred to an lu since   }  # #      { the user probably wants to terminate the transfer and not   }  # #      { return control from the lu), generate a null command which  }  # #      { will look like an Eof to the code below. Otherwise get a    }  # #      { command from input by calling GetCommand.                   }  #       IF in_transfer_file                       AND            aborted_or_cancelled                   AND            (FmpInteractive (input_dcb_ptr^) >= 0) THEN           BEGIN           main_buffer.command  := '';           END   { IF }         ELSE           BEGIN  #         GetCommand (main_buffer.command, command_flushed, nft_error); #          END;  { ELSE }             aborted_or_cancelled := FALSE;      #      { If there was part or all of a copy command in the run-string } # #      { then we should terminate after it is carried out. To do so   } # #      { set the "copy_in_run_string" flag.                           } #       IF pickup_params THEN            BEGIN           pickup_params := FALSE;           copy_in_run_string :=              (run_string_chars > 0)                     AND              (NOT command_flushed)                      AND              (main_buffer.command [1] <> QUESTION_MARK) AND              (main_buffer.command [1] <> PLUS_SIGN);            END;  { IF pickup_params }             IF nft_error = 0 THEN            BEGIN  !         { If the command we just got is null then it indicates  } ! !         { end-of-file since GetCommand did his best to get a    } ! !         { command from input. Let the +TR command processor do  } ! !         { the work for us.                                      } !          IF StrLen (main_buffer.command) = 0 THEN   	            BEGIN  	             main_buffer.command := '+TR';               end_of_file         := TRUE;              END  { IF }            ELSE IF main_buffer.command = '/' THEN   	            BEGIN  	 "            { We will bounce a single slash character given as a   } " "            { command. At a HP1000 source node it would cause all  } " "            { new files to be copied since it would be expanded to } " "            { /@.@.D by the producer. The user probably wanted a   } " "            { command stack, but if not, he can enter /@.@ instead.} "             nft_error := ILLEGAL_COMMAND;               END; { IF main_buffer.command }                IF nft_error = 0 THEN  	            BEGIN  	             PreparseCommand (main_buffer.command, nft_error);               END;               IF nft_error = 0 THEN  	            BEGIN  	             { Decide what to do based on the first character }              CASE main_buffer.command [1] OF   
               PLUS_SIGN:  
                   BEGIN                     HandleNonCopyCommand                       (main_buffer.command, error_string,                         end_of_file, global_fmp_error, nft_error);   $                  { Don't clear global_nft_error if we were the cause }  $ $                  { of getting here (see where end_of_file set above).}  $                   IF NOT end_of_file THEN                        global_nft_error := 0;                     END;                     QUESTION_MARK:                     BEGIN                     PrintHelpInfo (main_buffer.command);                    global_fmp_error := 0;                    END;                     OTHERWISE                    BEGIN                     global_nft_error := 0;                    HandleCopyCommand                        (main_buffer.command, error_string,                        aborted_or_cancelled,                         ipc_error, rsm_error, nft_error);                     END;  { Otherwise }                  END;  { CASE }               END;  { IF nft_error }           END;  { IF nft_error }             { Print any Nft or Fmp error }        IF (nft_error <> 0) OR (global_fmp_error <> 0) THEN            BEGIN           total_errors     := total_errors + 1;           global_nft_error := nft_error;   "         PrintErrorOrWarn (ERROR, list, global_fmp_error, nft_error, "                             ipc_error, rsm_error, error_string);             IF output_file_name <> list_file_name THEN               PrintErrorOrWarn (ERROR, output, global_fmp_error,                                nft_error, ipc_error, rsm_error,                                error_string);           END;  { IF (nft_error }            main_buffer.command := '';      !      { Terminate the loop if we got a copy command in the run  }  ! !      { string. There may be other cases for termination of the }  ! !      { program but they call CleanupAndTerminate directly who  }  ! !      { in turn goes to label 999 below.                        }  !    UNTIL copy_in_run_string;         CleanupAndTerminate (total_errors, global_nft_error);      999:  END.  { DSCOP }  