 $PASCAL '91790-1X036 REV.4010 <851205.1550>'      $ TITLE 'DS/1000-IV Information' $      
$STANDARD_LEVEL 'HP1000'$  
 $HEAP 0   $HEAPPARMS OFF  $RECURSIVE OFF  $RANGE OFF  $DEBUG$   $AUTOPAGE ON$   $CODE_INFO ON$  	$CODE_OFFSETS ON$  	         $TITLE 'MODULE Descripton',PAGE$      MODULE DSInf;   $ALIAS 'N$DSINF'      {}  {-------------------------------------------------------------  {   { (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS  { RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   { REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT  { THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   {   {-------------------------------------------------------------  {}      {}  	{      NAME: DSInf 	 {    SOURCE: 91790-18036  	{     RELOC: NONE  	 {      PGMR: RM, EW and JXL   {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date     Prgmr  Description  {   5-22-85  JXL    Incorporated suggestions from the review;   #{                    especially check EnterCrit error and environment  # {                    checks e.g. #FWAM and DS_StateofDSAM   ${  06-07-85  EW     Modified LIST processing section to move entire list $  {                    to users code space to ensure stable list.    {  06-12-85  EW     To call NSIXGET and NSIGET.   {  08-14-85  EW     To SEARCH DRES.XPT and INIT_DEC.REL.  {  08-29-85  RM     To Display #MARN in VAInfo.   &{  08-29-85  RM     To Display line down count and consecutive cancellation  & {                   count in MAInfo.  ${  10-29-85  ash    Convert to CDS so that it may be used with NSInf and $ {                    with NSInternal.   {  10-30-85  ash    Print 'No remote sessions' in RSInfo.   #{  11-08-85  RM     Print 'No rerouting link at this node' in RRInfo.  # {  11-08-85  RM     Print IP address in NRV display NRInfo.   {  12-03-85  RM     Print lu timeout in NRV display correctly.  {  12-05-85  ash    Print clearer remote session message  {------------------------------------------------------------       {}  { MODULE DESCRIPTION:   {   {  This module used to examine the DS/1000-IV data structures.  {}  $TITLE 'IMPORT Section',PAGE$       IMPORT            $SEARCH 'phtm/BODEC.REL'$   BODEC,            $SEARCH 'phtm/MMDEC.REL'$   MMDEC,            $SEARCH 'phtm/MMEXT.REL'$   DS_MM,            $SEARCH 'phtm/SODEC.REL'$   SODEC,            $SEARCH 'phtm/INFLB.REL'$   INFLB,            $SEARCH 'phtm/IPUI.REL'$  IPUI,             $SEARCH 'phtm/TMRDEC.REL'$  TMRDEC,             $SEARCH 'phtm/IPDEC.REL'$   IPDEC,            $SEARCH 'phtm/init_dec.rel'$  INIT_DEC,             $SEARCH 'phtm/dres.xpt'$  DRES;           $TITLE 'EXPORT Section',PAGE$   {------------------------------------------------------------}  {              Export Section                                }  {------------------------------------------------------------}      EXPORT                  PROCEDURE DSInf      (VAR info: InfoRecordType);          PROCEDURE LIInfo     (VAR buffer : Charray78);      PROCEDURE MAInfo     (VAR buffer : Charray78);      PROCEDURE NRInfo     (VAR buffer : Charray78);      PROCEDURE RRInfo     (VAR buffer : Charray78);      PROCEDURE RSInfo     (VAR buffer : Charray78);      PROCEDURE VAInfo     (VAR buffer : Charray78);      $TITLE 'IMPLEMENT Section',PAGE$  {------------------------------------------------------------}  {              Implement Section                             }  {------------------------------------------------------------}  IMPLEMENT       CONST          HE   = 18501;    { Help }     LI   = 19529;    { DS/1000 Lists }      MA   = 19777;    { Message Accounting }     NR   = 20050;    { Nodal Routing Vector }     RR   = 21074;    { Rerouting }      RS   = 21075;    { Remote Sessions }      VA   = 22081;    { DS/1000 Values }     EX   = 17752;    { Exit }      	   BIT7TO0 = 255;  	 
   BIT14TO0 = 32767; 
    TCB_TABLE_SIZE = 6 ;      BAD_ENTRY_MARK = 'B';  
   HP_3K_MARK = '*'; 
 '   RES_BUF_LEN = 42;  { No. of RES entry points to copy into a local buffer }  ' '   SYS_BUF_LEN = 1;   { No. of sys entry points to copy into a local buffer }  '    GTRES_ERROR = 1;   { Internal error code for Halt }     GTSYS_ERROR = 2;   { Internal error code for Halt }  %   MAX_LIST_ENTRIES = 100; { Max number of list entries we can process. }  %    MAX_STREAM = 12;  { Highest slave stream allowed }      STREAM_HEAD_SIZE = 5; { size of a stream head entry }     STREAM_LIST_SIZE = (MAX_STREAM + 1) * STREAM_HEAD_SIZE; {}      LIST_BUFFER_SIZE = MAX_LIST_ENTRIES * TCB_TABLE_SIZE;             DDolLID = 1;               LbMDCT  = 17;   $   DDolRID = 2;               LbRPCV  = 18;      { Indices to res_buf }  $    LbRDLY  = 3;               LbRQCV  = 19;      LbPRLU  = 4;               Lb3KLU  = 20;      LbFWAM  = 5;               LbQXCL  = 21;      LbTBRN  = 6;               LbQZCL  = 22;      LbQRN   = 7;               LbRFSZ  = 23;      LbGRPM  = 8;               LbPLOG  = 24;      LbQCLM  = 9;               LbPLOGPlus  = 25;      LbMSTO  = 10;              LbLEVL  = 26;      LbSVTO  = 11;              LbMAHC  = 27;      LbWAIT  = 12;              LbEXHC  = 28;      LbBREJ  = 13;              LbEXTC  = 29;      LbINCV  = 14;              LbLNOD  = 30;      LbOTCV  = 15;              LbLUMP  = 31;      LbMHCT  = 16;              LbMCTR  = 32;      LbNCNT  = 33;              LbNODE  = 34;      LbLCNT  = 35;              LbMNUM  = 36;      LbMRTH  = 37;              LbST00  = 38;      LbNULL  = 39;              LbPNLH  = 40;      LbPOOL  = 41;              lbMARN  = 42;           DolRNTA = 1;         { System entry point index to sys_buf }            %   PROMPT_CONST = Charray78 ['DS/1000-IV Info (default command =   ) >'];  % %   CMD_POS      = 36;   { Char position where default command is placed }  %         TYPE         IntChrType = RECORD  
      CASE Int16 OF  
 
         0: (int : Int16); 
          1: (bytes : PACKED ARRAY [1..2] OF PosInt8);            END;  { IntChrType }          ControlWordType = ARRAY [1..2] OF Int16;      ResBufType = ARRAY [1..RES_BUF_LEN] OF Int16;     SysBufType = ARRAY [1..SYS_BUF_LEN] OF Int16;         LvEntryType = PACKED RECORD          Link_status     :Posint1;           reserved        :Posint7;           Link_Lu         :Posint8;           Cost_Value      :Int16;           Sys_Time        :Int32;           Up_Down_Counter :Int16;           Neighbor_Node   :Int16;          END;          Wd3to7  = ARRAY [1..5] OF Int16;   $   MaType    =  PACKED RECORD                        { MA list entry: }  $ $                rtr_addr             :  Int16;       { router address }  $ $                unacknowledged       :  PosInt4;     { unacknowledged }  $ $                bits11and10          :  PosInt2;     { don't care     }  $ $                timeout              :  PosInt8;     { TMAX           }  $ '                state                :  PosInt2;     { state of the MA chnl.}  ' %                word3thru7           :  Wd3to7;      { words 3-7 of table} % "                c_cancel_count       :  PosInt4;     { lines down }  " "                lines_down           :  PosInt12;    { lines down }  " '                word9thru10          :  Int32;       { the rest of the table}  ' 
                END; 
        NrvType    = PACKED RECORD         { NRV entry format: }   $                rtr_addr          :  Int16;     { router address       } $ $                lu_timeout        :  PosInt8;   { lu time out          } $ $                rsvd1             :  PosInt4;   { reserved             } $ $                msg_level         :  PosInt4;   { message level (0/1)  } $ $                chgbit            :  PosInt1;   { used by rerouting    } $ $                rsvd2             :  Int5;      { reserved             } $ $                non_rtr_lu        :  Boolean;   { non router bit       } $ $                neighbor          :  Boolean;   { neighbor bit         } $ $                lu                :  Int8;      { lu number            } $ $                ip_addr           :  Int32;     { ip address           } $ 
                END; 
        TcbSlaveType = PACKED RECORD            link         : Int16;           upline_bit   : boolean;           hp_3k        : boolean;           tmout_cntr   : PosInt8;           lcl_seq_num  : Int16;           org_seq_num  : Int16;           org_node_num : Int16;           reserved     : Int16;        END;         TcbMasterType = PACKED RECORD           link         : Int16;           upline_bit   : boolean;           hp_3k        : boolean;           ma_acked     : boolean;           reserved     : PosInt4;           tcb_tmed_out : boolean;           tmout_cntr   : Posint8;           lcl_seq_num  : Int16;           m20_tmout    : boolean;           class_bits   : Posint7;           mst_cls_num  : Posint8;           entry_bad    : BOOLEAN;           id_seg_addr  : Posint15;            ma_seq_num   : Int16;        END;             PrcNumListType = PACKED RECORD            link         : Int16;           reserved     : boolean;           hp_3k        : boolean;           fill1        : PosInt14;            rmt_nod_num  : Int16;           fill2        : Posint8;           trm_lu       : Posint8;           entry_bad    : BOOLEAN;           id_seg_addr  : Posint15;            rmt_sub_lvl  : Posint8;           rmt_ses_id   : Posint8;        END;         ListEntrytype = RECORD CASE INTEGER OF            0 : (mast : TCBMasterType);           1 : (slav : TCBSlaveType);            2 : (pnl  : PrcNumListType);            3 : (null : PACKED ARRAY [1..6] OF Int16);         END;      #   ListBufType = PACKED ARRAY [1..MAX_LIST_ENTRIES] OF ListEntryType;  #            NameIntType = PACKED ARRAY [1..3] OF Int16;     NameCharType = PACKED ARRAY [1..6] OF CHAR;     PgNameType = RECORD CASE BOOLEAN OF           TRUE  : (int  : NameIntType);           FALSE : (char : NameCharType);         END;         StreamHeadType = PACKED RECORD   
         pointer  : Int16; 
          fill     : Posint3;           cls_num  : Posint13;            mname    : PgNameType;         END;      "   StreamListType = PACKED ARRAY [0..MAX_STREAM] OF StreamHeadType;  "        array3 = ARRAY [1..3] OF Int16;         BytesType = RECORD CASE BOOLEAN OF                    TRUE  : (int : Int16);                    FALSE : (byt : PACKED RECORD                                     upper : 0..255;                                     lower : 0..255;                                   END);   
               END;  
     VAR   
   the_value : BytesType;  
    address   : Int16;      next_pos  : Int16;   
   request_code   : RECORD 
                         CASE BOOLEAN OF                           TRUE : ( int  : Int16 );  #                        FALSE: ( chars: PACKED ARRAY [1..2] OF CHAR ); #                         END;  
   res_buf   : ResBufType; 
    stream_list : StreamListType;  
   sys_buf   : SysBufType; 
    ierr      : Int16;      wkmap     : Int16;      a_reg     : Int16;      b_reg     : Int16;      choice    : Int16;      asciichoice : IntChrType;     oldchoice : Int16;      DS1000_prompt : Charray78;                   $SUBTITLE 'External Procedures',PAGE$    {--------------------------------------------------------------}    {   External Procedures                                        }    {--------------------------------------------------------------}            FUNCTION AddressOf        (*$ALIAS ' ADDR '$ Use RTE-A routine*)      (    buffer : Charray78)      : Int16;      EXTERNAL;      PROCEDURE DDollarThreeIN    $ALIAS ' D$3IN '$      (    entry_num     : Int16;      VAR lu_of_3000    : Int16;      VAR buff_size     : Int16;      VAR cont_rec_flag : Int16;      VAR x25_flag      : Int16);      EXTERNAL;      PROCEDURE DispatchLock;      EXTERNAL;      
PROCEDURE DispatchUnLock;  
    EXTERNAL;      	PROCEDURE Fetch_Lv 	    (    index   : Int16;      VAR buffer  : LvEntryType);      EXTERNAL;      PROCEDURE Fetch_MA_Index     (    index   : Int16;  
    VAR buffer  : MAType); 
    EXTERNAL;      
PROCEDURE Fetch_NRV_Index  
    (    index   : Int16;      VAR buffer  : NRVType);      EXTERNAL;      PROCEDURE FormatTime         $ ALIAS '$FMTI' $            (    seconds : Int16;              VAR buffer  : Charray78;                  pos     : Int16);     EXTERNAL;      PROCEDURE GetMapElement      $ ALIAS ' NSIGET ' $      (     addr   : Int16;           offset : Int16;  
     VAR value  : Int16);  
    EXTERNAL;      	PROCEDURE GetPool  	 
   (VAR poolptr : Int16);  
    EXTERNAL;      	PROCEDURE GetFwam  	    (VAR fwam : Int16);     EXTERNAL;      PROCEDURE GetResElements     $ ALIAS ' GTRES ' $     ( VAR len : Int16;        VAR buf : ResBufType);      EXTERNAL;      PROCEDURE GetSysElements     $ ALIAS ' GTSYS ' $     ( VAR len : Int16;        VAR buf : SysBufType);      EXTERNAL;      PROCEDURE GetTcb             $ ALIAS ' $XMOV ' $     (    SMBPtr      : Int16;      VAR buf         : TcbMasterType;          len         : Int16);      EXTERNAL;      PROCEDURE GetTcbLists        $ ALIAS ' $XMOV ' $     (    SMBPtr      : Int16;      VAR buf         : ListBufType;          len         : Int16);      EXTERNAL;      PROCEDURE GetPnl             $ ALIAS ' $XMOV ' $     (    SMBPtr      : Int16;      VAR buf         : PrcNumListType;           len         : Int16);      EXTERNAL;      PROCEDURE GetStrmHead        $ ALIAS ' $XMOV ' $     (    SMBPtr      : Int16;      VAR buf         : StreamHeadType;           len         : Int16);      EXTERNAL;      PROCEDURE GetXMapElement     $ ALIAS ' NSIXGET ' $     (     addr   : Int16;           offset : Int16;  
     VAR value  : Int16);  
    EXTERNAL;      FUNCTION IAnd      $DIRECT$   
   (  op1 : Int16 ;  
 
      op2 : Int16 )  
       : Int16;     EXTERNAL;      PROCEDURE IdAddToName      (  addr    : Int16;      VAR name  : NameIntType;      VAR lu    : Int16);      EXTERNAL;      FUNCTION IdNumberToAdd     (  id_num : Int16 )     : Int16;      EXTERNAL;      FUNCTION IOR     $DIRECT$   
   (  op1 : Int16 ;  
 
      op2 : Int16 )  
       : Int16;     EXTERNAL;      FUNCTION Kcvt      (num : Int16)     : Int16;      EXTERNAL;      PROCEDURE LuStatus  $ALIAS 'XLUEX'$   { EXEC 13 i/o status   }     $ NOABORT $     (     icode         :     Int16 ;           cntwd         :     ControlWordType;            param1        :     Int16 ) ;  	         EXTERNAL; 	     PROCEDURE MoveBytes       $ ALIAS ' MBTS ' $  
   (    from_addr : Int16; 
         to_addr : Int16;          len  : Int16);     EXTERNAL;      PROCEDURE MoveFromSys     $ ALIAS '$XMOV' $      (    source : Int16;           dest   : Int16;           num_words  : Int16);     EXTERNAL;      PROCEDURE GetStreamList         $ ALIAS 'GetStHd' $      (VAR Stbuf  : StreamListtype;          len    : Int16);     EXTERNAL;      PROCEDURE MoveXMap        $ ALIAS ' $XMOV ' $      (    SMBPtr      : Int16;      VAR buf         : Int16;          len         : Int16);      EXTERNAL;      FUNCTION MinimumOf       $ ALIAS ' MIN0 ' $      (    number1 : Int16;          number2 : Int16) : Int16;      EXTERNAL;      $SUBTITLE 'Forward Procedures',PAGE$   {--------------------------------------------------------------}    {   Forward Procedures                                         }    {--------------------------------------------------------------}       PROCEDURE PrChrBuf       { Output the buffer as follows:  }      (VAR outbuf : Charray78;    { Write into this buffer      }          buffer1: Charray78;    {   ...this buffer            }          buffer2: Charray78;    {   ...and these characters   }          pos    : Int16;        {       (pos of chars)        }          len    : Int16);       {       (length for chars)    }     FORWARD;           PROCEDURE PrDecBuf       { Output the buffer as follows:  }      (VAR outbuf : Charray78;    { Write into this buffer      }          buffer : Charray78;    {   ...these characters       }          decnum : Int16;        {   ...and this number        }          pos    : Int16;        {       (pos for number)      }          justify: Int16);       {       (-1 to left justify)  }     FORWARD;           PROCEDURE PrintLine      { Output the buffer as follows:  }      (VAR outbuf : Charray78;    { Write into this buffer      }          buffer : Charray78);   {   ...these characters       }     FORWARD;           
PROCEDURE PrintMenu  
    (VAR info : InfoRecordType);      FORWARD;                       $SUBTITLE 'CallGetRES',PAGE$  "{-----------------------------------------------------------------}  " "{  * Internal *          CallGetRES                * Internal *   }  " "{-----------------------------------------------------------------}  "     {    {   Fill all the RES entry points needed for DSINF into a buffer   {}      
PROCEDURE CallGetRES 
    (VAR buffer : Charray78);      	BEGIN {CallGetRES} 	        the_value.int := RES_BUF_LEN;  &   GetResElements (the_value.int, res_buf); { Buf has not been filled when } & &                                            {   the_value returned is zero } & %   IF the_value.int = 0 THEN  { Zero indicates that the buffer length is } % %      BEGIN                   { not what the Macro routine GTRES expects } %       buffer := INTERN_ERR;         PrInsrtDec (buffer, GTRES_ERROR, 24, -1);   
      Halt (-GTRES_ERROR); 
       END;      	END;  {CallGetRES} 	     $SUBTITLE 'CallGetSYS',PAGE$  !{----------------------------------------------------------------} ! !{  * Internal *          CallGetSYS                * Internal *  } ! !{----------------------------------------------------------------} ! {   "{   Fill all the system entry points needed for DSINF into a buffer  " {}      
PROCEDURE CallGetSYS 
    (VAR buffer : Charray78);      	BEGIN {CallGetSYS} 	        the_value.int := SYS_BUF_LEN;  &   GetSysElements (the_value.int, sys_buf); { Buf has not been filled when } & &                                            {   the_value returned is zero } & %   IF the_value.int = 0 THEN  { Zero indicates that the buffer length is } % %      BEGIN                   { not what the Macro routine GTSYS expects } %       buffer := INTERN_ERR;         PrInsrtDec (buffer, GTSYS_ERROR, 24, -1);   
      Halt (-GTSYS_ERROR); 
       END;      	END;  {CallGetSYS} 	     $SUBTITLE 'LIInfo',PAGE$  "{-----------------------------------------------------------------}  " "{  * Internal *              LIInfo                * Internal *   }  " "{-----------------------------------------------------------------}  "     PROCEDURE LIInfo     (VAR buffer : Charray78);          VAR   
   fwam          : Int16;  
    list_buffer   : ListBufType;   
   start_pnl     : Int16;  
 
   start_tcb     : Int16;  
 
   start_null    : Int16;  
         
$SUBTITLE 'IndexOf', PAGE$ 
 ${---------------------------------------------------------------------}  $ ${  FUNCTION TO CALCULATE INDEX OF AN ENTRY IN "LIST_BUFFER"           }  $ ${---------------------------------------------------------------------}  $     FUNCTION IndexOf (    SMBAddr : Int16;                        EntryAddr : Int16) : INTEGER;       	BEGIN { IndexOf }  	        IF EntryAddr = 0 THEN  	      IndexOf := 0 	    ELSE   !      IndexOf := ((EntryAddr - SmbAddr) DIV TCB_TABLE_SIZE ) + 1;  !     	END;  { IndexOf }  	     $SUBTITLE 'CntEnt',PAGE$   {--------------------------------------------------------------}    {  COUNT NUMBER OF ENTRIES IN A LIST IN "LIST_BUFFER"          }    {--------------------------------------------------------------}       FUNCTION CntEnt(    next  : Int16) : Int16;       VAR   
   counter : Int16 ; 
     BEGIN { CntEnt }     counter := 0;  
   IF next > 0 THEN  
       WHILE next <> 0 DO        BEGIN            counter := counter + 1;           next := IndexOf (fwam, list_buffer[next].null[1]);         END;     CntEnt := counter ;  END; { CntEnt }           $SUBTITLE 'PrtMasterTcb', PAGE$   ${---------------------------------------------------------------------}  $ ${ PRINT THE LIST OF MASTER TCBS IN "LIST_BUFFER"                      }  $ ${---------------------------------------------------------------------}  $ PROCEDURE PrtMasterTcb;       VAR      count      : Int16;     dummy      : Int16;     index      : Int16;     pgname     : PgNameType;      start      : int16;      
   BEGIN  { PrtMasterTcb } 
           start := res_buf[LbMRTH];         index := IndexOf (fwam, start);         count := CntEnt ( index );      { count the entries }             { print number of entries and start address }         buffer := '        Entries in Master Request List';         InsrtDec ( buffer , count , 2 , next_pos , 0 );             IF count > 0 THEN            BEGIN { add other info }            InsrtOct ( buffer , start , 52 , next_pos );            temp_buf := ', starting at';            InsrtChr (buffer, temp_buf, 13, 39, next_pos);            END;  { add other info }             PrintLine (buffer, buffer);       
   IF count > 0 THEN 
       BEGIN   
      { print sub header } 
       temp_buf := 'Program  Class  T/O Ctr';        PrInsrtChr (buffer, temp_buf, 23, 19);      
      WHILE index <> 0 DO  
          BEGIN               WITH list_buffer[index].mast DO  	            BEGIN  	             IF entry_bad THEN                  BEGIN { bad entry }                 temp_buf := '(deleted)    *****';  !               InsrtChr ( buffer , temp_buf , 18 , 7 , next_pos ); !                END   { bad entry }              ELSE                 BEGIN { good entry }                  { get the name of the program }                 IdAddToName( id_seg_addr, pgname.int, dummy);                     temp_buf := pgname.char ;                 IF temp_buf[1] < ' ' THEN                    temp_buf := 'none  ';   %               InsrtChr ( buffer , temp_buf , PNAMELEN , 20 , next_pos );  %                END;  { good entry }       
            IF hp_3k THEN  
                BEGIN { tell user }                 temp_buf := '(HP3000 Request)';                 InsrtChr (buffer, temp_buf, 16, 43, next_pos);                  END;  { tell user }      !            InsrtDec ( buffer , mst_cls_num , 26 , next_pos , 0 ); ! &            InsrtDec ( buffer , (255 - tmout_cntr) * 5, 33 , next_pos , 0 ); &             PrInfo ( buffer );                  { update the pointer }              index := IndexOf(fwam, link);   
            END; { with }  
              END; { while }            PrintLine (buffer, '');  	      END; { if }  	        END; { PrtmasterTcb }          $SUBTITLE 'PrtSlaveTcb', PAGE$  ${---------------------------------------------------------------------}  $ ${ PRINT THE SLAVE STREAM LISTS IN "LIST_BUFFER"                       }  $ ${---------------------------------------------------------------------}  $ PROCEDURE PrtSlaveTcb;          VAR      tcount        : Int16 ;          { counter for slave list }     stream_num    : Int16 ;          { stream number          }     count         : Int16 ;          { count of tcb's         }     monitor_cnt   : Int16 ;          { number of monitors     }  
   index         : Int16 ; 
        BEGIN         tcount := 0;       
   { print header }  
    PrintLine (buffer,          '        Active Slave Monitors            1st TCB');      PrintLine (buffer,          '        stream  class  monitor  entries  address');          monitor_cnt := MinimumOf( res_buf [LbMNUM], MAX_STREAM);          FOR stream_num := 0 TO monitor_cnt  DO         BEGIN         WITH stream_list[stream_num] DO            BEGIN           IF mname.int[1] <> 0 THEN    { if monitor is active }  	            BEGIN  	              InsrtDec ( buffer , stream_num , 7 , next_pos , 0 );               InsrtDec ( buffer , cls_num , 15 , next_pos , 0 );              temp_buf := mname.char ;               InsrtChr ( buffer , temp_buf , 6 , 25 , next_pos );                count := CntEnt ( IndexOf(fwam, pointer) ) ;              tcount := tcount + count ;              InsrtDec ( buffer , count , 31 , next_pos , 0 );              PrInsrtOct ( buffer , pointer , 42 );               END; { IF }            END ; { WITH }       
      END ; { FOR }  
     temp_buf := 'Entries in Slave Lists';   InsrtChr (buffer, temp_buf, 22, 9, next_pos);   PrInsrtDec (buffer, tcount, 2, 0);  END ;  { PrtSlaveTcb }          
$SUBTITLE 'PrtPNL', PAGE$  
 ${---------------------------------------------------------------------}  $ ${  PRINT PNL ENTRIES IN "LIST_BUFFER"                                 }  $ ${---------------------------------------------------------------------}  $ 
   PROCEDURE PrtPNL; 
        VAR  
      count      : Int16;  
 
      dummy      : Int16;  
 
      index      : Int16 ; 
       pgname     : PgNameType;  
      start      : Int16;  
     
   BEGIN  { PrtPNL } 
        start := res_buf[LbPNLH];     index := IndexOf (fwam, start);     count := CntEnt (index);      { count the entries }      
   PrintLine (buffer, ''); 
    { print number of entries and start address }        { print number of entries and start address }         buffer := '        Entries in Process Number List';         InsrtDec ( buffer , count , 2 , next_pos , 0 );             IF count > 0 THEN            BEGIN { add other info }            InsrtOct ( buffer , start , 52 , next_pos );            temp_buf := ', starting at';            InsrtChr (buffer, temp_buf, 13, 39, next_pos);            END;  { add other info }             PrintLine (buffer, buffer);       
   IF count > 0 THEN 
       BEGIN   
      { print sub header } 
       temp_buf := 'Program  Loglu';         PrInsrtChr (buffer, temp_buf, 14, 24);      
      WHILE index <> 0 DO  
          BEGIN               WITH list_buffer[index].pnl DO   	            BEGIN  	             { check the bad bit }               IF entry_bad THEN   
               BEGIN 
                temp_buf := '(deleted)     *****';                  InsrtChr (buffer, temp_buf, 17, 7, next_pos);  	               END 	             ELSE                 BEGIN { good entry }                  { get the name of the program }                 IdAddToName (id_seg_addr, pgname.int, dummy);                 temp_buf := pgname.char ;                 IF temp_buf[1] < ' ' THEN                    temp_buf := 'none  ';   "               InsrtChr (buffer, temp_buf, PNAMELEN, 25, next_pos);  "                END;  { good entry }       
            IF hp_3k THEN  
 
               BEGIN 
                temp_buf := '(HP3000 process)';                 InsrtChr (buffer, temp_buf, 16, 41, next_pos);   
               END;  
                 PrInsrtDec (buffer, trm_lu, 32, 0);                   { update the pointer }              index := IndexOf(fwam, link);   
            END; { with }  
              END; { while }       	      END; { if }  	     	   END; { PrtPNL } 	         $SUBTITLE 'PrtNullList', PAGE$  ${---------------------------------------------------------------------}  $ ${  PRINT NUMBER OF ENTRIES IN THE NULL LIST                           }  $ ${---------------------------------------------------------------------}  $ 
   PROCEDURE PrtNullList;  
        VAR        count    : Int16 ;        index    : Int16 ;        start    : Int16;          BEGIN         start := res_buf [LbNull];      index := IndexOf (fwam, start);     count := CntEnt (index);       
   PrintLine (buffer, ''); 
    buffer := '        Entries in Null list';     InsrtDec ( buffer , count , 2 , next_pos , 0 );      
   IF count > 0 THEN 
       BEGIN { add other info }        InsrtOct ( buffer , start , 42 , next_pos );        temp_buf := ', starting at';        InsrtChr (buffer, temp_buf, 13, 29, next_pos);        END;  { add other info }         PrintLine (buffer, buffer);         END;           
$SUBTITLE 'LiInfo', PAGE$  
        BEGIN  { LI Case }       	   GetFwam (fwam); 	        IF fwam > 0 THEN     { Otherwise DS is not initialized }             BEGIN         PrintLine ( buffer , '');         PrintLine ( buffer , ' DS/1000 Lists:');        PrintLine ( buffer , '');             { Move pointers and lists to local areas }  
      DispatchLock;  
 
      CallGetRes (buffer); 
       GetTcbLists (fwam, list_buffer, LIST_BUFFER_SIZE);        GetStreamList (stream_list, STREAM_LIST_SIZE);        DispatchUnlock;       
      PrtMasterTcb;  
     	      PrtSlaveTcb; 	           PrtPNL;       	      PrtNullList; 	     	      END; { IF }  	     	   END; {LI Case } 	         $SUBTITLE 'MAInfo',PAGE$  "{-----------------------------------------------------------------}  " "{  * Internal *              MAInfo                * Internal *   }  " "{-----------------------------------------------------------------}  "     PROCEDURE MAInfo     (VAR buffer : Charray78);      CONST      NO_DEBUG_BIT = 32767;      VAR   
   index          : Int16; 
 
   entries_count  : Int16; 
    ma_entry       : MaType;       BEGIN       IF DS_StateofDSAM = ADSInit THEN     BEGIN  %                 { Get all RES values; ignore those that are not needed }  %    CallGetRES (buffer);       
   PrInfo (buffer);  
    PrintLine (buffer,'Message Accounting Information');   
   PrInfo (buffer);  
     { M. A. State Table }      entries_count := -res_buf [LbMCTR];     IF entries_count = 0 THEN     { Check number of entries }        PrintLine (buffer,'  No Entries')      ELSE BEGIN         PrintLine (buffer,  $       ' Node State  # Unack   # Linedowns  Timeout  # Cancellations');  $ 	      index := 0;  	           REPEAT      
      index := index + 1;  
       DS_EnterCritical (wkmap, ierr);         IF ierr = 0 THEN           BEGIN   { OK to Fetch }      "         Fetch_MA_index (index, ma_entry);   { Get entire MA entry } "          DS_LeaveCritical (wkmap);      
         WITH ma_entry DO  
 	            BEGIN  	     $            IF rtr_addr >= 0 THEN        { If negative, it is a dummy }  $ 
               BEGIN 
                    { Print information }                 InsrtDec (buffer, rtr_addr, 1, next_pos, 0);                      CASE state OF                    0 : temp_buf := 'Down';                     1 : temp_buf := 'None';                     2 : temp_buf := 'Up';                     3 : temp_buf := 'Pend';                     Otherwise;      { Abnormal condition }                    END;                 InsrtChr (buffer, temp_buf, 4, 9, next_pos);       !               InsrtDec (buffer, unacknowledged, 15, next_pos, 0); !                InsrtDec (buffer, lines_down, 27, next_pos, 0);                 InsrtDec (buffer, timeout, 37, next_pos, 0);                  PrInsrtDec ( buffer, c_cancel_count , 50, 0);                 END;  { If not negative }      
            END;  { With } 
     %         IF (index MOD 18) = 0 THEN    { Issue a blank line and the More } % %            BEGIN                      {   prompt string                 } %             PrInfo (buffer);              IF NOT More THEN  
               BEGIN 
 $               index := entries_count;  { Force an exit from the loop }  $ 	               END 	 %            ELSE PrInfo (buffer);       { ..or print another blank line }  %             END;               END   { OK to Fetch }            ELSE BEGIN           buffer := ENT_CRIT_ERR;  
         PrInfo (buffer);  
          END;       #      UNTIL (ierr <> 0) OR (index = entries_count);    { Total count } #           END; { Number of entries not zero }          END;  { IF DS_StateofDSAM }      END; {MA case }       $SUBTITLE 'NRInfo',PAGE$  "{-----------------------------------------------------------------}  " "{  * Internal *              NRInfo                * Internal *   }  " "{-----------------------------------------------------------------}  "     PROCEDURE NRInfo     (VAR buffer : Charray78);      CONST      BIT15     = -32768;     BIT13TO8  = 16128;      EXEC13    = -32755;   { 100015b }      VAR      index      : Int16;  
   entries_count : Int16;  
    nrv_entry  : NrvType;     cntwd      : ControlWordType;     drv_type   : Int16 ;      linkstatus : Int16 ;      arpapacbuf : ArpaPacType;      BEGIN       IF DS_StateofDSAM = ADSINIT THEN     BEGIN  { DS is initialized }       
   PrInfo (buffer);  
    PrintLine (buffer,'NRV Specifications:');  
   PrInfo (buffer);  
      { Get the needed RES values }     CallGetRES (buffer);        { NRV Node count and local node }     entries_count := -res_buf [LbNCNT];     IF entries_count <> 0 THEN     { Check number of entries }         BEGIN             buffer := ' Local node #:       , No. of Nodes =';        InsrtDec (buffer, res_buf [LbNODE], 15, next_pos, 0);         PrInsrtDec (buffer, entries_count, 37, 0);        PrInfo (buffer);        PrintLine (buffer,  &      '      Node       IP ADDRESS     LU         T/O(Sec)   Type  Level');  & 	      index := 0;  	           REPEAT      
      index := index + 1;  
       DS_EnterCritical (wkmap, ierr);         IF ierr = 0 THEN           BEGIN  { OK to Fetch }   "                                            { Get entire NRV entry } "          Fetch_NRV_index (index, nrv_entry);           DS_LeaveCritical (wkmap);      
         WITH nrv_entry DO 
 	            BEGIN  	     &            IF rtr_addr < 0 THEN        { If negative, it is a blank entry } & $               BEGIN  { Blank entries may be used for a later release }  $ $                      {   of additions and deletions to/from the NRV  }  $           (*   temp_buf := '** Blank Entry **';                  PrInsrtChr (buffer, temp_buf, 17, 5);    *)  	               END 	             ELSE BEGIN                 InsrtDec (buffer, rtr_addr, 5, next_pos, 0);                  InsrtDec (buffer, msg_level, 58, next_pos, 0);                      IF lu_timeout = 0 THEN the_value.int := 0                 ELSE the_value.int := ( 256 - lu_timeout ) * 5;      !               InsrtDec (buffer, the_value.int, 44, next_pos, 0);  !                InsrtDec (buffer, lu, 29, next_pos, 0);                     IPArpaPac ( ip_addr , arpapacbuf );                 temp_buf := arpapacbuf ;   "               Insrtchr ( buffer , temp_buf , 15 , 15 , next_pos );  "                    IF non_rtr_lu THEN                     BEGIN                     temp_buf := ',(NR)';                     InsrtChr (buffer, temp_buf, 5, 35, next_pos);                      END;                     IF neighbor THEN                     BEGIN                     temp_buf := '*';                     InsrtChr (buffer, temp_buf, 1, 11, next_pos);                      END;      %               IF lu <> 0 THEN   { If LU is  not local, get device type }  %                   BEGIN                         { find the driver type }                    cntwd[1] := IOR ( lu , BIT15 ) ;                    cntwd[2] := 0 ;                         LuStatus ( EXEC13 , cntwd , linkstatus );                        BEGIN   { handle XLUEX error }                        ABReg (a_reg , b_reg);                        buffer :=  &                         'Unable to get driver type, status on EXEC call ='; &                      PrInsrtOct (buffer, a_reg, 50);                       END;    { handle XLUEX error }                         IF a_reg = 0 THEN   
                     BEGIN 
 '                      { get the driver type from bits 13 to 8 of linkstatus }  '                       drv_type := IAND ( linkstatus, BIT13TO8 ) ;   '                     drv_type := drv_type DIV 256;   { shift right 8 places }  '                           InsrtOct (buffer, drv_type, 52, next_pos);    
                     END;  
                       END;  { if LU <> 0 }                     PrInfo (buffer);                      END;  { if rtr_addr }      
            END;  { with } 
              END  { OK to Fetch }         ELSE BEGIN              buffer := ENT_CRIT_ERR;               PrInfo (buffer);           END;       $      IF (index MOD 16) = 0 THEN    { Issue a blank line and the More }  $ $         BEGIN                      {   prompt string                 }  $ 
         PrInfo (buffer);  
 
         IF NOT More THEN  
 	            BEGIN  	 "            index := entries_count;  { Force an exit from the loop } "             END   #         ELSE PrInfo (buffer);       { ..or print another blank line } #          END;             UNTIL (ierr <> 0) OR (index = entries_count);             END;  { if number of entries not zero }          END;    { DS is initialized }      END; {NR case}      $SUBTITLE 'RRInfo',PAGE$  "{-----------------------------------------------------------------}  " "{  * Internal *              RRInfo                * Internal *   }  " "{-----------------------------------------------------------------}  "     PROCEDURE RRInfo     (VAR buffer : Charray78);      CONST      MAX_INT16 = 32767;       VAR   
   index          : Int16; 
 
   entries_count  : Int16; 
    lv_entry  : LvEntryType;      up_down   : PACKED ARRAY [1..4] of CHAR;           BEGIN {RR case }      IF DS_StateofDSAM = ADSINIT THEN     BEGIN  %             { Get all the RES values; ignore those that are not needed }  %    CallGetRES (buffer);      entries_count := res_buf [LbLCNT];          IF entries_count > 0 THEN        BEGIN             PrInfo (buffer);        PrintLine (buffer,'Rerouting specifications:');         PrInfo (buffer);        temp_buf := 'Up/Down';        PrInsrtChr (buffer, temp_buf, 7, 30);         temp_buf := 'LU     Cost   Counter    Status';        PrInsrtChr (buffer, temp_buf, 31, 16);      	      index := 0;  	           REPEAT      
      index := index + 1;  
           DS_EnterCritical (wkmap, ierr);             IF ierr = 0 THEN           BEGIN  { OK to Fetch }                Fetch_LV (index, lv_entry);           DS_LeaveCritical (wkmap);      
         WITH lv_entry DO  
 	            BEGIN  	             IF Link_status = 1                 THEN up_down := ' up '               ELSE up_down := 'down';                   InsrtDec (buffer, Link_Lu, 12, next_pos, 0);              InsrtDec(buffer, Cost_Value, 21, next_pos, 0);              IF Up_Down_counter = 0 THEN   
               BEGIN 
 !               InsrtDec(buffer, Up_Down_Counter, 30, next_pos, 0); ! 	               END 	 	              ELSE 	 
               BEGIN 
 "               InsrtDec(buffer,11+Up_Down_Counter, 30, next_pos, 0); " 
               END;  
                 PrChrBuf(buffer, buffer, up_down, 43, 4);   
            END; { WITH }  
     %         IF (index MOD 16) = 0 THEN    { Issue a blank line and the More } % %            BEGIN                      {   prompt string                 } %             PrInfo (buffer);              IF NOT More THEN  
               BEGIN 
 $               index := entries_count;  { Force an exit from the loop }  $ 	               END 	 %            ELSE PrInfo (buffer);       { ..or print another blank line }  %             END;               END   { OK to Fetch }            ELSE BEGIN           buffer := ENT_CRIT_ERR;  
         PrInfo (buffer);  
          END;       #      UNTIL (ierr <> 0) OR (index = entries_count);    { Total count } #           END          ELSE             BEGIN  { no rerouting links}        PrintLine (buffer,'No rerouting links at this node');         END;   { no rerouting links}         END;  { IF StateofDSAM }       END; {RR case}      $SUBTITLE 'RSInfo',PAGE$  "{-----------------------------------------------------------------}  " "{  * Internal *              RSInfo                * Internal *   }  " "{-----------------------------------------------------------------}  "     PROCEDURE RSInfo     (VAR buffer : Charray78);  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{ PURPOSE : Dispalys currently used "#POOL" entries.              }  " "{                                                                 }  " "{ PARAMTERS :                                                     }  " "{   buffer   INPUT   array to be used for output                  }  " "{                                                                 }  " "{ SIDE EFFECTS :                                                  }  " "{                                                                 }  " "{ GLOBAL DATA STRUCTURES :                                        }  " "{   none                                                          }  " "{                                                                 }  " "{ ERROR HANDLING :                                                }  " "{                                                                 }  " "{ ALGORITHM :                                                     }  " "{                                                                 }  " "{  IF old services not initialized THEN return                    }  " "{  ELSE                                                           }  " "{   get number of POOL entries                                    }  " "{   FOR I := 1 TO number of entries DO                            }  " "{    BEGIN                                                        }  " "{    get the entry;                                               }  " "{    IF entry is in use THEN display the information              }  " "{    ELSE                                                         }  " "{     add 1 to the "empty entry" count                            }  " "{    END;                                                         }  " "{-----------------------------------------------------------------}  "     TYPE     Charray6 = PACKED ARRAY [1..6] OF CHAR;         SessionIdType = PACKED RECORD                     in_use        : BOOLEAN;                      cloned        : BOOLEAN;                      logging_off   : BOOLEAN;                      filler1       : Int4;                     by_execw      : BOOLEAN;                      local_id      : Int8;                     source_node   : Int16;                      execw_seq_num : Int8;                     owners_id     : Int8;                     program_name  : Charray6;                     timer         : Int16;                      END;          SessionVarType = RECORD CASE BOOLEAN OF  
      TRUE  : (I : Int16); 
       FALSE : (Rec : SessionIdType);        END;  CONST      JUSTIFY = -1;      VAR   
   count          : Int16; 
    header_printed : BOOLEAN;  
   in_use_count   : Int16; 
 
   numbentries    : Int16; 
 
   poolptr        : Int16; 
    rec            : SessionVarType;   
   temp           : Int16; 
         PROCEDURE DisplayRsEntry(VAR entry : SessionvarType);   ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${ PURPOSE : This routine is called to display one #POOL entry.        }  $ ${           The entry is assumed to be valid and "in use".            }  $ ${           Calls are made to the NSINFO output and formatting        }  $ ${           routines as well as the external routine "FormatTime".    }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $     VAR   !   Int      : Int16;                 { used for type conversion }  ! #   next_pos : Int16;                 { a dummy required by Insrt_Dec}  #    temp_buf : Charray78;         BEGIN   { DisplayrsEntry }      buffer := '                                          ';         int := entry.rec.source_node;     InsrtDec (buffer, int, 8, next_pos, JUSTIFY);         int := entry.rec.owners_id;     InsrtDec (buffer, int, 15, next_pos, JUSTIFY);          int := entry.rec.local_id;      InsrtDec (buffer, int, 22, next_pos, JUSTIFY);          FormatTime(entry.rec.timer , buffer, 24);         IF entry.rec.cloned THEN         BEGIN         temp_buf := '(clone) ';         InsrtChr (buffer, temp_buf, 8, 41, next_pos);         END;         temp_buf := entry.rec.program_name;     PrInsrtChr (buffer, temp_buf, 6, 35);         END;    { DisplayrsEntry }           	BEGIN { RS Case }  	    temp := 0;   	   GetFwam (temp); 	 
   IF temp = 0 THEN  
       BEGIN   { old services not initialized }        PrintLine (buffer, '');          PrintLine (buffer, 'DS/1000-IV services not initialized');         END     { old services not initialized }     ELSE         BEGIN   { displaying info. }        in_use_count := 0;        header_printed := FALSE;        GetPool (poolptr);        MoveFromSys(poolptr, numbentries, 1);         numbentries := - numbentries;         poolptr := poolptr + 1;         FOR count := 1 to numbentries DO            BEGIN   { checking one entry }            MoveFromSys(poolptr, rec.i, 7);             IF rec.rec.in_use THEN               BEGIN { this entry in use }               in_use_count := in_use_count + 1;               IF NOT header_printed THEN                   BEGIN   { print headers }   %                PrintLine(buffer, 'Remote Sessions Accessing this Node');  %                 PrintLine(buffer, '');                  PrintLine(buffer, '');                  PrintLine(buffer,'   Source   Session ID');   '                PrintLine(buffer,'    Node   Source Local  Timer   Program');  '                 header_printed := TRUE;                   END;    { print headers }                DisplayRsEntry(rec);                END;  { this entry in use }            poolptr := poolptr + 7;             END;    { checking one entry }        IF in_use_count = 0 THEN           BEGIN { none in use }  $         PrintLine (buffer, 'No remote sessions currently established'); $          END;  { none in use }            PrintLine(buffer, '');        PrDecBuf(buffer, '       Empty Entries',                 numbentries - in_use_count, 1, 0);         END;    { displaying info. }  END; {RS case }               $SUBTITLE 'VAInfo',PAGE$  "{-----------------------------------------------------------------}  " "{  * Internal *              VAInfo                * Internal *   }  " "{-----------------------------------------------------------------}  "     PROCEDURE VAInfo     (VAR buffer : Charray78);      CONST   	   LOW_BYTE = 255; 	 
   RN_LOOP_CNT = 4;  
 
   CLASS_NO_LOOP_CNT = 13; 
     VAR   
   prog_name : PgNameType; 
 
   entries_count : Int16;  
    i         : Int16;      rn        : Int16;      id_num    : Int16;      id_add    : Int16;      lu        : Int16;      buff_size : Int16;      areg      : Int16;      breg      : Int16;      lu_of_3000: Int16;      x25_flag  : Int16;   
   cont_rec_flag  : Int16; 
    printing  : BOOLEAN;      { Avoid asking 'More' too often }      $SUBTITLE 'GetOwnerLocker',PAGE$  "{-----------------------------------------------------------------}  " "{  * Local *            GetOwnerLocker               * Local *    }  " "{-----------------------------------------------------------------}  "     PROCEDURE GetOwnerLocker (id_num : Int16);      CONST      NONE     = 0;  	   GLOBAL   = 255; 	     
BEGIN  { GetOwnerLocker }  
     
   IF id_num = GLOBAL THEN 
       BEGIN         temp_buf := '(Global)';         END      ELSE IF id_num = NONE THEN         BEGIN         temp_buf := ' (None)';        END      ELSE BEGIN         id_add := IdNumberToAdd (id_num);         IdAddToName (id_add, prog_name.int, lu);        temp_buf := prog_name.char;         END;      END;  { GetOwnerLocker }      
$SUBTITLE 'VaInfo', PAGE$  
 	BEGIN  { VA case } 	     
   PrInfo (buffer);  
    PrintLine (buffer,'DS/1000 Values:');  
   PrInfo (buffer);  
     #{ get all RES and system values, although not all will be used here }  #    CallGetRES (buffer);      CallGetSYS (buffer);       
{ Resource numbers } 
     PrintLine (buffer,' Resource numbers:     Owner     Locker');              FOR i := 1 TO RN_LOOP_CNT DO         BEGIN             CASE i OF   	         1:  BEGIN 	              the_value.int := res_buf [LbPLOGPlus];                buffer := '   PLOG Synch.';  	             END;  	 	         2:  BEGIN 	              the_value.int := res_buf [LbQRN];               buffer := '   Initialization';   	             END;  	 	         3:  BEGIN 	              the_value.int := res_buf [LbTBRN];                buffer := '   TCB Access';   	             END;  	 	         4:  BEGIN 	              the_value.int := res_buf [LbMARN];                buffer := '   MA Table Access';  	             END;  	          Otherwise;  { Abnormal condition }            END;                 rn := the_value.byt.lower;      $      IF rn <> 0 THEN   { If rn is zero then entry point is not in use } $          BEGIN               InsrtDec (buffer, rn, 20, next_pos, -1);                GetXMapElement (sys_buf[DolRNTA], rn, the_value.int);               id_num := the_value.byt.lower;   { find locker }            GetOwnerLocker (id_num);            InsrtChr (buffer, temp_buf, 8, 33, next_pos);               id_num := the_value.byt.upper;   { find owner }           GetOwnerLocker (id_num);            PrInsrtChr (buffer, temp_buf, 8, 23);               END;  { if }       
      END;  { for }  
     $PAGE$  	{ Class numbers }  	    PrintLine (buffer,' Classes assigned to programs:');          FOR i := 1 TO CLASS_NO_LOOP_CNT DO         BEGIN             CASE i OF   	          1: BEGIN 	              the_value.int := res_buf [LbLUMP];                temp_buf := 'LUMAP';   	             END;  	 	          2: BEGIN 	              the_value.int := res_buf [LbPLOG];                temp_buf := 'PLOG';  	             END;  	 	          3: BEGIN 	              the_value.int := res_buf [LbEXTC];                temp_buf := 'EXECM';   	             END;  	 	          4: BEGIN 	              the_value.int := res_buf [LbEXHC];                temp_buf := 'EXECM';   	             END;  	 	          5: BEGIN 	              the_value.int := res_buf [LbMAHC];                temp_buf := 'M. A.';   	             END;  	 	          6: BEGIN 	              the_value.int := res_buf [LbOTCV];                temp_buf := 'OTCNV';   	             END;  	 	          7: BEGIN 	              the_value.int := res_buf [LbINCV];                temp_buf := 'INCNV';   	             END;  	 	          8: BEGIN 	              the_value.int := res_buf [LbQCLM];                temp_buf := 'QCLM';  	             END;  	 	          9: BEGIN 	              the_value.int := res_buf [LbGRPM];                temp_buf := 'GRPM';  	             END;  	 	         10: BEGIN 	              the_value.int := res_buf [LbRPCV];                temp_buf := 'RPCNV';   	             END;  	 	         11: BEGIN 	              the_value.int := res_buf [LbRQCV];                temp_buf := 'RQCNV';   	             END;  	 	         12: BEGIN 	              the_value.int := res_buf [LbQZCL];                temp_buf := 'QUEZ';  	             END;  	 	         13: BEGIN 	              the_value.int := res_buf [LbQXCL];                temp_buf := 'QUEX';  	             END;  	          Otherwise;  { Abnormal condition }            END;           &      IF the_value.byt.lower <> 0 THEN     { If the value is zero then the } & &         BEGIN                             {   entry point is not in use   } &          InsrtChr (buffer, temp_buf, 5, 8, next_pos);            PrInsrtDec (buffer, the_value.byt.lower, 4, -1);            END;       
      END;  { for }  
     $PAGE$  printing := FALSE;   { Initialize for 'More' }      &IF (res_buf [LbFWAM] > 0) AND (More) THEN   { No display if #FWAM is zero }  & 
   BEGIN  { If #FWAM > 0 } 
     	{ Timeout Values } 	    PrintLine (buffer,' Timeout Values (sec):');   "                                                 { Master Timeout }  " &   the_value.int := res_buf [LbMSTO];                 { Negative of bits   } & &   the_value.int := (256 - the_value.byt.lower) * 5;  { 7 - 0 only * 5 secs} &    buffer := '   Master Timeout';      PrInsrtDec (buffer, the_value.int, 23, 0);       !                                                 { Slave Timeout } ! &   the_value.int := res_buf [LbSVTO];                 { Negative of bits   } & &   the_value.int := (256 - the_value.byt.lower) * 5;  { 7 - 0 only * 5 secs} &    buffer := '   Slave Timeout';     PrInsrtDec (buffer, the_value.int, 23, 0);       $                                                 { Remote Busy Retries } $ &   the_value.int := res_buf [LbBREJ];                  { Complement bits  }  & &   the_value.int := 15 - (the_value.byt.upper MOD 16); {   11 - 8 only    }  &    buffer := '   Remote Busy Retries';     PrInsrtDec (buffer, the_value.int, 23, 0);       #                                                 { Remote Quiet Wait } #    the_value.int := res_buf [LbWAIT];      the_value.int := -the_value.int;      buffer := '   Remote Quiet Wait';     PrInsrtDec (buffer, the_value.int, 23, 0);       "                                                 { Max Retry Delay } "    the_value.int := res_buf [LbRDLY];      the_value.int := -the_value.int;      buffer := '   Max Retry Delay';     InsrtDec (buffer, the_value.int, 22, next_pos, 0);      buffer[28] := buffer[27];      { insert decimal point }     buffer[27] := buffer[26];     buffer[26] := '.';   
   PrInfo (buffer);  
     
   printing := TRUE; 
 
   END;   { If #FWAM > 0 } 
     $PAGE$  !IF (res_buf [LbMHCT] > 0) THEN     { No display if #MHCT is zero } !    IF ((res_buf [LbFWAM] > 0) AND printing) OR        More THEN      BEGIN  { if #MHCT is zero }      { Maximum Hop Count }          the_value.int := res_buf [LbMHCT];      the_value.int := -the_value.int;      buffer := ' Maximum Hop Count';     PrInsrtDec (buffer, the_value.int, 23, 0);       { Maximum Link Down Count }          the_value.int := res_buf [LbMDCT];      the_value.int := -the_value.int;      buffer := ' Maximum Link Down Count';     PrInsrtDec (buffer, the_value.int, 23, 0);          END;   { if #MHCT is zero }      'IF (res_buf [LbFWAM] > 0) AND printing THEN   { No display if #FWAM is zero }  '    BEGIN  { if #FWAM is zero }      
{ Progl Message LU } 
        the_value.int := res_buf [LbPRLU];      buffer := ' Progl Message LU';      PrInsrtDec (buffer, the_value.int, 23, 0);       { APLDR Down-Load Node }      #(**)  { This ought to only be printed when appropriate -- on RTE-A you # %      {   cannot find this out from the opsys type as used to be on RTE-IV % #      { Or shall we change the wording of the message ' Last APLDR...' #       {}         the_value.int := res_buf [LbLNOD];      buffer := ' Last APLDR Load-Node';       $   IF the_value.int <> -1 THEN        { Was the down_load number used? } $       PrInsrtDec (buffer, the_value.int, 23, 0)      ELSE BEGIN   
      temp_buf := 'None';  
       PrInsrtChr (buffer, temp_buf, 4, 25);   	      END;  { if } 	         	{ Upgrade Level }  	        the_value.int := res_buf [LbLEVL];      buffer := ' Upgrade Level';     PrInsrtDec (buffer, the_value.byt.lower, 23, 0);      buffer := ' Upgrade SubLevel';      PrInsrtDec (buffer, the_value.byt.upper, 23, 0);       { RFA Files }          the_value.int := res_buf [LbRFSZ];      IF (the_value.int >= 0) THEN         BEGIN         buffer := '        RFA Files May Be Open';        PrInsrtDec (buffer, the_value.int, 2, 0);   	      END;  { if } 	     $PAGE$  	{ 3000 LU Table }  	        IF More THEN         BEGIN   #      entries_count := res_buf [Lb3KLU];         { count of entries }  #       IF entries_count <> 0 THEN           BEGIN  
         PrInfo (buffer);  
          buffer := ' HP 3000 LU Table';   
         PrInfo (buffer);  
          buffer := '   LU  Buffer Size  CR Flag';   
         PrInfo (buffer);  
          i := 0;                             { loop on entry number }            REPEAT   
         i := i + 1; 
          DDollarThreeIN (i, lu_of_3000, buff_size,                           cont_rec_flag, x25_flag);           ABReg (areg, breg);  #         IF areg >= 0 THEN         { continue if there was no error }  # 	            BEGIN  	             InsrtDec (buffer, lu_of_3000, 0, next_pos, 0);                  IF buff_size >= 0 THEN                 InsrtDec (buffer, buff_size, 10, next_pos, 0)              ELSE BEGIN                 temp_buf := '*Down*';                 InsrtChr (buffer, temp_buf, 6, 10, next_pos);                 END;  { if buff_size }                   IF x25_flag  <> 0 THEN  
               BEGIN 
                temp_buf := '(X.25)';                 InsrtChr (buffer, temp_buf, 6, 30, next_pos);                 END;  { IF x_dot }                   PrInsrtDec (buffer, cont_rec_flag, 20, 0);                  END;  { if areg }       &         IF (i MOD 16) = 0 THEN         { Issue a blank line and the More }  & &            BEGIN                       {   prompt string                 }  &             PrInfo (buffer);              IF NOT More THEN  
               BEGIN 
 $               i := entries_count;      { Force an exit from the loop }  $                printing := FALSE;   	               END 	 %            ELSE PrInfo (buffer);       { ..or print another blank line }  %             END;                   UNTIL (i = entries_count);                END;  { if entries_count }             IF printing THEN           BEGIN           address := res_buf [DDolLID];           GetMapElement (address, 0, the_value.int);            IF the_value.int <> 0 THEN   $            BEGIN                     { read characters of ID sequence } $ #            MoveBytes ((address + 1) * 2, (AddressOf (temp_buf)) * 2,  #                        the_value.int);              buffer := '  Local ID Sequence:';               PrInsrtChr (buffer, temp_buf, 28, the_value.int);   
            END;   { if }  
              address := res_buf [DDolRID];           GetMapElement (address, 0, the_value.int);            IF the_value.int <> 0 THEN   $            BEGIN                     { read characters of ID sequence } $ #            MoveBytes ((address + 1) * 2, (AddressOf (temp_buf)) * 2,  #                        the_value.int);              buffer := '  Remote ID Sequence:';              PrInsrtChr (buffer, temp_buf, 28, the_value.int);   
            END;   { if }  
              END;   { if printing }             END;   { if More }         END;   { if #FWAM is zero }      
   PrInfo (buffer);  
     END; {VA case }       $SUBTITLE 'DSInf',PAGE$    {--------------------------------------------------------------}    {   DSInf                                                      }    {--------------------------------------------------------------}       PROCEDURE DSInf      (VAR info: InfoRecordType);      {}  { Description   #{     This routine is called to process all user information requests  # ${     of DS/1000-IV. It will present the user with a menu of DS/1000-IV  $ {     information choices and will process each request.  {}  { Parameters  "{     info     IN/OUT      Global variable which controls the outer  " {                          Information Utility's shell.   "{                          This record contains several fields which " !{                          are used to direct the shells actions.  ! {}  { Global Data Structures  {}  { Error Handling  {}  { Algorithm   {}  BEGIN { DSInf }       WITH info DO     BEGIN         { Set up the DS/1000 prompt }     DS1000_prompt := PROMPT_CONST;          choice := HE;      
   WHILE (choice <> EX) DO 
       BEGIN { WHILE more DS/1000 commands }       
      CASE choice OF 
              HE : PrintMenu (info);  { DS/1000 menu }            LI : LIInfo (buffer); { List tables  }            MA : MAInfo (buffer); { MA table  }           NR : NRInfo (buffer); { NRV table  }            RR : RRInfo (buffer); { Rerouting table }           RS : RSInfo (buffer); { Remote session table }            VA : VAInfo (buffer); { DS/1000 values }                EX : ;                OTHERWISE   { Illegal command }              PrintMenu (info);                END;  { CASE choice }            asciichoice.int := choice;  '      DS1000_prompt := PROMPT_CONST;   { This buffer may be erased each time } '        DS1000_prompt [CMD_POS]   := Chr (asciichoice.bytes [1]);           DS1000_prompt [CMD_POS+1] := Chr (asciichoice.bytes [2]);    
      oldchoice := choice; 
       PrMenu (buffer);    { blank line }  %      IF NOT PromptMenu (DS1000_prompt, choice) THEN choice := oldchoice;  %           END;  { WHILE more commands }       	   END;  { WITH }  	 { Return to the main shell }  END;  { DSInf }       
$SUBTITLE 'PrChrBuf',PAGE$ 
  {--------------------------------------------------------------}    {   PRINT CHARACTER/BUFFER                                     }    {--------------------------------------------------------------}       PROCEDURE PrChrBuf       { Output the buffer as follows:  }      (VAR outbuf : Charray78;    { Write into this buffer      }          buffer1: Charray78;    {   ...this buffer            }          buffer2: Charray78;    {   ...and these characters   }          pos    : Int16;        {       (pos of chars)        }          len    : Int16);       {       (length for chars)    }      
BEGIN  { PrChrBuf }  
        outbuf := buffer1;      PrInsrtChr (outbuf, buffer2, len, pos);      
END;   { PrChrBuf }  
         
$SUBTITLE 'PrDecBuf',PAGE$ 
  {--------------------------------------------------------------}    {   PRINT DECIMAL/BUFFER                                       }    {--------------------------------------------------------------}       	PROCEDURE PrDecBuf 	    (VAR outbuf : Charray78;    { Write into this buffer      }          buffer : Charray78;    {   ...these characters       }          decnum : Int16;        {   ...and this number        }          pos    : Int16;        {       (pos for number)      }          justify: Int16);       {       (-1 to left justify)  }          
BEGIN  { PrDecBuf }  
     
   outbuf := buffer; 
    PrInsrtDec (outbuf, decnum, pos, justify);       
END;   { PrDecBuf }  
         $ SUBTITLE 'PrintLine', PAGE $  ${----------------------------------------------------------------------} $ ${   PRINT LINE                                                         } $ ${----------------------------------------------------------------------} $     
PROCEDURE PrintLine  
    (VAR outbuf : Charray78;           buffer : Charray78);      
BEGIN  { PrintLine } 
        PrInsrtChr (outbuf, buffer, 78, 1);      
END;   { PrintLine } 
         $ SUBTITLE 'PrintMenu', PAGE $  ${----------------------------------------------------------------------} $ ${   PRINT MENU                                                         } $ ${----------------------------------------------------------------------} $     
PROCEDURE PrintMenu  
    (VAR info : InfoRecordType);       VAR      i : Int16;       
BEGIN  { PrintMenu } 
     WITH info DO     BEGIN         FOR i := 1 TO 11 DO        BEGIN         CASE i OF         0: ;        1: buffer := '            DS/1000 Information';         2: ;        3: buffer := 'HE = Help';         4: buffer := 'LI = List tables';        5: buffer := 'MA = Message Accounting table';         6: buffer := 'NR = Nodal Rerouting Vector';         7: buffer := 'RR = Rerouting table';        8: buffer := 'RS = Remote session table';         9: buffer := 'VA = Values';        10: buffer := 'EX = Exit';        11: ;        Otherwise;      
      END;  { case } 
           PrMenu (buffer);      
      END;  { For }  
     	   END;  { With }  	     
END;   { PrintMenu } 
                 END. { MODULE }  