     $PASCAL '   91790-16062 REV.4010 <860410.1703>'   $TITLE 'FMTRC Formatting routines'$   
$STANDARD_LEVEL 'HP1000' $ 
 $DEBUG $  $RECURSIVE OFF$   $ HEAP 2 $  
$ HEAP_DISPOSE OFF $ 
 $ SUBPROGRAM $  $ RANGE OFF $   $ CDS ON $      PROGRAM FMVIN;      %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : FMVIN   {      SOURCE : 91790-18062   {       RELOC : 91790-16062   
{        PGMR : JXL  
 {}  {  FMVIN is a segment of the Trace Formatter FMTRC.   {}  "{  FMTRC reads unformatted messages out of a VMA file that has been  " !{  created by the AdvanceDS program NETRC.  FMTRC formats the raw  ! "{  trace messages  and analyzes the messages somewhat.  The user can " !{  specify options that limit the formatted output to a subset of  ! {  the messages contained in the raw trace file.  {   {}  { MODIFICATIONS:  #{  4/9/86   ash   remove duplicate call to AddError code in Openfiles. # {}       $INCLUDE 'src/FMTRC.PASI', SUBTITLE 'Imports and Globals', PAGE$       $SUBTITLE 'External Procedures', PAGE$  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   External Procedures                           }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " 	$ HEAPPARMS OFF $  	     '{ Converts a binary number to its ascii representation as a decimal integer }  ' PROCEDURE CNumD      (   num : Int16;     { Binary Number }   
    VAR chars : SixChar);  
    EXTERNAL;      &{ Converts a binary number to its ascii representation as an octal integer } & PROCEDURE CNumO      (   num : Int16;     { Binary Number }   
    VAR chars : SixChar);  
    EXTERNAL;      	FUNCTION FmpClose  	    (VAR dcb : DcbType;          error : Int16)     : Int16;      EXTERNAL;          FUNCTION FmpInteractive      (VAR dcb : DcbType)     : Int16;      EXTERNAL;          
$ FIXED_STRING ON $  
     FUNCTION FmpOpen     (VAR dcb : DcbType;      VAR error : Int16;          filedesc : String64;          options : OptionType;           bufs : Int16)      : Int16;      EXTERNAL;          FUNCTION FmpSize     (    filedesc : String64;  
    VAR filesize : Int32)  
    : Int16;      EXTERNAL;      
$ FIXED_STRING OFF $ 
     	FUNCTION FmpWrite  	    (VAR dcb : DcbType;          error : Int16;          fmp_buffer : FmpBufferType;   
        maxlength : Int16) 
    : Int16;      EXTERNAL;          PROCEDURE FTime      (VAR time_array : FtimeType);     EXTERNAL;          $ HEAPPARMS ON $      PROCEDURE GetHeapStackInfo    $ ALIAS 'Pas.GetMemInfo2' $      (VAR heap_Info : Info_Rec);     EXTERNAL;      	$ HEAPPARMS OFF $  	         FUNCTION IAnd   	    (num1 : Int16; 	 	     num2 : Int16) 	    : Int16;      EXTERNAL;          FUNCTION IfBrk     : Int16;      EXTERNAL;          FUNCTION IfTTY     (lu : Int16)      : Int16;      EXTERNAL;          FUNCTION PasSParms    $ ALIAS 'Pas.SParameters' $      (    pos : Int16;    { Parameter number }      VAR parm : String)  !   : Int16;             { Length of the parameter in characters }  !    EXTERNAL;          
$ FIXED_STRING ON $  
     	PROCEDURE VmaOpen  	    (VAR error : Int16;          name : String64;          optn : OptionType);      EXTERNAL;      
$ FIXED_STRING OFF $ 
     PROCEDURE VmaSt      (VAR version : Int16;  
    VAR my_size : Int16);  
    EXTERNAL;          $SUBTITLE 'FMTRC routines',PAGE$  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{              FMTRC Routines                                     }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " %$ HEAPPARMS ON $      { Heapparms option should be left on for the rest }  %         PROCEDURE AddErrorCode     (VAR msg_text   : STRING;          error_code : Int16);        EXTERNAL;       PROCEDURE AddMsgHeader     (    msg_number  : Int16;      VAR msg_buf     : String72;           exception   : BOOLEAN);         EXTERNAL;       
PROCEDURE AddMsgText 
    (VAR msg_text   : STRING;      VAR add_text   : STRING;          exception  : BOOLEAN);        EXTERNAL;       PROCEDURE CheckFmpError   
   (error : Int16);  
       EXTERNAL;       PROCEDURE CheckFmpWriteError  
   (error : Int16);  
       EXTERNAL;       
FUNCTION DefaultFormatFile 
    (VAR raw_file_name : String64) : String64;         EXTERNAL;       FUNCTION FileInteractive     (VAR filedesc : String64)     : BOOLEAN;         EXTERNAL;       PROCEDURE InitFormatFile  
   (VAR parms: ParmsType;  
     VAR options: OptionsType;       VAR VMA_info : VmaInfoType;       VAR command_value: TempEntryType);        FORWARD;      	PROCEDURE InitVMA  	    (VAR VMA_info : VMAInfoType;       VAR parms : ParmsType);         FORWARD;      
PROCEDURE OpenFiles  
    (VAR parms : ParmsType);         FORWARD;      
FUNCTION PromptUser  
    (VAR msg_text : String) : BOOLEAN;         FORWARD;      PROCEDURE ReadRunstringParms     ( VAR parms : ParmsType);        FORWARD;      PROCEDURE ReadVmaHeader      ( VAR VMA_info : VmaInfoType);         FORWARD;      PROCEDURE ScanVmaForSSNs     ( VAR options : OptionsType;        VAR VMA_info : VmaInfoType;  
     VAR SSNs : SSNsPtr);  
       FORWARD;      
PROCEDURE UIGetInput 
    (VAR prompt_string : STRING;       VAR input_string : STRING);         EXTERNAL;       FUNCTION UIOpenExcept      (VAR name: STRING;       VAR result: Int16) : Int16;         EXTERNAL;       PROCEDURE UIWriteExcept      (VAR except_string : STRING);        EXTERNAL;       PROCEDURE UIWriteOutput      (VAR output_string : STRING);        EXTERNAL;       	PROCEDURE Upshift  	    (VAR char_string: String);         EXTERNAL;               $ SUBTITLE 'InitFormatFile', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   InitFormatFile                                }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE InitFormatFile  
   (VAR parms: ParmsType;  
     VAR options: OptionsType;       VAR VMA_info : VmaInfoType;       VAR command_value : TempEntryType);   {}  { Discussion  #{   Write a FMTRC identifying title to the format trace file.  Follow  # "{   this with a strings that identify the raw and format filenames.  " #{   Write the user's label prominently.  Label and list the data from  # #{   the head record of the raw trace file.  Label and list the Options # {   used in formatting.   {}  { Parameters  {   parms          INPUT   User or default Parm values  {   options        INPUT   User or default Option values  !{   VMA_info       INPUT   Pointers, counters, timevalues from the ! {                            VMA file   "{   command_value  INPUT   User's parms and options in ascii format  " {}  { Called by   {  Main of FMTRC  {}  { Calls   {  CheckFMPError    FMTRC procedure   {  CNumD            RTE library routine   {  FileInteractive  FMTRC function  {  FMPWrite         RTE file system function  {  FTime            RTE library routine   {  SetStrLen        Pascal Standard string procedure  {  StrAppend        Pascal Standard string procedure  {  StrLen           Pascal Standard string procedure  {  StrWrite         Pascal Standard string procedure  {  UIWriteOutput    Fileio procedure  {}  {   {              Algorithm/Pseudocode   {   { Write 'Formatting...' message to interactive user   { From message array, obtain the FMTRC identifying string   { Obtain the current system time  !{ Write these strings and those listed below in a readable manner: ! {   .Raw trace filename   {   .Start time and stop time (must be formatted) of raw trace  {   .Count of entries in the raw trace  
{   .Format trace filename 
 {   .User's label for this formatting effort  {   .List Options used for this pass at filtering   {}      VAR               { maybe global level declarations }   
   outline : OutlineType;  
    fmp_outline : FmpBufferType;   
   ftime_buf : FTimeType;  
     VAR      next_line : Int16;    { case variable }     i : Int16;    { FOR loop control }   	   error : Int16;  	    next_pos : Int16;  { String write and read variable }     length : Int16;  { Return from FmpWrite }      BEGIN  {InitFormatFile}          IF FileInteractive (parms.command_input_name) THEN         BEGIN         msg_buf := MSGS [FORMATTING];         UIWriteOutput (msg_buf);        END;  {if}      	   next_line := 1; 	    outline.chr := ALL_BLANKS;   
   WHILE next_line <> 0 DO 
       BEGIN         CASE next_line OF              2,5,7,   { Space between lines of output }          10,13,   	        15:  BEGIN 	              outline.chr := ALL_BLANKS               END;  { case blank line }      	         1:  BEGIN 	              FTime (ftime_buf);           { initialize }               outline.chr := PROD_ID;      { NS/1000 }                FOR i := 1 TO 15 DO  $                BEGIN              { insert time starting in column 41}  $                 outline.view.as.int [20 + i] := ftime_buf [i];  
                END; 
              END;  { case line = 1 }               3:  BEGIN                        { originating node }  %             outline.chr := ALL_BLANKS;      { initialize for SetStrLen }  %              outline.chr := T_NODE;                StrAppend (outline.chr, vma_info.node_name);                END;  { case line = 3 }      "         4:  BEGIN                        { user's label for file }  "              outline.chr := parms.label_field;               END;  { case line = 4 }      	         6:  BEGIN 	              outline.chr := P_RAW;               StrAppend (outline.chr, parms.raw_file_name);               END;  { case line = 6 }      	         8:  BEGIN 	              outline.chr := T_START;  !             StrAppend (outline.chr, vma_info.start_time.tstring); !              END;  { case line = 8 }      	         9:  BEGIN 	              outline.chr := T_STOP;   !             StrAppend (outline.chr, vma_info.stop_time.tstring);  !              END;  { case line = 9 }      	        11:  BEGIN 	              CNumD (vma_info.num_datarecs, six_str);  "             StrWrite (outline.chr, 1, next_pos, six_str, T_COUNT);  " #             CNumD ((vma_info.total_records - vma_info.record_count),  #                      six_str);  #             StrWrite (outline.chr, 32, next_pos, six_str, OV_COUNT);  #              END;  { case line = 11 }       	        12:  BEGIN 	              CNumD (vma_info.records_lost, six_str);  "             StrWrite (outline.chr, 1, next_pos, six_str, D_COUNT);  "              END;  { case line = 12 }       	        14:  BEGIN 	              outline.chr := P_FMTR;                StrAppend (outline.chr, parms.format_file_name);                END;  { case line = 14 }       	        16:  BEGIN 	              outline.chr := O_LEVEL;               WITH options DO                  BEGIN                   IF (trace_level[SCKET]) THEN                     StrAppend(outline.chr, 'SOCKET ');                   IF (trace_level[NTWORK]) THEN                      StrAppend(outline.chr, 'NETWORK');                   END; { with }                END;  { case line = 16 }       	        17:  BEGIN 	              outline.chr := O_START;               SetStrLen (command_value [START_TIME_ENTRY],11);                command_value [START_TIME_ENTRY] [3] := ':';                command_value [START_TIME_ENTRY] [6] := ':';                command_value [START_TIME_ENTRY] [9] := ':';   $             StrAppend (outline.chr, command_value [START_TIME_ENTRY]);  $              END;  { case line = 17 }       	        18:  BEGIN 	              outline.chr := O_STOP;                SetStrLen (command_value [STOP_TIME_ENTRY],11);               command_value [STOP_TIME_ENTRY] [3] := ':';               command_value [STOP_TIME_ENTRY] [6] := ':';               command_value [STOP_TIME_ENTRY] [9] := ':';  #             StrAppend (outline.chr, command_value [STOP_TIME_ENTRY]); #              END;  { case line = 18 }       #        19:  BEGIN                     { Copy from the user's input }  #              outline.chr := O_PROTO;  #             IF (StrLen (command_value [PROTOCOL_ENTRY]) > 80-14) THEN # !                SetStrLen (command_value [PROTOCOL_ENTRY], 80-14); ! #             StrAppend (outline.chr, command_value [PROTOCOL_ENTRY]);  #              END;  { case line = 19 }       #        20:  BEGIN                     { Copy from the user's input }  #              outline.chr := O_SandD;  $             IF (StrLen (command_value [NODES_PAIR_ENTRY]) > 80-31) THEN $ "                SetStrLen (command_value [NODES_PAIR_ENTRY], 80-31); " $             StrAppend (outline.chr, command_value [NODES_PAIR_ENTRY]);  $              END;  { case line = 20 }       #        21:  BEGIN                     { Copy from the user's input }  #              outline.chr := O_SERV;   #             IF (StrLen (command_value [SERVMON_ENTRY]) > 80-24 ) THEN # !                SetStrLen (command_value [SERVMON_ENTRY], 80-24 ); ! "             StrAppend (outline.chr, command_value [SERVMON_ENTRY]); "              END;  { case line = 21 }       #        22:  BEGIN                     { Copy from the user's input }  #              outline.chr := O_SOCK;   "             IF (StrLen (command_value [SOCKET_ENTRY]) > 80-13) THEN "                  SetStrLen (command_value [SOCKET_ENTRY], 80-13);   "             StrAppend (outline.chr, command_value [SOCKET_ENTRY]);  " &             next_line := -1;         { incremented, this will become zero } &              END;  { case line = 22 }   
      END;  { case } 
     "   length := FmpWrite (dcb, error, outline.view.as.int, FMP_LENGTH); "    CheckFMPWriteError (error);         outline.chr := ALL_BLANKS;      next_line := next_line + 1;      	   END;  { while } 	     
outline.chr := ALL_BLANKS; 
 !length := FmpWrite (dcb, error, outline.view.as.int, FMP_LENGTH);  ! CheckFMPWriteError (error);       END;   {InitFormatFile}           $ SUBTITLE 'InitVMA', PAGE$   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                     InitVMA                                     }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     	PROCEDURE InitVMA  	    (VAR VMA_info : VmaInfoType;       VAR parms : ParmsType);   {}  { Discussion  !{  This procedure repeats the steps used to initialize the heap in !  {  NETRC.  It is needed so that Pascal's heap Stack pointer will   {  agree with the status in the VMA file.  The pointers should  {  agree, but if they do not, the program will abort.   {}  { Parameters  {   parms     INPUT    Holds the VMA file name (raw trace)  {   VMA_info  OUTPUT   Pointers, counters, timevalues from  {                        the VMA file   {}  { Called by   {  Main of FMTRC  {}  { Calls   {  AddMsgHeader      FMTRC procedure  {  AddMsgText        FMTRC procedure  {  GetHeapStackInfo  Pascal procedure   {  New               Pascal function  {  ReturnParms       RTE system routine   {  UIWriteExcept     Fileio procedure   {}  {   {              Algorithm/Pseudocode   {   
{ Allocate space for head  
 { Allocate space for a block  { Set block count to 1  { Get heap stack info   { While top-of-heap > top-of-stack do   {   .Save current block in previous block   
{   .Increment block count 
 {   .Allocate space for a block    {   .If the previous block does not point to current block then    {      .Call ErrorProc  {      .Exit with error number in return parameter  {   .Get heap stack info  { End while   {}  $PAGE$      CONST   $    { Amount of heap/stack slack to keep is calculated for the worst  }  $ $    {   case trace file where all messages are socket/sequence number }  $ $    {   hints, each with the maximum of 8 sequence numbers; MSG_LEN   }  $ $    {   is in bytes so word count must be computed.                   }  $    BLOCKSIZE = MSG_PER_BLOCK * (MSG_LEN DIV 2);      FMT_WDLEN = 4 * 8;       VAR   !   current_block : BlkPtr;    { Block currently being allocated }  !    previous : BlkPtr;         { Block previously allocated }  
   fmtspace : Int16; 
 $   space : Info_rec;       { Information on heap/stack status is here }  $     	BEGIN { InitVma }  	 WITH VMA_info DO     BEGIN     New (head);    { Allocate space for this one first }      New (current_block);       
   num_blocks := 1;  
 '   fmtspace := MSG_PER_BLOCK * FMT_WDLEN * 2; { Reserve 2 for the formatter }  '     #{ Fill vma space with the data structure.  Check after each allocation #  { to be sure that the pointer written into VMA as a link to the    !{ next block (previous^.next_block) agrees with the pointer to the ! #{ block we have just allocated (current_block).  If they don't, abort  # { the program.  {}     GetHeapStackInfo (space);     WHILE space.toh - space.tos > (BLOCKSIZE + fmtspace) DO        BEGIN         previous := current_block;  %      num_blocks := num_blocks + 1;   { Keep track of how many allocated } % 
      New (current_block); 
           IF previous^.next_block <> current_block THEN            BEGIN           AddMsgHeader (BAD_BLOCK_POINTER, msg_buf, TRUE);            msg_buf2 := parms.raw_file_name;            AddMsgText (msg_buf, msg_buf2, TRUE);           UIWriteExcept (msg_buf);   %         prams[1] := BAD_BLOCK_POINTER;   { Bow out of the program here }  % 
         HALT (prams[1]);  
          END;             GetHeapStackInfo (space);   %               { Increase the reserved space for each block initialized }  %       fmtspace := fmtspace + (MSG_PER_BLOCK * FMT_WDLEN);   
      END;  {while}  
    END;  {with VMA_Info}  END;  {InitVma}           $ SUBTITLE 'OpenFiles', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                     OpenFiles                                   }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE OpenFiles  
    (VAR parms : ParmsType);   {}  { Discussion  {  The raw file parameter references a VMA file that NETRC has  {  used to write raw trace messages.  The raw trace file is    {  checked for correct size (to match the formatter) and opened.   {  The format filename references a user specified file or LU,  {  or a default filename.  The format file may be overwritten   {  only if the user replies 'yes' to a query.  Otherwise the  {  format file must not exist and will be created.  Any error    {  causes routines to be called to print a message with the fmp    "{  or vm error number.  The program will call ReturnParms and exit.  " {}  { Parameters  {  parms  INPUT    Holds the user's choices (or defaults) for    {                    LogLU, raw trace file, and formatted output   {}  { Global used   {  dcb  {}  { Called by   {  Main of FMTRC  {}  { Calls   {  AddErrorCode      FMTRC procedure  {  AddMsgHeader      FMTRC procedure  {  AddMsgText        FMTRC procedure  {  DefaultFormatFile FMTRC function   {  FileInteractive   FMTRC function   {  FMPOpen           RTE library subroutine   {  FMPSize           RTE library subroutine   {  PromptUser        FMTRC function   {  ReturnParms       RTE library procedure  {  StrAppend         Pascal Standard String procedure   {  StrLen            Pascal Standard String function  {  UIWriteExcept     FMTRC procedure  {  UIWriteOutput     FMTRC procedure  {  VmaOpen           RTE library subroutine   {  VmaSt             RTE library subroutine   {}  {   {              Algorithm/Pseudocode   {   { If the user chose to default the raw file (VMA file) then   {   .Supply the default   { Endif    { Open the VMA file with FMPOpen to check the file type; type 2    {   is expected   { Close the file again  "{ If the file type is correct or if there was an error returned then " {   .Make sure VMA file is correct size for this program  {   .If not then  {      .Call error procs  {      .Exit with error number in return parameter  {   .Open VMA file for reading  {   .If there is an error then  {      .Call error procs  {      .Exit with error number in return parameter  !{ Else call error procs and exit with error number in return parm  ! {   { If the user chose to default the format file (FMP file) then  {   .Call function with raw file name to return default   {      format file name   { Open FMP file for output {create only}  { If there is an error then    {   .If no command file was specified then {user is interactive}   {      .Ask the user if OK to overwrite an existing file  	{      .If OK then 	 {         .Open FMP file for output {existing}  !{       Else call error procs and exit with error number in return ! {           parameter   {       Endif    {    Else user is programmatic so call error procs and exit with   {       error number in return parameter  {    Endif  { Endif   {}  $PAGE$      CONST      TYPE_TWO = 2;     DUPLICATE_FILE = -2;       VAR      option_string : OptionType;  	   error : Int16;  	    len : Int16;      file_type : Int16;   
   is_ok : BOOLEAN;  
    size_ok : BOOLEAN;   
   size_in_blocks : Int32; 
    my_version : Int16;     my_size : RECORD CASE Int16 OF                 1 : (sing : ARRAY [1..2] OF Int16);                 2 : (doub : Int32);   	             END;  	     $ SUBTITLE 'CheckVMASize'; PAGE $       PROCEDURE CheckVMASize     (VAR same_size : BOOLEAN);       BEGIN  { CheckVMASize }       %  { If the raw trace file is not the size that FMTRC expects, give the  }  % %  {   user the size of the raw trace and an error message and exit      }  %     error := FmpSize (parms.raw_file_name, size_in_blocks);       %            { My_size represents number of pages and is returned as an  }  % %            {   unsigned single word integer.                           }  % &VmaSt (my_version, my_size.sing[2]); { My_size represents number of pages }  &     &            { Zero is special case representing the max size (65536 pages) } & IF my_size.sing[2] = 0 THEN      my_size.doub := 65536  %ELSE my_size.sing[1] := 0;     { otherwise initialize upper word to zero } %     $            { Size_in _blocks represents number of disc blocks of 128  } $ $            {   words per block; therefore 8 blocks per page (1024).   } $ $            { If there is an error, VMAOpen will catch it.  If size    } $ $            {   is a problem, remember that until after VMAOpen call.  } $  IF (error = 0) AND ((size_in_blocks DIV 8) <> my_size.doub) THEN   
   size_ok := FALSE  
 ELSE size_ok := TRUE;       END;   { CheckVMASize }           $ SUBTITLE 'AddVMASize'; PAGE $       
PROCEDURE AddVMASize 
    (    decint : Int32;       VAR msg_buf : String72);      TYPE     DigitArrayType = ARRAY [0..9] OF CHAR;       CONST      DIGIT_ARRAY = DigitArrayType ['0', '1', '2', '3', '4',                                    '5', '6', '7', '8', '9'];  VAR   	   digit : Int16;  	 	   x     : Int16;  	     BEGIN  { AddVMASize }       #   x := 61;  { index the message string for least significant digit }  #        REPEAT   
   digit := decint MOD 10; 
    decint := decint DIV 10;          msg_buf [x] := DIGIT_ARRAY [digit];  $   x := x - 1;       { index next for the next most significant digit }  $     $   UNTIL (decint = 0) OR ( x < 57);  { maximum of five digits expected } $     
   IF (x > 56) THEN  
       REPEAT  
      msg_buf [x] := ' ';  
       x := x -1;        UNTIL (x < 57);       END;   { AddVMASize }       $ SUBTITLE 'OpenFiles'; PAGE $      
BEGIN  { OpenFiles } 
 WITH parms DO      BEGIN          IF raw_file_name = '' THEN              {default input file}          BEGIN         raw_file_name := RAW_FILE_DEFAULT;        END   '   ELSE BEGIN  { VMA bug currently requires even-length names; bad problems }  ' '               {   have developed when either filename or option string is  }  ' '               {   odd in length.  A fix will be forthcoming. JXL 8-7-85    }  '       len := StrLen (raw_file_name);        IF Odd (len) THEN            StrAppend (raw_file_name,' ');         END;      &{ Check first that this file is actually a type 2 file and then that its  }  & &{   size matches the space allowed by the linked formatter.                } & 
   option_string := 'ROQ'; 
 !   file_type := FmpOpen (dcb, error, raw_file_name, option_string, !                          DCB_BUFFS_CNT);     error := FmpClose (dcb, error);         IF (file_type = TYPE_TWO) OR (file_type < 0) THEN        BEGIN   { file is VMA (type 2) or error opening file }            CheckVMASize (size_ok);       
      IF NOT size_ok THEN  
 $         BEGIN  { trace program wasn't sized the same as the formatter } $          AddMsgHeader (VMA_WRONG_SIZE, msg_buf, TRUE);           AddVMASize (size_in_blocks DIV 8, msg_buf);           msg_buf2 := raw_file_name;            AddMsgText (msg_buf, msg_buf2, TRUE);           UIWriteExcept (msg_buf);   %         prams[1] := VMA_WRONG_SIZE;      { Bow out of the program here }  % 
         HALT (prams[1]);  
 $         END;   { trace program wasn't sized the same as the formatter } $     "                          {must exist; open for reading; extents OK} "       option_string := 'ORWUX ';        VmaOpen (error, raw_file_name, option_string);        IF error <> 0 THEN           BEGIN           AddMsgHeader (VMA_OPEN_ERROR, msg_buf, TRUE);           AddErrorCode (msg_buf, error);            msg_buf2 := raw_file_name;            AddMsgText (msg_buf, msg_buf2, TRUE);           UIWriteExcept (msg_buf);   %         prams[1] := VMA_OPEN_ERROR;      { Bow out of the program here }  % 
         HALT (prams[1]);  
          END;         END      { file is VMA (type 2) or error opening file }       %   ELSE BEGIN  { user specified a file of the wrong type for vma access }  %       AddMsgHeader (VMA_TYPE_ERROR, msg_buf, TRUE);         msg_buf2 := raw_file_name;        AddMsgText (msg_buf, msg_buf2, TRUE);         UIWriteExcept (msg_buf);  #      prams[1] := VMA_TYPE_ERROR;      { Bow out of the program here } #       HALT (prams[1]);  %      END;     { user specified a file of the wrong type for vma access }  %             IF format_file_name = '' THEN           {default output file}         BEGIN         format_file_name := DefaultFormatFile (raw_file_name);        END      ELSE IF format_file_name = raw_file_name THEN  #      BEGIN     { sanity check on command file and runstring inputs }  #       AddMsgHeader (SAME_FILENAME, msg_buf, TRUE);        msg_buf2 := format_file_name;         AddMsgText (msg_buf, msg_buf2, TRUE);         UIWriteExcept (msg_buf);  #      prams[1] := SAME_FILENAME;       { Bow out of the program here } #       HALT (prams[1]);        END;         len := StrLen (format_file_name);  
   IF Odd (len) THEN 
       StrAppend (format_file_name,' ');       "                                    {must create; open for writing}  " 
   option_string := 'CW';  
 #   file_type := FmpOpen (dcb, error, format_file_name, option_string,  #                          DCB_BUFFS_CNT);         IF error = DUPLICATE_FILE THEN      {file already exists}        BEGIN         IF (command_input_name = '') OR            (FileInteractive(command_input_name)) THEN                BEGIN  { interactive user }           msg_buf := ' ';           UIWriteOutput (msg_buf);            msg_buf := MSGS [OVERWRITE_FILE];           msg_buf2 := format_file_name;           AddMsgText (msg_buf, msg_buf2, FALSE);            msg_buf2 := ' [(Y)/N] : ';            AddMsgText (msg_buf, msg_buf2, FALSE);            is_ok := PromptUser (msg_buf);                IF is_ok THEN  #            BEGIN       {file may exist, or create; open for writing}  #             option_string := 'OCW ';               file_type := FmpOpen (dcb, error, format_file_name,                                       option_string, DCB_BUFFS_CNT);               END   
         ELSE BEGIN  
             msg_buf := MSGS [FILE_NOT_OVERWRITTEN];               msg_buf2 := format_file_name;               AddMsgText (msg_buf, msg_buf2, TRUE);               UIWriteExcept (msg_buf);  &            prams[1] := FMP_OPEN_ERROR;      { Bow out of the program here } &             HALT (prams[1]);              END; {is not ok}           END  {if interactive user}       !      ELSE BEGIN  { no way to ask user if overwriting file is ok } !          AddMsgHeader (FILE_NOT_OVERWRITTEN, msg_buf, TRUE);           msg_buf2 := format_file_name;           AddMsgText (msg_buf, msg_buf2, TRUE);           UIWriteExcept (msg_buf);   %         prams[1] := FMP_OPEN_ERROR;      { Bow out of the program here }  % 
         HALT (prams[1]);  
          END;         END  { error = duplicate file }          ELSE BEGIN  { other error? }         IF error < 0 THEN            BEGIN           AddMsgHeader (FMP_OPEN_ERROR, msg_buf, TRUE);           AddErrorCode (msg_buf, error);            msg_buf2 := format_file_name;           AddMsgText (msg_buf, msg_buf2, TRUE);           UIWriteExcept (msg_buf);   %         prams[1] := FMP_OPEN_ERROR;      { Bow out of the program here }  % 
         HALT (prams[1]);  
          END;         END;  { if FMP error }         END; {with}      	END;  {OpenFiles}  	             $SUBTITLE 'PromptUser', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                  PromptUser                                     }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
FUNCTION PromptUser  
 
   (VAR msg_text : STRING) 
     : BOOLEAN;      VAR      input_str : String1;       
BEGIN  {PromptUser}  
     
   input_str := '';  
    UIGetInput (msg_text, input_str);         IF (input_str <> '') THEN  
      Upshift (input_str); 
        IF (input_str = '') OR (input_str = 'Y') THEN        PromptUser := TRUE     ELSE   
      PromptUser := FALSE; 
     	   msg_text := ''; 	     
END;   {PromptUser}  
 $ SUBTITLE 'ReadRunstringParms', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   ReadRunstringParms                            }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE ReadRunstringParms     ( VAR parms : ParmsType);  {}  { Discussion  "{  Obtain the values for Parms One to Four from the runstring.  Open " {  the user's choice or the default error logfile.  {}  { Parameters  "{  parms      OUTPUT  Returns the individual runstring parameters in " "{                     string format.  Parameters not supplied in the " #{                     runstring will be assigned a null string value.  # {}  { Called by   {  Main of FMTRC  {}  { Calls   {  UIOpenExcept     Fileio function   {  Pas_SParms       Pascal Standard string function   {}  {   {              Algorithm/Pseudocode   {   { Initialize all elements of the Parms data structure.  { Read the fifth parameter.   { If the parameter is empty then   {user the default}   {   .Read the first parameter   {   .If Parm One is empty then  {user must be interactive}  {      .Open LU 1 for error logging   {    Else open 'FMTRC.LOG' for error logging  {    Endif  { Else open the file given in Parm Five for logging   { Endif   
{ Read the first parameter 
 { Get the parameter length.   { While parameter length >= 0 and up through Parm Four do   {   .Read the next parameter.   {}  $PAGE$          VAR      parm_length : Int16;      trash_result : Int16;      BEGIN  {ReadRunstringParms}       WITH parms DO      BEGIN  {with}         command_input_name := '';     raw_file_name := '';   
   format_file_name := ''; 
    label_field := '';                                       {Open error log file immediately}      IF (PasSParms (5, error_log) <= 0) THEN        BEGIN  {Get default log file name}            IF (PasSParms (1, command_input_name) > 0) THEN            BEGIN   {User may not be interactive}           error_log := 'FMTRC.LOG';           END        ELSE BEGIN  
         error_log := '1'; 
          END;             END;   {Get default log file name}                 {Open error log file}     trash_result := UIOpenExcept (error_log, trash_result);          "                               {Now read the rest of the runstring}  "    IF (PasSParms (1, command_input_name) >= 0) THEN         IF (PasSParms (2, raw_file_name) >= 0) THEN            IF (PasSParms (3, format_file_name) >= 0) THEN   	            BEGIN  	             parm_length := PasSParms (4, label_field);              END;         END;   {with}      END;  { ReadRunstringParms }      $ SUBTITLE 'ReadVmaHeader', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   ReadVmaHeader                                 }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE ReadVmaHeader      ( VAR VMA_info : VmaInfoType);   {}  { Discussion  !{  Using the pointer obtained in InitVMA, read the expected values ! {  from the head record of the raw trace file.  {}  { Parameters  "{   VMA_info  INPUT/OUTPUT  Pointers, counters, timevalues from the  " {                             VMA file  {}  { Called by   {  Main of FMTRC  {}  { Calls   {  Strread          Pascal Standard string procedure  {}  {   {              Algorithm/Pseudocode   {   { Set the current block index from the head record  { Read from the head record the following values:   {   .Get the total number of records written  {   .Get the total number of blocks used in this VMA file   !{   .Find the oldest record (circular file) by its position in the ! 
{     current block  
 {   .Set the trace start time and trace stop time variables   {}  $PAGE$      VAR      next_pos : Int16;   { String reads }   #   blank : CHAR;       { Dummy space separating 'start_record' from }  # #                       {   'start_time'                             }  #     #{-------------------------------------------------------------------}  # {              MIN a function to find the minimum   #{-------------------------------------------------------------------}  # FUNCTION MIN  	   (    a : Int16; 	         b : Int16) : Int16;       BEGIN       
   IF a <= b THEN min := a 
 
      ELSE min := b; 
     END;          $PAGE$      BEGIN  {ReadVmaHeader}      WITH VMA_info DO     BEGIN      	   next_pos := 1;  	     !   StrRead (head^.info, next_pos, next_pos, total_records, blank,  ! $            num_blocks, blank, start_record, blank, start_time.tstring,  $             stop_time.tstring, node_name);                { determine how many entries there are in the file }  #   record_count := MIN ((num_blocks * MSG_PER_BLOCK), total_records);  #     	   END;  { with }  	     END;   {ReadVmaHeader}          $ SUBTITLE 'ScanVmaForSSNs', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   ScanVmaForSSNs                                }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE ScanVmaForSSNs     (VAR options : OptionsType;      VAR VMA_info : VmaInfoType;       VAR SSNs : SSNsPtr);  {}  { Discussion  {  Test the trace level Option.  If the user has set 'Both' or   {  'Network', then prepare a list of any Socket/Sequence Number    {  pairs for later reference.  Scan the file viewing Z-buffer   {  lengths.  For any trace entry that has a Z-buffer length of  !{  zero, read the contents of the trace entry message.  The first  !  {  value is a Socket, the remaining values for the length of the    {  message are associated Sequence numbers.  Allocate space for    {  each pair and thread the pairs in Sequence number order.   !{  Note:  Trace files may contain only socket/sequence pairs in a  ! !{  very busy system.  For insurance against heap/stack collisions  ! !{  check for ample space before allocating more and quit make the  ! {  linked list whenever space becomes too limited.  {}  { Parameters  "{   options       INPUT   The Option settings, including trace level " !{   VMA_info      INPUT   Pointers, counters, and timevalues from  ! {                           the VMA file  {   SSNs          OUTPUT  Pointer to a linked list of SSNs  {}  { Called by   {  Main of FMTRC  {}  { Calls   {  New                Pascal procedure  {  GetHeapStackInfo   Pascal procedure  {}  {   {              Algorithm/Pseudocode   {   { If the trace level set in options is Network or Both then   {   .Allocate a list element  {   .Initialize this element as a list head   {   .Loop for the number of entries written to the trace file   {      .Read the entry header to obtain the Z-buffer length   {      .If the Z-buffer length is zero then   {         .Initialize pointers to list head    {         .Read the first value of the message for Socket value    {         .Loop for the length of the message - 1   {            .Allocate a list element   {            .Assign the Socket value   !{            .Read the next message value for Sequence number into ! {               the list element  #{            .Search the linked list for the first list element whose  #  {               sequence number is greater than this current one   ${            .Insert the new element in the linked list before the list  $ {               element just found  #{                      { Build a list of increasing sequence numbers } # #{                      { --this should make the sequential search at } # #{                      { format time go more quickly, provided a ptr } # #{                      { is used to 'keep a finger on' the element   } # #{                      { that was found in the previous search.      } # {       Endif   {      .Calculate total lost messages   {      .Increment entry pointers and block pointer if needed  {    End loop   { Endif   {}  $PAGE$      VAR      element : SSNsPtr;      previous_element : SSNsPtr;  	   entry : Int16;  	 
   current_block : BlkPtr; 
    msgline : MsgBuffer;   	   index : Int16;  	    the_socket : Int16;  	   count : Int16;  	    lost_counter : Int16;  
   space : Info_Rec; 
    space_remaining : BOOLEAN;           BEGIN  {ScanVmaForSSNs}       %space_remaining := TRUE;       { there is certainly space for the first }  % %                               {   many allocations of ssns             }  % WITH VMA_info DO     BEGIN      entry := start_record;      { locate first or oldest entry }       current_block := head^.first_block;         New (SSNs);         WITH SSNs^ DO        BEGIN         next_ssn := nil;  	      seq_no := 0; 	 	      socket := 0; 	       END;         previous_element := SSNs;     count := 1;     num_datarecs := 0;      records_lost := 0;   &                    { initialize this for comparison with the next msglost } &    lost_counter := current_block^.message[entry].msglost;          REPEAT         msgline := current_block^.message [entry];      '      IF msgline.zbufferlen = NO_ZBUF THEN    { This is a socket/seqno hint }  '          BEGIN           IF space_remaining THEN  	            BEGIN  	             index := 2;        { First sequence number }              the_socket := msgline.databuffer[1] DIV 2;                  WHILE (msgline.databuffer [index] <> 0) AND                           (index <= MAX_SEQNO_COUNT) AND                          space_remaining DO  
               BEGIN 
                    New (element);                  previous_element^.next_ssn := element;                      WITH element^ DO                     BEGIN                     next_ssn := nil;                    seq_no := msgline.databuffer[index];                    socket := the_socket;                     END;                     previous_element := element;                  index := index + 1;                     GetHeapStackInfo (space);  &                     { allow an extra page and four words for the next ssn } &                IF (space.toh - space.tos < 1024 + 4) THEN                     space_remaining := FALSE;                      END;  { while }                  END;   { if space_remaining }                END    { if no z_buffer }        ELSE BEGIN  '         num_datarecs := num_datarecs + 1; { Side benefit that we can count }  ' '         END;                              {  how many trace entries are    }  ' '                                           {  actual trace data.            }  '     &  { Msglost counter is running, relative counter of dropped messages.     }  & &  { We want the lastmost msglost value -- keep saving it in lost_counter. }  &           IF msgline.msglost > lost_counter THEN  $         BEGIN           { Record lost counter is continual, relative }  $          records_lost := records_lost +                                  (msgline.msglost - lost_counter);             END  !      ELSE IF lost_counter > msgline.msglost THEN    { rollover }  !          BEGIN           records_lost := records_lost +   &                              (32767 - lost_counter) + 1 + msgline.msglost;  &          END;             lost_counter := msgline.msglost;          
      entry := entry + 1;  
 "      IF entry > MSG_PER_BLOCK THEN   { move pointer to next block } "          BEGIN  
         entry := 1; 
          current_block := current_block^.next_block;           END;   { if entry }      
      count := count + 1;  
    UNTIL (count > record_count);      
   END;  { with VMA_info } 
     END;   {ScanVmaForSSNs}                  { FMVIN }  .  