 $PASCAL '91790-1X071 REV.4010 <860227.1053> '   
$STANDARD_LEVEL 'HP1000'$  
 $debug$   $HEAPPARMS OFF$   $RECURSIVE OFF$   $RANGE OFF$   $HEAP 0$  	$HEAP_DISPOSE OFF$ 	     MODULE ifpinit;   	$ALIAS 'N$ifpinit' 	     $TITLE 'MODULE Description',PAGE$   {}  {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  {      NAME:   IFPINIT  
{      SOURCE: 91790-18071 
 
{      RELOC : NONE  
 	{      PGMR  : DGA 	 {}  ${----------------------------------------------------------------------- $ { MODIFICATIONS   {   {    date  Prgmr  Description   !{    860225 lms   Enhanced shutdown/startup error handling (n356). ! ${----------------------------------------------------------------------- $ {}  
{ MODULE DESCRIPTION 
 {   {    This module contains the IFP and IFPM initialization and   {    shutdown routines.   {}  $TITLE 'IMPORT Section',PAGE$       IMPORT         $SEARCH 'phtm/BODEC.rel'$     bodec,      $SEARCH 'phtm/SODEC.rel'$     sodec,      $SEARCH 'phtm/mmdec.rel'$     mmdec,      $SEARCH 'phtm/mmext.rel'$     ds_mm,      $SEARCH 'phtm/IFPDEC.REL'$      ifpdec,     $SEARCH 'phtm/TRCMOD.rel'$      trcmod,     $SEARCH 'phtm/SIGMOD.rel'$      sigmod,     $SEARCH 'phtm/init_dec.rel'$      init_dec,     $SEARCH 'phtm/initmulti.xpt'$     initmulti,      $SEARCH 'phtm/filemad.xpt'$     fileman,      $SEARCH 'phtm/parsdd.xpt'$      parser,     $SEARCH 'phtm/dres.xpt'$      dres,     $SEARCH 'phtm/init_rte_if.xpt'      init_rte_if;       $TITLE 'Export Section',PAGE$       %{------------------------------------------------------------------------} % %{             Export Section                                             } % %{------------------------------------------------------------------------} %     EXPORT      	PROCEDURE InitIFP  	    ( VAR  rtn_err       : Int16 );      	PROCEDURE ShutIfp  	    (      trustvar  : TrustType;       VAR  rtn_err   : Int16 );      PROCEDURE SynIfp     ( VAR  smbsize         : Int16;       VAR  dsamtblsize     : Int16;       VAR  socketcnt       : Int16;       VAR  classcnt        : Int16;       VAR  resourcecnt     : Int16;       VAR  result          : Int16 );          IMPLEMENT       TYPE     OptionType       = ARRAY [1..3] OF Int16;      CONST      NO_OPTS            = OptionType [0,0,0];      CLRQ_FUNC_ALLOC    = -16383;      CLRQ_FUNC_DEALLOC  = -16382;               $TITLE 'Forward Declarations',PAGE$       %{-----------------------------------------------------------------------}  % %{             Forward Declarations                                      }  % %{-----------------------------------------------------------------------}  %     PROCEDURE CLRQ  $ NOABORT $      (     ifunc      : Int16;       VAR iclass     : Int16;           options    : OptionType );        EXTERNAL;      PROCEDURE ABReg          $ALIAS 'ABREG'$     ( VAR a_reg  : Int16;  
     VAR b_reg  : Int16 ); 
      EXTERNAL;      	PROCEDURE GetClass 	    ( VAR class_no    : Int16;        VAR rtn_err     : Int16 );        FORWARD;           $TITLE 'GetClass',PAGE$       &{--------------------------------------------------------------------------} & &{             GetClass                                                     } & &{--------------------------------------------------------------------------} &     	PROCEDURE GetClass 	    { VAR class_no  : Int16;        VAR rtn_err   : Int16 };   {}  { Description   {    This procedure allocates a class number by calling CLRQ.   {       CLRQ OPTIONS  ::=  NO WAIT  {                          NO ABORT   { Parameters  {    class_no   <output>   newly allocated class numbrer  {   {    rtn_err    <output>   clrq error   {}  LABEL      99;      VAR   	   a_reg  : Int16; 	 	   b_reg  : Int16; 	 	   func   : Int16; 	     
BEGIN  { GetClass }  
     func    := CLRQ_FUNC_ALLOC;   class_no := 0;         {Allocate new class number}  CLRQ ( func , class_no , NO_OPTS );   
   BEGIN  { error return } 
 
   ABReg ( a_reg, b_reg ); 
    rtn_err := IFP_CLASS_IO_ERR;      GOTO 99;   
   END;   { error return } 
     rtn_err := 0;       99:;  	END;  { GetClass } 	     $TITLE 'InitIFP',PAGE$          %{------------------------------------------------------------------------} % %{                    InitIFP                                             } % %{------------------------------------------------------------------------} %     	PROCEDURE InitIFP  	    (VAR rtn_err       : Int16 );      {}  { Description   !{    This procedure performs the initialization for the IFP event  !  {    handlers and IFPM process. All that needs to be done is to    {    allocate class numbers for IFPM and IFPIB and create and   {    initialize the IFPM socket.  { Parameters  {    rtn_err          <output>   0    no error  {                                x    error detected  {}      LABEL      99;      CONST   $   BURSTIN      = 1; {reserve as little space as possible; this buffer } $                      { is not used by us. }   &   BURSTOUT     = 7; {reserve space for 7 MA messages in the socket buffer}  & 
   INCC         = 0; 
    OUTCC        = 600;{ Maximum MA message size }       VAR   
   err            : Int16; 
 
   ifp_class_no   : Int16; 
 
   ifpm_class_no  : Int16; 
 
   ifpm_socket_id : Int16; 
 
   ifp_wkmap      : Int16; 
    print_err_flag : BOOLEAN;      PROCEDURE Exit;      BEGIN     GOTO 99;      END;       BEGIN {InitIFP}   rtn_err := GOOD;       { See if the DS/1000 services are configured on this node ; If }   "{ they are not, then set the ifp class number DSAM global         }  " "{ DS_IFP_Class to a special constant to indicate to IFPIB that it }  " "{ it should not try to send messages to GRPM since that process   }  " "{ would not have been scheduled.                                  }  " {}  IF NOT initglobals.IG_1K50_enable THEN     BEGIN     { DS/1000 services are not enabled }      DS_InitEnterCritical( ifp_wkmap, err );  	   IF err = 0 THEN 	       BEGIN    { show no ifp in tables }        ifp_class_no := IFP_NOT_USED;         DS_StoreGlobal( DS_IFP_Class, 1, ifp_class_no );        DS_InitLeaveCritical( ifp_wkmap );  
      ifpm_class_no := 0;  
 #      DS_StoreResElement( NSINIT_AdrOf( Lb_IFPM ), 0, ifpm_class_no ); #       rtn_err := err;         END      { show no ifp in tables }       ELSE         BEGIN    { criticality error }        rtn_err := err;         Exit;         END;     { criticality error }     Exit;     END;       { Allocate class numbers for IFPM and IFPIB }   { and store them in the DSAM globals table  }   { If there is an error in allocating the    }   { class, the class number will be zero and  }   { that will be put in the DSAM global.      }   GetClass( ifpm_class_no, err );   IF err <> 0 THEN     BEGIN     ifpm_class_no := 0;     rtn_err       := err;     END;   { put ifpm's class no in a RES variable for DS/1000 sending}  { processes. ie GRPM et al. }    DS_StoreResElement( NSINIT_AdrOf( Lb_IFPM ), 0, ifpm_class_no );       GetClass( ifp_class_no, err );  IF err <> 0 THEN     BEGIN     ifp_class_no := 0;      rtn_err      := err;      END;   DS_InitEnterCritical( ifp_wkmap, err );   IF err <> 0 THEN     BEGIN  	   rtn_err := err; 	    Exit;     END;   DS_StoreGlobal( DS_IFPM_Class, 1, ifpm_class_no );  DS_StoreGlobal( DS_IFP_Class, 1, ifp_class_no );      { Create a socket for IFPM }  SoInitCreate( BURSTOUT, OUTCC, BURSTIN, INCC, IFPM_SOKIND,  #                                               ifpm_socket_id, err );  # IF err <> 0 THEN     BEGIN     DS_InitLeaveCritical( ifp_wkmap );   	   rtn_err := err; 	    Exit;     END;       { Store its descriptor in DSAM }  DS_StoreGlobal( DS_IFPM_Socket_Id, 1, ifpm_socket_id );   DS_InitLeaveCritical( ifp_wkmap );      { Schedule the IFPM process }   print_err_flag := TRUE;   { schedule ifpm, with no parameters passed to him }   DS_StartMonitor( 'IFPM', 0, print_err_flag, err );  IF err = NOTDORMANT THEN GOTO 99;   IF err <> 0 THEN     BEGIN     { Tell user IFPM is a required monitor }      PrintError( NO_REQ_MONMSG, err );      #   { do not hand the error back to the main, we want to go ahead with  # $      initialization anyway.  The user can always RP IFPM later....   }  $    err := GOOD;      END;       99:;  END; {InitIFP}          $TITLE 'ShutIfp',PAGE$      &{--------------------------------------------------------------------------} & &{             ShutIfp                                                      } & &{--------------------------------------------------------------------------} &     	PROCEDURE ShutIfp  	    (     trustvar: TrustType;        VAR rtn_err  : Int16 );  {}  { Description   {   { Parameters  {}  LABEL      99;      VAR   
   err            : Int16; 
 
   ifp_class_no   : Int16; 
 
   func           : Int16; 
 
   ifp_wkmap      : Int16; 
     	BEGIN { ShutIfp }  	 rtn_err := GOOD;      { Deschedule the IFPM process }   DS_StopMonitor( 'IFPM', err );  	{ ignore errors }  	     DS_RetClass( NSINIT_AdrOf( Lb_IFPM ), 0, err );   	{ ignore errors }  	     IF trustvar = TRUST THEN     BEGIN    { continue shutdown }      { Get globals from DSAM }         DS_InitEnterCritical( ifp_wkmap, err );  
   IF err <> 0 THEN  
       BEGIN       { not critical }        rtn_err := CANT_ENTER_CRIT;         END         { not critical }       ELSE         BEGIN       { are critical }            DS_FetchGlobal( DS_IFP_Class,  1,  ifp_class_no);         DS_InitLeaveCritical( ifp_wkmap  );             { Deallocate class numbers used by IFP }        IF ifp_class_no <> IFP_NOT_USED THEN           BEGIN    { deallocate the class }               func    := CLRQ_FUNC_DEALLOC;           CLRQ ( func , ifp_class_no , NO_OPTS );              BEGIN  { error return }               { ignore errors }               END;   { error return }            END;     { deallocate the class }            END;     { are critical }      END;     { continue shutdown }       99:;  END; { ShutIfp }      $TITLE 'SynIfp',PAGE$       &{--------------------------------------------------------------------------} & &{             SynIfp                                                       } & &{--------------------------------------------------------------------------} &     PROCEDURE SynIfp     ( VAR   smbsize           : Int16;        VAR   dsamtblsize       : Int16;        VAR   socketcnt         : Int16;        VAR   classcnt          : Int16;        VAR   resourcecnt       : Int16;        VAR   result            : Int16 );   {}   { Description: This is the syntax checker for IFP. However, IFP    {              does not require user input so there is nothing  
{              to do 
 {}      BEGIN {SynIfp}  { All output variables are cleared by NSINIT }  result := GOOD;       { Tell nsinit we need 2 class numbers: 1 for IFP, 1 for IFPM }  classcnt := 2;  END;  {SynIfp}      END.  { IFPInit module }         