 $PASCAL ',7 91790-1X088 REV.4010 <860404.0232>'   $ TITLE 'IP Active Path Routines' $   $HEAP 0 $   $HEAPPARMS OFF$   $RECURSIVE OFF$   
$STANDARD_LEVEL 'HP1000'$  
 $DEBUG$   $CODE_INFO ON$  	$CODE_OFFSETS ON$  	 $RANGE OFF$       MODULE ipactp;  	$ALIAS 'N$IPACTP'  	     {}  {-------------------------------------------------------------  {   { (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS  { RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   { REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT  { THE PRIOR WRITTEN CONSENT OF THE HEWLETT PACKARD COMPANY.   {   {-------------------------------------------------------------  {}      {}  
{      NAME: IPACTP  
 {    SOURCE: 91790-18088  	{     RELOC: NONE  	 {      PGMR: CWJ  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   &{  2/1/85   cwj      CopyOptions Fix: Header was not being padded to 32-bit  & {                    boundary correctly after copying options.  {  2/14/85     cwj   Change import searches to @.rels   {  2/21/85     cwj   Add Duplicate Fragment trigger point   {  5/22/85     cwj   Add ICMP message sending   !{  5/30/85     cwj   Bug Fix: Net Unreach generation loops due to  ! {                       link not being updated in loop  {                    Bug Fix: Error return from PrepareNxtFrag  {                       cleared by ICMP code on error.  {                    Bug Fix: TTL not decremented if S&F node   !{  6/3/85      cwj   Send status indications only when a segmented ! {                       message was sent.   !{  6/4/85      cwj   Change REQUEST DPATH handling so that sending ! &{                       may happen with an offered, but not confirmed route  & "{                    Remove ProcessRouteStates as it is not called.  " {  7/3/85      cwj   for cww: Changes for PROBE SREGLIB   "{  6/28/85     cwj   Add S&F timer restart check when S&F msg recvd. " {                    Remove unused KillOldRoute routine   !{  7/1/85      cwj   Change GetAnhRec to set the net segment size  !  {                    Fix loop that occurs when IP must wait for    {                       Confirm Dpath.   {  7/3/85      cwj   Never deallocate the reserved S&F path recs   {  7/8/85      cwj   Send Status Indication only on first frag  {  7/9/85      cwj   Clean up SF inuse count handling   {                    Emsg count correction  {                    S&F Timeout correction   {                    Merge in N050 emsg format changes   {  7/30/85     cwj   Remove LoopBack handling. PROBE will do it    {  7/31/85     cwj   Change the GetAnhRec calling sequence  {  8/2/85      cwj   Convert to LogEvent  {                    IMPORT @.xpt   {                    Range checking off   {                    Enter/Leave critical error handling  {  8/16/85     cwj   Update comments re: global variables   {  8/20/85     cwj   Add Prosw error return logging   {  8/29/85     cwj   Add CantSendData state processing routine  {                    Set ast_CANT_SEND_DATA when have no route  {                    Moved KillPath to IPACTP   {                    Moved ClearReassQue to IPACTP  {                    Moved ClearOutQue to IPACTP  ${                    BuildRoute will always clear the BUILD_ROUTE state  $ {  8/30/85     cwj   Move ClearFragments from IPPCTL  {                    Add UpdatedPr in a few places.   {                    Fix CANT_SEND_DATA processing bug  {  ----- posted -----   {  ----- N145 submittal -----   {  9/3/85      cwj   Changes for Connectionless path handling   {  9/5/85      cwj   Moved ClearOutQue to IPLIB   {  9/11/85     cwj   Kill Path processing & Connectless paths   {                    Misc Emsg count cleanup  {  9/12/85     cwj   Remove DS_IncWd  {  9/13/85     cwj   StartClTimer changes   {                    Use LruLinkageType rather than ClBufrType  "{  9/17/85     cwj   Keep aging the S&F paths even if they will not  " {                       time out  {  ----- N145 submittal -----   {  ----- N152 Submittal -----   {  9/19/85     cwj   Change to CCP - DEBUG for trigger code   {  9/26/85     cwj   Do S&F path checks on KillPath routine   {                    Initialize the error parameters  {  ----- N152 Submittal -----   {  ----- N180 Submittal -----   {  10/24/85    cwj   Clear Reassembly Queue bug fix   {  ----- N180 Submittal -----   {  ----- N185 Submittal -----   {  10/31/85    cwj   RCB List maintainance fixes  {  11/2/85     cwj   Clear Reassembly queue WHILE loop bug  {  ----- N185 Submittal -----   {  ----- N176 Submittal -----   #{  10/9/85     cwj   On KillPath processing, cleanup any outbound msg  # ${                       resources that have been held up for any reason. $ {  ----- N176 Submittal -----   {  ----- N209 Submittal -----   {  11/5/85     cwj   Add Part Number  {  11/6/85     cwj   Add Module Alias   {  11/18/85    cwj   CCP out TRGLB references   {  ----- N209 Submittal -----   {  ----- N247 Submittal -----    {  12/9/85     cwj   CL Path Not deallocated on Time Out Bug Fix   {  ----- N247 Submittal -----   {  ----- N262 Submittal -----   {  12/31/85    cwj   IP sends SIs to IP bug Fix SR# 031716  !{  1/3/85      cwj   On Path/ANH reallocation, rebuild ANH record  ! {                    based on gateway in NGT if necessary.  {                       SR# <unassigned>  {  1/6/86      cwj   RouteSendable correction   {  1/7/85      cwj   BuildRoute, uninitialized variables  {  ----- N262 Submittal -----   {  ----- N286 Submittal -----    {  1/9/86      cwj   IP Should not send Probe OB emsgs in INPRO    {  ----- N286 Submittal -----   {  ----- N302 Submittal -----   {  1/11/86     cwj   Path Maintainance bugs fixed   {  1/14/86     cwj   LLP emsg counts moved to ANH record  {  ----- N302 Submittal -----   {  ----- N323 Submittal -----   {  1/28/86     cwj   KillPath Bug Fix   {  ----- N323 Submittal -----   {  ----- N363 Submittal -----    {  2/27/86     cwj   On reallocation of path, ensure ANH record    {                    gets linked to path record.  {                    SR# 034710   {  ----- N352 Submittal -----   {  3/11/86     cwj   Net Unknown Processing Bug fix.  {                    SR# 034314   {                    Event Message Counting in BuildRoute when  {                    doing rerouting Bug Fix.   {                    SR# 034298   {  ----- N372 Submittal -----   "{  3/25/86     cwj   TTL not being decremented correctly on outbound " {                    S&F traffic.   {                    SR# xxxxxx   {  ----- N395 Submittal -----   "{  4/2/86      cwj   Change Outbound Message Queue from LIFO to FIFO " {                       SR# 035451  {  ----- Nxxx Submittal -----   {  End of Modifications   {------------------------------------------------------------   {}      {}  { MODULE DESCRIPTION:   {   #{  This module contains the active path maintainance routines for IP.  # {   {}  $TITLE 'IMPORT Section',PAGE$       IMPORT                  $SEARCH 'phtm/bodec.xpt'$      bodec,               $SEARCH 'phtm/sodec.xpt'$      sodec,               $SEARCH 'phtm/mmdec.xpt'     mmdec,               $SEARCH 'phtm/mmext.xpt'$      ds_mm,               $SEARCH 'phtm/trcmod.xpt'$     trcmod,              $SEARCH 'phtm/sigmod.xpt'$     sigmod,              $SEARCH 'phtm/tmrdec.xpt'$     tmrdec,              $SEARCH 'phtm/tuser.xpt'$      tuser,               $SEARCH 'phtm/ipdec.xpt'$      ipdec,               $SEARCH 'phtm/ipdb.xpt'$     ipdb,              $SEARCH 'phtm/iplib.xpt'$      iplib;       $TITLE 'EXPORT Section',PAGE$   {------------------------------------------------------------}  {              Export Section                                }  {------------------------------------------------------------}  EXPORT      PROCEDURE DisposeRcbsQue             (VAR rcb      : RcbType;               VAR iphead   : IpHeaderType;              VAR numfrags : Int16);      PROCEDURE IpActOutPath;       PROCEDURE OutIpClTimer;           IMPLEMENT       TYPE     DummyNrvType = ARRAY [1..10] OF Int16;       $TITLE 'Forward Declarations',PAGE$   {------------------------------------------------------------}  {              Forward Declarations                          }  {------------------------------------------------------------}      PROCEDURE BuildRoute;   
            FORWARD; 
     PROCEDURE CantSendData;   
            FORWARD; 
     PROCEDURE ClearFragments             (VAR rcb : RcbType );  
            FORWARD; 
     PROCEDURE ClearReassemblyQue             (    pathref : Int16);   
            FORWARD; 
     PROCEDURE CopyOptions;  
            FORWARD; 
     
PROCEDURE Fetch_Nrv_Router 
            (VAR localadr : Int16;               VAR nrv      : DummyNrvType;              VAR nrvindex : Int16;               VAR result   : Int16 );               EXTERNAL;       FUNCTION  FirstAhState            $ALIAS 'DS_FirstElement'$              (    states : AhStateSetType) : AhAllStatesType;               EXTERNAL;       FUNCTION  FirstPrState            $ALIAS 'DS_FirstElement'$              (    states : PrStateSetType) : PrAllStatesType;               EXTERNAL;       PROCEDURE GetDefaultNgt              (    dest_ipadr : Int32);  
            FORWARD; 
     
PROCEDURE KillPath;  
 
            FORWARD; 
     PROCEDURE PrepareNxtFrag             (VAR mbufid : MbufIdType;              VAR result : Int16 );   
            FORWARD; 
     PROCEDURE ProSw              (VAR emsg   : EventMsgType;              VAR result : Int16);              EXTERNAL;       PROCEDURE RemoveMsgFrmSendQue              (VAR mbufid : MbufidType);   
            FORWARD; 
     FUNCTION  RouteSendable : BOOLEAN;  
            FORWARD; 
     
PROCEDURE SendData;  
 
            FORWARD; 
     PROCEDURE SendQueError             (    error : Int16);   
            FORWARD; 
     	PROCEDURE SplitMsg 	            (VAR mbufid  : MbufIdType;               VAR result  : Int16 );  
            FORWARD; 
     
$TITLE 'Procedures',PAGE$  
 {------------------------------------------------------------}  {              Procedures                                    }  {------------------------------------------------------------}      
$TITLE 'BuildRoute',PAGE$  
 {------------------------------------------------------------}  {              BuildRoute                                    }  {------------------------------------------------------------}      PROCEDURE BuildRoute;       {}  { Description   "{     BuildRoute will be called if there is no acceptable down route " {     recorded for this path record.  {     See "RouteSendable" function for what is unacceptable.  {   {}  { Parameters  {     None  {}  	{ Global Variables 	 {     gv_ip_globals  IN/OUT   List head for ANH free list.  {   "{     gv_path_rec    IN/OUT   The path record to build a route for.  " {   #{     gv_anh_rec        OUT   The ANH record which contains the route. # ${                             This structure may not have been allocated $ {                             or it may need updating.  {   &{     gv_ngt_rec     IN/OUT   This structure is not modifed by this routine  & &{                             but the routing information in it is required  & {                             by this routine.  {}  { Algorithm   {     The given path record may or may not have an NGT entry  %{     associated with it, and it may or may not have a down PID/down Path  % {     in an ANH associated with it.   {     A route is the down PID, down Path pair.  {     The processing for the various cases is:  {   {     HAVE  HAVE  {     NGT   Route          processing   %{     ----+------------+------------------------------------------------+  % #{     Y     Y              Verify the existing route with the NGT info # ${                          Use the existing route until the verification $ {                          comes through.   "{     Y     N              Build a route using the NGT information.  "  {     N     Y              Use the existing route. Verification    ${                          is not possible since IP has no information.  $ "{     N     N              Can't build a new route. Log the fact and " {                          send a KILL_INDICATION to the ULP.   {}     LABEL        99;            { Exit Label }          CONST  "      SUBR = SubrBUILDROUTE;   { Subroutine ID number for logging }  " #         NONGTINDEX = 1;       { Current Pathrec in has no NGT index } # !         ANHFETCH   = 2;       { Fetch of referenced ANH failed }  ! $         NEWANHFAIL = 3;       { Allocation of replacement ANH failed }  $ '         NOROUTEPOSSIBLE = 4;  { Have no down route and no info for building } '            VAR  
      error : Int16; 
 
      dnpid : Int16; 
       dnpath : Int16;   
      llupemscnt : Int32;  
 
      lldnemscnt : Int32;  
               PROCEDURE Exit;            BEGIN { Exit }   	         GOTO 99;  	          END;  { Exit }             PROCEDURE DisasterExit           (    error    : Int16;                 location : Int16);               BEGIN { DisasterExit }            WITH gv_path_rec DO              BEGIN { WITH global path record }   #            IpErrorLog (EL_DISASTER, ips_DESTNET_UNKNOWN, pr_pathref,  #                            SUBR+location);              pr_states := pr_states + [cst_SEND_KILL_UP];              pr_ki_reason := error;              UpdatedPr;              StatesLink;   	            Exit;  	             END;  { WITH global path record }            END;  { DisasterExit }          BEGIN { BuildRoute }      WITH gv_ip_globals, gv_path_rec, gv_anh_rec, gv_ngt_rec DO             BEGIN { WITH Global Variables }         { Clear some local variables        {}  	      dnpid := 0;  	 	      dnpath := 0; 	       llupemscnt := 0;        lldnemscnt := 0;            { Always clear the BUILD_ROUTE state        {}        pr_states := pr_states - [ast_BUILD_ROUTE];         UpdatedPr;            {}        { Get the NGT routing information if it exists.         {}        IF pr_ngt_idx <> NO_INDEX THEN           BEGIN { IF have ngt index in path record }            FetchNgtRec (pr_ngt_idx, pr_remote);            END   { IF have ngt index in path record }          ELSE            BEGIN { ELSE have ngt NO index in path record }           gv_ngt_rec := ngt_INIT_NGT_REC;           END;  { ELSE have ngt NO index in path record }      !      { Ensure that there is an ANH record linked to the path rec  !       {}        IF pr_anh_idx = NO_INDEX THEN            BEGIN { IF need an ANH record }            { Find or build an entry and link it to the path record            { This can only be done if the NGT entry is present.            {}            IF pr_ngt_idx = NO_INDEX THEN                 DisasterExit (ips_DESTNET_UNKNOWN, NONGTINDEX);               GetAnhRec (ngt_anh, ngt_dnpid, ngt_segsize, error);           IF error = ips_GOOD_RETURN THEN              BEGIN { IF have ANH record }              LkPathToAnh;              END   { IF have ANH record }            ELSE              BEGIN { ELSE NO ANH record }              DisasterExit (error, ANHFAIL);              END;  { ELSE NO ANH record }               END   { IF need an ANH record }         ELSE            BEGIN { ELSE already allocated ANH }            FetchAnhRec (pr_anh_idx, error);            IF error <> ips_GOOD_RETURN THEN               BEGIN { IF error fetching ANH }               pr_anh_idx := NO_INDEX;               pr_states := pr_states + [ast_BUILD_ROUTE];               UpdatedPr;              StatesLink;               DisasterExit (error, ANHFETCH);               END;  { IF error fetching ANH }                END;  { ELSE already allocated ANH }             { There is an ANH Record        { Is this the correct ANH by NGT's standards?         {}  "      IF (pr_ngt_idx <> NO_INDEX) AND        { There is an NGT rec } " $         (ngt_anh <> ah_anh     ) THEN       { ANH doesn't match NGT  }  $          BEGIN { IF gateway inconsistency }            { Drop the current ANH record           {}   
         UnLkPathFromAnh;  
          IF ah_pr_link = END_OF_LIST THEN               BEGIN { IF ANH record is unused }               { Clean up orphan ANH record              {}              ah_free_link := ipg_ah_free;              ipg_ah_free  := ah_index;               UpdatedAnh;               UpdatedIpg;                   { Clean up Emsg counts in anh record               { and record the information to Kill this old route.               {}              dnpid := ah_dnpid;              dnpath := ah_dnpath;              llupemscnt := ah_up_emscnt;               lldnemscnt := ah_dn_emscnt;               END;  { IF ANH record is unused }                { Get a new ANH record            {}            GetAnhRec (ngt_anh, ngt_dnpid, ngt_segsize, error);           IF error = ips_GOOD_RETURN THEN              BEGIN { IF have ANH record }              LkPathToAnh;              END   { IF have ANH record }            ELSE              BEGIN { ELSE NO ANH record }              DisasterExit (error, NEWANHFAIL);               END;  { ELSE NO ANH record }               END;  { IF gateway inconsistency }             { Have the best ANH we can find ...         { Is there already a route set up?        {     If so, use it until a better one comes along,         {            and ask for a confirmation.        {}        IF (ah_dnpid <> NO_PID) AND (ah_dnpath <> NO_PATH) THEN            BEGIN { IF already have a route }           { Clear the can't send data block           {     (so we can use the route)           {}            IF NOT (ahst_FLOW_CONTROLLED IN ah_states) THEN              BEGIN { IF ANH is not Flow Controlled }               pr_states := pr_states - [ast_CANT_SEND_DATA];              UpdatedPr;              StatesLink;               END;  { IF ANH is not Flow Controlled }            END   { IF already have a route }             ELSE IF pr_ngt_idx = NO_INDEX THEN       !         BEGIN { IF have no down route and no info to build one }  !          DisasterExit (ips_DESTNET_UNKNOWN, NOROUTEPOSSIBLE);   !         END;  { IF have no down route and no info to build one }  !           { Ask PROBE for a route to the desired ANH.          { This will build a new route, or validate an existing one         {}        RequestDownPath;      
99:   { Error Exit Point } 
           { If an old path must be killed, then do it now.        {}        IF (llupemscnt <> 0) OR            (lldnemscnt <> 0) THEN            BEGIN { IF there are counts to kill }           KillRoute (dnpid, dnpath, llupemscnt, lldnemscnt);            END;  { IF there are counts to kill }            END;  { WITH Global Variables }      END;  { BuildRoute }       $TITLE 'CantSendData',PAGE$   {------------------------------------------------------------}  {           CantSendData                                     }  {------------------------------------------------------------}      PROCEDURE CantSendData;       {}  { Description   {     This routine processes the ast_CANT_SEND_DATA state.  #{     This state indicates that there is data to be sent on this path, # %{     but that there is no route to send it on. And further, it indicates  % !{     that the processing to build the proper route has been done. ! {   "{     The only action done is to remove this message from the active " {     processing queue.   {}  { Parameters  {     none  {}  { Side Effects  {}  { Global Data Structures  #{     gv_ip_globals  IN/OUT   The active processing queue's list head  # {}      BEGIN { CantSendData }  WITH gv_ip_globals DO      BEGIN { WITH Global variables }     UnLinkPathRec (ipg_act_out_pr_que);     END;  { WITH Global variables }  END;  { CantSendData }      $TITLE 'ClearFragments',PAGE$   {------------------------------------------------------------}  {           ClearFragments                                   }  {------------------------------------------------------------}      PROCEDURE ClearFragments             (VAR rcb : RcbType );      {}  { Description   {     This routine will dispose of all the message fragments  {     queued off of the given RCB.  {}  { Parameters   {     rcb      IN       The RCB that is the head of the fragment   {                       chain to be dropped.  {}  { Error Handling  !{     If an error occurs while disposing a message, it is logged.  ! {     Otherwise, errors are ignored.  {}  { Algorithm   {}      CONST       SUBR = SubrCLEARFRAGS;   { Subroutine ID number for logging }       TYPE     ContextType = RECORD CASE Int16 OF         0: (longint : Int32);         1: (int     : Int16);         2: (pathref   : Int16;            rcbmbufid : MbufIdType);        END;  { ContextType }       VAR      link  : MbufIdType;  	   error : Int16;  	    frag  : fragDescType;  
   context : ContextType;  
     BEGIN { ClearFragments }      
link := rcb.rcb_frag.link; 
 &{ On error return, frag will be the EOL frag descriptor, with mbufid = EOL } & GetFrag (link, frag);       WHILE frag.mbufid > 0 DO         BEGIN { WHILE more fragments to drop }      DS_MDispose (frag.mbufid, error);     link := frag.link;      IF error <> ips_GOOD_RETURN THEN             BEGIN { IF Dispose Error }        context.pathref   := rcb.rcb_pathref;         context.rcbmbufid := rcb.rcb_mbufid;        IpErrorLog (EL_ERROR, error, context.int, SUBR);        END;  { IF Dispose Error }         GetFrag (link, frag);     END;  { WHILE more fragments to drop }   END;  { ClearFragments }      $TITLE 'ClearReassemblyQue',PAGE$   {------------------------------------------------------------}  {              ClearReassemblyQue                            }  {------------------------------------------------------------}      PROCEDURE ClearReassemblyQue             (    pathref : Int16);       {}  { Description    {     This routine will dispose of all the fragments associated    #{     with the given path reference from off of the reassembly queue.  # {     It is primarily used before destroying a path record.   {}  { Parameters  #{     pathref  IN    Path Record whose fragments must be cleared out.  # {}  { Global Data Structures  {     gv_ip_globals  IN   {}  { Algorithm    {     The various fragment chains being reassembled for delivery    {     on the path record given, are dropped by searching for the   {     RCBs on the reassembly queue that reference pathref.  {   {     Each Chain is processed to drop all the fragments queued  #{     off of the RCB and then the RCB is unlinked from the reassembly  # {     queue and disposed of.  {}     LABEL        99;   { Error Exit Point }         CONST  "      SUBR = SubrCLEARREASSQ;  { Subroutine ID number for logging }  "        TYPE         ContextType = RECORD CASE Int16 OF           0: (longint : Int32);           1: (int     : Int16);           2: (mbufid  : MbufIdType);            END;  { ContextType }         VAR        rcb   : RcbType;  
      error : Int16; 
       link     : MbufIdType;        backref  : MbufIdType;        numfrags : Int16;         context  : ContextType;       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
        BEGIN { ClearReassemblyQue }      WITH rcb DO        BEGIN { WITH Global Variables }         link    := gv_ip_globals.ipg_reass_que;         backref := GLOBAL_BLK_RCB;        WHILE link <> END_OF_LIST DO               BEGIN { WHILE more on reassembly queue }            GetRcb (link, rcb, error);            IF error <> 0 THEN               BEGIN { IF error on fetch of RCB }              context.mbufid := link;               IpErrorLog (EL_ERROR, error, context.int, SUBR);              RcbUnLink (rcb, backref);   	            Exit;  	             END;  { IF error on fetch of RCB }               IF rcb_pathref = pathref THEN                  BEGIN { IF have an RCB to dispose of }              RcbUnLink (rcb, backref);               DisposeRcbsQue (rcb, gv_ip_head, numfrags);               END;  { IF have an RCB to dispose of }               link    := rcb_link;            backref := rcb_mbufid;            END;  { WHILE more on reassembly queue }             END;  { WITH Global Variables }          99:   { Error Exit Point }      END;  { ClearReassemblyQue }       
$TITLE 'CopyOptions',PAGE$ 
 {------------------------------------------------------------}  {              CopyOptions                                   }  {------------------------------------------------------------}      PROCEDURE CopyOptions;      {}  {  Description  !{     This routine will take the IP header contained in the global ! {     IP header variable, and will convert it into a header   {     suitable for all fragments except the first one.  {   "{     It removes any options that need be transmitted with only the  " {     first fragment.   {}  {  Parameters   {     none;   {}  {  Side Effects   {}  
{  Global Data Structures  
 #{     gv_ip_head  IN/OUT   This contains the options, and is converted # %{                          into a header suitable for the 2..Nth segement. % {}  	{  Error Handling  	 {}  {  Algorithm  {   {}     LABEL        99;   { Exit point for quick returns }         VAR  #      nxt_option    : Int16;  { Byte index of next option to process } # %      len_of_opts   : Int16;  { Byte length of all the options in header } % %      opt_len       : Int16;  { Length of current option being processed } % &      end_of_header : Int16;  { Byte index of last item in rebuilt header }  & '      newheaderend  : Int16;  { Byte index of header padded to 32-bit words }  '       i             : Int16;  { Index variable }      	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
        BEGIN { CopyOptions }     WITH gv_ip_head DO         BEGIN { WITH Global Variables }         nxt_option    := BYTES_IP_HEAD;         Len_of_opts   := (iphd.w1.headlen*4) - BYTES_IP_HEAD;         end_of_header := BYTES_IP_HEAD;             IF Len_of_opts = 0 THEN Exit;             WHILE Len_of_opts > nxt_option DO            BEGIN { WHILE More options to process }               { Get the length of the next option }           CASE iphd_options.options[nxt_option].option OF                  { Single Byte Options }               op_END_OF_OPTIONS,              op_NO_OPERATION    :  
               BEGIN 
                opt_len := 1;  
               END;  
                 { All options with length fields }              OTHERWISE   
               BEGIN 
 "               opt_len := iphd_options.options[nxt_option+1].length; " 
               END;  
 
            END;  { CASE } 
                  IF (iphd_options.options[nxt_option].copy = 1) THEN              BEGIN { IF Must copy option }               IF end_of_header < nxt_option THEN                     BEGIN { IF must move options }                  FOR i := 1 TO opt_len DO                         BEGIN { FOR all bytes in option }                     { Move the option bytes in the header }                     iphd_options.opt_bytes[end_of_header+i] :=  &                                    iphd_options.opt_bytes[nxt_option-1+i];  &                   END;  { FOR all bytes in option }                      END   { IF must move options }       	             ELSE  	                    BEGIN { ELSE option need not be moved }                 { Adjust the indices into the option array }                  end_of_header := end_of_header + opt_len;                 nxt_option    := nxt_option + opt_len;                  END;  { ELSE option need not be moved }                  END   { IF Must copy option }                 ELSE                  BEGIN { ELSE option not copied }              { set nxt_option for next time }              nxt_option := nxt_option + opt_len;               END;  { ELSE option not copied }               END;  { WHILE More options to process }      "      { Pad header with "END_OF_OPTIONS" bytes to a 32 bit boundary  "       {  and reset the header length in the message.        {  and the total message length.        {}        newheaderend := ( (end_of_header + 3) DIV 4) * 4;         FOR i := end_of_header TO newheaderend DO            BEGIN { FOR the pad bytes }           iphd_options.opt_bytes [i] := op_END_OF_OPTIONS;            END;  { FOR the pad bytes }         iphd.len := iphd.len - (iphd.w1.headlen*4 - newheaderend);         iphd.w1.headlen := newheaderend DIV 4;      	      UpdatedIphd; 	       END;  { WITH Global Variables }          99:   { Quick return point for no options }     END;  { CopyOptions }      $TITLE 'DisposeRcbsQue',PAGE$   {------------------------------------------------------------}  {           DisposeRcbsQue                                   }  {------------------------------------------------------------}      PROCEDURE DisposeRcbsQue             (VAR rcb      : RcbType;               VAR iphead   : IpHeaderType;              VAR numfrags : Int16);  {}  { Description   #{     This routine will dispose of all the message fragments appended  # "{     to the rcb passed in, and will then dispose of the rcb itself. " {   "{     The rcb should have been removed from all lists prior to this  " {     routine being called.   {   {     It is typically used in conjunction with the Reassembly   
{     time-out processing  
 {}  { Parameters  "{     rcb   IN/OUT   The Reassembly control block for the partially  " {                    reassembled message to dispose of.   {   {                    It will be garbage on return.  {    {     iphead   OUT   The IP header associated with this message.   #{                    If there was no header, then the fragment offset  # ${                    field will be set non-zero, since this header will  $ #{                    be used for ICMP messages on reassembly time out. # #{     numfrags OUT   The number of fragments disposed by this routine. # {}  { Error Handling   {     If an error is encountered during this disposal operation,    {     it is logged to the event monitor and processing continues   
{     as long as possible. 
 {   !{     No errors are returned to the caller as there is nothing the ! {     caller could do about it anyway.  {   {}  { Algorithm   "{     The fragments queued off of the RCB will be disposed of first, " {     and then the RCB will be disposed of.   {   {}  CONST      SUBR  = subrDISPOSERCB;     { ID for logging errors }  "      FRAGDISPOSE = 1;         { Dispose of a fragment failed     }  " "      RCBDISPOSE  = 2;         { Dispose of the RCB failed        }  "        MAX_FRAG_OFFSET = 8191;     { Max fragment offset }      VAR      frag  : FragDescType;  
   mmflags : MMFlagsType;  
 
   error   : Int16;  
     BEGIN { DisposeRcbsQue }  WITH rcb DO      BEGIN { WITH rcb }      { Initialize the header to return     { to indicate that there is no header returned.     {}      iphead.iphd.fragwd.iphd_off := MAX_FRAG_OFFSET;          { Initialize the number of fragments dropped by this routine.      {}   	   numfrags := 0;  	        { Drop all fragments queued off this RCB      {}      { Fetch first frag descriptor     {}      GetFrag (rcb.rcb_frag.link, frag);      WHILE frag.mbufid > 0  DO        BEGIN { WHILE have more fragments on list }         { Dispose of this fragment        {}        DS_MDispose (frag.mbufid, error);         IF error <> 0 THEN           BEGIN { IF Error on Dispose }  %         IpErrorLog (EL_ERROR, error, rcb.rcb_pathref, SUBR+FRAGDISPOSE);  %          END;  { IF Error on Dispose }            { Set up for the next time around the loop        { and increment the number of fragments dropped         {}        GetFrag (frag.link, frag);        numfrags := numfrags + 1;             END;  { WHILE have more fragments on list }      END;  { WITH rcb }       	{ Dispose the RCB  	 {}  DS_MDispose (rcb.rcb_mbufid, error);  	IF error <> 0 THEN 	    BEGIN { IF Error on Dispose }  !   IpErrorLog (EL_ERROR, error, rcb.rcb_pathref, SUBR+RCBDISPOSE); !    END;  { IF Error on Dispose }      END;  { DisposeRcbsQue }      $TITLE 'GetDefaultNgt',PAGE$  {------------------------------------------------------------}  {              GetDefaultNgt                                 }  {------------------------------------------------------------}      PROCEDURE GetDefaultNgt              (    dest_ipadr : Int32);      {}  {  Description  {     This routine will initialize the global NGT record  {     to the default NGT value. It is called when the NGT has   {     no information about the destination network.   {}  {  Parameters    {     dest_ipadr  IN    An IP address in the destination network   {                       of interest.  {}  
{  Global Data Structures  
 !{     gv_ngt_rec     OUT   This record will be set to the default  ! {                          value.   {}  	{  Error Handling  	 {     none  {}  {  Algorithm  !{     A Constant is declared which contains the basic default, and ! !{     the destination network information is added to the record.  ! {    {     The NGT is not a writable table by the IP protocol modules   {     and so it will never be posted into DSAM.   {}     CONST        DEFAULT_NGT = NgtRecType              [               ngt_dstnet    : 0,              ngt_neighgate : 0,              ngt_dnpid     : 0,              ngt_segsize   : 0,              ngt_hopwd     : ngt_MAX_HOPS,               ngt_index     : NO_INDEX,               ngt_anh       : NO_ANH_NODE,              ];      
   BEGIN { GetDefaultNgt } 
        gv_ngt_rec := DEFAULT_NGT;      gv_ngt_rec.ngt_dstnet := GetNet (dest_ipadr);      
   END;  { GetDefaultNgt } 
     $TITLE 'IpActOutPath',PAGE$   {------------------------------------------------------------}  {              IpActOutPath                                  }  {------------------------------------------------------------}      
   PROCEDURE IpActOutPath; 
     {}  {  Description  {     This routine will handle the processing of the various  {     active states a path record may have set.   {   {     It will process one state each time it is entered.  {     It will process these states in the order they are  {     declared in the PrAllStatesType declaraion.   {}  {  Parameters   {     None  {}  
{  Global Variables  
 {     gv_ip_globals  IN/OUT   {        This record will be set up prior to entry into this  {        routine. It contains the head of the Active Queue  {        that this routine uses to determine which path   {        record to process.   {   {     gv_path_rec    IN/OUT   {        This routine will fetch the appropriate path record  {        and will then process the control states in this   {        record.  {}  	{  Error Handling  	 {     Handled in the Algorithm  {}  {  Algorithm  {     Fetch the path to be processed (its at the head of the  {        Active Path Queue )  {     Get the first state to be processed by this routine.  {   {     Check for the case where no states are set and unlink   	{        the path  	 !{     Check for the various Active States and call the appropriate ! {        routine for each state.  {     Otherwise, a Control state is all that was set, and the   {        path must be queued onto the control queue.  {}     CONST  "      SUBR = SubrIPACTOUTPATH; { Subroutine ID number for logging }  "          BADSTATE = 2;     { error log qualifier }         VAR  
      error : Int16; 
     
   BEGIN { IpActOutPath }  
    WITH gv_ip_globals, gv_path_rec DO         BEGIN { WITH Global Variables }         FetchPathRec (ipg_act_out_pr_que, error);             IF error <> ips_GOOD_RETURN THEN               BEGIN { IF Error on fetch of Path }           { Remove the path from the processing lists }           { (but first ensure there are no bogus states }           { (and ensure that the globals get cleaned up }  
         pr_states := [];  
          pr_active_link := END_OF_LIST;   
         UpdatedPr;  
 
         StatesLink; 
 !         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+PATHFAIL);  !          END   { IF Error on fetch of Path }            ELSE IF pr_states = [] THEN                BEGIN { ELSE IF No states set }           { Remove the path from the lists }   
         StatesLink; 
          END   { ELSE IF No states set }             ELSE                BEGIN { ELSE Some states set }            CASE FirstPrState (pr_states) OF                       ast_BUILD_ROUTE:  
               BEGIN 
 
               BuildRoute; 
 
               END;  
                 ast_CANT_SEND_DATA:   
               BEGIN 
                CantSendData;  
               END;  
     
            ast_SEND_DATA: 
 
               BEGIN 
                SendData;  
               END;  
     
            ast_KILL_PATH: 
 
               BEGIN 
                KillPath;  
               END;  
                 OTHERWISE                  BEGIN { ELSE Don't have an Active State }                 IF (pr_states * CNTL_STATES) <> [] THEN                    BEGIN { IF Have Control State }                     StatesLink;                     END   { IF Have Control State }   
                ELSE 
                   BEGIN { ELSE Unknown State }  #                  IpErrorLog (EL_ERROR, 0, pr_pathref, SUBR+BADSTATE); # #                  pr_states := pr_states - [FirstPrState (pr_states)]; #                   UpdatedPr;                    END;  { ELSE Unknown State }                 END;  { ELSE Don't have an Active State }                  END;  { CASE first_elem }            END;  { ELSE Some states set }         END;  { WITH Global Variables }   
   END;  { IpActOutPath }  
     $TITLE 'KillPath',PAGE$   {------------------------------------------------------------}  {              KillPath                                      }  {------------------------------------------------------------}      
PROCEDURE KillPath;  
     {}  {  Description   {     This routine will kill the path record in the global path    {     record variable IF the ULP emsg counts are 0.   {}  {  Parameters   {     None  {}  
{  Global Variables  
 {     gv_ip_globals  IN/OUT   IP Globals block  {     gv_path_rec    IN/OUT   Path being KILLed   {     gv_anh_rec        OUT   {     gv_send_emsg      OUT   {}  LABEL      99;         { Exit Label }       CONST       SUBR = SubrKILLPATH;     { Subroutine ID number for logging }         FETCHANHFAIL = 1;       VAR   
   error    : Int16; 
 
   anhindex : Int16; 
     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     	BEGIN { KillPath } 	 WITH gv_path_rec, gv_ip_globals, gv_anh_rec, gv_send_emsg DO     BEGIN { WITH Global Variables }         pr_states := pr_states - [ast_KILL_PATH];     UpdatedPr;      StatesLink;         IF ( (pr_ulp_up_emscnt = NO_MSGS) AND          (pr_ulp_dn_emscnt = NO_MSGS)     )         OR             (  pr_path_type = pr_UNREFED_CONNECTLESS  )  THEN             BEGIN { IF path is no longer referenced }         { Clean off any outstanding outbound traffic.         { It is not IP's business to hang on to outbound traffic         { too long. The Send Data had to have failed to get here.          {}  	      ClearOutQue; 	       END   { IF path is no longer referenced }           ELSE            BEGIN { ELSE path is still referenced }         Exit;         END;  { ELSE path is still referenced }          { Does the path need to be deallocated RIGHT NOW?     { 1) Connection paths will get deallocated now      { 2) Connectionless paths must time out      { 3) S&F paths must always have the reserved number allocated      {}      IF (   pr_path_type = pr_REFED_CONNECT             ) OR            (  (pr_path_type = pr_REFED_CONNECTLESS) AND           (ipg_cl_maxidle > 0)                  AND           (pr_cl_idletime >= ipg_cl_maxidle)           ) OR            (  (pr_path_type = pr_UNREFED_CONNECTLESS) AND           (ipg_cl_maxidle > 0)                    AND           (pr_cl_idletime >= ipg_cl_maxidle)      AND           (ipg_clcnt.resvd <  ipg_clcnt.inuse)         ) THEN            BEGIN { IF path is to be deallocated NOW }        { Do nothing here, The deallocate will be done        { below.        {}        END   { IF path is to be deallocated NOW }          ELSE            BEGIN { ELSE path shouldn't be deallocated yet }        { Exit immediately        {}        Exit;         END;  { ELSE path shouldn't be deallocated yet }         { KILL the path NOW     {}      IF pr_anh_idx <> NO_INDEX THEN   	      BEGIN { IF } 	       { Have an ANH Record to clean up        { Fetch it, and on error, ignore it.        { Remove the path from the ANH rec's list         { and erase the path's reference to the ANH rec         {}        FetchAnhRec (pr_anh_idx, error);        IF error <> ips_GOOD_RETURN THEN           BEGIN { IF couldn't get an ANH record }           { This is never supposed to happen.           {}   #         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+FETCHANHFAIL);  #          pr_anh_idx  := NO_INDEX;            pr_anh_link := END_OF_LIST;  
         UpdatedPr;  
          END;  { IF couldn't get an ANH record }  	      END;  { IF } 	        { Record the Route's ANH index locally      {}   
   anhindex := pr_anh_idx; 
        IF pr_anh_idx <> NO_INDEX THEN         BEGIN { IF have an ANH record }         UnLkPathfromAnh;        END;  { IF have an ANH record }          {}      { Clean up the Path Record      {}          { Remove the path from whichever Processing Queue it is on.     {}      UnLinkPathRec (ipg_pr_cntl_que);      UnLinkPathRec (ipg_act_out_pr_que);         { Drop any messages associated with this path record.     {}      ClearReassemblyQue (pr_pathref);           { Remove the path from the Connectionless path list if on it       {}      UnLkClPath;         { Return this path to the head of the free List     { and update the # of paths inuse stat.     {}      pr_free_link := ipg_pr_free;      ipg_pr_free := pr_pathref;   
   WITH ipg_statistics DO  
 
      BEGIN { WITH } 
       ipgs_paths_inuse := DS_DecBt (ipgs_paths_inuse, 1);   
      END;  { WITH } 
    UpdatedPr;      UpdatedIpg;         IF (anhindex <> NO_INDEX) AND        (ah_pr_link = END_OF_LIST) THEN   	      BEGIN { IF } 	       { This Anh record is no longer used by any paths        { so Clean it up.         {         { Put this Anh Rec back onto the head of the free list        {}        ah_free_link := ipg_ah_free;        ipg_ah_free  := ah_index;             UpdatedPr;  	      UpdatedAnh;  	 	      UpdatedIpg;  	           { Kill the old route, and lose context        {}  !      KillRoute (ah_dnpid, ah_dnpath, ah_up_emscnt, ah_dn_emscnt); ! 	      END;  { IF } 	        END;  { WITH Global Variables }      
99:   { Exit Point } 
 	END;  { KillPath } 	     $TITLE 'OutIpCLTimer',PAGE$   {------------------------------------------------------------}  {              OutIpClTimer                                  }  {------------------------------------------------------------}      PROCEDURE OutIpClTimer;       {}  { Description   !{     When the CL timer expires, this routine will process all the ! %{     Connectionless path records, incrementing the idle time counters in  % %{     each record. If any of these counters go to the maximum, those paths % 
{     must be deallocated. 
 {   %{     Following this processing, the Connectionless Timer is reset for the % {     next expiration.  {}  { Parameters  {     none  {}  { Side Effects  {   {}  { Global Data Structures  '{     gv_ip_globals  IN/OUT   IP Global block contains the CL path list head.  ' {     gv_path_rec    IN/OUT   CL path records.  {}  { Algorithm   %{     The CL path record list is traversed, incrementing the idle counter  % %{     in each record. If an idle counter goes to a maximum allowed value,  % ${     this path is deallocated. This maximum is in the IP global block.  $ {   ${     There is also an upper bound on the idle counter and if the count  $ "{     ever reaches this limit, it will remain there and will not be  " 
{     incremented further. 
 {}  CONST       SUBR = SubrOUTIPCLTIMER; { Subroutine ID number for logging }       VAR   
   link    : Int16;  
 
   error   : Int16;  
    lrubufr : LruLinkageType;      BEGIN { OutIpClTimer }  WITH gv_ip_globals, lrubufr, gv_path_rec DO      BEGIN { WITH Global Variables }     { Mark the Connectionless Path timer as having expired      {}      ipg_cl_tmrid.index := ip_TIMER_OFF;         { Fetch the first path index from the global block }      link := ipg_clpath_list;          WHILE link <> END_OF_LIST DO         BEGIN { WHILE Have path on the CL list }        { Fetch the Link and the LRU counter from the path }         DS_FetchFields (DS_IP_Path_Rec_TD, link, lrubufr.lru_bufr,                           pr_CL_OFSET, pr_CL_LEN);            IF lru_count < pr_MAX_CL_IDLETIME THEN           BEGIN { IF Haven't hit the max idle time yet }            { so increment the idle counter           {}            lru_count := lru_count + 1;           { Post the updated idle counts            {}   "         DS_StoreFields (DS_IP_Path_Rec_TD, link, lrubufr.lru_bufr,  "             pr_CL_OFSET, pr_CL_LEN);           END;  { IF Haven't hit the max idle time yet }       #      IF (ipg_cl_maxidle  >  0             ) AND     { Time out = ON } # $         (lru_count       >= ipg_cl_maxidle) THEN    { Path = TOO idle } $              BEGIN { IF This path is too idle }            { Deallocate the path if possible           {}            FetchPathRec (link, error);           IF error = ips_GOOD_RETURN THEN              BEGIN { IF Have Path record }               IF (  (pr_ulp_up_emscnt = 0) AND                    (pr_ulp_dn_emscnt = 0) AND  !                  (pr_path_type = pr_REFED_CONNECTLESS)       ) OR !                    (  (pr_path_type = pr_UNREFED_CONNECTLESS) AND   "                  (ipg_clcnt.inuse > ipg_clcnt.resvd)         ) THEN "                    BEGIN { IF deallocatable }                  { Set it to the KILL_PATH state                 { IF the event message counts are 0                 { And queue it onto the processing queue   	               {}  	                pr_states := pr_states + [ast_KILL_PATH];  
               UpdatedPr;  
 
               StatesLink; 
                END;  { IF deallocatable }                   END   { IF Have Path record }                 ELSE                  BEGIN { ELSE Don't have path record }   "            IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+PATHFAIL); "             END;  { ELSE Don't have path record }                END;  { IF This path is too idle }             { Update the link for the next time }         link := lru_index;            END;  { WHILE Have path on the Connectionless list }         { Starts CL timer if something on the ipg_clpath_list     {}      StartClTimer;         END;  { WITH Global Variables }  END;  { OutIpClTimer }      $TITLE 'PrepareNxtFrag',PAGE$   {------------------------------------------------------------}  {              PrepareNxtFrag                                }  {------------------------------------------------------------}      PROCEDURE PrepareNxtFrag             (VAR mbufid : MbufIdType;              VAR result : Int16 );   {}  { Description   #{     This routine prepares the next fragment for sending and returns  # {     the mbufid to the caller.   {    {     It gets the message from the Outbound Message queue in the   "{     current path record, builds the next fragment, and leaves the  " !{     remainder of the message, ready to send, linked through the  ! {     checksum word of the IP header.   {   #{     NOTE: This routine will partially prepare any fragment it leaves # #{     queued on the path record. This means that an IP header will be  # {     built and filled out for it.  {}  { Parameters  ${     mbufid   OUT      On return from this routine, this is the mbufid  $ {                       of the message to be sent to the LLP.   {}  { Side Effects  "{     Message fragments queued on the Outbound message queue may be  " {     further fragmented or removed from the queue.   {}  { Global Data Structures  {     gv_ip_head  IN/OUT   Storage for IP header.   {   %{     gv_path_rec IN/OUT   The path record which contains the head of the  % {                          outbound message queue.  {     gv_anh_rec     OUT  {     gv_ip_globals  IN/OUT   
{     gv_icmp_msg      OUT 
 {}  { Error Handling   {     If an error is detected in any portion of the preparation,   "{     the message that was at the head of the Outbound message queue " {     will be dropped and an error code will be returned.   {}  { Algorithm   {}     LABEL        99;      { Exit Label }          CONST  "      SUBR = SubrPREPARENXTFR; { Subroutine ID number for logging }  " 
      FRAGFAIL = 1;  
        VAR        error     : Int16;        icmperror : Int16;            PROCEDURE Exit;            BEGIN { Exit }   	         GOTO 99;  	          END;  { Exit }          BEGIN { PrepareNxtFrag }      WITH gv_path_rec, gv_ip_head, gv_anh_rec,          gv_ip_globals.ipg_statistics DO         BEGIN { WITH Global Variables }   	      error := 0;  	     #      { Fetch the IP message at the head of the outbound message queue #       {}        FetchIpHead (pr_out_que, error);        IF error <> ips_GOOD_RETURN THEN               BEGIN { IF IP Header could not be fetched }           SendQueError (error);           Exit;           END;  { IF IP Header could not be fetched }            { Have IP Header        { Fetch the Down Path inforamation (esp segment size)         {}        FetchAnhRec (pr_anh_idx, error);        IF error <> ips_GOOD_RETURN THEN           BEGIN { IF DON'T have ANH record }            { Bad ANH reference in path record            { Clear the bad reference and try again           {}            error := ips_BAD_ROUTE;            IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+ANHFAIL);                pr_anh_idx := NO_INDEX;           pr_states := pr_states + [ast_BUILD_ROUTE];  
         StatesLink; 
 
         UpdatedPr;  
          Exit;           END;  { IF DON'T have ANH record }             { Have ANH record         { Process the message based on the LLP's segment size         {}        IF (iphd.len <= ah_segsize) OR           (ah_segsize = 0)         THEN               BEGIN { IF fragmentation is NOT needed }            RemoveMsgFrmSendQue (mbufid);           END   { IF fragmentation is NOT needed }             ELSE IF iphd.fragwd.iphd_df = 1 THEN           BEGIN { ELSE IF frag required, but not allowed }            error := ips_FRAG_NOT_ALLOWED;   $         ipgs_oversize_packloss := DS_IncBt (ipgs_oversize_packloss,1);  $ 
         UpdatedIpg; 
          SendQueError (error);  !         { Send a Dest Unreachable ICMP message back to the source !          {}            GetPathRec (iphd.src, NO_LOCAL, NO_PROTO, icmperror);           IF icmperror = ips_GOOD_RETURN THEN              BEGIN { IF have proper path }               WITH gv_icmp_msg DO                  BEGIN { WITH }                  icmp_tc.msgtype := DEST_UNREACH;                  icmp_tc.msgcode := FRAG_NEEDED_DF_SET;                  icmp_cksum      := 0;                 dstunreach      := 0; { unused field }                  END;  { WITH }               RtnIcmpMsg (gv_icmp_msg, icmperror);              IF icmperror <> ips_GOOD_RETURN THEN                 BEGIN { IF error on send }   &               IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+ICMPSENDFAIL);  &                END;  { IF error on send }               END   { IF have proper path }            ELSE               BEGIN { ELSE could'nt get path }  !            IpErrorLog (EL_RESOURCELIM, error, 0, SUBR+PATHFAIL);  !             END;  { ELSE could'nt get path }           Exit;           END   { ELSE IF frag required, but not allowed }             ELSE           BEGIN { ELSE Fragmentation is needed and allowed }   !         { Attempt to split off the first portion of the message.  !          {}            SplitMsg (mbufid, error);           IF error <> ips_GOOD_RETURN THEN                   BEGIN { IF fragmentation failed }               error  := ips_FRAG_FAILED;  %            ipgs_oversize_packloss := DS_IncBt (ipgs_oversize_packloss,1); %             UpdatedIpg;               SendQueError (error);   	            Exit;  	             END;  { IF fragmentation failed }                { Fragmentation of message was required.            { Try to get the ULP to do it the next time.   &         { But not if this is an S&F path (since there is no ULP to do it).  &          {}            IF (iphd.fragwd.iphd_off = 0) AND              (pr_local <> NO_LOCAL    ) THEN               BEGIN { IF first fragment }               pr_states := pr_states + [cst_SEND_FRAG_STATUS];              UpdatedPr;              StatesLink;               END;  { IF first fragment }                END;  { ELSE Fragmentation is needed and allowed }              { Set the Hop count and the checksum in the first fragment         { and return the mbufid of it to the caller.        {}        IF pr_local = NO_LOCAL THEN            BEGIN { IF Store and Forward Path }           iphd.w5.iphd_ttl := DS_DecBt (iphd.w5.iphd_ttl, 1);           END   { IF Store and Forward Path }         ELSE            BEGIN { ELSE Terminal path }            iphd.w5.iphd_ttl := pr_ttlwd.ttl;           END;  { ELSE Terminal path }   
      iphd.sum := 0; 
       iphd.sum := ChecksumHeader;       	      UpdatedIphd; 	       SaveHeaderState;        END;  { WITH Global Variables }       
   99:      { Exit Point } 
 
   result := error;  
    END;  { PrepareNxtFrag }       $TITLE 'RemoveMsgFrmSendQue',PAGE$  {------------------------------------------------------------}  {              RemoveMsgFrmSendQue                           }  {------------------------------------------------------------}      PROCEDURE RemoveMsgFrmSendQue              (VAR mbufid : MbufidType);       {}  { Description   !{     This routine will remove the first message from the outbound ! {     message queue of the current path record.   {    {     The mbufid for the message will be returned to the caller.   {   #{     This routine will also check to see if this was the last message # ${     on the send queue, and if so, it will set the tail pointer to EOL  $ #{     and clear the ast_SEND_DATA state from the path state fields in  # {     the path record.  {}  { Parameters  "{     mbufid      OUT   The mbuf pointer to the message just removed " {                       from the outbound message queue.  {}  { Side Effects  {}  { Global Data Structures  {     gv_path_rec    IN/OUT   {     gv_ip_head     IN/OUT   {}  { Error Handling  {}  { Algorithm   {}         BEGIN { RemoveMsgFrmSendQue }     WITH gv_path_rec, gv_ip_head DO        BEGIN { WITH Global Variables }         { Unlink the message from the head of the queue }         mbufid := pr_out_que;         IF pr_out_tail = pr_out_que THEN           BEGIN           pr_out_tail := END_OF_LIST;           pr_out_que := END_OF_LIST;                { No messages on queue }   "         { Clear the SEND_DATA state as there is not data to send }  "          pr_states := pr_states - [ast_SEND_DATA];  
         StatesLink; 
          END         ELSE            pr_out_que := iphd.sum;            UpdatedPr;        END;  { WITH Global Variables }      END;  { RemoveMsgFrmSendQue }      $TITLE 'RouteSendable',PAGE$  {------------------------------------------------------------}  {              RouteSendable                                 }  {------------------------------------------------------------}      FUNCTION  RouteSendable : BOOLEAN;      {}  { Description   {     This routine will check to see if the existing route is    {     sendable or not, if it is, it will return TRUE, otherwise    {     it will return FALSE.   {}  { Parameters   {     RouteSendable  OUT   TRUE if there is a valid route built    {                          FALSE otherwise.   {}  { Side Effects   {     If the route is sendable, then the ANH record will be the    {     appropriate one to send the message on.   {}  { Global Data Structures  #{     gv_path_rec    IN       The path whose route is to be verified.  # {    {     gv_anh_rec     OUT      This structure will be initialized   ${                             following this routine if there is a valid $ {                             route.   {     gv_ngt_rec     OUT      This structure will be initialized   {                             by this routine.  {}  { Algorithm   ${     This routine checks all the conditions that would cause a route to $ {     not be sendable and returns FALSE if any are set.   {     If the route is sendable this TRUE is returned.   {}     VAR  
      error : Int16; 
     
   BEGIN { RouteSendable } 
    WITH gv_path_rec, gv_anh_rec, gv_ngt_rec DO        BEGIN { WITH Global Variables }   $      IF (pr_anh_idx <> NO_INDEX) THEN FetchAnhRec (pr_anh_idx, error);  $ 
      ngt_anh := 0;  
 &      IF (pr_ngt_idx <> NO_INDEX) THEN FetchNgtRec (pr_ngt_idx, pr_remote);  &           RouteSendable := NOT (  "         {no anh record }     (pr_anh_idx = NO_INDEX)             OR " "         {no anh record }     (error <> ips_GOOD_RETURN)          OR " "         {flow controlled }   (ahst_FLOW_CONTROLLED IN ah_states) OR " "         {no down route }     (ah_dnpid = NO_PID)                 OR " "         {no down route }     (ah_dnpath = NO_PATH)               OR "              {have ngt and     }  (  (pr_ngt_idx <> NO_INDEX)  AND            {using wrong gate }     (ngt_anh <> ah_anh)           )                              );         END;  { WITH Global Variables }   
   END;  { RouteSendable } 
     $TITLE 'SendData',PAGE$   {------------------------------------------------------------}  {              SendData                                      }  {------------------------------------------------------------}      
PROCEDURE SendData;  
     {}  { Description   {     SendData will process paths in the pr_SEND_DATA state.  {}  { Parameters  {     none  {}  { Global Data Structures  #{     gv_path_rec    IN/OUT   The message at the head of the Outbound  # %{                             message queue will be processed with respect % {                             to this path record.  {     gv_ip_head        OUT   {     gv_icmp_msg       OUT   {     gv_ip_globals  IN/OUT   {     gv_anh_rec        OUT   {     gv_send_emsg      OUT   {     gv_wkmp        IN/OUT   {}  { Error Handling  {     none  {}  { Algorithm   {     If the route is not sendable, it will set the state to  "{     ast_BUILD_ROUTE and queue the path onto the Active Path Queue  " {     for processing.   {   !{     If the route is sendable, It will prepare the next fragment, ! "{     build the event message and call the next protocol via ProSw.  " {}     LABEL        99;      { Exit Label }          CONST  "      SUBR = SubrSENDDATA;     { Subroutine ID number for logging }  " #         HEADFAIL = 1;         { Could not fetch necessary IP header } #     
      NO_MBUFID = 0; 
 
      NO_FLAGS  = 0; 
       WD32_TO_WD16 = 2;          VAR  
      mbufid : MbufIdType; 
       error  : Int16;             PROCEDURE Exit;            BEGIN { Exit }   	         GOTO 99;  	          END;  { Exit }             PROCEDURE NotifyAnySourceNodes                   (    link : MbufIdType);            BEGIN { NotifyAnySourceNodes }            WITH gv_ip_head DO               BEGIN { WITH ip head }              WHILE link <> END_OF_LIST DO                 BEGIN { WHILE more on list }                  FetchIpHead (link, error);                  link := iphd.sum;  { Set link for next entry }                  IF (error = ips_GOOD_RETURN) AND                     (iphd.w5.iphd_proto <> ICMP_PROTO_NUM) THEN                     BEGIN { IF have header and non ICMP msg }       "                  GetPathRec (iphd.src, NO_LOCAL, NO_PROTO, error);  "                   IF error = ips_GOOD_RETURN THEN                        BEGIN { IF have proper path }                       WITH gv_icmp_msg DO                          BEGIN { WITH }                          icmp_tc.msgtype := DEST_UNREACH;                          icmp_tc.msgcode := NETWORK_UNREACH;                           icmp_cksum      := 0;                           dstunreach      := 0; { unused field }                          END;  { WITH }                       RtnIcmpMsg (gv_icmp_msg, error);                        IF error <> ips_GOOD_RETURN THEN                            BEGIN { IF error on returning ICMP msg }   &                        IpErrorLog (EL_ERROR, error, gv_path_rec.pr_pathref, & $                                                    SUBR+ICMPSENDFAIL);  $                          END;  { IF error on returning ICMP msg }                        END   { IF have proper path }                    ELSE                       BEGIN { ELSE couldn't get path }   %                     IpErrorLog (EL_RESOURCELIM, error, 0, SUBR+PATHFAIL); %                      END;  { ELSE couldn't get path }                     END   { IF have header }                      ELSE IF error <> ips_GOOD_RETURN THEN                         BEGIN { IF couldn't get header }                    WITH gv_path_rec DO   '                     IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+HEADFAIL);  '                   link := END_OF_LIST;                    END;  { IF couldn't get header }                     END;  { WHILE more on list }   
            END;  { WITH } 
          END;  { NotifyAnySourceNodes }          BEGIN { SendData }      WITH gv_ip_globals, gv_path_rec,           gv_anh_rec, gv_send_emsg, gv_ip_head  DO            BEGIN { WITH Global Variables }         IF NOT RouteSendable THEN                BEGIN { IF not a sendable route }  !         { A Route for this message must be built before it can be !          { sent.           {}            IF pr_ngt_idx = NO_INDEX THEN              BEGIN { IF no information to build a route }              pr_states := pr_states + [cst_SEND_KILL_UP];              pr_ki_reason := ips_DESTNET_UNKNOWN;              UpdatedPr;              StatesLink;               NotifyAnySourceNodes (pr_out_que);  	            Exit;  	             END;  { IF no information to build a route }           pr_states := pr_states + [ast_BUILD_ROUTE]                                   + [ast_CANT_SEND_DATA];   
         UpdatedPr;  
 
         StatesLink; 
          Exit;           END;  { IF not a sendable route }            { The Route is acceptable, send the next fragment         {         { Build the message to send and remove it from the        { Outbound Message queue.         {         { PrepareNxtFrag also leaves the header in the local  #      { buffer for read access and fetches the appropriate ANH record; #       {}        PrepareNxtFrag (mbufid, error);         IF error <> ips_GOOD_RETURN THEN           BEGIN { IF Fragment prep failed }           { mbuf cleaned up by fragment routine           { Log the event and get out.            {}            IpErrorLog (EL_ERROR, error, pr_pathref, SUBR);           Exit;           END;  { IF Fragment prep failed }            {}        { Have the next fragment        {}  
      { Count this send }  
       WITH ipg_statistics DO           BEGIN { WITH statistics }           IF pr_local = NO_LOCAL THEN            BEGIN             { Store and Forward packet }  !          ipgs_transit_packs_sent := ipgs_transit_packs_sent + 1;  !           END                ELSE                 BEGIN             { Packet sourced at local node }            ipgs_src_packs_sent := ipgs_src_packs_sent + 1;             END;  
         UpdatedIpg; 
          END;  { WITH statistics }            { Build the event message         {}        WITH pr_statistics DO            st_sendrq_dn  := st_sendrq_dn + 1;             { Count this outbound eventmessage        {}        ah_dn_emscnt := ah_dn_emscnt + 1;   	      UpdatedAnh;  	           em_event := SEND_REQUEST;         ehport   := BuildPort (ah_dnpid, EHOB_OFFSET);            emsr_down_ref   := ah_dnpath;         emsr_mbufid     := mbufid;        emsr_dlen       := iphd.len;        emsr_flags.int  := NO_FLAGS;        emsr_opt_mbufid := NO_MBUFID;         emsr_killsnd_cnt := 0;        emsr_killrcv_cnt := 0;            SaveState;        IF gv_gocrit_error = 0 THEN DS_LeaveCritical (gv_wkmap);        ProSw (gv_send_emsg, error);  	      ContextLost; 	           DS_EnterCritical (gv_wkmap, gv_gocrit_error);         { Post the Prosw error return if any, before proceeding         { Then save the EnterCritical error         {}  %      IF error <> 0 THEN IpErrorLog (EL_ERROR, error, 0, SUBR+PROSWFAIL);  %       error := gv_gocrit_error;             IF error <> ips_GOOD_RETURN THEN           BEGIN           { EnterCritical Error Checking            {}            IpErrorLog (EL_DISASTER, error, 0, SUBR+GOCRITFAIL);            END;       
      FetchGlobals;  
           END;  { WITH Global Variables }          99:   { Exit Point }      END;  { SendData }       $TITLE 'SendQueError',PAGE$   {------------------------------------------------------------}  {              SendQueError                                  }  {------------------------------------------------------------}      PROCEDURE SendQueError             (    error : Int16);   {}  { Description   !{     This routine is called when there is an error in processing  ! {     messages at the head of the Outbound Message queue.   {   !{     It will remove the message from the queue, drop the message  ! {     and log the error passed in to the event logger.  {}  { Parameters  {     error    IN    The error to log.  {}  { Global Data Structures  
{     gv_ip_head  IN 
 {     gv_path_rec IN    Path reference logged on error  {}  { Error Handling  {}  { Algorithm   {}     CONST  "      SUBR = SubrSENDQUEERROR; { Subroutine ID number for logging }  "        VAR  
      mbufid : MbufIdType; 
     
   BEGIN { SendQueError }  
    RemoveMsgFrmSendQue (mbufid);     DropMessage (mbufid);     WITH gv_path_rec DO        IpErrorLog (EL_ERROR, error, pr_pathref, SUBR);   %   IpBufrLog (IPL_HEADLOG, SUBR, gv_ip_head.iphd_words[1], BYTES_IP_HEAD); % 
   END;  { SendQueError }  
     $TITLE 'SplitMsg',PAGE$   {------------------------------------------------------------}  {              SplitMsg                                      }  {------------------------------------------------------------}      	PROCEDURE SplitMsg 	            (VAR mbufid  : MbufIdType;               VAR result  : Int16 );  {}  { Description    {     This routine is called when the message at the head of the    {     outbound message queue in the current path record needs to   
{     be fragmented. 
 {   "{     This routine splits the message into two fragments, returning  " !{     the mbufid of the first fragment to the caller, and queuing  ! "{     the second fragment at the head of the outbound message queue. " {   !{     If the routine encounters any errors, it will drop the first ! #{     fragment and leave the second fragment queued on the Path Rec's  # {     outbound message queue for the caller to dispose of.  {}  { Parameters  {     mbufid      OUT   The mbufid of the first message   {     result      OUT   The status of the operation:  {        ips_GOOD_RETURN   -  The fragmentation was successful  !{        ips_FRAG_FAILED   -  The fragmentation was NOT successful ! ${        other             -  The fragmentation was not successful, and  $ {                             a further reason is given.  {}  { Side Effects  "{     Message fragments queued on the Outbound message queue may be  " {     further fragmented or removed from the queue.   {}  { Global Data Structures  "{     This routine assumes that the following variables are set up:  " {   {     gv_ip_head  IN/OUT   Storage for IP header.   {   %{     gv_path_rec IN/OUT   The path record which contains the head of the  % {                          outbound message queue.  {   &{     gv_anh_rec  IN/OUT   The Anh record containing the route, this message & {                          is to take.  {}  { Error Handling  {     xxxx  {}  { Algorithm   {     To be filled in   {}     LABEL        99;            { Exit Label }          CONST  "      SUBR = SubrSPLITMSG;     { Subroutine ID number for logging }  "       APENDHDFAIL = 1;     { Error Logging qualifiers }         SPLITFAIL   = 2;     {          "               }         FRAGHDFAIL  = 3;     {          "               }             MORE_FRAGS = 1;          VAR  
      error : Int16; 
 #      fragblocks : Int16;  { Number of 8-byte chunks of data to send } # "      frag1len   : Int16;  { Length of fragment 1 including header } " "      frag2len   : Int16;  { Length of fragment 2 including header } "       frag1mbuf  : MbufIdType; { mbufid for first fragment }        frag2mbuf  : MbufIdType; { mbufid for second fragment }             PROCEDURE Exit;            BEGIN { Exit }   	         GOTO 99;  	          END;  { Exit }          BEGIN { SplitMsg }      WITH gv_path_rec, gv_ip_head, gv_anh_rec DO        BEGIN { WITH Global Variables }   	      error := 0;  	           fragblocks := (ah_segsize - (iphd.w1.headlen*4) ) DIV 8;        frag1len   := (iphd.w1.headlen*4) + (fragblocks*8);         frag2mbuf  := pr_out_que;             DS_MSplit (frag2mbuf, frag1len, 0, frag1mbuf, error);         IF error <> ips_GOOD_RETURN THEN           BEGIN { ELSE message was NOT fragmented }  !         { An unexpected error occured on the split message call } ! !         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+SPLITFAIL); !          mbufid := NO_MBUFID;            Exit;           END;  { ELSE message was NOT fragmented }            { Process the tail fragment first         { To prepare it for the sending next time         { Set the message length field, and the fragment offset.        { (the header length is already set from fragment #1)         {}        frag2len := iphd.len - frag1len;        iphd.len := frag2len + (iphd.w1.headlen*4);          iphd.fragwd.iphd_off := iphd.fragwd.iphd_off + fragblocks;             { Copy the options for the 2..Nth headers and update the        { length fields as necessary.         {}  	      CopyOptions; 	           { Append this header to the second fragment in DSAM.        {}        DS_MAppendHead (gv_ip_head.iphd_bufr,                         iphd.w1.headlen*4,                        frag2mbuf,                        error);              { Ensure that any new mbufid is recorded with the header }         iphd_mbufid := frag2mbuf;             IF error <> ips_GOOD_RETURN THEN           BEGIN { IF Header NOT appended to frag2 }           DropMessage (frag2mbuf);   "         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+APENDHDFAIL); "          mbufid := NO_MBUFID;            Exit;           END;  { IF Header NOT appended to frag2 }            {}        { Frag2 has a header appended to it         {}        iphd_rec_status := VALID_DATA;            { Unlink frag1 from the Outbound message queue and  }         { Link frag2 in at this point.                      }         { NOTE that the linkage in frag2 is the same as the }         { old frag1 linkage.                                }         {}  !      IF pr_out_tail = pr_out_que THEN pr_out_tail := iphd_mbufid; !       pr_out_que := iphd_mbufid;        UpdatedPr;            { Build the first fragment }        {}        FetchIpHead (frag1mbuf, error);         IF error <> ips_GOOD_RETURN THEN               BEGIN { IF Can't get frag1 header }           DropMessage (frag1mbuf);   "         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+FRAGHDFAIL);  "          mbufid := NO_MBUFID;            Exit;           END;  { IF Can't get frag1 header }                { Have Frag1 header, update the necessary fields        {}        iphd.len := frag1len;         iphd.fragwd.iphd_mf := MORE_FRAGS;        iphd_mbufid := frag1mbuf;   	      UpdatedIphd; 	           { Set the return parameters }   
      mbufid := frag1mbuf; 
       error  := ips_GOOD_RETURN;            END;  { WITH Global Variables }       
   99:      { Exit Point } 
 
   result := error;  
    END;  { SplitMsg }       $PAGE$ (*   $TITLE 'template',PAGE$   {------------------------------------------------------------}  {           template                                         }  {------------------------------------------------------------}      {}  { Description   {}  { Parameters  {   {   {   {   {   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}      	BEGIN { Template } 	 	END;  { Template } 	     *)      	$TITLE 'The End'$  	 
END   { IMPLEMENT }  
 .     { End of File }  