 $PASCAL '91790-1X100 REV.4010 <860404.1131>'  $ TITLE 'IP Library Routines' $   $HEAP 0 $   $HEAPPARMS OFF$   $RECURSIVE OFF$   
$STANDARD_LEVEL 'HP1000'$  
 $DEBUG$   $AUTOPAGE ON$   $CODE_INFO ON$  	$CODE_OFFSETS ON$  	 $RANGE OFF$       MODULE iplib;   $ALIAS 'N$IPL'      {}  {-------------------------------------------------------------  {   { (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS  { RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   { REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT  { THE PRIOR WRITTEN CONSENT OF THE HEWLETT PACKARD COMPANY.   {   {-------------------------------------------------------------  {}      {}  	{      NAME: IPLIB 	 {    SOURCE: 91790-18100  	{     RELOC: NONE  	 {      PGMR: CWJ  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   %{  1/18/85  cwj   Added TTL initialization for header field to BuildIpHead % %{  1/21/85  cwj   Initialized Checksum storage before calling DS_LOnesSum  % {  2/8/85   cwj   Rework Reassembly timer handling  {  2/14/85  cwj   Change import searches to @.rels   {  3/08/85  cwj   Fix IpBufrLog by making it an external routine   {  3/21/85  cwj   Fix ipg_reass_time updating mechanism   !{  3/21/85  cwj   RcbLink chase the reass list incorrectly. Fixed. ! {  3/26/85  cwj   RcbLink rework  {                 RcbUnLink rework  {                 Add StartReassTimer   {                 Add OffReassTimer   {                 Add ReassDeltaTime  {  4/08/85  cwj   Move IP address parsing routines in.  {  4/11/85  cwj   Old timer routines removed.   {  4/11/85  cwj   Correct RcbLink time calculation  ${  4/12/85  cwj   Simplify ReassDelta time, and make callers less prone  $ {                    to err.  #{  4/30/85  cwj   Fix a bug in ReassDelta time. A constant is used as  # {                    both centiseconds and seconds.   {  5/1/85   cwj   Add GetFrag routine   {                 Add PostFrag routine  {                 Remove GetNextHole routine  {                 Remove RevmoveHoleDesc routine  {                 Add RemoveFragDesc routine  {  5/2/85   cwj   Correct some code in IpDisasterLog  !{  5/17/85  cwj   Merge IP PAC address parsing routine into iplib  ! {                 Merge IP address to PAC coversion routine in  {  5/16/85  cwj   Remove commented out sections   {  5/21/85  cwj   Add ICMP Sending routines   {                 Moved ChecksumIcmp from ipib  {  5/22/85  cwj   Comment change  !{  5/24/85  cwj   Allow protocol number = 0 for Store and forward  ! {                    and set up the S&F PidList record  "{  5/29/85  cwj   Bug Fix: IpKillLog was using wrong length for emsg " "{  6/3/85   cwj   Bug Fix: StatesLink will now only operate on paths " {                    with status = UPDATED_DATA or VALID_DATA   {  6/4/85   cwj   Move RequestDownPath from IPACTP.PAS  {                 Add ProSw external for RequestDownPath  {  6/7/85   cwj   Remove `PROBE` constant emulating PROBE PID   {  7/3/85   cwj   for cww: Changes for PROBE SREGLIB  {  6/28/85  cwj   Correct some minor bugs   {                    (some related to S&F Timer processing)   {  7/1/85   cwj   Correct SerialF&FF calls to assume the  {                    buffer and indices returned are invalid.   {  7/1/85   cwj   Change GetAnhRec to set the net segment size  {  7/2/85   cwj   Correct bug in FindLruPathRec   {  7/9/85   cwj   Correctly handle ipg_sfcnt.inuse & @.resvd   {                 Handle Fetch of Path record if net is unknown    {                 Merge in the N050 Event Msg format changes  {  7/30/85  cwj   Add emrd_down_pid to REQUEST_DPATH msgs   {  7/31/85  cwj   Correct emrd_down_pid handling  #{  8/2/85   cwj   Initialize the ah_netpid & use it for REQUEST_DPATHs # {  7/31/85  cwj   Add comments regarding Global variables   {  8/3/85   cwj   Convert to Log_Event  {                 Remove unused DeAllocAnh routine  {                 Remove User Interface routines  {                 IMPORT @.xpt  {                 Range checking off  {  8/14/85  cwj   Move KillOldRoute into IPLIB  {  8/20/85  cwj   Add ProSw error return logging  {  8/23/85  cwj   KillOldRoute Loops when called  {  8/26/85  cwj   Change GetIpPath to pick up globals first   {  ----- posted -----   {  9/3/85   cwj   Changes for Connectionless path handling  ${  9/5/85   cwj   Change GetPathRec to handle the various types of paths $ {                 Move KillOldRoute into IPPCTL   {                 Misc emsg count cleanup   {  9/12/85  cwj   Remove DS_IncWd   {                 Remove DS_DecWd   !{  9/13/85  cwj   StartClTimer only starts if something on CL list ! {  9/17/85  cwj   Unlink ConnectionLess paths correctly   {                 Correct Path ReAlloc Eligibility test   {  ----- N145 Submittal -----   {  9/19/85  cwj   Convert to CCP - remove triggers  {  9/26/85  cwj   Initialize error parameter  {  ----- N152 Submittal -----   {  9/30/85  cwj   Event logging length changes  {  ----- N171 Submittal -----   {  10/31/85 cwj   RCB list maintainance fixes   {  ----- N185 Submittal -----   {  11/2/85  cwj   UnLink CL list routine fixes  {                 Post Global block always unless INVALID DATA  {  ----- N191 Submittal -----   {  11/5/85     cwj   Add Part Number  {  11/18/85    cwj   CCP out TRGLB references   {  ----- N209 Submittal -----   {  11/21/85    cwj   Module Aliasing  {  ----- N223 Submittal -----   {  12/30/85    cwj   ICMP error logging   ${  12/31/85    cwj   Event logging message length corrections SR# 031708 $ {  ----- N262 Submittal -----   {  1/11/86     cwj   Path Maintainance bugs fixed   {  1/14/86     cwj   LLP emsg counts moved to ANH record  {  ----- N302 Submittal -----   #{  1/28/86     cwj   FindLruPath fix (in progress msgs have priority)  # {  ----- N323 Submittal -----    {  1/31/86     cwj   KillRoute now checks for nothing to be done   {  ----- N336 Submittal -----   {  ----- N352 Submittal -----   %{  3/12/86     cwj   Don't send ICMP messages on errors on ICMP messages.  % {                       SR# 034272  "{                    If disaster results in disposing mbuf prior to  " #{                       queuing on Send queue, outbound message queue  # {                       was corrupted. Bug Fix.   {                       SR# 034231  ${  3/13/86     cwj   Added DcnAddress routine to be called when checking $ {                       DCN membership.   {                       SR# 034223  {  ----- N372 Submittal -----   ${  3/31/86     cwj   Set TTL field from NGT to Path record on allocation $ {                       of path record.   {                       SR#   {  ----- N395 Submittal -----    {  4/2/86      cwj   Convert to handle Outbound message queue as   {                    FIFO not LIFO queue.   {                       SR# 035451   {              cwj   Path Not found(tables corrupt) reported as    !{                       Path Not Available(need to allocate more)  ! {                       SR# 035444  !{  4/4/86      cwj   Check Outmsg queue by comparing Head and tail ! {                       pointers.   {  ----- Nxxx Submittal -----   {}  {  End of Modify section  {------------------------------------------------------------   {}      {}  { MODULE DESCRIPTION:   {   #{  This module contains the low level IP procedures and functions that # {  are used by the rest of the IP software.   {}  $TITLE 'IMPORT Section',PAGE$       IMPORT              $SEARCH 'phtm/bodec.xpt'$      bodec,               $SEARCH 'phtm/sodec.xpt'$      sodec,               $SEARCH 'phtm/mmdec.xpt'     mmdec,               $SEARCH 'phtm/mmext.xpt'$      ds_mm,               $SEARCH 'phtm/trcmod.xpt'$     trcmod,              $SEARCH 'phtm/sigmod.xpt'$     sigmod,              $SEARCH 'phtm/tmrdec.xpt'$     tmrdec,              $SEARCH 'phtm/tuser.xpt'$      tuser,               $SEARCH 'phtm/ipdec.xpt'$      ipdec,               $SEARCH 'phtm/ipdb.xpt'$     ipdb;      $TITLE 'EXPORT Section',PAGE$   {------------------------------------------------------------}  {              Export Section                                }  {------------------------------------------------------------}  EXPORT      PROCEDURE AllocAnhRec              (VAR result : Int16);      PROCEDURE AsciiPosInt              (    error  : Int16;               VAR buffer : Int16);      PROCEDURE BuildIcmpMsg             (VAR icmphead : IcmpHeadType;                  srcnode  : Int32;                   dstnode  : Int32;               VAR mbufid   : MbufIdType;              VAR result   : Int16);      PROCEDURE BuildIPHeader              (    flagword   : Int16;                   mbufid     : MbufIdType;                  dlen       : Int16;                   opt_mbufid : MbufIdType );      
FUNCTION  BuildPort  
            (    pid  : Int16;                   port : Int16) : Int16;      FUNCTION  ChecksumHeader : Int16;       FUNCTION  CheckSumIcmp             (    mbufid : MbufIdType;                  startoffset : Int16;                  icmplen     : Int16 ) : Int16;      PROCEDURE ClearOutQue;      PROCEDURE ContextLost;      
FUNCTION  DcnAddress 
            (    address : Int32) : BOOLEAN;       PROCEDURE DropMessage              (    mbufid : MbufIdType);       	FUNCTION  DS_DecBt 	             $ALIAS 'DS_DecBt'$             (    count   : PosInt8;                  counter : PosInt8 ) : PosInt8;      	FUNCTION  DS_IncBt 	             $ALIAS 'DS_IncBt'$             (    count   : PosInt8;                  counter : PosInt8 ) : PosInt8;      PROCEDURE FetchAnhRec              (    index  : Int16;               VAR result : Int16);      PROCEDURE FetchGlobals;       PROCEDURE FetchIpHead              (    mbufid : MbufIdType;              VAR result : Int16);      PROCEDURE FetchNgtRec              (    index    : Int16;                   destnode : Int32 );       PROCEDURE FetchPathRec             (    index  : Int16;               VAR result : Int16 );       
PROCEDURE FindNgtRec 
            (    node    : Int32;              VAR ngt_rec : NgtRecType;               VAR result  : Int16 );      PROCEDURE FindPathRec              (VAR remote : Int32;               VAR local  : Int32;               VAR proto  : Int16;               VAR result : Int16 );       
PROCEDURE GetAnhRec  
            (    anh_adr : Int32;                  dnpid   : Int16;                  segsize : Int16;              VAR result  : Int16 );      	PROCEDURE GetFrag  	            (    link : MbufIdType;              VAR frag : FragDescType);       FUNCTION  GetNet             (    ipadr  : Int32) : Int32;      
PROCEDURE GetNgtRec  
            (    ipadr  : Int32;               VAR result : Int16);      
PROCEDURE GetPathRec 
            (    remote : Int32;                   local  : Int32;                   proto  : Int16;               VAR result : Int16);      
PROCEDURE GetIpPath  
            (    remote  : Int32;                  local   : Int32;                  proto   : Int16;              VAR pathref : Int16;              VAR result  : Int16 );      PROCEDURE GetRcb             (    link   : MbufIdType;              VAR rcb    : RcbType;               VAR result : Int16);      PROCEDURE IcmpErrorLog             (    location : Int16;                   eventtype: Int16;                   ictype   : Int16;                   iccode   : Int16;                   dest     : Int32;                   reporter : Int32;                   altgate  : Int32 );       
PROCEDURE IpBufrLog  
            (    bufrtype : Int16;                   location : Int16;               VAR bufr     : BufferType;                  blen     : Int16);      
PROCEDURE IpEmsgLog  
            (VAR emsg      : EventMsgType;                   location  : Int16);       
PROCEDURE IpErrorLog 
            (    eventtype : Int16;                  ecode     : Int16;                  pathref   : Int16;                  location  : Int16);       
PROCEDURE IpKillLog  
            (VAR emsg : EventMsgType;                  location : Int16);      
PROCEDURE KillRoute  
            (    dnpid   : Int16;                  dnpath  : Int16;                  upcount : Int32;                  dncount : Int32);       PROCEDURE LkPathToAnh;      FUNCTION  LocalAddress             (    address : Int32) : BOOLEAN;       PROCEDURE OffReassTimer;      	PROCEDURE PostFrag 	            (VAR frag : FragDescType);       	PROCEDURE PostRcb  	            (VAR rcb : RcbType );      PROCEDURE QueueMsgOnSendQue              (    mbufid : MbufIdType);       	PROCEDURE RcbLink  	            (    timeout    : Int16;               VAR rcb        : RcbType;               VAR backref    : MbufIdType;              VAR result     : Int16 );       
PROCEDURE RcbUnLink  
            (VAR rcb        : RcbType;                   backref    : MbufIdType);       FUNCTION  ReassDeltaTime             (    timea : Int32;                  timeb : Int32 ) : Int16;      PROCEDURE RemoveFragDesc             (    mbufid : MbufIdType;              VAR frag   : FragDescType);       
PROCEDURE RequestDownPath; 
     
PROCEDURE RtnIcmpMsg 
            (VAR icmphead : IcmpHeadType;              VAR result   : Int16);      PROCEDURE SaveAnhState;       
PROCEDURE SaveGlobalState; 
     
PROCEDURE SaveHeaderState; 
     PROCEDURE SavePathState;      
PROCEDURE SaveState; 
     PROCEDURE StartClTimer;       
PROCEDURE StartReassTimer; 
     PROCEDURE StatesLink;       PROCEDURE UnLinkPathRec              (VAR que_head : Int16);      PROCEDURE UnLkClPath;       
PROCEDURE UnLkPathFromAnh; 
     PROCEDURE UpdatedAnh;       PROCEDURE UpdatedIpg;       PROCEDURE UpdatedIphd;      
PROCEDURE UpdatedPr; 
     IMPLEMENT       $TITLE 'Forward/Externals',PAGE$  {------------------------------------------------------------}  {              Forward/External Declarations                 }  {------------------------------------------------------------}      TYPE      #   ParsedType = PACKED ARRAY [1..33] OF Int16;   { for PARSE routine}  #     PROCEDURE AdrOf              (VAR buffer   : BufferType;                  offset   : Int16;               VAR byte_adr : Int16);              EXTERNAL;       PROCEDURE AllocPathRec             (    remote : Int32;                   local  : Int32;               VAR result : Int16);  
            FORWARD; 
     PROCEDURE CnumD              (VAR value : Int16;  '            VAR buffer: Int16);  { This buffer must be at least 3 words long } '             EXTERNAL;       FUNCTION  DiAnd              (    pram1 : Int32;                  pram2 : Int32) : Int32;               EXTERNAL;       	FUNCTION  DS_DecBt 	            (    count   : PosInt8;                  counter : PosInt8 ) : PosInt8;              EXTERNAL;       	FUNCTION  DS_IncBt 	            (    count   : PosInt8;                  counter : PosInt8 ) : PosInt8;              EXTERNAL;       PROCEDURE FindLruPathRec             (    pathtype : Int16;               VAR result   : Int16 );   
            FORWARD; 
     
PROCEDURE FindPidRec 
            (    proto  : Int16;               VAR result : Int16 );   
            FORWARD; 
     PROCEDURE LinkPathRec              (VAR que_head : Int16);  
            FORWARD; 
     
PROCEDURE LkClPath;  
 
            FORWARD; 
     	FUNCTION  NextIpID 	            (VAR dlen : Int16) : Int16;  
            FORWARD; 
     PROCEDURE ProSw              (VAR emsg   : EventMsgType;              VAR result : Int16);              EXTERNAL;       PROCEDURE PutIcmpInDSAM              (VAR iphead      : IpHeaderType;                   ipheadlen   : Int16;              VAR icmphead    : IcmpHeadType;                   icmphdlen   : Int16;              VAR icmpdata    : IpHeaderType;                   icmpdatalen : Int16;              VAR mbufid      : MbufIdType;               VAR result      : Int16 );  
            FORWARD; 
     PROCEDURE ReAlcCleanUpPath;   
            FORWARD; 
     PROCEDURE ReAllocPathRec             (    remote : Int32;                   local  : Int32;               VAR result : Int16);  
            FORWARD; 
     PROCEDURE SetUpPathRec             (    remote : Int32;                   local  : Int32 );   
            FORWARD; 
     FUNCTION  TTLmin  
            $ALIAS 'MIN0'$ 
 
           (    a : Int16; 
                 b : Int16 ) : Byte;               EXTERNAL;       
$TITLE 'Procedures',PAGE$  
 {------------------------------------------------------------}  {              Procedures                                    }  {------------------------------------------------------------}      
$TITLE 'AllocAnhRec',PAGE$ 
 {------------------------------------------------------------}  {              AllocAnhRec                                   }  {------------------------------------------------------------}      PROCEDURE AllocAnhRec              (VAR result : Int16);      {}  { Description   {   #{     This routine will allocate and initialize a new ANH rec from the # 
{     table in DSAM. 
 {   {     It will be placed into the global variable gv_anh_rec.  {}  { Parameters  !{     result   OUT   ips_GOOD_RETURN   - the entry was allocated.  ! #{                    ips_ANH_NOT_ALLOC - the entry was NOT allocated.  # {}  { Side Effects  "{     This routine does not modify DSAM, it only modifies the local  " #{     structures so that when they are posted to DSAM the changes will # {     be recorded there.  {}  { Global Data Structures  {   ${     gv_ip_globals  IN/OUT   The Free ANH List list head is changed to  $ %{                             remove this newly allocated record from the  % {                             free list.  {   "{     gv_anh_rec        OUT   This global variable will contain the  " ${                             initialized ANH record following the call. $ #{     gv_path_rec    IN       The current path rec is logged on error. # {   {}  { Error Handling  ${     There should be nothing that can go wrong in this routine because  $ "{     the worst case number of ANH records required are allocated at " {     initialization (the same as the number of path records).  ${     If there is an error on the MMGR calls though, the ANH record will $ "{     be set to INVALID_DATA and the error result will be returned.  " {}  { Algorithm   %{     If the anh record variable already has valid information in it, that % {     information is posted to DSAM.  {   "{     This routine removes the first element from the Free ANH list  " {     which has a header kept in the ip_globals block.  {   !{     'gv_anh_rec' is initialized, the record status field is set  ! {     to UPDATED_DATA and the local link for the free list  {     (in the globals block) is changed to unlink this record.  {   {     The changed records will be posted to DSAM by the   {     'SaveStates' procedure at a later time.   {}     CONST  "      SUBR = SubrALLOCANH;     { Subroutine ID number for logging }  "        VAR  
      next_index : Int16;  
        BEGIN { AllocAnhRec }     WITH gv_ip_globals, gv_anh_rec DO        BEGIN { WITH Global Variables }         { Post the current Anh record to DSAM if necessary        { and initialize the result parameter.        {}  
      SaveAnhState;  
       result := ips_GOOD_RETURN;            IF ipg_ah_free = END_OF_LIST THEN                BEGIN { IF }            { This is a severe error, there are no ANH records            { and allocation has been requested.            {}            gv_anh_rec := ah_INIT_ANH_REC;            ah_rec_status := INVALID_DATA;            result := ips_ANH_NOT_ALLOC;            WITH gv_path_rec DO  %            IpErrorLog (EL_RESOURCELIM, result, pr_pathref, SUBR+ANHFAIL); %          END   { IF ipg_ah_free = END_OF_LIST }              ELSE                BEGIN { ELSE }            { The next free anh record index is in the globals.           { This list must be relinked however so           { Fetch the index of the n+1th free Anh record            {}   
         DS_FetchFields (  
             DS_IP_Anh_Rec_TD,        { From ANH Table }   %            ipg_ah_free,             { get the link to the 2nd Free rec }  % !            next_index,              { into this next_index word.} !             FREE_LIST_LINK_OFSET,               1);                { Initialize the new anh record           {}            gv_anh_rec := ah_INIT_ANH_REC;            ah_index := ipg_ah_free;   
         UpdatedAnh; 
          { Unlink this entry from the free list            {}            ipg_ah_free := next_index;   
         UpdatedIpg; 
          END;  { ELSE }         END;  { WITH Global Variables }      END;  { AllocAnhRec }      $TITLE 'AllocPathRec',PAGE$   {------------------------------------------------------------}  {              AllocPathRec                                  }  {------------------------------------------------------------}      PROCEDURE AllocPathRec             (    remote : Int32;                   local  : Int32;               VAR result : Int16);  {}  { Description   {   #{     This routine will allocate and initialize a new pathrec from the # {     DS_IP_PATH_REC_TD table in DSAM.  {   {     It will be placed into the global variable gv_path_rec.   {}  { Parameters  {   {     remote   IN       The IP address of the remote machine.   {     local    IN       The IP address of the local machine.  "{     result      OUT   The result of the operation. It may take one " {                       of the following values:  {   &{                          ips_GOOD_RETURN - The allocation was successful.  & #{                          ips_PATH_NOT_AVAIL - The allocation failed. # ${                                                'pathrec' is unchanged. $ {}  { Side Effects  "{     This routine does not modify DSAM, it only modifies the local  " #{     structures so that when they are posted to DSAM the changes will # {     be recorded there.  {}  { Global Data Structures  {   ${     gv_ip_globals  IN/OUT   The Free Path List list head is changed to $ ${                             remove this newly allocated path from the  $ {                             free list.  {   "{     gv_path_rec       OUT   This global variable will contain the  " "{                             initialized Path record if the call is " {                             successful.   {   "{     gv_pid_rec     IN       This is required to initialize the new " {                             path record.  {}  { Error Handling  {     See the result parameter above.   {}  { Algorithm   !{     If the path record already has valid information in it, that ! {     information is posted to DSAM.  {   "{     This routine removes the first element from the Free Path list " {     which has a header kept in the ip_globals block.  {   {     If there are no free entries, an error is returned  {     and the path record is untouched.   {   {     Otherwise, the local 'pathrec' is initialized, set  {     to UPDATED_DATA and the local link for the free list  {     (in the globals block) is changed to unlink this record.  {   {     The changed records will be posted to DSAM by the   {     'SaveStates' procedure at a later time.   {}  LABEL 99;                  { Exit Label }   VAR      next_index : Int16;     { Index of next free path record }      error      : Int16;     { Local error code }       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { AllocPathRec }  WITH gv_ip_globals, gv_path_rec DO     BEGIN { WITH GLOBAL VARIABLES }     { Initialize the error return and     { Post the current path record to DSAM if necessary     {}      error := ips_GOOD_RETURN;  	   SavePathState;  	        { Are there any free path records?      {}      IF ipg_pr_free = END_OF_LIST THEN        BEGIN { There are NO Free Path Records }        error := ips_PATH_NOT_AVAIL;        Exit;         END;  { There are NO Free Path Records }         {}      { There are free path records, so     { Fetch the index of the next free path record      {}   
   DS_FetchFields (  
       DS_IP_PATH_REC_TD,    { Table Descriptor }         ipg_pr_free,          { Index of First Free Path Record }          next_index,           { Index of Next Free path record }        FREE_LIST_LINK_OFSET, { Offset to Free List Link word }         1);                   { Length of List Linkage }         { Initialize this new path record     { with the standard stuff     { and unlink it from the global block     {}      gv_path_rec   := pr_INIT_PATH_REC;      pr_pathref    := ipg_pr_free;     pr_rec_status := UPDATED_DATA;      ipg_pr_free   := next_index;          { Set up the rest of the path record      { Depending on the context.     {  remote, local, gv_pid_rec      {}      SetUpPathRec (remote, local);         { Count this record as allocated & update the max allocated  	   { if necessary  	    {}   
   WITH ipg_statistics DO  
 
      BEGIN { WITH } 
       ipgs_paths_inuse := DS_IncBt (ipgs_paths_inuse, 1);         IF ipgs_paths_inuse > ipgs_maxpaths_used THEN            BEGIN { IF have new max }           ipgs_maxpaths_used := ipgs_paths_inuse;           END;  { IF have new max }  
      END;  { WITH } 
        UpdatedIpg;         END;  { WITH GLOBAL VARIABLES }      99:      { Exit Point }   result := error;  END;  { AllocPathRec }          
$TITLE 'AsciiPosInt',PAGE$ 
 {------------------------------------------------------------}  {           AsciiPosInt                                      }  {------------------------------------------------------------}      PROCEDURE AsciiPosInt              (    error  : Int16;               VAR buffer : Int16);  {}  { Description   {     This is a module style interface for CNUMD to allow   {     conversion of POSITIVE, 16-bit INTEGERS to ASCII.   {}  { Parameters  #{     error    IN    Positive 16-bit integer to be converted to ASCII. # {   "{     buffer     OUT The buffer that will contain the ASCII number.  " {    {        NOTE    that this buffer must be at least 3 words long.   {                In order to contain the CNUMD returns.   {}      BEGIN { AsciiPosInt }   CNUMD (error, buffer);  END;  { AsciiPosInt }       $TITLE 'BuildIcmpMsg',PAGE$   {------------------------------------------------------------}  {           BuildIcmpMsg                                     }  {------------------------------------------------------------}      PROCEDURE BuildIcmpMsg             (VAR icmphead : IcmpHeadType;                  srcnode  : Int32;                   dstnode  : Int32;               VAR mbufid   : MbufIdType;              VAR result   : Int16);      {}  { Description   {     This routine will build the ICMP  {     message, and see that it gets put into DSAM.  {     It will return a pointer to it in 'mbufid'.   {     The message will be ready to queue onto the appropriate   {     path record and sent.   {}  { Parameters  "{     icmphead IN       The ICMP header to be used for this message. " ${     srcnode  IN       The local node that is sending the ICMP message  $ ${     dstnode  IN       The remote node that will get this ICMP message  $ {     mbufid      OUT   The mbufid of the message in DSAM   {     result      OUT   The result of this operation  {                       0 = Good return   #{                       else = bad and will generally be a MMGR error  # {}  { Global Data Structures  ${     gv_path_rec IN    The path record this routine will use as context $ {                       It will also be logged on errors.   &{     gv_ip_head  IN    The IP header of the message that caused the sending & {                       of this ICMP message.   {}  { Error Handling  {}  { Algorithm   {     The ICMP message is of the format:  {     +------------+-------------+-------------+  {     |  IP header | ICMP header | ICMP data   |  {     +------------+-------------+-------------+  {   #{  where 'IP header' is a brand new header build using the appropriate # {                    path record.   {        'ICMP header' contains the ICMP information  "{        'ICMP data'   contains the IP header + 64 bits of ULP data  " "{                      of the message that caused this ICMP message  " {                      to be sent.  {   #{     These three fields will be set up, and then put into DSAM, using # {     IP's root socket for memory accounting purposes.  ${     The message will then be treated like any other outbound message,  $ {     queued to a path record, and sent.  {}  LABEL      99;   { Error Exit }       CONST      SUBR = SubrBUILDDSTUNREACH;        CKSUMPOST   = 1;        ICMPPOSTERR = 2;         INIT_IPHEAD = IpHeaderType         [          iphd : BasicIpHeadType            [              w1 : IpWord1Type                 [                 version : iphd_VERSION,                 headlen : iphd_LENGTH,                  typeofsrv : TOSType  
                  [  
                   precedence  : 0,                    delay       : 0,                    thruput     : 0,                    reliability : 0,                    reserved    : 0,  
                  ], 
 	               ],  	             len : BYTES_IP_HEAD,  
            id  : 0, 
             fragwd : IpFragWordType                  [                 iphd_rsv :  0,                  iphd_df  :  0,                  iphd_mf  :  0,                  iphd_off :  0,   	               ],  	             w5  : IpWord5Type                  [                 iphd_ttl   : 0,                 iphd_proto : 0,  	               ],  	             sum : END_OF_LIST,  
            src : 0, 
 
            dst : 0, 
          ],          iphd_options : IpOptionsType            [           opt_bufr : 0,           ],         ];      TYPE     CheckSumType = RECORD  
      CASE Int16 OF  
          0: (  bufr : BufferType);           1: (  int  : Int16);            END;  { CheckSumType }       VAR   
   iphead : IpHeaderType;  
    oldheadlen : Int16;     icmplen    : Int16;     checksum   : CheckSumType;      error      : Int16;      	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { BuildIcmpMsg }  { Set up the Oldheader  {}  !oldheadlen :=  gv_ip_head.iphd.w1.headlen*4 + WORDS_ICMP_ULPDATA;  !     { Set the length of the ICMP header   {}  icmplen := 8;  { byte length of ICMP header }       { Build the IP header   {}  WITH iphead, gv_path_rec DO      BEGIN { WITH iphead }     error := 0;  
   iphead := INIT_IPHEAD;  
        iphd.len := iphd.w1.headlen*4 + icmplen + oldheadlen;     iphd.id  := NextIpId (iphd.len);   	   WITH iphd.w5 DO 	       BEGIN { WITH word 5 }         iphd_ttl   := pr_ttlwd.ttl;         iphd_proto := ICMP_PROTO_NUM;         END;  { WITH word 5 }          iphd.src := srcnode;      iphd.dst := dstnode;      END;  { WITH iphead }      { Post this message to DSAM   {}  PutIcmpInDSAM (iphead, iphead.iphd.w1.headlen*4,                 icmphead, icmplen,                  gv_ip_head, oldheadlen, mbufid, error);         IF error <> ips_GOOD_RETURN THEN         BEGIN { IF error on putting this message into DSAM }        DropMessage (mbufid);   
      WITH gv_path_rec DO  
 "         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+ICMPPOSTERR); "       Exit;         END;  { IF error on putting this message into DSAM }      { Do the ICMP checksum of the message in DSAM   {}   checksum.int := CheckSumIcmp (mbufid, iphead.iphd.w1.headlen*4,    #                                                icmplen + oldheadlen); # DS_MBOverWrite (checksum.bufr, 2, mbufid,   #                                 (iphead.iphd.w1.headlen*4)+2, error); # IF error <> ips_GOOD_RETURN THEN     BEGIN { IF ICMP header posting error }      DropMessage (mbufid);     WITH gv_path_rec DO         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+CKSUMPOST);       Exit;     END;  { IF ICMP header posting error }       
99:   { Error Exit } 
 result := error;  END;  { BuildIcmpMsg }      $TITLE 'BuildIpHeader',PAGE$  {------------------------------------------------------------}  {              BuildIpHeader                                 }  {------------------------------------------------------------}      PROCEDURE BuildIPHeader              (    flagword   : Int16;                   mbufid     : MbufIdType;                  dlen       : Int16;                   opt_mbufid : MbufIdType );  {}  { Description   {   #{     This routine, builds the basic IP header locally to the protocol # {     procedure in gv_ip_head.  {     It also appends the header to the message in DSAM.  {}  { Parameters  {   %{     flagword    IN       This contains the Type of Service bits as well  % {                          as the don't fragment flag.  {   #{     mbufid      IN       The mbufid of the message that this header  # {                          is destined for.   {   %{     dlen        IN       The length of the data to which the header will % {                          be appended (in bytes).  {    {     opt_mbufid  IN       Initially, this must be a null mbufid   %{                          as it will be ignored. Later this will contain  % "{                          the options to be added to the IP header. " {}  { Side Effects  !{     This routine sets the 'gv_ip_head' variable and assumes that ! #{     some other routine will take care of appending this information  # {     to the message in DSAM.   {}  { Global Data Structures  ${     gv_ip_head     OUT   The header that is built by this routine will $ {                          reside here.   {     gv_path_rec IN       The path record context.   {}  { Error Handling  %{     There will be no errors, since everything required has already been  % {     allocated.  {}  { Algorithm   ${     If the global header variable already contained valid information, $ {     that information is posted to DSAM.   {   {     The header variable is then initialized, and the  {     specific fields passed in are set to their values.  {   ${     Note that the mbufid is recorded in one of the header housekeeping $ #{     fields and dlen will be kept in the header itself in the header  # {     length field (iphd.len).  {}  CONST       SUBR = SubrBUILDIPHD;    { Subroutine ID number for logging }       VAR   
   tosword : PACKED RECORD 
 
      CASE Int16 OF  
 
         0: (int : Int16); 
          1: (tos : IpWord1Type);  
         END;  { RECORD }  
    error   : Int16;     { Error Return for MMGR call }  &   ipheadlen : Int16;   { Byte length of the IP header built by this call }  &     BEGIN { BuildIPHeader }   WITH gv_ip_head, gv_path_rec DO      BEGIN { WITH Global Variables }     { Post the current header to DSAM if necessary      {}   
   SaveHeaderState;  
        WITH gv_ip_head.iphd.w1 DO         BEGIN { WITH first word of IP header }        { Version and default header length (w/o options)         {}        iphd.w1.version := iphd_VERSION;        iphd.w1.headlen := iphd_LENGTH;       !      { The type of service fields are set to the passed in values !       {}        tosword.int := flagword;        iphd.w1.typeofsrv := tosword.tos.typeofsrv;         END;  { WITH first word of IP header }         { Length of IP message in bytes }     {}      iphd.len := dlen + (IPHD_LENGTH * 4);         { IP Message Identifier }     {}      iphd.id := NextIpID (dlen);         WITH gv_ip_head.iphd.fragwd DO         BEGIN { WITH fragmentation word }         { Fragmentation fields }        {}  
      iphd_rsv := 0; 
 
      iphd_df  := 0; 
 
      iphd_mf  := 0; 
       iphd_off := iphd_FIRST_FRAG;        END;  { WITH fragmentation word }          WITH gv_ip_head.iphd.w5 DO         BEGIN { WITH word 5 of header }         { Time to live value and        { Protocol Number (ULP addressed)         {}        iphd.w5.iphd_ttl   := pr_ttlwd.ttl;         iphd.w5.iphd_proto := pr_proto.byte;        END;  { WITH word 5 of header }          { Checksum (also Active path link word)     { set to END_OF_LIST and then checksummed just before     { shipping the message to the Link Interface.     {}      iphd.sum := END_OF_LIST;          { Source and Destination Addresses }      {}      iphd.src := pr_local;  
   iphd.dst := pr_remote;  
        { Append this header to the head of the message in DSAM }     {}      ipheadlen := iphd.w1.headlen * 4;     DS_MAppendHead (gv_ip_head.iphd_bufr,                     ipheadlen, mbufid,   
                   error); 
        IF error = ips_GOOD_RETURN THEN            BEGIN { IF Header Appended }        { Space has been allocated and the header appended }        {}        iphd_mbufid     := mbufid;        iphd_rec_status := VALID_DATA;        END   { IF Header Appended }          ELSE            BEGIN { ELSE Header NOT appended }        { The header could not be appended to the message }         { This is a severe error which should never happen }        {}        IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR);            { Clean up the references         {}        iphd_mbufid     := NO_MBUFID;         iphd_rec_status := INVALID_DATA;        DropMessage (mbufid);         END;  { ELSE Header NOT appended }         END;  { WITH the header }  END;  { BuildIPHeader }       $TITLE 'BuildPort',PAGE$  {------------------------------------------------------------}  {                 BuildPort                                  }  {------------------------------------------------------------}  
FUNCTION  BuildPort  
            (    pid  : Int16;                   port : Int16) : Int16;      {}  { Description   {     BuildPort is used to construct the index used by ProSw  "{     in dispatching event messages. It builds the 'ehport' word for " 
{     the event messages.  
 {    {     It is isolated in a subroutine like this to make it easier   {     to change this interface should any changes be required.  {}  { Parameters  ${     pid   IN          The PID of the protocol to send the message to.  $ {     port  IN          The In or Out port offset to be used.   {   !{     BuildPort   OUT   The dispatch index to be passed to ProSw.  ! {}  { Side Effects  {     none  {}  { Global Data Structures  {     none  {}  { Error Handling  {     none  {}  { Algorithm   {     see below   {}     BEGIN { BuildPort }     BuildPort := (pid * EHS_PER) + port;      END;  { BuildPort }      $TITLE 'ChecksumHeader',PAGE$   {------------------------------------------------------------}  {              ChecksumHeader                                }  {------------------------------------------------------------}      FUNCTION  ChecksumHeader : Int16;       {}  { Description    {     This routine will calculate the checksum for the IP header   {     contained in the global ip header variable.   {     It will return this value as the functional return.   {}  { Parameters  {     ChecksumHeader    OUT   The value of the checksum.  {}  { Side Effects  {     none  {}  { Global Data Structures  {     gv_ip_head  IN       The IP header to be checksumed.  {}  { Error Handling  "{     Any error should result in a bad checksum. This is sufficient. " {}  { Algorithm   !{     The Memory manager checksumming routines are used to do the  ! {     sum, and then the ones complement of the sum is taken.  !{     NOTE: The IP header should be checksummed with the checksum  ! !{           word set to 0. This routine does not alter the header  ! !{           in any way, and so ensuring that this is done is left  ! 
{           to the caller. 
 {}     CONST  "      SUBR = SubrCHECKSUMHD;   { Subroutine ID number for logging }  "        VAR        checksum : Int16;         error    : Int16;          BEGIN { ChecksumHeader }      WITH gv_ip_head DO         BEGIN { WITH Global Variables }         { Initialize the checksum word for no partial sum }   
      checksum := 0; 
       DS_LOnesSum (  iphd_bufr,                        NO_OFSET,                       iphd.w1.headlen*4,                        checksum,                       error );             IF error <> ips_GOOD_RETURN THEN           BEGIN { IF bad checksum calculation }           IpErrorLog (EL_DISASTER, error, 0, SUBR);           END;  { IF bad checksum calculation }            CheckSumHeader := (-checksum) - 1;        END;  { WITH Global Variables }      END;  { ChecksumHeader }       $TITLE 'CheckSumIcmp',PAGE$   {------------------------------------------------------------}  {                 CheckSumIcmp                               }  {------------------------------------------------------------}      FUNCTION  CheckSumIcmp             (    mbufid : MbufIdType;                  startoffset : Int16;                  icmplen     : Int16 ) : Int16;  {}  { Description   {     This routine will do the checksum calculation on the  {     message in DSAM to determine if the message is valid  {     or not.  It will return the results of the operation as   {     the value of the function.  {}  { Parameters  !{     mbufid      IN    The mbufid of the message with the header  ! %{     startoffset IN    The offset in bytes of the start of the ICMP head  % #{     icmplen     IN    The length in bytes of the ICMP portion of the # {                       message.  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}  VAR   	   sum   : Int16;  	 	   error : Int16;  	     BEGIN { CheckSumIcmp }  sum := 0;   DS_MOnesSum (mbufid, startoffset, icmplen, sum, error);   	sum := (-sum) - 1; 	     IF error <> ips_GOOD_RETURN THEN  
   BEGIN { IF MMGR error } 
    CheckSumIcmp := -1;  
   END   { IF MMGR error } 
     ELSE         BEGIN { ELSE no MMGR error }      CheckSumIcmp := sum;      END;  { ELSE no MMGR error }       END;  { CheckSumIcmp }      
$TITLE 'ClearOutQue',PAGE$ 
 {------------------------------------------------------------}  {              ClearOutQue                                   }  {------------------------------------------------------------}      PROCEDURE ClearOutQue;      {}  { Description   !{     This routine will drop all the messages from the pr_out_que  ! {     on the global path record variable.   "{     It is used to clean up the path record when the path is being  " {     KILLed.   {}  { Parameters  {     none  {}  { Global Data Structures  {     gv_path_rec    IN/OUT   {}  { Algorithm   #{     Beginning with the list head in the global path record variable, # {     drop all messages linked on this queue.    {     Messages are linked using the mbufid as the link pointer,    "{     and the IP header checksum field as the link storage location. " {    {     Messages (mbuf chains) are dropped using the DS_MDispose.    {}     CONST  "      SUBR = SubrCLEAROUTQUE;  { Subroutine ID number for logging }  "     
      TWOBYTES = 2;  
        VAR  
      mbufid : MbufIdType; 
 
      nextid : MbufIdType; 
           copy_data : MMFlagsType;            error     : Int16;         BEGIN { ClearOutQue }     WITH gv_path_rec DO        BEGIN { WITH Global Variables }   !      copy_data.int      := 0;        { Initialize this variable } ! #      copy_data.bits [0] := TRUE;     { Set to copy not delete data }  # $      error := ips_GOOD_RETURN;       { Initialize the error parameter } $           mbufid := pr_out_que;         WHILE ((mbufid <> END_OF_LIST    ) AND               (error   = ips_GOOD_RETURN)     ) DO                BEGIN { WHILE }            { Fetch the next mbufid of a message to be disposed of             { and dispose of the current message            {}             DS_MRead (nextid, TWOBYTES, mbufid, iphd_CKSUM_BOFSET,                         copy_data, error);                IF error = ips_GOOD_RETURN THEN              BEGIN { IF read successful }              DS_MDispose (mbufid, error);              END;  { IF read successful }               { Set mbufid for next go around }           IF mbufid = pr_out_tail THEN mbufid := END_OF_LIST                                    ELSE mbufid := nextid;            END;  { WHILE }            IF error <> ips_GOOD_RETURN THEN           BEGIN { IF MRead or MDispose error }            IpErrorLog (EL_ERROR, error, pr_pathref, SUBR);           END;  { IF MRead or MDispose error }             { Clear the head and tail of the list         { and the SEND_DATA state         {}        pr_out_que  := END_OF_LIST;         pr_out_tail := END_OF_LIST;         pr_states   := pr_states - [ast_SEND_DATA];         UpdatedPr;            END;  { WITH Global Variables }      END;  { ClearOutQue }      
$TITLE 'ContextLost',PAGE$ 
 {------------------------------------------------------------}  {              ContextLost                                   }  {------------------------------------------------------------}      PROCEDURE ContextLost;      {}  { Description   {     This routine will set the record status on all the  {     global variables that can be altered by IP. This is to  {     keep them from being posted with garbage, to DSAM.  {   {     This also ensures that any fetches of these records will   {     get the data from DSAM and not erroneously from an out of    	{     date record. 	 {}  { Parameters  {     none  {}  { Side Effects  {     see Global Data Structures  {}  { Global Data Structures  {     gv_ip_globals     OUT   {     gv_anh_rec        OUT   These are set to INVALID_DATA   {     gv_path_rec       OUT   {     gv_ip_head        OUT   {}  { Error Handling  {     none  {}  { Algorithm   {     Set all the record status fields to INVALID_DATA.   {}         BEGIN { ContextLost }     WITH gv_ip_globals, gv_anh_rec, gv_path_rec, gv_ip_head DO         BEGIN { WITH Global Variables }         ipg_rec_status  := INVALID_DATA;        ah_rec_status   := INVALID_DATA;        pr_rec_status   := INVALID_DATA;        iphd_rec_status := INVALID_DATA;        END;  { WITH Global Variables }      END;  { ContextLost }      
$TITLE 'DcnAddress',PAGE$  
 {------------------------------------------------------------}  {              DcnAddress                                    }  {------------------------------------------------------------}      
FUNCTION  DcnAddress 
            (    address : Int32) : BOOLEAN;       {}  { Description   #{     This function tests an IP address to see if it is on one of the  # {     DCNs connected to the local machine.  {   !{     It returns the BOOLEAN result as the value of the function.  ! {}  { Parameters  ${     address     IN     The IP address to be tested for being on a DCN. $ {   #{     DcnAddress     OUT The value of the function will be TRUE if the # !{                        address IS on a DCN and FALSE otherwise.  ! {}  {  Side Effects   {     none  {}  
{  Global Data Structures  
 %{     NGT            This table in DSAM contains all of the Networks known % {                    to the local node. DCNs are 0 hops away.   {}  	{  Error Handling  	 {}  {  Algorithm  "{     A Search is done of the NGT for the netork in question, and if " {     the local node is 0 hops from it, the nodes share a DCN.  {}     VAR  
      ngt   : NgtRecType;  
 
      error : Int16; 
        BEGIN { DcnAddress }      error := 0;     FindNgtRec (address, ngt, error);     DcnAddress := (error = ips_GOOD_RETURN) AND                   (ngt.ngt_hopwd  = 0     );          END;  { DcnAddress }       
$TITLE 'DropMessage',PAGE$ 
 {------------------------------------------------------------}  {              DropMessage                                   }  {------------------------------------------------------------}      PROCEDURE DropMessage              (    mbufid : MbufIdType);       {}  { Description    {     This routine is called whenever IP must drop a message or    {     a fragment of a message.  {   {     This is due to the following kinds of things:   {        (this is not an exhaustive list)   {        - Invalid message (checksum is bad, ttl has expired)   {        - Reassembly timed out   {        - Memory Accounts are full   {}  { Parameters  {     mbufid   IN    The pointer to the message to be dropped.  {}  { Side Effects  {     This results in the mbufid passed in being invalidated,   {     and the message in DSAM being deallocated.  {   { Global Data Structures  {     none  {   { Error Handling  !{     If an error occurs in dropping the message, nothing is done  ! {     because there is nothing anyone else could do.  {   {     The fact that such an error occured is logged however.  {}     CONST  "      SUBR = SubrDROPMSG;      { Subroutine ID number for logging }  "        VAR  
      error : Int16; 
        BEGIN { DropMessage }     { Dispose of the message.     {}      DS_MDispose (mbufid, error);       !   { If there was a problem, report it but we can do nothing else. !    {}      IF error <> ips_GOOD_RETURN THEN   !      IpErrorLog (EL_ERROR, error, gv_path_rec.pr_pathref, SUBR);  !    END;  { DropMessage }      
$TITLE 'FetchAnhRec',PAGE$ 
 {------------------------------------------------------------}  {              FetchAnhRec                                   }  {------------------------------------------------------------}  PROCEDURE FetchAnhRec              (    index  : Int16;               VAR result : Int16 );       {}  {  Description  !{     FetchAnhRec will get the ANH record by index from DSAM, and  ! {     will put it into the global variable, gv_anh_rec.   {   !{     It will ensure that the record status is set to VALID_DATA.  ! {}  {  Parameters   #{     index    IN       The index of the record in DSAM to be fetched. # "{     result      OUT   ips_GOOD_RETURN   - Anh record requested was " {                                           fetched.  #{                       ips_BAD_ANHREF    - Anh record requested could # {                                           not be fetched.   {}  {  Side Effects   {     This routine will post the current gv_anh_rec if it is  "{     not the record being looked for, and if it needs to be posted. " {}  
{  Global Data Structures  
 "{     gv_anh_rec     OUT   The variable that is set by this routine. " {}  	{  Error Handling  	 {     This routine assumes that it has been passed a valid  {     index.  {   !{     If the record fetched is still on the free list, or it fails ! !{     for any other reason, the routine will set the record status ! {     field to INVALID_DATA and return an error result.   {}  {  Algorithm  {     Save the state of the current gv_anh_rec if necessary   "{     Check to see if the data in gv_anh_rec is what we are looking  " {        for, if it is, return.   "{     Otherwise, fetch the record from DSAM and set the housekeeping " {     fields.   {}         BEGIN { FetchAnhRec }     WITH gv_anh_rec DO         BEGIN { WITH Global Variables }   $      { Post the current record to DSAM if it is not the desired record  $ 
      { and if necessary.  
       {}        IF ah_index <> index THEN SaveAnhState;             { Initialize the result return }        result := ips_GOOD_RETURN;            IF (ah_rec_status = INVALID_DATA) OR           (ah_index <> index           ) THEN           BEGIN { IF }            { Must fetch a copy from DSAM           {}            DS_FetchElement (DS_IP_Anh_Rec_TD, index, ah_bufr);               IF ah_free_link <> REC_INUSE THEN  	            BEGIN  	             { This record is still on the free list.  $            { This fetch is not valid. Records must be ALLOCATED first.  $             {}              ah_rec_status := INVALID_DATA;              result := ips_BAD_ANHREF;               END   { IF }                ELSE      
            BEGIN { ELSE } 
             { This record has been previously allocated               { so it contains valid data and may be used.              {}              ah_index      := index;               ah_rec_status := VALID_DATA;  
            END;  { ELSE } 
              END;  { IF }         END;  { WITH Global Variables }      END;  { FetchAnhRec }      $TITLE 'FetchGlobals',PAGE$   {------------------------------------------------------------}  {              FetchGlobals                                  }  {------------------------------------------------------------}      PROCEDURE FetchGlobals;       {}  { Description    {     This routine will fetch the IP global block from the DSAM.   {     It will set it into the gv_ip_globals variable.   {}  { Parameters  {     none  {}  { Side Effects  !{     The globals will be fetched only if the gv_ip_globals status ! {     is INVALID_DATA.  {}  { Global Data Structures  "{     gv_ip_globals     OUT   The fetched globals will reside here.  " {}  	{  Error Handling  	  {     At the present time, there is no way to detect an error in   {     fetching the globals.   {}  {  Algorithm  {     See the code below  {}      
   BEGIN { FetchGlobals }  
    WITH gv_ip_globals DO        BEGIN { WITH Global Variables }             IF ipg_rec_status = INVALID_DATA THEN                BEGIN { IF }   "         DS_FetchElement (DS_IP_GLOBALS_TD, FIRST_ENTRY, ipg_bufr);  "              ipg_rec_status := VALID_DATA;               END;  { IF }         END;  { WITH Global Variables }   
   END;  { FetchGlobals }  
     
$TITLE 'FetchIpHead',PAGE$ 
 {------------------------------------------------------------}  {              FetchIpHead                                   }  {------------------------------------------------------------}      PROCEDURE FetchIpHead              (    mbufid : MbufIdType;              VAR result : Int16 );       {}  { Description   {     This routine will fetch the IP Header pointed to by the   #{     mbufid. It will fetch both the header and any possible options.  # {     This data will be placed into the gv_ip_head variable.  {}  { Parameters  !{     mbufid   IN       Key to Mbuf chain containing an IP message ! {   {     result      OUT   ips_GOOD_RETURN - IP header fetched   "{                       ips_HEAD_NOT_FOUND - IP Header could not be  "  {                                            fetched from DSAM.    {}  { Side Effects  {     none  {}  { Global Data Structures  %{     gv_ip_head  OUT   The fetched header will be put into this variable. % {}  { Error Handling  #{     It is assumed that this routine will not be called unless there  # {     is an IP header to fetch.   !{     The various header fields will indicate how much information ! {     is actually valid header.   {   !{     If there is an error in fetching the header (except for the  ! "{     too few bytes error), an error will be returned in the result. " {}  { Algorithm   {   %{   This routine will fetch the maximum size header and options from DSAM. % #{   This will ensure that there is only 1 DSAM call and it will always # {   include all of the options with the header.   {   {   This maximum is 60 bytes.   {}      VAR      error     : Int16;        { Local Error code }      copy_data : MMFlagsType;      readlen   : Int16;       BEGIN { FetchIpHeader }   	WITH gv_ip_head DO 	    BEGIN { WITH GLOBAL VARIABLES }         { Initialize the result return }      error  := 0;      result := ips_GOOD_RETURN;          {}      { Copy the IP header and Options to the local Buffer      {}   "   copy_data.int := 0;          { Clear all the bits in this word }  " !   copy_data.bits [0] := TRUE;  { Copy & don't delete mbuf data }  !        { Read the maximum header that ever will be required      {}      readlen := iphd_MAX_BYTES;   #   DS_MRead (iphd_bufr, readlen, mbufid, NO_OFSET, COPY_DATA, error);  #    IF (error = MMTOOFEWBYTES  ) OR        (error = ips_GOOD_RETURN) THEN            BEGIN { IF Data Returned }        { Some data was returned, fetch was successful}         iphd_mbufid  := mbufid;         iphd_rec_status := VALID_DATA;        END   { IF Data Returned }          ELSE            BEGIN { ELSE Error on Data return }         { The header couldn't be fetched }        iphd_rec_status := INVALID_DATA;        result := ips_HEAD_NOT_FOUND;         END;  { ELSE Error on Data return }          END;  { WITH GLOBAL VARIABLES }  END;  { FetchIpHeader }       
$TITLE 'FetchNgtRec',PAGE$ 
 {------------------------------------------------------------}  {              FetchNgtRec                                   }  {------------------------------------------------------------}      PROCEDURE FetchNgtRec              (    index    : Int16;                   destnode : Int32 );       {}  { Description   #{     This routine will fetch an ngt record based on the index passed  # %{     in. This record will be placed into the global variable, gv_ngt_rec. % {   "{     The destnode parameter is used to set the Appropriate next hop " {     for use.  {}  { Parameters  {   {  index    IN    Index of desired NGT record   {   "{  destnode IN    Destination node address, used in determining the  " "{                    Appropriate Next hop for messages on this path. " {}  { Side Effects  {}  { Global Data Structures  %{     gv_ngt_rec     OUT   This global varible is set as a result of this  % {                          routine.   {}  { Error Handling  {   #{     At this time there is no capacity for checking if the fetch was  # {     successful or not.  {}  { Algorithm   {   {     The record is read as an arrays from DSAM using the   {     Memory Manager calls.   {   {     And then the local fields are set to help in processing.  {}      BEGIN { FetchNgtRec }   	WITH gv_ngt_rec DO 	 	   BEGIN { WITH }  	        DS_FetchElement (DS_IP_Neigh_Gate_TD, index, ngt_bufr);         { Set the index for use in other data structures.     {}   
   ngt_index     := index; 
     "   { If the destination is on a Directly Connected Network (0 Hops)  "    { use its address as the ANH (Appropriate Next Hop)     { Otherwise, use the gateway supplied by the NGT.     {}      IF ngt_hopwd = NO_HOPS THEN            BEGIN   
      ngt_anh := destnode; 
       END   { IF ngt_hopwd = NO_HOPS }          ELSE            BEGIN         ngt_anh := ngt_neighgate;         END;  { ELSE ngt_hopwd <> NO_HOPS }       	   END;  { WITH }  	 END;  { FetchNgtRec }       $TITLE 'FetchPathRec',PAGE$   {------------------------------------------------------------}  {              FetchPathRec                                  }  {------------------------------------------------------------}      PROCEDURE FetchPathRec             (    index  : Int16;               VAR result : Int16);      {}  { Description   #{     This routine will fetch a path record based on the index passed  # %{     in. This path record will be placed into the 'gv_path_rec' variable. % {}  { Parameters  {     index    IN    Index of desired path record   {   "{     result      OUT ips_GOOD_RETURN - The path record was fetched  " ${                     ips_BAD_PATHREF - The path record was not fetched. $ {}  { Side Effects  {     none  {}  { Global Data Structures  '{     gv_path_rec    OUT   The path record will be placed into this variable.  ' {}  { Error Handling  "{     If the path record is still on the free list, an error will be " ${     returned. There is no way to tell if the DSAM call was successful  $ ${     or not so there can be no checks against a corrupt path reference. $ {}  { Algorithm   ${     If there is information in gv_path_rec that needs posting to DSAM, $ {     that will be done prior to fetching the desired record.   {   "{     If the desired element is already in gv_path_rec, then it will " {     be used.  {   "{     Otherwise, the path record will be read as an array from DSAM. " {}      BEGIN { FetchPathRec }  
WITH gv_path_rec DO  
 	   BEGIN { WITH }  	 $   { Post the existing Path record to DSAM if it is not the one desired  $    {  and if necessary.      {}      IF pr_pathref <> index THEN SavePathState;          { Initialize the result return }      result := ips_GOOD_RETURN;          IF (pr_rec_status = INVALID_DATA) OR         (pr_pathref <> index         ) THEN       	      BEGIN { IF } 	       { Need to get the new record from DSAM        {}        DS_FetchElement (DS_IP_Path_Rec_TD, index, pr_bufr);            IF pr_free_link <> REC_INUSE THEN                BEGIN           { This record is on the free list and           { does not contain valid data.            { Setting the record status will prevent this record            { from being copied back into DSAM.           { Records must be allocated prior to            { being used.           {}            pr_rec_status := INVALID_DATA;            result := ips_BAD_PATHREF;            END   { IF }              ELSE                BEGIN { ELSE }            { This record is currently NOT on the free list           { so contains valid data and is ready for use.            {}            pr_rec_status := VALID_DATA;            pr_pathref    := index;           END;  { ELSE }   	      END;  { IF } 	     	   END;  { WITH }  	 END;  { FetchPathRec }      $TITLE 'FindLruPathRec',PAGE$   {------------------------------------------------------------}  {              FindLruPathRec                                }  {------------------------------------------------------------}  PROCEDURE FindLruPathRec             (    pathtype : Int16;               VAR result   : Int16 );       {}  {  Description  %{     This routine will search for the least recently used connectionless  % {     path. When it finds it, the path record will be placed  {     into the global path record variable.   ${     If there are no connectionless paths inuse, or eligible for reuse, $ {     this routine will return an error.  {}  {  Parameters   {     pathtype IN       The type of path requested.   {                          pr_REFED_CONNECT         (e.g. TCP)  {                          pr_REFED_CONNECTLESS     (e.g. IFP)  {                          pr_UNREFED_CONNECTLESS   (e.g. S&F)  {   !{     result      OUT   ips_GOOD_RETURN if the LRU path was found  ! "{                       ips_PATH_NOT_AVAIL if there were no paths to " {                                          choose from.   {}  {  Side Effects   {     gv_path_rec may be altered by this routine.   {}  
{  Global Data Structures  
 &{     gv_ip_globals  IN       contains the list head for the Connectionless  & ${                             path list to be searched by this routine.  $ {     gv_path_rec       OUT   The LRU path found  {}  	{  Error Handling  	 
{     see result parameter 
 {}  {  Algorithm  !{     The Connectionless path list will be traversed, and the path ! !{     reference of the Least Recently Used path will be recorded.  ! "{     At the end of the search, the least recently used path will be " {     fetched.  {   {     NOTE regarding eligibility:   ${        Connectionless paths are eligible for reuse, only if there are  $ !{        no outstanding messages queued on the path, and further:  ! {   %{        PXP (RCL  paths) are eligible only if both ULP emsg counts are 0. % #{        S&F (UnRCL paths) are eligible if the number inuse is greater # #{            than the number reserved, or if the requested path is an  # {            UnRCL path.  {}         LABEL        99;   { Return point }         CONST        SUBR = subrFINDLRUPATH;          VAR        lru_nxt_path : LruLinkageType;        path_ref     : Int16;         bigest_count : Int16;         link         : Int16;         error        : Int16;             PROCEDURE Exit;            BEGIN { Exit }   	         GOTO 99;  	          END;  { Exit }          BEGIN { FindLruPathRec }      WITH gv_ip_globals, lru_nxt_path DO        BEGIN { WITH Global Variables }   	      error := 0;  	           { Initialize the Link word        {}        link := ipg_clpath_list;            { Initialize the FOUND values }         {}        path_ref     := END_OF_LIST;        bigest_count := 0;            WHILE link <> END_OF_LIST DO           BEGIN { WHILE more on clpath list }               DS_FetchFields (DS_IP_Path_Rec_TD, link,   %                           lru_nxt_path.lru_bufr, pr_CL_OFSET, pr_CL_LEN); %     %         IF (lru_count >= bigest_count                              ) AND  % %            (lru_out_que = END_OF_LIST                              ) AND  %             (                  (  (lru_path_type = pr_REFED_CONNECTLESS) AND                    (lru_up_emscnt = 0) AND                     (lru_dn_emscnt = 0)   "                                                               ) OR  "                (  (lru_path_type = pr_UNREFED_CONNECTLESS) AND                    (ipg_clcnt.resvd < ipg_clcnt.inuse)   "                                                               ) OR  "                    (  (lru_path_type = pr_UNREFED_CONNECTLESS) AND                    (pathtype = pr_UNREFED_CONNECTLESS)   '                                                               )       ) THEN  '     $            BEGIN { IF the path just fetched is more LRU and eligible }  $             {}               { Record this path's index and the new bigest count                 {     (note that the newer records are linked at the   !            {      head of the list so if the counts are the same, !             {      the farther out the list is the older.)              {}              path_ref     := link;               bigest_count := lru_count;  $            END;  { IF the path just fetched is more LRU and eligible }  $              {}            { Set the link to the next entry            {}            link := lru_index;            END;  { WHILE more on clpath list }            { IF nothing found, return with an error to the caller.         {}        IF path_ref = END_OF_LIST THEN           BEGIN { IF no appropriate path }            error := ips_PATH_NOT_AVAIL;            Exit;           END;  { IF no appropriate path }             { Have the index of the path record to reallocate.        {}        FetchPathRec (path_ref, error);   !      { If the fetch fails, return this information to the caller  !       {}        IF error <> ips_GOOD_RETURN THEN Exit;            END;  { WITH Global Variables }          {}      { Return the result to the caller.      {}   
   99:   { Return Point }  
 
   result := error;  
    END;  { FindLruPathRec }       
$TITLE 'FindNgtRec',PAGE$  
 {------------------------------------------------------------}  {           FindNgtRec                                       }  {------------------------------------------------------------}      
PROCEDURE FindNgtRec 
            (    node    : Int32;              VAR ngt_rec : NgtRecType;               VAR result  : Int16 );      {}  { Description   {     Given the destination IP address of a node, this routine  {     will return the Ngt Entry for that network.   {}  { Parameters  {     node     IN       The IP address of a node.   "{     ngt_rec     OUT   The Ngt Record for the network that contains " {                             'node'.   {     result      OUT   The result of this operation:   {              ips_GOOD_RETURN    - Found the entry   {              ips_NGT_NOT_FOUND  - No such entry   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}  CONST      ADR_LEN = 2;       VAR      net   : AddressType;   	   error : Int16;  	     
BEGIN { FindNgtRec } 
 error := 0;   net.longint := GetNet (node);   DS_SerialFindAndFetchFields (DS_IP_Neigh_Gate_TD,                             MININT16,   { Start search index }                            MAXINT16,   { Stop search index  }                                 NO_OFSET,   { Offset in mask of key }    "                          ADR_LEN,    { Length of Network address }  "                           net.int,    { Address of network }      %                          NO_OFSET,         { Offset to key in structure } % &                          ngt_MAX_WORDS,    { Length of structure returned } & "                          ngt_rec.ngt_bufr, { Information returned } " $                          ngt_rec.ngt_index,{ Index of NGT entry rtn'd } $                           error);       IF error = ips_GOOD_RETURN THEN      BEGIN { IF found NGT entry }      result := ips_GOOD_RETURN;          { Set the Appropriate Next Hop in a housekeeping      { field     {}      IF ngt_rec.ngt_hopwd = NO_HOPS THEN            BEGIN { IF node in DCN }        ngt_rec.ngt_anh := node;        END   { IF node in DCN }          ELSE            BEGIN { ELSE node NOT in DCN }        ngt_rec.ngt_anh := ngt_rec.ngt_neighgate;         END;  { ELSE node NOT in DCN }         END   { IF found NGT entry }        ELSE          BEGIN { ELSE NGT entry NOT found }      result := ips_NGT_NOT_FOUND;      END;  { ELSE NGT entry NOT found }   
END;  { FindNgtRec } 
     
$TITLE 'FindPathRec',PAGE$ 
 {------------------------------------------------------------}  {              FindPathRec                                   }  {------------------------------------------------------------}  PROCEDURE FindPathRec              (VAR remote : Int32;               VAR local  : Int32;               VAR proto  : Int16;               VAR result : Int16 );       {}  {  Description  "{     This routine will look for a path record that has already been " {     allocated that matches the parameters passed into it.   {   {   {     global path record variable 'gv_path_rec'.  {}  {  Parameters   {     remote   IN       IP address of the remote machine.   ${     local    IN       IP address of the local machine (0 if S&F path). $ {     proto    IN       ULP PID (0 if S&F path).  {     result      OUT   Result of the search.   {   #{        ips_GOOD_RETURN    - The search succeeded and the path record # {                             is now in 'gv_path_rec'.  !{        ips_PATH_NOT_FOUND - The path record could not be found.  ! {}  
{  Global Data Structures  
 '{     gv_path_rec    OUT The global storage for the path record currently bein ' {                        being used.  {}  {  Algorithm  {     The path record is searched for in the following places   
{     in this order: 
 {   {        1) The global path record variable   {        2) DSAM  {}         CONST        SKEYLEN  = 6;     { Key Length used for path search }          TYPE         {}        {  Path Search Key        {}        PrSrchKyType  = RECORD           CASE Int16 OF                  0: (psk_bufr : BufferType );                  1: (psk_free_link : Int16;                  psk_remote    : Int32;                  psk_local     : Int32;                  psk_proto     : Int16 );                  END;  { PrSrchKyType }         VAR        searchkey : PrSrchKyType;         error     : Int16;         BEGIN { FindPathRec }         WITH searchkey, gv_path_rec DO         BEGIN { WITH GLOBAL Variables }         { Initialize the result         {}        error         := ips_GOOD_RETURN;             {}        { Is the local record the one desired?        {}        IF (pr_rec_status <> INVALID_DATA)  AND            (pr_remote     =  remote )       AND            (pr_local      =  local  )       AND            (pr_proto.int  =  proto  )       THEN               BEGIN { IF Path Rec is already fetched }            {}            { Nothing to be done, the record is found           {}            END   { IF Path Rec is already fetched }              ELSE                BEGIN { ELSE Path Rec may be in DSAM }            {}            { Post the current path if it was updated.            {}            SavePathState;                { Search for the Path among the active paths in DSAM            {}            psk_free_link := REC_INUSE;           psk_local     := local;           psk_remote    := remote;            psk_proto     := proto;               DS_SerialFindAndFetchFields (                 DS_IP_Path_Rec_TD, MININT16, MAXINT16,                  NO_OFSET, SKEYLEN, psk_bufr,                  NO_OFSET, pr_MAX_WORDS, pr_bufr, pr_pathref,                  error );                { Check the fetch from DSAM status            {}            IF error  = ips_GOOD_RETURN THEN                   BEGIN { IF Path Rec Found and Fetched }               {}              { The record index is already set in pr_pathref.              { Set the record status               { and return the good result.               {}              pr_rec_status := VALID_DATA;              END   { IF Path Rec Found and Fetched }                 ELSE                  BEGIN { ELSE Path Rec NOT found }               pr_rec_status := INVALID_DATA;              error         := ips_PATH_NOT_FOUND;              END;  { ELSE Path Rec NOT found }                END;  { ELSE Path Rec may be in DSAM }         END;  { WITH Global Variables }          {}      { Return the result to the caller     {}   
   result := error;  
    END;  { FindPathRec }      
$TITLE 'FindPidRec',PAGE$  
 {------------------------------------------------------------}  {              FindPidRec                                    }  {------------------------------------------------------------}  
PROCEDURE FindPidRec 
            (    proto  : Int16;               VAR result : Int16 );       {}  {  Description  #{     This routine will find the pid record given IP's protocol number # {     as a search key.  {   !{     If it is passed a protocol number of 0, then it returns the  ! {     Store and Forward Pidlist entry   {   #{     If it can't find an appropriate record, it will return an error  # {     in the result parameter.  {}  {  Parameters   {     proto    IN       The IP Protocol Number  "{     result      OUT   ips_GOOD_RETURN - 'proto' was valid and the  " %{                                         PidList record is in gv_pid_rec  % '{                       ips_PROTOCOL_UNKNOWN - the record could not be found.  ' {}  {  Side Effects   {}  
{  Global Data Structures  
 {     gv_pid_rec     OUT   will be set by this routine.   {}  	{  Error Handling  	 
{     see result parameter 
 {   {  Alogrithm  {     Memory manager calls are used to find the PidList entry.  {}     CONST  
      SF_PROTO = NO_PROTO; 
       SF_PIDREC = PidListRecType           [           pl_uppid     : IP,            pl_proto     : SF_PROTO,            pl_mpool_id  : SANDF,           pl_path_type : pr_UNREFED_CONNECTLESS,            pl_canadr    : CA_IP,           ];          VAR  
      index : Int16; 
 
      error : Int16; 
        BEGIN { FindPidRec }      error := 0;         IF proto = SF_PROTO THEN   
      BEGIN { IF S&F PID } 
 	      error := 0;  	       gv_pid_rec := SF_PIDREC;  
      END   { IF S&F PID } 
    ELSE         BEGIN { ELSE normal ULP }         DS_SerialFindAndFetchFields (DS_IP_Proto_Id_TD,   "                                MININT16, MAXINT16, pl_PROTO_OFSET,  " &                                pl_PROTO_LEN, proto, NO_OFSET, pl_MAX_WORDS, & !                                gv_pid_rec.pl_bufr, index, error); !           IF error <> ips_GOOD_RETURN THEN           BEGIN { IF Couldn't find entry }            error := ips_PROTOCOL_UNKNOWN;            END;  { IF Couldn't find entry }         END;  { ELSE normal ULP }       
   result := error;  
    END;  { FindPidRec }       $TITLE 'GetAnhRec',PAGE$  {------------------------------------------------------------}  {              GetAnhRec                                     }  {------------------------------------------------------------}  
PROCEDURE GetAnhRec  
             (    anh_adr : Int32;                    dnpid   : Int16;                    segsize : Int16;                VAR result  : Int16 );       {}  { Description   {     This routine will either find the appropriate ANH record   {     or it will allocate and initialize a new one based on the    {     ANH IP address passed in.   {}  { Parameters  {     anh_adr  IN       The IP address of the gateway to be   {                       used or the host on a DCN. This is the  ${                       IP address of the node that IP will request the  $ {                       LLP to deliver the message to.  {   "{     dnpid    IN       The LLP PID for the network belonging to the " {                       anh_adr.  {   ${     segsize  IN       The number of bytes IP is to use as the maximum  $ #{                       segmentation size for the underlying network.  # {   %{     result      OUT   ips_GOOD_RETURN - An ANH record has been returned  % {                                         suitable for use.   %{                       ips_ANH_NOT_ALLOC - A suitable ANH rec was neither % {                                         found nor allocated.  {}  { Side Effects  {     none  {}  	{ Global Variables 	  {     gv_anh_rec OUT    This variable is set as a result of this   {                       call to the Anh Record requested.   {}  { Error Handling  {     The only error that could be returned   {     is in the case of not having enough ANH records. This is   {     eliminated by having as many ANH records as path records.    {     Each Path record may have at most one ANH record.   {   "{     If this error does occur, the Anh Allocate routine will return " {     an error which this routine will pass along.  {}  { Algorithm   {  Regarding the desired ANH record:  {     1) If the dest net is unknown to IP,  {        always allocate a unique ANH record  {        (so the offered route can be recorded).  {     2) If it is already local, use it.  {     3) Look in DSAM and if there, use it.   {     4) Allocate a new one and initialize it.  {}         CONST        ah_SKEYLEN = 3;          VAR        searchkey : AhSrchKyType;         error     : Int16;         BEGIN { GetAnhRec }     WITH gv_anh_rec, searchkey DO        BEGIN { WITH Global Variables }         { Initialize the return }   	      error  := 0; 	       result := ips_GOOD_RETURN;            {}        { Is the destination Network Known to IP?         {}        IF anh_adr = NO_ANH_NODE THEN            BEGIN           { Destination Network is NOT known to IP }            { Must allocate a new record.            }            AllocAnhRec (result);           END   { IF anh_adr }             {}        { Is the Local Copy the one we want?        {}        ELSE IF (ah_anh = anh_adr)              AND                 (ah_rec_status <> INVALID_DATA) THEN               BEGIN           { Local Copy is the record we want.           { so Nothing further to be done.            {}            END   { ELSE IF ah_anh }             {}        { Is the an existing copy in DSAM?        {}        ELSE               BEGIN           { Must search through DSAM for the record           { Post current record if necessary            {}            SaveAnhState;               { Set up search keys            {}            ahsk_free_link := REC_INUSE;            ahsk_anh_adr   := anh_adr;                DS_SerialFindAndFetchFields (              DS_IP_ANH_REC_TD, MININT16, MAXINT16,               NO_OFSET, AH_SKEYLEN, ahsk_bufr,              NO_OFSET, ah_MAX_WORDS, ah_bufr, ah_index,  
            error);  
              ah_rec_status := VALID_DATA;                IF error <> ips_GOOD_RETURN THEN   	            BEGIN  	             {}  #            { Record was NOT found, and the current record is invalid. #             { The only thing left to do is allocate a new one               { from the free list.               {}              ah_rec_status := INVALID_DATA;                  AllocAnhRec (result);               ah_anh        := anh_adr;               ah_netpid     := dnpid;               ah_netsegsize := segsize;               UpdatedAnh;               END   { IF error }                ELSE      	            BEGIN  	             { Record was FOUND, Set the record status }               ah_rec_status := VALID_DATA;  
            END;  { ELSE } 
              END;  { ELSE Must search }             END;  { WITH Global Variables }      END;  { GetAnhRec }      $TITLE 'GetFrag',PAGE$  {------------------------------------------------------------}  {           GetFrag                                          }  {------------------------------------------------------------}      	PROCEDURE GetFrag  	            (    link : MbufIdType;              VAR frag : FragDescType);   {}  { Description   !{     This routine will read the fragment descriptor off the front ! {     of the fragment in the mbuf given by 'link'.  {     The fragment descriptor will be returned in 'frag'.   {}  { Parameters  {     link  IN       The mbufid of the fragment in question.  {    {     frag     OUT   The fragment descriptor associated with the   {                    fragment.  {}  	{ Global Variables 	 !{     gv_path_rec IN    The current path index is logged on error  ! {}  { Error Handling  !{  If any error is encountered, it will be logged and the EOL_FRAG ! 
{  will be returned. 
 {}  CONST   
   SUBR     = SubrGETFRAG; 
     VAR   	   error : Int16;  	 
   mmflags : MMFlagsType;  
     	BEGIN { GetFrag }  	 
{ Set initial values 
 {}  mmflags.int     := 0;   mmflags.bits[0] := TRUE;   { Preview the data }   error           := ips_GOOD_RETURN;       IF link <> END_OF_LIST THEN      BEGIN { IF not EOL }   "   DS_MRead (frag.bufr, FRAG_BLEN, link, NO_OFSET, mmflags, error);  "    frag.mbufid := link;      IF error <> ips_GOOD_RETURN THEN         BEGIN { IF error fetching desired frag descriptor }   
      WITH gv_path_rec DO  
          IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR);         frag := EOL_FRAG;         END;  { IF error fetching desired frag descriptor }      END   { IF not EOL }        ELSE          BEGIN { ELSE is EOL }  
   frag := EOL_FRAG; 
    END;  { ELSE is EOL }  	END;  { GetFrag }  	     $TITLE 'GetIpPath',PAGE$  {------------------------------------------------------------}  {              GetIpPath                                     }  {------------------------------------------------------------}  
PROCEDURE GetIpPath  
            (    remote  : Int32;                  local   : Int32;                  proto   : Int16;              VAR pathref : Int16;              VAR result  : Int16 );      {}  {  Description  {     This routine will either find, or build the path record   {     requested in DSAM and will return the path reference  
{     to the caller. 
 {     It will be used by the IFP.   {}  {  Parameters   {     remote   IN       The IP Address of the remote machine.   {     local    IN       The IP Address of the local machine.  {     proto    IN       The ULP PID on this path.   {     pathref     OUT   The reference to the path built.  {     result      OUT   The result of this operation.   {   ${           ips_GOOD_RETURN - A valid path reference is being returned.  $ !{           ips_PATH_NOT_AVAIL - No such path exists, and it could ! {                                    not be built.  {}  {  Side Effects   {     none  {}  
{  Global Data Structures  
 {     gv_path_rec    OUT  An IP path rec  {     gv_ip_globals  OUT  The IP global block   {}  {  Algorithm  "{     This routine will call GetPathRec and do the processing to see " "{     that the record is posted to DSAM if necessary and to pass the " {     appropriate parameters back to the caller.  {}  CONST      SUBR = SubrGETIPPATH;         BEGIN { GetIpPath }  "   { Initialize all global IP variables so they will be fetched from "    { DSAM.     { Then fetch the global block.      {}      result := 0;      ContextLost;      FetchGlobals;         { Fetch or build the path requested     {}      GetPathRec (remote, local, proto, result);          { Whether we have succeeded or failed, set the path rec.       { and let the 'result' be returned to the caller to indicate       { success or failure.     {}      pathref := gv_path_rec.pr_pathref;          IF result <> ips_GOOD_RETURN THEN        BEGIN { IF path rec not returned }        IpErrorLog (EL_RESOURCELIM, result, 0, SUBR);         END;  { IF path rec not returned }         { Save in DSAM any information that has changed.   "   { Ensure that all of the global IP variables are initialized such "    { that they must be fetched from DSAM to be used.     {}      SaveState;      ContextLost;      END;  { GetIpPath }      $TITLE 'GetNet',PAGE$   {------------------------------------------------------------}  {              GetNet                                        }  {------------------------------------------------------------}  FUNCTION  GetNet             (    ipadr : Int32) : Int32;       {}  { Description   "{     GetNet will take an IP address and extract the network number  " %{     from it, returning an IP address with the network address unchanged  % {     and the node number portion set to 0.   {}  { Parameters  ${     ipadr  IN      The IP address to extract the network number from.  $ {   ${     GetNet    OUT  The Network number corresponding to the IP address  $ {                       passed in.  {}  { Side Effects  {     none  {}  	{ Global Variables 	 {     None  {}  { Error Handling  {     The passed in value will fit one of the cases.  {}  { Algorithm   "{     This routine will check for each of the classes of IP address, " {     selecting the appropriate mask for ipadr.   {   "{     It will then AND this mask with the passed in value and return " {     it as the value of the function.  {   #{     A large portion of this routine is setting up the types so that  # {     the bits can be accessed as necessary.  {}         CONST  
      CLASS_A =  0;  
 
      CLASS_B = -2;  
 
      CLASS_C = -2;  
 
      CLASS_X = -1;  
       MASK_A  = octal ('37700000000');        MASK_B  = octal ('37777600000');        MASK_C  = octal ('37777777400');        MASK_X  = octal ('37777777777');         TYPE         IpNetAdrType = PACKED RECORD           CASE Int16 OF              0: (classA : PosInt1;                   pada   : Int15;                   wda2   : Int16);                  1: (classB : Int2;                  padb   : Int14;                   wdb2   : Int16);                  2: (classC : Int3;                  padc   : Int13;                   wdc2   : Int16);                  3: (classX : Int3;                  padx   : Int13;                   wdx2   : Int16);                  4: (bigint : Int32);  
            END;  { CASE } 
        VAR        word     : IpNetAdrType;        mask     : Int32;         int      : Int32;       
   BEGIN { GetNet }  
    word.bigint := ipadr;            {}        { Select the mask         {}     IF      word.classA = CLASS_A THEN mask := MASK_A     ELSE IF word.classB = CLASS_B THEN mask := MASK_B     ELSE IF word.classC = CLASS_C THEN mask := MASK_C     ELSE IF word.classX = CLASS_X THEN mask := MASK_X;         {}        { Use the mask to generate the output word        { and return the recsult        {}     GetNet := DiAnd (mask, word.bigint);       
   END;  { GetNet }  
     $TITLE 'GetNgtRec',PAGE$  {------------------------------------------------------------}  {              GetNgtRec                                     }  {------------------------------------------------------------}      
PROCEDURE GetNgtRec  
            (    ipadr  : Int32;               VAR result : Int16);      {}  { Description   !{     GetNgtRec will search for the record in the NGT that matches ! {     the network address passed in in the 'ipadr' parameter.   {   {     If an entry is not found in IP's tables, an error will  	{     be returned. 	 {}  { Parameters  !{     ipadr    IN       An IP address in the destination network.  ! "{                       The nodal address portion is ignored in this " {                       routine.  {   {     result      OUT   The result of the operation:  {   ${           ips_GOOD_RETURN   - The destination network is known and the $ {                               NGT record is in gv_ngt_rec.  {   ${           ips_DESTNET_UNKNOWN - The destination network is NOT known.  $ #{                               IP has no routing information for this # {                               network.  {}  	{ Global Variables 	 "{     gv_ngt_rec  OUT   This variable will be changed as a result of " "{                       this routine. It will contain the NGT record " "{                       requested or garbage, depending on the value " {                       of 'result'.  {}  { Algorithm   %{     1) The Network number will be extracted from the passed ip address.  % {     2) The NGT will be searched for this entry.   #{     3) The return parameters will be set according to the result of  # 
{        the search. 
 {}     CONST  "      SUBR = SubrGETNGT;       { Subroutine ID number for logging }  "     
      NETADRLEN = 2; 
 
      NO_GATE   = 0; 
        VAR        netadr : AddressType;         error  : Int16;          BEGIN { GetNgtRec }     WITH gv_ngt_rec DO         BEGIN { WITH Global Variables }   	      error := 0;  	       netadr.longint := GetNet (ipadr);             DS_SerialFindAndFetchFields (            DS_IP_NEIGH_GATE_TD, MININT16, MAXINT16,            NO_OFSET, NETADRLEN, netadr.int,            NO_OFSET, ngt_MAX_WORDS, ngt_bufr, ngt_index,           error);            { Set the Appropriate Next Hop in the variable        { and return to caller if no errors         {}        IF ngt_hopwd = NO_HOPS THEN                BEGIN  
         ngt_anh := ipadr; 
          END   { IF no hops to dest net }              ELSE                BEGIN           ngt_anh := ngt_neighgate;           END;  { ELSE have hops to dest net }             IF error <> ips_GOOD_RETURN THEN               BEGIN { IF NGT not found }            {}            { The NGT record was not found.           { The Destination Network is not known to IP's tables           {}            gv_ngt_rec := ngt_INIT_NGT_REC;               IpErrorLog (EL_ERROR, error, 0, SUBR);            error := ips_DESTNET_UNKNOWN;           END;  { IF NGT not found }             END;  { WITH Global Variables }       
   result := error;  
    END;  { GetNgtRec }      
$TITLE 'GetPathRec',PAGE$  
 {------------------------------------------------------------}  {              GetPathRec                                    }  {------------------------------------------------------------}      
PROCEDURE GetPathRec 
            (    remote : Int32;                   local  : Int32;                   proto  : Int16;               VAR result : Int16);      {}  {  Description   {     This routine will get a path record appropriate to process   {     messages based on the parameters passed in.   {   {     The result of this operation is returned in result.   {   {     GetPathRec is called when a path is needed either for   {     an INBOUND MESSAGE that has just arrived for processing   {     or for a SOCKET REGISTRY request where a path must be   {     built from a PATH REPORT.   {   {     This routine will ensure that the appropriate path is   {     set up if it is possible to do so.  {     It will first try to find the appropriate path record   {     from the active path records, failing that, it will   {     attempt to allocate one from the free path list and   
{     initialize it. 
 {}  {  Parameters   {   {     remote   IN       The IP address of the remote node for   "{                          all messages sent or received using this  " {                          path.  {   {     local    IN       The IP address of this local node   {                       or 0 if a Store and Forward Path.   {   {     proto    IN       The ULP to which this path record is  {                          bound. All messages sent or  {                          received on this path will be  {                          passed to or from this protocol.   {   {     result      out   The result of the operation.  {                          The possible values are:   {   {        ips_GOOD_RETURN       - The normal return. The   {                                path record has been set up.   {   {        ips_PATH_NOT_AVAIL    - A free path record could not   {                                be allocated.  {   {        ips_BAD_VNA_DOMAIN    - The VNA domain is not HPDSN  {   %{        ips_PATH_NOT_FOUND    - The requested path could not be supplied  % {   "{        ips_PROTOCOL_UNKNOWN  - The ULP referenced is unknown to IP " {}  
{  Global Data Structures  
 {     gv_path_rec       OUT    The path record set up by this   {                              routine.   {     gv_ip_globals  IN   {     gv_pid_rec        OUT   {     gv_ngt_rec        OUT   {}  {  Algorithm  {     1) Search for the appropriate path record among the   {        records currenlty in use. If an active path record   {        is found, copy it into the local global path record  {        variable and return with a GOOD_RETURN to the caller.  {   {     2) OR ... If an active path was not found, attempt to   {        allocate one from the free list. If the allocation   {        is successful, the path record variable will have  {        been initialized, and a GOOD_RETURN will be made to  
{        the caller. 
 {   {     3) OR ... If the allocate was not successful, the local   {        path record will be initialized, the record status   {        field set to INVALID_DATA and an error in result   {        will be returned to the caller.  {}     LABEL        99;   { Immediate Exit Point }         VAR        error     : Int16;        ngterror  : Int16;  
      clpath    : BOOLEAN; 
           PROCEDURE Exit;            BEGIN { Exit }   	         GOTO 99;  	          END;  { Exit }          BEGIN { GetPathRec }      error := 0;         { Find path record.     { IF found, return with record in gv_path_rec     {}      FindPathRec (remote, local, proto, error);      IF error = ips_GOOD_RETURN THEN Exit;         { Find the ULP proto number.      { Is it a legal ULP for IP?     {}      FindPidRec (proto, error);          IF error <> ips_GOOD_RETURN THEN         BEGIN { IF PID not found }        { Increment the statistic         { and return with the error to the caller.        {}        WITH gv_ip_globals.ipg_statistics DO           BEGIN { WITH }   &         ipgs_protounrch_packloss := DS_IncBt (ipgs_protounrch_packloss,1);  & 
         UpdatedIpg; 
          END;  { WITH }             Exit;         END;  { IF PID not found }      
   { Have a legal ULP PID  
    { Attempt to allocate a new path record     { IF successful allocation, return to caller      { with new path rec in gv_path_rec      {     { NOTE: gv_pid_rec required on allocate     {}      AllocPathRec (remote, local, error);      IF error = ips_GOOD_RETURN THEN Exit;         { Couldn't Allocate a new record,     { Attempt to ReAllocate an existing record   !   { Return the success or failure of this operation to the caller !    {     { NOTE: gv_pid_rec is required on entry     {}      ReAllocPathRec (remote, local, error);          {}      { Return the result to the caller.      {}      99:   { Immediate Return Point }   
   result := error;  
    END;  { GetPathRec }       $TITLE 'GetRcb',PAGE$   {------------------------------------------------------------}  {           GetRcb                                           }  {------------------------------------------------------------}      PROCEDURE GetRcb             (    link   : MbufIdType;              VAR rcb    : RcbType;               VAR result : Int16);  {}  { Description   {     Given the mbufid of the rcb in 'link', this routine will  {     return the RCB associated with that mbufid.   {}  { Parameters  {     link  IN       The mbufid of the desired RCB.   {     rcb      OUT   The RCB found in the mbuf.   {     result   OUT   The result of this operation.  {}  { Error Handling  {}  { Algorithm   {     A call to DS_MRead accomplishes the task.   {}  CONST       SUBR = SubrGETRCB;       { Subroutine ID number for logging }       VAR   
   mmflags : MMFlagsType;  
     BEGIN { GetRcb }  result           := 0;  mmflags.int      := 0;    { Clear all flags }   mmflags.bits [0] := TRUE; { Copy, don't delete RCB }      "DS_MRead (rcb.rcb_bufr, RCB_BLEN, link, NO_OFSET, mmflags, result);  " rcb.rcb_mbufid    := link;    { Mbufid of fetched rcb    }      IF result <> ips_GOOD_RETURN THEN          BEGIN { IF Error reading RCB }      { This should never happen }      { If it does, it means that IP's internal structures      { contain invalid information.      {}      IpErrorLog (EL_DISASTER, result, link, SUBR);     rcb := READ_FAIL_RCB;     END;  { IF Error reading RCB }       END;  { GetRcb }          $TITLE 'IcmpErrorLog',PAGE$   {------------------------------------------------------------}  {           IcmpErrorLog                                     }  {------------------------------------------------------------}      PROCEDURE IcmpErrorLog             (    location : Int16;                   eventtype: Int16;                   ictype   : Int16;                   iccode   : Int16;                   dest     : Int32;                   reporter : Int32;                   altgate  : Int32 );       {}  { Description   {     This routine will log as an error, the information from   {     an ICMP message that has just been received.  {   {}  { Parameters  {     location    IN    The location indicator to log   &{     eventtype   IN    EL_WARNING - An informational ICMP message was recvd & ${                       EL_ERROR   - A message failed to reach its dest. $ {     ictype      IN    The ICMP message type   {     iccode      IN    The ICMP message code   ${     dest        IN    The IP address of the original destination node  $ ${     reporter    IN    The IP address of the originator of the ICMP msg $ #{     altgate     IN    The Alternate gateway to use if a REDIRECT msg # {   {   {   {}  { Error Handling  {}  { Algorithm   {   {}  { Message buffer format:  {   {     ( IP addresses in 2 word decimal format )   {   {     <error code> <dest / IP> <reporting / IP> <alt / gate>  {}  CONST      ECODE         = 1;      DESTNODE      = 1;      REPORTINGNODE = 2;      ALTGATENODE   = 3;       $   MINLENGTH     = 5;      { Length of message to log w/o REDIRECT's   } $ $                           {  alternate gateway                        } $ $   MAXADDRS      = 3;      { Max number of IP addresses in message     } $     TYPE     IntArrayType = ARRAY [1..MINLENGTH+2] OF Int16;         LogEventBufrType = RECORD CASE Int16 OF        0: (bufr     : Int16);        1: (int      : Int16;             ipaddrs  : ARRAY [1..MAXADDRS] OF Int32);         2: (ints     : IntArrayType);         END;  { LogEventBufrType }      CONST   #   CLEARMSG = LogEventBufrType [ints : IntArrayType [0,0,0,0,0,0,0]];  #     VAR      msg   : LogEventBufrType;  	   error : Int16;  	 
   context : ContextWords; 
    msglength : Int16;       BEGIN { IcmpErrorLog }  msglength                   := MINLENGTH;       msg                         := CLEARMSG;  msg.ipaddrs [DESTNODE]      := dest;  msg.ipaddrs [REPORTINGNODE] := reporter;  msg.ipaddrs [ALTGATENODE]   := altgate;       context.ints [1]            := ictype;  context.ints [2]            := iccode;      CASE ictype OF     ECHO_REPLY:                      error := ips_ECHO_REPLY;         DEST_UNREACH:  
      CASE iccode OF 
          NETWORK_UNREACH:           error := ips_NET_UNREACH;            HOST_UNREACH:              error := ips_HOST_UNREACH;            PROTOCOL_UNREACH:          error := ips_PROTO_UNREACH;             PORT_UNREACH:              error := ips_PORT_UNREACH;           FRAG_NEEDED_DF_SET:        error := ips_FRAG_BUT_DF;            SOURCE_ROUTE_FAILED:       error := ips_SRC_ROUTE;             OTHERWISE                  error := ips_BAD_ICMP_CODE;             END;  { DEST_UNREACH }          SOURCE_QUENCH:                   error := ips_SRC_QUENCH;         REDIRECT:        BEGIN { REDIRECT }  $      msglength := msglength + 2;   { Allow for the alternate gateway }  $ 
      CASE iccode OF 
          NETWORK_REDIRECT:          error := ips_NET_REDIRECT;            HOST_REDIRECT:             error := ips_HOST_REDIRECT;    !         TOSNET_REDIRECT:           error := ips_TOS_NET_REDIRECT; ! "         TOSHOST_REDIRECT:          error := ips_TOS_HOST_REDIRECT;  "           OTHERWISE                  error := ips_BAD_ICMP_CODE;    
         END;  { iccode }  
       END;  { REDIRECT }         ECHO_REQUEST:                    error := ips_ECHO_REQUEST;      	   TIME_EXCEEDED:  	 
      CASE iccode OF 
          TTL_EXPIRED:               error := ips_Transit_TTL;            REASS_EXPIRED:             error := ips_Reass_TTL;             OTHERWISE                  error := ips_BAD_ICMP_CODE;             END;  { TIME_EXCEEDED }         OPTIONS_PRAM_PROB:               error := ips_PRAM_PROB;          TIMESTAMP_REQUEST:               error := ips_TS_REQUEST;         TIMESTAMP_REPLY:                 error := ips_TS_REPLY;         INFO_REQUEST:                    error := ips_INFO_REQUEST;         INFO_REPLY:                      error := ips_INFO_REPLY;          OTHERWISE                        error := ips_BAD_ICMP_TYPE;           END;  { CASE ictype }         msg.ints[ECODE] := error;      IF gv_ip_globals.ipg_debug.bits[-2] = 1 THEN     BEGIN { IF logging errors }  &   Log_Event (eventtype, IP, location, context, msglength, msg.bufr, error); &    END;  { IF logging errors }      END;  { IcmpErrorLog }      $TITLE 'IpBufrLog',PAGE$  {------------------------------------------------------------}  {           IpBufrLog                                        }  {------------------------------------------------------------}      
PROCEDURE IpBufrLog  
            (    bufrtype : Int16;                   location : Int16;               VAR bufr     : Int16;                   blen     : Int16);      {}  { Description   #{     This routine will log, via Log_Event, a buffer with some context # "{     information in it. It is used to convey status information and " #{     additional context thought to be useful to further understanding # {     of some error messages.   {     It is a protocol specific log.  {   {}  { Parameters   {     bufrtype    IN    The indentifier that indicates the type    {                       of buffer that is being logged.    {                       This information will show itself in the   {                       path record field.  {                       (See the ipl_@ constants in IPDEC)  !{     location    IN    The Subroutine + offset where this occurs  ! {     bufr        IN    The buffer to log   {     blen        IN    The byte length of the buffer.  {}  VAR   
   error   : Int16;  
 
   context : ContextWords; 
 
   wlen    : Int16;  
     
BEGIN { IpBufrLog }  
     IF gv_ip_globals.ipg_debug.bits[-1] = 1 THEN     BEGIN { IF logging emsgs  }     context.longint := bufrtype;      wlen := (blen + 1) DIV 2;  "   Log_Event (EL_PROLOG, IP, location, context, wlen, bufr, error);  "    END;  { IF logging emsgs  }      
END;  { IpBufrLog }  
     $TITLE 'IpEmsgLog',PAGE$  {------------------------------------------------------------}  {           IpEmsgLog                                        }  {------------------------------------------------------------}      
PROCEDURE IpEmsgLog  
            (VAR emsg      : EventMsgType;                   location  : Int16);       {}  { Description   ${     This routine will log, via Log_Event, an event message received by $ ${     IP. It is to be used immediately following the EnterCritical call  $ {     just after IP is called by PROSW.   {}  { Parameters  {     emsg        IN    The event message to be logged.   #{                       This is a VAR parameter to avoid extra copies  # {                       being made of this variable.   {     location    IN    The Subroutine ID + routine offset code    {}  VAR   
   error   : Int16;  
 
   context : ContextWords; 
     
BEGIN { IpEmsgLog }  
     IF gv_ip_globals.ipg_debug.bits[-3] = 1 THEN     BEGIN { IF logging emsgs  }     context.longint := 0;     Log_Event (EL_EVENT, IP, location, context, EMSG_WORD_LEN,                                                   emsg.int, error);      END;  { IF logging emsgs  }      
END;  { IpEmsgLog }  
     
$TITLE 'IpErrorLog',PAGE$  
 {------------------------------------------------------------}  {           IpErrorLog                                       }  {------------------------------------------------------------}      
PROCEDURE IpErrorLog 
            (    eventtype : Int16;                  ecode     : Int16;                  pathref   : Int16;                  location  : Int16);       {}  { Description   !{     This routine will log, via Log_Event, an error message from  ! #{     IP. It is to be used with WARNINGs, ERRORs, and DISASTERs only.  # {}  { Parameters  {     eventtype   IN    EL_WARNING  #{                          Something MAY BE wrong and should be looked # {                             into.   {                          WARNING IS NOT CURRENTLY USED.   {   {                       EL_ERROR  ${                          Something IS wrong, but recovery is possible  $ {                       EL_DISASTER   !{                          Something IS VERY wrong, and NS should  ! {                             probably be shut down   {     ecode       IN    The error code to be logged    {     pathref     IN    The path reference (if any) associated.     {     location    IN    The Subroutine ID + routine offset code    {}  { Global Data Structures  {     gv_ip_globals  IN/OUT   For statistics  {}  { Error Handling  ${     Each time this routine is called, a global counter is incremented. $ &{     Errors on sends will be ignored as there is nothing that can be done.  & {}  CONST      ONE_WORD = 1;      VAR   
   error   : Int16;  
 
   context : ContextWords; 
     
BEGIN { IpErrorLog } 
 WITH gv_ip_globals.ipg_statistics DO     BEGIN { WITH global statistics }          { Count the message, allowing for roll over     {}   
   CASE eventtype OF 
        EL_ERROR:      ipgs_error    := DS_IncBt (ipgs_error, 1);    !      EL_DISASTER:   ipgs_disaster := DS_IncBt (ipgs_disaster, 1); !       OTHERWISE         END;  { CASE eventtype }     UpdatedIpg;         IF gv_ip_globals.ipg_debug.bits[-2] = 1 THEN         BEGIN { IF logging errors }         context.longint := pathref;   &      Log_Event (eventtype, IP, location, context, ONE_WORD, ecode, error);  &       END;  { IF logging errors }          END;  { WITH global statistics }   
END;  { IpErrorLog } 
         $TITLE 'IpKillLog',PAGE$  {------------------------------------------------------------}  {           IpKillLog                                        }  {------------------------------------------------------------}      
PROCEDURE IpKillLog  
            (VAR emsg     : EventMsgType;                  location : Int16);  {}  { Description   "{     This routine logs any KILL_INDICATION event messages generated " {     by IP.  {   {     The event message is logged.  {   {}  { Parameters  {     emsg     IN    The event message to be logged.  {     location IN    The location of the logging call.  {}  { Global Data Structures  {  gv_ip_globals  IN/OUT  For statistics  {  gv_path_rec    IN      Path reference for log  {}  CONST   !   KILL_WORD_LEN = 5;   { Length in words of the Kill_Indication } !     VAR   	   result : Int16; 	 
   context : ContextWords; 
     
BEGIN { IpKillLog }  
 WITH gv_ip_globals.ipg_statistics, gv_path_rec DO      BEGIN { WITH global statistics }          { Count the message, allowing for roll over     {}      ipgs_kill := DS_IncBt (ipgs_kill, 1);     UpdatedIpg;         IF gv_ip_globals.ipg_debug.bits[-2] = 1 THEN         BEGIN { IF error logging turned on }        context.longint := pr_pathref;        Log_Event (EL_ERROR, IP, location, context,   #                                     KILL_WORD_LEN, emsg.int, result); #       END;  { IF error logging turned on }     END;  { WITH global statistics }   
END;  { IpKillLog }  
     $TITLE 'KillRoute',PAGE$  {------------------------------------------------------------}  {           KillRoute                                        }  {------------------------------------------------------------}      
PROCEDURE KillRoute  
            (    dnpid   : Int16;                  dnpath  : Int16;                  upcount : Int32;                  dncount : Int32);       {}  { Description    {     This routine will generate a kill request to the LLP Path    {     indicated with the counts provided.   {}  { Parameters  #{     dnpid    IN    PID of LLP to which the message will be sent to.  # {     dnpath   IN    LLP's path reference to be killed.   {     upcount  IN    # messages received from LLP   {     dncount  IN    # messages sent to LLP   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}  LABEL      99;   { Immediate return point }       CONST      SUBR = SubrKILLROUTE;      VAR   	   error : Int16;  	     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
BEGIN { KillRoute }  
 
WITH gv_send_emsg DO 
    BEGIN { WITH global emsg }      error := 0;         {  If there is nothing to do, return immediately.     {     i.e.  1) No Down PID/Path     {           2) No emsg counts to be killed      {}      IF (dnpid  = 0) OR         (dnpath = 0)      THEN Exit;         IF (upcount = 0) AND         (dncount = 0)     THEN Exit;         em_event := KILL_REQUEST;     ehport   := BuildPort (dnpid, EHOB_OFFSET);     emkr_down_ref := dnpath;      emkr_msg_rcv_cnt := upcount;      emkr_msg_snd_cnt := dncount + 1;          SaveState;      IF gv_gocrit_error = 0 THEN DS_LeaveCritical (gv_wkmap);          ProSw (gv_send_emsg, error);      ContextLost;      DS_EnterCritical (gv_wkmap, gv_gocrit_error);         { Post the ProSw error return if any, before proceeding     { and then save the EnterCritical error     {}   #   IF error <> 0 then IpErrorLog (EL_ERROR, error, 0, SUBR+PROSWFAIL); #    error := gv_gocrit_error;         IF error <> 0 THEN         BEGIN { IF couldn't go critical }         IpErrorLog (EL_DISASTER, error, 0, SUBR+GOCRITFAIL);        END;  { IF couldn't go critical }          FetchGlobals;         END;  { WITH global emsg }       99:   { Immediate Exit Point }  
END;  { KillRoute }  
     
$TITLE 'LinkPathRec',PAGE$ 
 {------------------------------------------------------------}  {              LinkPathRec                                   }  {------------------------------------------------------------}         PROCEDURE LinkPathRec                (VAR que_head : Int16);       {}  {  Description  !{     LinkPathRec is used to link the path record onto one of the  ! #{     in gv_path_rec onto one of the processing queues (Control Queue  # {     or Active Queue) with a list head in gv_ip_globals.   {   #{     This procedure assumes that the record is either already linked  # !{     on the desired queue or that it is not linked on any queue.  ! "{     If the record is already linked on the desired queue, nothing  " 	{     is changed.  	 {   #{     This routine is called by StatesLink and is used in conjunction  # 
{     with UnLinkPathRec.  
 {}  {  Parameters   {   #{     que_head IN/OUT      The list head, a field of the gv_ip_globals # {                          variable. It may be either:  {   ${                             ipg_pr_cntl_que    or ipg_act_out_pr_que.  $ {}  {  Side Effects   {     none  {}  
{  Global Data Structures  
 {   ${     gv_path_rec IN/OUT  This is the path record to be linked onto the  $ #{                         appropriate queue. If it needs to be linked  # ${                         onto the queue, it will be added to the head.  $ {}  	{  Error Handling  	 {     There are no error cases.   {}  {  Algorithm  "{     The queue to link the path record on is searched to see if the " {     record is already linked on it.   {     If so, processing is complete.  #{     Otherwise, the path record is linked onto the head of the queue. # {   #{     This routine does not update DSAM, that is left to be done when  # {     these records are posted to DSAM.   {}      VAR         { List linkage storage variable         {}     que_linkage : Int16;          BEGIN { LinkPathRec }     WITH gv_path_rec DO        BEGIN { WITH Global Variables }         que_linkage := que_head;            WHILE (que_linkage <> pr_pathref ) AND              (que_linkage <> END_OF_LIST)    DO               BEGIN { WHILE }           DS_FetchFields (DS_IP_Path_Rec_TD,                  que_linkage, que_linkage,                 pr_ACTLINK_OFSET, ONE_WORD);            END;  { WHILE }            IF que_linkage = END_OF_LIST THEN                BEGIN { Path Not Yet Linked in }            {}            { Link it onto the head of the queue            {}            pr_active_link := que_head;           que_head := pr_pathref;  !         UpdatedIpg;       { The globals block has been UPDATED }  !           UpdatedPr;        { The path record has been UPDATED }             END   { Path Not Yet Linked in }              ELSE                BEGIN { Path already linked }  
         { Simply Return } 
          END;  { Path already linked }            END;  { WITH Global Variables }      END;  { LinkPathRec }      $TITLE 'LkClPath',PAGE$   {------------------------------------------------------------}  {              LkClPath                                      }  {------------------------------------------------------------}      
PROCEDURE LkClPath;  
     {}  {  Description  {     This routine will link the path record currently in the   {     'gv_path_rec' global variable onto the clpath list.   {}  {  Parameters   {     none  {}  {  Side Effects   {   {}  
{  Global Data Structures  
 {     gv_path_rec    IN/OUT   Linked onto the list  {     gv_ip_globals  IN/OUT   Contains the list head  {}  	{  Error Handling  	 {     none  {}  {  Algorithm  {     The global path record is linked onto the head of the   !{     clpath list and the number of Connectionless paths inuse is  ! #{     incremented only if this is an Unreferenced Connectionless path. # %{     These are paths to which no ULP has a reference ever, and therefore  % {     may be deallocated at any time required by IP.  "{     Store and Forward paths are the typical example of such paths. " {}         BEGIN { LkClPath }      WITH gv_ip_globals, gv_path_rec DO         BEGIN { WITH Global Variables }             pr_cl_link := ipg_clpath_list;        ipg_clpath_list := pr_pathref;            IF pr_path_type = pr_UNREFED_CONNECTLESS THEN            BEGIN { IF unreferenced connectionless path }  $         { Count the number of unreferenced connectionless paths inuse.  $ !         { There is a pool of paths reserved for this type of path !          { to allow store and forward traffic to always go           { through a busy node.            {}            ipg_clcnt.inuse := ipg_clcnt.inuse + 1;           END;  { IF unreferenced connectionless path }            UpdatedPr;  	      UpdatedIpg;  	           END;  { WITH Global Variables }      END;  { LkClPath }       
$TITLE 'LkPathToAnh',PAGE$ 
 {------------------------------------------------------------}  {              LkPathToAnh                                   }  {------------------------------------------------------------}      PROCEDURE LkPathToAnh;      {}  { Description    {     This routine takes care of linking the Path record and the   {     Anh Record in the global variables together.  {     It assumes that they are not yet linked.  {   {     They need to be linked in the following fields:   {    {        The path record must be added to the list of path recs    {        queued off of this ANH record.   {   {        The index of the Anh record must be put into the path  {        record.  {}  { Global Data Structures  {     gv_path_rec IN/OUT  {     gv_anh_rec  IN/OUT  {}         BEGIN { LkPathToAnh }     WITH gv_path_rec, gv_anh_rec DO        BEGIN { WITH Global Variables }         {}  "      { Link the Path record to the head of the list of path records "       { on this ANH record.         {}        pr_anh_link := ah_pr_link;        ah_pr_link  := pr_pathref;            pr_anh_idx  := ah_index;             { Mark these data structures as requiring posting to DSAM          {}  	      UpdatedAnh;  	       UpdatedPr;            END;  { WITH Global Variables }      END;  { LkPathToAnh }      $TITLE 'LocalAddress',PAGE$   {------------------------------------------------------------}  {              LocalAddress                                  }  {------------------------------------------------------------}  FUNCTION  LocalAddress             (    address : Int32) : BOOLEAN;       {}  { Description   #{     This function tests an IP address to see if it is one of the IP  # {     addresses of the local machine.   {   !{     It returns the BOOLEAN result as the value of the function.  ! {}  { Parameters  &{     address     IN     The IP address to be tested for being an address of & {                        the local machine.   {   #{     LocalAddress   OUT The value of the function will be TRUE if the # ${                        address IS an address of the local machine and  $ {                        FALSE otherwise.   {}  {  Side Effects   {     none  {}  
{  Global Data Structures  
 ${     LipadList      This table in DSAM contains all of the IP addresses $ {                    for this local node.   {}  	{  Error Handling  	 {}  {  Algorithm  !{     A Serial Search is done of the list of IP addresses of this  ! 
{     local machine. 
 {}         CONST        ADDR_LENGTH = 2;         VAR  
      index : Int16; 
       ipadr : LipadType;  
      error : Int16; 
     
   BEGIN { LocalAddress }  
    ipadr.lpd_addr := address;          DS_SerialFindAndFetchFields (        DS_IP_Local_Addrs_TD,   	      FIRST_ENTRY, 	 	      LAST_ENTRY,  	       NO_OFSET,   	      ADDR_LENGTH, 	       ipadr.lpd_bufr,         NO_OFSET,   	      ADDR_LENGTH, 	       ipadr.lpd_bufr,         index,        error );         IF error = ips_GOOD_RETURN THEN        BEGIN { IF Found }        LocalAddress := TRUE;         END   { IF Found }          ELSE            BEGIN { ELSE NOT Found }        LocalAddress := FALSE;        END;  { ELSE NOT Found }      
   END;  { LocalAddress }  
     $TITLE 'NextIpID',PAGE$   {------------------------------------------------------------}  {              NextIpID                                      }  {------------------------------------------------------------}      	FUNCTION NextIpID  	            (VAR dlen : Int16) : Int16;      {}  { Description   {     This function will allocate the next IP Identifier and  {     return it as the value of the function.   {}  { Parameters  {     dlen  IN    The length of the data in this message.   "{                 It is passed to the debug IP ID Increment routine  " #{                 and is for additional information to allow selective # ${                 ID Incrementing for testing Reassembly/Fragmentation.  $ {}  { Global Data Structures  "{     gv_ip_globals  IN/OUT   The current identfier is obtained from " "{                             the global block, and then the global  " !{                             block is updated to contain the next ! {                             identifier.   {}  { Error Handling  {     none  {}  { Algorithm    {     The IP message identifier is kept in the IP global block.     {     The next one is obtained by incrementing the current value   {     and returning it.   {   "{     The increment is done with roll around. All values are valid.  " {}         BEGIN { NextIpID }      WITH gv_ip_globals DO        BEGIN { WITH Global Variables }            BEGIN { No Triggers, always increment }           ipg_ip_id := ipg_ip_id + 1;           NextIpID  := ipg_ip_id;  
         UpdatedIpg; 
          END;  { IF Increment is turned on }        END;  { WITH Global Variables }      END;  { NextIpID }       $TITLE 'OffReassTimer',PAGE$  {------------------------------------------------------------}  {           OffReassTimer                                    }  {------------------------------------------------------------}      PROCEDURE OffReassTimer;      {}  { Description   {     This procedure will turn off the Reassembly timer, no   {     matter what its current state.  {   {}  { Parameters  {     none  {}  { Side Effects  {}  { Global Data Structures  {     gv_ip_globals  IN/OUT   {}  { Error Handling  {}  { Algorithm   {   {}  VAR   	   error : Int16;  	     BEGIN { OffReassTimer }   WITH gv_ip_globals DO     BEGIN { WITH globals }     IF ipg_reass_tmrid.index <> ip_TIMER_OFF THEN        BEGIN { IF timer is running }         CancelTimer (ipg_reass_tmrid, error);         { Ignore error return }         END;  { IF timer is running }          ipg_reass_tmrid.index  := ip_TIMER_OFF;     ipg_reass_expire := TimeOfDay;      UpdatedIpg;    END;  { WITH globals }  END;  { OffReassTimer }       $TITLE 'PostFrag',PAGE$   {------------------------------------------------------------}  {           PostFrag                                         }  {------------------------------------------------------------}      	PROCEDURE PostFrag 	            (VAR frag : FragDescType);       {}  { Description   !{  Given a fragment desciptor, this routine will write it back to  ! {  DSAM to the mbufid given by frag.mbufid.   {}  { Parameters  {     frag     IN    The fragment descriptor to be posted.  {}  { Error Handling  "{     If there are any errors in this routine, they will be logged.  " {}  CONST      SUBR = SubrPOSTFRAG;       VAR   	   error : Int16;  	     	BEGIN { PostFrag } 	 "DS_MBOverWrite (frag.bufr, FRAG_BLEN, frag.mbufid, NO_OFSET, error); "     IF error <> ips_GOOD_RETURN THEN     BEGIN { IF error on post }      IpErrorLog (EL_DISASTER, error, 0, SUBR);     END;  { IF error on post }       	END;  { PostFrag } 	     $TITLE 'PostRcb ',PAGE$   {------------------------------------------------------------}  {           PostRcb                                          }  {------------------------------------------------------------}      	PROCEDURE PostRcb  	            (VAR rcb : RcbType );      {}  { Description   !{     This routine will see that the RCB gets written back out to  ! {     the mbuf in DSAM where it was taken from.   {}  { Parameters  {     rcb      IN    The RCB to post to DSAM.   {}  { Error Handling  {     An error will be logged if this post fails.   {     This would be a severe error  {     and should never happen.  {}  CONST       SUBR = SubrPOSTRCB;      { Subroutine ID number for logging }       VAR   	   error : Int16;  	     	BEGIN { PostRcb  } 	 %DS_MBOverWrite (rcb.rcb_bufr, RCB_BLEN, rcb.rcb_mbufid, NO_OFSET, error);  %     IF error <> ips_GOOD_RETURN THEN     BEGIN { IF error on post to DSAM }      { Log the error return but ignore it otherwise }      { This is a severe error that should never happen }     IpErrorLog (EL_DISASTER, error, rcb.rcb_pathref, SUBR);     END;  { IF error on post to DSAM }       	END;  { PostRcb  } 	     $TITLE 'PutIcmpInDSAM',PAGE$  {------------------------------------------------------------}  {           PutIcmpInDSAM                                    }  {------------------------------------------------------------}      PROCEDURE PutIcmpInDSAM              (VAR iphead      : IpHeaderType;                   ipheadlen   : Int16;              VAR icmphead    : IcmpHeadType;                   icmphdlen   : Int16;              VAR icmpdata    : IpHeaderType;                   icmpdatalen : Int16;              VAR mbufid      : MbufIdType;               VAR result      : Int16 );      {}  { Description   {     This routine will put the ICMP message into DSAM.    {     It builds it out of three parts given from the parameters.   {   !{     It will use IP's socket for memory accounting purposes when  ! "{     putting this new message into DSAM, and if there is some kind  "  {     of an error, it will return that indication to the caller.   {}  { Parameters  !{     iphead      IN       The IP header used to send the message  ! {     ipheadlen   IN       The length of the IP header  {     icmphead    IN       The ICMP header for this message   {     icmphdlen   IN       The length of the ICMP header  #{     icmpdata    IN       The ICMP data (old IP header in this case)  # {     icmpdatalen IN       The length of the ICMP data  {     mbufid         OUT   The mbufid of the message in DSAM  {     result         OUT   The result of the operation  {                          0 = Good return  "{                          else = bad return. The message could not  " {                                 be put into DSAM.   #{                                 This will typically be a MMGR error. # {   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}      CONST   	   VLEN_WORDS = 6; 	    VLEN_BYTES = VLEN_WORDS * 2;          TAP_GENERAL_POOL = 0;     ALLOC_MACCT      = 2;      VAR   
   ip_gsd  : Int16;  
 
   mmflags : MMFlagsType;  
 
   maxchar : Int16;  
 
   error   : Int16;  
 
   vbuf    : RECORD  
 
      CASE Int16 OF  
          0: (vector : VectoredDataType);           1: (ints   : ARRAY [1..VLEN_WORDS] OF Int16);           END;  { vbuf }       BEGIN { PutIcmpInDSAM }   error := 0;       { Set up the data vector  {}  AdrOf (iphead.iphd_bufr, NO_OFSET, vbuf.ints[1]);   
vbuf.ints[2] := ipheadlen; 
 AdrOf (icmphead.bufr, NO_OFSET, vbuf.ints[3]);  
vbuf.ints[4] := icmphdlen; 
 AdrOf (icmpdata.iphd_bufr, NO_OFSET, vbuf.ints[5]);   vbuf.ints[6] := icmpdatalen;      { Set up for the put into DSAM  {}  mmflags.int := TAP_GENERAL_POOL + ALLOC_MACCT;  
maxchar := MAXINT16; 
 DS_FetchElement (DS_TrackTd, TL_IP_SOCKET, ip_gsd);       DS_SBPut (vbuf.vector,            VLEN_BYTES,             2 * ip_gsd,   	          mmflags, 	 	          mbufid,  	 	          maxchar, 	 	          error ); 	     IF error <> ips_GOOD_RETURN THEN         BEGIN { IF error on post }      mbufid := NO_MBUFID;      END;  { IF error on post }       result := error;  END;  { PutIcmpInDSAM }       $TITLE 'QueueMsgOnSendQue',PAGE$  {------------------------------------------------------------}  {              QueueMsgOnSendQue                             }  {------------------------------------------------------------}  PROCEDURE QueueMsgOnSendQue              (    mbufid : MbufIdType);       {}  { Description    {     This routine will take the IP message header refered to by   {     mbufid, and link it onto the Outbound message   {     queue of the path record in gv_path_rec.  {   !{     It uses the checksum word of the IP header for the link word ! ${     since this word is not used until the message is ready to be sent. $ {   "{     It does not require that this message be in DSAM, but it does  " !{     require that the checksum word of the message be 0'd before  ! {     entry into this routine.  {}  { Parameters  !{     mbufid   IN    The mbufid of the message to be put onto the  ! {                    outbound message queue.  {}  { Side Effects  {   {}  { Global Data Structures  #{     gv_path_rec IN/OUT   The path record that contains the Outbound  # {                          message queue's list head.   {}  { Error Handling  {     none  {}  { Algorithm   "{     The IP header is linked (via its checksum word) at the tail of " !{     the Outbound Message queue with its list head in the current ! 	{     path record. 	 {   #{     The message is linked to the last message on this queue in DSAM, # {     but the message itself need not be in DSAM.   #{     The caller must set the checksum word of the header being linked # {     in to END_OF_LIST (0).  {   {     The path will also be set to the SEND_DATA state.   {}         CONST        SUBR      = SubrQUEMSGONSEND; { Subroutine ID }   
      TWO_BYTES = 2; 
        VAR        error   : Int16;        msglink : RECORD           CASE Int16 OF              0: (int  : Int16     );               1: (bufr : BufferType);               END;  { msglink type }         BEGIN { QueueMsgOnSendQue }     WITH gv_path_rec, gv_ip_head DO        BEGIN { WITH Global Data Structures }   	      error := 0;  	           IF mbufid <> NO_MBUFID THEN            BEGIN { IF have message to queue }                IF pr_out_tail <> END_OF_LIST THEN               BEGIN { IF have messages queued }               msglink.int := mbufid;      !            DS_MBOverWrite (msglink.bufr, TWO_BYTES, pr_out_tail,  !                                   iphd_CKSUM_BOFSET, error);              END;  { IF have messages queued }                IF error = ips_GOOD_RETURN THEN                  BEGIN { IF new mbufid successfully linked in }              pr_out_tail := mbufid;  $            IF pr_out_que = END_OF_LIST THEN pr_out_que := pr_out_tail;  $             pr_states := pr_states + [ast_SEND_DATA];               UpdatedPr;              StatesLink;               END   { IF new mbufid successfully linked in }                ELSE                  BEGIN { IF new message NOT linked in }              { Report the trouble, and drop the message              {}              IpErrorLog (EL_ERROR, error, mbufid, SUBR);               DropMessage (mbufid);               END;  { IF new message NOT linked in }               END;  { IF have message to queue }         END;  { WITH Global Data Structures }      END;  { QueueMsgOnSendQue }      $TITLE 'RcbLink',PAGE$  {------------------------------------------------------------}  {           RcbLink                                          }  {------------------------------------------------------------}      	PROCEDURE RcbLink  	            (    timeout    : Int16;               VAR rcb        : RcbType;               VAR backref    : MbufIdType;              VAR result     : Int16);      {}  { Description   !{     This routine will link the RCB passed in onto the queue with ! {     list head in the ip global block.   {   {     The RCBs are linked in order of timeout.  {     All the RCBs for the system are linked onto this list.  {}  { Parameters  #{     timeout     IN       The number of seconds before this RCB is to # {                             time out.   #{     rcb         IN/OUT   The rcb that is to be linked onto the list. # {     backref        OUT   The MbufId of the previous RCB.  {     result         OUT   The result of this operation.  {}  { Side Effects  {}  { Global Data Structures  #{     gv_ip_globals     IN/OUT  The Ip global block that contains the  # {                               reassembly queue list head.   {}  { Error Handling  {}  { Algorithm   ${     The Rcbs are linked in order of timeout time, the soonest to time  $ #{     out is first. Each Rcb contains the incremental timeout time for # {     the next in the list.   {}  LABEL      99;   { Error Exit point }       CONST      SUBR = SubrRCBLINK;     MAX_REASS_TIME = 9 * 60 * 60;  { 9 hours of seconds }      TYPE     ContextType = RECORD CASE Int16 OF         0: (longint : Int32);         1: (int     : Int16);         2: (mbufid  : MbufIdType);        END;  { ContextType }       VAR   &   temp_rcb : RcbType;  { RCB storage for elements on the reassembly queue } &    timemsg  : TimerMsgType;   
   link     : MbufIdType;  
 
   context  : ContextType; 
     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     	BEGIN { RcbLink }  	 
WITH gv_ip_globals, rcb DO 
    BEGIN { WITH Global Variables }     result := 0;          { Set up the head of the list RCB     {}      temp_rcb.rcb_link   := ipg_reass_que;     temp_rcb.rcb_time   := MAX_REASS_TIME;      IF ipg_reass_que <> END_OF_LIST THEN         BEGIN { IF msgs on the queue }  %      temp_rcb.rcb_time   := ReassDeltaTime (TimeOfDay, ipg_reass_expire); %       END;  { IF msgs on the queue }         temp_rcb.rcb_mbufid := GLOBAL_BLK_RCB;      WHILE (timeout >= temp_rcb.rcb_time    ) AND            (temp_rcb.rcb_link <> END_OF_LIST) DO            BEGIN { WHILE rcb follows temp_rcb }        backref := temp_rcb.rcb_mbufid;         timeout := timeout - temp_rcb.rcb_time;         link := temp_rcb.rcb_link;        GetRcb (link, temp_rcb, result);  
      IF result <> 0 THEN  
          BEGIN { IF error on getting RCB }           { Attempt cleanup of corrupt list           { Notify of a diaster (corrupt list)   
         { and Exit. 
          {}            RcbUnLink (temp_rcb, backref);            context.mbufid := link;           IpErrorLog (EL_DISASTER, result, context.int, SUBR);            Exit;           END;  { IF error on getting RCB }            END;  { WHILE rcb follows temp_rcb }         { RCB follows TEMP_RCB in the list, so link it in     {}      rcb.rcb_link      := temp_rcb.rcb_link;     temp_rcb.rcb_link := rcb.rcb_mbufid;          rcb.rcb_time      := temp_rcb.rcb_time - timeout;     temp_rcb.rcb_time := timeout;         backref           := temp_rcb.rcb_mbufid;  	   PostRcb (rcb);  	        IF temp_rcb.rcb_mbufid <> GLOBAL_BLK_RCB THEN            BEGIN { IF temp_rcb is NOT the list head }  
      PostRcb (temp_rcb);  
       END   { IF temp_rcb is NOT the list head }          ELSE            BEGIN { ELSE temp_rcb is the list head }        ipg_reass_que  := temp_rcb.rcb_link;  &      ipg_reass_expire := (TimeOfDay + temp_rcb.rcb_time*ip_TMRES) MOD CSPD; & 	      UpdatedIpg;  	       StartReassTimer;        END;  { ELSE temp_rcb is the list head }         END;  { WITH Global Variables }      
99:   { Error Exit Point } 
 	END;  { RcbLink }  	     $TITLE 'RcbUnLink',PAGE$  {------------------------------------------------------------}  {           RcbUnLink                                        }  {------------------------------------------------------------}      
PROCEDURE RcbUnLink  
            (VAR rcb        : RcbType;                   backref    : MbufIdType);       {}  { Description    {     This routine will remove an RCB from the reassembly queue    {     and see that the timer is running appropriately.  {}  { Parameters  !{     rcb         IN/OUT   The RCB to be unlinked from this queue. ! ${     backref     IN       The MBUFID of the RCB immediately preceeding  $ {                          'rcb' in the list.   {}  { Global Data Structures  !{     gv_ip_globals  IN/OUT   IP's global block which contains the ! !{                             list head for the reassembly queue.  ! {}  { Algorithm   "{     This routine will reset both the link and the incremental time " !{     words in the rcb previous to 'rcb' to unlink 'rcb' from the  ! !{     list. If the first RCB on the list was removed, this routine ! ${     will see to it that the timer is either reset or stopped depending $ {     on what remains.  {}  CONST      SUBR = SubrRCBUNLINK;      TYPE     ContextType = RECORD CASE Int16 OF         0: (longint : Int32);         1: (int     : Int16);         2: (mbufid  : MbufIdType);        END;  { ContextType }       VAR      temp_rcb   : RcbType;  { Temp storage for RCBs }      error      : Int16;     timertime  : Int32;     oldrcbtime : Int32;     context    : ContextType;      
BEGIN { RcbUnLink }  
 
WITH gv_ip_globals, rcb DO 
    BEGIN { WITH Global Variables }     IF (ipg_reass_que = rcb.rcb_mbufid) OR         (backref = GLOBAL_BLK_RCB)       THEN             BEGIN { IF previous rcb is the list head }        ipg_reass_que := rcb.rcb_link;        IF ipg_reass_que = END_OF_LIST THEN                BEGIN { IF nothing more on the list }           OffReassTimer;            END   { IF nothing more on the list }             ELSE                BEGIN { ELSE have more on the list }   '         timertime  := ReassDeltaTime (TimeOfDay, ipg_reass_expire)*ip_TMRES;  '          oldrcbtime := rcb.rcb_time*ip_TMRES;            {  Next time to expire            {}   &         ipg_reass_expire := (TimeOfDay + timertime + oldrcbtime) MOD CSPD;  &     
         UpdatedIpg; 
 
         StartReassTimer;  
          END;  { ELSE have more on the list }             END   { IF previous rcb is the list head }          ELSE            BEGIN { ELSE previous rcb is NOT the list head }        GetRcb (backref, temp_rcb, error);        IF error <> 0 THEN               BEGIN { IF error on fetch of RCB }            context.mbufid := backref;            IpErrorLog (EL_ERROR, error, context.int, SUBR);            END   { IF error on fetch of RCB }              ELSE                BEGIN { ELSE have RCB }           { Unlink rcb by resetting the previous rcb's linkage            { and incremental time.           {}            temp_rcb.rcb_link := rcb.rcb_link;             temp_rcb.rcb_time := temp_rcb.rcb_time + rcb.rcb_time;                 PostRcb (temp_rcb);           END;  { ELSE have RCB }        END;  { ELSE previous rcb is NOT the list head }         END;  { WITH Global Variables }  
END;  { RcbUnLink }  
     $TITLE 'ReAlcCleanUpPath',PAGE$   {------------------------------------------------------------}   {              ReAlcCleanUpPath                                }   {------------------------------------------------------------}      PROCEDURE ReAlcCleanUpPath;       {}  {  Description  !{     This routine will clean up anything necessary on the global  ! {     path record in preparation for this path record being   {     reallocated. This processing should not cause IP to lose  {     context.  {}  {  Parameters   {     none  {}  {  Side Effects   {     The global path record is altered by this routine.  {}  
{  Global Data Structures  
 {     gv_path_rec    IN/OUT   is operated on by this routine.   {     gv_ip_globals  IN/OUT   {}  	{  Error Handling  	 {     none  {}  {  Algorithm  {     Various fields of the path record will be dealt with.   {}         BEGIN { ReAlcCleanUpPath }      WITH gv_ip_globals, gv_path_rec DO         BEGIN { WITH Global Variables }         {}  
      { pr_free_link 
 	      { pr_remote  	       { pr_local        These remain as they are and will be  "      { pr_proto        set appropriately by the ReAllocate routine  "       { pr_uppid  
      { pr_mpool_id  
       {}        pr_ulp_up_emscnt  := 0;         pr_ulp_dn_emscnt  := 0;       "      { pr_cl_link      The current path record must be removed from "       {                 the clpath list.  !      { pr_cl_idletime  And its idletime counter set to NOT idle.  !       {}  	      UnLkClPath;  	       pr_cl_idletime    := 0;             {}         { pr_out_que      There will be no messages on this queue.         { pr_out_tail     The path is not a candidate for   "      {                 reallocation unless all messages on it have  "       {                 been sent.        {}            {}  "      { pr_states       The path state will be set to the empty set  "        { pr_active_link     and the path will be removed from any   !      {                    processing list it might have been in.  !       {}        pr_states := [];        UnLinkPathRec (ipg_pr_cntl_que);        UnLinkPathRec (ipg_act_out_pr_que);             {}  !      { pr_anh_link     The current route will remain intact until ! "      { pr_anh_idx      it is determined that the new path needs new "       { pr_ngt_idx      routing information.        {}  #      { pr_in_dnpid     There should be no unprocessed offered routes  #       { pr_in_dnpath    at this point         { pr_ki_reason    and no unprocessed kill_indications.        {}            {}  $      { pr_statistics   These will be cleared to make way for the stats  $       {                 for the reallocated path.         {}        pr_statistics := NO_STATISTICS;             {}        { pr_pathref      The path reference remains unchanged.         { pr_rec_status   and the record status is UPDATED.         {}        UpdatedPr;        END;  { WITH Global Variables }      END;  { ReAlcCleanUpPath }       $TITLE 'ReAllocPathRec',PAGE$   {------------------------------------------------------------}  {           ReAllocPathRec                                   }  {------------------------------------------------------------}      PROCEDURE ReAllocPathRec             (    remote : Int32;                   local  : Int32;               VAR result : Int16);      {}  { Description   "{     This routine will attempt to find a path record that is in use " !{     but that may be reallocated for use given the remote, local  ! {     and gv_pid_rec context.   {}  { Parameters  {     remote   IN       The IP Address of the remote node   {   {     local    IN       The IP Address of the local node  {   {     result      OUT   The result of this operation.   {}  { Side Effects  {}  { Global Data Structures  !{     gv_path_rec    IN/OUT   The storage for the new path record  !  {     gv_pid_rec     IN       The Protocol specific information    {}  { Error Handling  "{     If the requested path can't be produced, an error is returned  " {     to the caller, and the path record is meaningless.  {}  LABEL   
   99;   { return point }  
     VAR   
   error    : Int16; 
     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { ReAllocPathRec }  WITH gv_path_rec, gv_pid_rec DO      BEGIN { WITH Global variables }     error := 0;         { Save the current path if necessary      {}   	   SavePathState;  	        { Attempt to find the LRU path appropriate to the required      { path type.      {     { IF this fails, then return the error to the caller.     {}      FindLruPathRec (pl_path_type, error);     IF error <> ips_GOOD_RETURN THEN Exit;          { Have a path that may be reallocated  	   { so reclaim it 	    {     { NOTE: gv_pid_rec required on entry      {}   
   ReAlcCleanUpPath; 
    SetUpPathRec (remote, local);         END;  { WITH Global variables }      99:   { Return Point }  result := error;  END;  { ReAllocPathRec }      $TITLE 'ReassDeltaTime',PAGE$   {------------------------------------------------------------}  {           ReassDeltaTime                                   }  {------------------------------------------------------------}      FUNCTION  ReassDeltaTime             (    timea : Int32;                  timeb : Int32 ) : Int16;      {}  { Description   {     This function will take two times given in the form of  {     Int32s of centiseconds since midnight, and will return  {     an Int16 difference in the units the reassembly timeout   {     processing is using (typically seconds).  {   {     It assumes that the longest delta time is 9 hours, which  {     is about the number of 16-bits worth of seconds.  {   "{     The routine does not depend on knowing which time is earlier,  " %{     just on knowing that the interval is going to be less than 9 hours.  % {}  { Parameters  {     timea    IN          TimeOfDay format time  {     timeb    IN          TimeOfDay format time  {   {     function    OUT      The time difference late - early   {                          in seconds.  {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  "{     If the time to be passed back is calculated to be longer than  " {     9 hours, 9 hours will be returned.  {}  { Algorithm   {   {}  CONST      MAX_TIME =  9 * 60 * 60 ;  { 9 Hrs in seconds }      VAR   	   delta : Int32;  	     
   FUNCTION  MinTime 
               (    a : Int16;                      b : Int16) : Int16;        BEGIN { MinTime }   
      MinTime := b;  
       IF a < b THEN MinTime := a;         END;  { MinTime }       BEGIN { ReassDeltaTime }  delta := Abs (timea - timeb);   IF (delta DIV ip_TMRES) > MAX_TIME THEN delta := CSPD - delta;      { Returning seconds, and checking for huge intervals  {}  ReassDeltaTime := MinTime (MAX_TIME, delta DIV ip_TMRES);       END;  { ReassDeltaTime }      $TITLE 'RemoveFragDesc',PAGE$   {------------------------------------------------------------}  {           RemoveFragDesc                                   }  {------------------------------------------------------------}      PROCEDURE RemoveFragDesc             (    mbufid : MbufIdType;              VAR frag   : FragDescType);       {}  { Description   !{     This routine will remove the frag descriptor from a message  ! {     fragment and will return it in the frag parameter.  {}  { Parameters  {     mbufid   IN       The mbufid of the fragment  {   !{     frag        OUT   The fragment descriptor for the fragment.  ! {}  CONST   
   SUBR = SubrREMOVEFRAG;  
     VAR   
   mmflags : MMFlagsType;  
 
   error   : Int16;  
    link    : MbufIdType;      BEGIN { RemoveFragDesc }  
{ Set initial values 
 {}  mmflags.int     := 0;   mmflags.bits[0] := FALSE;  { Destructive read of the data }   error           := ips_GOOD_RETURN;   
link            := mbufid; 
     IF link <> END_OF_LIST THEN      BEGIN { IF not EOL }   "   DS_MRead (frag.bufr, FRAG_BLEN, link, NO_OFSET, mmflags, error);  "    IF error <> ips_GOOD_RETURN THEN         BEGIN { IF error fetching desired frag descriptor }         IpErrorLog (EL_DISASTER, error, 0, SUBR);         frag := EOL_FRAG;         END;  { IF error fetching desired frag descriptor }      END   { IF not EOL }        ELSE          BEGIN { ELSE is EOL }  
   frag := EOL_FRAG; 
    END;  { ELSE is EOL }  END;  { RemoveFragDesc }      $TITLE 'RequestDownPath',PAGE$  {------------------------------------------------------------}  {              RequestDownPath                               }  {------------------------------------------------------------}      
PROCEDURE RequestDownPath; 
     {}  {  Description  "{     This routine will generate the REQUEST_DPATH event message to  " ${     be sent to the PROBE when a new route (down pid/path) is required. $ {}  {  Parameters   {     none  {}  
{  Global Data Structures  
 #{     gv_send_emsg      OUT   The event message used to send this msg. # "{     gv_anh_rec     IN/OUT   The ANH record to be used as the root  " #{                             reference for the REQUEST_DPATH message. # "{                             It also contains the IP address of the " "{                             ANH node and the state word to set if  " {                             a REQUEST_DPATH is sent.  {     gv_ngt_rec        OUT   Fetch the DnPid to be used.   {     gv_ip_globals  IN/OUT   {     gv_wkmap       IN/OUT   {}  {  Algorithm  !{     The REQUEST_DPATH event message is built and is sent to the  ! {     PROBE protocol for resolution.  {   !{     It is not sent on the current path record, and PROBE has no  ! !{     path records in this context, so the message is NOT counted. ! {}     LABEL  
      99;   { Exit Point } 
        CONST  "      SUBR = SubrREQUESTDOWNP; { Subroutine ID number for logging }  "        VAR  
      error : Int16; 
           PROCEDURE Exit;            BEGIN { Exit }   	         GOTO 99;  	          END;  { Exit }          BEGIN { RequestDownPath }     WITH gv_send_emsg, gv_anh_rec DO         BEGIN { WITH Global Variables }         { Do NOT send a REQUEST_DPATH,        { IF the ANH node is unknown,         { Or if the net PID is unknown (i.e. 0)          { Or if the ANH rec is already in the ROUTE_PENDING state          {}        IF (ah_anh = NO_ANH_NODE) OR           (ah_netpid = 0)        OR           (ahst_ROUTE_PENDING IN ah_states) THEN Exit;             {}        { Build the REQUEST_DPATH event message         {}        em_event := REQUEST_DPATH;        ehport  := BuildPort (PROBE, EHOB_OFFSET);  
      emrd_root_pid := IP; 
       emrd_root_ref := ah_index;        emrd_vna.bytes[0] := 0; {version 0}         emrd_vna.bytes[1] := HPDSN_DOMAIN;        emrd_vna.addrpart := ah_anh;        emrd_down_pid     := ah_netpid;             {  Set the ROUTE_PENDING state        {}        ah_states := ah_states + [ahst_ROUTE_PENDING];  	      UpdatedAnh;  	     
      { Ship this message  
       {}        SaveState;        IF gv_gocrit_error = 0 THEN DS_LeaveCritical (gv_wkmap);        ProSw (gv_send_emsg, error);  	      ContextLost; 	       DS_EnterCritical (gv_wkmap, gv_gocrit_error);         { Post the Prosw error return if any, before proceeding         { Then save the EnterCritical error         {}  %      IF error <> 0 THEN IpErrorLog (EL_ERROR, error, 0, SUBR+PROSWFAIL);  %       error := gv_gocrit_error;             IF error <> ips_GOOD_RETURN THEN           BEGIN           {  EnterCritical error checking }           IpErrorLog (EL_DISASTER, error, 0, SUBR+GOCRITFAIL);            END;   
      FetchGlobals;  
           END;  { WITH Global Variables }          99:   { Exit Point }      END;  { RequestDownPath }      
$TITLE 'RtnIcmpMsg',PAGE$  
 {------------------------------------------------------------}  {           RtnIcmpMsg                                       }  {------------------------------------------------------------}      
PROCEDURE RtnIcmpMsg 
            (VAR icmphead : IcmpHeadType;              VAR result   : Int16);      {}  { Description   !{     This routine will build an ICMP message from the ICMP header !  {     passed in, the current global path record, and the current   {     global IP header.   !{     It will not send this message, but will see that the message !  {     gets queued off of the current path and is ready to send.    {   !{     This routine is to be used only for those ICMP messages that ! #{     are error returns. i.e. that have the old IP header as the ICMP  # {     data.   {}  { Parameters  {     icmphead IN       The ICMP header to be sent  {     result      OUT   The result of the operation.  {                       0    = Good Result  !{                       else = The Icmp message could not be sent. ! "{                              In this case, any mbufs used for the  "  {                              ICMP message will be cleaned up.    {}  { Global Data Structures  {     gv_path_rec IN/OUT   The current path context   &{     gv_ip_head  IN       The IP header (+ some ULP data) being processed.  & {}  LABEL      99;   { Exit Point }       VAR      error     : Int16;   
   mbufid    : MbufIdType; 
    localnode : AddressType;       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
BEGIN { RtnIcmpMsg } 
 WITH gv_path_rec, gv_ip_head DO      BEGIN { WITH current context }      error := 0;     { Don't return ICMP msgs on ICMP messages     {}      IF iphd.w5.iphd_proto = ICMP_PROTO_NUM THEN Exit;         DS_FetchElement (DS_IP_Local_Addrs_TD, 1, localnode.int);  $   BuildIcmpMsg (icmphead, localnode.longint, iphd.src, mbufid, error);  $    IF error <> ips_GOOD_RETURN THEN Exit;          { icmphead has checksum word = 0 (from BuildIcmpMsg)      { Update Send Queue list head to link in this new message     {}      QueueMsgOnSendQue (mbufid);     END;  { WITH current context }       
99:   { Error Exit } 
 result := error;  
END;  { RtnIcmpMsg } 
     $TITLE 'SaveAnhState',PAGE$   {------------------------------------------------------------}  {              SaveAnhState                                  }  {------------------------------------------------------------}  PROCEDURE SaveAnhState;          {}      { Description  #   {  SaveAnhState will restore the Anh Record to DSAM if it has been  #    {  updated.     {}      { Parameters      {     None      {}   	   { Side Effects  	    {     The ANH record in DSAM is updated and the local copy      {     is set to the VALID_DATA status.      {}      { Global Data Structures      {     gv_anh_rec  IN/OUT   Variable Operated on.      {}   
   { Error Handling  
    {     none      {}      { Algorithm  #   {     If the gv_anh_rec.ah_rec_status field is set to UPDATED_DATA  # "   {        this variable is posted to DSAM. The anh index is given  "    {        in the gv_anh_rec.ah_index field.      {}       
   BEGIN { SaveAnhState }  
    WITH gv_anh_rec DO         BEGIN         {}  
      { Save AnhRec  
       {}        IF ah_rec_status = UPDATED_DATA THEN           BEGIN { IF }            {}            { DSAM needs updating so Post the record            { and reset the local record status           {}             DS_StoreElement (DS_IP_Anh_Rec_TD, ah_index, ah_bufr);             ah_rec_status := VALID_DATA;            END;  { IF }         END;  { WITH Global Variables }   
   END;  { SaveAnhState }  
     $TITLE 'SaveGlobalState',PAGE$  {------------------------------------------------------------}  {              SaveGlobalState                               }  {------------------------------------------------------------}  
PROCEDURE SaveGlobalState; 
        {}      { Description  !   {  SaveGlobalState will restore the IP Global Block to DSAM if  ! 
   {  it has been updated. 
    {}      { Parameters      {     None      {}   	   { Side Effects  	    {     none      {}      { Global Data Structures   %   {     gv_ip_globals  IN/OUT  Variable restored to DSAM by this routine. %    {}   
   { Error Handling  
    {     none      {}      { Algorithm  %   {     If the gv_ip_globals.ipg_rec_status field is set to UPDATED_DATA  %    {        or to VALID_DATA this variable is posted to DSAM.      {}          BEGIN { SaveGlobalState }     WITH gv_ip_globals DO        BEGIN         {}  
      { Save Globals 
       {}        IF ipg_rec_status <> INVALID_DATA THEN           BEGIN { IF }   
         { Post the record 
          { and Reset the status of the local record.           {}   "         DS_StoreElement (DS_IP_Globals_TD, FIRST_ENTRY, ipg_bufr);  "          ipg_rec_status := VALID_DATA;           END;  { IF }         END;  { WITH Global Variables }      END;  { SaveGlobalState }      $TITLE 'SaveHeaderState',PAGE$  {------------------------------------------------------------}  {              SaveHeaderState                               }  {------------------------------------------------------------}  
PROCEDURE SaveHeaderState; 
        {}      { Description  $   {  SaveHeaderState will restore the IP Header to the message in DSAM  $    {  if the local copy has been updated.      {}      { Parameters      {     None      {}   	   { Side Effects  	    {     none      {}      { Global Data Structures      {     gv_ip_header   IN/OUT Variable Restored to DSAM     {}   
   { Error Handling  
    {     none      {}      { Algorithm  %   {     If the gv_ip_header.iphd_rec_status field is set to UPDATED_DATA  % $   {        this variable is posted to DSAM. The mbufid associated with  $ #   {        this message is contained in the gv_ip_header.iphd_mbufid  # 	   {        field. 	    {}      CONST  "      SUBR = SubrSAVEHEADER;   { Subroutine ID number for logging }  "        VAR        error        : Int16;         headerlength : Int16;          BEGIN { SaveHeaderState }     WITH gv_ip_head DO         BEGIN         {}        { Save IP Header        {}        IF iphd_rec_status = UPDATED_DATA THEN           BEGIN { IF header updated }           headerlength := iphd.w1.headlen * 4;                DS_MBOverWRITE (iphd_bufr, headerlength, iphd_mbufid,                             NO_OFSET, error);           If error = ips_GOOD_RETURN THEN                  BEGIN { IF write worked }               iphd_rec_status := VALID_DATA;              END   { IF write worked }                 ELSE                  BEGIN { ELSE write failed }               IpErrorLog (EL_DISASTER, error, 0, SUBR);               END;  { ELSE write failed }                END;  { IF header updated }        END;  { WITH Global Variables }      END;  { SaveHeaderState }      $TITLE 'SavePathState',PAGE$  {------------------------------------------------------------}  {              SavePathState                                 }  {------------------------------------------------------------}  PROCEDURE SavePathState;         {}      { Description      {  SavePathState will restore gv_path_rec to the appropriate       {  path record element in DSAM if it has been updated.      {}      { Parameters      {     None      {}   	   { Side Effects  	    {     none      {}      { Global Data Structures      {     gv_path_rec IN/OUT   Record to be restored      {}   	   { Error Returns 	    {     none      {}      { Algorithm  #   {     If the gv_path_rec.pr_rec_status field is set to UPDATED_DATA # #   {        this variable is posted to DSAM. The record index is given #    {        in the gv_path_rec.pr_pathref field.     {}       
   BEGIN { SavePathState } 
    WITH gv_path_rec DO        BEGIN         {}  
      { Save PathRec 
       {}  	      StatesLink;  	       IF pr_rec_status =  UPDATED_DATA THEN            BEGIN { IF }            {}            { DSAM Needs updating so Post the record            { and reset the local record status           {}   !         DS_StoreElement (DS_IP_Path_Rec_TD, pr_pathref, pr_bufr); !          pr_rec_status := VALID_DATA;            END;  { IF }         END;  { WITH Global Variables }   
   END;  { SavePathState } 
     $TITLE 'SaveState',PAGE$  {------------------------------------------------------------}  {              SaveState                                     }  {------------------------------------------------------------}      
PROCEDURE SaveState; 
        {}      { Description  !   {  SaveState will ensure that all the writable global variables !    {  that need to be posted to DSAM on updates are posted.      {}      { Parameters      {     None      {}   	   { Side Effects  	    {     none      {}      { Global Data Structures   #   {     gv_ip_globals  IN/OUT   Restored dependant on ipg_rec_status  # "   {     gv_path_rec    IN/OUT   Restored dependant on pr_rec_status " "   {     gv_anh_rec     IN/OUT   Restored dependant on ah_rec_status " #   {     gv_ip_header   IN/OUT   Restored dependant on iphd_rec_status #    {}   
   { Error Handling  
    {     none      {}      { Algorithm  %   {     The Save State routines for each of the writable data structures  % $   {     are called. It is up to each of them to ensure that the records $    {     are posted appropriately.     {}          BEGIN { SaveState }     { Save Updated IP Global Block }   
   SaveGlobalState;  
        { Save Updated Path Record }   	   SavePathState;  	        { Save Updated Anh Record }     SaveAnhState;         { Save Updated IP Header }   
   SaveHeaderState;  
        END;  { SaveState }      $TITLE 'SetUpPathRec',PAGE$   {------------------------------------------------------------}  {              SetUpPathRec                                  }  {------------------------------------------------------------}  PROCEDURE SetUpPathRec             (    remote : Int32;                   local  : Int32 );       {}  {  Description  "{     This routine is used to initialize a path record after it has  " {     been allocated from the free list.  {}  {  Parameters   {     remote   IN    The IP address of the remote machine.  {     local    IN    The IP address of the local machine.   {}  {  Side Effects   {     This routine modifies the global variable 'gv_path_rec'.  {}  
{  Global Data Structures  
 {     gv_ip_globals  IN/OUT   {     gv_path_rec    IN/OUT   {     gv_pid_rec     IN   {     gv_ngt_rec        OUT   {}  	{  Error Handling  	 {     none  {}  {  Algorithm  {     Various fields of the path record are set. See below:   {}     VAR  
      error : Int16; 
 
      ttl   : Int16; 
     
   BEGIN { SetUpPathRec }  
 %   WITH gv_ip_globals, gv_path_rec, gv_pid_rec, gv_ngt_rec, gv_pid_rec DO  %       BEGIN { WITH Global Variables }         {}  $      { pr_free_link    The path remains allocated, so this is unchanged $ 	      { pr_remote  	        { pr_local        These are set to indentify the new path          { pr_proto        record.         { pr_uppid  
      { pr_mpool_id  
       {}        pr_remote    := remote;         pr_local     := local;        pr_proto.int := pl_proto;         pr_uppid     := pl_uppid;         pr_mpool_id  := pl_mpool_id;        pr_path_type := pl_path_type;             {}        { pr_ulp_up_emscnt   Cleanup occurs when these go to 0.         { pr_ulp_dn_emscnt        {}            {}  %      { pr_cl_link      If this path is an Connectionless path, it must be %       {                 linked onto the clpath list.  !      { pr_cl_idletime  And its idletime counter set to NOT idle.  !       { pr_path_type    This is already set at this point.        {}        IF (pr_path_type = pr_UNREFED_CONNECTLESS) OR            (pr_path_type = pr_REFED_CONNECTLESS)   THEN            BEGIN { IF Connectionless path }   	         LkClPath; 	          pr_cl_idletime    := 0;           END;  { IF Connectionless path }             {}         { pr_out_que      There will be no messages on this queue.   
      { pr_out_tail  
       {}            {}  $      { pr_states       The path state will remain unchanged as nothing  $       { pr_active_link     has happened to change the state.        {}  !      { pr_anh_link     The current route will remain intact until ! "      { pr_anh_idx      it is determined that the new path needs new "       {                 routing information.        {}            {}  !      { pr_ngt_idx      A new NGT index will be found to match the !       {                 new remote IP address.  "      {                 If there is an error, the ngt_index will be  "       {                 set to 0 by GetNgtRec.  "      { pr_ttlwd        The TTL field will be set from the hop count "       {                 in the NGT.         {}        GetNgtRec (remote, error);        pr_ngt_idx := ngt_index;        { Reset the TTL if other than the default         {}        ttl := ngt_hopwd * SECS_PER_HOP;        IF ttl < MAX_TTL.ttl THEN pr_ttlwd.ttl := ttl;            {}  #      { pr_in_dnpid     There should be no unprocessed offered routes  #       { pr_in_dnpath    at this point         { pr_ki_reason    and no unprocessed kill_indications.        {}            {}  &      { pr_statistics   These will be cleared to make way for the statistics &       {                 for the reallocated path.         {}        pr_statistics := NO_STATISTICS;             {}        { pr_pathref      The path reference remains unchanged.         { pr_rec_status   and the record status is UPDATED.         {}        UpdatedPr;        END;  { WITH Global Variables }   
   END;  { SetUpPathRec }  
     $TITLE 'StartClTimer',PAGE$   {------------------------------------------------------------}  {           StartClTimer                                     }  {------------------------------------------------------------}      PROCEDURE StartClTimer;       {}  { Description   "{     This procedure will start the Connectionless Path Aging timer  " {     if it is not already going.   {}  { Parameters  {     none  {}  { Global Data Structures  {     gv_ip_globals  IN/OUT   {}  { Error Handling  ${     If the timer activate fails, the timer id in the global block will $ {     indicate that the timer is not running.   &{     When ever a new store and forward message is received (ipib.inbound),  & "{     the state of this time will be checked and if it is not going, " #{     the timer expired processing will be done which will cause this  # {     routine to attempt to start the timer again.  {}      LABEL      99;   { Immediate Exit Point }       CONST      SUBR  =  SubrSTARTCLTMR;       VAR   
   timemsg : TimerMsgType; 
 
   time    : Int32;  
 
   error   : Int16;  
     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { StartClTimer }  WITH gv_ip_globals DO   
   BEGIN { WITH globals }  
    time := ipg_reset.cl * ip_TMRES;          { If there is nothing for this timer to do, get out.      {}      IF ipg_clpath_list = END_OF_LIST THEN Exit;         { If timer is already running, get out immediately.     {}      IF ipg_cl_tmrid.index <> ip_TIMER_OFF THEN Exit;       
   { Timer is NOT running  
    {}      DS_FetchElement (DS_TRACKTD, TL_IP_SOCKET, timemsg.socket);     timemsg.direction := OUTBOUND_SIG;      timemsg.signal    := IP_CL_TIMER;         ActivateTimer (time, timemsg, ipg_cl_tmrid, error);         IF error <> ips_GOOD_RETURN THEN         BEGIN { IF error on timer activate }        IpErrorLog (EL_ERROR, error, 0, SUBR);        ipg_cl_tmrid.index := ip_TIMER_OFF;         END;  { IF error on timer activate }      
   END;  { WITH globals }  
     99:   { Immediate Exit point }  UpdatedIpg;   END;  { StartClTimer }      $TITLE 'StartReassTimer',PAGE$  {------------------------------------------------------------}  {           StartReassTimer                                  }  {------------------------------------------------------------}      
PROCEDURE StartReassTimer; 
     {}  { Description   {     This routine will restart the reassembly timer no matter  {     what its current state.   {}  { Parameters  {     none  {}  { Side Effects  {}  { Global Data Structures  {     gv_ip_globals  IN/OUT   {}  { Error Handling  {}  { Algorithm   {   {}  LABEL      99;   { Immediate Exit Point }       CONST      SUBR  =  SubrSTARTREASSTMR;      VAR   
   timemsg : TimerMsgType; 
 
   time    : Int32;  
 
   error   : Int16;  
     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
BEGIN { StartReassTimer }  
 WITH gv_ip_globals DO   
   BEGIN { WITH globals }  
 "   time := ReassDeltaTime (TimeOfDay, ipg_reass_expire) * ip_TMRES;  "        IF ipg_reass_tmrid.index <> ip_TIMER_OFF THEN            BEGIN { IF timer is already running }         ResetTimer (time, ipg_reass_tmrid, error);        IF error = ips_GOOD_RETURN THEN Exit;         END;  { IF timer is already running }       
   { Timer is NOT running  
    {}      DS_FetchElement (DS_TRACKTD, TL_IP_SOCKET, timemsg.socket);     timemsg.direction := OUTBOUND_SIG;      timemsg.signal    := IP_REASS_TIMER;          ActivateTimer (time, timemsg, ipg_reass_tmrid, error);          IF error <> ips_GOOD_RETURN THEN         BEGIN { IF error on timer activate }        IpErrorLog (EL_ERROR, error, 0, SUBR);  
      OffReassTimer; 
       END;  { IF error on timer activate }      
   END;  { WITH globals }  
     99:   { Immediate Exit point }  UpdatedIpg;   
END;  { StartReassTimer }  
     
$TITLE 'StatesLink',PAGE$  
 {------------------------------------------------------------}  {              StatesLink                                    }  {------------------------------------------------------------}      PROCEDURE StatesLink;          {}      { Description     {  This routine will link the given path record onto the   "   {  appropriate processing queue in the IP global block depending  "    {  on the states set in the path record.      {  !   {  It will only do this if the path record is currently in the  !    {  UPDATED_DATA or VALID_DATA status state.     {     {  If necessary it will unlink the record from its current      {  queue and relink it at the head of the new queue.      {     {  It depends on the routines: LinkPathRec   and      {                              UnLinkPathRec      {}      { Parameters      {     none      {}   	   { Side Effects  	    {     none      {}      { Global Data Structures      {     {     gv_path_rec    IN/OUT   The path record to be queued.  %   {                             This is a variable global to the process. %    {  %   {     gv_ip_globals  IN/OUT   The IP Global values, including the list  % $   {                             heads for both of the Processing Queues $     {                             that the path may be queued to.      {}   
   { Error Handling  
    {     None required, either a control state will be set, or      {     an active state will be set, or no states will be set.       {     There are no other cases.     {}      { Algorithm     {  #   {  This routine does not change DSAM, that is left to the routines  #    {  which post the various global variables.     {  "   {  A path record may have several states set in its states word.  "    {  The states fall into two sets:     {     {     The Control States   
   {     The Active States 
    {      {     The control States have priority over the active states   $   {     and the various states within each subset are ordered as well.  $    {  #   {  There are two processing queues that path records may be linked  #    {  onto:      {     {     ipg_pr_cntl_que      the Path Record Control Queue      {     ipg_act_out_pr_que   the Active Outbound Path Queue     {  #   {     The Inbound Protocol process, handles only the Control Queue  # $   {     and the Outbound process handles both queues, with the Control  $ 
   {     having priority.  
    {  $   {  This routine will see that the path record in the global variables $    {  is linked onto the appropriate queue for processing.     {  !   {  If any control state is set, the path will be linked to the  !    {     control queue.   %   {  Otherwise, if any active state is set, the path will be linked onto  % 
   {     the active queue, 
 %   {  and if no states are set, then there is no processing to be done and %    {     the path record is removed from both lists.     {  $   {  NOTE that the Link and UnLink routines handle the cases where the  $    {  path record is already linked or unlinked.     {}   LABEL      99;   { Immediate Exit Point }       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
BEGIN { StatesLink } 
 WITH gv_path_rec, gv_ip_globals DO     BEGIN { WITH GLOBAL VARIABLES }         IF NOT ( (pr_rec_status = UPDATED_DATA) OR               (pr_rec_status = VALID_DATA  )    ) THEN Exit;         IF (pr_states * CNTL_STATES) <> [] THEN        {}        { A control Queue State is set        {}        BEGIN { CONTROL QUEUE States }        UnLinkPathRec (ipg_act_out_pr_que);         LinkPathRec (ipg_pr_cntl_que);        END   { CONTROL QUEUE States }         ELSE IF (pr_states * ACTIVE_STATES) <> [] THEN         {}        { An Active Queue State is set        {}        BEGIN { ACTIVE QUEUE States }         UnLinkPathRec (ipg_pr_cntl_que);        LinkPathRec (ipg_act_out_pr_que);         END  { ACTIVE QUEUE States }         ELSE         {}  
      { No States are set  
       {}  
      BEGIN { No States }  
       UnlinkPathRec (ipg_pr_cntl_que);        UnlinkPathRec (ipg_act_out_pr_que);   
      END;   { No States } 
        END;  { WITH GLOBAL VARIABLES }      99:   { Immediate Exit Point }  
END;  { StatesLink } 
     $TITLE 'UnLinkPathRec',PAGE$  {------------------------------------------------------------}  {              UnLinkPathRec                                 }  {------------------------------------------------------------}      PROCEDURE UnLinkPathRec               (VAR que_head : Int16);       {}  {  Description  #{     UnLinkPathRec is used to remove IP path records from one of the  # !{     processing queues with the list head in the IP global block  ! {     in DSAM.  {   {     If the record is not linked on the given queue, nothing   	{     is changed.  	 {   {}  {  Parameters   {    {     que_head : The queue head from which the path record will    !{                be unlinked. This is a field of the gv_ip_globals ! {                variable. This may be either   {    {                    ipg_pr_cntl_que   or   ipg_act_out_pr_que.    {}  {  SideEffects  {     none  {}  
{  Global Data Structures  
 {   &{     gv_path_rec    IN/OUT   This is the path record to be removed from the & {                             given queue.  {}  {  Algorithm  {}      VAR         { List Linkage Storage Variables        {}     old_que_linkage : Int16;      que_linkage     : Int16;           BEGIN { UnLinkPathRec }   
WITH gv_path_rec DO  
    BEGIN { WITH Global Variables }             { Set the index of the first path rec to check }      { And set the old_que_linkage also.            }      { If the record is at the head, the WHILE will }      { not execute and the queu_linkage and old_que_linkage }      { will be the same. Once into the WHILE loop they }     { will always be different.                    }      que_linkage := que_head;      old_que_linkage := que_linkage;         WHILE (que_linkage <> pr_pathref ) AND            (que_linkage <> END_OF_LIST)   DO            BEGIN { WHILE }         {}        { Trace down this linked list         {}        old_que_linkage := que_linkage;         DS_FetchFields (DS_IP_Path_Rec_TD,           old_que_linkage, que_linkage,           pr_ACTLINK_OFSET, ONE_WORD);         END;  { WHILE }              IF que_linkage = END_OF_LIST THEN      	      BEGIN { IF } 	       {}        { Nothing to do, The record was not found         {}  	      END   { IF } 	        ELSE IF que_linkage = old_que_linkage THEN             BEGIN { ELSE IF }         {}        { It was found at the head of the list.   	      { Remove it. 	       {}        que_head := pr_active_link;         pr_active_link := END_OF_LIST;            UpdatedIpg;    { Global Block has been updated }        UpdatedPr;     { Path Record has been updated  }        END   { ELSE IF }          ELSE IF que_linkage = pr_pathref THEN            BEGIN { ELSE IF }         {}        { It was found, but not at the head.        { Remove it from the list         {}        DS_StoreFields (DS_IP_Path_Rec_TD,              old_que_linkage, pr_active_link,              pr_ACTLINK_OFSET, ONE_WORD);            pr_active_link := END_OF_LIST;            UpdatedPr;     { Path Record has been updated }         END;  { ELSE IF }          END;  { WITH Global Variables }  END;  { UnLinkPathRec }       $TITLE 'UnLkPathFromAnh',PAGE$  {------------------------------------------------------------}  {              UnLkPathFromAnh                               }  {------------------------------------------------------------}      
PROCEDURE UnLkPathFromAnh; 
     {}  { Description   !{     This routine takes care of unlinking the Path record and the ! 	{     Anh Record.  	 {   {     They need to be unlinked in the following fields:   {   "{        The path record must be removed from the list of path recs  " {        queued off of the ANH record.  {   !{        The index of the Anh record in the path must be cleared.  ! {}  { Global Data Structures  {     gv_path_rec IN/OUT  {     gv_anh_rec  IN/OUT  {}     CONST        SUBR = SubrUNLKPATHFANH;         VAR         que_link     : Int16;   { storage for tracing the Anh's }           old_que_link : Int16;   { list of path records          }           BEGIN { UnLkPathFromAnh }     WITH gv_path_rec, gv_anh_rec DO        BEGIN { WITH Global Variables }   !      { Unlink the path record from the Anh record's list of path  !       { recs.         {}        que_link := ah_pr_link;         WHILE (que_link <> pr_pathref) AND              (que_link <> END_OF_LIST) DO           BEGIN { WHILE }           { Trace down the linked list            {}            old_que_link := que_link;           DS_FetchFields (DS_IP_Path_Rec_TD,                            old_que_link, que_link,                           pr_ANHLINK_OFSET, ONE_WORD);                END;  { WHILE }            IF que_link = END_OF_LIST THEN               BEGIN { IF }            {}            { End of list found without finding path record           { The Path record is already unlinked.            {}            IpErrorLog (EL_WARNING, 0, pr_pathref, SUBR);           END   { IF }              ELSE IF que_link = ah_pr_link THEN                BEGIN { ELSE }            { Path record found at the head of the list           { Unlink it,            { Clear the ANH index           {}            ah_pr_link := pr_anh_link;            pr_anh_link := END_OF_LIST;               pr_anh_idx := NO_INDEX;  
         UpdatedAnh; 
 
         UpdatedPr;  
          END   { ELSE IF que_link }              ELSE                BEGIN { ELSE }            { Link found, Path was not at the head of the list.           { Unlink the path,            { Clear the Anh Index           {}            DS_StoreFields (DS_IP_Path_Rec_TD,                           old_que_link, pr_anh_link,                          pr_ANHLINK_OFSET, ONE_WORD);               pr_anh_link := END_OF_LIST;           pr_anh_idx  := NO_INDEX;   
         UpdatedAnh; 
 
         UpdatedPr;  
          END;  { ELSE }             END;  { WITH Global Variables }      END;  { UnLkPathFromAnh }      
$TITLE 'UnLkClPath',PAGE$  
 {------------------------------------------------------------}  {              UnLkClPath                                    }  {------------------------------------------------------------}      PROCEDURE UnLkClPath;       {}  { Description   {     This routine will remove the global Path record from the  {     Connectionless Path list.   {}  { Parameters  {     none  {}  { Side Effects  {   {}  { Global Data Structures  {     gv_ip_globals  IN/OUT   Contains the CL list list head.   %{     gv_path_rec    IN/OUT   The Path record being removed from the list. % {}  { Error Handling   {     If the record is not on the list, it will not be altered.    {}  { Algorithm   !{     This routine will search the Connectionless Path record list ! {     for the record with the link to the global path record.   {   #{     If this is not found, there is nothing to be unlinked, and this  # ${     routine sets the CL Link word to END_OF_LIST to avoid propagating  $ {     this error condition.   {   "{     If this record is found, and at the head of the list, then the " {     record is removed and the list head updated.  {    {     If this record is found, but not at the head of the list,    #{     then again the record is removed from the list and the previous  # {     record is updated.  {}     LABEL        99;   { Error Exit Point }         CONST        GLOBAL_BLOCK_REF = -1;         VAR        link     : Int16;         backlink : Int16;       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
        BEGIN { UnLkClPath }      WITH gv_ip_globals, gv_path_rec DO         BEGIN { WITH Global Variables }         { Find the entry on the Connectionless list }             link := ipg_clpath_list;        backlink := GLOBAL_BLOCK_REF;         WHILE (link <> END_OF_LIST) AND               (link <> pr_pathref ) DO               BEGIN { WHILE have more on Connectionless Path List }           { Fetch the next link           {}   
         backlink := link; 
          DS_FetchFields (DS_IP_Path_Rec_TD, link,                  link, pr_CL_LINK_OFSET, ONE_WORD);            END;  { WHILE have more on Connectionless Path List }            IF link = END_OF_LIST THEN               BEGIN { IF Entry NOT Found }            { Set the link to END_OF_LIST }           { Nothing further to be done  }           pr_cl_link := END_OF_LIST;   
         UpdatedPr;  
          Exit;           END;  { IF Entry NOT Found }             { Entry was found         {}        IF backlink = GLOBAL_BLOCK_REF THEN                BEGIN { IF Entry was found at head of list }            ipg_clpath_list := pr_cl_link;   
         UpdatedIpg; 
          END  {  IF Entry was found at head of list }              ELSE                BEGIN { Entry was not found at head }           DS_StoreFields (DS_IP_Path_Rec_TD, backlink,                  pr_cl_link, pr_CL_LINK_OFSET, ONE_WORD);   
         UpdatedPr;  
          END;  { Entry was not found at head }            pr_cl_link      := END_OF_LIST;         UpdatedPr;            IF pr_path_type = pr_UNREFED_CONNECTLESS THEN            BEGIN { IF unreferenced connectionless path }           { Maintain the reservation counting only for such           { path records.           {}            ipg_clcnt.inuse := ipg_clcnt.inuse - 1;  
         UpdatedIpg; 
          END;  { IF unreferenced connectionless path }            END;  { WITH Global Variables }          99:   { Error Exit Point }      END;  { UnLkClPath }       
$TITLE 'UpdatedAnh',PAGE$  
 {------------------------------------------------------------}  {              UpdatedAnh                                    }  {------------------------------------------------------------}      PROCEDURE UpdatedAnh;       {}  {  Description  {     This procedure will set the Anh record to the   
{     UPDATED_DATA status. 
 {   {     It will only set it to this state if it was VALID data  {     before, (i.e. If the status was INVALID_DATA, this  {     procedure will leave the record in that state to prevent  {     bad information being copied into DSAM).  {}  {  Side Effects   !{     As a result of the record being set to UPDATED_DATA status,  !  {     it may be posted into DSAM when SaveState or SaveAnhState    	{     are called.  	 {}  
{  Global Data Structures  
 {     gv_anh_rec  IN/OUT   The variable being operated on   {}  	{  Error Handling  	 {     none  {}  {  Algorithm  	{     see the code 	 {}      
BEGIN { UpdatedAnh } 
 	WITH gv_anh_rec DO 	    BEGIN { WITH Global Variables }      "   IF ah_rec_status = VALID_DATA THEN ah_rec_status := UPDATED_DATA; "        END;  { WITH Global Variables }  
END;  { UpdatedAnh } 
     
$TITLE 'UpdatedIpg',PAGE$  
 {------------------------------------------------------------}  {              UpdatedIpg                                    }  {------------------------------------------------------------}      PROCEDURE UpdatedIpg;       {}  {  Description  {     This procedure will set the IP Global Block to the  
{     UPDATED_DATA status. 
 {   {     It will only set it to this state if it was VALID data  {     before, (i.e. If the status was INVALID_DATA, this  {     procedure will leave the record in that state to prevent  {     bad information being copied into DSAM).  {   {}  {  Side Effects   !{     As a result of the record being set to UPDATED_DATA status,  !  {     it may be posted into DSAM when SaveState or SaveIpgState    	{     are called.  	 {}  
{  Global Data Structures  
 {     gv_ip_globals   IN/OUT   The variable being operated on   {}  	{  Error Handling  	 {     none  {}  {  Algorithm  	{     see the code 	 {}      
BEGIN { UpdatedIpg } 
 WITH gv_ip_globals DO      BEGIN { WITH Global Variables }      #   IF ipg_rec_status = VALID_DATA THEN ipg_rec_status := UPDATED_DATA; #        END;  { WITH Global Variables }  
END;  { UpdatedIpg } 
     
$TITLE 'UpdatedIphd',PAGE$ 
 {------------------------------------------------------------}  {              UpdatedIphd                                   }  {------------------------------------------------------------}      PROCEDURE UpdatedIphd;      {}  {  Description  {     This procedure will set the IP Header variable to the   
{     UPDATED_DATA status. 
 {   {     It will only set it to this state if it was VALID data  {     before, (i.e. If the status was INVALID_DATA, this  {     procedure will leave the record in that state to prevent  {     bad information being copied into DSAM).  {   {}  {  Side Effects   !{     As a result of the record being set to UPDATED_DATA status,  !  {     it may be posted into DSAM when SaveState or SaveIphdState   	{     are called.  	 {}  
{  Global Data Structures  
 {     gv_ip_head  IN/OUT   The variable being operated on   {}  	{  Error Handling  	 {     none  {}  {  Algorithm  	{     see the code 	 {}      BEGIN { UpdatedIphd }   	WITH gv_ip_head DO 	    BEGIN { WITH Global Variables }      $   IF iphd_rec_status = VALID_DATA THEN iphd_rec_status := UPDATED_DATA; $        END;  { WITH Global Variables }  END;  { UpdatedIphd }       $TITLE 'UpdatedPr',PAGE$  {------------------------------------------------------------}  {              UpdatedPr                                     }  {------------------------------------------------------------}      
PROCEDURE UpdatedPr; 
     {}  {  Description  {     This procedure will set the path record to the  
{     UPDATED_DATA status. 
 {   {     It will only set it to this state if it was VALID data  {     before, (i.e. If the status was INVALID_DATA, this  {     procedure will leave the record in that state to prevent  {     bad information being copied into DSAM).  {   {}  {  Side Effects   !{     As a result of the record being set to UPDATED_DATA status,  !  {     it may be posted into DSAM when SaveState or SavePathState   	{     are called.  	 {}  
{  Global Data Structures  
 {     gv_path_rec  IN/OUT   The variable being operated on  {}  	{  Error Handling  	 {     none  {}  {  Algorithm  	{     see the code 	 {}      
BEGIN { UpdatedPr }  
 
WITH gv_path_rec DO  
    BEGIN { WITH Global Variables }      "   IF pr_rec_status = VALID_DATA THEN pr_rec_status := UPDATED_DATA; "        END;  { WITH Global Variables }  
END;  { UpdatedPr }  
     $TITLE ' ',PAGE$  (*  $TITLE 'template',PAGE$   {------------------------------------------------------------}  {           template                                         }  {------------------------------------------------------------}      {}  { Description   {}  { Parameters  {   {   {   {   {   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}      	BEGIN { Template } 	 	END;  { Template } 	     *)      	$TITLE 'The End'$  	 
END   { IMPLEMENT }  
 .     { End of File }  