 $PASCAL ',7 91790-1X109 REV.4010 <860130.1120>'   
$STANDARD_LEVEL 'HP1000' $ 
 $DEBUG $  $RECURSIVE OFF$   $HEAP 0$      MODULE LanUI;   
$ ALIAS 'N$LANUI' $  
     %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : LANUI   {      SOURCE : 91790-18109   
{       RELOC : none 
 
{        PGMR : ASH  
 {}      ${----------------------------------------------------------------------- $    MODIFICATIONS  "     8/15/85  JXL  Weeded out unnecessary parts of the search list.  "      11/14/85      Check for characters where '-' expected.   % -----------------------------------------------------------------------}  % {}  { MODULE DESCRIPTION :  !{  This is an amalgamation of all the procedures needed to convert ! "{  LAN station addresses in hex format (xx-xx-xx-xx-xx-xx), used by  " #{  humans, to the internal format (array of 3 Int16s) used by the LAN  # {  software, and from the internal format to the hex format.  {   {  The name: LAN U(se)r I(nterface) (routines)  {}          IMPORT     $search 'phtm/bodec.rel'   bodec;      EXPORT  TYPE     UserFormat     = PACKED ARRAY [0..16] of CHAR;   $   Hexd = 0..15;                    { decimal value of the hex digits }  $    InternalWord = RECORD CASE BOOLEAN OF        TRUE : (int : Int16);         FALSE : (hd : PACKED ARRAY [1..4] OF hexd);         END;          PROCEDURE InternalToUser     (VAR SA : StatAddr;      VAR StationAddress : UserFormat);           FUNCTION Numchk      (VAR numstr : String)     : Boolean;           PROCEDURE UserToInternal  
   (VAR instring : String; 
     VAR StatAddress : StatAddr;   
    VAR ierr     : Int16); 
         IMPLEMENT   $ SUBTITLE 'Numchk', PAGE $   {---------------------------------------------------}   {                Numchk                             }   {---------------------------------------------------}           FUNCTION Numchk      (VAR numstr : String)        : BOOLEAN;      { Discussion:   "{  Procedure to check to see whether a string contains only numeric  " {  characters.  {   { Parameters:   {  numstr      INPUT       string to check  {}      VAR      Numeric : Boolean;      Pos : Int16;      { Character position within parm }      Len : Int16;      { Length of parm }       	BEGIN  { Numchk }  	 numeric := TRUE;  pos := 1;   len := strlen (numstr);       IF len > 0 THEN      BEGIN     REPEAT         CASE (numstr[pos]) OF         '0'..'9': BEGIN                   pos := pos + 1   { move on to next one }  
                END  
       Otherwise BEGIN                   numeric := FALSE  
                END  
       END;     UNTIL (pos > len) OR (NOT numeric);         numchk := (numeric = TRUE);     END { if something to check }  ELSE     BEGIN  	   numchk := FALSE 	    END;       END;  {Numchk }       $SUBTITLE 'InternalToUser', PAGE $  {-----------------------------------------------}   
{           InternalToUser 
 {-----------------------------------------------}   "{ Procedure to convert LAN station addresses to hex (user) format }  " { Internal format is an array of three Int16; User format   {  is a packed array of char of the form:   {   {           XX-XX-XX-XX-XX-XX   {  where x is any valid hex digit.  {}          PROCEDURE InternalToUser     (VAR SA : StatAddr;      VAR StationAddress : UserFormat);       TYPE     HexChars = Array [hexd] of CHAR;       CONST   #   TABLE = HexChars ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', #                      'A', 'B', 'C', 'D', 'E', 'F'];       VAR      i, j : Int16;  	   index : Int16;  	    dashcount : Int16;      digit : InternalWord;      BEGIN   	   dashcount := 0; 	    index := 0;         FOR i := 1 to 3 DO         BEGIN   "      digit.int := SA[i];  { get the word from the station address } "       FOR j := 1 TO 4 DO           BEGIN           IF (index MOD 3 = 2) THEN  	            BEGIN  	             StationAddress[index] := '-';               dashcount := dashcount + 1;               index := index + 1;               END;           StationAddress[index] := TABLE [digit.hd[j]];           index := Index + 1;  { move to the next character }           END;         END;  END;  { InternalToUser }      $ SUBTITLE 'UserToInternal', page$  {------------------------------------------------}  {             User to Internal                   }  {------------------------------------------------}  PROCEDURE UserToInternal  
   (VAR instring : String; 
     VAR StatAddress : StatAddr;   
    VAR ierr     : Int16); 
 {}  { Discussion:   !{  Procedure to convert hex format to an array of three integers } ! {}          LABEL      99;  CONST      UFLEN = 17;  { length of the address in user format }      VAR      validaddr : Boolean;      pos       : Int16;      i,j       : Int16;   
   curchar   : CHAR; 
 
   curstr    : String[1];  
    digit     : InternalWord;      BEGIN       ierr := 0;  instring := Strrtrim (instring);  instring := Strltrim (instring);  IF strlen (instring) <> UFLEN THEN     BEGIN     ierr := -1;     goto 99;      END;       pos := 1;   	validaddr := TRUE; 	 i := 1;   j := 1;       WHILE (pos <= UFLEN) AND (validaddr) DO   	   BEGIN { while } 	    curchar := instring[pos];     curstr := '';     strmove (1,instring,pos,curstr,1);       	   CASE curchar OF 	    '0'..'9', 'a'..'f', 'A'..'F':        BEGIN         validaddr := (pos MOD 3 = 1) OR (pos MOD 3 = 2);        digit.hd[i] := hex(curstr);   	      i := i + 1;  	       END;         '-' :        BEGIN         IF pos MOD 3 <> 0 THEN validaddr := FALSE;        END;         Otherwise validaddr := FALSE;  	   END;  { case }  	        pos := pos + 1;   { move to next char }         IF (validaddr) AND (i > 4) THEN        BEGIN         StatAddress[j] := digit.int;  	      j := j + 1;  	       i := 1;         END;      	   END;  { while } 	     IF NOT validaddr THEN ierr := -1;       99:   END;  { usertointernal }  END. 