 $PASCAL '91790-16111 REV.4010 <860403.1741>'  
$STANDARD_LEVEL 'HP1000' $ 
 $RUN_STRING 256   $DEBUG $  $RECURSIVE OFF$   $HEAP 0$      PROGRAM LogChg;       %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT-PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : LogChg  {      SOURCE : 91790-18111   {       RELOC : 91790-16111   
{        PGMR : ASH  
 {}      ${----------------------------------------------------------------------- $    MODIFICATIONS  5/03/85   "   change to trace mask from severity.  Delete proto specific stuff  "     6/11/85      Be sure bit 0 in the mask is always set. (For BREVL).      11/10/85      Modify numchk to accept only values in the acceptable range.       Add Getmask routine to convert octal input to decimal.      Read/write log mask from DS_Logmask   3/18/86     Extend trace mask to trace mask expr   % -----------------------------------------------------------------------}  % {}  { PROGRAM DESCRIPTION :   "{  Program to change the values in DSAM which determine the severity " 
{  of error logging. 
 {  All values will be determined from runstring parameters.   {              LOGCHG [[+|-]<logmask>]...   
{  <logmask> may be: 
 '{     *                                    (which means, "the current value")  ' 	{     Octal digits 	 {     Octal digits followed by b  {     LOGSTATS  {     PROLOG  {     EVENT   {     WARNING   {     ERROR   {     DISASTER  	{     RESOURCELIM  	 {     TESTMSG   {   {}      IMPORT            $SEARCH  'phtm/bodec.rel'   bodec,        $SEARCH  'phtm/sodec.rel'   sodec,        $SEARCH  'phtm/mmdec.rel'   mmdec,        $search  'phtm/mmext.rel'   ds_mm,        $SEARCH 'phtm/trcmod.rel'   trcmod;           CONST   '   MAXMASK     = 255;                                       { bits 0..7 set }  '    USAGENOTE   = 'Usage: LOGCHG [{+|-|,| }<logmask>]...';       TYPE     pac      =  PACKED ARRAY [1..256] OF Char;   
   pacptr   =  ^pac; 
    st       =  String[256];       VAR   
   ierr     : Int16; 
    instr    : St;           { input string }     mask     : MMFlagsType;  { log mask converted }     outfile  : TEXT;  { output file for error messages }      warn     : BOOLEAN;  { used for output warning }   
   wkmp     : Int16; 
     	PROCEDURE AddValue 	    (VAR  numstr   :  String;      VAR  pos      :  Int16;       VAR  logmask  :  Int16 );      FORWARD;       PROCEDURE CNUMO      (     n  :  Int16;       VAR  b  :  Pac );      EXTERNAL;      
PROCEDURE CritReject 
    (ierr  :  Int16 );      FORWARD;       FUNCTION Current     :  Int16;     FORWARD;       FUNCTION IAND      $DIRECT  
   (  i, j : Int16 ) 
    :  Int16;     EXTERNAL;      FUNCTION IOR     $DIRECT  
   (  i, j : Int16 ) 
    :  Int16;     EXTERNAL;      'FUNCTION IXOR                 { This IS right!  IXOR is .ENTR, the others   }  ' '   (  i, j : Int16 )          { .ENTN                                       }  '    :  Int16;     EXTERNAL;      FUNCTION Number      (VAR  numstr   :  String;      VAR  pos      :  Int16 )     :  Int16;     FORWARD;       FUNCTION Numchk      (VAR numstr    : String;   
    VAR logmask   : Int16) 
                   : Boolean;     FORWARD;       FUNCTION  Pas_SParms          $ ALIAS 'Pas.SParameters'$  
   (    pos : Int16; 
     VAR str : String)         : Int16;     EXTERNAL;      PROCEDURE Pas_StrEndCheck     $ ALIAS 'Pas.StrEndCheck'$  
   (  check :  Boolean  ); 
    EXTERNAL;      FUNCTION Pas_StringData       $ ALIAS 'Pas.StringData1'$     (  VAR   s  :  String   )     :  PacPtr;      EXTERNAL;      PROCEDURE Reject     (VAR  instr :  String );      FORWARD;       PROCEDURE SkipWhiteSpace     (  VAR   pos   :  Int16;         VAR   s     :  String );     FORWARD;       PROCEDURE SplitString   
   $FIXED_STRING ON  
    ( VAR instring, item, outstring : String );  
   $FIXED_STRING OFF 
    EXTERNAL;      PROCEDURE SubtractValue      (VAR  numstr   :  String;      VAR  pos      :  Int16;       VAR  logmask  :  Int16 );      FORWARD;       	FUNCTION Symbolic  	    (VAR  numstr   :  String;      VAR  pos      :  Int16 )     :  Int16;     FORWARD;       FUNCTION TrimLen  
   $FIXED_STRING ON  
    (VAR  s  :  String )      :  Int16;  
   $FIXED_STRING OFF 
    EXTERNAL;      $ SUBTITLE 'ADDVALUE            ', PAGE $   '{---------------------------------------------------------------------------}  ' '{                                                                           }  ' '{                       ADDVALUE                                            }  ' '{                                                                           }  ' '{---------------------------------------------------------------------------}  ' {   {  Purpose: To add a value (one or more logmask bits) into the  {     accumulating logmask.   {   {  Parameters:  {     numstr   INPUT    The string being parsed   {     pos      IN/OUT   The current position within the string  {     logmask  IN/OUT   The accumulating logmask  {  Side effects:  "{     Calls Reject (and, therefore, halts the program) if bad input  " 	{     is detected. 	 {   {}  	PROCEDURE AddValue 	    (VAR  numstr   :  String;      VAR  pos      :  Int16;       VAR  logmask  :  Int16 );       
BEGIN {  AddValue }  
     IF ( pos > StrLen ( numstr ) ) THEN      BEGIN {  Ran off the end }      Reject ( numstr );      END;  {  Ran off the end }       
CASE numstr[pos] OF  
    '*'      : BEGIN  {  Current value }      logmask := IOR ( logmask, Current );   	   pos := pos + 1; 	    SkipWhiteSpace ( pos, numstr );     END;              {  Current value }          '0'..'7' : BEGIN  {  Numerical value }      logmask := IOR ( logmask, Number ( numstr, pos ));      END;              {  Numerical value }          'A'..'Z' : BEGIN  {  Symbolic Value }     logmask := IOR ( logmask, Symbolic ( numstr, pos ));      END;              {  Symbolic Value }         OTHERWISE BEGIN   {  Bogus value }      Reject ( numstr );      END;              {  Bogus value }          END;  {  CASE numstr[pos] OF }       
END;  {  AddValue }  
     $ SUBTITLE 'CritReject', page   '{---------------------------------------------------------------------------}  ' '{                                                                           }  ' '{                             CritReject                                    }  ' '{                                                                           }  ' '{---------------------------------------------------------------------------}  ' {    {  Purpose: To reject a request because we can't enter critical    {   {  Parameters:   {     ierr     INPUT    The error returned from DS_EnterCritical   {   {  Side effects:  {     Halts the program   {}  
PROCEDURE CritReject 
    (ierr  :  Int16 );       BEGIN {  CritReject   }   'writeln (outfile, 'LOGCHG: Access to DSAM not allowed.  Error code ',ierr:1);  ' halt ( 1 );   END;  {  CritReject   }       $ SUBTITLE 'CURRENT             ', PAGE $   '{---------------------------------------------------------------------------}  ' '{                                                                           }  ' '{                          CURRENT                                          }  ' '{                                                                           }  ' '{---------------------------------------------------------------------------}  ' {   {  Purpose: To return the current setting of LOGMASK.   
{  Parameters: None  
 {  Returns:    The current log mask   {  Side Effects:  Aborts LogChg, if it can't enter critical   {   {}  FUNCTION Current     :  Int16;      VAR      wkmp     :  Int16;      ierr     :  Int16;      logmask  :  Int16;       
BEGIN {  current  }  
     DS_EnterCritical (wkmp, ierr);  	IF ierr <> 0 THEN  	    BEGIN     CritReject ( ierr );      END;   DS_FetchGlobal (DS_LogMask, 1, logmask);  
DS_LeaveCritical ( wkmp ); 
     
Current := logmask;  
     
END;  {  current  }  
     $ SUBTITLE 'NUMBER              ', PAGE $   '{---------------------------------------------------------------------------}  ' '{                                                                           }  ' '{                          NUMBER                                           }  ' '{                                                                           }  ' '{---------------------------------------------------------------------------}  ' {   {  Purpose: Returns a numerical value, as represented by the  
{     numstr[pos...] 
 {  Parameters:   {     numstr      INPUT    The string whence to parse the number   {     pos         IN/OUT   Where to start   {     (return)    OUTPUT   The numerical value  {  Side Effects:  "{     Calls Reject (and therefore halts the program) if the head of  " {     numstr isn't a valid octal number.  {   {}  FUNCTION Number      (VAR  numstr   :  String;      VAR  pos      :  Int16 )     :  Int16;      VAR      initialpos  :  Int16;      
BEGIN {  Number   }  
     	initialpos := pos; 	     WHILE ( pos <= StrLen ( numstr ) ) AND        ( numstr[pos] >= '0' )       AND        ( numstr[pos] <= '7' )           DO      BEGIN {  Scan to the end of the number }   	   pos := pos + 1; 	    END;  {  Scan to the end of the number }       !Number := Octal ( Str ( numstr, initialpos, (pos-initialpos) ) );  !     IF ( pos <= StrLen ( numstr ) ) AND ( numstr[pos] = 'B' ) THEN     BEGIN {  Optional and redundant B specified }  	   pos := pos + 1; 	    END;  {  Optional and redundant B specified }      SkipWhiteSpace ( pos, numstr );       
END;  {  Number   }  
     $ SUBTITLE 'NUMCHK              ', PAGE $   %{-----------------------------------------------------------------------}  % {   {                        FUNCTION Numchk  {   %{-----------------------------------------------------------------------}  %     FUNCTION Numchk      (VAR numstr    : String;   
    VAR logmask   : Int16) 
       : BOOLEAN;      { Discussion:   {  Procedure to parse the new log mask from the run string.   {  It also does range checking on the mask.   {  Caller must call with a numstr of at least three elements.   {   { Parameters:   {  numstr      OUTPUT      The log mask part of the runstring   {  logmask     OUTPUT      the new log mask   {  (return)    OUTPUT      Was the new log mask valid?  {}      VAR      junk: String[256];      Pos : Int16;      { Character position within parm }      Len : Int16;      { Length of parm }      ierr: Int16;      { Length of parm }       	BEGIN  { Numchk }  	     SetStrLen ( junk, StrMax(junk) );   SplitString ( numstr, junk, numstr ); { Junk := 'RU' }  SplitString ( numstr, junk, numstr ); { Junk := 'LOGCHG' }  SetStrLen ( numstr, TrimLen ( numstr ) );       pos := 1;   SkipWhiteSpace ( pos, numstr );   IF ( numstr[pos] = '+' ) OR      ( numstr[pos] = '-' ) THEN      BEGIN {  Start with the current logmask }     logmask := Current;     END   {  Start with the current logmask }  ELSE     BEGIN { Build a whole new logmask }     logmask := 0;     END;  { Build a whole new logmask }      WHILE ( pos <= StrLen ( numstr ) ) DO      BEGIN {  Chew down the string, assembling the logmask }     CASE numstr[pos] OF        '+' : BEGIN  {  Add in a value }        pos := pos + 1;         SkipWhiteSpace ( pos, numstr );         AddValue ( numstr, pos, logmask );        END;         {  Add in a value }            '-' : BEGIN {  Delete a value }         pos := pos + 1;         SkipWhiteSpace ( pos, numstr );         SubtractValue ( numstr, pos, logmask );         END;        {  Delete a value }             OTHERWISE BEGIN   {  Implied addition }         AddValue ( numstr, pos, logmask );        END;              {  Implied addition }             END;  {  CASE numstr[pos] OF }         END;  {  Chew down the string, assembling the logmask }      numchk := ((logmask >= 0) AND (logmask <= MAXMASK));      END;  {Numchk }       $ SUBTITLE 'SkipWhiteSpace           ', PAGE $  '{---------------------------------------------------------------------------}  ' '{                                                                           }  ' '{                          SkipWhiteSpace                                   }  ' '{                                                                           }  ' '{---------------------------------------------------------------------------}  ' {   {  Purpose: To scan past any white space in a string.   {     "WhiteSpace" is defined as:   {        blank  {        comma  {        tab  {   {}  PROCEDURE SkipWhiteSpace     (  VAR   pos   :  Int16;         VAR   s     :  String );      CONST      TAB   =  #9;       
BEGIN {  SkipWhiteSpace }  
     WHILE ( pos <= StrLen ( s ) )       AND         ( ( s[pos] = ' ' ) OR           ( s[pos] = ',' ) OR           ( s[pos] = TAB )        ) DO     BEGIN {  Skip it  }  	   pos := pos + 1; 	    END;  {  Skip it  }      
END;  {  SkipWhiteSpace }  
     $ SUBTITLE 'SubtractVALUE            ', PAGE $  '{---------------------------------------------------------------------------}  ' '{                                                                           }  ' '{                       SubtractVALUE                                       }  ' '{                                                                           }  ' '{---------------------------------------------------------------------------}  ' {   #{  Purpose: To Subtract a value (one or more logmask bits) out of the  # {     accumulating logmask.   {   {  Parameters:  {     numstr   INPUT    The string being parsed   {     pos      IN/OUT   The current position within the string  {     logmask  IN/OUT   The accumulating logmask  {  Side effects:  "{     Calls Reject (and, therefore, halts the program) if bad input  " 	{     is detected. 	 {   {}  PROCEDURE SubtractValue      (VAR  numstr   :  String;      VAR  pos      :  Int16;       VAR  logmask  :  Int16 );       BEGIN {  SubtractValue }      IF ( pos > StrLen ( numstr ) ) THEN      BEGIN {  Ran off the end }      Reject ( numstr );      END;  {  Ran off the end }       
CASE numstr[pos] OF  
    '*'      : BEGIN  {  Current value }      logmask := IAND ( logmask,         IXOR ( -1, Current ) );      END;              {  Current value }          '0'..'7' : BEGIN  {  Numerical value }      logmask := IAND ( logmask,         IXOR ( -1, Number ( numstr, pos )));     END;              {  Numerical value }          'A'..'Z' : BEGIN  {  Symbolic Value }     logmask := IAND ( logmask,         IXOR ( -1, Symbolic ( numstr, pos )));     END;              {  Symbolic Value }         OTHERWISE BEGIN   {  Bogus value }      Reject ( numstr );      END;              {  Bogus value }          END;  {  CASE numstr[pos] OF }       END;  {  SubtractValue }      
$ SUBTITLE 'Reject', page  
 '{---------------------------------------------------------------------------}  ' '{                                                                           }  ' '{                             REJECT                                        }  ' '{                                                                           }  ' '{---------------------------------------------------------------------------}  ' {   {  Purpose: To reject a runstring as unsuitable.  {   {  Parameters:  {     instr    INPUT    The log mask part of the runstring  {   {  Side effects:  {     Halts the program   {}  PROCEDURE Reject     (VAR  instr :  String );       
BEGIN {  Reject   }  
  writeln (outfile,'LOGCHG: "',instr,'" is not a legal logmask.');   writeln (outfile,USAGENOTE );   halt ( 1 );   
END;  {  Reject   }  
     
$SUBTITLE 'Symbolic', PAGE 
 '{---------------------------------------------------------------------------}  ' '{                                                                           }  ' '{                          SYMBOLIC                                         }  ' '{                                                                           }  ' '{---------------------------------------------------------------------------}  ' {   {  Purpose: To return a numerical value determined by the   {     symbolic value in numstr[pos...].   {   {  Parameters:  {     numstr      INPUT    The string to read   {     pos         IN/OUT   Where to start   ${     (return)    OUTPUT   The numerical value represented by the string $ {  Side Effects:  !{     Calls Reject (and therefore halts the program) if an illegal ! {     symbol is read.   {   {}  	FUNCTION Symbolic  	    (VAR  numstr   :  String;      VAR  pos      :  Int16 )     :  Int16;      TYPE     BitType  =  ARRAY [0..15] OF Int16;      CONST   	   SYMBOLICTERMS = 	 $WIDTH 132  2'LOGSTATS    PROLOG      EVENT       WARNING     ERROR       DISASTER    RESOURCELIM TESTMSG     ';  2 $WIDTH 80          BIT      =  BitType [        BIT0,         BIT1,         BIT2,         BIT3,         BIT4,         BIT5,         BIT6,         BIT7,         BIT8,         BIT9,         BIT10,        BIT11,        BIT12,        BIT13,        BIT14,        BIT15,     ];       VAR      initialpos  :  Int16;     value       :  Int16;      
BEGIN {  Symbolic }  
     
initialpos  := pos;  
 WHILE ( pos <= StrLen ( numstr ) ) AND     ( numstr[pos] >= 'A' ) AND      ( numstr[pos] <= 'Z' ) DO     BEGIN {  Advance through the symbol }  	   pos := pos + 1; 	    END;  {  Advance through the symbol }      value := StrPos ( SYMBOLICTERMS,                    Str ( numstr, initialpos, (pos-initialpos) )  	                ); 	     IF ( ( pos - initialpos ) < 2 ) OR     ( value = 0 )                THEN  
   BEGIN {  bogus value }  
    Reject ( numstr );   
   END   {  bogus value }  
 ELSE     BEGIN {  OK value }     value := (value - 1) DIV 12;      IF ( value >= 0 ) AND ( value <= 15 ) THEN         BEGIN         Symbolic := BIT[value];         END      ELSE         BEGIN         Reject ( numstr );        END;     END;  {  OK value }      SkipWhiteSpace ( pos, numstr );       
END;  {  Symbolic }  
     $ SUBTITLE 'LogChg Main Program', page      	BEGIN  { logchg }  	     
Pas_StrEndCheck ( FALSE ); 
     rewrite (outfile, '1');   IF ( Pas_SParms (1, instr) < 0 ) THEN      BEGIN     writeln (outfile, USAGENOTE );      halt ( 1 );     END;       SetStrLen ( instr, 0 );   ierr := Pas_SParms ( -1, instr );   IF NOT numchk (instr, mask.int) THEN     BEGIN  
   Reject ( instr ); 
    END;       IF mask.bits[0] = FALSE THEN     BEGIN     { make sure bit 0 is always set }     mask.bits[0] := TRUE;  "   instr[StrLen ( instr )] := chr (ord(instr[StrLen ( instr )])+1);  "    warn := TRUE;     END;       DS_EnterCritical (wkmp, ierr);  	IF ierr <> 0 THEN  	    BEGIN     CritReject ( ierr );      END;       DS_StoreGlobal (DS_LogMask, 1, mask.int);   DS_LeaveCritical (wkmp);      SetStrLen ( instr, 6 );   CNUMO ( mask.int, Pas_StringData(instr)^ );   write (outfile, 'LOGCHG: New log mask is ',instr,'B.');   IF warn THEN write (outfile, '  Bit 0 must always be set.');  writeln (outfile);   { print it }       halt ( 0 );       END. 