 $PASCAL ',7 91790-1X112 REV.4010 <860310.1520>'   $ TITLE 'NS/1000 LU Information' $  
$STANDARD_LEVEL 'HP1000'$  
 $HEAP 0   $HEAPPARMS OFF  $RANGE OFF  $RECURSIVE OFF  	$PARTIAL_EVAL ON$  	 $DEBUG$   $AUTOPAGE ON$   $CODE_INFO ON$  	$CODE_OFFSETS ON$  	         $TITLE 'MODULE Descripton'$   {}  ${ This Module contains the exported subroutines for used to retrieve and $ ${ present information related to NS/1000 LUs. These routines are called  $ { by the NS/1000 utility NSINF.   {}      MODULE LUINF;   	$ALIAS 'N$LUINF'$  	     {}  {-------------------------------------------------------------  {   { (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS  { RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   { REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT  { THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   {   {-------------------------------------------------------------  {}      {}  	{      NAME: LUINF 	 {    SOURCE: 91790-18112  {     RELOC: 91790-1X112  {      PGMR: EW   {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date     Prgmr  Description  { 08/14/85  EW     SEARCH DRES.XPT and INIT_DEC.REL   { 09/04/85  EW     Report error when reading LAN card.  { 09/05/85  EW     Don't display MORE after last DVT entry.   { 09/05/85  EW     Format changes.  { 09/05/85  EW     Fix LAN info. to match new statistics.   { 09/05/85  EW     Add HDLC header, more info in BSC header   { 11/21/85  EW     Added Module ALIAS.  "{ 01/10/86  ash    Make a few changes in the LAN card stats display, " {                  per request from RND   ${  1/30/86  ash    Change dvt6 declaration in LAN card status to report  $ {                  error from driver (SR#33662)   {------------------------------------------------------------   {}      {}  $TITLE 'IMPORT Section'$      IMPORT            $SEARCH 'phtm/BODEC.REL'$   BODEC,            $SEARCH 'phtm/MMDEC.REL'$   MMDEC,            $SEARCH 'phtm/MMEXT.REL'$   DS_MM,            $SEARCH 'phtm/SODEC.REL'$   SODEC,            $SEARCH 'phtm/INFLB.REL'$   INFLB,            $SEARCH 'phtm/init_dec.rel' $   INIT_DEC,             $SEARCH 'phtm/dres.xpt'$  DRES;       $TITLE 'EXPORT Section',PAGE$   {------------------------------------------------------------}  {              Export Section                                }  {------------------------------------------------------------}      EXPORT          PROCEDURE DVINF      (VAR info: InforecordType);      PROCEDURE LUINF      (VAR info: InfoRecordType);      PROCEDURE IOINF      (VAR info: InforecordType);      $TITLE 'IMPLEMENT Section',PAGE$  {------------------------------------------------------------}  {              Implement Section                             }  {------------------------------------------------------------}  IMPLEMENT       CONST           ASCII = 48;     { 60B for conversion of binary 0-9 to ASCII}       BSC = 0;        { Board Type for BSC }      HDLC = 1;       { Board Type for HDLC }  
   ID66_EXTENT_SIZE = 20;  
    JUSTIFY = -1;   { for formatting rouitnes }     MAXIFTLEN = 21; { maximum IFT + extent we ever want }     MAXLINES = 24;  { maximum lines to display on a screen}     MAXLU = 255;    { maximum LU we can ever have }     MINLU = 1;      { minimum LU we can ever have }     NOERROR = 0;      NOMORELUS = -2; { error returned by getlu }     NOSUCHLU = -1;  { error returned by getlu }      TYPE66 = 54;    { device type for DVA66 devices (and X.25) }       TYPE67 = 55;    { device type LAN driver }           TYPE         ControlType = PACKED RECORD                   ov          : Posint2;                    fil1        : Posint6;                    lu          : Posint8;                    subfunction : Posint10;                   fil2        : Posint6;                    END;          DvrBitType = PACKED RECORD                   vcp_wait      : Posint1;                  reconnect     : Posint1;                  sever_error   : Posint1;                  initialized   : Posint1;                  non_ds        : Posint1;                  start_message : Posint1;                  connected     : Posint1;                  long_timeout  : Posint1;                  med_timeout   : Posint1;                  short_timeout : Posint1;                  write_locked  : Posint1;                  read_locked   : Posint1;                  write_pending : Posint1;                  read_pending  : Posint1;                  write_aborted : Posint1;                  read_aborted  : Posint1;                  END; { record }       
   DVTType = PACKED RECORD 
              dvt1         : Int16;               dvt2         : Int16;               dvt3         : Int16;               dvt4         : Int16;               dvt5         : Int16;               availability : Posint2;               devicetype   : Posint6;               status       : Posint7;               error        : BOOLEAN;               dvt7         : Int16;               dvt8         : Int16;               dvt9         : Int16;               dvt10        : Int16;               dvt11        : Int16;               dvt12        : Int16;               dvt13        : Int16;               dvt14        : Int16;               dvt15        : Int16;               dvt16        : Int16;               dvt17        : Int16;               dvt18        : Int16;               dvt19        : Int16;               dvt20        : Int16;               dvt21        : Int16;               dvt22        : Int16;               dvt23        : Int16;               dvt24        : Int16;               dvt25        : Int16;  	             END;  	        Ift11Type = RECORD CASE BOOLEAN OF                  TRUE  : (dvr : DVRBitType);                 FALSE : (int : Int16 );  
               END;  
     
   IftType = PACKED RECORD 
              timeoutlist  : Int16;               timeout      : Int16;               q            : BOOLEAN;               requestlist  : Posint15;                driver       : Int16;               dvtaddress   : Int16;               availability : Posint2;               eqttype      : Posint6;               fill1        : Posint2;               selectcode   : Posint6;               sysflags     : Posint5;               i            : BOOLEAN;               m            : BOOLEAN;               extentsize   : Posint9;               driverpage   : Int16;               ift9         : Int16;               iftx1        : Int16;               iftx2        : Int16;               iftx3        : Int16;               iftx4        : Int16;               iftx5        : Int16;               iftx6        : Int16;               iftx7        : Int16;               iftx8        : Int16;               iftx9        : Int16;               iftx10       : Int16;               iftx11       : Ift11Type;               iftx12       : Int16;  	             END;  	        BisyncStatType = PACKED RECORD                       Good_Blocks_Sent : Int16;                       Good_Blocks_Rcvd : Int16;                       Naks_Sent        : Int16;                       Naks_Rcvd        : Int16;                       Wacks_Sent       : Int16;                       Wacks_Rcvd       : Int16;                       Ttds_Sent        : Int16;                       Ttds_Rcvd        : Int16;                       Response_Errors  : Int16;                       Short_Timeouts   : Int16;                       Line_Errors      : Int16;                       Automatic_Reconnects : Int16;                       Fill1            : Posint12;                      Board_Type       : Posint4;                       Rev_code         : Int16;                       speed            : Posint3;                       fill2            : BOOLEAN;                       direct_connect   : BOOLEAN;                       wait_for_ring    : BOOLEAN;                       clock            : BOOLEAN;                       fcl_enabled      : BOOLEAN;                       fill3            : Posint7;                       hood_sensed      : BOOLEAN;                       Trace_Length     : Int16;                       Id_Number        : Posint4;                       Id_Length        : Posint4;                       Mode             : Posint8;                       Retry_Limit      : Posint8;                       Connect_timer    : Posint8;                       Data_Block_Size  : Int16;                       Intermediate_Size : Int16;                      Header_Size      : Int16;                       fill4            : Posint7;                       Secondary        : BOOLEAN;                       fill5            : Posint8;                       END;         HdlcStatType = PACKED RECORD                     good_frames_rcvd    : Int16;                    rr_frames_rcvd      : Int16;                    rnr_frames_rcvd     : Int16;                    reject_frames_rcvd  : Int16;                    overruns            : Int16;                    crc_errors          : Int16;                    aborts_received     : Int16;                    receiver_overruns   : Int16;                    rx_buffer_overflows : Int16;                    bad_address         : Int16;                    cmdr_frames         : Int16;                    fill1               : Int16;                    fill2               : Posint12;                     board_type          : Posint4;                    rev_code            : Int16;                    speed               : Posint3;                    fill3               : Posint3;                    frame128            : BOOLEAN;                    fcl_enabled         : BOOLEAN;                    fill4               : Posint7;                    hood_sensed         : BOOLEAN;                    fill5               : Posint5;                    k                   : Posint3;                    n2_retries          : Posint8;                    timeout             : Int16;                    END;         LanStatsType = PACKED RECORD                     rev_code          : Int16;                    good_bytes_sent   : Int32;                    good_bytes_rcvd   : Int32;                    good_packets_sent : Int32;                    good_packets_rcvd : Int32;                    errors_on_xmit    : Int16;                    errors_on_recv    : Int16;                    babble_errors     : Int16;                    heart_beat_errors : Int16;                    missed_packets    : Int16;                    memory_errors     : Int16;                    framing_errors    : Int16;                    discarded_packets : Int16;                    crc_errors        : Int16;                    length_errors     : Int16;                    multiple_retries  : Int16;                    no_retries        : Int16;                    xmit_deferral     : Int16;                    underflows        : Int16;                    late_collisions   : Int16;                    loss_of_carrier   : Int16;                    retry_exceeded    : Int16;                    tdr_info          : Int16;                    END;           LanStatusType = PACKED RECORD                       unused          : Posint4;                        lost_novr_data  : Posint1;                        last_wt_failed  : Posint1;                        link_wt_pending : Posint1;                        ui_pending      : Posint1;                        wait_for_tx_buf : Posint1;                        rcv_pac_avail   : Posint1;                        no_rx_buffers   : Posint1;                        mau_power_fail  : Posint1;                        multicast_en    : Posint1;                        broadcast_en    : Posint1;                        promis_en       : Posint1;                        novram2_en      : Posint1;                        END; { record }         RmparType = PACKED ARRAY [1..5] OF LanStatusType;         StatType = RECORD CASE INTEGER OF                0 : (BSC  : BisyncStatType);                1 : (HDLC : HdlcStatType);                2 : (LAN  : LanStatsType);  	              END; 	         $SUBTITLE 'Global Variables', PAGE$       VAR       
   buffer     : Charray78; 
    dvt        : DvtType;     first_call : BOOLEAN;     ift        : Ifttype;     iftlen     : Int16;     lu         : Int16;     next       : Int16;     stoplu     : Int16;     temp       : Int16;      $SUBTITLE 'External Procedures', PAGE$   {--------------------------------------------------------------}    {   External Procedures                                        }    {--------------------------------------------------------------}       FUNCTION break : Boolean;         $ ALIAS 'IFBRK'$     EXTERNAL;          $PROCEDURE GetLu                     { Macro procedure to return       }  $ $   (VAR lu    : Int16;              { DVT and IFT information for the }  $ $    VAR dvt   : DVTType;            { specified LU.                   }  $     VAR ift   : IftType;      VAR iftln : Int16;      VAR error : Int16);      EXTERNAL;          "PROCEDURE GetBoardStats             { Routine to return PSI board  } " "   (VAR lu    : Int16;              { statistics. For the specified} " "    VAR stats : StatType;           { LU.                          } "     VAR error : Int16);      EXTERNAL;      #PROCEDURE GetLanStatus                       $ ALIAS 'XLUEX',NOABORT $ #    (    code    : Int16;          control : ControlType);      EXTERNAL;      #PROCEDURE GetLanStats                        $ ALIAS 'XLUEX',NOABORT $ # #   (    read_code : Int16;          { Read long term statistics from } # #        control   : ControlType;    { the LAN card                   } #     VAR stats     : StatType;   
        statlen   : Int16; 
         reset     : Int16);      EXTERNAL;      %PROCEDURE Rmpar                     { Subroutine used to return extended } % %   (VAR parms : RmparType);         { I/O status afetr XLUEX call.       } %    EXTERNAL;      $FUNCTION Unsigned                   { Convert 16 bit unsigned integer  } $ $   (    number : Int16) : INTEGER;  { to 32 bit signed (positive). int.} $    EXTERNAL;      $SUBTITLE 'Forward Procedures', PAGE$    {--------------------------------------------------------------}    {   Forward Procedures                                         }    {--------------------------------------------------------------}       PROCEDURE PrChrBuf       { Output the buffer as follows:  }      (VAR outbuf : Charray78;    { Write into this buffer      }          buffer1: Charray78;    {   ...and these characters   }          pos    : Int16;        {       (pos of chars)        }          len    : Int16);       {       (length for chars)    }     FORWARD;           PROCEDURE PrDecBuf       { Output the buffer as follows:  }      (VAR outbuf : Charray78;    { Write into this buffer      }          buffer : Charray78;    {   ...these characters       }          decnum : Int16;        {   ...and this number        }          pos    : Int16;        {       (pos for number)      }          justify: Int16);       {       (-1 to left justify)  }     FORWARD;           PROCEDURE PrintLine      { Output the buffer as follows:  }      (VAR outbuf : Charray78;    { Write into this buffer      }          buffer : Charray78);   {   ...these characters       }     FORWARD;       PROCEDURE ShowCard             { Determine card type and     }     (VAR lu     : Int16;        { display the statistics.     }  
    VAR dvt    : DvtType;  
 
    VAR ift    : IftType;  
     VAR iftlen : Int16);     FORWARD;        PROCEDURE ShowDvt              { Display the values of the DVT }      (VAR lu     : Int16;   
    VAR dvt    : Dvttype); 
    FORWARD;       $PROCEDURE ShowFlags            { Display the flag bits from IFT extent}  $ $   (VAR lu     : Int16;        { word x for DVA66.                    }  $ 
    VAR dvt    : DvtType;  
 
    VAR ift    : IftType;  
     VAR iftlen : Int16);     FORWARD;       	PROCEDURE ShowIft  	 
   (VAR lu  : Int16; 
     VAR ift : Ifttype);      FORWARD;       
PROCEDURE StuffChar  
    (VAR buffer : Charray78;    { Write into this buffer      }          buffer1: Charray78;    {   these characters          }          pos    : Int16;        {       (pos of chars)        }          len    : Int16);       {       (length for chars)    }     FORWARD;       PROCEDURE Userinput            { Determines from user input  }     (VAR startlu : Int16;       { which LUs to display.       }  
    VAR stoplu  : Int16);  
    FORWARD;       $SUBTITLE 'DVINF',PAGE$    {--------------------------------------------------------------}    {   DVINF                                                      }    {--------------------------------------------------------------}       PROCEDURE DVINF      (VAR info: InfoRecordType);          VAR      done      : BOOLEAN;      error     : Int16;   
   more_enabled : BOOLEAN; 
     
BEGIN { Procedure DVINF }  
     
   UserInput (lu, stoplu); 
 	   done := FALSE;  	    more_enabled := FALSE; { turn off MORE }          WHILE (NOT done) AND (NOT break) DO        BEGIN { while }   
      iftlen := MAXIFTLEN; 
       Getlu (lu, dvt, ift, iftlen, error);      
      CASE error OF  
     	         NOERROR : 	                BEGIN { no error case }                     CASE dvt.devicetype OF       
                  TYPE66 : 
                      BEGIN { TYPE66 case }  %                     IF (NOT more_enabled) OR (more_enabled AND More) THEN %                         BEGIN { user wans more }                          more_enabled := TRUE; { turn on MORE }                          ShowDVT (lu, dvt);  !                        IF ift.extentsize = ID66_EXTENT_SIZE THEN  !                            BEGIN { ID.66 LU }                              IF more THEN                                 BEGIN { user wants more }                                 ShowIft (lu, ift);                                END   { user wants more }                              ELSE                                 BEGIN { user doesn't want more }                                done := TRUE;                                 END;  { user doesn't want more }                             END;  { ID.66 LU }                           lu := lu + 1; { skip the read LU }                          END   { user wants more }   
                     ELSE  
                         BEGIN { no more }                           done := TRUE;                           END;  { no more }                        END;  { TYPE66 case }      
                  TYPE67 : 
                      BEGIN { TYPE67 case }  %                     IF (NOT more_enabled) OR (more_enabled AND more) THEN %                         BEGIN { user wants more }                           more_enabled := TRUE; { turn on MORE }                          ShowDVT (lu, dvt);                          lu := lu + 1; { skip the read LU }                          END   { user wants more }   
                     ELSE  
                         BEGIN { no more }                           done := TRUE;                           END;  { no more }                            END;  { TYPE67 case }                        OTHERWISE                        BEGIN { not an "NS" LU }                        END;  { not an "NS" LU }                         END; { case }                      END; { no error case }       
         NOSUCHLU :  
             ;       
         NOMORELUS : 
 
            done := TRUE;  
              END;  { case }             lu := lu + 1; { move to next LU }       
      IF lu > stoplu THEN  
          BEGIN { set done flag }           done := TRUE;           END;  { set done flag }         END; { WHILE loop }  
END;  { Procedure DVINF }  
     
$SUBTITLE 'ShowBSCStats'$  
  {--------------------------------------------------------------}    {   DISPLAY STATISTICS FROM THE Bisync card                    }    {--------------------------------------------------------------}       PROCEDURE ShowBSCStats (    lu        : Int16;                              stats : StatType);  {}  "{ This procedure formats and outputs the statistics in "STATS" using " "{ the BISYNC interpretation of the bits in the "STATS" array. It is  " ${ assumed that array stats does, in fact, contain valid statistics from  $ { a PSI card equiped with Bisync firmware.  {}  
   BEGIN { ShowBSCStats }  
        buffer :=  &      'BSC Board, Firmware Revision:xxxx, Speed:xxxxxxxx , xxxxxxxx Clock';  &    InsrtDec (buffer, stats.bsc.rev_code, 30, next, JUSTIFY);  
   CASE stats.bsc.speed OF 
       0: StuffChar (buffer, '  300 BPS', 42, 9);        1: StuffChar (buffer, ' 1200 BPS', 42, 9);        2: StuffChar (buffer, ' 2400 BPS', 42, 9);        3: StuffChar (buffer, ' 4800 BPS', 42, 9);        4: StuffChar (buffer, ' 9600 BPS', 42, 9);        5: StuffChar (buffer, '19.2K BPS', 42, 9);        6: StuffChar (buffer, '57.6K BPS', 42, 9);        7: StuffChar (buffer, '230 K BPS', 42, 9);     END; { case }      
   CASE stats.bsc.clock OF 
       TRUE  : StuffChar (buffer, 'External', 53, 8);        FALSE : StuffChar (buffer, 'Internal', 53, 8);     END; { case }         PrintLine ( buffer, buffer);          CASE stats.bsc.fcl_enabled OF        TRUE  : buffer :=                 'FCL enabled,';         FALSE : buffer :=                 'FCL disabled,';     END; { case }         CASE stats.bsc.hood_sensed OF  "      TRUE  : StuffChar (buffer, ' Diagnostic Hood sensed', 15, 24); " $      FALSE : StuffChar (buffer, ' Diagnostic Hood not sensed', 15, 28); $    END; { case }         PrintLine ( buffer, buffer);          PrintLine ( buffer, '');          buffer :=  $   '                Good Blocks Sent                  Good Blocks Rcvd'; $ $   InsrtDec (buffer, Unsigned(stats.bsc.Good_Blocks_Sent), 9, next, 0);  $ "   PrInsrtDec (buffer, Unsigned(stats.bsc.Good_Blocks_Rcvd), 42, 0); "        buffer :=  #   '                Bad Blocks Received               NAKs Received';  #     InsrtDec (buffer, Unsigned(stats.bsc.Naks_Sent), 9, next, 0);      PrInsrtDec (buffer, Unsigned(stats.bsc.Naks_Rcvd), 42, 0);          buffer :=  %   '                WACKs Sent                        WACKs Received    '; % !   InsrtDec (buffer, Unsigned(stats.bsc.Wacks_Sent), 9, next, 0);  !    PrInsrtDec (buffer, Unsigned(stats.bsc.Wacks_Rcvd), 42, 0);         buffer :=  #   '                TTDs Sent                         TTDs Received';  #     InsrtDec (buffer, Unsigned(stats.bsc.Ttds_Sent), 9, next, 0);      PrInsrtDec (buffer, Unsigned(stats.bsc.Ttds_Rcvd), 42, 0);          buffer :=  %   '                Response Errors                   3 Second Timeouts';  % #   InsrtDec (buffer, Unsigned(stats.bsc.Response_Errors), 9, next, 0); # !   PrInsrtDec (buffer, Unsigned(stats.bsc.Short_Timeouts), 42, 0); !        buffer :=  &   '                Line Errors                       Automatic Reconnects'; & !   InsrtDec (buffer, Unsigned(stats.bsc.Line_Errors), 9, next, 0); ! $   PrInsrtDec (buffer, Unsigned(stats.bsc.Automatic_Reconnects), 42, 0); $        buffer :=  "   '                Blocksize (bytes)                 Retry Limit';  " #   InsrtDec (buffer, Unsigned(stats.bsc.Data_Block_Size), 9, next, 0); #    temp := stats.bsc.Retry_Limit;      PrInsrtDec (buffer, Unsigned(temp), 42, 0);         buffer :=  %   '                Connect Timer                     Trace Size (bytes)'; %    temp := stats.bsc.Connect_Timer;      InsrtDec (buffer, Unsigned(temp), 9, next, 0);       PrInsrtDec (buffer, Unsigned(stats.bsc.Trace_Length), 42, 0);       
   Printline (buffer,'');  
        IF stats.bsc.secondary THEN        BEGIN            PrintLine (buffer, '   Card Connected as Secondary');        END      ELSE         BEGIN            PRINTLINE (BUFFER, '   Card Connected as Primary');        END;      
   END;  { ShowBSCStats }  
     
$SUBTITLE 'ShowDvt'$ 
 ${---------------------------------------------------------------------}  $ ${  PROCEDURE ShowDvt                                                  }  $ ${---------------------------------------------------------------------}  $ PROCEDURE ShowDvt (VAR lu  : Int16;                      VAR dvt : DVTtype);      
   BEGIN { ShowDVT } 
     
   PrintLine (buffer, ''); 
    buffer := '   DVT Words For LU ';     PrInsrtDec (buffer, lu, 21, JUSTIFY);  
   PrintLine (buffer, ''); 
    PrintLine (buffer,   %            '   Word  Value  Meaning              Word  Value  Meaning');  %        buffer :=  %   '     1          DVT Link Word          2          Q/Rqst Init List ';  %    InsrtOct (buffer, dvt.dvt1, 9, next);     PrInsrtOct (buffer, dvt.dvt2, 42);          buffer :=  &   '     3          N/Circular Node List   4          P/Circular DVT List';  &    InsrtOct (buffer, dvt.dvt3, 9, next);     PrInsrtOct (buffer, dvt.dvt4, 42);          buffer :=  %   '     5          X/IFT Reference        6          Device Type      ';  %    InsrtOct (buffer, dvt.dvt5, 9, next);  
   temp := dvt.devicetype; 
    PrInsrtOct (buffer, temp, 42);          buffer :=  %   '     7          Sys Flgs/LU Lck/A/Rs   8          B/Buffer Accum.  ';  %    InsrtOct (buffer, dvt.dvt7, 9, next);     PrInsrtOct (buffer, dvt.dvt8, 42);          buffer :=  %   '     9          S/ Hi-Lo/16 / Lo/16   10          Reserved         ';  %    InsrtOct (buffer, dvt.dvt9, 9, next);     PrInsrtOct (buffer, dvt.dvt10, 42);         buffer :=  %   '    11          T.O. List             12          Device T.O. Value';  %    InsrtOct (buffer, dvt.dvt11, 9, next);      PrInsrtOct (buffer, dvt.dvt12, 42);         buffer :=  %   '    13          I/F T.O. Value        14          Device Dvr Address'; %    InsrtOct (buffer, dvt.dvt13, 9, next);      PrInsrtOct (buffer, dvt.dvt14, 42);         buffer :=  %   '    15          Ty/Ue/Z/Subfn/Rq      16          Rq/Parm Error Code'; %    InsrtOct (buffer, dvt.dvt15, 9, next);      PrInsrtOct (buffer, dvt.dvt16, 42);         buffer :=  &   '    17          Rqst Parm2/Xlog       18          Rqst Parm3/Ext Stat1'; &    InsrtOct (buffer, dvt.dvt17, 9, next);      PrInsrtOct (buffer, dvt.dvt18, 42);         buffer :=     '    19          Rqst Parm4/Ext Stat2 ';      PrInsrtOct (buffer, dvt.dvt19, 9);          END;       
$SUBTITLE 'ShowIft'$ 
 ${---------------------------------------------------------------------}  $ ${  PROCEDURE ShowIft                                                  }  $ ${---------------------------------------------------------------------}  $ PROCEDURE ShowIFT (VAR lu  : Int16;                      VAR ift : IftType);  {}  ${ This procedure formats and displays the words in "IFT". It is assumed  $ "{ that the array containd words 1-?? of an IFT associated with DD.66 " {}         BEGIN { showing the IFT }      
   PrintLine (buffer, ''); 
    buffer := '  IFT Extension Words For LU ';      PrInsrtDec (buffer, lu, 39, JUSTIFY);  
   PrintLine (buffer, ''); 
    PrintLine (buffer,   %            '   Word  Value  Meaning              Word  Value  Meaning');  %        buffer :=  &   '     1          Retry Cntr/Read Ptr   2           1st Read Len Skp Ct';  &    InsrtOct (buffer, ift.iftx1, 9, next);      PrInsrtOct (buffer, ift.iftx2, 42);         buffer :=  &   '     3          2nd Read len/Read Ct  4           Frame length On Card'; &    InsrtOct (buffer, ift.iftx3, 9, next);      PrInsrtOct (buffer, ift.iftx4, 42);         buffer :=  &   '     5          Write Pointer         6           Write Buffers Length'; &    InsrtOct (buffer, ift.iftx5, 9, next);      PrInsrtOct (buffer, ift.iftx6, 42);         buffer :=  %   '     7          Max PSI Frame Size    8           Num Output Buffers'; %    InsrtOct (buffer, ift.iftx7, 9, next);      PrInsrtOct (buffer, ift.iftx8, 42);         buffer :=  %   '     9          Read Cont Address    10           Write Cont Address'; %    InsrtOct (buffer, ift.iftx9, 9, next);      PrInsrtOct (buffer, ift.iftx10, 42);          buffer :=  %   '    11          Flag Bits            12           Miscellaneous Bits'; %    InsrtOct (buffer, ift.iftx11.int, 9, next);     PrInsrtOct (buffer, ift.iftx12, 42);          ShowFlags (lu, dvt, ift, iftlen);      
   END;  { ShowIFT } 
     
$SUBTITLE 'ShowHDLCStats'$ 
 %{-----------------------------------------------------------------------}  % %{  PROCEDURE ShowHDLCStats                                              }  % %{-----------------------------------------------------------------------}  % PROCEDURE ShowHDLCStats (    lu        : Int16;                                stats : StatType);       
   BEGIN { ShowHDLCStats } 
            buffer :=        'HDLC Board, Firmware Revision:xxxx, Speed:xxxxxxxx ,';      InsrtDec (buffer, stats.hdlc.rev_code, 31, next, JUSTIFY);      CASE stats.hdlc.speed OF         0: StuffChar (buffer, '  300 BPS', 43, 9);        1: StuffChar (buffer, ' 1200 BPS', 43, 9);        2: StuffChar (buffer, ' 2400 BPS', 43, 9);        3: StuffChar (buffer, ' 4800 BPS', 43, 9);        4: StuffChar (buffer, ' 9600 BPS', 43, 9);        5: StuffChar (buffer, '19.2K BPS', 43, 9);        6: StuffChar (buffer, '57.6K BPS', 43, 9);        7: StuffChar (buffer, '230 K BPS', 43, 9);     END; { case }         CASE stats.hdlc.frame128 OF         TRUE  : StuffChar (buffer, '128 byte frame size', 54, 20);   !      FALSE : StuffChar (buffer, '1024 byte frame size', 54, 21);  !    END; { case }         Printline (buffer, buffer);         CASE stats.hdlc.fcl_enabled OF         TRUE  : buffer :=                 'FCL enabled,';         FALSE : buffer :=                 'FCL disabled,';     END; { case }         CASE stats.hdlc.hood_sensed OF   "      TRUE  : StuffChar (buffer, ' Diagnostic Hood sensed', 15, 24); " $      FALSE : StuffChar (buffer, ' Diagnostic Hood not sensed', 15, 28); $    END; { case }         PrintLine ( buffer, buffer);       
   PrintLine (buffer, ''); 
        buffer :=  %   '                Good I-Frames Recvd               RR Frames Received'; % $   InsrtDec (buffer, Unsigned(stats.hdlc.good_frames_rcvd), 9, next, 0); $ "   PrInsrtDec (buffer, Unsigned(stats.hdlc.rr_frames_rcvd), 42, 0);  "        buffer :=  %   '                RNR Frames Received               reject Frames Rcvd'; % $   InsrtDec (buffer, Unsigned(stats.hdlc.rnr_frames_rcvd), 9, next, 0);  $ $   PrInsrtDec (buffer, Unsigned(stats.hdlc.reject_frames_rcvd), 42, 0);  $        buffer :=  %   '                RCV Proc Overruns                 CRC Errors        '; %     InsrtDec (buffer, Unsigned(stats.hdlc.overruns), 9, next, 0);       PrInsrtDec (buffer, Unsigned(stats.hdlc.crc_errors), 42, 0);           buffer :=  %   '                Abort Seq. Received               Receiver Overruns';  % $   InsrtDec (buffer, Unsigned(stats.hdlc.aborts_received), 9, next, 0);  $ #   PrInsrtDec (buffer, Unsigned(stats.hdlc.receiver_overruns), 42, 0); #        buffer :=  %   '                Rx Buffer Overflows               Frames W/Bad Addr';  % &   InsrtDec (buffer, Unsigned(stats.hdlc.rx_buffer_overflows), 9, next, 0);  &     PrInsrtDec (buffer, Unsigned(stats.hdlc.bad_address), 42, 0);          buffer :=  &   '                Cmdr Frames Rcvd                  Unack Fr Window Size'; & "   InsrtDec (buffer, Unsigned(stats.hdlc.cmdr_frames), 9, next, 0);  "    temp := stats.hdlc.k;     PrInsrtDec (buffer, Unsigned(temp), 42, 0);         buffer :=  &   '                N2 Retry Count                    T1 T.O. In 0.01 Sec';  &    temp := stats.hdlc.n2_retries;      InsrtDec (buffer, Unsigned(temp), 9, next, 0);      PrInsrtDec (buffer, Unsigned(-stats.hdlc.timeout), 42, 0);       
   END;  { ShowHDLCStats } 
     
$SUBTITLE 'ShowLanStats'$  
  {--------------------------------------------------------------}    {   DISPLAY STATISTICS AND STATUS FROM THE LAN CARD            }    {--------------------------------------------------------------}       PROCEDURE ShowLanStats     (VAR lu  : Int16);       CONST      CONTROL_CODE = 3;     { EXEC code for control       }     GET_STATUS = 38;      { control subfunction to get status }     NO_RESET = 0;         { don't reset LAN statistics  }     RETURN_STATS = 13;    { EXEC subfunctiuon for stats }     READ_CODE = 1;        { EXEC code for read request  }     STATLEN = 27;         { length of LASN statistics   }      TYPE     errortype = PACKED RECORD  
        upperbyte : Byte;  
         err_code  : PosInt4;   {error code from driver}           ds_bit    : Boolean;   {ds request if true.   }           wr_bit    : Boolean;   {write request if true }           er_bit    : Boolean;   {error if true         }           sys_bit   : Boolean;   {reserved for system   }           END;          aregtype = RECORD CASE BOOLEAN OF           TRUE  : (int : Int16);          FALSE : (err : errortype);          END;      VAR   
   areg       : AregType;  
    breg       : Int16;     control    : ControlType;     error      : BOOLEAN;     error_code : Int16;  
   parms      : RmparType; 
 
   stats      : StatType;  
    status     : LanStatusType;      BEGIN { ShowLanStats }      
   PrintLine (buffer, ''); 
     
   control.ov := 0;  
    { For LAN LUs the request must always be to the write LU. }     { This is always the first LU and is always even.         }     IF ODD(lu) THEN { user specified the read LU }   
      control.lu := LU - 1 
    ELSE         control.lu := lu;          control.subfunction := RETURN_STATS;          error := FALSE; { set up for no error }  
   error_code := 0;  
     '   GetLanStats (READ_CODE + BIT15 + BIT14, control, stats, STATLEN, NO_RESET); '       BEGIN { error processing }        ABReg (areg.int, breg);   
      error := TRUE; 
       error_code := areg.int;         END;  { error processing }      
   ABREG (areg.int, breg); 
     %   IF (NOT error) AND ((areg.err.sys_bit OR (areg.err.err_code<>0))) THEN  %       BEGIN { handling error }  !      { If we enter here, we made a normal return from the XLUEX } ! !      { call but the system reports an error.  This may occur if } ! !      { the LU goes down while we are making the call.           } ! 
      error := TRUE; 
       error_code := areg.int;         END;  { handling error }         IF (NOT error) THEN        BEGIN { get the card status }         control.subfunction := GET_STATUS;        GetLanStatus (CONTROL_CODE + BIT14 + BIT15, control);            BEGIN { error return }            ABREG (areg.int, breg);           error := TRUE;            error_code := areg.int;           END;  { error return }             ABREG (areg.int, breg);       &      IF (NOT error) AND ((areg.err.sys_bit OR (areg.err.err_code<>0))) THEN &          BEGIN { handling error }            error := True;            error_code := areg.int;           END;  { handling error }       
      Rmpar (parms); 
           END;  { get the card status }          IF (NOT error) THEN { we got statistics and status }         BEGIN { reporting stats }             buffer :=            'LAN Card, Firmware Revision:xxxx ';         PrInsrtDec (buffer, stats.lan.rev_code, 29, JUSTIFY);             PrintLine ( buffer, buffer);            PrintLine ( buffer, '');            buffer :=   %      '                Good Bytes Sent                   Good Bytes Rcvd'; %        InsrtDec (buffer, stats.lan.good_bytes_sent, 4, next, 1);           InsrtDec (buffer, stats.lan.good_bytes_rcvd, 37, next, 1);         PrInfo (buffer);            buffer :=   &      '                Good Packets Sent                 Good Packets Rcvd'; & !      InsrtDec (buffer, stats.lan.good_packets_sent, 4, next, 1);  ! !      InsrtDec (buffer, stats.lan.good_packets_rcvd, 37, next, 1); !       PrInfo (buffer);            buffer :=   '      '                Errors on Xmit                    Errors on Recv    ';  ' $      InsrtDec (buffer, Unsigned(stats.lan.errors_on_xmit), 9, next, 0); $ #      PrInsrtDec (buffer, Unsigned(stats.lan.errors_on_recv), 42, 0);  #           buffer :=   &      '                Babble Errors                     Heart Beat Errors'; & $      InsrtDec (buffer, Unsigned(stats.lan.babble_errors), 9, next, 0);  $ $      PrInsrtDec (buffer, Unsigned(stats.lan.heart_beat_errors), 42, 0); $           buffer :=   $      '                Missed Packets                    Memory Errors'; $ $      InsrtDec (buffer, Unsigned(stats.lan.missed_packets), 9, next, 0); $ "      PrInsrtDec (buffer, Unsigned(stats.lan.memory_errors), 42, 0); "           buffer :=   &      '                Framing Errors                    Discarded Packets'; & $      InsrtDec (buffer, Unsigned(stats.lan.framing_errors), 9, next, 0); $ $      PrInsrtDec (buffer, Unsigned(stats.lan.discarded_packets), 42, 0); $           buffer :=   $      '                CRC Errors                        Length Errors'; $ "      InsrtDec (buffer, Unsigned(stats.lan.crc_errors), 9, next, 0); " "      PrInsrtDec (buffer, Unsigned(stats.lan.length_errors), 42, 0); "           buffer :=   #      '                Multiple Retries                  Retries = 1'; # %      InsrtDec (buffer, Unsigned(stats.lan.multiple_retries), 9, next, 0); % !      PrInsrtDec (buffer, Unsigned(stats.lan.no_retries), 42, 0);  !           buffer :=   #      '                Transmit Deferral                 Underflows';  # $      InsrtDec (buffer, Unsigned(stats.lan.xmit_deferral), 9, next, 0);  $ !      PrInsrtDec (buffer, Unsigned(stats.lan.underflows), 42, 0);  !           buffer :=   %      '                Late Collisions                   Loss of Carrier'; % %      InsrtDec (buffer, Unsigned(stats.lan.late_collisions), 9, next, 0);  % #      PrInsrtDec (buffer, Unsigned(stats.lan.loss_of_carrier), 42, 0); #           buffer :=   %      '                Retry Exceeded                    TDR Information'; % $      InsrtDec (buffer, Unsigned(stats.lan.retry_exceeded), 9, next, 0); $        PrInsrtDec (buffer, Unsigned(stats.lan.tdr_info), 42, 0);              PrintLine (buffer,' ');             WITH parms[3] DO { i.e. status from DVT 18 }           BEGIN { with }       	         buffer := 	 &   '  x Last Write Failed   x Link Write Pending   x Interrupt Pending   ';  &              IF last_wt_failed = 0 THEN               buffer [3] :=  '1'           ELSE               buffer [3] :=  '0';                buffer [25] := chr (ASCII + link_wt_pending);           buffer [48] := chr (ASCII + ui_pending);                PrintLine (buffer, buffer);      	         buffer := 	 &   '  x Wait For TX Buffer  x RCV Packet Available x No Receive Buffers  ';  &              buffer [3] :=  chr (ASCII + wait_for_tx_buf);           buffer [25] := chr (ASCII + rcv_pac_avail);           buffer [48] := chr (ASCII + no_rx_buffers);               PrintLine (buffer, buffer);      	         buffer := 	 &   '  x MAU Power Failed    x Lost NOVRAM data     x NOVRAM Bank 2 Enable';  &              buffer [3] :=  chr (ASCII + mau_power_fail);            buffer [25] := chr (ASCII + lost_novr_data);            buffer [48] := chr (ASCII + novram2_en);                PrintLine (buffer, buffer);      	         buffer := 	 &   '  x Multicast Mode      x Broadcast Mode       x Promiscuous Mode    ';  &              buffer [3] :=  chr (ASCII + multicast_en);            buffer [25] := chr (ASCII + broadcast_en);            buffer [48] := chr (ASCII + promis_en);               PrintLine (buffer, buffer);           END;  { with }             END   { reporting stats }      ELSE         BEGIN { couldn't read status/statistics }   !      buffer := 'Unable to read from card, status on EXEC call ='; !       PrInsrtOct (buffer, error_code, 49);        END;  { couldn't read status/statistics }   END;  { ShowLanStats }      $SUBTITLE 'ShowLuType'$    {--------------------------------------------------------------}    {   DISPLAY LU NUMBER TYPE AND STATUS                          }    {--------------------------------------------------------------}       
PROCEDURE ShowLuType 
 
   (VAR lu  : Int16; 
     VAR dvt : DvtType;      VAR ift : IftType;      VAR iftlen : Int16;       VAR print_header : BOOLEAN);      BEGIN  { ShowLuType }          IF print_header THEN         BEGIN { printing headers }        PrintLine (buffer, '');         PrintLine (buffer,        'lu    device type     select code     availability');        print_header := FALSE;        PrintLine (buffer, '');         END;  { printing headers }     buffer := '';     InsrtDec (buffer, lu, 1, next, JUSTIFY);   
   temp := dvt.devicetype; 
    InsrtOct (buffer, temp, 7, next);  
   temp := ift.selectcode; 
    InsrtOct (buffer, temp, 23, next);      CASE dvt.availability OF         0 : PrChrBuf (buffer, 'up', 41, 2);         1 : PrChrBuf (buffer, 'down', 41, 4);         2 : PrChrBuf (buffer, 'busy', 41, 4);         3 : PrChrBuf (buffer, 'down and busy', 41, 13);      END; { case }      END;   { ShowLuType }       $SUBTITLE 'ShowThisLu'$    {--------------------------------------------------------------}    {   DISPLAY ALL INFORMATION ON THE SPECIFIED LU                }    {--------------------------------------------------------------}       
PROCEDURE ShowThisLu 
 
   (VAR lu  : Int16; 
     VAR dvt : DvtType;      VAR ift : IftType;      VAR iftlen : Int16);      VAR   
   print_header : BOOLEAN; 
     BEGIN  { ShowThisLu }          PrintLine (buffer,   &   '********************************************************************');  &    print_header := TRUE;     ShowLuType (lu, dvt, ift, iftlen, print_header);      ShowCard (lu, dvt, ift, iftlen);   
   PrintLIne (buffer, ''); 
     END;   { ShowThisLu }           $SUBTITLE 'ShowType66Stats'$   {--------------------------------------------------------------}    {   DISPLAY BSC OR HDLC STATISTICS FOR THE SPECIFIED LU        }    {--------------------------------------------------------------}       
PROCEDURE ShowType66Stats  
    (VAR lu  : Int16);       VAR   
   errornum : Int16; 
 
   stats : StatType; 
     
BEGIN  { ShowType66Stats } 
              PrintLine (buffer, '');           GetBoardStats (lu, stats, errornum);                IF errornum = 0 THEN               BEGIN { display stats }               IF stats.bsc.board_type = HDLC THEN                  ShowHDLCStats (lu, stats)              ELSE                 IF stats.bsc.board_type = BSC THEN                     ShowBSCStats (lu, stats);               END   { display stats }            ELSE { errornum <> 0 }               BEGIN { report error }  &               buffer := 'Unable to read statistics, status on EXEC call ='; &                PrInsrtOct (buffer, errornum, 49);               END;  { report error }      
END;   { ShowType66Stats } 
     $SUBTITLE 'ShowCard'$    {--------------------------------------------------------------}    {   DISPLAY ALL INFORMATION ON THE SPECIFIED LU                }    {--------------------------------------------------------------}       	PROCEDURE ShowCard 	 
   (VAR lu  : Int16; 
     VAR dvt : DvtType;      VAR ift : IftType;      VAR iftlen : Int16);      
BEGIN  { ShowCard }  
     "   IF (dvt.devicetype = Type66) AND (ift.extentsize IN [18,20]) THEN " 
      BEGIN { DVA66 card } 
          ShowType66Stats (lu);           ShowFlags (lu, dvt, ift, iftlen);  
      END   { DVA66 card } 
    ELSE         IF dvt.devicetype = TYPE67 THEN            BEGIN { LAN card }               ShowLanStats (lu);           END   { LAN card }         ELSE           BEGIN { not DVA66 or LAN }            END;  { not DVA66 or LAN }       
END;   { ShowCard }  
     $SUBTITLE 'ShowFlags'$   {--------------------------------------------------------------}    {   DISPLAY FLAG BITS FOR THE SPECIFIED LU                     }    {--------------------------------------------------------------}       
PROCEDURE ShowFlags  
 
   (VAR lu  : Int16; 
     VAR dvt : DvtType;      VAR ift : IftType;      VAR iftlen : Int16);          VAR temp : packed array [1..2] of char;       
BEGIN  { ShowFlags } 
       PrintLine (buffer, '');          PrintLine (buffer, 'Flag bits from IFT extent (word 11)');         PrintLine (buffer, '');       
   WITH ift.iftx11.dvr DO  
 
      BEGIN { with } 
           buffer :=   %'  X Read Aborted    X Write Aborted   X Rd Rq Pending   X Wt Rq Pending'; %           buffer [3] :=  chr (ASCII + read_aborted);        buffer [21] := chr (ASCII + write_aborted);         buffer [39] := chr (ASCII + read_pending);        buffer [57] := chr (ASCII + write_pending);             PrintLine (buffer, buffer);             buffer :=   &'  X Bkpl Locked RP  X Bkpl Locked WP  X Short TO active X Med. TO Active';  &           buffer [3]  := chr (ASCII + read_locked);         buffer [21] := chr (ASCII + write_locked);        buffer [39] := chr (ASCII + short_timeout);         buffer [57] := chr (ASCII + med_timeout);             PrintLine (buffer, buffer);             buffer :=   $'  X Long TO Active  X Connected       X Start of Msg.   X Non-DS Mode'; $           buffer [3]  := chr (ASCII + long_timeout);        buffer [21] := chr (ASCII + connected);         buffer [39] := chr (ASCII + start_message);         buffer [57] := chr (ASCII + non_ds);            PrintLine (buffer, buffer);             buffer :=   %'  X Connect Req.    X Severe Error    X P-F Reconnect   X RFP Wait     '; %           buffer [3]  := chr (ASCII + initialized);         buffer [21] := chr (ASCII + sever_error);         buffer [39] := chr (ASCII + reconnect);         buffer [57] := chr (ASCII + vcp_wait);            PrintLine (buffer, buffer);       
      END;  { with } 
     
END;   { ShowFlags } 
     $SUBTITLE 'StuffChar'$   {--------------------------------------------------------------}    {   Insert Characters into buffer                              }    {--------------------------------------------------------------}       
PROCEDURE StuffChar  
    (VAR buffer : Charray78;    { Write into this buffer      }          buffer1: Charray78;    {   ...and these characters   }          pos    : Int16;        {       (pos of chars)        }          len    : Int16);       {       (length for chars)    }      VAR      next : Int16;      
BEGIN  { StuffChar } 
        Insrtchr (buffer, buffer1, len, pos, next);      
END;   { StuffChar } 
     $SUBTITLE 'PrChrBuf'$    {--------------------------------------------------------------}    {   PRINT CHARACTER/BUFFER                                     }    {--------------------------------------------------------------}       PROCEDURE PrChrBuf       { Output the buffer as follows:  }      (VAR outbuf : Charray78;    { Write into this buffer      }          buffer1: Charray78;    {   ...and these characters   }          pos    : Int16;        {       (pos of chars)        }          len    : Int16);       {       (length for chars)    }      
BEGIN  { PrChrBuf }  
        PrInsrtchr (outbuf, buffer1, len, pos);      
END;   { PrChrBuf }  
         $SUBTITLE 'PrDecBuf'$    {--------------------------------------------------------------}    {   PRINT DECIMAL/BUFFER                                       }    {--------------------------------------------------------------}       	PROCEDURE PrDecBuf 	    (VAR outbuf : Charray78;    { Write into this buffer      }          buffer : Charray78;    {   ...these characters       }          decnum : Int16;        {   ...and this number        }          pos    : Int16;        {       (pos for number)      }          justify: Int16);       {       (-1 to left justify)  }          
BEGIN  { PrDecBuf }  
     
   outbuf := buffer; 
    PrInsrtDec (outbuf, decnum, pos, justify);       
END;   { PrDecBuf }  
     $ SUBTITLE 'PrintLine' $  ${----------------------------------------------------------------------} $ ${   PRINT LINE                                                         } $ ${----------------------------------------------------------------------} $     
PROCEDURE PrintLine  
    (VAR outbuf : Charray78;           buffer : Charray78);      
BEGIN  { PrintLine } 
        PrInsrtchr (outbuf, buffer, 78, 1);      
END;   { PrintLine } 
         $SUBTITLE 'UserInput'$   {--------------------------------------------------------------}    {   UserInput                                                 }     {--------------------------------------------------------------}       
PROCEDURE UserInput  
    (VAR startlu : Int16;  
    VAR stoplu  : Int16);  
     VAR      luselected : BOOLEAN;      BEGIN { Procedure UserInput }          buffer := 'NSINF: Enter LU (cr for all LUs) >';     luselected := PromptUser (buffer, startlu);     IF luselected THEN   
      BEGIN { luselected } 
       stoplu := startlu;        END   { lu selected }      ELSE         BEGIN { user hit cr }         startlu := MINLU;         stoplu := MAXLU;        END;  { user hit cr }       END;  { Procedure UserInput }           	$SUBTITLE 'IOINF'$ 	  {--------------------------------------------------------------}    {   IOINF                                                      }    {--------------------------------------------------------------}       PROCEDURE IOINF      (VAR info: InfoRecordType);          VAR      done      : BOOLEAN;      error     : Int16;      linecount : Int16;       
BEGIN { Procedure IOINF }  
     
   PrintLine (buffer, ''); 
    PrintLine (buffer, 'NS/1000 LU Summary:');   
   PrintLine (buffer, ''); 
    PrintLine (buffer,      'lu    device type     select code     availability');   
   PrintLine (buffer, ''); 
    { Set up for loop }  	   done := FALSE;  	 	   linecount := 3; 	    lu := MINLU;      WHILE (NOT done) AND (NOT break) DO        BEGIN { while }   
      iftlen := MAXIFTLEN; 
       Getlu (lu, dvt, ift, iftlen, error);  
      CASE error OF  
          NOERROR : BEGIN { no error case }                 IF dvt.devicetype IN [TYPE66, TYPE67] THEN                     BEGIN { display info on this LU }                        buffer := '';                       InsrtDec (buffer, lu, 1, next, JUSTIFY);                        temp := dvt.devicetype;                       InsrtOct (buffer, temp, 7, next);                       temp := ift.selectcode;                       InsrtOct (buffer, temp, 23, next);                        CASE dvt.availability OF                           0 : PrChrBuf (buffer, 'up', 41, 2);                           1 : PrChrBuf (buffer, 'down', 41, 4);                           2 : PrChrBuf (buffer, 'busy', 41, 4);   $                        3 : PrChrBuf (buffer, 'down and busy', 41, 13);  $                      END; { case }                       linecount := linecount + 1;                       LU := LU + 1; { skip next LU }                     END; { diplay info on this LU }                END; { no error case }                NOSUCHLU : ;            NOMORELUS : done := TRUE;           END;  { case }            lu := lu + 1; { move to next LU }        IF (linecount > maxlines) AND (NOT done) THEN            BEGIN { check for "more" }               done := (NOT more);               linecount := 0;            END;  { check for "more" }      END; { WHILE loop }  
END;  { Procedure IOINF }  
         	$SUBTITLE 'LUINF'$ 	  {--------------------------------------------------------------}    {   LUINF                                                      }    {--------------------------------------------------------------}       PROCEDURE LUINF      (VAR info: InfoRecordType);      {}  {   {}      VAR   
   done        : BOOLEAN;  
 
   moreenabled : BOOLEAN;  
    errornum    : Int16;       BEGIN { LUINF }       
   UserInput (lu, stoplu); 
 	   done := FALSE;  	    moreenabled := FALSE;      
   WHILE NOT done DO 
       BEGIN { processing lu(s) }      
      iftlen := MAXIFTLEN; 
       GetLu (lu, dvt, ift, iftlen, errornum);       %      IF (errornum = NOERROR) AND (dvt.devicetype IN [TYPE66,TYPE67]) THEN %          BEGIN { processing one DS lu }            IF (moreenabled) AND (NOT more) THEN               BEGIN { stop processing }   
            done := TRUE;  
             END   { stop processing }            ELSE               BEGIN { process this LU }               ShowThisLu (lu, dvt, ift, iftlen);  
            lu := lu + 2;  
             moreenabled := TRUE;              END;  { process this LU }            END   { processing one lu }  "      ELSE { there was an error on this LU or it wasn't an "NS" LU } "          BEGIN { handling non-NS LU }            lu := lu + 1;           IF errornum = NOMORELUS THEN   
            done := TRUE;  
          END;  { handling error on getlu call }             IF (lu > stoplu) OR (break) THEN           BEGIN { set done flag }  
            done := TRUE;  
          END;  { set done flag }            END;  { processing lu(s) }      END;  { LUINF }       END. { MODULE }  