 $PASCAL '91790-1X142 REV.4010 <851125.2009>'  
$STANDARD_LEVEL 'HP1000'$  
 $RECURSIVE off, RANGE off, HEAP 0 $   $DEBUG$   $CODE_CONSTANTS OFF,HEAP_DISPOSE OFF$   $TITLE 'NR_ACCESS',page$  MODULE nrlock;      {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{      NAME: nr_access.pas 
 {    SOURCE: 91790-18142  	{     RELOC: NONE  	 {      PGMR: LAW  {     OWNER: CLC  {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  PCO  Prgmr  Description  "{ 071985      LAW    Changed to use new DS_NRLockRN, DS_FetchGlobal& " {                    DS_StoreGlobal   {   {   {------------------------------------------------------------   {}  $page$  { Module  Description:  !{ This module is shared by NRLIST and NRINIT to lock access to the !  { Nodal Registry tables.  This lockout mechanism is used only by   !{ these two.  Race conditions and critical sections are avoided by ! { "dispatch-lock" calls prior to modifying the tables.  {   {}  %{------------------------------------------------------------------------} % %{                          Imported Modules                              } % %{------------------------------------------------------------------------} %     IMPORT                $SEARCH 'phtm/BODEC.REL'     bodec,                 $SEARCH 'phtm/SODEC.REL'     sodec,                 $SEARCH 'phtm/MMDEC.REL'     mmdec,                 $SEARCH 'phtm/MMEXT.REL'     ds_mm,                 $SEARCH 'phtm/TRCMOD.REL'      trcmod,                $SEARCH 'phtm/SIGMOD.REL'      sigmod;      ${----------------------------------------------------------------------} $ ${                         Exported Modules                             } $ ${----------------------------------------------------------------------} $     EXPORT  	PROCEDURE NR_Lock  	          (VAR text_f : TEXT;            VAR ierr: Int16);       
PROCEDURE NR_Unlock  
          (VAR text_f: TEXT;             VAR ierr: Int16);           $subtitle 'Global Constants',page$      %{------------------------------------------------------------------------} % %{                               Module Implementation                    } % %{------------------------------------------------------------------------} %     IMPLEMENT   CONST      { Define bits for RNRQ calls}  
   NO_WAIT        = bit15; 
 
   no_abort       = bit14; 
 
   Deallocate_RN  = bit5;  
 
   Allocate_global= bit4;  
 
   Allocate_local = bit3;  
 
   Unlock         = bit2;  
 
   Lock_globally  = bit1;  
 
   Lock_locally   = bit0;  
     $subtitle 'Types',page$       &{-------------------------------------------------------------------------}  & &{                                Types                                    }  & &{-------------------------------------------------------------------------}  &     TYPE  ByteOrWordType = RECORD      CASE Int16 OF     1: (bite: PACKED ARRAY[1..2] OF Byte);      2: (cchar:PACKED ARRAY[1..2] OF char);   
   3: (word: Int16); 
    END; {ByteOrWordType}      $subtitle 'Global Variables',page$      %{------------------------------------------------------------------------} % %{                               Variables                                } % %{------------------------------------------------------------------------} %     VAR   
   wkmap          : Int16; 
    wait_msg_flag : Boolean;   
   err2          : Int16;  
    NR_Resource_control : Int16;      RN_Stat             : Int16;      areg, breg          : byteorwordtype;      $subtitle 'Aliases for EXEC',page$      &{-------------------------------------------------------------------------}  & &{                               Alias for Exec                            }  & &{-------------------------------------------------------------------------}  &     PROCEDURE RN_LOCK $ALIAS 'RNRQ',noabort$           (icode: Int16;             irn:   Int16;             VAR istat: Int16);  EXTERNAL;   #{ abreg returns the A&B register contents, which are meaningful after  # { EXEC calls.}      PROCEDURE abreg(VAR ar:Int16; VAR br:Int16); EXTERNAL;      $subtitle 'RN_Error_Recover',page$      %{------------------------------------------------------------------------} % %{                               RN_Error_Recover                         } % %{------------------------------------------------------------------------} %     
PROCEDURE RN_Error_Recover 
          (VAR ierr: Int16);   VAR      err_x: PACKED ARRAY[1..4] OF char;   BEGIN   $   { Place the four characters of EXEC error (e.g., IO00) into message.} $    err_x[1] := CHR(areg.bite[1]);      err_x[2] := CHR(areg.bite[2]);      err_x[3] := CHR(breg.bite[1]);      err_x[4] := CHR(breg.bite[2]);      writeln('RTE RNRQ Error:',err_x:4);     ierr := -4   END; {RN_Error_Recover}       
$subtitle 'NR_LOCK',page$  
 ${---------------------------------------------------------------------}  $ ${                               NR_Lock                               }  $ ${---------------------------------------------------------------------}  $ ${ This routine is called to secure exclusive access to Nodal Registry.}  $ ${---------------------------------------------------------------------}  $     	PROCEDURE NR_Lock; 	 LABEL 5,10,20,99,999;   BEGIN   "   { Go dispatch-locked, and find out if a resource number has been  " !   { allocated.  If it hasn't been, then allocate it.  If it has,  ! "   { find out if anybody is suspended on it.  If not, we can use it  " #   { and we'll deallocate it when we're through.  This last part is so # "   { we can recover from the case where a former user of the RN was  "    { aborted, before the RN could be cleared}       5:  
   wait_msg_flag := false; 
     10:      DS_EnterCritical(wkmap, err2);   
   IF err2 <> 0 THEN 
       BEGIN    {Terrible error! Exit now!}  	      ierr := -5;  	       goto 999        END;     DS_FetchGlobal(DS_NRLockRN, 1, NR_Resource_control);      IF NR_Resource_control = 0 THEN        BEGIN {allocate an RN}  20:   !      RN_LOCK(No_wait + No_abort + Allocate_local + lock_locally,  !             NR_Resource_control, RN_Stat);           BEGIN  #         {There has been an error reported at the RN lock system call. # #         {This must mean that the RN is no longer valid, which in turn #           {means that a process, which had the tables locked, was   #         {aborted before it could unlock & clear the table entry.  We  # #         {recover by clearing the entry, and going back to re-attempt  #          {to allocate an RN.}            NR_Resource_control := 0;           DS_StoreGlobal(DS_NRLockRN, 1, NR_Resource_control);            goto 20           END;       
      IF RN_Stat = 2 THEN  
          { Enter the newly-allocated RN into the table}            BEGIN           DS_StoreGlobal(DS_NRLockRN, 1, NR_Resource_control);            goto 99           END        ELSE IF RN_Stat = 4 THEN           {No RNs available now}            BEGIN  
         ierr := -2; 
          goto 99           END        ELSE           BEGIN  
         ierr := -3; 
          goto 99           END        END;         { The table has an RN in it.  Attempt to lock it locally. }     RN_LOCK(No_wait + No_abort + Lock_locally,               NR_Resource_control, RN_Stat);        BEGIN  { error handling }         NR_Resource_control := 0;         DS_StoreGlobal(DS_NRLockRN, 1, NR_Resource_control);        GOTO 20;        END;         IF RN_Stat = 6 THEN {it's locked to another program}         BEGIN         DS_LeaveCritical(wkmap);        IF NOT wait_msg_flag THEN            BEGIN           wait_msg_flag := true;   #         writeln(text_f,'Waiting-- another program has tables locked') #          END;       !      { We'll attempt to lock this RN.  When the program clears it ! #      { and de-allocates it, then RTE will object to us attempting to  # #      { lock an un-allocated RN, and will return to the error-recovery # $      { code.  That's fine with us, we'll just allocate another one, and $       { store that in the table. }  #      RN_LOCK(No_Abort + Lock_locally, NR_Resource_control, RN_Stat);  #          BEGIN           goto 5            END;         GOTO 5;         END;  99:      DS_LeaveCritical(wkmap);   999:  END; {NR_LOCK}      $subtitle 'NR_Unlock',page$   ${----------------------------------------------------------------------} $ ${                                NR_Unlock                             } $ ${----------------------------------------------------------------------} $     
PROCEDURE NR_Unlock; 
 LABEL 90,99,999;  BEGIN      DS_EnterCritical(wkmap, err2);   
   IF err2 <> 0 THEN 
       BEGIN   	      ierr := -5;  	       goto 999        END;     DS_FetchGlobal(DS_NRLockRN, 1, NR_Resource_control);      IF NR_Resource_Control <> 0 THEN         BEGIN         RN_LOCK(NO_Wait + NO_abort + Unlock,           NR_Resource_control, RN_Stat);            BEGIN   { error handling }            NR_Resource_control := 0;  	         goto 90;  	          END;   '      RN_LOCK(NO_Wait + NO_abort + Deallocate_RN,NR_Resource_control,RN_Stat); '          BEGIN           NR_Resource_control := 0;           END;   90:         NR_Resource_control := 0;         DS_StoreGlobal(DS_NRLockRN, 1, NR_Resource_control)         END;  99:         DS_LeaveCritical(wkmap);  999:  END; {NR_UNLOCK}      
END. {module NRLOCK} 
