 $PASCAL ',20,99 91790-16139 REV.4010 <860317.1435>'   
$STANDARD_LEVEL 'HP1000'$  
 $RECURSIVE off, RANGE off, HEAP 0 $   $DEBUG$   $CODE_CONSTANTS OFF,HEAP_DISPOSE OFF$   $title 'Nodal Registry Configuration'$      PROGRAM nrinit(input,output);       {------------------------------------------------------------        (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1985. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{      NAME: NRINIT  
 {    SOURCE: 91790-18139  {     RELOC: 91790-16139  {      PGMR: JM   {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  PCO  Prgmr  Description  {  8/24/84    JM     Original version   {  3/85       LAW    Modified for NS1000   {  7/85       LAW    Corrected end_offset (was short by 2 bytes)   !{  7/85       CLC    Added documentation, error codes, fixed bugs  ! ${  8/85       CLC    Fixed bug in concatenating entries, deleted display $ {                    of mbufs to user   #{  9/85       CLC    Interface changes, bug fix of 'Delete' option in  # {                    batch mode   { -------------------------   
{  After Release I:  
 ${  2/21/86    CLC    Fixed Misleading error msg for illegal name format  $ {                    SR# 033514   "{                    Disallow accepting env names > 3 fields #033522 "  {                    Fixed confusing compiler directives #033287   {                    (All in submittal N337)  {------------------------------------------------------------   {}  $PAGE$  { PROGRAM DESCRIPTION:      #    This program is part of the NS1000 initialization.  It is used to  # "    initialize the Nodal Registry.  Its origins may be found in the  " "    ES by Jeff Mangassarian, and the "Network Directory Maintenance  "     -- External Specifications" document.       #    The document mentioned above has the format of all the data types  # "    and addresses which this program uses. One must become familiar  "     with that document and the "Path Reports" document by   "    Craig Wassenberg and Bob Carlson. There is a complete reference  "      to this document, and others in the External Specifications.       #    This program reads ASCII Domain records, parses them, and converts # "    them to the internal Nodal Registry entry form, and enters this  "     information into that table.      &    Create_TF_report has been written in system-independent code.  However,  & '    one may have problems with the variant record in the procedure enterword.  ' "    This procedure relies upon the ability of HP1000/3000 PASCALs to " "    allow a packed variant record to contain either two 8-bit or one " "    16-bit quantity (a common programming technique for dealing with " #    items which may be either bytes or 16-bit words).  Except for this # #    "trick", this code is system-independent.  In other PASCAL imple-  #     mentations, it may be necessary to rewrite enterword.   $    Note if one does redefine these types one should make sure that the  $ "    constant Allbits has a value which sets all the bits of a 16 bit "     integer.      !    The Scanner has also been written in system independent code.  !                                                             }       
$subtitle 'Imports',page$  
 IMPORT                $SEARCH 'phtm/BODEC.REL'     bodec,                 $SEARCH 'phtm/SODEC.REL'     sodec,                 $SEARCH 'phtm/MMDEC.REL'     mmdec,                 $SEARCH 'phtm/MMEXT.REL'     ds_mm,                 $SEARCH 'phtm/TRCMOD.REL'      trcmod,                $SEARCH 'phtm/SIGMOD.REL'      sigmod,                $SEARCH 'phtm/LKLB.REL'      lk,                $SEARCH 'phtm/TMRDEC.REL'      tmrdec,                $SEARCH 'phtm/TCPGB.REL'     tg,                $SEARCH 'phtm/TUSER.REL'     tuser,          $SEARCH 'phtm/ipdec.rel,phtm/iplib.rel,phtm/ipdb.rel'     iplib,   $              $SEARCH 'phtm/IPPATH.REL,phtm/IPPCTL.REL,phtm/IPACTP.REL'  $    ippath,                $SEARCH 'phtm/TCPLB.REL'     tl,                $SEARCH 'phtm/PXPLB.REL'     px,                $SEARCH 'phtm/lan8.rel'      lan8,                $search 'phtm/sreglib.rel'     sreglib,                 $search 'phtm/nrerr.rel'     nrerr,               $SEARCH 'phtm/NR_ACCESS.REL'     nrlock;      LABEL   	  5, 10, 99, 999;  	     TYPE  !  rev_string_type = PACKED ARRAY[1..14] OF char; {revision string} !     $subtitle 'Constants declarations',page$      %{-----------------------------------------------------------------------}  % %{                               CONSTANTS                               }  % %{-----------------------------------------------------------------------}  %     CONST         PROMPT_STRING = 'NRINIT> '; {prompt for interactive input}  !  { max_TF_leng is defined as the maximum length of a path report, ! 
  { including name.} 
   max_TF_leng   = NDREC_BSIZE + MAX_PATHREP_BYTES - 1;  "  Allbits       = -1;       {used to set all the 16 servicemap bits} "   slimit        = 80;       {max length of alpha string}          %{ Define a <revcode> string constant which is automatically changed by the % #{ editor, whenever this module is changed.  The string must be in the  # ${ form shown below;  if any characters follow the trailing string quote, $ %{ the editor will not recognize it as a date code, and so will not update  % #{ it.  The purpose here is to have an automatic means for maintaining  # ${ the revision date, and identifying it for each run, without requiring  $ { anything of the programmer who makes any changes.}   { NB: DO NOT place any characters after the closing single-quote   { in the following line.  See comments above.}    this_rev_date = rev_string_type['<860317.1435>'   
                       ];  
     "{ Define the constant string which gives the major and minor version " { numbers.}   
  Version_string = '1.0';  
     $subtitle 'Type declarations',page$       %{-----------------------------------------------------------------------}  % %{                          Type Declarations                            }  % %{-----------------------------------------------------------------------}  %     TYPE  
{TF Node Descriptor} 
       alpha = packed array[0..slimit] of char;  #      {alpha type when used in conjunction with the procedures concat, # "       delete,insert,init,print,length, will store the length of the "        data in array locaion 0.}                    {TF node descriptor }   
      node_desc_t =  
          packed record            length : int16;   {length of record in bytes}             name_offset  : int16;   {offset to name}            path_offset  : int16;             end_offset   : int16;              var_part     : packed array [1..max_TF_leng] of Byte;    !         end;              {var_part contains name & path strings} !         $      NR_statetype = (NR_newBegin, NR_oldBegin, NR_newName, NR_oldName,  $                  NR_newIP, NR_newIPid, NR_newIEEE802id,                    NR_newAddr, NR_newEnd, NR_new_Error);                {TF state information record}      Pas_File_name = PACKED ARRAY[1.. 150] of char;      { Types used for Pascal I/O errors }      ErrorType  = (run, ema, i_o, fmp, seg, warn);         String_26 = PACKED ARRAY [1..26] OF char;      TYPE     ReturnParamsType = ARRAY [1..5] OF INT16;      $subtitle 'Global Variables',PAGE$  &{-------------------------------------------------------------------------}  & &{                              Global Variables                           }  & &{-------------------------------------------------------------------------}  &     VAR         RetErr           : ReturnParamsType;    mbufid           : Int16;     pathlen          : Int16;     pathoffset       : Int16;     wkmap            : Int16;     compare_flag     : Boolean;     entries_used     : Int16;     n_NR_Entries     : Int16;     org_state        : Int16;     organization_str : String[16];    domain_str       : String[16];    cc_str           : String[1];     input_line       : string[256];     old_input_line   : string[256];   #  old_input_line_len   : Int16; {tracks length of previous input_line} #   input_line_len   : Int16; {tracks length of input_line}     prev_name        : alpha; {holds the environment name}  #  index            : int16; {holds the present index into TF.var_part} #   mach_state       : NR_statetype; {state of state-machine}     convpid          : int16; {protocol id number}    reportlen        : int16; {current length of report}      $  { The indices below refer to parts of the path report in TF.var_part}  $   reportindex      : int16; {where the report begins}     domainindex      : int16; {where current domain part begins}    lastdomain       : int16;     pathindex        : int16; {where current path begins}     Begin_TF         : Boolean;     name_copied      : Boolean;     ip_proto         : Boolean;     replace_ok       : Boolean;     simulate_eof     : Boolean;     interactive_mode : Boolean;     overwritten_entries: Int16;   
  cc               : char; 
   error_OK         : Boolean;     Paserror         : Boolean;     nr_options       : MMFlagsType;     mmflags          : MMFlagsType;     TF               : NDRecord;    internalndrec    : InternalNDRecord;    param_str        : alpha;     param_str_len    : Int16;   
  terminal_out     : text; 
 
  terminal_inp     : text; 
   token            : alpha;     TFdone,endofdata : Boolean;     scanner_new_line : Boolean;     err              : int16;     m_index          : Int16;     line_number      : Int16;{tracks line number of input file}      column_number    : Int16;{tracks column number of input file}      old_column       : Int16;     num_differences  : Int16;     num_new_nodes    : Int16;     stack            : alpha; {scanner global variable}     mode_string      : string[slimit];    error_str        : String[80];    param_1_str,    param_2_str      : String[80];    ftime_buf        : String_26;{date/time stamp }     noderec          : NodeRecord;    my_node_name     : String[80];{contains local node's name.}     i                : integer;   { loop counter }    SetSoon, endoffile, endofline : Boolean;          $subtitle 'External Proc&Fns',page$       %{------------------------------------------------------------------------} % %{                    External Procedures and Functions                   } % %{------------------------------------------------------------------------} %     $HEAPPARMS OFF$   { Check whether user is "superuser" }       %{----------------------------UserIsSuper---------------------------------} % FUNCTION UserIsSuper $ALIAS 'UserIsSuper'$           : Int16; EXTERNAL;           	$fixed_string on$  	 $HEAPPARMS OFF$       %{------------------------------get_time----------------------------------} % 	PROCEDURE get_time 	 
 $ALIAS 'Pas.TimeString'$  
   (VAR time_string: String_26);     EXTERNAL;   #{ get_time returns a date & time stamp, to be used to mark the time of # { execution.}       ${--------------------------------prtn----------------------------------} $ PROCEDURE prtn (VAR return_params : ReturnParamsType);  EXTERNAL;   { return error code to caller }           $HEAPPARMS ON, fixed_string off$  $ SUBTITLE 'Catch Pascal File Errors', PAGE $       ${------------------------------RunString-------------------------------} $ ${ Pick up run-time parameter as a string                               } $     FUNCTION RunString                  $ ALIAS 'PAS.PARAMETERS' $   (pnum: Int16; VAR p: alpha; max: Int16): Int16;  EXTERNAL;           ${------------------------------wait_time-------------------------------} $ ${  Print Pascal run-time error                                         } $     $HEAPPARMS OFF$   
PROCEDURE wait_time  
 $ALIAS 'EXEC'$        (ecode,nam,units,often,delay: Int16); EXTERNAL;           ${----------------------------------------------------------------------} $ ${                               errorprint                             } $ ${----------------------------------------------------------------------} $     
PROCEDURE errorprint 
           $alias 'Pas.errorprinter'$            ( Err_type : ErrorType;               Err_Number: int16;              Err_line: int16;              Err_file: pas_file_name;              err_flen: int16);   
          EXTERNAL;  
         FUNCTION Check_Env : Boolean;   FORWARD;      %{-----------------------------------------------------------------------}  % %{                              printerror                               }  % %{-----------------------------------------------------------------------}  %     
PROCEDURE printerror 
           ( Err_type : ErrorType;               Err_Number: int16;              Err_line: int16;              Err_file: pas_file_name;              err_flen: int16);   BEGIN   
   errorprint ( Err_type,  
                 Err_number,   
                err_line,  
 
                err_file,  
                 err_flen );       
END; { printerror }  
     ${----------------------------------------------------------------------} $ ${                             Trapproc                                 } $ ${----------------------------------------------------------------------} $     	PROCEDURE Trapproc 	           $alias 'Pas.errorcatcher'$    { hp1000 }            ( Err_type : ErrorType;               Err_Number: int16;              Err_line: int16;              Err_file: pas_file_name;              err_flen: int16);       BEGIN   
   IF error_ok THEN  
       Paserror := true     ELSE         BEGIN         Printerror ( Err_type,                     Err_number,                     err_line,                     err_file,                     err_flen );        NR_unlock(output,err);         Halt(1) {No point in continuing execution after this....}    "      END {clause to process run-time errors if error_ok is false.}  " 	END;  { Trapproc } 	     $HEAPPARMS ON$      $subtitle 'Length',PAGE$  %{-----------------------------------------------------------------------}  % %{                               length                                  }  % %{-----------------------------------------------------------------------}  %     FUNCTION length (a:Alpha) : Integer;  BEGIN      length := ord(a[0]);   END;  { length }      $page$  ${---------------------------------------------------------------------}  $ ${                             concat                                  }  $ ${---------------------------------------------------------------------}  $ ${ concat will concatenate a character onto the end of an alpha        }  $     PROCEDURE concat (VAR a:alpha; c:char);   VAR i : Integer;      BEGIN       	   i := ord(a[0]); 	 
   IF i<slimit THEN  
       BEGIN         i:= i+1;        a[i] := c;        a[0] := chr(i);         END;  	   END; { concat } 	     $page$  %{------------------------------------------------------------------------} % %{                                NDelete                                 } % %{------------------------------------------------------------------------} % %{ delete will delete a range of characters from an alpha. it starts with } % %{ the indexth character and deletes count characters                     } %     PROCEDURE Ndelete (VAR a:Alpha; index, count:Integer);  VAR len,l,i : Integer;      BEGIN       
   len := ord(a[0]); 
 
   l := index + count - 1; 
 	   IF len > l THEN 	       BEGIN         FOR i := l+1 TO len DO           a[index+i-l-1] := a[i];        a[0] := chr(len-count);         END      ELSE         a[0] := chr(index-1);       END; { Ndelete }      $page$      %{------------------------------------------------------------------------} % %{                                 Insert                                 } % %{------------------------------------------------------------------------} % %{ insert will enter a character ch into an alpha at the indexth location } % %{ and move the rest of the string over one location                      } %     PROCEDURE insert (ch:char; var a:alpha; index:integer);   	VAR i,j: Integer;  	     BEGIN       	   i := ord(a[0]); 	 
   IF i<slimit THEN  
       BEGIN         FOR j := i DOWNTO index DO           a[j+1] := a[j];        a[index] := ch;         a[0] := chr(i+1);         END       END; { insert }       $page$      &{-------------------------------------------------------------------------}  & &{                               strcomp                                   }  & &{-------------------------------------------------------------------------}  & &{ Strcomp will do a comparison of two alpha types. It returns a -1 if     }  & &{ a<b;  0 if a=b;  and a 1 if a>b                                         }  &     FUNCTION strcomp (a, b : alpha) : Integer;  VAR l,a1,b1,i : Integer;      BEGIN       
   a1 := ord(a[0]);  
 
   b1 := ord(b[0]);  
    i := 1;     IF a1<b1 THEN  
      WHILE a[0]<>b[0] DO  
 
         concat(a,chr(0))  
    ELSE   
      WHILE a[0]<>b[0] DO  
 
         concat(b,chr(0)); 
       l := ord(a[0]);         WHILE (i<l) AND (a[i]=b[i]) DO  
         i := i +1;  
       IF a[i]=b[i] THEN            strcomp := 0         ELSE  
         IF a[i]<b[i] THEN 
 
            strcomp := -1  
          ELSE   
            strcomp := 1;  
     	END;  { strcomp }  	     $page$      
$subtitle 'Scanner',PAGE$  
 ${---------------------------------------------------------------------}  $ ${                           scanner                                   }  $ ${---------------------------------------------------------------------}  $ ${  The scanner scans the input text and decides what type of token it }  $ ${  is looking at and calls the appropriate procedure                  }  $ ${   $INCLUDE 'CONVSCAN'$                                              }  $ ${    program name     : lex                                           }  $ ${     date            : 11-Feb-84                                     }  $ ${     author          : Jeffrey T. Mangasarian                        }  $ ${     modified        : for network directory conversion 31-Jul-84    }  $ ${---------------------------------------------------------------------}  $ ${  Scanner variables                                                  }  $ ${---------------------------------------------------------------------}  $ ${  stack     : string where input chars are put                       }  $ ${  tokdata   : string where current token is kept                     }  $ ${  next      : token type has the type of token                       }  $ ${  out       : file id for output text file                           }  $ ${  prog      : file id for input text file                            }  $ ${  overflow  : test to see if token length > 255 chars                }  $ ${  filename  : used to prompt users for input/output files            }  $ ${---------------------------------------------------------------------}  $     PROCEDURE scanner (VAR token : alpha);   TYPE tokentype = (literal_T, comment_T, bad_T, nil_T, space_T);    VAR   
   next : tokentype; 
    overflow : Boolean;      %{ ********************************************************************** } % %{ ***              Local Procedures of Scanner                       *** } % %{ ********************************************************************** } %     %   {---------------------------------------------------------------------} % %   {                               BadToken                              } % %   {                          (Local to Scanner)                         } % %   {---------------------------------------------------------------------} % %   { Creates a token called 'bad token'                                  } %        PROCEDURE BadToken;            BEGIN   
      next := bad_T; 
 
      token[0] := chr(0);  
 
      stack[0] := chr(0);  
       END;  { BadToken }      $page$  %   {---------------------------------------------------------------------} % %   {                             getchar                                 } % %   {                       (Local to scanner)                            } % %   {---------------------------------------------------------------------} % %   { getchar makes sure that a character is entered into the stack       } % %   { and converts upper to lower case.                                   } % %   {---------------------------------------------------------------------} %        PROCEDURE getchar;   	   VAR ch : char;  	        BEGIN  %   { If input and output are the user's terminal, then give a prompt to  } % %   { the user at the beginning of each line                              } %           IF length(stack) = 0 THEN            BEGIN           IF interactive_mode AND NOT endoffile THEN               IF scanner_new_line THEN                  BEGIN                   scanner_new_line := false;                  prompt (terminal_out, PROMPT_STRING);   
                END; 
          IF eof(input) THEN   	             BEGIN 	              concat(stack,' ');                IF input_line_len < 254 THEN                   BEGIN                   input_line_len := input_line_len + 1;                   setstrlen(input_line, input_line_len);                  input_line[input_line_len] := ' '   
                END; 
              endoffile := true;                END            ELSE  	             BEGIN 	              IF NOT eoln(input) THEN                  BEGIN                   endofline := false;                   column_number := column_number + 1;                   read(input,ch);                   IF (column_number = 1) AND (ch='/') THEN                     BEGIN                     simulate_eof := true;                     endoffile := true;                      END;                   IF input_line_len < 254 THEN                     BEGIN                     input_line_len := input_line_len + 1;                     setstrlen(input_line, input_line_len);                      input_line[input_line_len] := ch                      END  
                END  
 	             ELSE  	 "                { end of line encountered. Append a space to the end "                   of the input }                  BEGIN                   endofline := true;  
                ch := ' '; 
                 IF input_line_len < 254 THEN                     BEGIN                     input_line_len := input_line_len + 1;                     setstrlen(input_line, input_line_len);                      input_line[input_line_len] := ch                      END  
                END; 
              concat(stack,ch);               SetSoon := false;               IF NOT endoffile THEN                  IF endofline THEN                      BEGIN  #                   readln (input);  { skip to beginning of next line } #                    IF interactive_mode THEN                         scanner_new_line := true;                      old_input_line := input_line;                     input_line := '';                     line_number := line_number + 1;                     old_input_line_len := input_line_len;                     input_line_len := 0;                      { for error message reporting }                     old_column := column_number + 1;                      column_number := 0;                     SetSoon := true;                      insert(' ',stack,1)                     END               END            END      END;  {procedure getchar}      $page$  $   {------------------------------------------------------------------}  $ $   {                            word                                  }  $ $   {                      (Local to scanner)                          }  $ $   {------------------------------------------------------------------}  $ $   { word is called when an identifier or reserve word is detected    }  $ $   {------------------------------------------------------------------}  $     	   PROCEDURE word; 	    BEGIN            next := literal_T;        REPEAT           concat(token,stack[length(stack)]);           Ndelete(stack,length(stack),1);  	         getchar;  	       UNTIL ((stack[length(stack)] = ' ') OR overflow);         IF overflow THEN  	         badtoken; 	        END; { word }      $page$      %   {--------------------------------------------------------------------}  % %   {                             comment                                }  % %   {                         (Local to scanner)                         }  % %   {--------------------------------------------------------------------}  % %   {  finds comments which are enclosed in asterisks that extend to the }  % %   {  end of line                                                       }  % %   {--------------------------------------------------------------------}  %        PROCEDURE comment;   	   VAR ch : char;  	        BEGIN        next := comment_T;        REPEAT           Ndelete(stack,length(stack),1);  	         getchar;  	          ch := stack[length(stack)];  
      UNTIL setsoon; 
       Ndelete(stack,length(stack),1);   
   END; { comment }  
     $page$      %   {---------------------------------------------------------------------} % %   {                               space                                 } % %   {                         (Local to scanner)                          } % %   {---------------------------------------------------------------------} %     
   PROCEDURE space;  
 
   VAR l : integer;  
        BEGIN      
      l := length(stack);  
       IF (l>0) AND (stack[l] IN [' ',',']) THEN            Ndelete(stack,length(stack),1);        next := space_T;        getchar;      	   END; { space }  	     $page$      %{------------------------------------------------------------------------} % %{                        start of scanner                                } % %{------------------------------------------------------------------------} %     	BEGIN { scanner }  	        REPEAT         getchar;        IF NOT endoffile THEN            BEGIN           token[0] := chr(0);           overflow := false;            IF ((stack[length(stack)]) = ' ') THEN   	            space  	          ELSE               IF stack[length(stack)] IN                 ['A'..'Z','a'..'z','0'..'9','.','-','_'] THEN  
               word  
             ELSE                 IF stack[length(stack)] = '*' THEN   
                  comment  
 
               ELSE  
                   badtoken;            END        ELSE           BEGIN           next := nil_T;            token[0] := chr(0);           END;      UNTIL ((next = literal_T) OR (next = nil_T));  END; { scanner }      $subtitle 'Bad_DSAM_State',page$  %{------------------------------------------------------------------------} % %{                             Bad_DSAM_State                             } % %{------------------------------------------------------------------------} % %{  Bad_DSAM_State is called when the state of DSAM changes whilst        } % %{  NRINIT is running, i.e., NS is being shut down                        } % %{------------------------------------------------------------------------} %     
PROCEDURE Bad_DSAM_State;  
 BEGIN      Describe_error(output,er_state_changed,0);      err := er_state_changed;   END; {Bad_DSAM_State}       $subtitle 'Conv_1_to_upper',page$   %{------------------------------------------------------------------------} % %{                            Conv_1_to_upper                             } % %{------------------------------------------------------------------------} % %{  Conv_1_to_upper converts a character to uppercase, if it's in the     } % %{  range 'a' .. 'z'.                                                     } % %{------------------------------------------------------------------------} %     FUNCTION Conv_1_to_upper (cchar:char) : char;   VAR      cc : char;       BEGIN      cc := cchar;      IF (cc in ['a' .. 'z']) THEN         cc := CHR((ORD(cc) - ORD('a')) + ORD('A'));      Conv_1_to_upper := cc  END; {Conv_1_to_upper}      $subtitle 'Param_is_1',page$  %{-----------------------------------------------------------------------}  % %{                               param_is_1                              }  % %{-----------------------------------------------------------------------}  % %{  Gets the parameter so that we can tell whether we are interactive or }  % %{  not                                                                  }  % %{-----------------------------------------------------------------------}  %     #FUNCTION param_is_1(num: Int16; VAR param_string : string) : Boolean;  # VAR     i : Int16;      BEGIN          param_str_len := RunString(num,param_str,slimit);     FOR i := 1 TO param_str_len DO         param_string[i] := param_str[i-1];     IF (param_str_len <= 0) THEN         param_is_1 := true     ELSE IF (param_str_len = 1) AND (param_str[0] = '1') THEN        param_is_1 := true     ELSE   
      param_is_1 := false; 
     	END; {param_is_1}  	     $subtitle 'InitTF',page$  %{------------------------------------------------------------------------} % %{                               initTF                                   } % %{------------------------------------------------------------------------} % %{  Initialize a TF node descriptor and set the state information for     } % %{  the conversion or reconversion process                                } % %{------------------------------------------------------------------------} %     	PROCEDURE initTF;  	 VAR     i : int16;      BEGIN     WITH TF DO       BEGIN  
     nd_length := 0; 
 
     nd_name_offset := 0;  
 
     nd_path_offset := 0;  
      nd_end_offset := 0;       nd_nameinfo.ntype := 0;       nd_nameinfo.nlen  := 0;       FOR i := 1 TO max_TF_leng DO          nd_name.bytes[i] := 0;   	     END; { WITH } 	        prev_name[0] := chr(0);  {set length of prev nodename to zero}     index := 0;              {index into TF rec for conversion}   #  mach_state := NR_newbegin;  {set ASCII domain rec state to "begin"}  # #  convpid := 0;            {set conversion protocol id to undefinded}  # #  domainindex := 0;        {used to save start of domain in path rpt}  #   reportindex := 0;        {used to save start of path rpt}     reportlen   := 0;        {used to save length of path rpt}  #  lastdomain := 0;         {used when error occurs to go back to... }  #                            {...the last domain report}  #  pathindex := 0;          {used to save start of path in path report} # !  begin_TF := true;        {set when an  TF rec should be started} !   name_copied := false;     ip_proto    := false      END; { initTF }       $Subtitle 'Help_user',page$   %{-----------------------------------------------------------------------}  % %{                                  Help_user                            }  % %{-----------------------------------------------------------------------}  %     
PROCEDURE Help_user; 
 VAR   
   go_on : Boolean;  
    i : Int16;       BEGIN       	   go_on := true;  	 	   WHILE go_on DO  	       BEGIN         go_on := false; { Assume answer will be valid }         writeln(terminal_out,   !         'Mode selection.  Please choose one of the following:');  !       writeln(terminal_out,'C   Comparison mode');        writeln(terminal_out,'V   Verify mode');        writeln(terminal_out,'D   Delete mode');  &      writeln(terminal_out,'--The following modes add to Nodal Registry--'); & &      writeln(terminal_out,'P   Ask for permission to replace duplicates');  &       writeln(terminal_out,'N   Add only non-duplicates');        writeln(terminal_out,   !         'R   Replace duplicates without asking for permission');  !       writeln(terminal_out);        writeln(terminal_out,'Enter /E to exit');         prompt(terminal_out,PROMPT_STRING);         readln(terminal_inp,mode_string);         mode_string := strltrim(mode_string);         mode_string := strrtrim(mode_string);             FOR i := 1 to strlen(mode_string) DO           mode_string [i] := Conv_1_to_upper(mode_string[i]);            IF (mode_string = '/E') THEN           Halt(0)         ELSE IF (mode_string <> 'D') AND (mode_string <> 'C') AND               (mode_string <> 'R') AND (mode_string <> 'V') AND             (mode_string <> 'P') AND (mode_string <> 'N') THEN            BEGIN           writeln(terminal_out,  %           'That is not one of the available modes.  Please try again.');  %          go_on := true;            END        END;  { WHILE }   END; {help_user}      
$subtitle 'initscan',page$ 
     ${----------------------------------------------------------------------} $ ${                           initscan                                   } $ ${----------------------------------------------------------------------} $     FUNCTION initscan : Boolean;  LABEL 90;   VAR     cc            : char;     i             : Int16;    filename      : string[80];     param_str     : alpha;    param_str_len : Int16;      BEGIN          initscan := false;      entries_used := 0;      num_differences := 0;     num_new_nodes   := 0;  
   simulate_eof := false;  
    overwritten_entries := 0;     stack[0]:=chr(0);   {set length of stack to zero}  
   input_line := ''; 
    nr_options.int := 0;   
   Error_ok := true; 
 
   line_number := 1; 
    column_number := 0;  
   old_column := 0;  
    input_line_len := 0;      old_input_line_len := 0;      scanner_new_line := true;     Paserror := false;      Paserror := false;      reset(input,'','SHARED');     reset(terminal_inp,'1');      rewrite(terminal_out,'1');   $   writeln (terminal_out,'** Nodal Registry Configuration Program **');  $    writeln (terminal_out,'Enter ? for help');   
   writeln (terminal_out); 
 !   {get third parameter, and store in "mode_string" as upper case} !    param_str_len := RunString(3,param_str,slimit);      IF param_str_len >0 THEN   {parameter exists; get its value}          BEGIN         {Make a string, lower case chars shifted to uppper }        setstrlen(mode_string,param_str_len);         FOR i := 0 to param_str_len-1 DO           mode_string[i+1] := conv_1_to_upper(param_str[i])        END      ELSE         mode_string := 'DEFAULT';          {If 1st parameter is '1' or defaulted, then we're  !   {in interactive mode.  Otherwise, we're not.  This matters when ! #   {deciding whether to abort on any error in the Domain file syntax.} #    IF param_is_1 (1, param_1_str) THEN        interactive_mode := true     ELSE         interactive_mode := false;          compare_flag := param_is_1(2,param_2_str); {get param_2_str}           IF (mode_string = 'DEFAULT') THEN        Help_user;         IF (mode_string = 'C') AND         (NOT(param_2_str[1] IN ['0'..'9'])) THEN        {mode is COMPARE and output file is not an LU}  
      append(output) 
    ELSE         rewrite(output);         IF NOT Check_Env THEN GOTO 90;          initTF;      get_time(ftime_buf);  {ftime_buf <== date time stamp string.}      DS_EnterCritical(wkmap, err);  
   IF err <> 0 THEN  
       BEGIN         Bad_DSAM_State; {Terrible error!  Quit now!}        goto 90;        END;  $   DS_FetchElement(DS_NodesTD, 1, noderec.int); {get our own node name}  $    DS_LeaveCritical(wkmap);       	   WITH noderec DO 	       BEGIN         organization_str := '';         domain_str := '';         org_state := 0;         Setstrlen(my_node_name, nr_nodenamelen);        Setstrlen(cc_str, 1);         FOR i := 1 TO nr_nodenamelen DO            BEGIN           cc := nr_nodename.chars[i];           my_node_name[i] := cc;   
         cc_str[1] := cc;  
 
         IF cc = '.' THEN  
             org_state := org_state + 1           ELSE               CASE org_state OF   $            0: ;  {don't do anything, we haven't gotten to domain part}  $             1: domain_str := domain_str + cc_str;               2: organization_str := organization_str + cc_str;               OTHERWISE ;               END {CASE}           END        END;              { Identify this program, when it was run, what version, where      { it was run, and so forth. }     { Get the run string, and show what it is. }      param_str_len := RunString(-1, param_str,slimit);     IF param_str_len > 0 THEN        BEGIN         setstrlen(input_line, param_str_len);         FOR i := 1 TO param_str_len DO           input_line[i] := param_str[i - 1];         IF param_str_len > 69 THEN           i := 69        ELSE           i := param_str_len;        writeln('Parameters:',input_line:i)         END;         writeln(this_rev_date); {Take out of final version.}   
   writeln( ftime_buf:26,  
      ' Version ',Version_string, ' Mode:',mode_string);      writeln(' At node ',my_node_name);          IF (interactive_mode AND (mode_string <> 'D')) THEN        BEGIN         writeln('*++ Nodal Registry ++*');  &      writeln('* Enter a nodal path report for each node in the network.');  & '      writeln('* format: BEGIN  <node name > <IP addr> <protocol descr> END'); ' 
      writeln('*');  
 
      writeln('* Where:'); 
       writeln(  &         '* node name = name.domain.organization (each field 1..16 char)');  & !      writeln('* IP addr = IP address n.n.n.n, where n = 0..255'); ! 
      writeln('*');  
       writeln('* Protocol description format (choose 1):');   
      writeln('*');  
       writeln('*   IP');  '      writeln('*   IP IEEE802 <802 addr>; where 802 addr HH-HH-HH-HH-HH-HH;'); ' $      writeln('*                                H = hexadecimal digit'); $ 
      writeln('*');  
    END; { printing for interactive mode}         NR_Lock(output, err);  
   IF err <> 0 THEN  
       BEGIN         Describe_error(output,er_lock_failed,0);        err := er_lock_failed;        goto 90         END;  
   initscan := true; 
     90:   	END; { initscan }  	     $Subtitle 'Create_TF_Report declarations',page$       ${----------------------------------------------------------------------} $ ${                          Create_TF_Report                            } $ ${----------------------------------------------------------------------} $ ${ See description in ES document for more information about interfacing} $ ${ to this procedure                                                    } $ ${                                                                      } $ ${ input parameters : token, endofdata                                  } $ ${      token  : a string of chars containing a token.                  } $ ${               the first element of this packed array contains the    } $ ${               length of the string.                                  } $ ${      endofdata : set to true when one has no more data to pass to    } $ ${                  this procedure the length                           } $ ${ output parms     : done, error_code                                  } $ ${      done   : This parameter is set when a TF node descriptor has    } $ ${               been successully built.                                } $ ${ error_code  : This parameter returns a zero if no error occured      } $ ${               or an error number.                                    } $ ${                                                                      } $ ${ note : when entering the pathreport data the path length in a        } $ ${        domain report is continously updated. This is the only        } $ ${        parameter which is updated in IPID_action, servicemap_action, } $ ${        sap_action, address_action, and ieee802_action                } $ ${                                                                      } $ ${----------------------------------------------------------------------} $     
PROCEDURE Create_Tf_report 
          (token:alpha; Endofdata:Boolean;             Var done : Boolean;             VAR error_code: Int16);       CONST          slimit      = 80; {number of chars allowed in each string}         domain      = 1;  {ARPA IP domain of path report}         version     = 0;  {version of path report}        transports  = Allbits;        services    = Allbits;        TFvarOffset = INDR_END_BOFFSET;         pthlen      = 2;  {number of bytes a path length is  }  #      drxlen      = 2;  {number of bytes the domain report length is}  # #      prxlen      = 2;  {number of bytes the path report length is  }  #     TYPE        address     = packed array[1..20] of Byte;  #      tokentype   = (begin_s, name_s, ip_s, id_s, servicemap_s, sap_s, #                      address_s, end_s);       VAR         addr        : address;        rword       : array[1..5] of alpha;       &{  variable table                                                         }  & &{-------------------------------------------------------------------------}  & &{  addr        : a byte array to store x25, IEEE802, and IP addresses     }  & &{  rword       : an array of reserve words                                }  & &{  pathindex   : used to store the index in TF.nd_name to the start       }  & &{                of the last path.                                        }  & &{  state       : used to store the current state of the conversion process}  & &{  prev_name   : used to store the last read node name                    }  &     $SUBTITLE 'Set_error',page$   &{ *********************************************************************** }  & &{ ***            Local Procedures of Create_TF_Report                 *** }  & &{ *********************************************************************** }  &     &   {----------------------------------------------------------------------}  & &   {                            Set_Error                                 }  & &   {                   ( Local to Create_TF_Report )                      }  & &   {----------------------------------------------------------------------}  & &   {  This routine is called to set an error code.  It does this only if  }  & &   {  another error code has not already been set.                        }  &        PROCEDURE Set_Error (err : Int16);      BEGIN       IF error_code = 0 THEN error_code := err   
   END; {Set_Error}  
         $subtitle 'enterbyte',page$   %   {---------------------------------------------------------------------} % %   {                              enterbyte                              } % %   {                       (Local to Create_TF_Report)                   } % %   {---------------------------------------------------------------------} % %   {  enterbyte enters data into the global array TF.nd_name[i]          } % %   {  index is an input/output parmeter. On input index contains the     } % %   {  element index into  TF.nd_name[i]. On output it contains           } % %   {  its pervious value plus one.  the value parameter is the number    } % %   {  which is too be entered into the TF.nd_name[i].                    } %        PROCEDURE enterbyte (VAR index:int16; value:Byte);      BEGIN        IF index < max_TF_leng THEN            index := index + 1;        IF index > max_TF_leng THEN            Set_error(er_report_2big) {TF record is too big}         ELSE IF index > 0 THEN           TF.nd_name.bytes[index] := value      END; { enterbyte }       $subtitle 'enterword',page$   %   {---------------------------------------------------------------------} % %   {                            enterword                                } % %   {                    (Local to Create_TF_Report)                      } % %   {---------------------------------------------------------------------} % %   { enterword enters data into the global array TF.nd_name[i]           } % %   { index is an I/O parameter which on input contains the index to      } % %   { the global arrray. num is an input parameter which is the value     } % %   { to be entered in the array.                                         } %        PROCEDURE enterword(var index:int16; num:int16);          {non system independent but works on the 1000 & 3000 }      TYPE overlay= record                       CASE integer OF                          1 : (a : int16);                          2 : (b : packed array[1..2] of Byte);                      END;     VAR x             : overlay;          lobyte,hibyte : Byte;         BEGIN      	      x.a := num;  	       hibyte := x.b[1];         lobyte := x.b[2];   "      enterbyte(index,hibyte);{corrected 4/15 law -- low byte last}  "       enterbyte(index,lobyte);{corrected 4/15 law}     END; { enterword }       $subtitle 'enterword_nobump',page$  &   {-----------------------------------------------------------------------} & &   {                          enterword_nobump                             } & &   {                    (local to Create_TF_Report)                        } & &   {-----------------------------------------------------------------------} & &   {  Same as enterword, but index value does not increase                 } &        PROCEDURE enterword_nobump   %         (index: Int16; {index variable is passed by value, no reference}  %           num  : Int16);     BEGIN  '      enterword(index, num)  {call enterword, but don't allow index to change} ' 
   END; {enterword_nobump} 
     $subtitle 'print',page$       '   {------------------------------------------------------------------------}  ' '   {                                 print                                  }  ' '   {                       (Local to Create_TF_Report)                      }  ' '   {------------------------------------------------------------------------}  ' '   {  prints an alpha string a                                              }  '        PROCEDURE print (a:alpha; VAR f: text);     VAR  	      i :integer;  	        BEGIN        FOR i := 1 TO ord(a[0]) DO           write(f,a[i]);   	   END; { print }  	     $subtitle 'InitRwords',page$      '   {------------------------------------------------------------------------}  ' '   {                               InitRwords                               }  ' '   {                      (Local to Create_TF_Report)                       }  ' '   {------------------------------------------------------------------------}  ' '   {  this procedure initializes the reserve words BEGIN, END, X25, IEEE802 }  ' '   {  and IP.                                                               }  '        PROCEDURE initRwords;  	   VAR i : int16;  	        BEGIN        FOR i := 1 TO 5 DO           rword[i,0] := chr(0);        concat(rword[1],'B');         concat(rword[1],'E');         concat(rword[1],'G');         concat(rword[1],'I');         concat(rword[1],'N');             concat(rword[2],'E');         concat(rword[2],'N');         concat(rword[2],'D');             concat(rword[3],'X');         concat(rword[3],'2');         concat(rword[3],'5');             concat(rword[4],'I');         concat(rword[4],'E');         concat(rword[4],'E');         concat(rword[4],'E');         concat(rword[4],'8');         concat(rword[4],'0');         concat(rword[4],'2');             concat(rword[5],'I');         concat(rword[5],'P');          END; {procedure 'initRwords'}      $subtitle 'add_leading_zeros',page$       &   {----------------------------------------------------------------------}  & &   {                           add_leading_zeros                          }  & &   {                      (Local to Create_TF_Report)                     }  & &   {----------------------------------------------------------------------}  & &   {  adds on leading zeros to a string s. This is only done if           }  & &   {  the strings length is less than the length of the len parameter     }  &        PROCEDURE add_leading_zeros(var s:alpha; len:int16);      BEGIN        WHILE length(s) < len DO  
         insert('0',s,1);  
    END; { add_leading_zeros }       $subtitle 'intOverflow',page$       %   {---------------------------------------------------------------------} % %   {                              intOverflow                            } % %   {                      (Local to Create_TF_Report)                    } % %   {---------------------------------------------------------------------} % %   {  intOverflow checks to see if overflow occurs when the two integer  } % %   {  x,y have the operation performed on them.                          } % %   {  "true" is returned only if overflow would occur, otherwise         } % %   {  returned                                                           } %        FUNCTION intOverflow (x,y:integer; oper: char) : Boolean;     VAR r1,r2,r3 : real;   
       bad      : Boolean; 
        BEGIN        r1 := x;        r2 := y;  	      CASE oper OF 	 
         '+' : r3 :=r1+r2; 
 
         '-' : r3 :=r1-r2; 
 
         '*' : r3 :=r1*r2; 
 
         '/' : r3 :=r1/r2; 
       END; {CASE operation type}      
      bad := false;  
       IF r3>32767 THEN   {max positive integer}   
         bad := true 
       ELSE           IF r3<-32768 THEN  {max negative integer}              bad := true;  
      intOverflow := bad;  
    END; { intOverflow }       $subtitle 'Cnum',page$      &   {----------------------------------------------------------------------}  & &   {                               Cnum                                   }  & &   {                    (Local to Create_TF_Report)                       }  & &   {----------------------------------------------------------------------}  & &   {  Cnum changes a char-string s to an integer.  This is needed to      }  & &   {  convert the numbers read in by the scanner procedure to numbers     }  &        FUNCTION cnum (s:alpha) : integer;      VAR  	      i,r : int16; 	        BEGIN         r := 0;         FOR i := 1 TO length(s) DO             BEGIN             IF intOverflow(r,10,'*') THEN   	             BEGIN 	 
             r := 0; 
              Set_Error(er_int_ovf); {overflow}  	             END;  	           r := r*10+ord(s[i])-ord('0');             END;  	       cnum := r;  	    END; { Cnum }      $subtitle 'check_IP_addr',page$       %   {---------------------------------------------------------------------} % %   {                          check_IP_addr                              } % %   {                   (Local to Create_TF_Report)                       } % %   {---------------------------------------------------------------------} % %   {  check_IP_addr is passed a string IPstr.  It checks this string     } % %   {  and returns true if the string is a legal IP address               } %        FUNCTION check_IP_addr (IPstr:alpha) : Boolean;  "   {Changes: allow IP subfields to be 1 to 3 digits -- law 4/10/85}  "    CONST        IP_min_len = 6;{minimal allowable IP address length}        period     = '.';      VAR        i         : int16;        ipstr_len : Int16;        field_num : Int16;        loc_char  : char;          BEGIN        ipstr_len := length(IPstr);         IF ipstr_len < IP_min_len THEN           Set_Error(er_IP_bad_fmt); {Must be 4 subfields.}   $      {Scan address string.  Should contain only digits and 3 periods }  $       i := 1;         field_num := 1;         WHILE (i <= ipstr_len) AND (error_code = 0) DO           BEGIN           loc_char := IPstr[i];           IF NOT (loc_char in ['0' .. '9']) THEN   	            BEGIN  	             IF loc_char = period THEN                  field_num := field_num + 1               ELSE                 Set_Error(er_ip_bad_fmt)               END;  
         i := i + 1; 
          END;  { WHILE }        IF field_num <> 4 THEN           Set_Error(er_IP_bad_fmt);        check_IP_addr := (error_code = 0);  
   END; { Check_IP_addr }  
     $subtitle 'convIP',page$      %   {---------------------------------------------------------------------} % %   {                              convIP                                 } % %   {                     (Local to Create_TF_Report)                     } % %   {---------------------------------------------------------------------} % %   {convIP converts a checked  string str to a binary repersentation     } % %   {of an IP address.                                                    } %        PROCEDURE convIP (str : alpha; VAR addr : address);  %   { Changes:  allow 1 to 3-digit subfields for IP -- law 4/10/85        } % %   {           Verify IP subfields contain numerics and are separated    } % %   {           by periods -- law 4/10/85                                 } %    LABEL 99;     VAR  	      cc   : char; 	       i, j, k ,c_num : Byte;  
      snum : alpha;  
 
      word : int16;  
        BEGIN            FOR i := (length(str)+1) to slimit DO            str[i] := ' ';         c_num := 1;  {c_num is character number in str}         FOR i := 0 TO 3 DO {pick up 4 fields}            BEGIN           snum[0] := chr(0);   
         cc := str[c_num]; 
          j := 1;           WHILE (cc in ['0' .. '9']) AND (j<=3) DO   	            BEGIN  	             concat(snum,cc); {build a string of digits}               c_num := c_num + 1; { move on to ...}               j := j + 1;               cc := str[c_num]    { ... next digit or char}               END;      !         {Verify that each subfield is separated by a period, and  !          {contains at least one digit.}            IF i <> 3 THEN   #            IF cc <> '.' THEN {IP Subfields not separated by periods.} # 
               BEGIN 
                Set_Error(er_bad_IP_sep);                 goto 99  
               END;  
              c_num := c_num + 1; {Skip over the field separator}           IF length(snum) = 0 THEN   	            BEGIN  	             Set_Error(er_IP_subf_r);  
            goto 99  
             END;      #         word := cnum(snum); {Convert string to numeric - range 0-255} #          IF (word<0) or (word>255) THEN   	            BEGIN  	 "            Set_Error(er_IP_subf_r); {IP subfield must be in 0..255} " 
            GOTO 99  
             END            ELSE   	            BEGIN  	             k := ord(word);               {first field of address for IP Class C addressing               {must be in 192..223}               addr[i+1] := k;               END;           END;       $      { At this point, each of the four fields have been verified to be  $ $        between 0 and 255 inclusive and their numeric values are stored  $ $        in addr[i], i = 1 to 4. Now check for zero network addresses and $ $        node numbers, as well as network addresses that fall within the  $         reserved class }            IF (addr[1] = 0) THEN            { zero valued network number }            Set_Error (er_net_zero)        ELSE IF (addr[1] <= 127) THEN            BEGIN            { Class A address. Check for zero valued node address }            IF ((addr[2]=0) AND (addr[3]=0) AND (addr[4]=0)) THEN              Set_Error (er_node_zero)           END        ELSE IF (addr[1] <= 191) THEN            BEGIN            { Class B address. Check for zero valued node address }            IF ((addr[3]=0) AND (addr[4]=0)) THEN              Set_Error (er_node_zero)           END        ELSE IF (addr[1] <= 223) THEN            BEGIN            { Class C address. Check for zero valued node address }            IF (addr[4]=0) THEN              Set_Error (er_node_zero)           END        ELSE           { address is in the reserved class }            Set_Error (er_reserved_class);      99:  	   END; { convIP } 	     $subtitle 'hex',page$       &   {-----------------------------------------------------------------------} & &   {                                Hex                                    } & &   {                     (Local to Create_TF_Report)                       } & &   {-----------------------------------------------------------------------} & &   {  hex converts a 2 digit hexidecimal number to an integer in base 10   } & &   {  digit1,digit2 are the input parameters. digit1 is the high digit     } & &   {  so F4 would have digit1=F, digit2=4                                  } &        FUNCTION Hex(digit1,digit2:char):Byte;      VAR  	      num : Byte;  	     &      {--------------------------------------------------------------------} & &      {                      hdigit (Local to Hex)                         } & &      {--------------------------------------------------------------------} & &      { hdigit -- a little routine to convert a hex digit to a 4-bit value } &           FUNCTION hdigit (digit:char) : Byte;        VAR   	         x : Byte; 	           BEGIN            CASE digit OF              '0','1','2','3','4','5',               '6','7','8','9'          : x := ord(digit)-ord('0');   #            'A','B','C','D','E','F'  : x := ord(digit)-ord('A') + 10;  #          END;            hdigit := x;         END; { hdigit }       &   {----------------------- start of function hex -------------------------} &     	   BEGIN  { hex }  	       num := hdigit(digit1)*16+hdigit(digit2);  	      hex := num;  	    END; { hex }       $subtitle 'check_802_addr',page$      &   {-----------------------------------------------------------------------} & &   {                              check_802_addr                           } & &   {                       (Local to Create_TF_Report)                     } & &   {-----------------------------------------------------------------------} & &   { check_802_addr is passed a string IEEEstr which it may alter          } & &   { and returns a true value if the string is a legal IEEE802 address     } &        FUNCTION check_802_addr(var IEEEstr:alpha):Boolean;     CONST        IEEE802_len = 17;   	      dash = '-';  	    VAR        i:int16;        loc_char : char;         BEGIN            add_leading_zeros(IEEEstr,IEEE802_len);         i := 1;         IF length(IEEEstr)<> IEEE802_len THEN   "         Set_Error(er_802_bad_fmt); { 802 address length is wrong }  "           WHILE (i<=IEEE802_len) AND (error_code = 0) DO           BEGIN           loc_char := IEEEstr[i];           IF i mod 3 = 0 THEN  	            BEGIN  	             IF loc_char <> dash THEN  "               Set_Error(er_802_bad_fmt);{incorrect fmt for 802 adr} "             END            ELSE               IF NOT (loc_char IN ['0'..'9','A'..'F']) THEN                   Set_Error(er_802_bad_fmt);{bad char in 802 addr}                i := i + 1;            END;         check_802_addr := (error_code = 0);   
   END; { check_802_addr } 
     
$subtitle 'conv802',page$  
     &   {----------------------------------------------------------------------}  & &   {                                conv802                               }  & &   {                       (Local to Create_TF_Report)                    }  & &   {----------------------------------------------------------------------}  & &   {  conv802 converts a string str to a binary representation of an      }  & &   {  802 address.  This can only be called after the string has been     }  & &   {  checked by check_802_addr.                                          }  &        PROCEDURE conv802 (str:alpha; var buf802: address);     VAR        i : int16;     BEGIN        FOR i := 6 DOWNTO 1 DO           buf802[7-i] := hex(str[18-(i*3-1)],str[18-(i*3-2)]);   
   END; { conv802 }  
     $subtitle 'BCD',page$       %   {--------------------------------------------------------------------}  % %   {                                BCD                                 }  % %   {                    (Local to Create_TF_Report)                     }  % %   {--------------------------------------------------------------------}  % %   {function BCD converts a two digit decimal number into binary        }  % %   {coded decimal. to convert 58, d1=5, d2=8                            }  %        FUNCTION BCD (d1,d2:char) : Byte;     VAR        x : Byte;      BEGIN        x := (ord(d1)-ord('0'))*16;         BCD := x + (ord(d2) - ord('0'))      END; { BCD }       $subtitle 'check_X25_addr',page$      %   {--------------------------------------------------------------------}  % %   {                             check_X25_addr                         }  % %   {                        (Local to Create_TF_Report)                 }  % %   {--------------------------------------------------------------------}  % %   {  check_X25_addr is passed a string X25str, which it may modify.    }  % %   {  It returns a true value if the string is X25 compatible           }  %     {  FUNCTION check_x25_addr(var X25str:alpha) : Boolean;   {  CONST  
{     len_X25 = 16;  
 {  VAR  
{     i,len : int16; 
 {   {  BEGIN  {   {     add_leading_zeros(X25str,len_X25);  {     len := length(X25str);  {     IF len <> len_X25 THEN  {        Set_Error(er_X25_addr_2big)  {     ELSE  {        FOR i := 1 TO len DO   {           IF NOT (X25str[i] IN ['0'..'9']) THEN   {              Set_Error(er_X25_badc);  {     check_x25_addr := (error_code = 0)  {   {  END; } { check_x25_addr }  {}      
$subtitle 'convX25',page$  
     %   {--------------------------------------------------------------------}  % %   {                              convX25                               }  % %   {                      (Local to Create_TF_Report)                   }  % %   {--------------------------------------------------------------------}  % %   {  convX25 converts a string str into a binary coded decimal and     }  % %   {  returns the result in bufX25. This may only be used after         }  % %   {  check_X25_addr has been called.                                   }  %     {  PROCEDURE convX25 (str:alpha; var bufX25: address);  {  VAR  {     i : int16;  {  BEGIN  {     FOR i := 8 DOWNTO 1 DO  {        bufX25[i] := bcd(str[16-(i*2-1)],str[16-(i*2-2)])  
{  END; }{ convX25 } 
 {}      $subtitle 'checknodename',page$       %   {---------------------------------------------------------------------} % %   {                              Checknodename                          } % %   {                       (Local to Create_TF_Report)                   } % %   {---------------------------------------------------------------------} % %   {  checknodename is passed a string str and verifies that the string  } % %   {  meets the standards set for the first release of the network dir   } %        FUNCTION checknodename (VAR str:alpha) : Boolean;     VAR        y                  : int16;         dot_found          : Boolean;         defaulted_subfield : Boolean;       %      {------------------------------------------------------------------} % %      {                            Find1to16                             } % %      {                     (Local to Checknodename)                     } % %      {              (Checknodename local to Create_TF_Report)           } % %      {------------------------------------------------------------------} % %      {Find1to16 scans up to a 16-character string starting at index y of} % %      {str. The index is modified such that it points to char after the  } % %      {index. Variables y, str and dot_found are globals passed from     } % %      {checknodename.                                                    } %     
      PROCEDURE find1to16; 
       VAR            count,len : int16;            kk        : Int16;            loop_done : Boolean;       
      BEGIN  { find1to16 } 
          dot_found := false;           len := length(str);           loop_done := false;  
         count := 1; 
          IF len>=y THEN   	            BEGIN  	             kk := ORD(str[y]);              {Is 1st char in field alpha?}               IF (kk < ORD('A')) OR (kk > ORD('Z')) THEN              {No, set error code for illegal format.}              Set_Error(er_name_fmt) {illegal char in name}               END            ELSE               Set_Error(er_name_fmt); {illegal name format}       "         WHILE (len>=y+1) AND (NOT loop_done) AND (error_code=0) DO  " 	            BEGIN  	             count := count + 1;               IF (count>17) OR ((count=17) AND (y+1 = len)) THEN                 Set_Error(er_name_subf_2big);{name subfield}               y := y+1;   
            cc := str[y];  
 
            kk := ORD(cc); 
             IF cc = '.' THEN  
               BEGIN 
                dot_found := true;                  loop_done := true  	               END 	             ELSE IF ((kk < ORD('A')) OR (kk > ORD('Z'))) AND                 ((kk < ORD('0')) OR (kk > ORD('9'))) AND                  (cc <> '_') AND (cc <> '-') THEN                  {illegal char in field}                 Set_Error(er_name_fmt) {Illegal char in name}  
            END; { WHILE } 
 
      END;  { Find1to16 }  
     
$subtitle 'add_str',page$  
     %      {------------------------------------------------------------------} % %      {                               add_str                            } % %      {                       (Local to Checknodename)                   } % %      {              (Checknodename local to Create_TD_Report)           } % %      {------------------------------------------------------------------} %           PROCEDURE add_str (VAR str1: alpha; VAR str2: string);        VAR   	         i: Int16; 	       BEGIN            concat(str1, '.'); {Start the field with a period.}           FOR i := 1 TO strlen(str2) DO              concat(str1, str2[i])   
      END; {add_str} 
     $subtitle 'checknodename (again)',page$   %   {---------------------------------------------------------------------} % %   {                    start of Checknodename                           } % %   {                  (Local to Create_TF_Report)                        } % %   {---------------------------------------------------------------------} %     
   BEGIN  {checknodename}  
       y := 1;         defaulted_subfield := false;        find1to16;        IF NOT dot_found THEN   #         BEGIN {No first period. Add domain and organization strings}  #          add_str(str, domain_str);           add_str(str, organization_str);           defaulted_subfield := true;  
         y := y + 1  
          END;         y := y + 1; {move passed the period.}         find1to16;        IF NOT dot_found THEN             BEGIN {No second period.  Add only organization string}            add_str(str, organization_str);  
         y := y + 1; 
          defaulted_subfield := true            END;   	      y := y + 1;  	       find1to16;        IF dot_found THEN            BEGIN           { period after third name. This is not allowed }            Set_Error (er_name_fmt);            END        ELSE IF (error_code = 0) AND defaulted_subfield THEN  '      { Print warning about having substituted subfields in environment name}  '          BEGIN           writeln(terminal_out,  #           'Warning: defaulted domain and/or organization subfield.'); #           write(terminal_out,'Taking full environment name as:');            print(str, terminal_out);           writeln(terminal_out)           END;         checknodename := (error_code=0);         END; {checknodename}       
$subtitle 'checksap',page$ 
     &   {----------------------------------------------------------------------}  & &   {                               checksap                               }  & &   {                        (Local to Create_TF_Report)                   }  & &   {----------------------------------------------------------------------}  & &   {  checksap is passed a string which it may modify.  If the            }  & &   {  string is SAP compatible it returns a true value.                   }  & &   {  Change 4/26/85 --law                                                }  & &   {  A change was made to the syntax rules, removing the need for user   }  & &   {  to specify the Service Access Point.  This change obviated the need }  & &   {  for this routine.  In the interests of code-space, it is commented  }  & &   {  out, but the lines of code remain, in case they should be needed.   }  &        {  FUNCTION checksap(var tok:alpha):Boolean;      {  CONST sap_len=4;  
   {  VAR i : int16; 
    {     {  BEGIN      {     add_leading_zeros(tok,sap_len);     {     IF length(tok) > 4 THEN     {        Set_Error(er_sap_len) {sap length wrong}     {     ELSE      {        FOR i := 1 TO 4 DO     {           IF NOT (tok[i] IN ['0'..'9','A'..'F']) THEN     {              Set_Error(er_sap_badc);{Illegal char in sap}     {     checksap := (error_code=0)      {  END;  { Checksap }     {}       $subtitle 'checkaddress',page$      %   {---------------------------------------------------------------------} % %   {                             checkaddress                            } % %   {                      (Local to Create_TF_Report)                    } % %   {---------------------------------------------------------------------} % %   { checkaddress is passed a string with an address and calls procedures} % %   { to check it. The string may be modified. A true value is returned if} % %   { the address is valid.                                               } %        FUNCTION checkaddress (var t:alpha) : Boolean;      VAR  	      ok: Boolean; 	        BEGIN  	      ok := false; 	     {     IF (convpid = 2) OR (convpid = 7) THEN  {        case convpid of  {           2 : ok :=  check_x25_addr(t);   {           7 : ok :=  check_802_addr(t);   {        end;   {}        ok := check_802_addr(t);        checkaddress := ok     END; { checkaddress }      $subtitle 'checkprotocolid',page$       &   {----------------------------------------------------------------------}  & &   {                             checkprotocolid                          }  & &   {                      (Local to Create_TF_Report)                     }  & &   {----------------------------------------------------------------------}  & &   {  Checkprotocolid checks a protocol identifier with the ids listed    }  & &   {  in the Rwords table.                                                }  &        FUNCTION checkprotocolid (x:alpha) : Boolean;     VAR        i : int16;        found : Boolean;         BEGIN        i := 3;         found := false;         REPEAT           IF strcomp(rword[i],x)=0 THEN   {rword=x ?}  
            found := true; 
 
         i := i + 1; 
       UNTIL (i=6) OR found;             IF NOT found THEN            checkprotocolid  := false        ELSE IF { (i = 4) OR } (i = 5) OR (i = 6) THEN           BEGIN  	         CASE i OF 	             { 4 : convpid := 2; } {X25}               5 : convpid := 7; {IEEE802}               6 : convpid := 8; {IP}  
            END; {case i}  
          checkprotocolid := true;            END        ELSE           checkprotocolid:= false;       
   END;  {checkprotocolid} 
     $subtitle 'Match',page$       &   {----------------------------------------------------------------------}  & &   {                                Match                                 }  & &   {                     (Local to Create_TF_Report)                      }  & &   {----------------------------------------------------------------------}  & &   {  Match is passed a tokentype identifier, it goes and calls an        }  & &   {  appropriate check procedure and returns a true value if the         }  & &   {  tokentype expected is actually in the current token.                }  &        FUNCTION Match (T:tokentype) : Boolean;     VAR        found : Boolean;         BEGIN        found := false;   !      IF (ORD(T) >= ORD(begin_s)) AND (ORD(T) <= ORD(end_s)) THEN  ! 	         CASE T OF 	 !            begin_s     : found := (strcomp(rword[1],token) = 0);  !             name_s      : found := checknodename(token);              IP_s        : found := check_IP_addr(token);              ID_s        : found := checkprotocolid(token);              servicemap_s: found := false;   # { NB: call to checksap commented out.  See note on function checksap} #             sap_s       :; {  found := checksap(token); }               address_s   : found := checkaddress(token);   !            end_s       : found := (strcomp(rword[2],token) = 0);  !          END        ELSE           Set_Error(er_fatal_45); {fatal error}            IF error_code <> 0 THEN            found := false;        match := found;      END; {Match}       $subtitle 'Begin_action',page$      %   {--------------------------------------------------------------------}  % %   {                             Begin_action                           }  % %   {                     (Local to Create_TF_Report)                    }  % %   {--------------------------------------------------------------------}  % %   {  Begin_action is called when the next expected state is NR_oldBegin}  % %   {  or NR_newbegin. The procedure updates lengths within the TF node  }  % %   {  descriptor.                                                       }  %     
   PROCEDURE Begin_action; 
    VAR  
      domain_len : Int16;  
    BEGIN        convpid := -1;            {set protocol id to undefined}        IF mach_state = NR_oldBegin THEN           BEGIN {close domain}            domain_len := index - domainindex - drxlen;           enterword_nobump(domainindex,              index - domainindex - drxlen);           reportlen := reportlen + domain_len + 2;            enterword_nobump(reportindex, reportlen);           lastdomain := index   {starting point of domain}   
         END { IF }  
    END; {Begin_action}      $subtitle 'Nodename_action',page$       %   {---------------------------------------------------------------------} % %   {                            Nodename_action                          } % %   {                     (Local to Create_TF_Report)                     } % %   {---------------------------------------------------------------------} % %   {  nodename_action  updates the TF node descriptor and closes the     } % %   {  TF node descriptor if a new node name is found.                    } %        PROCEDURE Nodename_action;      VAR        i : int16;         BEGIN        WITH TF DO           BEGIN           { assume no IP node descriptor found yet}  $         IF mach_state = NR_oldName THEN { already have name in TF rec } $ 	            BEGIN  	 $            IF strcomp(prev_name,token)<>0 THEN   {if strings not equal} $ #               { The user is not permitted to concatenate entries with # #                 different environment names without putting an 'end'  #                  after the first entry }                 Set_Error (er_diff_name);              END;           prev_name := token;        END {WITH}  
   END; {Nodename_action}  
     $subtitle 'IP_action',page$       &   {----------------------------------------------------------------------}  & &   {                               IP_action                              }  & &   {----------------------------------------------------------------------}  & &   {  IP action updates the TF node and enters the last node name read    }  & &   {  if a new TF node descriptor is to be started.                       }  & &   {  It also enters an IP address.                                       }  & &   {----------------------------------------------------------------------}  &        PROCEDURE IP_action;      CONST        name_type = 1;      {node name type = 1}     VAR  
      len,i : int16; 
        BEGIN        WITH TF DO           BEGIN  !         IF NOT name_copied AND begin_tf THEN { start new TF rec } ! 	            BEGIN  	             name_copied := true;              nd_name_offset := TFvarOffset; {TF name offset}               nd_nameinfo.ntype := name_type;               len := length(prev_name);               nd_nameinfo.nlen := len; {enter name length}      "            { The Standard calls for adding a pad byte of the number " &            { of characters in the node name is odd.  The pad byte is zero } &                 IF odd(len) THEN                 concat(prev_name,chr(0));              len := length(prev_name);                   FOR i := 1 TO len DO           {enter name }                 enterbyte(index,ord(prev_name[i]));      $            nd_path_offset := index+TFvarOffset+2;  {enter TF path offse $ #            index := index + 2;            {save space for report len} #             begin_TF := false;              END;               IF reportindex = 0 THEN {open report}  	            BEGIN  	             reportindex := index;               index := index + 2    {save space for report leng}              END;           {open domain report}   !         domainindex := index;   {save domain report start index}  !          index := index + 2;     {save space for domain leng}            enterbyte(index,version);           enterbyte(index,domain);            convIP(token,addr);           FOR i := 1 TO 4 DO      {enter ARPA IP address}              enterbyte(index,addr[i])        END {WITH}  
   END;  {IP_action} 
     $subtitle 'ARPA_action',page$       &   {----------------------------------------------------------------------}  & &   {                              ARPA_action                             }  & &   {                      (local to Create_TF_Report)                     }  & &   {----------------------------------------------------------------------}  & &   {  Invoked by ID_state when the keyword IP is encountered to enter the }  & &   {  IP pid, element length for IP (2), and a blank entry into TF.       }  & &   {  This implies inserting the values 8 2 0 0.                          }  & &   {----------------------------------------------------------------------}  &     
   PROCEDURE ARPA_action;  
    BEGIN        ip_proto := true;      { Note that "ip" was given }         enterbyte (index,IP);  { enter IP pid }         enterbyte (index,2);   { element length }         enterword (index,0)    { next two bytes are zeros }      END; {ARPA_action}       $subtitle 'IEEE802_action',page$      %   {---------------------------------------------------------------------} % %   {                             IEEE802_action                          } % %   {                       (local to Create_TF_Report)                   } % %   {---------------------------------------------------------------------} % %   { This routine builds a part of the protocol element for the LAN.     } % %   { The protocol element in its complete form is as follows:            } % %   { ! byte     !  byte                                                  } % %   { +_____________________________+                                     } % %   { ! pid = 7  ! elem. len = 8    !                                     } % %   { +_____________________________+                                     } % %   { !RESERVED  ! IP's SAP #       !                                     } % %   { +_____________________________+                                     } % %   { !LAN address( bytes 1 & 2)    !                                     } % %   { +_____________________________+                                     } % %   { !LAN address( bytes 3 & 4)    !                                     } % %   { +_____________________________+                                     } % %   { !LAN address( bytes 5 & 6)    !                                     } % %   { +_____________________________+                                     } % %   {                                                                     } % %   { The LAN address portion is filled in later.                         } %        PROCEDURE IEEE802_action;     BEGIN        enterbyte(index,IEEE_802);   {enter IEEE802 pid}        enterbyte(index,8);          {length of IEEE802 info}         enterbyte(index,0);          {next byte is RESERVED}        enterbyte(index,IPSAP);      {next byte is IP's SAP}  &      enterword_nobump (pathindex,index-pathindex-pthlen); { report length } & 
   END; { IEEE802_action } 
     $subtitle 'X25_action',page$      &   {----------------------------------------------------------------------}  & &   {                             X25_action                               }  & &   {                      (local to Create_TF_Report)                     }  & &   {----------------------------------------------------------------------}  &        PROCEDURE X25_action;     BEGIN  %      error_code := 14; {temporary; take out when X.25 access allowed   }  % %      { The code below has been commented out, since X.25 access not    }  % %      { allowed in first release.                                       }  % %      {             enterbyte(index,X25);                               }  % %      {             enterbyte(index,10);                                }  %       {}  
   END; {X25_action} 
     $subtitle 'ID_action',page$       %   {---------------------------------------------------------------------} % %   {                             IPID_action                             } % %   {                      (Local to Create_TF_Report)                    } % %   {---------------------------------------------------------------------} % %   {  Invoked upon encountering the expected IP keyword, to enter the IP } % %   {  path element information into the nodal path report.               } % %   {---------------------------------------------------------------------} %     
   PROCEDURE IPID_action;  
    VAR  
      temp : int16;  
        BEGIN  
      pathindex := index;  
       index := index + 2;     {save space for path length}        enterbyte(index,255);   {enter services pid}        enterbyte(index,2);     {length of services}            { Set bit map showing services supported.}        enterword(index,services);        enterbyte(index,254);   {enter transports pid}        enterbyte(index,2);     {length of transports}        { Set bit map showing transports supported.}        enterword(index,transports);  	      ARPA_action; 	       {stuff length of path}        enterword_nobump(pathindex, index - pathindex - pthlen);     END;  { IPID_action }      $subtitle 'Servicemap_action',page$       %   {--------------------------------------------------------------------}  % %   {                       Servicemap_action                            }  % %   {                   (Local to Create_TF_Report)                      }  % %   {--------------------------------------------------------------------}  % %   { NB: This routine has been commented out for some reason ...        }  % %   {       PROCEDURE Servicemap_action;                                 }  % %   {       VAR temp : integer;                                          }  % %   {       BEGIN                                                        }  % %   {               .                                                    }  % %   {               .                                                    }  % %   {               .                                                    }  % %   {          temp := pathindex;                                        }  % %   {          enterword(temp,index - pathindex - pthlen);               }  % %   {       END;                                                         }  %    {}       $subtitle 'Sap_action',page$      %   {--------------------------------------------------------------------}  % %   {                           Sap_action                               }  % %   {                   (Local to Create_TF_Report)                      }  % %   {--------------------------------------------------------------------}  %     {  PROCEDURE Sap_action;  {  VAR  {     sap : packed array[1..2] of Byte;   {   {  BEGIN  {     sap[1] := hex(token[1],token[2]);   {     sap[2] := hex(token[3],token[4]);   {     enterbyte(index,sap[2]);  {     enterbyte(index,sap[1]);  {     { length of path}   {     enterword_nobump(pathindex, index - pathindex - pthlen)   {  END; } {SAP_action}  {}      $subtitle 'address_action',page$      &   {----------------------------------------------------------------------}  & &   {                         address_action                               }  & &   {                   (Local to Create_TF_Report)                        }  & &   {----------------------------------------------------------------------}  &        PROCEDURE address_action;      %      {------------------------------------------------------------------} % %      {                         enter_X25_addr                           } % %      {                   (Local to address_action)                      } % %      {             (address_action local to create_TF_report)           } % %      {------------------------------------------------------------------} %     {     PROCEDURE enter_X25_addr;   {     VAR   
{        i : int16;  
 {   {     BEGIN   {        convx25(token,addr);   {        FOR i := 1 TO 8 DO   {           enterbyte(index,addr[i])  {     END;} {enterX25}  {}      %      {------------------------------------------------------------------} % %      {                       enter_IEEE802_addr                         } % %      {                    (Local to address_action)                     } % %      {             (address_action local to Create_TF_Report)           } % %      {------------------------------------------------------------------} %           PROCEDURE enter_IEEE802_addr;         VAR   	         i: int16; 	           BEGIN            conv802(token,addr);            FOR i := 1 TO 6 DO               enterbyte(index,addr[i]);         END; {enter_IEEE802_addr}       %   {---------------------------------------------------------------------} % %   {                        start of address action                      } % %   {                       (Local to Create_TF_Report)                   } % %   {---------------------------------------------------------------------} %     
   BEGIN {address action}  
       { IF convpid = 2 THEN            enter_X25_addr         ELSE } IF convpid = 7 THEN           enter_IEEE802_addr         ELSE           Set_Error(er_proto_id); {fatal error}            { enter length of path}         enterword_nobump(pathindex, index - pathindex - pthlen)      END; {address_action}      $subtitle 'End_action',page$      &   {----------------------------------------------------------------------}  & &   {                           end_action                                 }  & &   {                    (Local to Create_TF_Report)                       }  & &   {----------------------------------------------------------------------}  & &   {  This procedure is invoked by end_state when the keyword 'END' is    }  & &   {  encountered, to complete the TF entry to be inserted into the       }  & &   {  Nodal Registry                                                      }  & &   {----------------------------------------------------------------------}  &        PROCEDURE end_action;     VAR  
      domain_len : Int16;  
    BEGIN        WITH TF DO           BEGIN           done := true;  
         begin_tf := true; 
          domain_len := index - domainindex - drxlen;  #         enterword_nobump (domainindex,index - domainindex - drxlen);  #          reportlen := reportlen + domain_len + 2;            enterword_nobump (reportindex, reportlen);            lastdomain := index;            nd_length := index + TFvarOffset + 2;           nd_end_offset := index + TFvarOffset + 2;           END; { WITH }     END; { end_action }      $subtitle 'Begin_State',page$       &   {----------------------------------------------------------------------}  & &   {                           Begin_State                                }  & &   {                    (Local to Create_TF_Report)                       }  & &   {----------------------------------------------------------------------}  & &   {   Invoked by Create_TF_Report when the next expected token item is   }  & &   {   the keyword BEGIN.  If BEGIN is encounted, begin_action is then    }  & &   {   invoked to complete the previous entry if necessary.  It then sets }  & &   {   the next expected token: the environment name, which should be     }  & &   {   the same as the previous name, if an END wasn't encountered before }  & &   {   the BEGIN, or any other name, if an END was encountered.           }  & &   {----------------------------------------------------------------------}  &     
   PROCEDURE Begin_State;  
    BEGIN        IF match(begin_S) THEN           Begin_action         ELSE           Set_Error(er_missing_begin);{missing begin}            IF mach_state = NR_oldBegin THEN {first domain report?}            mach_state := NR_oldName         {NO}        ELSE           mach_state := NR_newName;        {Yes}      END; { Begin_State }       $subtitle 'name_State',page$      &   {----------------------------------------------------------------------}  & &   {                              name_State                              }  & &   {                      (local to Create_TF_Report)                     }  & &   {----------------------------------------------------------------------}  &        PROCEDURE name_State;     BEGIN        IF match(name_S) THEN   
         nodename_Action;  
       {set next expected mach_state}        mach_state := NR_newIP;      END; { name_state }      $subtitle 'IPaddr_state',page$      %   {---------------------------------------------------------------------} % %   {                            IPaddr_state                             } % %   {                     (Local to Create_TF_Report)                     } % %   {---------------------------------------------------------------------} % %   {  This procedure is invoked when the IP address is expected          } % %   {---------------------------------------------------------------------} %     
   PROCEDURE IPaddr_state; 
    BEGIN  
      IF match(IP_s) THEN  
 
         IP_Action;  
           mach_state := NR_newIPid;          END;  {IPaddr_state}       $subtitle 'IPid_state',page$      %   {---------------------------------------------------------------------} % %   {                            IPid_state                               } % %   {                     (Local to Create_TF_Report)                     } % %   {---------------------------------------------------------------------} % %   {  This procedure is invoked when the keyword IP is expected          } % %   {---------------------------------------------------------------------} %        PROCEDURE IPid_state;         BEGIN      
      IF match(ID_s) THEN  
          BEGIN           { make sure id = 8 for IP }           IF (convpid = 8) THEN  	            BEGIN  	             IPID_Action;              mach_state := NR_newIEEE802id;              END            ELSE               Set_Error(er_no_ip);           END        ELSE           Set_Error(er_no_ip);          END; { IPid_state }      $subtitle 'IEEE802id_state',page$       %   {---------------------------------------------------------------------} % %   {                          IEEE802id_state                            } % %   {                    (Local to Create_TF_Report)                      } % %   {---------------------------------------------------------------------} % %   {   This procedure is invoked when the keyword IEEE802 is expected    } % %   {---------------------------------------------------------------------} %        PROCEDURE end_state; FORWARD;         PROCEDURE IEEE802id_state;      BEGIN  
      IF match(ID_s) THEN  
          BEGIN           { make sure id=7 for ieee802 and that it is not IP }            IF convpid = 7 THEN  	            BEGIN  	             IEEE802_Action;               mach_state := NR_newAddr;               END            ELSE               Set_Error(er_ieee802_id); {Fatal error}            END        ELSE           BEGIN  "         error_code := 0;  {reset error and look for 'begin' token}  "          IF match(begin_s) THEN   	            BEGIN  	             mach_state := NR_oldBegin;              begin_state;              END            ELSE   	            BEGIN  	             {reset error flag and look for 'end' token}               error_code := 0;              IF match(end_s) THEN  
               BEGIN 
                mach_state := NR_newEnd;   
               end_state;  
 	               END 	             ELSE                 {expected protocol ID or Begin or END}                  Set_Error(er_exp_pid_or_beg_or_end)              END;           END;      END; { IEEE802id_state }       $subtitle 'SAP_state',page$       %   {--------------------------------------------------------------------}  % %   {                            SAP_state                               }  % %   {                     (Local to Create_TF_Report)                    }  % %   {--------------------------------------------------------------------}  %     {  PROCEDURE SAP_state;   {  BEGIN  
{     IF match(sap_s) THEN 
 
{        Sap_Action; 
 {     IF (convpid = 2) OR (convpid = 7) THEN  {        mach_state := NR_newAddr   {     ELSE  {        Set_Error(er_fatal_43)   {  END; } { SAP_state }   {}      $subtitle 'addr_state',page$      %   {---------------------------------------------------------------------} % %   {                           addr_state                                } % %   {                     (Local to Create_TF_Report)                     } % %   {---------------------------------------------------------------------} %        PROCEDURE addr_state;     BEGIN        if match(address_s) then           address_action;          mach_state := NR_newEnd;  {set next expected mach_state}       END; { addr_state }      $subtitle 'End_state',page$       %   {---------------------------------------------------------------------} % %   {                            End_state                                } % %   {                   (Local to Create_TF_Report)                       } % %   {---------------------------------------------------------------------} %        PROCEDURE end_state;      BEGIN  
      IF match(end_s) THEN 
          BEGIN  
         end_action; 
          mach_state := NR_newBegin           END        ELSE IF match(begin_s) THEN            BEGIN           mach_state := NR_oldBegin;            begin_state;            END        ELSE           Set_Error(er_exp_beg_or_end);{expected begin or end}   
   END; {End_State}  
     $subtitle 'Error_State',page$       %   {---------------------------------------------------------------------} % %   {                             Error_State                             } % %   {                       (Local to Create_TF_Report)                   } % %   {---------------------------------------------------------------------} %     
   PROCEDURE Error_State;  
    BEGIN        IF lastdomain = 0 THEN           BEGIN           initTF;  
         index := 0; 
          END        ELSE           index := lastdomain; {destroy bad domain report}             IF match(begin_s) THEN           BEGIN           IF lastdomain > 0 THEN               mach_state := NR_oldBegin            ELSE               mach_state := NR_newbegin;           begin_state;            END        ELSE           {continued state error until a 'begin'}           Set_Error(er_cont_state)      END; { Error_State }       
$subtitle 'shutdown',page$ 
     %   {---------------------------------------------------------------------} % %   {                              shutdown                               } % %   {                    (Local to Create_TF_Report)                      } % %   {---------------------------------------------------------------------} %        PROCEDURE shutdown;     VAR        i:int16;  
   BEGIN  {shutdown} 
       WITH TF DO           BEGIN           IF (mach_state <> NR_newBegin) THEN  %            Set_Error(er_path_incompl);{endofdata with an incomplete path} %          done := true;           END; { WITH }  
   END;  {shutdown}  
     $subtitle 'convertuppercase',page$      %   {---------------------------------------------------------------------} % %   {                         convertuppercase                            } % %   {                     (Local to Create_TF_Report)                     } % %   {---------------------------------------------------------------------} %        PROCEDURE convertuppercase(var token:alpha);      VAR        i : int16;     BEGIN        FOR i := 1 TO length(token) DO           IF token[i] in ['a'..'z'] THEN               token[i] := chr( ord(token[i]) -32);  
   END; {convertuppercase} 
     $subtitle 'Create_TF_Report (code)',page$       %{-----------------------------------------------------------------------}  % %{                start of code for Create_TF_Report                     }  % %{-----------------------------------------------------------------------}  %     BEGIN {Create_TF_report}     IF endofdata AND (length(token)=0) THEN        shutdown     ELSE         BEGIN   	      initrwords;  	       error_code := 0;  
      IF done = true THEN  
          initTF;   {zero out all data in TF node descriptor}  
      done := false; 
 #      convertuppercase(token);      {upshift all letters to uppercase} #       IF (ORD(mach_state) < ORD(NR_newbegin)) OR           (ORD(mach_state) > ORD(NR_new_Error)) THEN            Set_Error(er_fatal_55) {invalid state}         ELSE           CASE mach_state OF                NR_newbegin, NR_oldBegin : begin_state;     {BEGIN}    "            NR_newName, NR_oldName   : name_state;      {node name}  " !            NR_newIP                 : IPaddr_state;    {IP addr } !             NR_newIPid               : IPid_state;      {IP }   !            NR_newIEEE802id          : IEEE802id_state; {IEEE802 } !            { NR_newSAP               : SAP_state; }     {sap}   %            NR_newAddr               : Addr_state;      {IEEE802 address}  %             NR_newEnd                : End_state;       {END}   #            NR_new_Error             : Error_state;     {error state}  #          end;   "      IF error_code <> 0 THEN  {set error state if an error occured} "          mach_state := NR_new_Error;     END;   END; {Create_TF_Report}       $subtitle 'Err_Bad_NR',page$  %{------------------------------------------------------------------------} % %{                               Err_Bad_NR                               } % %{------------------------------------------------------------------------} % %{  Err_Bad_NR is called to print an error message when a corrupt Nodal   } % %{  Registry is signalled.                                                } %     PROCEDURE Err_Bad_NR;   BEGIN      Describe_error (output,er_nreg_corrupt,0);   
   err := er_nreg_corrupt; 
 	END; {Err_Bad_NR}  	         $subtitle 'Count_entries',page$       %{------------------------------------------------------------------------} % %{                                Count_entries                           } % %{------------------------------------------------------------------------} % %{  Count_entries counts the total number of entries in use by NR         } % %{  Warning:  this routine calls DS_EnterCritical, and remains            } % %{  "dispatch-locked" until the scan ends.  This is because no            } % %{  changes to the linked list can be permitted while it's being          } % %{  searched.  There is a protection against the list being cirular       } %     PROCEDURE Count_entries (VAR n_entries: Int16);   LABEL 99,999;   VAR      protect_loop_cnt  : Int16;       BEGIN   
   protect_loop_cnt := 0;  
 	   n_entries := 0; 	 #   { Start the loop by obtaining the listhead.  Note that this code is # &   { dependent upon there being a linked list of entries in Nodal Registry.} &    DS_EnterCritical(wkmap,err);   
   IF err <> 0 THEN  
       BEGIN         Bad_DSAM_State; {Terrible error!  Quit now!}        goto 999;         END;         DS_FetchElement (DS_TrackTD, TL_NODE_LIST, mbufid);         { Begin the counting loop.}     WHILE (mbufid <> NULL) AND (protect_loop_cnt < 32767) DO         BEGIN   $      { Fetch the InternalNDRecord stored in the referenced mbuf. Don't  $       { bother fetching the associated path report.         {}        protect_loop_cnt := protect_loop_cnt + 1;         n_entries := n_entries + 1;         mmflags.int := 0;         mmflags.bits[0] := TRUE;  "      DS_MRead (internalndrec.int, INTERNAL_NDREC_BSIZE, mbufid, 0,  "          mmflags, err);   !      IF (NOT ((err = SUCCESSFUL) OR (err = MMTOOFEWBYTES))) THEN  !          BEGIN           err := U_INTERNALERR;  	         GOTO 99;  	          END; {IF NOT}        mbufid := internalndrec.in_nxtptr   	      END; {WHILE} 	        err := SUCCESSFUL;       99:;     DS_LeaveCritical(wkmap);      IF protect_loop_cnt = 32767 THEN         BEGIN         writeln('NR linked list loop');   
      err := U_INTERNALERR 
       END;  999:  
END; {Count_entries} 
     $subtitle 'NR_Delete_Name',page$      %{------------------------------------------------------------------------} % %{                           NR_Delete_Name                               } % %{------------------------------------------------------------------------} % %{  NR_Delete_Name allows the user to delete a name from Nodal Registry   } %     
PROCEDURE NR_Delete_Name;  
 LABEL 999;  VAR      loopflag      : Boolean;   
   namelen       : Int16;  
 
   ierr          : Int16;  
 
   i,j           : Int16;  
    mmflags       : MMFlagsType;      Name_to_delete: EnvironStringType;      name_str      : String[60];      BEGIN {NR_Delete_Name}  
  loopflag := true;  
 
  IF interactive_mode THEN 
      prompt('Name to delete [(/E)]? ');         WHILE loopflag AND NOT eof(input) DO       BEGIN       readln(name_str);       namelen := strlen(name_str);        IF (namelen = 0) OR (name_str = '/E') OR           (name_str = '/e') THEN  
        loopflag := false  
      ELSE           BEGIN           FOR i := 1 to namelen DO  "           Name_to_delete.chars[i] := Conv_1_to_upper(name_str[i]);  "         DS_EnterCritical(wkmap, err);           IF err <> 0 THEN             BEGIN             Bad_DSAM_State; {Terrible error!  Quit now!}   
           GOTO 999; 
            END;           NRegFind (name_to_delete, namelen,                  mbufid, pathoffset, pathlen, ierr);           DS_LeaveCritical(wkmap);          IF ierr = successful THEN              BEGIN             IF mbufid = NULL THEN                writeln(name_str:namelen,' not found')             ELSE   
              BEGIN  
               DS_EnterCritical(wkmap, err);                 IF err <> 0 THEN                   Bad_DSAM_State; {Terrible error!  Quit now!}                     NRegPurge (name_to_delete, namelen, ierr);                DS_LeaveCritical(wkmap);                    IF ierr = successful THEN                    BEGIN                    writeln(name_str:strlen(name_str),' deleted');                     entries_used := entries_used + 1   
                 END 
 	              END  	            END          END;        IF interactive_mode THEN           prompt('Name to delete[(/E)]? ');        END; { while loopflag }          writeln;      IF entries_used > 1 THEN        writeln(entries_used:6,' entries were deleted.')      ELSE IF (entries_used = 1) THEN       writeln('1 entry was deleted')      ELSE        writeln('No entries were deleted');      999:  END; {NR_Delete_Name}       $Subtitle 'Check_Env',page$       ${----------------------------------------------------------------------} $ ${                               Check_Env                              } $ ${----------------------------------------------------------------------} $ ${  Check_Env checks the user environment.  The checks are :            } $ ${  1.  User must be Super-user.                                        } $ ${  2.  NSINIT must have been run previously, and DSAM must be set up   } $ ${      (state = ADSINIT).                                              } $ ${                                                                      } $ ${  All of the above conditions must be true for the routine to return  } $ ${  "true".  Otherwise, "false" is returned and an appropriate error    } $ ${  message is printed.                                                 } $ ${                                                                      } $ ${----------------------------------------------------------------------} $     FUNCTION Check_Env : Boolean;   VAR     Env_result : Boolean;       	BEGIN {Check_Env}  	        Env_result := false;   
   IF UserIsSuper = 0 THEN 
       BEGIN         Describe_error (output,er_not_superuser,0);         err := er_not_superuser;        END      ELSE         BEGIN         IF DS_StateOfDSAM <> ADSINIT THEN            BEGIN           { NSINIT hasn't been run or system is shutdown.}            Describe_error (output,er_DSAM_not_set,0);            err := er_DSAM_not_set;           END        ELSE           Env_result := true         END;  
   Check_Env := Env_result 
     END; {Check_Env}      $subtitle 'Compare_path',page$      %{------------------------------------------------------------------------} % %{                              Compare_path                              } % %{------------------------------------------------------------------------} %     PROCEDURE Compare_path           (environ_name : EnvironStringType;   
          namelen : Int16; 
           VAR mbufid : Int16;             VAR compare_flag : Boolean;             VAR ierr   : Int16);  LABEL 99;   VAR      i,j         : Int16;      TF_b         : byte;      internal_b   : byte;   BEGIN      compare_flag := true;         {Now try to find that name. }     DS_EnterCritical(wkmap, ierr);   
   IF ierr <> 0 THEN 
       BEGIN         Bad_DSAM_State; {Terrible error!  Quit now!}        goto 99;        END;      #   NRegFind(environ_name, namelen, mbufid, pathoffset, pathlen, err);  #    DS_LeaveCritical(wkmap);          IF err <> successful THEN        BEGIN         Describe_error(output,er_NRegFind,err);   
      err := er_NRegFind;  
       goto 99         END;     IF mbufid = NULL THEN        compare_flag := false      ELSE         {There is an entry by that name.  Fetch its record.}        BEGIN         mmflags.int := 0;         mmflags.bits[0] := TRUE;        DS_EnterCritical(wkmap,err);        IF err <> 0 THEN           BEGIN           Bad_DSAM_State; {Terrible error!  Quit now!}   	         goto 99;  	          END;       "      DS_MRead (internalndrec.int, INTERNAL_NDREC_BSIZE, mbufid, 0,  "          mmflags, err);         IF (((err = SUCCESSFUL) OR (err = MMTOOFEWBYTES))) THEN   !         DS_MRead (internalndrec.int, internalndrec.in_length +2,  !             mbufid, 0, mmflags, err);         DS_LeaveCritical(wkmap);  !      IF (NOT ((err = SUCCESSFUL) OR (err = MMTOOFEWBYTES))) THEN  !          BEGIN           err := U_INTERNALERR;  	         GOTO 99;  	          END; {IF NOT}            { Compare this entry to the one we formed from the ASCII        { Domain record.}         IF ((internalndrec.in_length) <> TF.nd_length) THEN            compare_flag := false;         j:=internalndrec.in_nameinfo.nlen;        IF odd(j) THEN {make sure pad byte is zero}            internalndrec.in_name.bytes[j+1] := 0;       $      i := 8; { skip over the offset parts; they'll differ by 2 anyway}  $       WHILE (compare_flag) AND (i < TF.nd_length) DO           IF internalndrec.bytes[i+2] <> TF.bytes[i] THEN              compare_flag := false            ELSE               i := i + 1;         END;  99:   
END; {Compare_path}  
     $subtitle 'NR_Compare',page       ${----------------------------------------------------------------------} $ ${                                NR_Compare                            } $ ${----------------------------------------------------------------------} $ PROCEDURE NR_Compare;   LABEL 99;   VAR      pathoffset   : Int16;     pathlen      : Int16;     ierr         : Int16;     namelen      : Int16;     i,j          : Int16;     env_name     : String[MAX_ENVIRON_NAMELEN];  BEGIN      namelen := TF.nd_nameinfo.nlen;     setstrlen(env_name,MAX_ENVIRON_NAMELEN);      FOR i := 1 to namelen DO         env_name[i] := TF.nd_name.chars[i];      FOR i := namelen+1 TO MAX_ENVIRON_NAMELEN DO   
      env_name[i] := ' ';  
 !   Compare_path(TF.nd_name, namelen, mbufid, compare_flag, ierr);  !    IF ierr <> successful THEN goto 99;         IF mbufid = NULL THEN        BEGIN {this entry does not exist in NR}         writeln(env_name,' not found in local Registry');         num_new_nodes := num_new_nodes+1        END      ELSE {There is an entry by that name.  Fetch its record.}        BEGIN          IF NOT compare_flag THEN {these entries are not identical}            BEGIN           writeln(env_name,' is different');            num_differences := num_differences + 1            END        END;  99:   	END; {NR_Compare}  	     $Subtitle 'Main program',page$      %{-----------------------------------------------------------------------}  % %{                             start of main program                     }  % %{-----------------------------------------------------------------------}  %     BEGIN {main}      &   IF NOT initscan THEN goto 999; {Initialize; check for initialize errors.} &     	   { Check mode }  	    IF mode_string = 'D' THEN  
      NR_Delete_Name 
    ELSE      BEGIN {Here for all modes except DELETE}   5:     endofdata := false;     REPEAT         scanner(token);         IF token[0] = chr(0) THEN            endofdata := true;             create_TF_report(token, endofdata, TFdone, err);      #      { Verify that "ip" appears in the path.  Note that we shouldn't  # %        flag the error if the user enters /e without entering any NPR's }  %           IF ((TFdone) AND (mach_state <> NR_newbegin) AND            (NOT ip_proto) AND  
          (err = 0)) THEN  
            err := er_no_ip;             IF err <> 0 THEN           BEGIN  '         IF column_number <> 0 THEN  { error not encountered at end of line }  ' 	            BEGIN  	             writeln('Line number ',line_number:5,                  ' column number',                 column_number:3,' error number ',err:3);               writeln(input_line);              FOR m_index := 1 TO input_line_len-1 DO   
               write(' '); 
             END            ELSE  { error encountered at end of line }   	            BEGIN  	 #            writeln('Line number ',(line_number-1):5,' column number', #                old_column:3,' error number ',err:3);              writeln(old_input_line);              FOR m_index := 1 TO old_input_line_len-1 DO   
               write(' '); 
             END;           writeln('^');           Describe_error(output,err,0);           IF NOT endofdata AND                interactive_mode THEN {we'll help the guy out here.}   	            BEGIN  	 %            { note that we need to skip to end-of-line only if we discover % $              the error before the scanner has read the eoln character.  $ #              Otherwise, the scanner would already have skipped to the #               start of the new line }               IF NOT endofline THEN   
               BEGIN 
                readln(input); {Skip end-of-line}                 line_number := line_number + 1;  
               END;  
 %            writeln('You may start over at BEGIN, or terminate with /E');  %             err := 0;   
            initTF;  
             input_line := '';               stack[0] := chr(0);               column_number := 0;               input_line_len := 0;              IF NOT endofline THEN                  prompt(terminal_out,PROMPT_STRING);  	            GOTO 5 	             END            ELSE   	            BEGIN  	             NR_Unlock(output,err);              GOTO 999;               END            END;             IF TFdone AND NOT endofdata AND            (mode_string <> 'V') THEN        IF mode_string = 'C' THEN   
         NR_Compare  
       ELSE           BEGIN            nr_options.bits[-1] := false; {1st time, no overwrite.}   10:            DS_EnterCritical(wkmap,err);   
         IF err <> 0 THEN  
 	            BEGIN  	             Bad_DSAM_State; {Terrible error!  Quit now!}              goto 999;               END;               NregAdd(TF, nr_options, err);           DS_LeaveCritical(wkmap);            IF err = U_DUPLICATE_NAME THEN               BEGIN{ duplicate name; is path identical?}               Compare_path(TF.nd_name, TF.nd_nameinfo.nlen,mbufid,                         compare_flag, err);               IF compare_flag THEN  "            {These entries are identical, so don't flag as an error} " 
               BEGIN 
                entries_used := entries_used - 1;                 err := successful  	               END 	             ELSE                 err := U_DUPLICATE_NAME              END;               IF err = successful THEN   	            BEGIN  	             {if we aren't replacing, then bump the counter.}              IF NOT nr_options.bits[-1] THEN                  entries_used := entries_used + 1               END            ELSE   	            BEGIN  	             IF err = U_DUPLICATE_NAME THEN                 BEGIN {Process duplicate name.}                 {For duplicates, we:   "               {1: consider the error a warning only, and even then, " #               {   only if the content of the local entry is different #                {   from the content of the ASCII path record.   '               {   If the content is identical, then the duplicate is ignored. ' !               {   Duplicates are not considered a serious enough  !                {   error to stop processing.  "               {2: Tell the user of the error and what the name is.  " !               {3: Check the mode_string.  If it's R(eplace), then ! $               {   we'll go replace the old entry with the new.  If it's $ %               {   ASK, then we'll ask if we should do this.  If neither,  %                {   then simply ignore the entry. }  %               err := successful; {we consider this a warning case only.}  %                write(                     'Warning: Duplicate name:');                 FOR m_index := 1 TO TF.nd_nameinfo.nlen DO                      write(TF.nd_name.chars[m_index]:1);                 writeln;                      { Now, decide what to do about the duplicate.}                  IF mode_string = 'R' THEN                    replace_ok := true  
               ELSE  
                   replace_ok := false;                     IF (mode_string = 'P') THEN                    BEGIN   !                  prompt(terminal_out,'OK to replace [Y/(N)]? ');  !                   readln(terminal_inp,cc_str);  !                  replace_ok := (cc_str = 'y') OR (cc_str = 'Y');  !                   END;      !               IF (replace_ok) AND (NOT nr_options.bits[-1]) THEN  !                   BEGIN   $                  writeln (terminal_out, 'Overwriting previous entry.'); $                   nr_options.bits[-1] := true;  !                  overwritten_entries := overwritten_entries + 1;  ! 
                  GOTO 10  
                   END   
               ELSE  
                   BEGIN   "                  writeln (terminal_out,'New entry being ignored.'); "                   END                  END  {if duplicate encountered}              ELSE IF err = U_NO_MEMORY THEN  
               BEGIN 
                Describe_error (output,er_no_nreg_space,0);                 writeln(   &                 '** Use NSINIT to allocate more space to Nodal Registry');  &                err := er_no_nreg_space;                  GOTO 999;  	               END 	             ELSE  
               BEGIN 
                Describe_error (output,er_NRegAdd,err);                 err := er_NRegAdd;                  GOTO 999;  	               END 	             END            END        UNTIL endofdata;     END; {Enter NR data}   99:;         IF overwritten_entries <> 0 THEN         BEGIN         writeln('WARNING:',overwritten_entries:6,            ' duplicate names were detected');          writeln('and their configuration information replaced.');          writeln(           'This information should be verified')         END;         IF mode_string = 'C' THEN        BEGIN         IF num_differences = 0 THEN            writeln('No differences were found')         ELSE IF (num_differences = 1) THEN           writeln('1 difference was found')        ELSE           writeln(num_differences:5,' differences were found');            IF num_new_nodes = 0 THEN            writeln('No new nodes encountered')        ELSE IF (num_new_nodes = 1) THEN           writeln('1 new node encountered')        ELSE           writeln(num_new_nodes:5,' new nodes encountered')        END          ELSE IF mode_string <> 'D' THEN        BEGIN         IF entries_used=0 THEN           writeln('No entries were added')         ELSE IF entries_used = 1 THEN            writeln('1 entry was added')         ELSE           writeln(entries_used:6,' entries were added');         END;         Count_entries(n_NR_Entries);      IF err = successful THEN         BEGIN         IF n_NR_Entries = 0 THEN           writeln('There are no entries in the Nodal Registry')        ELSE IF n_NR_Entries = 1 THEN            writeln('There is one entry in the Nodal Registry')        ELSE            writeln('There are ',n_NR_Entries:5,' entries in the ',              'Nodal Registry');         NR_Unlock(output,err)         END      ELSE   	      Err_Bad_NR;  	 999:     { Finally, return error code if any }  
   IF err <> 0 THEN  
       writeln(terminal_out,'NRERR: ',err:4);         FOR i := 2 to 5 DO         RetErr[i] := 0;   
   RetErr[1] := err; 
 	   prtn (RetErr);  	     END. {end of main program }  