 $PASCAL ',20,99 91790-16140 REV.4010 <860728.1432>'   $title 'Nodal Registry Display/Dump'$   
$STANDARD_LEVEL 'HP1000'$  
 $RECURSIVE off, RANGE off, HEAP 0 $   $DEBUG$   $CODE_CONSTANTS OFF,HEAP_DISPOSE OFF$           PROGRAM nrlist(input,output);   {------------------------------------------------------------        (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1985. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{      NAME: NRLIST  
 {    SOURCE: 91790-18140  {     RELOC: 91790-16140  {      PGMR: CLC  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  PCO  Prgmr  Description   {  7/16/85    CLC    Changed program name from nrdump to nrlist    #{  7/28/86    CLC    Disallow display of more than one path per domain # {   {------------------------------------------------------------   {}  $ PAGE $  { PROGRAM DESCRIPTION:      $  This is the NS1000 Nodal Registry Display and Dump program.  It allows $   users to see what is in the Nodal Registry.   {}      !{ -------------------------------------------------------------- } ! !{                         IMPORTS                                } ! !{ -------------------------------------------------------------- } !         IMPORT                $SEARCH 'phtm/BODEC.REL'     bodec,                 $SEARCH 'phtm/SODEC.REL'     sodec,                 $SEARCH 'phtm/MMDEC.REL'     mmdec,                 $SEARCH 'phtm/MMEXT.REL'     ds_mm,                 $SEARCH 'phtm/TRCMOD.REL'      trcmod,                $SEARCH 'phtm/SIGMOD.REL'      sigmod,                $SEARCH 'phtm/nrerr.rel'     nrerr,                 $SEARCH 'phtm/NR_ACCESS.REL'     nrlock;          $Subtitle 'Constants',page$   ${-------------------------------------------------------------------- }  $ ${                        GLOBAL CONSTANTS                             }  $ ${-------------------------------------------------------------------- }  $     CONST   
 MAX_CHARS_PER_LINE = 80;  
     $SUBTITLE 'Global Type declarations',page$      ${-------------------------------------------------------------------- }  $ ${                          TYPE DECLARATIONS                          }  $ ${-------------------------------------------------------------------- }  $     TYPE    bit    = 0..1;    {one bit}     nibble = 0..15;   {one nibble = 1/2 byte}         two_chars_type = packed array[1..2] of char;    String_26 = PACKED ARRAY [1..26] OF char;     String_80 = PACKED ARRAY [1..80] OF char;     String2   = PACKED ARRAY [1..2] OF char;      !  rev_string_type = PACKED ARRAY[1..14] OF char; {revision string} !       Split_Int16_type = RECORD   	     CASE Int16 OF 	      1: (bits: packed array[0..15] of bit);        2: (bytes: packed array[1..2] of byte);       3: (cchar: packed array[1..2] of char);       4: (nibs : packed array[1..4] of nibble);       5: (word: Int16);       END; {Split_Int16_type}        ErrorType = (run,ema,i_o,fmp,seg,warn);     Pas_file_name = Packed array[1..50] of char;    ReturnParamsType = ARRAY [1..5] OF Int16;       $SUBTITLE 'Global Constants',page$  #{--------------------------------------------------------------------} # #{                          GLOBAL CONSTANTS                          } # #{--------------------------------------------------------------------} #     CONST   %{ Define a <revcode> string constant which is automatically changed by the % #{ editor, whenever this module is changed.  The string must be in the  # ${ form shown below;  if any characters follow the trailing string quote, $ %{ the editor will not recognize it as a date code, and so will not update  % #{ it.  The purpose here is to have an automatic means for maintaining  # ${ the revision date, and identifying it for each run, without requiring  $ { anything of the programmer who makes any changes.}   { NB: DO NOT place any characters after the closing single-quote   { in the following line.  See comments above.}    this_rev_date = rev_string_type['<860728.1432>'   
                       ];  
     "{ Define the constant string which gives the major and minor version " { numbers.}   
  Version_string = '1.0';  
     ! { Define maximum allowable size for a name + path record to be.}  !  MAX_ND_SIZE = NDREC_BSIZE + MAX_PATHREP_BYTES - 1;       $SUBTITLE 'Global Variables',page$  ${---------------------------------------------------------------------}  $ ${                          GLOBAL VARIABLES                           }  $ ${---------------------------------------------------------------------}  $     VAR      wkmap            : Int16;     error            : Int16;     internalndrec    : InternalNDRecord;      whatisit         : Split_Int16_type;      word_bits        : Split_Int16_type;      two_chars        : two_chars_type;      tt               : Int16;     msg_str          : String[120];     cmnd_str         : String_80;     interactive_mode : Boolean;     error_ok         : Boolean;     Paserror         : Boolean;     ierr             : Int16;     RetErr           : ReturnParamsType;      i                : Int16;      $SUBTITLE 'External Functions&Procedures',page$   ${----------------------------------------------------------------------} $ ${                    EXTERNAL FUNCTIONS AND PROCEDURES                 } $ ${----------------------------------------------------------------------} $     	$fixed_string on$  	 $HEAPPARMS OFF$       	PROCEDURE get_time 	 
 $ALIAS 'Pas.TimeString'$  
   (VAR time_string: String_26);     EXTERNAL;   $  { get_time returns a date & time stamp, to be used to mark the time of $   { execution.}       #{--------------------------------------------------------------------} # #{                           PRTN                                     } # #{--------------------------------------------------------------------} #     PROCEDURE prtn (VAR return_params: ReturnParamsType);     EXTERNAL;     { return error code to caller }       #{--------------------------------------------------------------------} # #{                           IFBRK                                    } # #{--------------------------------------------------------------------} #     FUNCTION ifbrk $alias 'IFBRK'$           : Int16; EXTERNAL;   "  { This function checks RTE's "BR" flag, returning < 0 if the flag  "     was set, else 0 }       	$fixed_string off$ 	         	$fixed_string off$ 	 
PROCEDURE errorprint 
           $alias 'Pas.errorprinter'$            ( Err_type : ErrorType;               Err_Number: int16;              Err_line: int16;              Err_file: pas_file_name;              err_flen: int16);   
          EXTERNAL;  
     %{-----------------------------------------------------------------------}  % %{                            printerror                                 }  % %{-----------------------------------------------------------------------}  %     
PROCEDURE printerror 
           ( Err_type : ErrorType;               Err_Number: int16;              Err_line: int16;              Err_file: pas_file_name;              err_flen: int16);   BEGIN   
   errorprint ( Err_type,  
                 Err_number,   
                err_line,  
 
                err_file,  
                 err_flen );       END;      ${---------------------------------------------------------------------}  $ ${                             Trapproc                                }  $ ${---------------------------------------------------------------------}  $     	PROCEDURE Trapproc 	           $alias 'Pas.errorcatcher'$    { hp1000 }            ( Err_type : ErrorType;               Err_Number: int16;              Err_line: int16;              Err_file: pas_file_name;              err_flen: int16);       BEGIN   
   IF error_ok THEN  
       Paserror := true     ELSE         BEGIN   "      Printerror ( Err_type,Err_number,err_line,err_file,err_flen);  "        Halt(1) {No point in continuing execution after this....}          END;  END;          "{-----------------------------------------------------------------}  " "{                             RUNSTRING                           }  " "{-----------------------------------------------------------------}  " "{ Pick up run-time parameter as a string                          }  " "{-----------------------------------------------------------------}  "     FUNCTION RunString                  $ ALIAS 'PAS.PARAMETERS' $          (pnum: Int16;   
         VAR p: string_80; 
          max: Int16): Int16;    EXTERNAL;       "{-----------------------------------------------------------------}  " "{                          EXEC                                   }  " "{-----------------------------------------------------------------}  " "{  This is used to read in one character for pagination control   }  " "{-----------------------------------------------------------------}  "     "PROCEDURE exec (ecode, cntwd: Int16; VAR bufr:String2; bufln:Int16); "    EXTERNAL;      $HEAPPARMS ON, fixed_string off$      $SUBTITLE 'ListIt',PAGE$  !{---------------------------------------------------------------}  ! !{                            LISTIT                             }  ! !{---------------------------------------------------------------}  ! !{ ListIt is called to list or dump information from the NR      }  ! !{ tables.                                                       }  ! !{---------------------------------------------------------------}  !     PROCEDURE ListIt  $         (option_kind: Int16; {1 = just list to screen, 2= dump to file} $           VAR option_str: String;             VAR in_file: TEXT;            VAR out_file: TEXT);  	LABEL 5,10,99,999; 	 VAR   
   loopflag    : boolean;  
 
   format_ok   : boolean;  
 
   header_printed:boolean; 
    next_name_p : Int16;   
   path_rpt_indx  : Int16; 
    i,j         : Int16;      namelen     : Int16;      mbufid      : Int16;      pathoffset  : Int16;      report_len  : Int16;      domain_len  : Int16;      last_of_rpt : Int16;      pathlen     : Int16;      num_entries : Int16;      noderec     : NodeRecord;     env_name    : String[60];     my_node_name: String[MAX_CHARS_PER_LINE];     dump_file_name: String[MAX_CHARS_PER_LINE];     ftime_buf     : String_26;{date/time stamp }      dump_file     : TEXT;  
   line_number   : Int16;  
    page_control  : Boolean;      answer        : String[120];       $subtitle 'Set_error',page$       !{----------------------------------------------------------------} ! !{                          Set_error                             } ! !{                      (Local to ListIt)                         } ! !{----------------------------------------------------------------} ! !{  Sets error code if it has not already been set                } ! !{----------------------------------------------------------------} !     PROCEDURE Set_error (err : Int16);  BEGIN       
   IF ierr = 0 THEN  
 	      ierr := err; 	     	END; { Set_error } 	         $subtitle 'Bad_DSAM_State',page$      "{-----------------------------------------------------------------}  " "{                           BAD_DSAM_STATE                        }  " "{                          (Local to ListIt)                      }  " "{-----------------------------------------------------------------}  " "{  Bad_DSAM_State is called when the state of DSAM changes whilst }  " "{  NRCONF is running, i.e., NS is being shut down.                }  " "{-----------------------------------------------------------------}  "     
PROCEDURE Bad_DSAM_State;  
 BEGIN      Set_error(er_state_changed);      Describe_error(out_file,er_state_changed,0);   END; {Bad_DSAM_State}           $subtitle 'Pagination',PAGE$   {--------------------------------------------------------------}    {                          Pagination                          }    {--------------------------------------------------------------}    {  This procedure is called after each line is printed to the  }    {  screen in interactive mode to control the pagination.  The  }    {  page_control variable is initially set in ListIt to true,   }    {  and will remain true until the user enters <CR> in response }    {  to the 'more' question.  The user is also given the oppor-  }    {  tunity to abort the display if he so wishes                 }    {--------------------------------------------------------------}       PROCEDURE Pagination;   CONST        MAX_LINES_ON_SCREEN = 20;  VAR      readbuf : String2;      readlength : Int16;      BEGIN      line_number := line_number + 1;         IF interactive_mode AND page_control AND         (line_number >= MAX_LINES_ON_SCREEN) THEN         BEGIN         line_number := 0;             { first write a blank line }        writeln(out_file);        prompt(out_file,'More...(''a'' to abort)');         readlength := -1;         exec(1,octal('002101'),readbuf,readlength);             { delete the More... line and move cursor up two lines }        writeln(#27'M',#27'A',#27'A');            IF (ORD(readbuf[1])=13) THEN  !         page_control := false   { display everything else without !                                    pagination }         ELSE IF (readbuf[1]='a') OR (readbuf[1]='A') THEN   	         GOTO 99;  	           END;      END; { procedure Pagination }       $Subtitle 'Dump_string',page$   %{------------------------------------------------------------------------} % %{                               DUMP_STRING                              } % %{                            (Local to ListIt)                           } % %{------------------------------------------------------------------------} %     PROCEDURE Dump_string   
         (VAR out_f: text; 
           VAR msg_s: string);   BEGIN         IF strlen(msg_s) > 0 THEN     BEGIN   
    writeln(out_f, msg_s); 
     Pagination;       msg_s := ''     END       	END; {dump_string} 	 $subtitle 'Check_str_len',page  !{---------------------------------------------------------------}  ! !{                          Check_str_len                        }  ! !{                         (Local to ListIt)                     }  ! !{---------------------------------------------------------------}  !     PROCEDURE Check_str_len            (VAR disp_file: text;            VAR msg_str  : string;            start_ch : char);   BEGIN         IF strlen(msg_str) > 70 THEN      BEGIN       writeln(disp_file, msg_str);      Pagination;   
    setstrlen(msg_str, 1); 
 
    msg_str[1] := start_ch 
     END       END; { Check_str_len }      $SUBTITLE 'Conv_to_hex',page$   !{---------------------------------------------------------------}  ! !{                          CONV_TO_HEX                          }  ! !{                       (Local to ListIt)                       }  ! !{---------------------------------------------------------------}  ! !{  Conv_to_hex converts its 8-bit argument into two hex digits. }  ! !{---------------------------------------------------------------}  !     
FUNCTION Conv_to_hex 
         (byte_arg: byte) :two_chars_type;   VAR     x          : split_int16_type;      BEGIN       
  x.bytes[2] := byte_arg;  
       {Convert right-hand hex digit}    IF x.nibs[4] > 9 THEN       Conv_to_hex[2] := CHR(x.nibs[4] - 10 + ORD('A'))    ELSE      Conv_to_hex[2] := CHR(x.nibs[4] + ORD('0'));        {convert left-hand hex digit}     IF x.nibs[3] > 9 THEN       Conv_to_hex[1] := CHR(x.nibs[3] - 10 + ORD('A'))    ELSE      Conv_to_hex[1] := CHR(x.nibs[3] + ORD('0'));      	END; {Conv_to_hex} 	     $Subtitle 'Convert_to_BCD',page$  !{---------------------------------------------------------------}  ! !{                         CONVERT_TO_BCD                        }  ! !{                        (Local to ListIt)                      }  ! !{---------------------------------------------------------------}  ! !{ Convert_to_BCD takes an argument which is an 8-bit field      }  ! !{ consisting of two 4-bit BCD-coded digits, and returns the two }  ! !{ characters which are the ASCII representation of the BCD; e.g.}  ! !{ if bb = 0 then Convert_to_bcd returns '00'.  If either of the }  ! !{ two BCD digits are not in the range 0 .. 9 then '9' is return-}  ! !{ ed.                                                           }  ! !{---------------------------------------------------------------}  !     FUNCTION Convert_to_BCD           (bb : byte): Int16;   VAR     bx : Int16;     by : Split_Int16_type;    bcd: Split_int16_type;      BEGIN       
  by.bytes[2] := bb; 
   bx := by.nibs[4];{low 4 bits}   
  IF bx > 9 THEN bx := 9;  
 &  bcd.cchar[2] := CHR(bx + ORD('0'));  {Convert to char in range '0' .. '9'} &   bx := by.nibs[3]; {get high 4 bits}   
  IF bx > 9 THEN bx := 9;  
 #  bcd.cchar[1] := CHR(bx + ORD('0'));  {Convert to char in '0' .. '9'} #   Convert_to_BCD := bcd.word {return both characters}       END; {Convert_to_BCD}       $subtitle 'enterbyte',page$   !{---------------------------------------------------------------}  ! !{                           ENTERBYTE                           }  ! !{                          (Local to ListIt)                    }  ! !{---------------------------------------------------------------}  !     
PROCEDURE Enterbyte  
          (index: Int16;             value: byte);   BEGIN     internalndrec.bytes[index] := value   END; {enterbyte}      $SUBTITLE 'NextNodeName',page$  !{---------------------------------------------------------------}  ! !{                        NEXTNODENAME                           }  ! !{                      (Local to ListIt)                        }  ! !{---------------------------------------------------------------}  ! !{                                                               }  ! !{ NextNodeName is called to copy NR table information for the   }  ! !{ next entry into a local data structure (InternalNDREC).       }  ! !{                                                               }  ! !{---------------------------------------------------------------}  !     FUNCTION NextNodeName                    (VAR next_name_ptr : Int16;                        VAR namelen   : Int16;                        VAR mbufid    : Int16;                        VAR pathoffset: Int16;                        VAR pathlen   : Int16;                        VAR ierr      : Int16) : boolean;       {}  { Abstract:   {  The NReg database contains entries which bind environment  {  names to nodal path reports.   {  These database entries are keyed by environment names.   ${  NextNodeName () is called repeatedly to obtain the next node name and $ &{  its path-report (as offset).  The routine returns "false" only when there & {  are no more entries in the nodal registry.   {   
{ Input parameters:  
 {   #{  next_name_ptr: actually, both an input and an output parameter.  To # &{                 initialize the routine, set this to zero before the first  & &{                 call.  Thereafter, leave the parameter alone (NextNodeName & {                 leaves it as the pointer to the next entry).  {   
{ Output parameters: 
 {   {  next_name_ptr: (see above)   {   &{  NextNodeName:  function value, returns "true" if the following parameters & #{                 return the next node name;  "false" if the list was  # {                 exhausted when NextNodeName was last called.  {    {  namelen: The length, in characters, of the environment name.    {   !{  mbufid: Returns the mbufid of the mbuf containing the NDRecord  ! {          for the node whose name is returned.   {   {  pathoffset: The offset, in bytes, from the beginning of the  !{     mbuf containing the NDRecord, at which the nodal path report ! 
{     for the node begins. 
 {    {  pathlen: The length of path report contained in the NDRecord.   {   "{  ierr: Returns either a value of SUCCESSFUL or else an indication  " {     that an internal system error occurred.   {}      LABEL 99;       VAR      found            : BOOLEAN;     i,j              : Int16;     mmflags          : MMFlagsType;      BEGIN        { Compute a hash value for the string & retrieve the pointer to    { the head of the equivalence class where we're likely to find  
{ the entry we seek. 
 {   { TESTBED: We don't have a true hash table yet.   {}  
IF next_name_ptr = 0 THEN  
    BEGIN     DS_EnterCritical(wkmap, error);     IF error <> 0 THEN         BEGIN         Bad_DSAM_State; {Terrible error!  Quit now!}        GOTO 99;        END;     DS_FetchElement (DS_TrackTD, TL_NODE_LIST, mbufid);     DS_LeaveCritical(wkmap);   
   next_name_ptr := mbufid 
    END  ELSE     mbufid := next_name_ptr;       found := FALSE;       IF (mbufid <> NULL) THEN     BEGIN  "   { Fetch the InternalNDRecord stored in the referenced mbuf. Don't "    { bother fetching the associated path report.     {}      NextNodeName := true;  
   mmflags.int := 0; 
    mmflags.bits[0] := TRUE;          DS_EnterCritical(wkmap, error);         IF error <> 0 THEN         BEGIN         Bad_DSAM_State; {Terrible error!  Quit now!}        GOTO 99;        END;          DS_MRead (internalndrec.int, INTERNAL_NDREC_BSIZE, mbufid, 0,                  mmflags, ierr);         IF ((ierr = SUCCESSFUL) OR  (ierr = MMTOOFEWBYTES)) THEN           DS_MRead (internalndrec.int, internalndrec.in_length +2,                     mbufid, 0, mmflags, ierr);          DS_LeaveCritical(wkmap);           IF (NOT ((ierr = SUCCESSFUL) OR (ierr = MMTOOFEWBYTES))) THEN         BEGIN         ierr := U_INTERNALERR;        GOTO 99   
      END; {IF NOT}  
        {Set name length, set pathoffset and path length}     namelen := internalndrec.in_nameinfo.nlen;   #   pathoffset := internalndrec.in_path_offset + INTERNAL_NDREC_BSIZE - #                  NDREC_BSIZE;      pathlen := internalndrec.in_end_offset -                    internalndrec.in_path_offset;         {establish "next" pntr for next call}     next_name_ptr := internalndrec.in_nxtptr      END  {IF mbufid <> NULL}   ELSE {no more entries}  
   NextNodeName := false;  
     
ierr := SUCCESSFUL;  
     99:;  
END; {NextNodeName}  
         $SUBTITLE 'Obtain_file_name',PAGE$  !{---------------------------------------------------------------}  ! !{                          OBTAIN_FILE_NAME                     }  ! !{                          (Local to ListIt)                    }  ! !{---------------------------------------------------------------}  ! !{ Obtain_file_name is called to obtain the desired file name    }  ! !{ from a command, e.g., XX,<filename>                           }  ! !{---------------------------------------------------------------}  !     
PROCEDURE Obtain_File_Name 
          (VAR option_str: string;             VAR file_name: string);       VAR   
  loopflag: boolean; 
   cc: char;     i,j,k: Int16;   	  opt_len: Int16;  	     BEGIN         opt_len := strlen(option_str);    { Scan option string for file name to use}    i := 2;   
  loopflag := true;  
       WHILE (loopflag) AND (i < opt_len) DO        BEGIN {scan for first blank or comma.}   
     cc := option_str[i];  
      IF (cc = ' ') OR (cc = ',') THEN   
        loopflag := false  
      ELSE   	        i := i + 1 	      END;         { Now, scan for first non-blank character.}     i := i + 1;   
  loopflag := true;  
   WHILE  (loopflag) AND (i <= opt_len) DO        IF option_str[i] <> ' ' THEN   
        loopflag := false  
      ELSE   
        i := i + 1;  
     !  { If the scan went off the end of the string, then there was no  ! !  { file name given, and we should select the default.  Otherwise, !   { copy the name bytes to file_name}     IF i > opt_len THEN        BEGIN       file_name := '1';       { output is to the terminal, so we are interactive }        interactive_mode := true;       END    ELSE       BEGIN       loopflag := true;  
     k := opt_len - i + 1; 
      j := 1;       WHILE (loopflag) AND (j <= k) DO   $        BEGIN {Copy all legal file name characters to file_name string.} $         cc := option_str[i];  !        IF NOT (cc IN [ 'A' .. 'Z','a' .. 'z', '0' .. '9','.','/', !            '_','$','%']) THEN   %           loopflag := false {first illegal filename char stops the copy.} %         ELSE             BEGIN             setstrlen(file_name,j);             file_name[j] := option_str[i];              j := j + 1;             i := i + 1              END          END        END;   $   { Now, if output file is '1' or not specified, we are in interactive  $ !     mode.  Otherwise, we direct all output to a file. We need to  ! %     distinguish this for pagination control - we don't want to issue the  %      'more' prompt if output is to a file }      interactive_mode := file_name = '1';           END; {Procedure Obtain_File_name}       $subtitle 'Fmt_VNA_Fld',page$   {-------------------------------------------------------}   {                      FMT_VNA_FLD                      }   {                   (Local to ListIt)                   }   {-------------------------------------------------------}   { Fmt_VNA_Fld formats a field from the Virtual Network  }   { Address, and adds it to the print-line string.  Each  }   { field is three digits, with leading zeros if neces-   }   { ary.                                                  }   {-------------------------------------------------------}       PROCEDURE Fmt_VNA_Fld            (VAR str: string; {input and output string}            field:   Int16);  {value to be formatted}   VAR     p,t: Int16;     field_str: String[20];      BEGIN       
  setstrlen(field_str,0);  
   p := 1;     strwrite(field_str,p, t,field); {convert to ASCII}    field_str := strltrim(field_str); {strip leading blanks}  
  t := strlen(field_str);  
       WHILE t < 3 DO       BEGIN       strinsert('0',field_str, 1);        t := t + 1        END;         str := str + field_str      	END; {Fmt_VNA_Fld} 	     $subtitle 'Print_Path_Rpt',page$      {-------------------------------------------------------}   {                    PRINT_PATH_RPT                     }   {                   (Local to ListIt)                   }   {-------------------------------------------------------}   {   Print_Path_Rpt prints the path report information.  }   {-------------------------------------------------------}       PROCEDURE Print_Path_Rpt  !         (option_k: Int16;  {option kind; controls output format}  !           VAR dump_file: TEXT;            VAR env_name : String;            VAR start_path: Int16;            VAR format_ok : boolean);   LABEL 99;   VAR      aa,     bb,     dd          : byte;     cc          : char;     finish,  
   ipprinted   : BOOLEAN;  
    n_c_in_line : Int16;      path_len    : Int16;      pid         : Int16;      elem_len    : Int16;      t           : Int16;      jj          : Int16;      kk          : Int16;      jb          : Int16;      last_of_path: Int16;      last_of_domain:Int16;     out_str     : String[MAX_CHARS_PER_LINE];     x_str       : string[20];      BEGIN {Print_Path_Rpt}         { Determine domain length.}     whatisit.bytes[1] := internalNDRec.bytes[start_path];     whatisit.bytes[2] := internalNDRec.bytes[start_path+ 1];      last_of_domain := start_path + whatisit.word;      start_path := start_path + 2; {skip over domain length part}           { get version and domain part of Virtual Network Address}     bb := internalNDRec.bytes[start_path]; {version}      dd := internalNDRec.bytes[start_path + 1]; {domain}      start_path := start_path + 2; {skip over version/domain part}          Dump_string(dump_file, msg_str);          msg_str := 'BEGIN ' + env_name + ' ';      $   { Format the Virtual Network Address, as four fields of three digits  $ %   { each.  The field must contain characters in range 0 .. 9, so leading  %    { zeros must be inserted.}      FOR t := 0 TO 3 DO         BEGIN         Fmt_VNA_Fld(msg_str,internalNDRec.bytes[start_path]);         start_path := start_path + 1;   
      IF t <> 3 THEN 
          msg_str := msg_str + '.'         END;         msg_str := msg_str + ' ';      !   IF (option_k = 1) OR (option_k = 3) THEN {DUMP out VNA address} !       BEGIN { Show the version and domain code for the VNA}         msg_str := msg_str + ' * Version ';         tt := strlen(msg_str);        strwrite(msg_str,tt, kk, bb:3);         msg_str := msg_str + ' Domain ';        tt := strlen(msg_str);  
      IF dd = 1 THEN 
          msg_str := msg_str + 'HPDSN'         ELSE           strwrite(msg_str,tt, kk, dd:3);            Dump_string(dump_file, msg_str)         END;         IF (bb <> 0) OR (dd <> 1) THEN         BEGIN         Dump_string(dump_file, msg_str);        Set_error (er_version_unknown);         Describe_error (dump_file,er_version_unknown,0);  
      format_ok := false;  
       GOTO 99         END;         { Now, "crack" the path elements.}       !   t := start_path;           { start out the scan w/ t as index}  !    ipprinted := false;        { no IP sap encountered yet }   %   finish    := false;        { set to TRUE if second IP sap encountered } %        WHILE (t < last_of_domain) AND NOT finish DO         BEGIN         Check_str_len(dump_file, msg_str, ' ');             whatisit.bytes[1] := internalNDRec.bytes[t];        whatisit.bytes[2] := internalNDRec.bytes[t+1];        last_of_path := whatisit.word + t;        t := t + 2; {skip over path length}             WHILE (t < last_of_path) AND NOT finish DO           BEGIN            pid      := internalNDRec.bytes[t];   {get Protocol ID}   "         elem_len := internalNDRec.bytes[t+1]; {get element length}  "     
         CASE pid OF 
     {           255:   {Group services PID for AdvanceNet}  {              IF (option_k = 1) OR (option_k = 3) THEN   {                 BEGIN {we're listing; print lotsa stuff}  {                 {1st half of service map}   !{                 word_bits.bytes[1] := internalNDRec.bytes[t+2] ; ! {                 {2nd half of service map}   !{                 word_bits.bytes[2] := internalNDRec.bytes[t+3] ; ! {                 Dump_string(dump_file, msg_str);  {                 msg_str := '* Services supported:';   {                 IF word_bits.word = 0 THEN  {                    msg_str := msg_str + ' (none)'   {                 ELSE  {                 IF word_bits.word = -1 THEN   {                    msg_str := msg_str + ' (all)'  {                 ELSE  
{                    BEGIN 
 {                    Dump_string(dump_file, msg_str);   {                    msg_str := '*';  #{                    FOR jj := 0 TO 15 DO {interpret service map bits} # {                       BEGIN   ${                       { convert jb to MPE bit-numbering; jj=0==>jb=15} $ {                       jb := 15 - jj;  {                       IF word_bits.bits[jb] = 1 THEN  {                          BEGIN  {                          CASE jb OF   %{                             0: x_str := ' NFT'; {Network File Transfer}  % &{                             1: x_str := ' VTS'; {Virtual Terminal Service} & '{                             2: x_str := ' IPC';{Network Interprocess Comm.}  ' &{                             3: x_str := ' RPM';{Remote Program Management} & {                             4: x_str := ' MONAD';   {                             5: x_str := ' RFA/3000';  {                             6: x_str := ' RDBA/3000';   {                             OTHERWISE   {                                x_str := '';   {                          END; {CASE on bit-map}   {                       msg_str := msg_str + x_str  {                       END;  {   {                    Check_str_len(dump_file, msg_str, '*');  
{                    END;  
 {   {                 IF strlen(msg_str) > 1 THEN   {                    Dump_string(dump_file, msg_str)  {                 END   {              END; {Group services PID}  {   {           254:   {Group Transports PID for AdvanceNet}  {               IF (option_k = 1) OR (option_k = 3) THEN  {                  BEGIN {we're listing; print lotsa stuff}   {                  {1st half of service map}  "{                  word_bits.bytes[1] := internalNDRec.bytes[t+2] ;  " {                  {2nd half of service map}  "{                  word_bits.bytes[2] := internalNDRec.bytes[t+3] ;  " {   {                  Dump_string(dump_file, msg_str);   {                  msg_str := '* Transports supported:';  {   {                  IF word_bits.word = 0 THEN   {                     msg_str := msg_str + ' (none)'  {                  ELSE   {                  IF word_bits.word = -1 THEN  {                     msg_str := msg_str + ' (all)'   {                  ELSE   {                     BEGIN   %{                     FOR jj := 0 TO 15 DO {interpret transports map bits} % {                        BEGIN  ${                        jb := 15 - jj;{convert to MPE's bit-numbering}  $ {                        IF word_bits.bits[jb] = 1 THEN   {                           BEGIN   {                           CASE jb OF  ${                              0: x_str := ' TCP cksm'; {TCP, checksum } $  {                              1: x_str := ' TCP'; {regular TCP}   #{                              2: x_str := ' HPPXP'; {HP PXP protocol} # {                              3: x_str := ' MAPLE';  {                              4: x_str := ' UDP';  {                              OTHERWISE  {                                 x_str := '';  {                              END; {CASE on bit-map}   {   {                           msg_str := msg_str + x_str;   {                           END;  {    {                        Check_str_len(dump_file, msg_str, '*')    {                        END  
{                     END; 
 {   {             IF strlen(msg_str) > 1 THEN   {                Dump_string(dump_file,msg_str)   {             END; {Group Transports PID for AdvanceNet}                 7:     {IEEE802}   
              BEGIN  
               msg_str := msg_str + ' IEEE802 ';   #              { Convert LAN address to hex, separated by dashes (-) }  #               FOR jj := t+4 TO t+9 DO                    BEGIN                   x_str := '';                    strwrite (   %                    x_str, 1,kk, Conv_to_hex( internalNDRec.bytes[jj]):2); %                  msg_str := msg_str + x_str;                   IF jj < t+9 THEN                       msg_str := msg_str + '-'  
                 END 
               END; {IEEE802}                 8:     {DARPA Internet Protocol}   
              BEGIN  
               IF NOT ipprinted THEN                    BEGIN  $                 { first time IP sap encountered. Set a flag to remember $ $                   this because our Nodal Registry syntax currently does $ $                   not permit us to specify more than one path report }  $                  msg_str := msg_str + ' IP ';                    ipprinted := TRUE;   
                 END 
 	              ELSE 	                  BEGIN  #                 { we have already encountered one IP sap. Our NRINIT  # $                   input syntax does not permit us to specify more than  $ #                   one path within a single domain, so stop here, and  #                    advance to the end of the domain }                    finish := TRUE;                   t := last_of_domain;                    END; { if not ipprinted }  	              END; 	     {          2:   {X25}   
{             BEGIN  
 {             msg_str := msg_str + ' X.25 ';  {             {Get the X.25 address}  {             FOR jj := t+3 TO t + elem_len + 2 DO  {                BEGIN  {                bb := internalNDRec.bytes[jj];   {                whatisit.word := Convert_to_BCD(bb);   {                tt:= strlen(msg_str);  {                strwrite (   &{                   msg_str,tt, kk, whatisit.cchar[1]:1,whatisit.cchar[2]:1) & {                END;   {             END; {X25}                 OTHERWISE {some protocol ID we're not coded for}                 ;   
        END; {Case on PID} 
          IF NOT finish THEN   #        { if the finish flag is not set, this implies that we haven't  # $          encountered a second IP sap (some systems such as HP9000 allow $ &          more than one path report per domain, but we have to ignore that). & &          Simply proceed as usual. On the other hand, if the finish flag is  & %          set, this implies that we would have advanced to the end of the  %           domain report, so don't proceed any further }           t := t + elem_len + 2        ELSE           { need to get to the start of next domain }   
        t := t + 2;  
      Check_str_len(dump_file, msg_str, ' ')   
     END  { while in path} 
     
  END ; { while in domain} 
     
  format_ok := true; 
 99:   	  start_path := t  	     END; {Print_Path_Rpt}       $SUBTITLE 'ListIt',PAGE$  !{---------------------------------------------------------------}  ! !{                       start of LISTIT                         }  ! !{---------------------------------------------------------------}  !     BEGIN          NR_LOCK(out_file, error);         IF error <> 0 THEN         BEGIN         Set_error(er_lock_failed);        Describe_error(out_file,er_lock_failed,0);        GOTO 999;         END;      
   { Initialize variables} 
    page_control := true;  { for pagination }  
   loopflag := true; 
 
   next_name_p := 0; 
    header_printed := false;   
   num_entries := 0; 
    Obtain_File_Name(option_str, dump_file_name);  5:     IF dump_file_name = '1' THEN    { terminal i/o }         rewrite(dump_file, dump_file_name)     ELSE         BEGIN   "      { output is to a file.  First try a 'reset' to see if the file "         exists }        Paserror := false;  #      error_ok := true;  { used in Pascal error catcher routine to set # $                           Paserror if there is something wrong with the $                            reset }        reset(dump_file,dump_file_name);        error_ok := false;        IF Paserror THEN           BEGIN           { file does not exist. See if we can create it }            rewrite(dump_file,dump_file_name);            END        ELSE           BEGIN  $         { file already exists.  Ask user whether he wishes to overwrite $            the existing file }           Prompt (out_file,dump_file_name,   "            ' already exists. [(R)=replace / E=Exit / N=newfile]?'); " 10:            readln (in_file,answer);            answer := strltrim (answer);            IF strlen(answer) = 0 THEN   
            answer := 'R'  
          ELSE   	            BEGIN  	             { convert to uppercase }              IF (answer[1] IN ['a' .. 'z']) THEN   #               answer[1] := CHR(ORD(answer[1]) - ORD('a') + ORD('A')); #             END;               IF (answer[1] = 'N') THEN  	            BEGIN  	              { User wishes to specify a new file name. Reprompt }               Prompt (out_file,'Enter file name : ');               readln(in_file,dump_file_name);   
            GOTO 5;  
             END            ELSE IF (answer[1] = 'E') THEN   	            BEGIN  	             { Exit option chosen }              writeln (out_file,'Program terminating');               Halt (1);               END            ELSE IF (answer[1] <> 'R') THEN  	            BEGIN  	 &            prompt (out_file, 'Invalid answer, please retry. [(R)/E/N]? ');  & 
            GOTO 10; 
             END            ELSE   	            BEGIN  	             { user wishes to replace the file }               rewrite (dump_file,dump_file_name);               END;           END;  { replace file }         END; { file i/o }       %   get_time(ftime_buf);           {ftime_buf <== date time stamp string.}  %    DS_EnterCritical(wkmap, error);         IF error <> 0 THEN         BEGIN         Bad_DSAM_State; {Terrible error!  Quit now!}        GOTO 99;        END;      $   DS_FetchElement(DS_NodesTD, 1, noderec.int); {get our own node name}  $    DS_LeaveCritical(wkmap);       	   WITH noderec DO 	       BEGIN         Setstrlen(my_node_name, nr_nodenamelen);        FOR i := 1 to nr_nodenamelen DO            my_node_name[i] := nr_nodename.chars[i]        END;      %   { Place some info in the file so people will know what it is, what's in %    { it, when and where it was created, etc.}   "   writeln(dump_file,'*',this_rev_date); {Take out of final version} "    writeln(dump_file,         '* Nodal Registry Dump File,',        ' Version ', Version_string);      writeln(dump_file,  '* File created: ',ftime_buf:26);     writeln(dump_file,'* At node ',my_node_name);  
   line_number := 4; 
     
   loopflag := true; 
 '   { Call "NextNodeName" until no more entries exist.  Print node name & etc.  ' 
   { for each one found. } 
    WHILE (loopflag) AND         NextNodeName (next_name_p, namelen, mbufid,                       pathoffset, report_len,ierr)  DO       BEGIN       IF ierr <> SUCCESSFUL THEN   !        BEGIN  {Internal error flagged.  This is a serious error!} !         loopflag := false; {Take us out of this loop!}          Set_error(er_int_dsam);           Describe_error(out_file,er_int_dsam,0);           END        ELSE           WITH internalNDRec DO              BEGIN             last_of_rpt := internalNDRec.in_end_offset;             IF internalNDRec.in_length > (MAX_ND_SIZE) THEN  
              BEGIN  
               Set_error(er_entry_559);                Describe_error(dump_file,er_entry_559,0);                 format_ok := false;                 GOTO 99   	              END; 	                num_entries := num_entries + 1;  #           { size of data being used is in_length + 2.  Need to round  # $           { up to mbuf boundary.  MMMLEN is # bytes available per mbuf} $            namelen := in_nameinfo.nlen;                  IF namelen > MAX_ENVIRON_NAMELEN THEN  
              BEGIN  
               Set_error(er_env_50);                 Describe_error(dump_file,er_env_50,0);                format_ok := false;                 GOTO 99   	              END; 	                path_rpt_indx := in_name_offset + 4;              setstrlen(env_name,namelen);                  FOR j := 1 TO namelen DO {get the node name.}  
              BEGIN  
 #              env_name[j] := CHR(internalNDRec.bytes[path_rpt_indx]);  #               path_rpt_indx := path_rpt_indx + 1  &              END; {at loop termination, path_rpt_indx is either at start of &     "           { path report, or the pad byte, if length of name is odd. " #           { The "standard" for these entries is to provide a pad byte #             { if the name contains an odd number of characters.}               IF odd(namelen) THEN   &              path_rpt_indx := path_rpt_indx+1; {skip the pad byte, if any}  &                { Now, interpret the report. }   &           path_rpt_indx := path_rpt_indx + 2; {skip over report len field}  &            format_ok := true;       !           WHILE (format_ok) AND (path_rpt_indx < last_of_rpt) DO  ! 
              BEGIN  
               Print_Path_Rpt(option_kind, dump_file, env_name,                path_rpt_indx, format_ok);                IF ifbrk < 0 THEN { break flag detected }                    page_control := true;  	              END; 	                writeln(dump_file,msg_str,' END');              Pagination;  
           msg_str := '';  
               IF option_kind = 3 THEN                BEGIN {print raw path data, in decimal}  %             write(dump_file,'* Raw internal record: (in decimal bytes)'); % #             FOR path_rpt_indx := 0 TO internalNDRec.in_length + 1 DO  #                 BEGIN                   IF (path_rpt_indx MOD 10) = 0 THEN                     BEGIN                     writeln(dump_file);                     Pagination;                     write(dump_file,'*',path_rpt_indx:4, ':')                     END;   #                write(dump_file,internalNDRec.bytes[path_rpt_indx]:4)  # 
                END; 
              writeln(dump_file);               Pagination;  	             END;  	     &          { Did NextNodeName() return last table entry in the previous call? & "          { If so then clear the loopflag.  Otherwise, the next call " !          { would re-initialize, and start the search over again.} !           IF next_name_p = NULL THEN               loopflag := false            END              END; {call-loop for NextNodeName}          IF num_entries = 0 THEN          {There were no entries in the Nodal Registry Table.}           writeln(dump_file,'*Nodal Registry contains no entries.')       ELSE IF num_entries = 1 THEN          writeln(dump_file,'*Nodal Registry contains one entry.')        ELSE  "       writeln(dump_file,'*Nodal Registry contains ',num_entries:6,  "           ' entries.');       99:      close(dump_file,'SAVE');   999:     NR_Unlock(out_file, error)       END; {ListIt}       $SUBTITLE 'NregDProc',PAGE$   %{-----------------------------------------------------------------------}  % %{                                 NregDProc                             }  % %{-----------------------------------------------------------------------}  %     
PROCEDURE NregDProc  
          (VAR in_file: TEXT;            VAR out_file: TEXT);  LABEL 99;   VAR      cc               : char;      Command_Mode     : boolean;     i                : Int16;     n_param          : Int16;     st_len           : Int16;     opt_2            : String[2];     option_str       : String[120];      $SUBTITLE 'Print_Help',page$  !{---------------------------------------------------------------}  ! !{                        PRINT_HELP                             }  ! !{                     (Local to NRegDProc)                      }  ! !{---------------------------------------------------------------}  ! !{ Print_Help is called to print a "help" menu.                  }  ! !{---------------------------------------------------------------}  !     
PROCEDURE Print_Help 
          (VAR out_file:  text);       BEGIN       #   writeln(out_file,'Please select one of the following functions:');  # "   writeln(out_file,'D[,<filename>] = Dump Nodal Registry to file'); " #{  writeln(out_file,'L[,<filename>] = List Nodal Registry to file'); } #    writeln(out_file,'R[,<filename>] = D + raw table info');      writeln(out_file,'?              = Print Help Menu');     writeln(out_file);      writeln(out_file,'Enter /E to exit')       	END; {Print_help}  	     !{---------------------------------------------------------------}  ! !{                    start of NRegDProc                         }  ! !{---------------------------------------------------------------}  !         BEGIN {Nodal Registry Display/Dump procedure}          { Verify that DSAM has been set up previously. }      IF DS_StateOFDSam <> ADSINIT THEN        BEGIN         Describe_error(output,er_DSAM_not_set,0);         GOTO 99         END;      %   Command_Mode := true;{This guy remains "true" until user exits NR mode} %     $   { See if there is a third parameter in run-string.  If there is, then $ $   { we'll execute it as a command, and terminate.  In that case, we'll  $ #   { copy the rest of the run string to the command line (option_str). # #   { Otherwise, we'll go interactive, reading commands from the user's # "   { terminal, executing them, until the /E or EX command is given.} "     
   option_str := ''; 
    tt := RunString(3,cmnd_str,MAX_CHARS_PER_LINE);  	   IF tt > 0 THEN  	 #      BEGIN {There are more than two parameters.  We're "batch mode"}  #       interactive_mode := false;  
      n_param := 3;  
       WHILE tt > 0 DO   !         BEGIN {Pack the rest of the run-string into "option_str"} !          st_len := strlen(option_str);           tt := tt + 1;           cmnd_str[tt] := ',';            FOR i := 1 to tt DO              IF st_len < (MAX_CHARS_PER_LINE-1) THEN   
               BEGIN 
                st_len := st_len + 1;                 setstrlen(option_str, st_len);                  option_str[st_len] := cmnd_str[i]  
               END;  
          n_param := n_param + 1;            tt := RunString(n_param, cmnd_str, MAX_CHARS_PER_LINE);            IF tt < 0 THEN   
            tt := 0; 
          setstrlen(msg_str, tt)            END        END      ELSE         BEGIN         interactive_mode := true;   !      Print_help(out_file)   {Print help for the user, one time.}  !       END;          WHILE Command_Mode DO {Remain in this loop until user exits}          BEGIN         IF interactive_mode THEN           BEGIN            prompt(out_file,'NRLIST> '); { Ask for user's command.}   '         readln(in_file,option_str); { read the command, as full 80-char str}  '          END        ELSE  $         Command_mode := false;      {one-time execution of loop if not  $                                       interactive }         IF strlen(option_str) > 0 THEN           BEGIN  !         { The user entered some input rather than an empty line.  !            Process the input (else reprompt) }  !         { IF (option_str[1] = 'L') OR (option_str[1] = 'l') THEN  ! 	            BEGIN  	             listit(1,option_str,in_file,out_file);              command_mode := false;              END   #         ELSE } IF (option_str[1] = 'D') OR (option_str[1] = 'd') THEN # 	            BEGIN  	             listit(2,option_str,in_file,out_file);              command_mode := false;              END   "         ELSE IF (option_str[1] = 'R') OR (option_str[1] = 'r') THEN " 	            BEGIN  	             listit(3,option_str,in_file,out_file);              command_mode := false;              END            ELSE IF option_str[1] = '?' THEN               Print_Help(out_file)           ELSE   	            BEGIN  	             IF (strlen(option_str) < 2) THEN  %               writeln(out_file,'That is not one of the available modes')  %             ELSE  
               BEGIN 
                IF (option_str[1]='/') AND ((option_str[2]='E')                    OR (option_str[2] = 'e')) THEN                    command_mode := false   
               ELSE  
 &                  writeln(out_file,'That is not one of the available modes') & 	               END 	             END            END        END;{WHILE in command loop}   99:   END; {Nodal Registry Display/Dump Procedure}      $subtitle 'Main program - code',page$   {------------------------------------------------------------}  {                      MAIN PROGRAM                          }  {------------------------------------------------------------}      
BEGIN {Main program} 
        reset(input);  
   rewrite(output);  
    writeln('** Nodal Registry Display Program **');      writeln('Enter ? for help');      writeln;   "   NregDProc(input, output); {call the NReg Display/Dump Procedure}  "        { Finally, return error code if any }  
   IF ierr <> 0 THEN 
       writeln('NRERR: ',ierr:4);         FOR i := 2 TO 5 DO         RetErr[i] := 0;      RetErr[1] := ierr;   	   prtn (RetErr);  	     END. {NRLIST program}  