 $PASCAL ',20,29 91790-16168 REV.4010 <851204.1655>'   $ STANDARD_LEVEL 'HP1000' $   $ DEBUG $   $ RECURSIVE OFF, RANGE OFF$   $ HEAP 2 $  
$ HEAP_DISPOSE OFF $ 
         PROGRAM NSTRC;      %{------------------------------------------------------------------------  %     "   (C) COPYRIGHT HEWLETT_PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : NSTRC   {      SOURCE : 91790-18168   {       RELOC : 91790-16168   
{        PGMR : ASH  
 {}      {}  {   	{  MODIFICATIONS:  	 {   {  6/5/84   %{     1. Receive_messages will do a class get with the z buffer parameters % {     2. Post_msg writes the parameters into the trace file.  {  6/25/84  #{     1. Write the class number into DSAM so that it is accessible by  # {        mmgr without getting into labeled common.  {     2. Cleaned up comments and user interface defaults.   {   {  7/15/84  {     1. Incorporate suggestions from the review.   {   {  3/14/85   {     1. Add lost message counter code (declaration in TRCGBL).    "{     2. Add spaces between integers in Receive_Messages. (strwrite  " ${        does not work correctly -- adds no delimeter between numbers).  $ {   {  5/16/85  "{     1. Add code to get around rte requeue bug.  The second requeue " %{        always has xmit log in words, even if original request is bytes.  % {   {  6/12/85  {     1. Add DS_EnvOK check   {   {  7/30/85  {     1. Remove search of dres.rel and init_dec.rel   {   {  8/11/85  {     1. Get correct nodename from nodal registry   {   {  9/5/85   #{     1. Expand the slack area in VMA reserved for the formatter from  # "{        40 words/block to 320 words/block.  Also correct two steps  " {        in the allocation logic in InitVma.  {  10/1/85  !{     1. Add capability to trace exclusively old service messages  ! {     2. Convert nodename into a string from a PAC for FMTRC   {     3. We will always receive words. Modified receive routine.   {     4. Pad filename with a space if the length is odd.  %{     5. Distinguish between truly defaulting for filename, and specifying % "{        the default filename. (ok to overwrite in the second case)  " {}  $ PAGE $  { PROGRAM DESCRIPTION:   {  NSTRC is the tracing program for the AdvanceDS/1000 product.    {   "{  Users will be able to trace messages as they appear when they are " #{  delivered to a socket or as they appear as they enter or leave the  # !{  machine.  The tracing program may be scheduled interactively or ! 
{  programatically.  
 {   {  Runstring parameters:   {     RU, NSTRC [,trace file] [,error file] [,data len] [,level]   {   "{     trace file : Fully qualified name of the trace file.  Up to 64 " {                  characters.  #{                  Default: NS_TRACE.TRC in the working directory from # {                    which NSTRC was scheduled.   !{     error file : where to report runtime errors (a file or LU).  ! {                  Default: Scheduling terminal.  {     Data Len   : Length of the trace records.   {                  Default : 120 chars.  (One mbuf + a little)  {     Level      : N(etwork), S(ocket) or B(oth).   {                  Default : Network  {   {}  $ PAGE $  {  Program Flow:  {   {     Open error file   #{     Make sure NSTRC is not a cloned program and PLOG is not running  # {        ( only one tracing program may run at a time)  {     If writing to a file then   {        Open/create backing store file   {     Initialize Heap   {        Get Heap size  {        Allocate head record   !{        Allocate blocks to fill the heap and link them together.  ! {     Get a class number  {     Determine tracing level   {     IF S)ocket OR B)oth then  {        write class number in DSAM   {        turn high tracing on (Boolean in DSAM)   {     ENDIF   {     IF N)etwork ro B)oth Then   {        write class number in #PLOG  {        turn low tracing on  (Boolean in DSAM)   {     ENDIF   {     Receive Messages  {        REPEAT   {           Class Get (message)   {           Timestamp   {           Write it into heap  {        UNTIL (user break)   {     Post working set  
{     Close VM file  
 
{     return class number  
 {}  {   {   {   !{  Messages destined for NSTRC will come from one of three places: !  {  1. Old service messages will arrive exactly as they do today.   "{  2. If tracing is enabled at the network level, the message buffer " #{     which is copied into/from DSAM is rethreaded to the Class number #  {     of NSTRC.  The class number is stored in #PLOG and in DSAM   {     global area (DS_LLTClass).  Included in the appendage   {     buffer of the message is a sequence number   {     for the message and a socket number for outbound messages.   #{     Inbound messages will not know the socket number until they are  # !{     actually appended.  At that time, a record matching sequence ! {     numbers to the socket is posted to NSTRC.   #{  3. If tracing is enabled at the socket level, the message which is  # !{     appended to the socket is copied into SAM and sent to NSTRC. ! {     The socket number is contained in the appendage buffer.   {}  $ PAGE $  LABEL      99;      IMPORT  $search 'phtm/bodec.rel'     bodec,   $search 'phtm/sodec.rel'     sodec,      { declaration for IEEE_802 }   $search 'phtm/mmdec.rel'     mmdec,   $search 'phtm/mmext.rel'     ds_mm,   
$search 'phtm/trcgbl.rel'  
    trcgbl,  $search 'phtm/envok.rel'     envok;       CONST      CSPD = 100*60*60*24; { centiseconds per day }     ABORT   = -99; { constants for error proc }  	   RETURN  = -98;  	    DEFAULT_KEY = '....';   { illegal file name }      TYPE     IntAsc   = RECORD CASE Int16 OF              1 : (int : Int16);              2 : (asc : Packed Array [1..2] of CHAR);              END;         ParmRecordType = RECORD    { the various input parameters }           error_file : fname;   { where to record errors }   !         trace_place : fname;  { where the trace records will go } ! #         to_file  : Boolean;   { whether trace is to a file or an lu } #          level    : string[1]; { High_, low_level or both }   !         data_len : Int16;     { length of the data in the trace } !                     END;          VAR      exitstatus : Int16;      Runparm : ParmRecordType;   { Runstring parameters/defaults }      space : Info_rec;    { Heap/stack information }     j : Int16;           { Used in strwrite }  "   version : Int16; { whether this is a VMA or EMA prog or neither } "    errmsg   : String[80];  { error message for users }     errorfile : text;    { error log file }  $   outfil : text;       { Used for debugging.. Reports things to lu 1 }  $    class_num : Int16;   $   sktclass  : Int16;   { class number for trace subsystem in the mmgr } $    numblocks : Int16;   { Number of blocks allocated in VMA }      head : headptr;      { Pointer to the head of the list }   !   areg, breg : Int16;  { Used for error processing in CLRQ call } !         $ SUBTITLE 'EXTERNAL DECLARATIONS', PAGE$   #{--------------------------------------------------------------------} # #{                                                                    } # #{              EXTERNAL DECLARATIONS                                 } # #{                                                                    } # #{--------------------------------------------------------------------} #     	$ HEAPPARMS OFF $  	 PROCEDURE Abreg   { Get the value of the A and B registers }     (VAR areg : Int16;       VAR breg : Int16);     EXTERNAL;          ${ Procedure to write a dummy message to the end of the class queue to }  $ {  mark the end of tracing. }   PROCEDURE ClassWrite       $ ALIAS 'EXEC', NOABORT $     (    code : Int16;           cntwd : Int16;          bufr : Int16;   
        len : Int16; 
         pram1: Int16;           pram2 : Int16;  
        classnum : Int16); 
    EXTERNAL;      { Procedure to receive the messages }   PROCEDURE GetBuffer         $ ALIAS 'RCVBF', NOABORT $  
   (    class_num : Int16; 
     VAR zbuffer : ZBType;     { Second buffer}          maxzblen : Int16;     { Largest one we will accept }      VAR databuf : DBType;     { The message }   
        maxmsglen : Int16; 
     VAR Samaddr   : Int16;    { address of buffer in SAM }      VAR Istat     : Int16);   { not used }     EXTERNAL;          { Procedure which clears the buffer in S.A.M. }   PROCEDURE Class_Get        $ALIAS 'EXEC', NOABORT $      (    ecode : Int16;  
        class_num : Int16; 
     VAR buffer : DBType;          length : Int16);     EXTERNAL;      $ PAGE $  { Procedure to get a class number from the system }   PROCEDURE Clrq          $ NOABORT $      (    code : Int16;   { request or return a cl# }       VAR class_num : Int16);      EXTERNAL;      { Function to read the first two words of $TIME }    FUNCTION DTIME : Int32;                         $ALIAS 'DTIME'$       $DIRECT$      EXTERNAL;      $ HEAPPARMS ON $   { Heap management routine-- gets top of heap and top of stack }        PROCEDURE get_heap_stack_info     $ALIAS 'Pas.GetMemInfo2' $     (VAR heap_info : Info_Rec);     External;  	$ HEAPPARMS OFF $  	     $PAGE $   !{ Function which checks  to see if the user has issued  a break }  ! FUNCTION Ifbrk     : Int16;      EXTERNAL;          FUNCTION Pas_sparms   $ALIAS 'PAS.SPARAMETERS' $  
   (    Pos : Int16; 
     VAR Parm : String)               : Int16;   { Procedure to get runstring parameters in string format }     EXTERNAL;          "{ Procedure which returns the name, status and idadr of the calling  " {  program, or the idadr and status of a named program.   {}  PROCEDURE Pgmad      (VAR program_name : ProgName;      VAR idadr : Int16;     { address of the id segment }      VAR status : Int16);     EXTERNAL;      { Procedure to return exit status }   PROCEDURE Prtn     (    exitstatus : Int16);     EXTERNAL;      { Function to read the class number which is stored in #PLOG }  FUNCTION RdCNum      $ DIRECT $      : Int16;      EXTERNAL;      { Function to read the lost message count stored in #PLOG+7}  FUNCTION RdLMC     $ DIRECT $      : Int16;      EXTERNAL;      { Procedure to get the system time for a timestamp }  PROCEDURE Time  $ALIAS 'FTIME' $     (VAR times : FTimeType);      External;      { All the VMA routines require fixed_string on }  
$ FIXED_STRING ON $  
     	PROCEDURE VmaOpen  	    (VAR error : Int16;  { error code from open }  
        filename : fname;  
         optn : optype);   ${ Procedure to open a named file and use it as the backing store file }  $    EXTERNAL;      
PROCEDURE VmaClose;  
 { Closees the backing store file }     EXTERNAL;      	PROCEDURE VmaPost; 	 { Post the working set to the backing store file }     EXTERNAL;      PROCEDURE VmaSt      (VAR version : Int16;      { VMA, EMA, or neither }      VAR size : Int16);        { size of VMA/EMA }   { Get the status of this program as a VMA/EMA program }      EXTERNAL;      { Procedure to write the class number into #PLOG }  PROCEDURE WrCNum     (    class_num : Int16);      $DIRECT $     EXTERNAL;      $SUBTITLE 'FORWARD DECLARATIONS', PAGE$   %{-----------------------------------------------------------------------}  % %{                                                                       }  % %{                    FORWARD DECLARATIONS                               }  % %{                                                                       }  % %{-----------------------------------------------------------------------}  %     $HEAPPARMS ON, FIXED_STRING OFF$      
PROCEDURE Check_Sec; 
 %{ Make sure trace integrity is not violated by running this program.  That % ${  is, check to be sure it was properly loaded, that PLOG is not running $ {  that the system does not think it has a class number.  {}     FORWARD;           PROCEDURE CleanUpClass     (    class_num : Int16);   { Clean up stored values of class numbers in DSAM and #PLOG }      FORWARD;           PROCEDURE DeAllocClass  
   (    class_num : Int16; 
 
        sktclass  : Int16; 
     VAR level     : string);      { Deallocate the class numbers allocated to NSTRC }      FORWARD;       
PROCEDURE Error_loc  
    (VAR errorlog : String);   %{ Procedure to get the first parameter in the runstring which will be the  % ${ lu number to log error messages encountered while tracing is enabled.  $ {}     FORWARD;       
PROCEDURE Error_proc 
 #{ Procedure to report errors to the Error Lu and then either abort the # #{  program, or return to the calling procedure, depending on the value # {  of Code. }      (VAR msg : string;           code : Int16);   { severity of the error }     FORWARD;       !{ Handles error conditions on any exec call, since if there is an  ! "{ error, control returns to the first executable statement after the " { exec call. }  
PROCEDURE ExecError  
    (    areg : Int16;           breg : Int16);     FORWARD;            { Routine to initialize VMA and structure it as a linked list of   
{ record blocks.  }  
 	PROCEDURE Init_Vma 	    (VAR head : headptr;       { Pointer to the first record }       VAR numblocks : Int16;    { Number of blocks in VMA }   $    VAR Space : Info_Rec);    { Information on start of Heap and Stack } $    FORWARD;       FUNCTION Numchk      (VAR numstr : String)     : Boolean;   #{ Function to determine whether a string has only numeric characters } #    FORWARD;           { Open the backing store file }   	PROCEDURE OpenBack 	    (VAR filename : fname);   { User given or default }     FORWARD;               
FUNCTION ProgType: Int16;  
    { Determine whether this is a VMA or EMA program }      FORWARD;               ${ Routine to receive messages or logging info from the logging routines  $ 
{ in the memory manager }  
 
PROCEDURE Receive_Messages 
    (VAR head      : headptr;  
        class_num : Int16; 
 
        sktclass  : Int16; 
 
        numblocks : Int16; 
     VAR runparm   : ParmRecordType);     FORWARD;       $ PAGE $  FUNCTION Record_Length     : Int16;   #{ Function to get from the runstring the maximum length of the trace } # { records. }     FORWARD;       
PROCEDURE StoreClass 
 
   (    class_num : Int16; 
 
        sktclass  : Int16; 
 
    VAR trlevel : string); 
 #{ Procedure to store the class number where it needs to be and enable  # {  tracing according to the value of level.   {}     FORWARD;           PROCEDURE Trace_level      (VAR level : String);  !{ Procedure to determine the level of tracing the user requested } !    FORWARD;       
PROCEDURE Trace_loc  
    (VAR tracelog : fname;  { Where the trace records will go }      VAR into_file : Boolean);   #{ Procedure to determine where the tracing is to occur; in a VMA file  # 	{ or onto a tape.  	 {}     FORWARD;       $ SUBTITLE 'CHECK_SEC', PAGE $  %{***********************************************************************}  % {                 PROCEDURE Check_Sec   %{***********************************************************************}  % { DISCUSSION:   {   %{ Procedure to check that Trace Integrity will not be violated by running  % %{  the tracing program.  It checks to see that this program is not cloned, % "{  then checks to see that PLOG (old services trace program) is not  " #{  running, then checks to be sure that resources were returned to the # {  system the last time this program was run.   "{  If the program fails any of these tests, it aborts with an error  " "{  message to the procedure Error_Proc which prints it in error_loc. " {}  
PROCEDURE Check_Sec; 
     CONST      DORMANT = 0;       VAR      myname : ProgName;   { Name of the calling program }          itsname : ProgName;     idadr : Int16;       { Address of the id segment }      status : Int16;      { Program status }     namstr : string[20];    { Conversion destination }      prettynum : string[6];  { formatted version }     k : Int16;     { dummy var for strwrite }      
BEGIN  { CheckSec }  
    Pgmad (myname, idadr, status);      IF myname <> 'NSTRC ' THEN         BEGIN         setstrlen (namstr, 0);        strmove (6, myname, 1, namstr, 1);        errmsg := 'Name must be NSTRC, not ' + namstr + '.';        error_proc (errmsg, ABORT);         END;         itsname := 'PLOG  ';      pgmad (itsname, idadr, status);     IF status <> DORMANT THEN        BEGIN         setstrlen (namstr, 0);        strwrite (namstr, 1, k, status);        prettynum := strltrim(namstr);        errmsg := 'PLOG must be dormant.  It''s status: '                   + prettynum + '.';        error_proc (errmsg, ABORT);         END;  	END;  { CheckSec } 	     $ SUBTITLE 'CLEANUPCLASS         ', PAGE $  %{-----------------------------------------------------------------------}  % %{                                                                       }  % %{                    CleanUpClass                                       }  % %{                                                                       }  % %{-----------------------------------------------------------------------}  %     PROCEDURE CleanUpClass     (    class_num : Int16);       {   { Discussion:   !{  Procedure to clean up the the areas where the class numbers are ! {  stored.  That is, in DSAM global area and in #PLOG.  {}  { Parameters:   ${  class_num   INPUT          class number for receiving message buffers $ !{  sktclass    INPUT          class number for skt level messages. ! "{  level       INPUT          tells what level of tracing is enabled " {}      LABEL      9;       VAR   	   wkmp  : Int16;  	 	   ierr  : Int16;  	 	   class : Int16;  	     	BEGIN { cleanup }  	 IF class_num <> 0 THEN     BEGIN     DS_EnterCritical (wkmp, ierr);   
   IF ierr <> 0 THEN 
       BEGIN         errmsg := 'Access to DSAM not allowed';         error_proc  (errmsg, RETURN);   
      exitstatus := ierr;  
       goto 9;         END;     class := 0;     DS_StoreGlobal (DS_LLTClass, 1, class);     DS_StoreGlobal (DS_HLTClass, 1, class);     DS_StoreGlobal (DS_NetClass, 1, class);     DS_LeaveCritical (wkmp);      END;   9:     WrCNum (0);    { store class number 0 in #PLOG for GRPM }  	END;  { cleanup }  	         $ SUBTITLE 'DeAllocClass         ', PAGE $  %{-----------------------------------------------------------------------}  % %{                                                                       }  % %{                    DeAllocClass                                       }  % %{                                                                       }  % %{-----------------------------------------------------------------------}  %     PROCEDURE DeAllocClass  
   (    class_num : Int16; 
 
        sktclass  : Int16; 
     VAR level     : String);      {   { Discussion:    {  Procedure to clean up the the areas where the class number is   {  stored and to turn off tracing by setting the appropriate  {  Boolean values in DSAM to FALSE.   {}  { Parameters:   ${  class_num   INPUT          class number for NSTRC to get message bfrs $ ${  sktclass    INPUT          class # for mmgr to move data from mbuf to $ {                             SAM for skt level trace   {  runparm     INPUT          runtime parameter record  {}  VAR   	   areg : IntAsc;  	 	   breg : IntAsc;  	     
BEGIN { deallocate } 
 IF class_num <> 0 THEN     BEGIN     clrq (DEALLOCATE + CLRQ_NOABORT, class_num);   
      BEGIN { error proc } 
       abreg (areg.int, breg.int);   #      writeln (errorfile, 'NSTRC: Error deallocating class number. ',  # &               'Class #: ',class_num:1,' A Reg: ',areg.asc[1], areg.asc[2],  &                  ' B Reg: ', breg.asc[1], breg.asc[2]);   
      END;  { error proc } 
     
   IF (sktclass <> 0) THEN 
       BEGIN         clrq (DEALLOCATE + CLRQ_NOABORT, sktclass);            BEGIN { error proc }            abreg (areg.int, breg.int);  $         writeln (errorfile,'NSTRC: Error deallocating class number. ',  $ %               'Class #: ',sktclass:1,' A Reg: ',areg.asc[1], areg.asc[2], %                ' B Reg: ', breg.asc[1], breg.asc[2]);            END;  { error proc }         END;     END;   
END;  { deallocate } 
         $ SUBTITLE 'ERROR_LOC           ', PAGE $   %{-----------------------------------------------------------------------}  % {                 PROCEDURE  Error_Loc  %{-----------------------------------------------------------------------}  % { DISCUSSION:   {   %{ This procedure determines the location for the error log, as determined  % &{ from the second input parameter, and uses it to write errors from now on.  & { It may be either a file name or an LU.  {   { Parameters:   {  Error_Loc      OUTPUT      second runstring parameter  {}      
PROCEDURE Error_Loc  
    (VAR errorlog : String);           VAR   	   length : Int16; 	    parm2 : string[80];     numparm : Int16;     { Parm2 converted into a number }      n : Int16;           { Ending position in string convert }           
BEGIN  { Error_loc } 
 length := Pas_Sparms (2, parm2);  IF (length <= NOPARMS) THEN      BEGIN     rewrite (errorfile, '1');     errorlog := '1';     { Log errors to LU 1 }     END  ELSE      BEGIN  { Let the error catcher handle file open errors here }      rewrite (errorfile, parm2);     errorlog := parm2;      END;   
END;  { Error_loc }  
     $ SUBTITLE 'ERROR_PROC          ', PAGE $       ${**********************************************************************} $ {                       PROCEDURE Error_Proc  ${**********************************************************************} $ { Discussion:    {  Procedure to print an error message to the error LU and then    {  either abort the program or continue.  Used in parsing the   {  runstring before starting to gather data.  {   { Parameters:   {  msg         INPUT       error message to be printed  {  code        INPUT       whether to abort or return   {}          
PROCEDURE Error_Proc 
    (VAR msg : String;   
      code : Int16); 
 BEGIN   
   msg := 'NSTRC: ' + msg; 
    writeln (errorfile, msg);     IF code = ABORT THEN         BEGIN         exitstatus := -1;         goto 99;        END;      
END;  { error_proc } 
         $ SUBTITLE 'EXEC ERROR          ', PAGE $   %{-----------------------------------------------------------------------}  % {                       PROCEDURE ExecError   %{-----------------------------------------------------------------------}  % 
PROCEDURE ExecError  
    (    areg : Int16;           breg : Int16);      { Discussion:   ${  Procedure to handle a no abort error on an exec call.  Always aborts  $ {  the program.   {   
{ Global Variables:  
 {  Errorfile   Not changed.   {}      VAR      ar : Intasc;      br : Intasc;       BEGIN   	   ar.int := areg; 	 	   br.int := breg; 	        writeln (errorfile, 'Error in exec call.  Error code: ',                  ar.asc[1], ar.asc[2], br.asc[1], br.asc[2]);      writeln (errorfile, 'Class number is ',class_num:1);      goto 99;   END;     { ExecError }      $ SUBTITLE 'INIT_VMA            ', PAGE $   %{************************************************************************} % %{                     PROCEDURE INIT_VMA                                 } % %{************************************************************************} % {}  { DISCUSSION:   "{ Procedure to initialize the VMA space with the chain of vmblocks.  " "{ The main loop allocates a vmblock, and initializes the whole block " "{ by writing INIT_MSG into it.  It then links it onto the chain and  " "{ checks to see if there is enough free space (get_heap_stack_info)  " "{ to allocate another.  When the free space is full, the last block  " "{ is linked around to the first.  Now there is a circular list with  " { the head pointer pointing to the first element.   {   #{  The amount of free space to leave is calculated by leaving about a  # "{  page for Pascal slack, plus enough room for the formatter  to do  " ${  its calculations.  It needs four words for each trace message in the  $ {  file (2wds data + 2 wds pointer)   {   { Parameters:   {  Head        OUTPUT      First record in Heap   {  Numblocks   OUTPUT      total number of message blocks   {  Space       OUTPUT      Contains heap/stack status info  {}      	PROCEDURE Init_Vma 	    (VAR Head : headptr;      { Pointer to the first record }       VAR numblocks : Int16;   { Total number of message blocks }    %    VAR space : Info_Rec);   { Information on heap/stack status is here }  %     CONST   #   { Amount of heap/stack slack to keep is calculated for the worst  } # #   {   case trace file where all messages are socket/sequence number } # #   {   hints, each with the maximum of 8 sequence numbers; MSG_LEN   } # #   {   is in bytes so word count must be computed.                   } #        BLOCKSIZE = MSG_PER_BLOCK * (MSG_LEN DIV 2);      FMT_WDLEN = (4 * 8);       VAR      cur_block : ^vmarec;    { Block currently being allocated }     prev : ^vmarec;         { Block previously allocated }   
   fmtspace : Int16; 
     $ PAGE $  	BEGIN { Init_Vma } 	    new (head);    { Allocate space for this one first }   
   new (cur_block);  
    head^.first_block := cur_block;  { Link head to the list }      cur_block^.message[1].time := -1;  	   numblocks := 1; 	 &   fmtspace := MSG_PER_BLOCK * FMT_WDLEN * 2; {reserve 2 for the formatter } &    get_heap_stack_info (space);          WHILE space.toh - space.tos > (BLOCKSIZE + fmtspace) DO        BEGIN         prev := cur_block;        new (cur_block);        numblocks := numblocks + 1;  { Count each one }         prev^.next_block := cur_block;   { Link them }  "      cur_block^.message[1].time := -1;   { Initialize each block }  "       get_heap_stack_info (space);      %      { Now increase the amount of space we will need to save because of } % 
      { the next block. }  
       fmtspace := fmtspace + (MSG_PER_BLOCK * FMT_WDLEN);         END;         { Link the list into a circular list }      cur_block^.next_block := head^.first_block;      END;  {Init_Vma}      $ SUBTITLE 'NUMCHK              ', PAGE $   %{-----------------------------------------------------------------------}  % {                        FUNCTION Numchk  %{-----------------------------------------------------------------------}  %     FUNCTION Numchk      (VAR numstr : String)        : BOOLEAN;      { Discussion:   "{  Procedure to check to see whether a string contains only numeric  " "{  characters.  This procedure must NOT be called with a zero length " {  string.  {   { Parameters:   {  numstr      INPUT       string to check  {}      VAR      Numeric : Boolean;      Pos : Int16;      { Character position within parm }      Len : Int16;      { Length of parm }       	BEGIN  { Numchk }  	 
   numeric := TRUE;  
    pos := 1;  
   len := strlen (numstr); 
        REPEAT         CASE (numstr[pos]) OF         '0'..'9': BEGIN                   pos := pos + 1   { move on to next one }  
                END  
       Otherwise BEGIN                   numeric := FALSE  
                END  
       END;     UNTIL (pos > len) OR (NOT numeric);         Numchk := numeric;       END;  {Numchk }           $ SUBTITLE 'OPENBACK            ', PAGE $   ${*********************************************************************}  $ {                   PROCEDURE OpenBack  ${*********************************************************************}  $     	PROCEDURE OpenBack 	 
   (VAR filename : fname); 
 {   { Discussion:   {   "{ This procedure is called if the program is a VMA program in order  " #{ to open the backing store file.  If the user gives a filename, that  # #{ file will be created if it didn't exist.  However, if it did exist,  # ${ the program will abort with a mesage to the user.  This is to protect  $ ${ the innocent user from overwriting their old trace file, yet to allow  $ %{ the program to be scheduled programmatically (no interactive questions). % !{ Data will be posted to the file by the VMA firmware only in the  ! { case of a page fault.   {   { Parameters:   {  filename       INPUT       name of file  {}  CONST      DESCLEN = 64;     NO_ERROR = 0;  	   NOT_VMFIL = 84; 	 	   NOT_THERE = -6; 	     VAR   !   num : String[20];    { string representation of an error code } !     prettynum : String[10]; { num with leading blanks stripped }    	   error : Int16;  	    helpmsg : string[80];  $   k : Int16;           { Dummy variable needed by strwrite.  Not used } $     $ PAGE $      PROCEDURE OpenDefault       (VAR tname : fname;  { string descriptor for the file name }        VAR error : Int16);   {}  { Discussion:   #{  Internal procedure to determine the name of the default trace file. # {}          BEGIN      tname := 'NS_TRACE.TRC';        { assign a valid name }     VMAOpen (error, tname, 'OWX');          IF error <> NOT_THERE THEN         BEGIN         IF error = NO_ERROR THEN           BEGIN { file exists }           errmsg := 'Trace file ' + tname + ' exists.';           END   { file exists }        ELSE           BEGIN           num := '';  { initialize it }           strwrite (num, 1, k, error);            prettynum := strltrim (num);            errmsg := 'VM error #' + prettynum + '.';           END;         error_Proc (errmsg, ABORT);         END;  { handle errors }       END;  { OpenDefault }   $ PAGE $              BEGIN   IF strlen(filename) > DESCLEN THEN     BEGIN  #   errmsg := 'VMA OPEN:  File descriptor may be only 64 characters.';  #    error_proc (errmsg, ABORT);     END;       IF filename = DEFAULT_KEY THEN     BEGIN { use default }     OpenDefault (filename, error);      END   { use default }  ELSE     BEGIN     { Try to open the which user wants to use }     VmaOpen (error, filename, 'OWX');     END;       helpmsg := filename + ' is the name of the trace file.';  setstrlen (num, 0);  { Initialize for error reporting }       CASE (error) OF      NO_ERROR:        BEGIN         error_proc (helpmsg, RETURN);         END;         NOT_VMFIL:         BEGIN         errmsg := 'Trace file ' + filename + ' not a VMA file.';        error_proc (errmsg, ABORT);         END;         NOT_THERE:         BEGIN    { File didn't exist-- create it }        VmaOpen (error, filename, 'CWX');         IF error = NO_ERROR THEN           BEGIN           error_proc (helpmsg, RETURN);           END        ELSE           BEGIN           strwrite (num, 1, k, error);            prettynum := strltrim (num);      { make it pretty }            errmsg := 'VM error #' + prettynum + '.';           error_proc (errmsg, ABORT);           END;         END;         OTHERWISE        BEGIN         strwrite (num, 1, k, error);        prettynum := strltrim (num);        errmsg := 'VM error #' + prettynum + '.';         error_proc (errmsg, ABORT);         END;  	   END;  { case }  	 	END;  { OpenBack } 	             $ SUBTITLE 'PROGTYPE            ', PAGE $   ${*********************************************************************}  $ {                    FUNCTION ProgType  ${*********************************************************************}  $ 
FUNCTION ProgType : Int16; 
 { Discussion:   !{  Function to determine whether this program was loaded as a VMA  !  {  program or an EMA program.  It returns the program type as an   {  integer.   {}      VAR      size : Int16;  { Size (in pages) of the heap }      ptype : Int16;  { Program type }       
BEGIN  { ProgType }  
    VmaSt (ptype, size);   	   CASE (ptype) of 	    EMAPROG,   	   VMAPROG: BEGIN  	             ProgType := ptype               END;  	   NOTVMA : BEGIN  	 !            errmsg := 'Program not loaded as a VMA/EMA program.';  !             error_proc (errmsg, ABORT);               END;     OTHERWISE  	            BEGIN  	             errmsg := 'Unexpected program type. ' +                         ' Received in VMAST call.';               error_proc (errmsg, ABORT);               END;  	   END;  { case }  	 	END;  { ProgType } 	         $ SUBTITLE 'RECEIVE_MESSAGES    ', PAGE $   %{***********************************************************************}  % %{                     PROCEDURE RECEIVE_MESSAGES                        }  % %{***********************************************************************}  %     
PROCEDURE Receive_Messages 
    (VAR Head : headptr;   
        class_num : Int16; 
 
        sktclass  : Int16; 
 
        numblocks : Int16; 
     VAR runparm : ParmRecordType);  {}  { Discussion:   {  Write initial lengths into head^.info and then hang on get   "{  waiting for messages.  After the main loop is finished by a user  " !{  break, write time, counts and pointers into head^.info so that  ! {  the formatting program will be able to read the trace file.  {   { The format of the message which is stored in memory is:   {     _______ ________ _________ ____________________ ________   {    |       | Length |  Length |                    |        |     {    |  time |   of   |    of   |                    |        |     {    | stamp |z buffer| message |     MESSAGE        |  Z BUF |     {    |_______|________|_________|____________________|________|    {   {   { Format of the z buffer for each of the three message types:   {   {  NetIB:                         NetOB:  {    _____ _____ _____ _____       _____ _____ _____ _____  {   |     | seq |link |     |     | skt | seq |link |     |   {   |  0  |  #  | type| LU# |     |  #  |  #  | type| LU# |   {   |_____|_____|_____|_____|     |_____|_____|_____|_____|   {   {  Socket:  {         ______ _____  {        | skt  |     |   {        |  #   |dir'n|   {        |______|_____|   {   %{  Socket/sequence number records will have no z buffer, but will have all % {   the data in the data buffer.  Their format will be:   {            _____ _____ _____ _____ _____  {           | skt | seq | seq |     | seq |   {           |  #  | # a | # b | ... | # n |   {           |_____|_____|_____|_____|_____|   {   {}  { PARAMETERS:   {  head       INPUT        points to first record in file   {  class_num  INPUT        class number   {  numblocks  INPUT        size of Heap image in blocks   {  runparm    INPUT        runstring parameters   {}  $ PAGE $      VAR   "   areg, breg  : Int16;        { register values for error returns } " '   blkpos      : Int16;     { Number of records written in the current block}  '     cur_block   : ^vmarec;      { Points to the current record }       dalen       : Int16;        { Actual data transmitted }     databuf     : DBType;  "   dummybuf    : DBType;       { Value of A register -- not needed } "    dummy1, dummy2 : Int16;     { Extra parameters in call }      end_time    : DayTimeType;  { Time at end of logging }      error       : Int16;      filesize    : Int16;        { Size of the VMA file }      j           : Int16;   &   maxmsglen   : Int16;        { Length of message user gave in runstring }  & %   maxzblen    : Int16;        { Length of zbuffer.  Fixed at 17 for now } %    NameOfNode  : String[MAX_ENVIRON_NAMELEN];      noderec     : NodeRecord;   { contains the nodename }  !   rec_cnt     : Int16;        { Total number of records written } !     start_time  : DayTimeType;  { Time at the start of logging }       wkmp        : Int16;      zblen       : Int16;        { Actual size of z buffer }     zbuf        : ZBType;      ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                    Post_Msg  (Internal)                             }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $     PROCEDURE Post_Msg;  { This one does the work into VMA/EMA }        %{ Note: length and zblen are referenced but not passed.  Done for speed }  % {       curblock, blockpos are referenced and changed. }         VAR  
      curtm : Int32; 
       lmc   : Int16;    { Lost message counter }         BEGIN  { Post_msg }         blkpos := blkpos + 1;     curtm := DTime + CSPD;  { get it in 24 hour format }          lmc := RdLMC;   { get the current lost message count }          { copy data to VMA }      WITH cur_block^.message[blkpos] DO         BEGIN   
      time := curtm; 
       msglost := lmc;    { record current lost message count }        datalen := dalen;  { actual length of data transmitted }  #      zbufferlen := zblen; { actual length of the z buffer received }  #       databuffer := databuf;        zbuffer := zbuf;        END;          "   { If we are at the end of the block then move into the next one } "    IF blkpos = MSG_PER_BLOCK THEN         BEGIN   	      blkpos := 0; 	       cur_block := cur_block^.next_block        END;  	END;  { Post_msg } 	 $ PAGE $      ${----------------------------------------------------------------------} $ ${                                                                      } $ ${                 PROCEDURE CleanUpQueue  (Internal)                   } $ ${                                                                      } $ ${----------------------------------------------------------------------} $ PROCEDURE CleanUpQueue     (    Class_Num : Int16);       { PARAMETERS:   {   !{  classnum  INPUT  class number allocated to the tracing program  ! {   { DISCUSSION:   !{  This procedure writes a zero length buffer into the class queue !  {  as a marker.  It then continues to read buffers and post them   {  until the mark buffer appears.   {}      VAR   	   areg  : Int16;  	 	   breg  : Int16;  	    bufr  : Int16;    { dummy buffer }      cntwd : Int16;    { control word for the class write }      dalen : Int16;    { data length from abreg call }     zblen : Int16;    { Appendage buffer length }      $ PAGE $  BEGIN { CleanUpQueue }      cntwd := 0;   bufr := 0;  ClassWrite (EXEC20, cntwd, bufr, 0, 0, 0, class_num);      BEGIN { error processing }      ABReg (areg, breg);  
   ExecError( areg, breg); 
    END;  { error processing }       ${ Continue to get and post messages until the marker buffer is reached } $ REPEAT     GetBuffer (class_num, zbuf, maxzblen, databuf, maxmsglen,                 dummy1, dummy2);         BEGIN { error processing }  
      ABReg (areg, breg);  
       ExecError (areg, breg);         END;  { error processing }         ABReg (zblen, dalen);         IF zblen <> 0 THEN         BEGIN { release the class buffer to the system }        Class_get (NOABORT+EXEC21, class_num, dummybuf, 0);            BEGIN { error processing }            ABReg (areg, breg);           ExecError( areg, breg);           END;  { error processing }         END   { release buffer }     ELSE         BEGIN { need to get the data; it's a ss hint }         Class_get (NOABORT+EXEC21, class_num, databuf, maxmsglen);            BEGIN { error processing }            ABReg (areg, breg);           ExecError( areg, breg);           END;  { error processing }   
      ABReg (areg, dalen); 
       END;            IF (dalen <> 0)  THEN            BEGIN { a valid message }  %         { Check for byte transmission (LAN).  We have no way of knowing } % %         { if others have transmitted in bytes or words.  This will be   } % %         { a byte length ONLY for inbound messages.  (rte bug)           } %              { Fix transmission log if necessary }           IF dalen > maxmsglen THEN dalen := maxmsglen;               rec_cnt := rec_cnt + 1;  	         Post_Msg; 	          END;  { a valid message }     UNTIL ((dalen=0) AND (zblen = 0));           END;  { CleanUpQueue }  $page   BEGIN    { Receive_messages }      blkpos := 0;      rec_cnt := 0;     filesize := numblocks * MSG_PER_BLOCK;      class_num := class_num + DONT_DEALLOCATE;      "   cur_block := head^.first_block;    {Get first block in the list } "    maxmsglen := runparm.data_len; { length in words }      maxzblen := MAX_ZB_LEN;       { length in words }     setstrlen (start_time.tstring, 30); { initialize it }     setstrlen (end_time.tstring, 30); { initialize it }     time (start_time.tarray);   { get start time }          WHILE Ifbrk = 0 DO         BEGIN          GetBuffer (class_num, zbuf, maxzblen, databuf, maxmsglen,                      dummy1, dummy2);           BEGIN { error processing }            ABReg (areg, breg);           ExecError( areg, breg);           END;  { error processing }       #      Abreg (zblen, dalen);   { Lengths in words of buffers returned } #           IF zblen <> 0 THEN           BEGIN { release the class buffer to the system }            Class_get (NOABORT+EXEC21, class_num, dummybuf, 0);              BEGIN { error processing }              ABReg (areg, breg);               ExecError( areg, breg);               END;  { error processing }           END   { release the class buffer to the system }         ELSE           BEGIN { get the data; it's a ss hint }   "         Class_get (NOABORT+EXEC21, class_num, databuf, maxmsglen);  "             BEGIN { error processing }              ABReg (areg, breg);               ExecError( areg, breg);               END;  { error processing }           ABReg (areg, dalen);                END;  { get data ourselves }             { fix transmission log for truncated messages }         IF dalen > maxmsglen THEN dalen := maxmsglen;             rec_cnt := rec_cnt + 1;         Post_msg;         END;       $ PAGE $       { Now that we are finished, clean up and update head record }      CleanUpClass (class_num);     CleanUpQueue (class_num);  
   time (end_time.tarray); 
     "   { If there were more records written than the size allocated then " "   { records have been overwritten.  Must adjust pointers so that we " !   { can get to the first record.  Blkpos must point to the block  !    { containing the oldest record in the file.     {}      IF rec_cnt > filesize THEN         BEGIN         blkpos := blkpos + 1;         head^.first_block := cur_block;         END   
   ELSE blkpos := 1; 
     #   { Now write the total number of records written, the oldest record, # $   {  the start and finish time into the file.  Numblocks is also needed $     {  so that the formatter knows how big to make the VMA space.      {}       !   strwrite (head^.info,1,j, rec_cnt,' ',numblocks,' ',blkpos,' ', !                   start_time.tstring, end_time.tstring);         { Now add the node name }         DS_EnterCritical (wkmp, error);     IF error <> 0 THEN         BEGIN         errmsg := 'Access to DSAM not allowed ';        Error_proc (errmsg, RETURN);        noderec.nr_nodename.chars := 'nodename unknown';        END      ELSE         BEGIN { get the real node name }        DS_FetchElement (DS_NodesTD, 1, noderec.int);         DS_LeaveCritical (wkmp);        END; { get the real node name }          { First write the nodename into a string for FMTRC }      NameOfNode := ''; { Initialize }   !   strmove (noderec.nr_nodenamelen, noderec.nr_nodename.chars, 1,  !                NameOfNode, 1);         strwrite (head^.info, j,j, NameOfNode);      END;     { Receive_messages }       $ SUBTITLE 'RECORD_LENGTH       ', PAGE $   ${*********************************************************************}  $ {                    FUNCTION Record_Length   ${*********************************************************************}  $     FUNCTION Record_Length     : Int16;   {   { Discussion:   {  Procedure to find out the maximum length of a trace record.  {  It would be given by a user for performance reasons or if  %{  s/he wanted to see more data.  The default is 24 words, twice as large  % #{  as the longest link interface header.  The max length is 60 words.  # ${  If the user enters a length longer than MAXLEN, a warning is printed  $ {  and all longer trace records are truncated to MAXLEN.  {}          VAR   	   length : Int16; 	    parm3 : string[80];     j : Int16;     { Return from strread.  Not used }     numparm : Int16;  { parm3 converted into a number }      $ PAGE $  BEGIN { Record_length }      length := Pas_Sparms (3, parm3);      IF length <= NOPARMS THEN        BEGIN         record_length := DEF_DATA_LEN;        END      ELSE IF NOT numchk(parm3) THEN         BEGIN         Errmsg := 'Expected a positive number.  Got '                     + parm3 + '.';        error_proc (errmsg, ABORT);         END      ELSE BEGIN         strread (parm3,1,j,numparm);        CASE (numparm) OF         0 : BEGIN            errmsg := 'Expected a positive number.  Got '                       + parm3 + '.';            error_proc (errmsg, ABORT);           END;         1..MAX_DATA_LEN :            BEGIN           record_length := numparm;           END;         otherwise            BEGIN           record_length := MAX_DATA_LEN;   #         errmsg := 'Records longer than 60 words will be truncated.';  #          error_proc (errmsg, RETURN);            END;   
      END;  { case } 
 	   END;  { else }  	 END;  { record_length }       $ SUBTITLE 'STORECLASS           ', PAGE $  ${*********************************************************************}  $ {   {                    PROCEDURE StoreClass   {   ${*********************************************************************}  $ 
PROCEDURE StoreClass 
 
   (    class_num : Int16; 
 
        sktclass  : Int16; 
 
    VAR trlevel : String); 
     { Discussion:   !{  Procedure to write the class number in the appropriate place(s) ! {  and enable tracing depending on the value of level.  {}  { Parameters:   {  class_num      INPUT       class number of NSTRC   #{  sktclass       INPUT       class number of Trace subsystem in mmgr  # !{  trlevel        INPUT       level of tracing (socket or network) ! {}          VAR      wkmp : Int16;     ierr : Int16;      
BEGIN { StoreClass } 
    DS_EnterCritical (wkmp, ierr);   
   IF ierr <> 0 THEN 
       BEGIN         errmsg := 'Access to DSAM not allowed ';        error_proc  (errmsg, ABORT);        END;         { For network level trace, store NSTRC class in #PLOG and }     {  in the global area in DSAM                             }         IF (trlevel = 'B') OR (trlevel = 'N') THEN         BEGIN { enable network level trace }        DS_StoreGlobal (DS_LLTClass, 1, class_num);   
      WrCNum (class_num);  
       END;  { enable network level trace }      $   { For Old service trace, we need only write the class number in LC }  $    IF trlevel = 'O' THEN        BEGIN   
      WrCNum (class_num);  
       END;      !   { For socket level trace, store the Socket Level class number } ! !   { in DSAM and NSTRC class number there also                   } !        IF (trlevel = 'B') OR (trlevel = 'S') THEN         BEGIN { enable socket level trace }         DS_StoreGlobal (DS_HLTClass, 1, sktclass);        DS_StoreGlobal (DS_NetClass, 1, class_num);         END;  { enable socket level trace }      DS_LeaveCritical (wkmp);       
END;  { storeClass } 
     $ SUBTITLE 'TRACE_LEVEL         ', PAGE $   ${---------------------------------------------------------------------}  $ {                    PROCEDURE Trace_Level  $----------------------------------------------------------------------}  $ PROCEDURE Trace_Level      (VAR level : String);      { Discussion:   "{  Looks at the first letter of the input parameter to determine the " 
{  level of tracing. 
 {}  { Parameters:   {  level          OUTPUT      level of tracing  {}      VAR   	   length : Int16; 	    parm4 : string[80];          BEGIN   parm4 := '';  length := Pas_Sparms (4, parm4);  
IF length <= NOPARMS THEN  
 
   BEGIN { no parameter }  
    level := 'N';    { default: trace at network level }   
   END   { no parameter }  
 ELSE  
   CASE parm4[1] OF  
       'N', 'n' : BEGIN                   level := 'N';                   END;             'S', 's' : BEGIN                   level := 'S';                   END;             'B', 'b' : BEGIN                   level := 'B';                   END;             'O', 'o' : BEGIN                   level := 'O';                   END;             OTHERWISE BEGIN   #                errmsg := 'Expected ''N'' , ''S'', or ''B''.  Got '''  #                 + parm4 + '''.';                  error_proc (errmsg, ABORT);   
                END; 
 	   END;  { case }  	     END;  { Trace_level }           $ SUBTITLE 'TRACE_LOC           ', PAGE $       ${*********************************************************************}  $ {                    PROCEDURE Trace_Loc  ${*********************************************************************}  $ 
PROCEDURE Trace_Loc  
 
   (VAR Tracelog : fname;  
 !    VAR Into_File : Boolean);     { whether records go to a file } ! {}  { Discussion:    {  Procedure to get the second runstring parameter, which is the   {  name of the trace file or else the lu of the tape/other.   !{  Assumes the file exists until the procedure OpenBack is called. ! {   { Parameters:   "{  Tracelog       OUTPUT      name of trace file or LU (as a string) " {  Into_File      OUTPUT      whether tracing is to a file  {}      CONST      NAMLEN = 6;       { Minimum file name length }      FIVESPACES = '     ';      VAR      parm1 : fname;    { Name of trace file }      length : Int16;   { Length of the second parameter }      lunum : Int16;    { Lu number for the trace file }       $ PAGE $      
BEGIN { trace_loc }  
    length := Pas_Sparms (1, parm1);   "   { If the user omitted the parameter or the rest of the runstring  "    { then use the default file name }      IF (length <= NOPARMS) THEN        BEGIN         tracelog := DEFAULT_KEY;        into_file := TRUE;        END      ELSE BEGIN  { Something came..Make sure it is valid }        IF numchk(parm1) THEN            BEGIN { can't trace to an LU }            errmsg := parm1 + ' not a valid trace file name.';            error_proc (errmsg, ABORT);           END   { can't trace to an LU }         ELSE           BEGIN  $         tracelog := parm1;  { assume for now that it is a valid file }  $          { Add on a space if the length is odd }           IF (length MOD 2 = 1) THEN   	            BEGIN  	             tracelog := tracelog + ' ';               END;           into_file := TRUE;            END;   
      END;  { else } 
     
END;  { trace_loc }  
 $ SUBTITLE 'MAIN                ', PAGE $   ${---------------------------------------------------------------------}  $ {                          MAIN   ${---------------------------------------------------------------------}  $     	BEGIN    { Main }  	 { emergency error file }  rewrite (outfil, '1');  exitstatus := 0;  
DS_EnvOK ('NSTRC '); 
         WITH runparm DO   
   BEGIN    { with } 
 
   error_loc (error_file); 
    { Now that there is an error_file, check security }     check_sec;      trace_level (level);      trace_loc (trace_place, to_file);     data_len := Record_Length;   
   END;     { with } 
 { Now determine the type of program. }  
version := ProgType; 
 IF (version = VMAPROG) AND (runparm.to_file) THEN      BEGIN    { Open the backing store file }      OpenBack (runparm.trace_place);     END;       { Initialize the VMA/EMA space with the data structure }  Init_Vma (head, numblocks, space);  { Initialize the head record }  
setstrlen(head^.info, 0);  
 IF (version = VMAPROG) AND (runparm.to_file) THEN      BEGIN     strwrite (head^.info, 1, j, 0);     VmaPost;      END;       !Clrq (ALLOCATE + CLRQ_NOABORT, class_num);  { Get a class number } !    BEGIN { Error processing }      ABReg (areg, breg);  
   ExecError (areg, breg); 
    END;  { error processing }       IF (runparm.level = 'S') OR (runparm.level = 'B') THEN     BEGIN { need another for the socket messages }   %   Clrq (ALLOCATE + CLRQ_NOABORT, sktclass);  { Get another class number } %       BEGIN { Error processing }  
      ABReg (areg, breg);  
       ExecError (areg, breg);         END;  { error processing }     END  
ELSE sktclass := 0;  
     &StoreClass (class_num, sktclass, runparm.level);   { Store class number(s)}  &     !Receive_messages (head, class_num, sktclass, numblocks, runparm);  !     VmaClose;       99:   DeAllocClass( class_num, sktclass, runparm.level);  	prtn (exitstatus); 	 END. 