 $PASCAL '91790-1X174 REV.4010 <851125.2001> '       $ TITLE 'NS Parsing/Display Routines '$   $ STANDARD_LEVEL'HP1000', RECURSIVE OFF, RANGE OFF, HEAP 0  $   $ DEBUG $   $ CODE_INFO on $      MODULE parser;  	$ALIAS 'N$parser'  	         {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  
{     NAME:   PARSDD 
 
{     SOURCE: 91790-18174  
 	{     RELOC:  NONE 	 	{     PGMR:   EMS  	 {}      {}  {   {  This module contains the dummy parsing routines  {  for NSINIT.  {   {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   {   {------------------------------------------------------------   {}      IMPORT         { basic memory manager declarations }  $ SEARCH 'phtm/bodec.rel' $      bodec,          { basic initialization declarations. }   $ SEARCH 'phtm/init_dec.rel'$      Init_Dec,      $ SEARCH 'phtm/initmulti.xpt' $      initmulti;       $ SUBTITLE 'Exported Routines ', PAGE $       EXPORT      
PROCEDURE CharInput  
   (    PromptString:       PromptType;         casefold:           Boolean;      VAR default:            Boolean;      VAR terminator:         Boolean;      VAR input_string:       String;     VAR passed_result:      Int16);  $   { Prompt user with promptstring; read a character string from user }  $     PROCEDURE CountErrorMsgs     ( VAR totalerrorcount:  Int16 );       
PROCEDURE ErrorMsgsToDSAM  
    ( VAR result:           Int16 );       	PROCEDURE IntInput 	   (    promptstring:        PromptType;      VAR default:             Boolean;     VAR terminator:          Boolean;         hi_value:            Int16;         lo_value:            Int16;     VAR int16_value:         Int16;     VAR passed_result:       Int16);   #   { Prompt with promptstring; read a positive integer from the user } #     PROCEDURE MsgFilePrint  (     msgnumber:     Int16;         whichroutine:  PrintMsgType;        printinfo:     Int16;     VAR result:        Int16 );       PROCEDURE PrintPrompt     (    saveprompt:         Boolean;          promptstring:       PromptType;     VAR passed_result:      Int16);      
PROCEDURE WordInput  
   (    promptstring:       PromptType;     VAR default:            Boolean;      VAR string_of_tokens:   String;     VAR token_from_user:    String;     VAR passed_result:      Int16);     { Prompt user with promptstring; read input and make sure        it is one of the tokens in string_of_tokens            }      
PROCEDURE YesNoInput 
   (    promptstring:       PromptType;     VAR default:            Boolean;      VAR yesnovalue:         OneCharType;      VAR passed_result:      Int16);     { Prompt user with promptstring; read a Y/N from the user }      $ SUBTITLE 'Implement', PAGE $  IMPLEMENT            { Module parser }      $SUBTITLE 'CharInput', PAGE $   
PROCEDURE CharInput  
   (    promptstring:       PromptType;         casefold:           Boolean;      VAR default:            Boolean;      VAR terminator:         Boolean;      VAR input_string:       String;     VAR passed_result:      Int16);  $   { Prompt user with promptstring; read a character string from user }  $     
   BEGIN    { CharInput }  
        initglobals.IG_whichguy := CCHARINPUT;      input_string := '';         WITH globalstring DO         BEGIN    { WITH }         CIpromptstring := promptstring;         CIcasefold := casefold;         CIdefault := default;         CIterminator := terminator;         CIinput_string := input_string;         CIresult := passed_result;            DoSubCall( PARSERPROG );            promptstring := CIpromptstring;         default := CIdefault;         terminator := CIterminator;         input_string := CIinput_string;         passed_result := CIresult;            END;     { WITH }   
   END;     { CharInput }  
     $SUBTITLE 'CountErrorMsgs', PAGE $  PROCEDURE CountErrorMsgs   ( VAR totalerrorcount:    Int16 );      { Count the number of error msgs in NFT/VT error msg file }         BEGIN    { CountErrorMsgs }         initglobals.IG_whichguy := CCountErrorMsgs;         WITH globalstring DO         BEGIN    { WITH }         CEtotalerrorcount := totalerrorcount;             DoSubCall( PARSERPROG );            totalerrorcount := CEtotalerrorcount;             END;     { WITH }      END;     { CountErrorMsgs }      $SUBTITLE 'ErrorMsgsToDSAM', PAGE $   
PROCEDURE ErrorMsgsToDSAM  
 
 ( VAR result:    Int16 ); 
    { Move the error msgs in NFT/VT error msg file to DSAM }          BEGIN    { ErrorMsgsToDSAM }          initglobals.IG_whichguy := CErrorMsgsToDSAM;          WITH globalstring DO         BEGIN    { WITH }   
      EMresult  := result; 
           DoSubCall( PARSERPROG );      
      result := EMresult;  
           END;     { WITH }      END;     { ErrorMsgsToDSAM }       $SUBTITLE 'IntInput', PAGE $  	PROCEDURE IntInput 	   (    promptstring:        PromptType;      VAR default:             Boolean;     VAR terminator:          Boolean;         hi_value:            Int16;         lo_value:            Int16;     VAR int16_value:         Int16;     VAR passed_result:       Int16);   #   { Prompt with promptstring; read a positive integer from the user } #        BEGIN    { IntInput }         initglobals.IG_whichguy := CINTINPUT;         WITH globalstring DO         BEGIN    { WITH }             IIpromptstring := promptstring;         IIdefault := default;         IIterminator := terminator;         IIhi_value := hi_value;         IIlo_value := lo_value;         IIint16_value := int16_value;         IIpassed_result := passed_result;             DoSubCall( PARSERPROG );            promptstring := IIpromptstring;         default := IIdefault;         terminator := IIterminator;         int16_value := IIint16_value;         passed_result := IIpassed_result;             END;     { WITH }      END;     { IntInput }      $SUBTITLE 'MsgFilePrint', PAGE $  PROCEDURE MsgFilePrint  (     msgnumber:     Int16;         whichroutine:  PrintMsgType;        printinfo:     Int16;     VAR result:        Int16 );          BEGIN    { PrintPrompt }          initglobals.IG_whichguy := CMSGFILEPRINT;         WITH globalstring DO         BEGIN    { WITH }             MFmsgnumber := msgnumber;         MFwhichroutine := whichroutine;         MFprintinfo := printinfo;   
      MFresult := result;  
           DoSubCall( PARSERPROG );            msgnumber := MFmsgnumber;         whichroutine := MFwhichroutine;         printinfo := MFprintinfo;   
      result := MFresult;  
           END;     { WITH }      END;     { PrintPrompt }       $SUBTITLE 'PrintPrompt', PAGE $   PROCEDURE PrintPrompt     (    saveprompt:         Boolean;          promptstring:       PromptType;     VAR passed_result:      Int16);         BEGIN    { PrintPrompt }          initglobals.IG_whichguy := CPRINTPROMPT;          WITH globalstring DO         BEGIN    { WITH }             PPsaveprompt := saveprompt;         PPpromptstring := promptstring;         PPpassed_result := passed_result;             DoSubCall( PARSERPROG );            promptstring := PPpromptstring;         passed_result := PPpassed_result;             END;     { WITH }      END;     { PrintPrompt }       $SUBTITLE 'WordInput', PAGE $   
PROCEDURE WordInput  
   (    promptstring:       PromptType;     VAR default:            Boolean;      VAR string_of_tokens:   String;     VAR token_from_user:    String;     VAR passed_result:      Int16);     { Prompt user with promptstring; read input and make sure        it is one of the tokens in string_of_tokens            }  
   BEGIN    { WordInput }  
        initglobals.IG_whichguy := CWORDINPUT;   
   token_from_user := '';  
        WITH globalstring DO         BEGIN    { WITH }             WRpromptstring := promptstring;         WRdefault := default;         WRstring_of_tokens := string_of_tokens;         WRtoken_from_user := token_from_user;         WRpassed_result := passed_result;             DoSubCall( PARSERPROG );            promptstring := WRpromptstring;         default := WRdefault;         string_of_tokens := WRstring_of_tokens;         token_from_user := WRtoken_from_user;         passed_result := WRpassed_result;             END;     { WITH }       
   END;     { WordInput }  
     $SUBTITLE 'YesNoInput', PAGE $  
PROCEDURE YesNoInput 
   (    promptstring:       PromptType;     VAR default:            Boolean;      VAR yesnovalue:         OneCharType;      VAR passed_result:      Int16);     { Prompt user with promptstring; read a Y/N from the user }      
   BEGIN    { YesNoInput } 
        initglobals.IG_whichguy := CYESNOINPUT;  
   yesnovalue := ''; 
        WITH globalstring DO         BEGIN    { WITH }             YIpromptstring := promptstring;         YIdefault := default;         YIyesnovalue := yesnovalue;         YIpassed_result := passed_result;             DoSubCall( PARSERPROG );            promptstring := YIpromptstring;         default := YIdefault;         yesnovalue := YIyesnovalue;         passed_result := YIpassed_result;             END;     { WITH }       
   END;     { YesNoInput } 
     END.                 { Module parser } 