 $PASCAL '91790-1X185 REV.4010 <860228.1532> '   $STANDARD_LEVEL 'HP1000'  $debug$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 2   	$HEAP_DISPOSE OFF  	     MODULE pxpinit;   	$ALIAS 'N$pxpinit' 	         {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  {     NAME:   PXPINIT   
{     SOURCE: 91790-18185  
 	{     RELOC:  NONE 	 	{     PGMR:   EMS  	 {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {   Date      Prgmr  Description  {  2/28/86     lms   Initialize result in synpxp (n356).  {}        {}  {   {  This module contains the PXP initialization routines   {  for NSINIT.  {   {}      IMPORT     $SEARCH 'phtm/bodec.rel'      bodec,      $SEARCH 'phtm/SODEC.rel'      sodec,      $SEARCH 'phtm/mmdec.rel'      mmdec,      $SEARCH 'phtm/mmext.rel'      ds_mm,      $SEARCH 'phtm/trcmod.rel'     trcmod,     $SEARCH 'phtm/SIGMOD.rel'     sigmod,     $SEARCH 'phtm/init_dec.rel'     init_dec,     $SEARCH 'phtm/initmulti.xpt'      initmulti,      $SEARCH 'phtm/parsdd.xpt'     parser,     $SEARCH 'phtm/filemad.xpt'      fileman,      $SEARCH 'phtm/tmrdec.rel'     tmrdec,         $SEARCH 'phtm/tuser.rel'      tuser,          $SEARCH 'phtm/PXPLB.REL'      px;          $SUBTITLE ' Export procedures ', PAGE$      EXPORT      {--------------------------------------------------------}  {                                                        }  {          EXPORT   PROCEDURES                           }  {                                                        }  {--------------------------------------------------------}          	PROCEDURE SynCkPXP 	    (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);           
PROCEDURE ShutdnPXP  
    (    trustvar    : TrustType;      VAR result      : Int16);           	PROCEDURE InitPXP  	 
   (VAR px_ierr : Int16);  
         {----------------------------------------------------}  {               Implement Section                    }  {----------------------------------------------------}      IMPLEMENT       VAR      pxpgblk     : PXPListBufType;     maxentry    : Int16;           $SUBTITLE 'PXP Syntax Check routine',PAGE$  {-------------------------------------------}   {              SynCkPXP                     }   {-------------------------------------------}       	PROCEDURE SynCkPXP 	    (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);           {}  !{ Description: Get user input to PXP configuration items; perform  !  {   validity check on the inputs; returns DSAM Table size to the   {   caller.   {   { Parameters:   !{   dsamtbsize (output)    Rreturn number of word required for PXP ! {                          tables (paths, pcbs and globals).  {   socketcnt  (output)    Ignored, not used by PXP.  {   classcnt   (output)    Ignored, not used by PXP   {   rsncnt     (output)    Ignored, not used by PXP   {   smbsize    (output)    Ignored, not used by PXP   {   result     (output)    Set to zero if successfull.  #{                          Return 'SYNCKERRR' if user input is invalid # #{                          or error returned from the Syntax checker.  # {}          BEGIN {synckpxp}  { all other return parameters were cleared by the caller. }   result := GOOD;       {Initialize the tcp options to their defaults}  pxpgblk     := PXPLISTINIT;       {Get maximum number of connection from nodal resources }  IF initglobals.IG_tot_nodal_progs > 0 THEN     BEGIN     {Remember the max number of connections}      maxentry := initglobals.IG_tot_nodal_progs DIV 2 + 10;      dsamtbsize := maxentry * SIZEOFPXPPATH  + SIZEOFPXPLIST;          END  ELSE     BEGIN     result := ERRPXPNOPROGS;      END;   END;  {synckpxp}          $SUBTITLE 'PXP Shutdown module', PAGE$  {-------------------------------------------}   {              ShutdnPXP                    }   {-------------------------------------------}       
PROCEDURE ShutdnPXP  
    {    trustvar    : TrustType;      VAR result      : Int16};       {}  { Description: Module to be called by the AdvDS/1000 Shutdown   {    program; PXP does not require any system resources on its  {    own; so its shutdown procedure do nothing.   {   { Parameters:   {    trustvar   (input)  Indicates potential corruption of  {                        data structures. For PXP there no  {                        recovery and hence does not have   {                        to worry.  {   {    result     (output) Always returns successful.   {   {}      BEGIN {shutdown}  {Always return successfully}  result := 0;  END;  {shutdown}          $SUBTITLE 'Initialize PXP stuffs', PAGE$  {------------------------------------------------------------}  {               Pxp Initialization                           }  {------------------------------------------------------------}      	PROCEDURE InitPXP  	    {VAR px_ierr     : Int16};       {}  { The routine does the following:   {   {  1. Allocate pxp path structures.   {  2. Allocate pxp global record  {  3. Initialize path pointers in DSAM.   {  4. Create free list for the pxp path structures.   {   {  Parameters:  {   {     px_ierr      - Error if MM calls fails  {   
{ Global Parameter:  
 #{   initglobals.IG_tot_nodal_progs:  Max. number of DS programs in the # #{                            system. PXP uses the number to calculate  # {                            the size of its data structure.  {}      LABEL 44;       VAR      i           : Int16;      pathbuffer  : PxpPathRecType;     pxplistbuf  : PxpListBufType;     domainrec   : DomainRecord;     protorec    : ProtocolRecord;     pxp_wkmap   : Int16;       BEGIN { init }      DS_InitEnterCritical ( pxp_wkmap, px_ierr );  IF px_ierr <> SUCCESSFUL THEN GOTO 44;      {Get pxp control and path structures}   DS_GetTableSpace(DS_PXPLISTHDTD, 1, PXPLISTSIZE,                      SIZEOFPXPLIST, px_ierr);  IF px_ierr <> SUCCESSFUL THEN      BEGIN    { error getting tablespace }     DS_InitLeaveCritical( pxp_wkmap );      GOTO 44;      END;     { error getting tablespace }      
{Get PXP path structures}  
 DS_GetTableSpace(DS_PXPPathTD, 1, maxentry,                         SIZEOFPXPPATH, px_ierr);  IF px_ierr <> SUCCESSFUL THEN      BEGIN    { error getting tablespace }     DS_InitLeaveCritical( pxp_wkmap );      GOTO 44;      END;     { error getting tablespace }  {initialize the lists }   	WITH pxplistbuf DO 	    BEGIN         {Initialize tha pxp globals}      pxplistbuf := PXPLISTINIT;      DS_StoreElement(DS_PXPLISTHDTD, 1, pxplistbuf.int);         {initialize list pointers}      WITH pathbuffer DO         BEGIN         {initialize all path records}         pathbuffer := PXPPATHINIT;      
      {free path sentinel} 
 
      xp_fptr := f_phead;  
 
      xp_bptr := xp_fptr;  
       DS_StoreElement(DS_PXPPathTD, f_phead, pathbuffer.int);             {i_path sentinel}   
      xp_fptr := i_phead;  
 
      xp_bptr := xp_fptr;  
       DS_StoreElement(DS_PXPPathTD, i_phead, pathbuffer.int);             {d_path sentinel}   
      xp_fptr  := d_phead; 
 
      xp_bptr  := xp_fptr; 
       DS_StoreElement(DS_PXPPathTD, d_phead, pathbuffer.int);             {Initialize the path free list}         FOR i := PXPFPATHLISTHEAD + 1 TO maxentry DO           BEGIN {free path list}            InsertPXList(DS_PXPPathTD, f_phead, i);           END;  {free path list}         END;     END;       { Initialize PXP's protocol record.}      DS_FetchElement (DS_ProtosTD, HP_PXP, protorec.int);      WITH protorec DO     BEGIN  
   pr_rnd := RND_OUTBOUND; 
    pr_services.bits[REQUEST] := TRUE;      pr_maxmsglen := MAX_USER_BYTES;  
   pr_default_incc := 100; 
    pr_default_outcc := 100;      pr_default_timeout := 0; {don't know yet}     END; {WITH protorec}       DS_StoreElement (DS_ProtosTD, HP_PXP, protorec.int);      { Modify the HPDSN domain record to reflect PXP's role within}  { the domain.                                                }      DS_FetchElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);      	WITH domainrec DO  	    BEGIN     dr_memberpids.bits[HP_PXP] := TRUE;     END; {WITH domainrec}      DS_StoreElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);       { Update the SReg protocol record to reflect the fact that PXP}     { is one of SReg's direct supporters.                         }        DS_FetchElement ( DS_ProtosTD, SREG, protorec.int);   protorec.pr_supportingpids.bits[HP_PXP] := TRUE;  DS_StoreElement (DS_ProtosTD, SREG, protorec.int);  { Bind PXP to socket registry.  If Sreg ever supports other       protocols this will have to change.                        }    SregBinding;      DS_InitLeaveCritical ( pxp_wkmap );       44:           END; { init }       END   .  