 $PASCAL ',7 91790-1X193 REV.4010 <840712.1759>'$  
$STANDARD_LEVEL 'HP1000'$  
 $debug$   $HEAPPARMS OFF$   $RECURSIVE OFF$   $RANGE OFF$   $HEAP 0$  	$HEAP_DISPOSE OFF$ 	     MODULE rrib;  $ALIAS 'N$RRIB'       $TITLE 'MODULE Description',PAGE$   {}  {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  
{      NAME:   RRIB  
 
{      SOURCE: 91790-18193 
 
{      RELOC : NONE  
 	{      PGMR  : DGA 	 {}  ${----------------------------------------------------------------------- $ { MODIFICATIONS   {   {    date  Prgmr  Description   {   { 12/20/84  dga   improved error logger messages;   { 06/24/85  mcl   Fix bug on Kill Indication Handling.  { 07/18/85  rm    Added triggers  { 07/29/85  rm    Conmverted Send_Event to Log_Event  "{ 08/27/85  rm    Replaced dst_adr with src_adr and set it properly  " !{                 for Fetch_NRV_Router call to pass the right path ! {                 reference to IP.  { 09/03/85  RM    Used negative char length when logging ASCII  { 09/03/85  RM    CCP'ed test variables   { 09/03/85  RM    log mbuf_ptr as contextword where applicable  { 09/12/85  RM    Leave critical when status indication   %{ 09/19/85  RM    Initialize the event handler port id at kill indication  %  { 09/26/85  RM    Call LogEvent first thing after going critical   { 12/16/85  RM    Modified Log_event context word   ${----------------------------------------------------------------------- $ {}  
{ MODULE DESCRIPTION 
 {   {    This module contains the Rerouter inbound routines and   {    global variables.  {   {}  $TITLE 'IMPORT Section',PAGE$       IMPORT         $SEARCH 'phtm/BODEC.REL'$     bodec,      $SEARCH 'phtm/SODEC.REL'$     sodec,      $SEARCH 'phtm/MMDEC.REL'$     mmdec,      $SEARCH 'phtm/MMEXT.REL'$     ds_mm,      $SEARCH 'phtm/TRCMOD.REL'$      TRCMOD,     $SEARCH 'phtm/LKLB.REL'$      lk,     $SEARCH 'phtm/RRDEC.REL'$     rrdec;           $TITLE 'Export Section',PAGE$       %{------------------------------------------------------------------------} %     %{             Export Section                                             } % %{------------------------------------------------------------------------} %     EXPORT      PROCEDURE RRIB     (    e_msg      : EventMsgType;      VAR ierr       : Int16        );      PROCEDURE INSTUB     (    e_msg      : EventMsgType;      VAR ierr       : Int16        );          $TITLE 'Global variables',PAGE$       &{--------------------------------------------------------------------------} & &{             Global Variables                                             } & &{--------------------------------------------------------------------------} &     IMPLEMENT       CONST   "   { Length of the router header not including the local appendage } "    RH_LEN_WO_LOCAL_AP = RH_LEN_BYTES - LOCAL_APNDGE_LEN_BYTES;  &   RRIB_DUMPBUFFER              = 257;       { Location code for Log_Event } & &   RRIB_INSTUB_1                = 258;       { Location code for Log_Event } & &   RRIB_INSTUB_2                = 259;       { Location code for Log_Event } & &   RRIB_READROUTERHEADER_1      = 260;       { Location code for Log_Event } & &   RRIB_READROUTERHEADER_2      = 261;       { Location code for Log_Event } & &   RRIB_RRIB_1                  = 262;       { Location code for Log_Event } & &   RRIB_RRIB_2                  = 263;       { Location code for Log_Event } & &   RRIB_RRIB_3                  = 264;       { Location code for Log_Event } & &   RRIB_RRIB_4                  = 265;       { Location code for Log_Event } & &   RRIB_RRIB_5                  = 266;       { Location code for Log_Event } & &   RRIB_ENTRY                   = 267;       { Location code for Log_Event } &         VAR   $   src_adr        : Int16; { Holder for router source addresses       }  $ $   err            : Int16; { General error parameter.                 }  $ $   log_pac        : AscType;     { String for the error logger.       }  $ $   mbuf_ptr       : Int16; { Pointer to the data in DSAM              }  $ $   mm_flags       : MMFlagsType; { Options parameter for DS_MRead call}  $ $   path_ref       : Int16; { Index returned from FetchNRVRouter       }  $ $   pathref        : contextwords; { Used by Log_Event                  } $ $   ps_err         : Int16; { Error parameter for ProSw                }  $ $   recv_request   : BOOLEAN; { Indicates if msg was request or reply  }  $ $   rhdr_offset    : Int16; { Offset in msg where router header starts }  $ $   router_header  : RouterHeaderType;  { Holder var for router header }  $ $   rr_msg         : AscType;      { Contains the emsg sent to the ulp }  $ $   rr_wkmap       : Int16; { Holds state of working map for dsam calls}  $ $   temp3          : Temp3Type; { general var used for type conversion }  $     $TITLE 'Forward Declarations',PAGE$       %{-----------------------------------------------------------------------}  % %{             Forward Declarations                                      }  % %{-----------------------------------------------------------------------}  %     PROCEDURE Cnumd      (     number     : Int16;       VAR string     : Pac6 );       EXTERNAL;       PROCEDURE DumpBuffer;       FORWARD;      PROCEDURE ExtractErrFromHeader;       FORWARD;      PROCEDURE FetchNRVRouter         $ALIAS 'Fetch_NRV_Router'$      (      node          : Int16;       VAR  nrv_entry     : NrvEntryType;        VAR  nrv_index     : Int16;       VAR  err           : Int16 );       EXTERNAL;          PROCEDURE ProSw      ( VAR e_msg     : EventMsgType;       VAR error     : Int16 );        EXTERNAL;          
PROCEDURE ReadRouterHeader 
    ( VAR  rtn_err  : Int16 );       FORWARD;              
$TITLE 'Procedures',PAGE$  
     %{------------------------------------------------------------------------} % %{             Procedures                                                 } % %{------------------------------------------------------------------------} %         
$TITLE 'DumpBuffer',PAGE$  
     %{------------------------------------------------------------------------} % %{             DumpBuffer                                                 } % %{------------------------------------------------------------------------} %     PROCEDURE DumpBuffer;       {}  { Description   {    Disposes of an inbound message in dsam.  {   { Global variables   :  rr_wkmap  {                       mbuf_ptr  {                       log_str   {}  VAR      ds_err  : Int16;    { error parm for dsam calls   }      BEGIN  { DumpBuffer }   DS_MDispose(mbuf_ptr,ds_err);   
IF  ds_err <> NO_ERR  THEN 
    BEGIN     temp3.chars  := 'RRIB : DS_MDispose error ';      log_pac.emsg := temp3.emsg;     pathref.longint := ds_err ;     Log_Event(EL_ERROR,RR_PID,RRIB_DUMPBUFFER,pathref,                 -MAX_LOG_LEN_BYTES,log_pac.bufr,err);      END;       
END;  { Dumpbuffer } 
             $TITLE 'ExtractErrFromHeader',PAGE$       %{------------------------------------------------------------------------} % %{             ExtractErrFromHeader                                       } % %{------------------------------------------------------------------------} %     PROCEDURE ExtractErrFromHeader;       {}  { Description   {    This routine looks at the router header and maps the   {    error code returned in the header to a string to be  {    output to the error logger.  {   { Global variables   :  router_header   {                       log_pac   {}  TYPE     TempType1 = RECORD         CASE  BOOLEAN  OF            FALSE:  (  tp_pac6  :  Pac6                 );            TRUE :  (  tp_word3 :  ARRAY[1..3] OF Int16 );         END;  { record }      VAR      temp1     :  TempType1; { temporary var }          BEGIN  { ExtractErrFromHeader }       { Send the following to the logger :    }   { ecode1/ecode2/qual word/reporting node}   temp3.chars := '         Reporting node =         ';      WITH  router_header  DO   	   BEGIN  { with } 	    temp3.emsg.words[1] := rh_ecode1;     IF  rh_rep_node_no.rn_sign_bit = 1  THEN         BEGIN  { ecode2 is ascii }        temp3.emsg.words[3]   := rh_ecode2;         END    { ecode2 is ascii }     ELSE         BEGIN  { ecode2 is numeric }        Cnumd(rh_ecode2,temp1.tp_pac6);         temp3.emsg.words[2]   := temp1.tp_word3[2];         temp3.emsg.words[3]   := temp1.tp_word3[3];         END;   { ecode2 is numeric }         { Put error qual word to log string  }      Cnumd(rh_qual_wd.qw_err_qual,temp1.tp_pac6);      temp3.emsg.words[4] := temp1.tp_word3[3];         { Put reporting node no to log string }     Cnumd(rh_rep_node_no.rn_node_no,temp1.tp_pac6);     temp3.emsg.words[14] := temp1.tp_word3[1];      temp3.emsg.words[15] := temp1.tp_word3[2];      temp3.emsg.words[16] := temp1.tp_word3[3];   	   END;  { with }  	      log_pac.emsg := temp3.emsg;      END;  { ExtractErrFromHeader }          $TITLE 'InStub',PAGE$       &{--------------------------------------------------------------------------} & &{             InStub                                                       } & &{--------------------------------------------------------------------------} &     PROCEDURE InStub     {     e_msg     : EventMsgType;       VAR ierr      : Int16         };       {}  { Description   #{    This procedure should not be called. It is used only as an entry  # "{    point for OUTPROSW. It would only be called by by a faulty LLP. " {}  LABEL     99 ;      VAR     err   : Int16;      BEGIN   DS_EnterCritical(rr_wkmap,err);       
IF err <> 0 THEN GOTO 99;  
     CASE e_msg.em_event OF      
   KILL_INDICATION:  
       BEGIN         { Format a kill indication.       }         rr_msg.emsg.ehport          := IPIB_INDEX;        rr_msg.emsg.em_event        := KILL_INDICATION;         rr_msg.emsg.emki_down_ref   := path_ref;        rr_msg.emsg.emki_down_pid   := RR_PID;        rr_msg.emsg.emki_reason     := RR_UNSUCCESSFUL_SEND;            pathref.longint := path_ref ;         Log_Event(EL_ERROR,RR_PID,RRIB_INSTUB_1,pathref,                KILL_IND_LEN,rr_msg.bufr,err);                { Send the event msg.                }        DS_LeaveCritical(rr_wkmap);         ProSw(rr_msg.emsg,ps_err);        END;         STATUS_INDICATION:         BEGIN         DS_LeaveCritical(rr_wkmap);         END;         OTHERWISE        BEGIN         temp3.chars  := 'Router InStub received spurious emsg';         log_pac.emsg := temp3.emsg;         pathref.longint := e_msg.em_event ;         Log_Event(EL_ERROR,RR_PID,RRIB_INSTUB_2,pathref,                -MAX_LOG_LEN_BYTES,log_pac.bufr,err);         DS_LeaveCritical(rr_wkmap);         END;     END; {case}  99: { exit }  END;      $TITLE 'ReadRouterHeader',PAGE$       %{------------------------------------------------------------------------} % %{             ReadRouterHeader                                           } % %{------------------------------------------------------------------------} % 
PROCEDURE ReadRouterHeader 
    { VAR rtn_err  : Int16  };       {}  { Description   {    This routine reads the router header from dsam and then  {    strips it from the message.  {   { Parameters  {    rtn_err   < output >   Error return     0 = NO_ERROR   #{                                            x = memory manager error  # { Global variables   :  mm_flags  {                       log_str   {                       rr_wkmap  {                       router_header   {                       mbuf_ptr  {                       rhdr_offset   {                       recv_request  {                       src_adr   {}  LABEL      99;      VAR   "   dummy     : Int16 ;       { for triggers                        } "     
BEGIN { ReadRouterHeader } 
 rtn_err          := NO_ERR;   
mm_flags.bits[0] := TRUE;  
        { The following change might be made }      { for performance reasons if the mem }      { manager is changed to support it:  }      { ie destructive reads from the tail }      { of a message                       }      { mm_flags.bits[0] := FALSE;         }      { use same DS_MRead call             }      {   delete DS_MAdj call              }       { read but do not strip the header  }   DS_MRead(router_header.int,RH_LEN_WO_LOCAL_AP,           mbuf_ptr,rhdr_offset,mm_flags,rtn_err);          
IF rtn_err <> NO_ERR  THEN 
    BEGIN     temp3.chars  := 'RRIB : DS_MRead error ';     log_pac.emsg := temp3.emsg;     pathref.longint := rtn_err ;      Log_Event(EL_ERROR,RR_PID,RRIB_READROUTERHEADER_1,pathref,                 -MAX_LOG_LEN_BYTES,log_pac.bufr,err);      GOTO 99;      END;       { strip the header from the tail of the msg }   DS_MAdj(mbuf_ptr,-RH_LEN_WO_LOCAL_AP,rtn_err);  IF  rtn_err <> NO_ERR  THEN      BEGIN     temp3.chars  := 'RRIB : DS_MAdj error ';      log_pac.emsg := temp3.emsg;     pathref.longint := rtn_err ;      Log_Event(EL_ERROR,RR_PID,RRIB_READROUTERHEADER_2,pathref,                 -MAX_LOG_LEN_BYTES,log_pac.bufr,err);      GOTO 99;      END;       { Get destination adr. from header.  }  IF  router_header.rh_stream_wd.sw_rply_flag = 1  THEN   
   BEGIN  { reply }  
    src_adr      := router_header.rh_dst_node_no;  
   recv_request := FALSE;  
 	   END   { reply } 	 ELSE  
   BEGIN { request } 
    src_adr      := router_header.rh_src_node_no;     recv_request := TRUE;  
   END;  { request } 
     99:   
END;  { ReadRouterHeader } 
         
$TITLE 'RRIB',PAGE$  
     %{------------------------------------------------------------------------} % %{                    RRIB                                                } % %{------------------------------------------------------------------------} %     PROCEDURE RRIB     {    e_msg    : EventMsgType;      VAR rrib_err : Int16 };       {}  { Description   %{    This is the router line inbound routine. It serves to accept messages % %{    from INPRO dispather, strip the DS/1000 header, and pass the message  % &{    to the ulp. All messages arrive already in DSAM. Most messages received & &{    are requests. If replies are received, the error code in the header is  & &{    passed in a kill indication to the ulp since replies are never sent by  & ${    the ADS router outbound module. These event messages are supported: $ {   "{    input   DATA_INDICATION               output   DATA_INDICATION  " "{                                                   KILL_INDICATION  " {   { Parameters  {    e_msg     <input>   event message type sent by ProSw   {   {    rrib_err  <output>  error code returned to ProSw   {   { Global variables   :  rr_wkmap  {                       mbuf_ptr  {                       rhdr_offset   {                       path_ref  {                       src_adr   {                       rr_msg  {                       log_pac   {                       ps_err  {}      LABEL      99;      VAR   #   nrv_entry : NrvEntryType; { parameter for FetchNRVRouter call     } # #   rtn_err   : Int16;     { general error return for procedures      } #         PROCEDURE Exit;   {}     BEGIN     GOTO 99;      END;           BEGIN { RRIB }  	rtn_err := NO_ERR; 	 DS_EnterCritical(rr_wkmap,rtn_err);   
IF rtn_err <> NO_ERR  THEN 
    BEGIN     Exit;     END;           pathref.longint := 0 ;  Log_Event(EL_EVENT,RR_PID,RRIB_ENTRY,pathref,                  EMSG_WORD_LEN,e_msg.int,err);          WITH  e_msg  DO      BEGIN { with e_msg }              CASE  em_event  OF             DATA_INDICATION:           BEGIN  { data }           { Initialize variables                   }            mbuf_ptr     := emdi_mbufid;            rhdr_offset  := emdi_dlen - RH_LEN_WO_LOCAL_AP;                   { Read and strip router header and local }            { apppendage from the dsam msg.          }            ReadRouterHeader(rtn_err);            IF  rtn_err <> NO_ERR  THEN  	            BEGIN  	             DumpBuffer;               DS_LeaveCritical(rr_wkmap);   	            Exit;  	             END;                   { See if there is a valid path for this msg. }            FetchNRVRouter(src_adr,nrv_entry,path_ref,rtn_err);           { This variable is used by Log_Event }            pathref.longint := path_ref ;                       IF  rtn_err <> NO_ERR  THEN  	            BEGIN  	             { The router address was not found }              DumpBuffer;               temp3.chars  := 'RRIB : NRV node not found error';              log_pac.emsg := temp3.emsg;               pathref.longint := src_adr ;              Log_Event(EL_WARNING,RR_PID,RRIB_RRIB_1,pathref,                       -MAX_LOG_LEN_BYTES,log_pac.bufr,err);              DS_LeaveCritical(rr_wkmap);   	            Exit;  	             END;                   { Format an event msg for the ulp.    }           rr_msg.emsg.ehport := IPIB_INDEX;           IF  recv_request  THEN               BEGIN  { request }              { Format a data indication.        }              rr_msg.emsg.emdi_up_ref     := -1;              {rr_msg.emsg.emdi_src_addr  := not used }               {rr_msg.emsg.emdi_dst_addr  := not used }               rr_msg.emsg.em_event        := DATA_INDICATION;               rr_msg.emsg.emdi_down_ref   := path_ref;              rr_msg.emsg.emdi_down_pid   := RR_PID;              rr_msg.emsg.emdi_mbufid     := e_msg.emdi_mbufid;               rr_msg.emsg.emdi_dlen       := rhdr_offset;                   END  { request }           ELSE               BEGIN  { reply }                  { Format a kill indication.       }               rr_msg.emsg.ehport          := IPIB_INDEX;              rr_msg.emsg.em_event        := KILL_INDICATION;               rr_msg.emsg.emki_down_ref   := path_ref;              rr_msg.emsg.emki_down_pid   := RR_PID;               rr_msg.emsg.emki_reason     := RR_UNSUCCESSFUL_SEND;                   { dispose inbound msg }               DumpBuffer;                   { Log the kill indication and reason   }              pathref.longint := path_ref ;               Log_Event(EL_WARNING,RR_PID,RRIB_RRIB_2,pathref,                       KILL_IND_LEN,rr_msg.bufr,err);                   { Log the actual dsxx error received in }               { the reply header.                     }               ExtractErrFromHeader;               Log_Event(EL_WARNING,RR_PID,RRIB_RRIB_3,pathref,                       -MAX_LOG_LEN_BYTES,log_pac.bufr,err);              END;  { reply }                { Send the event msg.                }            DS_LeaveCritical(rr_wkmap);           ProSw(rr_msg.emsg,ps_err);         END;   { data }             KILL_INDICATION:           BEGIN           { Format a kill indication.       }           rr_msg.emsg.ehport          := IPIB_INDEX;            rr_msg.emsg.em_event        := KILL_INDICATION;           rr_msg.emsg.emki_down_ref   := path_ref;            rr_msg.emsg.emki_down_pid   := RR_PID;            rr_msg.emsg.emki_reason     := RR_UNSUCCESSFUL_SEND;                    pathref.longint := path_ref ;           Log_Event(EL_WARNING,RR_PID,RRIB_RRIB_4,pathref,                     KILL_IND_LEN,rr_msg.bufr,err);               { Send the event msg.                }            DS_LeaveCritical(rr_wkmap);           ProSw(rr_msg.emsg,ps_err);            END;             STATUS_INDICATION:           BEGIN           DS_LeaveCritical(rr_wkmap);           END;                 OTHERWISE            BEGIN  { unknown }            temp3.chars  := 'RRIB : Invalid emsg  ';            log_pac.emsg := temp3.emsg;           pathref.longint := em_event ;           Log_Event(EL_ERROR,RR_PID,RRIB_RRIB_5,pathref,                     -MAX_LOG_LEN_BYTES,log_pac.bufr,err);            DS_LeaveCritical(rr_wkmap);  
         END;  { unknown } 
           END;  { end case }     END;  { with e_msg }       99: ;   END;  { RRIB }      END.  { RRIB module }      