 $PASCAL ',7 91790-18196 REV.4010 <860404.1434> '  $STANDARD_LEVEL 'HP1000'  $DEBUG$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 2   	$HEAP_DISPOSE OFF  	 $AUTOPAGE ON$   $CODE_INFO ON $   	$CODE_OFFSETS ON$  	     MODULE RTRINIT;   	$ALIAS 'N$RTRINIT' 	     {------------------------------------------------------------     (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS   RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {   {   {        NAME:   RTRINIT  {        SOURCE: 91790-18196  {        RELOC:  NONE   
{        PGMR:   RM  
 {   {   {-------------------------------------------------------------  {   { Modifications:  {   {     Date     Prgmr Description  {   %{     850506   RM    Should not try to build the Cost Matrix if there are  % {                    no rerouting links   {   {     850715   RM    Modified the error mesages   ${     850715   RM    Modified code to disable all the links at shutdown  $ ${     850828   RM    Modified code to handle default ma timeout properly $ !{     851107   RM    Modified code to shutdown convertors always.  ! %{     851107   RM    Modified code to print a better message if lu is not  % {                    driver 66.   {     851107   RM    Modified value of BIT13TO8 to 16128.   {     851218   lms   Be critical when checking nonrr TD.   {     860103   RM    Continue when encounter a non driver 66 lu    &{                    Verify the IP address of remote nodes is not one of the & {                    local IP adresses.   {     860208   lms   NSINIT program coalescence (n345).   !{     860219   lms   Delete error strings, put them in NSINIT.MSG. ! %{                    Call Disconnect_LU, enhance shutdown error reporting. % {                    (n356).  !{     860312   lms   Delete Driver 64 code that was commented out. ! !{                    Call CheckDriverType instead of in-line code. ! #{                    Correct spacing in Strwrites for error messages.  # {                    Set NoSuspend bit in LuStatus calls.   "{                    Call CheckXLUEXCall, HandleAbortReturn (n370).  " {     860320   lms   To abort on Wrong Driver for LUs (n370).   {   #{     860402   RM    Reset the lu field in NRV entry to 0 if the link  # #{                    is enabled as rerouting (n405 - 2626 - sr# 35212) # {-------------------------------------------------------------  {   {   ${ This module is used by NSINIT to initialize the router tables in DSAM  $ {   {}      
$TITLE ' Import Section '$ 
         IMPORT  $SEARCH 'phtm/BODEC.rel'     bodec,   $SEARCH 'phtm/SODEC.rel'     sodec,   $SEARCH 'phtm/mmdec.rel'     mmdec,   $SEARCH 'phtm/MMext.rel'     ds_mm,   
$SEARCH 'phtm/trcmod.rel'  
    trcmod,  
$SEARCH 'phtm/sigmod.rel'  
    sigmod,  
$SEARCH 'phtm/tmrdec.rel'  
    tmrdec,  $SEARCH 'phtm/tuser.REL'     tuser,   $SEARCH 'phtm/lklb.rel'      lk,  $SEARCH 'phtm/ipui.rel'      ipui,  $SEARCH 'phtm/iplib.rel,phtm/ipdec.rel,phtm/ipdb.rel'      iplib,   $SEARCH 'phtm/init_dec.rel'      init_dec,  $SEARCH 'phtm/initmulti.xpt'     initmulti,   
$SEARCH 'phtm/parsdd.xpt'  
    parser,  
$SEARCH 'phtm/filemad.xpt' 
    fileman,   $SEARCH 'phtm/dres.xpt'      dres,  $SEARCH 'phtm/lan8.xpt'      lan8,  $SEARCH 'phtm/lanui.xpt'     lanui,   $SEARCH 'phtm/init_rte_if.xpt'     init_rte_if,   
$SEARCH 'phtm/laninit.xpt' 
    laninit,   
$SEARCH 'phtm/ipinit.xpt'  
    ipinit,  
$SEARCH 'phtm/strrout.xpt' 
    Strrout;       $TITLE ' Export procedures ', PAGE$       EXPORT      {------------------------------------------------------------}  {             E X P O R T    P R O C E D U R E S             }  {------------------------------------------------------------}          	PROCEDURE InitRTR  	    (VAR result : Int16);          	PROCEDURE InitNRV  	    (VAR result : Int16);          	PROCEDURE ShutNRV  	    (    trustvar    : TrustType;      VAR result      : Int16);           	PROCEDURE ShutRTR  	    (    trustvar    : TrustType;      VAR result      : Int16);           PROCEDURE SynNRV     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);           PROCEDURE SynRTR     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);       $TITLE ' Type Declarations ', PAGE$       {------------------------------------------------------------}  {            I M P L E M E N T    S E C T I O N              }  {------------------------------------------------------------}      IMPLEMENT       CONST          BAD_LU_MSG  =  !      '** (303) Link: Specified LU is not a driver 66. LU is: ' ;  !    ENABLE_LU_ERR_MSG  =   "      '** (311) NSINIT: Error enabling RTR link.  Driver Reports:';  "    STAT_LU_ERR_MSG1   = '** (325) Link: Error ' ;      STAT_LU_ERR_MSG2   = ' accessing LU ';      END_OF_ERR_MSG     = ' (XLUEX). **';      BIT13TO8                  =  16128 ;      CVTSNEEDEDCLASSNUMBERS    = 2 ;    { INCNV , OTCNV }      CVTSNEEDEDRESOURCENUMBERS = 0 ; { INCNV , OTCNV }     DEFCOST                   =  1 ;      DEFIPADDRESS              =  0 ;      DEFLU                     =  0 ;      DEFLURR_NR                =  TRUE ;    { ROUTER }     DEFLUSTATUS               =  TRUE ;     DEFLUTIMEOUT              =  0 ;      DEFMABIT                  =  FALSE ;    { NO MA }     DEFMARETRYLIMIT          =  4 ;     DEFMATIMEOUT             =  3 ;     DEFMSGLEVEL              =  1 ;     DEFNEIGHBORBIT           =  FALSE ;    { NOT A NEIGHBOR }     DISABLERQST              =  1600 ;   { 3100B }      DRIVER64                 =  52;     DRIVER65                 =  53;     DRIVER66                 =  54;     DRIVER67                 =  55;     DUPLICATELU              =  10 ;  {*** ?! ***}      ENABLE_INDCTR            =  'E';      ENABLELISTENRQST         =  1536 ;   { 3000B }      EXEC13                   = -32755 ;  { 100015b}     EXEC20                   = -32748 ;  { 100024b}     GRPMNEEDEDCLASSNUMBERS   = 1 ;      ICANHANDLEIT      =   1 ; {*** ?! ***}      INVALID           =  -1 ;     INVALIDIPADDRESS  =  77 ;     INITCOST          =  32767 ;      LINK_LU_PROMPT    =  '* Link:_';      LOCAL_NODE_BANR   =  &          '* Enter the Router/1000 address of the local node.[1..32767]:_';  &    LOWERBYTE         = 255;      LVELEMENTSIZE            =  6;      MA_INDCTR         =  'MA';      MAELEMENTSIZE            =  10;   {words}     MANEEDEDCLASSNUMBERS = 1 ;  { MAHC }      MANEEDEDRESOURCENUMBERS = 1 ;  { MARN }  &   MARETRYLIMITPROMPT       = '* Enter the MA retry limit [1..(4)..13]:_' ;  &    MATIMEOUTLIMIT    =  3 ;    { in seconds }      MAXCOST           =  99;      MAXPOSINT8        =  256;     MAXLU             =  255;     MAXLUTIMEOUT      =  255;     MAXMATIMEOUT      =  32767;    {*** ?! ***}  
   MAXMSGLEVEL       =  1; 
    MAXMARETRYLIMIT   =  13;      MAXRTRADDR        =  32767;     MAXRRLINKS        =  20;   
   MINCMINDEX        =  1; 
 
   MINCOST           =  1; 
 
   MINIPADDR         =  1; 
 
   MINLU             =  1; 
 
   MINLUTIMEOUT      =  1; 
 
   MINLVINDEX        =  1; 
 
   MINMAINDEX        =  1; 
 
   MINMARETRYLIMIT   =  1; 
 
   MINMATIMEOUT      =  1; 
 
   MINMSGLEVEL       =  0; 
 
   MINNONRRINDEX     =  1; 
 
   MINNRVINDEX       =  1; 
 
   MINRTRADDR        =  1; 
 
   NEEDEDCLASSNUMS   =  4; 
 
   NEEDEDRESOURCENUMS=  1; 
    NEIGHBOR_INDCTR   =  'N';     NOMATICERROR      =  12 ;   {**** get it from lissa *****}      NONRRELEMENTSIZE  =  2;    {words}   !   NOTINNONRRMSG     = '** (309) Link: Bad non rerouting LU **' ;  !    NOT_ENABLE_INDCTR = 'NE' ;      NOT_RR_INDCTR    = 'NR' ;     NOTUSED           = 0  ;      NRV_PROMPT        =  '*NRV:_';      NRVELEMENTSIZE           =  5;    {words}  
   NS_MSG_LEVEL      =  1; 
    ONCEEVERYSECOND   =  1 ;      PASSWORD          =  17491 ;  { DS }      PRINTERR          =  TRUE;      RRNEEDEDCLASSNUMBERS = 0 ;      RRNEEDEDRESOURCENUMBERS = 0 ;     RR_INDCTR        =  'RR';  
   SECONDSUNIT       = 2 ; 
    SOON                = -1 ;      UPLINETICCONVFACTOR = 5 ;         BADIPLU        =       INIT_RTR_ERROFFSET + 0;      BADLINKTYPE    =       INIT_RTR_ERROFFSET + 1;      BAD_LEVEL      =       INIT_RTR_ERROFFSET + 2;      BAD_MA         =       INIT_RTR_ERROFFSET + 4;      BAD_NEIGHBOR     =     INIT_RTR_ERROFFSET + 5;      DUP_IP_ADDR    =       INIT_RTR_ERROFFSET + 6;      DUP_RTR_ADDR   =       INIT_RTR_ERROFFSET + 7;      DUPLUERR       =       INIT_RTR_ERROFFSET + 8;      NOTINNONRR     =       INIT_RTR_ERROFFSET + 9;          LINK_ERROR_OFFSET =    INIT_RTR_ERROFFSET + 12 -1;      NRV_ERROR_OFFSET =     INIT_RTR_ERROFFSET + 16 -1;       CONST      LASTRTRBANNER = 3;       TYPE     RtrBannerType = Array[1..LASTRTRBANNER] OF IStringType;      CONST      RTRBANNER = RtrBannerType[         IStringType['*'],         IStringType['*++      Router/1000      ++*'],         IStringType['*']];      $TITLE ' Type Declarations ', PAGE$           TYPE      $SUBTITLE ' Miscelaneous ',PAGE$  %{-----------------------------------------------------------------------}  % %{     Miscelaneous Type declarations                                    }  % %{-----------------------------------------------------------------------}  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  %        FourPCharType = Packed Array[1..4] OF Char;         Bits15to10 = PosInt6;     Bits1to0   = PosInt2;          $SUBTITLE 'Cost Matrix',PAGE$   %{-----------------------------------------------------------------------}  % %{     Type declarations for Cost Matrix                                 }  % %{-----------------------------------------------------------------------}  %     %{ Cost  Matrix (CM) is a 2-dimensional matrix which gives the "cost"    }  % %{ value to each destination ( router addresses in NRV) over all possible}  % %{ outgoing rerouting links ( lu's in the Link Vector )                  }  % %{ Each entry is two words long . The first word is cost value and the   }  % %{ second word is the hop count to the destination node from this node.  }  %         #   CmType    =  RECORD                   { one entry in a row of CM }  #                 cm_cost     :  Int16;    { cost to get there }  $                cm_hops     :  Int16;    { number of hops to get there } $ 
                END; 
     "   CmRecord  =  RECORD                    { one row of Cost Matrix } "                 CASE  Int16  OF                     1: ( cmrowint : Int16);   #                  2: ( cmrow    : ARRAY [1 .. MAXRRLINKS] OF CmType);  # 
                END; 
         $SUBTITLE 'Link Vector',PAGE$   %{-----------------------------------------------------------------------}  % %{     Type declarations for Link Vector                                 }  % %{-----------------------------------------------------------------------}  % %{                                                                       }  % %{ The Link Vector is used to store status information about rerouting   }  % %{ links.                                                                }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  %     LvLinkType       =  ^LvList;          { pointer to LV list }        !   LvType    =  PACKED RECORD             { LV entry consist of: } ! #                lv_stat         :  Posint1;     { staus of the link }  # #                lv_rsvd         :  Int7;        { reserved word     }  # #                lv_lklu         :  PosInt8;     { LU number         }  # #                lv_lkcost       :  Int16;       { cost for the LU   }  # #                lv_systime      :  Int32;       { system time       }  # $                lv_updnctr      :  Int16;       { link up/down counter } $ #                lv_nbr_node     :  Int16;       { neighbor node     }  # 
                END; 
     { LvList is a queue in EMA which holds the link vector en-   }  { tries.  This list is built by InitRtr during the link      }  { enable question in NSINIT.                                 }      !   LvList    =  RECORD                         { LV list entry:  } ! !                ll_lv        :  LvType;        { LV entry        } ! !                ll_enable    :  Boolean;       { enable indicator} ! $                ll_fptr      :  LvLinkType;    { pointer to next entry } $ 
                END; 
     $SUBTITLE 'Non Rerouting Table ',PAGE$  %{-----------------------------------------------------------------------}  % %{     Type declarations for Non Rerouting Table                         }  % %{-----------------------------------------------------------------------}  % %{                                                                       }  % %{  This table contains non rerouting links and their neighbor nodes     }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % "   NonRrLinkType    =  ^NonRrList;       { pointer to NON_RR list }  "     '   NonRrType  = PACKED RECORD                        { N_RR entry consist of:} ' &                nr_dummy              :  Int8;       { not initialized     } & &                nr_lu                 :  PosInt8;    { LU number           } & &                nr_nbr_node           :  Int16;      { neighbor node number} & 
                END; 
     {  NonRrList is a queue in EMA which holds the non-rerouting }  {  link LUs.                                                 }      &   NonRrList  = RECORD                               { NON_RR list entry :}  & &                nrl_nonrr             : NonRrType;       { N_RR entry     }  & &                nrl_enable            : Boolean;         { enable indicator} & &                nrl_fptr              : NonRrLinkType;   { pointer to next } & 
                END; 
     &   NonRrRec   = RECORD          { to be able to access to it as an integer } &                   CASE Int16 OF                        1: (nonrrint : Int16);                        2: (nonrrbuf : NonRrType);   
                END; 
     $SUBTITLE 'NRV and MA ',PAGE$   %{-----------------------------------------------------------------------}  % %{     Type declarations for  NRV and MA                                 }  % %{-----------------------------------------------------------------------}  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % !   NrvMaLinkType    =  ^NrvMaList;       { pointer to NRVMA list } !        MaWd3to10 =  PACKED ARRAY [3..10] OF Int16;      {  MaType is a packed record so that individual fields may be}  {  accessed but the precise number of words are stored into  }  {  an MA table entry.  Only the router address (word one)    }  {  and the MA timeout field in word two need to be initial-  }  {  ized with user inputs; all the other words have constant  }  {  values placed in them at initialization.                  }      $   MaType    =  PACKED RECORD                        { MA list entry: }  $ $                ma_rtr_addr          :  Int16;       { router address }  $ $                ma_wd2_upperbits     :  Bits15to10;  { not initialized}  $ $                ma_wd2_matimeout     :  PosInt8;     { TMAX           }  $ '                ma_wd2_state         :  Bits1to0;    { state of the MA chnl.}  ' '                ma_word3thru10       :  MaWd3to10;   { the rest of the table}  ' 
                END; 
     { Check the LU timeout field.  It may not really be the link }  { timeout but something else.                              }         NrvType    = PACKED RECORD         { NRV entry format: }   &                nrv_rtr_addr          :  Int16;     { router address       } & &                nrv_lu_tout           :  PosInt8;   { LU timeout           } & &                nrv_rsvd1             :  Int4;      { reserved             } & &                nrv_msg_lev           :  PosInt4;   { message level (0/1)  } & &                nrv_chgbit            :  Posint1;   { used by rerouting    } & &                nrv_rsvd2             :  Int5;      { reserved             } & &                nrv_nrtr_lu           :  Boolean;   { non router bit       } & &                nrv_nbr_nd            :  Boolean;   { neighbor bit         } & &                nrv_lu                :  PosInt8;   { LU number            } & &                nrv_ip_addr           :  Int32;     { ip address           } & 
                END; 
     {  NrvMaList is a singly  linked  list  in  EMA which holds  }  {  all the information from the NRV question.  Since all     }  {  the  information needed to build the MA table is supplied }  {  here, to indicate MA ,a boolean is used and the MA timeout}  {  saved here . This prevents us from having to build the MA }  {  table in EMA also.                                        }      '   NrvMaList =  RECORD                      { NRVMA List entry :            }  ' '                nml_nrv               :  NrvType;       { NRV entry         }  ' '                nml_ma                :  Boolean;       { MA indicator      }  ' '                nml_ma_tout           :  PosInt8;       { MA timeout        }  ' '                nml_fptr              :  NrvMaLinkType; { pointer to next   }  ' 
                END; 
     $SUBTITLE ' Parse strings',PAGE$  %{-----------------------------------------------------------------------}  % %{     Type declarations for Parse strings                               }  % %{-----------------------------------------------------------------------}  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % $   NrvParseType = RECORD    { containing user input after it is parsed}  $ '                np_rtr_addr           :  Int16;     { router address        }  ' '                np_ip_addr            :  Int32;     { ip address            }  ' '                np_lu                 :  Int16;     { LU number             }  ' '                np_lu_tout            :  Int16;     { LU timeout            }  ' '                np_msg_lev            :  Int16;     { message level         }  ' '                np_nbr_nd             :  Boolean;   { neighbor indicator    }  ' '                np_ma                 :  Boolean;   { MA indicator          }  ' '                np_ma_tout            :  Int16;     { MA  channel timeout   }  ' 
                END; 
     '   LvParseType = RECORD     { buffer containing user input after it is parsed} ' '               lp_lu                  :  Int16;     { LU number             }  ' '               lp_enable              :  boolean;   { enable indicator      }  ' '               lp_rr                  :  boolean;   { outer indicator       }  ' '               lp_cost                :  Int16;     { cost of the link      }  ' 
               END;  
         $SUBTITLE 'Initial Constants ',PAGE$  %{-----------------------------------------------------------------------}  % %{     Initial constants                                                 }  % %{-----------------------------------------------------------------------}  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % %{                                                                       }  % CONST       $   CM_NORR   =  CmType                 { for initializing non rr link }  $                 [ cm_cost          :  0,                    cm_hops          :  0];       $   MA_INIT   =  MaType                 { for initializing MA entry    }  $                 [ ma_rtr_addr      :  0,                    ma_wd2_upperbits :  0,                    ma_wd2_matimeout :  0,                    ma_wd2_state     :  0,  "                  ma_word3thru10   :  MaWd3to10 [1,0,1,0,0,0,0,0]];  "     $TITLE ' Variable Declarations ', PAGE$       %{-----------------------------------------------------------------------}  % %{                                                                       }  % ${     Linked lists notes:                                             }  $ %{                                                                       }  % %{     There are three lists in this module. These list are used to      }  % %{     build the table entries in EMA and once they are complete copy    }  % %{     them to DSAM.                                                     }  % %{        1- NrvMaList : Singly linked list with list lead pointed to    }  % %{                       by nrvmaheadptr. This list is kept inorder      }  % %{                       by router addresses.                            }  % %{        2- LvList    : Linked queue with list head.                    }  % %{                       lvheadptr points to the list head of the queue  }  % %{        3- NonRrList : Linked queue with list head.                    }  % %{                       nonrrheadptr points to the list head of the     }  % %{                       queue.                                          }  % %{                                                                       }  % %{-----------------------------------------------------------------------}  %         VAR      areg         :   Int16OrCharType;     breg         :   Int16OrCharType;  $   grpmclass    :   Int16 ;        { for grpm class number            }  $ $   dirconnet    :   Boolean;       { true if the input ip is on a DCN }  $    have_ma      :   Boolean;     have_rr      :   Boolean;  $   local_net    :   Int32;         {network part of IP addr., node = 0 } $ $   local_node   :   Int16;         {router address of local node       } $ $   lvheadptr    :   LvLinkType;    {pointer to list head of LvList     } $ $   lvents       :   Int16;         {counter for LV entries             } $ $   lvparsebuf   :   LvParseType;   {buffer for parsing user input      } $ $   maents       :   Int16;         {counter for MA entries             } $ $   maretry      :   Int16;         {maretry linit                      } $ $   mastertimeout:   Int16;         {master timeout  in seconds         } $    need_convtrs :   Boolean;  $   nonrrents    :   Int16;         {counter for NON_RR entries         } $ $   nonrrheadptr :   NonRrLinkType; {pointer to list head of NonRrList  } $ $   npos         :   Int16;         { points to output string buffer    } $ $   nrvmaheadptr :   NrvMaLinkType; {pointer to list head of NrvMaList  } $ $   nrvparsebuf  :   NrvParseType ; {buffer for parsing user input      } $ $   nrvents      :   Int16;         {counter for NRV entries            } $ $   outstring    :   IStringType;   {output string buffer for error msgs} $ $   printdebug   :   Boolean ;      { flag to enable EMA debug print out} $ $   printdebug2  :   Boolean ;      { flag to enable EMA debug print out} $ $   saveerror    :   Int16 ;        { savearea for error return         } $ $   stringtocheck:   IStringType;   {buffer used in parse routines      } $ $   wkmap        :   Int16;         {storage for working map            } $     $TITLE 'External Procedures'$   {------------------------------------------------------------}  {           E X T E R N A L   P R O C E D U R E S            }  {------------------------------------------------------------}      PROCEDURE ABReg      ( VAR a_reg:   Int16;  
     VAR b_reg:   Int16 ); 
    EXTERNAL;      PROCEDURE Fetch_LV                { get an LV element }      (   lvindex       :     Int16 ;     VAR lvbuf         :     LvType) ;        EXTERNAL;       !PROCEDURE Fetch_Nrr_Index         { get an Non rerouting element } !    (   nrrindex      :     Int16 ;     VAR nrrbuf        :     NonRrType) ;         EXTERNAL;       PROCEDURE Fetch_Nrv_Index         { get an NRV element }     (   nrvindex      :     Int16 ;     VAR nrvbuf        :     NrvType);         EXTERNAL;      FUNCTION IAND   $ DIRECT $  (  firstint:      Int16;     secondint:     Int16 ): Int16;      EXTERNAL;      FUNCTION IOR  $ DIRECT $  (  firstint:      Int16;     secondint:     Int16 ): Int16;      EXTERNAL;      FUNCTION IXOR   $ DIRECT $  (  firstint:      Int16;     secondint:     Int16 ): Int16;      EXTERNAL;      PROCEDURE LuStatus  $ALIAS 'XLUEX'$   { EXEC 13 i/o status   }     $ NOABORT $     (     icode         :     Int16 ;           cntwd         :     ControlWordType;            param1        :     Int16 ) ;  	         EXTERNAL; 	     PROCEDURE Store_Nrv               { store NRV element }      (  nrvindex      :     Int16 ;         nrvbuf        :     NrvType);         EXTERNAL;       PROCEDURE Store_Ma                { store an MA element }      (  maindex       :     Int16 ;         mabuf         :     MaType);        EXTERNAL;       PROCEDURE Store_Lv                { store a LV element }     (  lvindex       :     Int16 ;         lvbuf         :     LvType);        EXTERNAL;       PROCEDURE TimeSchedule       $ALIAS 'EXEC'$      $ NOABORT $     (  icode         :     Int16 ;         name          :     PnameType ;         units         :     Int16 ;         often         :     Int16 ;         delay         :     Int16 ) ;         EXTERNAL;       $TITLE 'Forward Declarations         ', PAGE$   {------------------------------------------------------------}  {           F O R W A R D   D E C L A R A T I O N S          }  {------------------------------------------------------------}  PROCEDURE BuildCmEntry     (     nrvma_next  : NrvMaLinkType ;           nrvindex    : Int16   ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     PROCEDURE ClearNrvMaList              ;   	         FORWARD;  	     PROCEDURE EnableLinks      ( VAR e_result    : Int16 ) ;  	         FORWARD;  	     	PROCEDURE EnableLu 	    (     LU          : Int16 ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     PROCEDURE FindNeighbor     (     LU          : Int16 ;       VAR Neighbor    : Int16 ) ;  	         FORWARD;  	     PROCEDURE GetLinkType      (     ip        : Int32 ;       VAR linktype  : Int16 ;       VAR e_result  : Int16 );   	         FORWARD;  	     PROCEDURE GetLocalNode     ( VAR e_result    : Int16 ) ;  	         FORWARD;  	     
PROCEDURE GetMaRetryLimit  
    ( VAR e_result    : Int16 ) ;  	         FORWARD;  	     
PROCEDURE Initialize 
          ;  	         FORWARD;  	     PROCEDURE InitResAndStartMonitors      ( VAR e_result    : Int16 ) ;  	         FORWARD;  	     	PROCEDURE InsertLV 	    (     lvparsebuf  : LvParseType ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     PROCEDURE InsertNonRr      (     nrvparsebuf : NrvParseType;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     PROCEDURE InsertNrvMa      (     nrvma_prev  : NrvMaLinkType ;           nrvparsebuf : NrvparseType ;            linktype    : Int16 ) ;  	         FORWARD;  	     	FUNCTION IpAddrOk  	    (     ip_addr1    : Int32 ;           ip_addr2    : Int32 ;           dirconnet   : Boolean ;      VAR  e_result    : Int16 ) : Boolean ;  	         FORWARD ; 	     	FUNCTION LuInNonRr 	    ( VAR lvparsebuf  : LvParseType ) : Boolean ;  	         FORWARD ; 	     
PROCEDURE LvValidateAnswer 
    (     lvparsebuf  : LvParseType ;       VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     PROCEDURE NonRrCheckLu     (     LU          : Int16 ) ;  	         FORWARD;  	     PROCEDURE NrvValidateAnswer      (     nrvparsebuf : NrvParseType ;        VAR linktype    : Int16 ;       VAR nrvma_prev  : NrvMaLinkType ;       VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     	PROCEDURE ParseLV  	    (     input       : IStringType ;       VAR lvparsebuf  : LvParseType ;       VAR response    : Int16 ) ;  	         FORWARD;  	     	PROCEDURE ParseNRV 	    (     input       : IStringType ;       VAR nrvparsebuf : NrvParseType ;        VAR response    : Int16 ) ;  	         FORWARD;  	     PROCEDURE PostErrorProc      ( VAR e_result    : Int16 ) ;  	         FORWARD ; 	     
PROCEDURE PrintLists 
          ;  	         FORWARD;  	     PROCEDURE PrintLvList            ;  	         FORWARD;  	     PROCEDURE PrintNonRrList           ;  	         FORWARD;  	     PROCEDURE PrintNrvList           ;  	         FORWARD;  	     
PROCEDURE ReturnResources  
    ( VAR e_result     : Int16 ) ;   	         FORWARD;  	     	FUNCTION RtrAddrOk 	    (     rtr_addr1   : Int16 ;           rtr_addr2   : Int16 ;       VAR e_result    : Int16 ) : Boolean ;  	         FORWARD;  	     PROCEDURE StopMonitors     ( VAR e_result    : Int16 ) ;  	         FORWARD;  	     PROCEDURE StoreResValuesInDsam     ( VAR e_result    : Int16 ) ;  	         FORWARD;  	     
PROCEDURE ValidAddrs 
    (     nrvparsebuf : NrvParseType ;        VAR nrvma_prev  : NrvMaLinkType ;       VAR valid       : Boolean ;       VAR result      : Int16 ) ;  	         FORWARD;  	     
PROCEDURE ValidCost  
    (     lvparsebuf  : LvParseType ;       VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     PROCEDURE ValidEnable      (     lvparsebuf  : LvParseType ;       VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     
PROCEDURE ValidLevel 
    (     nrvparsebuf : NrvParseType ;        VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     
PROCEDURE ValidIpLu  
    (     nrvparsebuf : NrvParseType ;        VAR linktype    : Int16 ;       VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     
PROCEDURE ValidDsLu  
    (     LU          : Int16 ;       VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     PROCEDURE ValidLuTout      (     nrvparsebuf : NrvParseType;       VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     	PROCEDURE ValidMa  	    ( VAR nrvparsebuf : NrvParseType;       VAR valid_ma    : Boolean ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     PROCEDURE Validneighbor      (     nrvparsebuf : NrvParseType ;        VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     	PROCEDURE ValidRtr 	    (     lvparsebuf  : LvParseType ;       VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;  	         FORWARD;  	     $TITLE 'BuildCmEntry',PAGE$       {------------------------------------------------------------}  {                 B u i l d C m E n t r y                    }  {------------------------------------------------------------}      { PURPOSE                                                    }  {  Always build a cost matrix entry. The cost matrix is the  }  {  number-of-nodes-in-the-NRV by the-number-of-rerouting-    }  {  links (i.e. the number of links in the link vector).  If  }  {  the user does not wish to use rerouting to this node (that}  {  is, the LU was specified in the NRV question) then the    }  {  cost matrix entry for this node will be all zeroes.  This }  {  indicates to the rerouting software that the link LU in   }  {  NRV should not be updated even if the link is a rerouting }  {  link.  By placing the value of zero in the LU field of the}  {  NRV question for a particular node, the user is indicating}  {  that rerouting should determine the LU to use for this    }  {  destination node.  In this case the cost matrix entry will}  {  be initialized appropriatedly.                            }      PROCEDURE BuildCmEntry     (    nrvma_next : NrvMaLinkType ;          nrvindex   : Int16 ;      VAR e_result   : Int16 ) ;      {}  { Parameters:   {  e_result     OUTPUT     error return   {   { Side Effects:   {  NONE   {   
{ Global Data Structures:  
 {  All from InitNrv   uses necessary variables from InitNrv   {  lvents             accessed but not changed  {  nrvents            accessed but not changed  {   	{ Error Handling:  	 {   { Algorithm:  {  IF lufield <> 0 THEN   {     { no rerouting }  {     Set cost matrix entry for this node to zeroes   {  ELSE   {     { use rerouting to this destination }   {     Initialize the cost matrix entry for this node to the   {       correct cost/hops for each link in the node.  {  END  {}      LABEL      99;      VAR      lvindex   :   Int16;   
   cm_init   :   CmRecord; 
         BEGIN { BuildCmEntry }  	   e_result := 0;  	     '   { if user specified an LU to get to a node then treat it as non rerouting } ' '   { also if non router link                                                 } '    IF ( ( nrvma_next^.nml_nrv.nrv_lu = 0 ) AND        ( nrvma_next^.nml_nrv.nrv_rtr_addr <> local_node ) AND        ( NOT nrvma_next^.nml_nrv.nrv_nrtr_lu ) ) THEN        BEGIN { use rerouting to this node }               FOR lvindex := 1 TO lvents DO           BEGIN { initialize the cost matrix row }               cm_init.cmrow[lvindex].cm_cost := INITCOST;               cm_init.cmrow[lvindex].cm_hops := nrvents;           END;  { initialize the cost matrix row }             END   { use rerouting to this node }         ELSE             BEGIN { user supplied lu, therefore no rerouting }               FOR lvindex := 1 TO lvents DO              BEGIN { initialize the cost matrix row to zeroes }                 cm_init.cmrow[lvindex] := CM_NORR;               END;  { initialize the cost matrix row to zeroes }            END;  { user supplied lu, therefore no rerouting }         DS_InitEnterCritical(wkmap,e_result);     IF e_result <> GOOD THEN GOTO 99 ;          DS_StoreElement(DS_CM_TD,nrvindex,cm_init.cmrowint);          DS_InitLeaveCritical(wkmap);       99:  { return the error if any }      END;  { BuildCmEntry }      $TITLE 'ClearNrvMaList',PAGE$   %{------------------------------------------------------------------------} % %{          ClearNrvMaList                                                } % %{------------------------------------------------------------------------} %     
PROCEDURE ClearNrvMaList;  
        BEGIN { ClearNrvMaList }          nrvmaheadptr^.nml_fptr := NIL ;  	   nrvents := 0 ;  	        END;  { ClearNrvMaList }                       
$TITLE 'EnableLinks',PAGE$ 
 {------------------------------------------------------------}  {                    E n a b l e L i n k s                   }  {------------------------------------------------------------}      { This routine enables all the NS links. Both non reroruting }  { and rerouting links which are specified by the user        }             PROCEDURE EnableLinks        ( VAR e_result  : Int16 ) ;       {  parameters :   {     e_result       output       error return  {   {}         LABEL        99 ;         VAR        nonrr_ptr   : NonRrLinkType;        lv_ptr      : LvLinkType;              BEGIN { EnableLinks }      	   e_result := 0;  	     $   { Go thru LvList and check the ENABLE boolean, if set enable link. }  $        nonrr_ptr := nonrrheadptr^.nrl_fptr ;         WHILE nonrr_ptr <> NIL DO            BEGIN         WITH nonrr_ptr^ DO  #         IF nrl_enable THEN  Enablelu ( nrl_nonrr.nr_lu , e_result );  #     $ (*   IF e_result <> GOOD THEN GOTO 99 ;  ignore any errors and go on *) $       nonrr_ptr := nonrr_ptr^.nrl_fptr;         END;      %   { Go thru NonRrList and check the ENABLE boolean, if set enable link. } %        lv_ptr := lvheadptr^.ll_fptr ;   
   WHILE lv_ptr <> NIL DO  
           BEGIN         WITH lv_ptr^ DO   !         IF ll_enable THEN  Enablelu ( ll_lv.lv_lklu , e_result ); !     $  (*  IF e_result <> GOOD THEN GOTO 99 ;  ignore any errors and go on *) $           lv_ptr := lv_ptr^.ll_fptr;            END;      99:      { return error if any }         END;  { EnableLinks }      $TITLE 'EnableLu',PAGE$       ${---------------------------------------------------------------------}  $ ${       EnableLU                                                      }  $ ${---------------------------------------------------------------------}  $     ${ This routine enables a given NS router link and returns error if any}  $            PROCEDURE EnableLu         (     LU       : Int16 ;          VAR e_result : Int16 );       {  Parameters :   {     LU          input       NS link to be enabled   {     e_result    output      error returned  {   {}         LABEL        99 ;         VAR        cntwd         : ControlWordType ;         grpmclass     : Int16 ;         listenmodelu  : Int16 ;         param         : ControlWordType ;          BEGIN         { assume everything is good }     e_result := GOOD ;          { setup the listen mode LU }      listenmodelu := LU ;          { setup control word to call XLUEX }      cntwd[1] := IOR( LU , BIT15 );      cntwd[2] := ENABLELISTENRQST ;       
   { enable the LU } 
    LuStatus ( EXEC3 + NOSUSPENDBIT , cntwd , listenmodelu ) ;         BEGIN  { handle the XLUEX error }         ABReg ( areg.IIOrCType , breg.IIOrCType ) ;         HandleAbortReturn( areg, breg, lu, e_result );        GOTO 99 ;         END;   { handle the XLUEX error }          { check the result }      ABReg ( areg.IIOrCType , breg.IIOrCType );      CheckXLUEXCall( areg, breg, lu,                       ENABLE_LU_ERR_MSG, e_result );       99 :  { return error if any }          END;           $TITLE 'FindNeighbor',PAGE$   {------------------------------------------------------------}  {         FindNeighbor                                       }  {------------------------------------------------------------}       { this routine returns the router address of the neighbor node }    { for a given LU . If it could not find the neighbor in the    }   { NrvMa list it returns INVALID }       PROCEDURE FindNeighbor     (     LU          : Int16 ;       VAR neighbor    : Int16 ) ;      {  Parameters:  {     LU         input       NS link lu   {     neighbor   output      possible neighbor node   {   {}      VAR      notfound     : Boolean ;      ptr          : NrvMaLinkType ;           
   BEGIN  { FindNeighbor } 
        ptr := NrvMaHeadPtr^.nml_fptr ;     notfound := TRUE ;          WHILE ( ( ptr <> NIL ) AND notfound ) DO             BEGIN { for each entry in NrvMaList }       
      WITH ptr^.nml_nrv DO 
          IF LU = nrv_lu THEN notfound := FALSE ;            { advance the pointer }         ptr := Ptr^.nml_fptr ;            END;  { for each entry in NrvMaList }          IF ptr = NIL THEN neighbor := INVALID     ELSE WITH ptr^.nml_nrv DO neighbor := nrv_rtr_addr ;       
   END;   { FindNeighbor } 
             
$TITLE 'GetLinkType',PAGE$ 
 {------------------------------------------------------------}  {        GetLinkType                                         }  {------------------------------------------------------------}      { This routine returns the link type of the first hop to get }  { to the given ip address                                    }      PROCEDURE GetLinkType      (     ip        : Int32 ;       VAR linktype  : Int16 ;       VAR e_result  : Int16 );        { parameters:                                                  }    {    ip       input      ip address                            }    {    linktype output     link type of the first hop            }   {    e_result output     error return  ( invalid ip )   {   {}      VAR      dumflag      : Boolean ;          BEGIN  	   e_result := 0;  	        IpRoute ( ip , linktype , dumflag , e_result ) ;          END ;          $TITLE 'GetLocalNode',PAGE$   {------------------------------------------------------------}  {         GetLocalNode                                       }  {------------------------------------------------------------}       {PURPOSE:                                                      }    { This procedure is responsible for prompting the user for the }    { router address of the local node and initializing the        }    { local_ip and local_net variables.                            }           PROCEDURE GetLocalNode     (VAR e_result  :  Int16);      {}  { Parameters:   {  result     output    error return  {   {   
{ Global Data Structures:  
 {  local_node    used by InitNrv to initialize #NODE in RES   {  local_net     used by IpAddrOk (local routine to ValidAddr)  {   {   {}      VAR      default       :   Boolean ;     nrvma_new     :   NrvMaLinkType;      terminator    :   Boolean ;     user_input_i  :   Int16;           
   BEGIN { GetLocalNode }  
    default    :=  FALSE;     terminator :=  FALSE;     e_result   := GOOD;         IntInput(LOCAL_NODE_BANR,default,terminator,MAXRTRADDR,              MINRTRADDR,user_input_i,e_result);         IF (e_result = GOOD) THEN        BEGIN { initialize global variables }      {  set the local node number and the local network number     {  global variables }        local_node := user_input_i;             local_net := GetNet(Local_Rtr_Ipadr);       &   { Insert an entry  containing the local node information in the        }  & &   { NrvMa list now, so that user would not need to give this information }  & &   { twice                                                                }  &    { initialize nrvparsebuf and hand it to InsertNrvma }  
      WITH nrvparsebuf DO  
          BEGIN           np_rtr_addr := local_node ;           np_ip_addr := Local_Rtr_Ipadr ;  
         np_lu:= 0 ; 
 
         np_lu_tout:= 0 ;  
          np_msg_lev:= DEFMSGLEVEL ;            np_nbr_nd := TRUE ;  
         np_ma := FALSE ;  
          END;             InsertNrvma ( nrvmaheadptr , nrvparsebuf , ROUTER );            END;  { initialize global variables }       
   END;  { GetLocalNode }  
         $TITLE 'GetMaRetryLimit',PAGE$  {------------------------------------------------------------}  {         GetMaRetryLimit                                    }  {------------------------------------------------------------}       {PURPOSE:                                                      }    { This procedure is responsible for prompting the user for the }    { MA retry limit and set the proper global variables.          }           
PROCEDURE GetMaRetryLimit  
    (VAR e_result  :  Int16);      {  Parameters:  {     e_result      output      error return  {   {}      VAR      default       :   Boolean ;     terminator    :   Boolean ;     user_input_i  :   Int16;              BEGIN { GetMaRetryLimit }     default    :=  TRUE;      terminator :=  FALSE;      !   IntInput(MARETRYLIMITPROMPT,default,terminator,MAXMARETRYLIMIT, !             MINMARETRYLIMIT,user_input_i,e_result);          IF (e_result = GOOD) THEN        BEGIN { initialize global variables }             IF default THEN       
         BEGIN { default } 
          maretry := DEFMARETRYLIMIT;  
         END   { default } 
           ELSE               BEGIN { take user input }           maretry := user_input_i;            END ; { Take user input }            END;  { initialize global variables }          END;  { GetMaRetryLimit }          
$TITLE 'Initialize',PAGE$  
     ${---------------------------------------------------------------------}  $ ${         Initialize                                                  }  $ ${---------------------------------------------------------------------}  $     PROCEDURE Initialize;       "{ This routine initialize the pointers to three lists and counters } "         
BEGIN { Initialize } 
 { Initialize the sizes of the MA, NRV and NONRR tables. }   maents    := 0;   nrvents   := 0;   nonrrents := 0;   lvents    := 0;           
{ initialize flags } 
 have_ma      := FALSE ;   have_rr      := FALSE ;   need_convtrs := FALSE ;           { Initialize the list head and pointer for LvList.}   NEW(lvheadptr) ;  lvheadptr^.ll_fptr := NIL ;   lvheadptr^.ll_lv.lv_lklu := 0 ;       { Initialize the list head and pointer for NonRrList.}  
NEW(nonrrheadptr) ;  
 nonrrheadptr^.nrl_fptr := NIL ;   nonrrheadptr^.nrl_nonrr.nr_lu := 0 ;      { Initialize the list head and pointer for NrvMaList. }   	NEW(nrvmaheadptr); 	 nrvmaheadptr^.nml_fptr := NIL;  $nrvmaheadptr^.nml_nrv.nrv_rtr_addr := -MAXRTRADDR;  {mark the list head} $     
END;  { Initialize } 
     $TITLE 'InitNRV ', PAGE$  {------------------------------------------------------------}  {                   I n i t N r v                            }  {------------------------------------------------------------}      { PURPOSE:                                                   }  {  This routine is responsible for traversing the NrvMaList  }  {  in EMA and building the NRV, CM and MA tables in DSAM.    }      	PROCEDURE InitNRV  	    (VAR result      : Int16);       {}  { Parameters:   #{  result        OUTPUT      good/bad result info. returned to NSINIT  # {   { Side Effects:   {   
{ Global Data Structures:  
 {  lvents        used to build the cost matrix (CM = NRV x LV)  {   	{ Error Handling:  	 {   { Algorithm:  {  Repeat   {     Get an NrvMa entry from the linked list in EMA  {     Build the NRV entry in DSAM   {     Build the cost matrix entry in DSAM   {     Build the MA table entry in DSAM if necessary   {     Until no more entries   "{  Initialize entry points in res (counts, class no., resource no.)  " {  Start necessary monitors   !{  Initialize msg. level, local node and max hops in DSAM globals  ! {   {}      LABEL      99 ;       VAR      cm_init        :  CmRecord;     error          :  Int16;      e_result       :  Int16;      ma_buf         :  MaType;     maindex        :  Int16;      nrvindex       :  Int16;      nrvma_next     :  NrvMaLinkType;      valid          :  Boolean ;      $PAGE$     PROCEDURE ErrorExit;       
      BEGIN { ErrorExit }  
       DS_InitLeaveCritical ( wkmap ) ;        GOTO 99 ;   
      END ; { ErrorExit }  
         	BEGIN { InitNrv }  	        e_result := GOOD ;      IF ( NOT InitGlobals.IG_need_RTR ) THEN            BEGIN  { no router to initialize }            GOTO 99 ;         END;   { no router to initialize }         { get table space in DSAM }     DS_InitEnterCritical(wkmap,e_result);     IF e_result <> GOOD THEN GOTO 99 ;          IF nrvents > 0 THEN  &      DS_GetTableSpace( DS_NRV_TD , MINNRVINDEX , nrvents , NRVELEMENTSIZE , &                         e_result );      IF e_result <> GOOD THEN ErrorExit ;          IF maents > 0 THEN   $      DS_GetTableSpace( DS_MA_TD , MINMAINDEX , maents , MAELEMENTSIZE , $                         e_result );      IF e_result <> GOOD THEN ErrorExit ;          IF ( ( nrvents > 0 ) AND ( lvents > 0 ) ) THEN   #      DS_GetTableSpace( DS_CM_TD , MINCMINDEX , nrvents , lvents * 2 , #                         e_result ) ;         IF e_result <> GOOD THEN ErrorExit ;          DS_InitLeaveCritical(wkmap);       	   nrvindex := 0;  	 	   maindex  := 0;  	    nrvma_next := nrvmaheadptr^.nml_fptr ;          WHILE nrvma_next <> NIL DO         BEGIN             {=======================}         {=== build NRV table ===}         nrvindex  := nrvindex + 1;            DS_InitEnterCritical(wkmap,e_result);         IF e_result <> GOOD THEN GOTO 99 ;        Store_Nrv(nrvindex,nrvma_next^.nml_nrv);      $      {===============================================================}  $ $      {=== build the corresponding MA table entry for this node if ===}  $ $      {=== the user indicated that MA should be used to this node. ===}  $       IF (nrvma_next^.nml_ma) THEN           BEGIN { build an MA table entry }           maindex := maindex + 1;           ma_buf := MA_INIT;             ma_buf.ma_rtr_addr := nrvma_next^.nml_nrv.nrv_rtr_addr;            ma_buf.ma_wd2_matimeout := nrvma_next^.nml_ma_tout;           Store_Ma(maindex,ma_buf);           END;  { build an MA table entry }            DS_InitLeaveCritical(wkmap);            {===============================}         {=== build Cost Matrix table if any rerouting links ===}        IF lvents > 0 THEN           BEGIN           BuildCmEntry( nrvma_next , nrvindex , e_result );           IF e_result <> GOOD THEN GOTO 99 ;            END;             { advance the pointer }             nrvma_next := nrvma_next^.nml_fptr;             END; { WHILE not end of the list }             { This is a double check. number of entries in the table }      { in DSAM should match what we calculated at SYN time    }      IF ((nrvents = nrvindex) AND (maents = maindex)) THEN        BEGIN { everything looks OK }             InitResAndStartMonitors( e_result );        IF e_result <> GOOD THEN GOTO 99 ;            StoreResValuesInDsam( e_result );         IF e_result <> GOOD THEN GOTO 99 ;            END   { everything looks OK }          ELSE         BEGIN { internal error, tables are screwed up! }        e_result := NRVTABCORR ;        END;  { internal error, tables are screwed up! }      99:      result := e_result ;       END; { InitNrv }  $TITLE 'InitResAndStartMonitors',PAGE$      {------------------------------------------------------------}  {        I n i t R e s A n d S t a r t M o n i t o r s       }  {------------------------------------------------------------}      !{ This routine initialize res variables and schedule requiered  }  ! !{ monitors.                                                     }  !     PROCEDURE InitResAndStartMonitors   
   (VAR e_result : Int16); 
     {}  { Parameters:   {  e_result   OUTPUT  error return  {   { Side Effects:   {  NONE   {   
{ Global Data Structures:  
 {  lvents   accessed but not changed  {  maents   accessed but not changed  {  nrvents  accessed but not changed  {   	{ Error Handling:  	 {   {   { Algorithm:  {   {}      LABEL      99 ;       VAR      fatalerrorflag :  Boolean;      incvclass      :  Int16;      maholdclass    :  Int16;      otcvclass      :  Int16;      ma_resnum      :  Int16;       $PAGE$  BEGIN { InitResAndStartMonitors }          DS_StoreResElement(NSINIT_AdrOf( Lb_NODE ),0,local_node);      { Initialize entry points for table sizes }      DS_StoreResElement(NSINIT_AdrOf( Lb_LCNT ), 0,  lvents);      DS_StoreResElement(NSINIT_AdrOf( Lb_MCTR ), 0, -maents);      DS_StoreResElement(NSINIT_AdrOf( Lb_NCNT ), 0, -nrvents);     DS_StoreResElement(NSINIT_AdrOf( Lb_MHCT ), 0, -nrvents);      	   IF have_rr THEN 	           BEGIN { schedule RR monitors }  !      { verify that #SEND is RP'ed but do not schedule it here. }  ! !      { if it is not there then abort                           }  !       fatalerrorflag := TRUE ;        DS_CheckIdSeg ( '#SEND' , fatalerrorflag , e_result ) ;         IF e_result <> GOOD THEN           BEGIN    { no #send }           e_result := ERR_ALREADY_PRINTED;   	         GOTO 99;  	          END;     { no #send }        END ; { schedule RR monitors }      	   IF have_ma THEN 	           BEGIN { allocate MA stuff }              DS_GetClass( NSINIT_AdrOf( Lb_MAHC ), 0 , SAVECLASSNUMBIT,                                      maholdclass, e_result );         IF e_result <> GOOD THEN GOTO 99 ;            DS_GetRN(NSINIT_AdrOf( Lb_MARN ),0,ma_resnum ,e_result);        IF e_result <> GOOD THEN GOTO 99 ;            { set MA retry limit: #MARL }   !      DS_StoreResElement ( NSINIT_AdrOf( Lb_MARL ), 0, maretry ) ; !           {  time schedule MATIC . Run once every second.  }  !      DS_StartMonitor( 'MATIC' , PASSWORD , PRINTERR , e_result);  !       IF e_result = NOTDORMANT THEN  GOTO 99 ;        IF  e_result <> GOOD  THEN           BEGIN    { change error to indicate we're aborting }            PrintError( NO_REQ_MON_ABORTMSG, e_result );            e_result := ERR_ALREADY_PRINTED;   	         GOTO 99;  	          END;     { change error to indicate we're aborting }         END;  { allocate MA stuff }          IF need_convtrs THEN         BEGIN { schedule input/output converters }             DS_GetClass( NSINIT_AdrOf( Lb_INCV ), 0 , SAVECLASSNUMBIT,   !                                            incvclass, e_result ); !       IF e_result <> GOOD THEN GOTO 99 ;             DS_GetClass( NSINIT_AdrOf( Lb_OTCV ), 0 , SAVECLASSNUMBIT,                                           otcvclass, e_result );        IF e_result <> GOOD THEN GOTO 99 ;            DS_StartMonitor('INCNV',incvclass,PRINTERR,e_result);         IF e_result = NOTDORMANT THEN GOTO 99 ;         IF e_result <> GOOD THEN           BEGIN    { Tell user req. mon not found }           PrintError( NO_REQ_MONMSG, e_result );            IF e_result <> GOOD THEN GOTO 99;           END;     { Tell user req. mon not found }            DS_StartMonitor('OTCNV',otcvclass,PRINTERR,e_result);         IF e_result = NOTDORMANT THEN GOTO 99 ;         IF e_result <> GOOD THEN           BEGIN    { Tell user req. mon not found }           PrintError( NO_REQ_MONMSG, e_result );            IF e_result <> GOOD THEN GOTO 99;           END;     { Tell user req. mon not found }            END;  { schedule input/output converters }         { if grpm is not started by oldservices start it here }     IF NOT InitGlobals.IG_1k50_enable THEN         BEGIN         DS_GetClass(NSINIT_AdrOf( Lb_GRPM ), 0,   %               SAVECLASSNUMBIT + SAVECLASSBUFBIT, grpmclass , e_result );  %           IF e_result <> GOOD THEN GOTO 99 ;            DS_StartMonitor('GRPM ',grpmclass,PRINTERR,e_result);         IF e_result = NOTDORMANT THEN  GOTO 99 ;        IF  e_result <> GOOD  THEN           BEGIN    { change error to indicate we're aborting }            PrintError( NO_REQ_MON_ABORTMSG, e_result );            e_result := ERR_ALREADY_PRINTED;   	         GOTO 99;  	          END;     { change error to indicate we're aborting }         END;      99:    { return error if any }      END;  { InitResAndStartMonitors }           $TITLE 'InitRTR', PAGE$   {------------------------------------------------------------}  {                     I n i t R t r                          }  {------------------------------------------------------------}      {PURPOSE:                                                    }  { This routine is responsible for traversing the LvList in   }  { EMA and building the Link Vector and the NonRR Table in    }  { DSAM.                                                      }      	PROCEDURE InitRTR  	    (VAR result      : Int16);       {}  { Parameters:    {  result        INPUT       good/bad result returned to NSINIT    {   { Side Effects:   {   {   
{ Global Data Structures:  
 {  lvents        used to build the link vector  {   	{ Error Handling:  	 {   {   { Algorithm:  {  Repeat   {     Get an entry from the link vector list in EMA   {     Build the link vector entry in DSAM   {     Until no more entries   {   {  Repeat   {     Get an entry from the non-rerouting list in EMA   {     If the entry is good then   {        Build the link vector entry in DSAM  {     Until no more entries   {  End  {}      LABEL      99;      VAR      e_result    :  Int16;     lvindex     :  Int16;     lv_next     :  LvLinkType;      nonrrindex  :  Int16;     nonrr_init  :  NonRrRec;      nonrr_next  :  NonRrLinkType;     valid        :  Boolean ;              {                       I n i t R t r                        }         PROCEDURE ErrorExit;       
      BEGIN { ErrorExit }  
       DS_InitLeaveCritical ( wkmap ) ;        GOTO 99 ;   
      END ; { ErrorExit }  
     	BEGIN { InitRtr }  	    e_result := GOOD ;          IF ( NOT InitGlobals.IG_need_RTR ) THEN            BEGIN  { no router to initialize }            GOTO 99 ;         END;   { no router to initialize }             { get the space in DSAM }         DS_InitEnterCritical(wkmap,e_result);     IF e_result <> GOOD THEN GOTO 99 ;          IF lvents > 0 THEN   $      DS_GetTableSpace( DS_LV_TD , MINLVINDEX , lvents , LVELEMENTSIZE , $                         e_result ) ;     IF e_result <> GOOD THEN ErrorExit;         IF nonrrents > 0 THEN  !      DS_GetTableSpace( DS_NON_RR_TD , MINNONRRINDEX , nonrrents , !                         NONRRELEMENTSIZE , e_result );     IF e_result <> GOOD THEN  ErrorExit ;         DS_InitLeaveCritical(wkmap);       {===============================}   { Build the link vector in DSAM.}          lvindex := 0;     lv_next := lvheadptr^.ll_fptr ;      
   WHILE lv_next <> NIL DO 
       BEGIN  { build the link vector }            { verify that LU is ds LU }          ValidDsLu ( lv_next^.ll_lv.lv_lklu , valid , e_result ) ;          IF ( ( NOT valid ) OR ( e_result <> GOOD ) ) THEN            BEGIN  { not a valid LU }           IF e_result = CHKDRIVER_BADTYPE THEN               BEGIN    { wrong type }               { catastrophic error.  Return to caller }   
            GOTO 99; 
             END;     { wrong type }                { other error, keep going }           e_result := ERR_ALREADY_PRINTED;            lv_next^.ll_lv.lv_lklu := 0;            END ;  { not a valid LU }            lvindex := lvindex + 1;             DS_InitEnterCritical(wkmap,e_result);         IF e_result <> GOOD THEN GOTO 99 ;            Store_Lv(lvindex,lv_next^.ll_lv);             DS_InitLeaveCritical(wkmap);            lv_next := lv_next^.ll_fptr;            END;    { build the link vector }       {================================}  { Build the non rerouting table. }      
   nonrrindex := 0;  
    nonrr_next := nonrrheadptr^.nrl_fptr ;          WHILE (nonrr_next <> NIL) DO             BEGIN { build the nonrr table }             IF (nonrr_next^.nrl_nonrr.nr_lu <> NOTUSED) THEN           BEGIN { good entry; place it in DSAM }             { verify that LU is ds LU }   "      ValidDsLu ( nonrr_next^.nrl_nonrr.nr_lu , valid , e_result ) ; "       IF ( ( NOT valid ) OR ( e_result <> GOOD ) ) THEN            BEGIN  { valid LU }           IF e_result <> CHKDRIVER_BADTYPE THEN              BEGIN    { wrong type. Give up }              { Catastrophic error. Return to caller }              GOTO 99 ;               END;     { wrong type. Give up }               { other error, keep going }           e_result := ERR_ALREADY_PRINTED;            END ;  { valid LU }               nonrrindex := nonrrindex + 1;           nonrr_init.nonrrbuf := nonrr_next^.nrl_nonrr;           DS_InitEnterCritical(wkmap,e_result);           IF e_result <> GOOD THEN GOTO 99 ;            DS_StoreElement(DS_NON_RR_TD,nonrrindex,                            nonrr_init.nonrrint);           DS_InitLeaveCritical(wkmap);            END;  { good entry; place it in DSAM }             nonrr_next := nonrr_next^.nrl_fptr;         END;  { build the nonrr table }          EnableLinks( e_result );       99:   	result := e_result 	     END; { InitRtr }      $TITLE 'InsertLV',PAGE$   ${---------------------------------------------------------------------}  $ 	{         InsertLV 	 ${---------------------------------------------------------------------}  $     %{ This routine sets up an entry in the LvList and inserts it in the list}  % %{ It check all the elements in the queue and if a duplicate LU is found }  % %{ it will not insert the entry                                          }  %     	PROCEDURE InsertLV 	    (    lvparsebuf : LvParseType ;      VAR e_result   : Int16       );       { Parameters :  "{     lvparsebuf    input     parsed user input to "link: " question " {     e_result      output    error return.   {   {}      LABEL      99 ;       VAR      ptr       : LvLinkType ;      lv_new    : LvLinkType ;      neighbor  : Int16 ;             BEGIN { InsertLv }       
   e_result := GOOD; 
    ptr := lvheadptr ;          { traverse the list }     WHILE ptr^.ll_fptr <> NIL DO             BEGIN             { check for duplicate entry }          IF ( ptr^.ll_fptr^.ll_lv.lv_lklu = lvparsebuf.lp_lu ) THEN                BEGIN           e_result := DUPLICATELU ;  	         GOTO 99 ; 	          END;             ptr := ptr^.ll_fptr ;             END;      '   { now we know it is a unique LU and we can setup the entry and insert it }  '        lvents := lvents + 1;     NEW(lv_new);          { set up the variables in th eentry }     WITH lv_new^, lvparsebuf DO ll_enable := lp_enable;         WITH lv_new^.ll_lv , lvparsebuf DO         BEGIN   
      lv_stat := 0 ; 
 
      lv_rsvd := 0 ; 
       lv_lklu := lp_lu;         lv_lkcost := lp_cost;         lv_systime := 0 ;         lv_updnctr := 0 ;         FindNeighbor ( lp_lu , neighbor ) ;         lv_nbr_node := neighbor ;         END;         { insert it in the list ( at the end of the list ) }      lv_new^.ll_fptr := NIL ;      ptr^.ll_fptr := lv_new ;       99:          END;       
$TITLE 'InsertNonRr',PAGE$ 
  {-------------------------------------------------------------}     {             I n s e r t N o n R t r                         }     {-------------------------------------------------------------}        %{ This routine sets up an entry for NonRrList and inserts it in the list}  % %{ It check all the elements in the queue and if a duplicate LU is found }  % %{ it will not insert the entry                                          }  %     PROCEDURE InsertNonRr      (     nrvparsebuf : NrvParseType ;        VAR e_result    : Int16 );       { Parameters :  #{     nrvparsebuf    input      parsed user input to "NRV: " question  # {     e_result       output     error return  {   {}          VAR      found        : Boolean ;      nonrr_new   : NonRrLinkType ;     ptr          : NonRrLinkType ;          BEGIN { InsertNonRr }             ptr := nonrrheadptr ;  
   found := FALSE ;  
    e_result := GOOD ;          WITH nrvparsebuf DO            BEGIN  { WITH nrvparsebuf }             { traverse the list }         WHILE ( ( ptr^.nrl_fptr <> NIL ) AND ( NOT found ) ) DO       
         BEGIN  { WHILE }  
              { check for duplicate entry }           IF ( ptr^.nrl_fptr^.nrl_nonrr.nr_lu = np_lu ) THEN       	            BEGIN  	             e_result := DUPLICATELU ;               found := TRUE ;               END                ELSE       
            BEGIN  { ok }  
             ptr := ptr^.nrl_fptr ;  
            END ;  { ok }  
              END; { WHILE }       $      { if duplicate see if it has any information about the neighbor }  $     '      IF ( np_nbr_nd AND                           { input has neighbor info } ' '           found AND                           { LU was already in nonrr list} ' '           (ptr^.nrl_fptr^.nrl_nonrr.nr_nbr_node = INVALID)) THEN  { no nbr  } '              BEGIN { update neighbor }  #         WITH ptr^.nrl_fptr^.nrl_nonrr DO nr_nbr_node := np_rtr_addr ; #          END   { update neighbor }            ELSE IF ( NOT FOUND ) THEN               BEGIN { first time in }  !         { now we can setup the entry and insert it in the list }  !              nonrrents := nonrrents + 1;           NEW(nonrr_new);               { set up the variables in th entry }            WITH nonrr_new^ DO nrl_enable := FALSE ;                WITH nonrr_new^.nrl_nonrr DO   	            BEGIN  	                 nr_dummy := 0 ;               nr_lu := np_lu ;                  { if user has specified 'N' , set neighbor node }               IF np_nbr_nd THEN nr_nbr_node := np_rtr_addr              ELSE              nr_nbr_node := INVALID ;                  END;               { insert it in the list ( at the end of the list ) }            nonrr_new^.nrl_fptr := NIL ;            ptr^.nrl_fptr := nonrr_new ;                END ; { first time in }            END; { WITH nrvparsebuf }          END;  { InsertNonRr }          $TITLE 'InsertNrvMa', PAGE$   {------------------------------------------------------------}  {                  I n s e r t N r v M a                     }  {------------------------------------------------------------}       { PURPOSE:                                                    }     {  After the NrvMa list in EMA has been scanned and it has    }     {  been determined that the router and IP addresses are vaild,}     {  the entry may be inserted at the appropriate place in the  }     {  list (after nrvma_prev). This routine sets up an entry and }     {  inserts it in the list. It also check to see if we need to }     {  creat an MA entry for this lu. If so it increments the     }     {  maents counter.                                            }     {=============================================================}        PROCEDURE InsertNrvMa      (    nrvma_prev  : NrvMaLinkType;          nrvparsebuf : NrvParseType ;          linktype    : Int16 ) ;       {}  { Parameters:   {  nrvma_prev    INPUT       pointer to preceeding list entry   !{  nrvparsebuf   INPUT       stores parsed info. from NRV question ! {  linktype      INPUT       link type of the lu  {   {   
{ Global Data Structures:  
 {  maents        number of MA table entries   {  nrvents       number of NRV entries  {   {   {}  VAR          nonrr_new     :   NonRrLinkType;      nrvma_new     :   NrvMaLinkType;           !{ InsertNrvMa sets up an NrvMa entry and inserts it in the list.}  ! !{ The entry is assigned value from nrvparsebuf which contains   }  ! !{ user input.                                                   }  !        BEGIN { InsertNrvMa }      
   NEW ( nrvma_new); 
        nrvents := nrvents + 1 ;          WITH nrvma_new^,nrvparsebuf DO             { initialize the new NrvMa list entry }   
      BEGIN { WITH } 
           nml_ma := np_ma ;         nml_ma_tout := np_ma_tout ;             WITH nml_nrv DO            BEGIN  { WITH }           nrv_rtr_addr := np_rtr_addr;            nrv_lu_tout := np_lu_tout;            nrv_rsvd1   := 0 ;            nrv_msg_lev := np_msg_lev;            nrv_chgbit  := 0 ;            nrv_rsvd2   := 0 ;            nrv_nrtr_lu :=  linktype <> ROUTER ;            nrv_nbr_nd := np_nbr_nd;   
         nrv_lu := np_lu;  
 !         need_convtrs := ( need_convtrs OR ( nrv_msg_lev = 0 ) );  !          nrv_ip_addr := np_ip_addr;            END; { WITH }            { Do we have MA? }        IF  nml_ma  THEN           BEGIN { increment the MA table size }           maents := maents + 1;  
         have_ma := TRUE;  
          END;  { increment the MA table size }            { insert item  after the save pointer.      }         { nrvma_prev is set by ValidAddress routine }             nml_fptr  := nrvma_prev^.nml_fptr ;         nrvma_prev^.nml_fptr := nrvma_new;      
      END; { WITH }  
        END;  { InsertNrvMa }              $TITLE 'IpAddrOk',PAGE$   !{---------------------------------------------------------------}  ! !{                  I p A d d r O k                              }  ! !{---------------------------------------------------------------}  !     !{ PURPOSE:                                                      }  ! !{  The IpAddrOk function compares the two IP adresses if both   }  ! !{  belong to local network and if the addresses match then the  }  ! !{  address is invalid and the function returns false. Also, it  }  ! !{  returns false if the IP address is a local IP address. It    }  ! !{  prints an error message if the returned value is false.      }  !     	FUNCTION  IpAddrOk 	    (    ip_addr1    :  Int32 ;          ip_addr2    :  Int32 ;          dirconnet   :  Boolean ;      VAR e_result    :  Int16 ) : Boolean ;      {  Parameters:  {     ip_addr1      input      ip address   {     ip_addr2      input      ip address   ${     dirconnet     input      true if both ip addresses are on directly $ {                              connected network.   {     e_result      output     error return   {   {}      	BEGIN { IpAddrOk } 	     
   e_result := GOOD; 
        IF  ( ( dirconnet AND ( ip_addr1 = ip_addr2 ) ) OR             FindLipadEntry ( ip_addr1 ) ) THEN               BEGIN { error }           MsgFilePrint( DUP_IP_ADDR, PMT_ERROR, 0, e_result);           IpAddrOk := FALSE;            END;  { error }      	END;  { IpAddrOk } 	         $TITLE 'LuInNonRr',PAGE$   {-------------------------------------------------------------}     {        LuInNonRr                                            }     {-------------------------------------------------------------}        !{ This routine returns TRUE if the given LU is in non rr list    } ! !{ If true then it sets the enable flag according to user responde} !     	FUNCTION LuInNonRr 	    ( VAR lvparsebuf  : LvparseType ) : Boolean ;      {  Parameters :   !{     lvparsebuf   input    parsed user input to "LINK: " question ! {   {}      VAR      found        : Boolean ;      ptr          : NonRrLinkType ;          BEGIN { LuInNonRr }         ptr := nonrrheadptr^.nrl_fptr ;  
   found := FALSE ;  
        WITH lvparsebuf DO             BEGIN  { WITH lvparsebuf }            { traverse the list }         WHILE ( ( ptr <> NIL ) AND ( NOT found ) ) DO       
         BEGIN  { WHILE }  
              { if found update the entry }           IF ( ptr^.nrl_nonrr.nr_lu = lp_lu ) THEN                   BEGIN  { found it }                   found := TRUE ;               ptr^.nrl_enable := lp_enable ;                  END ; { found it }               ptr := ptr^.nrl_fptr ;                END; { WHILE  }            END ;  { WITH lvparsebuf }         LuInNonRr := found ;          END;  { LuInNonRr }                  $TITLE 'LvValidateAnswer',PAGE$   ${----------------------------------------------------------------------} $ ${       LvLalidateAnswer                                               } $ ${----------------------------------------------------------------------} $     ${ This routine validate the user respond to "LINK: " question          } $         
PROCEDURE LvValidateAnswer 
    (     lvparsebuf   : LvParseType ;        VAR valid        : Boolean     ;        VAR e_result     : Int16      );       {  Parameters :   "{     lvparsebuf    input     parsed user input to "LINK: " question " {     valid         output    true if it is a valid answer  {     e_result      output    error return  {   {}      LABEL      99 ;       VAR      valid_cost   : Boolean ;      valid_enable : Boolean ;      valid_type   : Boolean ;              BEGIN    { LvValidateAnswer }      
   valid := FALSE ;  
        { validate the LU at init time }          { validate the E/NE }     ValidEnable ( lvparsebuf , valid_enable , e_result ) ;      IF e_result <> GOOD THEN GOTO 99 ;       
   { validate the RR/NR }  
    ValidRtr ( lvparsebuf , valid_type , e_result ) ;     IF e_result <> GOOD THEN GOTO 99 ;          { validate the cost }     ValidCost ( lvparsebuf , valid_cost , e_result ) ;      IF e_result <> GOOD THEN GOTO 99 ;          valid :=  valid_enable AND valid_type AND valid_cost ;           99:   { return error if any }          END;     { LvValidateAnswer }      $TITLE 'NonRrCheckLu',PAGE$       #{--------------------------------------------------------------------} # "{         NonRrCheckLu                                             } " #{--------------------------------------------------------------------} #      { This routine searches the non rerouting  list if an LU equal }   { to input LU is found then that entry is marked as NOTUSED}      PROCEDURE NonRrCheckLu  
   (   LU       : Int16 ); 
     {  Parameters :   {     LU          input       rerouting lu  {   {}      LABEL      99 ;       VAR      ptr : NonRrLinkType ;     nptr: NrvMaLinkType ;             BEGIN     ptr := nonrrheadptr^.nrl_fptr ;         WHILE ptr <> NIL DO        WITH ptr^.nrl_nonrr DO           BEGIN           IF nr_lu = LU THEN   	            BEGIN  	             nr_lu := NOTUSED ;              nonrrents := nonrrents - 1 ;      !            { search the NRV list for that lu and change it to 0}  !             nptr := nrvmaheadptr^.nml_fptr;               WHILE nptr <> NIL DO                     BEGIN { searching the list }                  WITH nptr^.nml_nrv DO                        BEGIN { with each entry in the list }                     IF nrv_lu = lu THEN                            BEGIN { lu is matched }                       nrv_lu := 0 ;                       END;  { lu is matched }                        nptr := nptr^.nml_fptr;                         END;  { with each entry in the list }                      END;  { searching the list }       
            goto 99; 
             END;           ptr := ptr^.nrl_fptr;           END;   99:      END;           $TITLE 'NrvValidateAnswer',PAGE$      ${----------------------------------------------------------------------} $ ${          NrvValidateAnswer                                           } $ ${----------------------------------------------------------------------} $     ${ This routine validate the user respond to "NRV: " question           } $     PROCEDURE NrvValidateAnswer      (     nrvparsebuf  : NrvParseType ;       VAR linktype     : Int16 ;        VAR nrvma_prev   : NrvMaLinkType ;        VAR valid        : Boolean ;        VAR e_result     : Int16 ) ;           {  Parameters :   ${     nrvparsebuf       input      parsed user input to "NRV: " question $ {     linktype          output     link type of the first hop   &{     nrvma_prev        output     pointer to prev node in NrvMa list where  & !{                                  current node should be inserted !  {     valid             output     true if it is a valid respond   {     e_result          output     error return   {   {}      LABEL      99 ;       VAR      valid_add      : Boolean ;      valid_iplu     : Boolean ;      valid_lu       : Boolean ;      valid_lutout   : Boolean ;      valid_level    : Boolean ;      valid_neighbor : Boolean ;      valid_ma       : Boolean ;              BEGIN  { NrvValidateAnswer }       
   valid := FALSE ;  
     $   { validate the addresses and find the proper position in NrvMa list}  $ "   ValidAddrs ( nrvparsebuf , nrvma_prev , valid_add , e_result ) ;  "    IF e_result <> GOOD THEN GOTO 99 ;          { validate the LU }      ValidIpLu ( nrvparsebuf ,linktype , valid_iplu , e_result ) ;      IF e_result <> GOOD THEN GOTO 99 ;          { validate the LU timeout  }      ValidLuTout ( nrvparsebuf , valid_lutout , e_result ) ;     IF e_result <> GOOD THEN GOTO 99 ;          { validate the message level }      ValidLevel ( nrvparsebuf , valid_level , e_result ) ;     IF e_result <> GOOD THEN GOTO 99 ;          { validate the neighbor node }      ValidNeighbor ( nrvparsebuf , valid_neighbor , e_result ) ;     IF e_result <> GOOD THEN GOTO 99 ;       	   { Validate MA } 	    ValidMA ( nrvparsebuf , valid_ma , e_result );      IF e_result <> GOOD THEN GOTO 99 ;       &   valid := valid_add AND valid_iplu AND valid_level AND valid_neighbor AND  &             valid_ma ;      99:   { return error if any }          END;   { NrvValidateAnswer }           $TITLE 'ParseLV',PAGE$  ${---------------------------------------------------------------------}  $ ${         ParseLV                                                     }  $ ${---------------------------------------------------------------------}  $     ${ This routine parse the user input to "LINK: " question              }  $     	PROCEDURE ParseLV  	  (    input      : IStringType ;    VAR lvparsebuf : LvparseType ;    VAR response   : Int16)      ;      {  Parameters :   {     input       input       user respond  {     lvparsebuf  output      parsed user respond   {     response    output      error retuen  {   {}      LABEL      99 ;       CONST      LVERRORMSGNUM = 4;          LINKLUTOKEN   = 1 ;     ENABLETOKEN   = 2 ;     RR_NRTOKEN    = 3 ;     COSTTOKEN     = 4 ;      VAR      e_result   : Int16;     lastpos    : Int16;     parsetoken : Int16;      #{ This routine parses the input string, which is a user response to }  # #{ "Link:", and sets the variables in lvparsebuf accordingly         }  #        BEGIN         WITH lvparsebuf DO             BEGIN       
      lastpos := 0 ; 
           { get LU no default }         parsetoken := LINKLUTOKEN ;         Extractnumber ( input , lastpos , MAXLU , MINLU ,                         lp_lu , response );         IF response <> GOOD THEN GOTO 99 ;                { get link enable indicator default to enable}        parsetoken := ENABLETOKEN ;         stringtocheck := '' ;         Extractstring ( input , lastpos , stringtocheck ,                         outstring , response);            { if end of string or null string use default }   $      IF ( ( response = ERRNULLSTR ) OR ( response = ERREND_STR ) ) THEN $          lp_enable := DEFLUSTATUS             { if it was 'E' set enable flag            }        ELSE IF outstring = ENABLE_INDCTR THEN lp_enable := TRUE            { if it was 'NE' don't set enable flag     }  "      ELSE IF outstring = NOT_ENABLE_INDCTR THEN lp_enable := FALSE  "           { any thing else is not valid }   
      ELSE GOTO 99 ; 
               { get rerouting indicator default to rerouting }        parsetoken := RR_NRTOKEN ;        stringtocheck := '' ;         Extractstring ( input , lastpos , stringtocheck ,                         outstring , response );             { if end of string or null string use default }   $      IF ( ( response = ERRNULLSTR ) OR ( response = ERREND_STR ) ) THEN $          lp_rr := DEFLURR_NR            { if it was 'RR' then set router flag          }        ELSE IF outstring = RR_INDCTR THEN lp_rr := TRUE            { if it was 'NR' then don't set router flag    }        ELSE IF outstring = NOT_RR_INDCTR THEN lp_rr := FALSE             { any thing else is not valid                  }  
      ELSE GOTO 99 ; 
               { get link cost default to DEFCOST }        parsetoken := COSTTOKEN ;         Extractnumber ( input , lastpos , MAXCOST , MINCOST ,                         lp_cost , response );       $      IF ( ( response = ERRNULLSTR ) OR ( response = ERREND_STR ) ) THEN $              BEGIN           lp_cost := DEFCOST ;            response := GOOD ;            END ;      
      END; { WITH }  
        IF response <> GOOD THEN         BEGIN   99 :       MsgFilePrint( LINK_ERROR_OFFSET + parsetoken,                                   PMT_ERROR, 0, e_result );        IF e_result <> GOOD THEN           response := e_result         ELSE           response := ICANHANDLEIT;        END;         END;       $TITLE 'ParseNRV',PAGE$       %{-----------------------------------------------------------------------}  % %{         ParseNRV                                                      }  % %{-----------------------------------------------------------------------}  %     ${ This routine parses the user input to "LINK: " question              } $     
PROCEDURE ParseNRV(  
       input      : IStringType ;    VAR nrvparsebuf: nrvparseType;    VAR response   : Int16)      ;      {  Parameters:  {     input          input      user input  {     nrvparsebuf    output     parsed user input   {     response       output     error return  {   {}          LABEL      99 ;       CONST      NRVERRORMSGNUM = 8 ;       
   ROUTERTOKEN      = 1 ;  
 
   IPTOKEN          = 2 ;  
 
   LUTOKEN          = 3 ;  
 
   LUTIMEOUTTOKEN   = 4 ;  
 
   MSGLEVELTOKEN    = 5 ;  
 
   NEIGHBORTOKEN    = 6 ;  
 
   MATOKEN          = 7 ;  
 
   MATIMEOUTTOKEN   = 8 ;  
     VAR      e_result   : Int16;     lastpos    : Int16;     linktype   : Int16;     parseplace : Int16;     ip_addr    : Int16;     arpastring : ArpaStrType ;       "{ This routine parse the user input string, which is a response to } " "{ "NRV:", and sets the variables in nrvparsebuf accordingly        } "            BEGIN     WITH nrvparsebuf DO            BEGIN       
      lastpos := 0 ; 
           { get router address }        parseplace := ROUTERTOKEN;  !      Extractnumber ( input , lastpos , MAXRTRADDR , MINRTRADDR ,  !                    np_rtr_addr , response );        IF response <> GOOD THEN GOTO 99 ;            { get ip address }        parseplace := IPTOKEN ;         stringtocheck := '' ;   "      Extractstring ( input , lastpos , stringtocheck , arpastring , "                       response );         { if end of string or null string use default }   $      IF ( ( response = ERRNULLSTR ) OR ( response = ERREND_STR ) ) THEN $          BEGIN           np_ip_addr := DEFIPADDRESS ;            dirconnet := FALSE ;            END            ELSE               BEGIN  { get the ip address }           IF response <> GOOD THEN GOTO 99 ;            ArpaIpAdr ( arpastring , np_ip_addr , e_result);            IF e_result <> GOOD THEN GOTO 99 ;   "         IpRoute ( np_ip_addr , linktype , dirconnet , e_result ) ;  "          IF e_result <> GOOD THEN GOTO 99 ;            END ;  { get the ip address }                { get LU }        parseplace := LUTOKEN ;         Extractnumber ( input , lastpos , MAXLU , MINLU ,                         np_lu , response );       $      IF ( ( response = ERRNULLSTR ) OR ( response = ERREND_STR ) ) THEN $              BEGIN  { default value }   
         np_lu := DEFLU ;  
          END    { default value }             ELSE               BEGIN  { get user input }           IF response <> GOOD THEN GOTO 99 ;            END ;  { get user input }            { get LU timeout }        parseplace := LUTIMEOUTTOKEN ;  #      Extractnumber ( input , lastpos , MAXLUTIMEOUT , MINLUTIMEOUT ,  #                       np_lu_tout , response );             { if end of string or null string then use default       }   $      IF ( ( response = ERRNULLSTR ) OR ( response = ERREND_STR ) ) THEN $              BEGIN   { default value }           np_lu_tout := DEFLUTIMEOUT ;            END     { default value }            ELSE               BEGIN   { get user input }            IF response <> GOOD THEN GOTO 99 ;            END ;   { get user input }       
      {get message level } 
       parseplace := MSGLEVELTOKEN ;   "      Extractnumber ( input , lastpos , MAXMSGLEVEL , MINMSGLEVEL ,  "                       np_msg_lev , response );             { if end of string or null string use default           }    $      IF ( ( response = ERRNULLSTR ) OR ( response = ERREND_STR ) ) THEN $              BEGIN   { default value }           np_msg_lev := DEFMSGLEVEL ;           END     { default value }            ELSE               BEGIN  { get user input }           IF response <> GOOD THEN GOTO 99 ;            END ;  { user input }            { get neighbor inicator }         parseplace := NEIGHBORTOKEN ;         stringtocheck := NEIGHBOR_INDCTR ;        Extractstring ( input , lastpos , stringtocheck ,                         outstring , response);            { if end of string or null string use default }   $      IF ( ( response = ERRNULLSTR ) OR ( response = ERREND_STR ) ) THEN $              BEGIN  { default value }            np_nbr_nd := DEFNEIGHBORBIT ;           END    { default value }             ELSE               BEGIN           IF response <> GOOD THEN GOTO 99 ;            IF outstring = NEIGHBOR_INDCTR THEN np_nbr_nd := TRUE                                       ELSE np_nbr_nd := FALSE ;           END;             { get message accounting indicator }        parseplace := MATOKEN ;         stringtocheck := MA_INDCTR ;        Extractstring ( input , lastpos , stringtocheck ,                         outstring , response );             { if end of string or null string use default }   $      IF ( ( response = ERRNULLSTR ) OR ( response = ERREND_STR ) ) THEN $              BEGIN   { default value }           np_ma := DEFMABIT ;           END     { default value }            ELSE               BEGIN           IF response <> GOOD THEN GOTO 99 ;            IF outstring = MA_INDCTR THEN np_ma := TRUE                                 ELSE np_ma := FALSE ;           END;             { get ma timeout }        parseplace := MATIMEOUTTOKEN ;  #      Extractnumber ( input , lastpos , MAXMATIMEOUT , MINMATIMEOUT ,  #                       np_ma_tout , response );            { if end of string or null string use default }   $      IF ( ( response = ERRNULLSTR ) OR ( response = ERREND_STR ) ) THEN $              BEGIN           np_ma_tout := DEFMATIMEOUT ;            response := GOOD ;            END      
      END; { WITH }  
        IF response <> GOOD THEN             BEGIN   99 :        MsgFilePrint( NRV_ERROR_OFFSET + parseplace,                                 PMT_ERROR, 0, e_result );        IF e_result <> GOOD THEN               response := e_result               ELSE               response := ICANHANDLEIT;            END;         END;           $TITLE 'PostErrorProc',PAGE$  #{--------------------------------------------------------------------} # #{         PostErrorProc                                              } # #{--------------------------------------------------------------------} #     #{ This routine is called after an error message has been written by  } # #{ rtrinit to notify the user                                         } #     PROCEDURE PostErrorProc      ( VAR e_result    : Int16 );       {  Parameters :   {     e_result       output       error return  {   {}         BEGIN { post error processing }         SayOutputNeedsEdit;         IF  ( NOT initglobals.IG_interactive ) THEN      
      BEGIN { abort user } 
       e_result := ERRUSERINPUT ;        END;   { abort user }              END;  {post  error processing }              
$TITLE 'PrintLists',PAGE$  
 #{--------------------------------------------------------------------} # #{         PrintLists                                                 } # #{--------------------------------------------------------------------} #     PROCEDURE PrintLists ;             BEGIN  	   PrintNrvList ;  	    PrintLvList ;  
   PrintNonRrList ;  
    END;           
$TITLE 'PrintLvList',PAGE$ 
 #{--------------------------------------------------------------------} # #{         PrintLvList                                                } # #{--------------------------------------------------------------------} #     PROCEDURE PrintLvList;      ${ This is a debug routine to print the elements of the lv list in EMA }  $         VAR      e_result   : Int16 ;      ptr        : LvLinkType ;             BEGIN     ptr := lvheadptr^.ll_fptr ;         setstrlen ( outstring , 0 ) ;     strwrite ( outstring , 1 , npos , '* LvList entries: ');          PrintError ( outstring , e_result ) ;         WHILE ptr <> NIL DO            BEGIN             setstrlen ( outstring , 0 ) ;   	      WITH ptr^ DO 	 '         strwrite ( outstring , 1 , npos , '* Link Enable  = ' , ll_enable  ); '       PrintError ( outstring , e_result ) ;                 setstrlen ( outstring , 0 ) ;         WITH ptr^.ll_lv DO               BEGIN  $         StrWrite ( outstring , 1 , npos , lv_stat , lv_rsvd , lv_lklu , $                                            lv_lkcost );            PrintError ( outstring , e_result ) ;           SetStrLen ( outstring , 0 ) ;  "         StrWrite ( outstring , 1 , npos , lv_systime , lv_updnctr , "                                            lv_nbr_node ) ;           PrintError ( outstring , e_result ) ;               SetStrLen ( outstring , 0 ) ;  '         strwrite ( outstring , 1 , npos , '*    LU        = ' , lv_lklu     , ' &                                           '*    cost      = ' , lv_lkcost); &              PrintError ( outstring , e_result ) ;           setstrlen ( outstring , 0 );   '         strwrite ( outstring , 1 , npos ,'*    nbr_node   = ' , lv_nbr_node); '          PrintError ( outstring , e_result ) ;               END;             ptr := ptr^.ll_fptr ;             END;         END;           $TITLE 'PrintNonRrList',PAGE$   %{------------------------------------------------------------------------} % %{         PrintRrList                                                    } % %{------------------------------------------------------------------------} %     
PROCEDURE PrintNonRrList;  
     &{ This is a debug routine to print the elements of the nonrtr list in EMA }  &         VAR      e_result   : Int16 ;      ptr        : NonRrLinkType ;      outstring  : IStringType   ;      npos       : Int16         ;              BEGIN     ptr := nonrrheadptr^.nrl_fptr ;         setstrlen ( outstring , 0 ) ;  #   strwrite ( outstring , 1 , npos , '* Non router list entries : ');  #    PrintError ( outstring , e_result ) ;         WHILE ptr <> NIL DO            BEGIN             setstrlen ( outstring , 0 ) ;   	      WITH ptr^ DO 	 '         strwrite ( outstring , 1 , npos , '* link enable  = ' , nrl_enable ); '           PrintError ( outstring , e_result ) ;                 setstrlen ( outstring , 0 ) ;         WITH ptr^.nrl_nonrr DO      
         BEGIN   { WITH }  
 '         strwrite ( outstring , 1 , npos , nr_dummy , nr_lu , nr_nbr_node ) ;  '          PrintError ( outstring , e_result ) ;           SetStrLen ( outstring , 0 ) ;      '         strwrite ( outstring , 1 , npos , '*    LU        = ' , nr_lu       , ' &                                        '*    nbr_node  = ' , nr_nbr_node ); &          PrintError ( outstring , e_result ) ;           END ;            ptr := ptr^.nrl_fptr;             END;         END;           $TITLE 'PrintNrvList',PAGE$       ${----------------------------------------------------------------------} $ ${         PrintNrvList                                                 } $ ${----------------------------------------------------------------------} $     PROCEDURE PrintNrvList;       %{ This is a debug routine to print the elements of the nrvma list in EMA } %         VAR      e_result   : Int16 ;      ptr        : NrvMaLinkType ;              BEGIN     ptr := nrvmaheadptr^.nml_fptr ;         setstrlen ( outstring , 0 );      strwrite ( outstring , 1 , npos , '* NrvMaList entries :');         PrintError ( outstring , e_result );          WHILE ptr <> NIL DO            BEGIN             setstrlen ( outstring , 0 );  	      WITH ptr^ DO 	 %         strwrite ( outstring , 1 , npos , '* MA indicator = ' , nml_ma ,  % '                                           '* MA timeout   = ' , nml_ma_tout); '           PrintError ( outstring , e_result );            setstrlen ( outstring , 0 );  
      WITH ptr^.nml_nrv DO 
          BEGIN  $         strwrite ( outstring , 1 , npos , nrv_rtr_addr , nrv_lu_tout ,  $                     nrv_rsvd1 , nrv_msg_lev ) ;            PrintError ( outstring , e_result );                SetStrLen ( outstring , 0 ) ;  "         strwrite ( outstring , 1 , npos , nrv_chgbit , nrv_rsvd2 ,  " $                    nrv_nrtr_lu , nrv_nbr_nd , nrv_lu , nrv_ip_addr ) ;  $          PrintError ( outstring , e_result ) ;               SetStrLen ( outstring , 0 ) ;  '         strwrite ( outstring , 1 , npos , '*   rtr_adr   = ' , nrv_rtr_addr,  ' '                                           '*   lu_tout   = ' , nrv_lu_tout ); '                  PrintError ( outstring , e_result );                    setstrlen ( outstring , 0 );       '         StrWrite ( outstring , 1 , npos , '*   msg_lvl   = ' , nrv_msg_lev ,  ' '                                           '*   nrtr_lu   = ' , nrv_nrtr_lu ); '              PrintError ( outstring , e_result );                setstrlen ( outstring , 0 );   '         strwrite ( outstring , 1 , npos , '*   nbr_nod   = ' , nrv_nbr_nd  ,  ' '                                           '*   nrv_lu    = ' , nrv_lu      ,  ' '                                           '*   ip_addr   = ' , nrv_ip_addr ); '              PrintError ( outstring , e_result );                END;             ptr := ptr^.nml_fptr ;            END;         END;       $TITLE 'ReturnResources ', PAGE$  {------------------------------------------------------------}  {          ReturnResources                                   }  {------------------------------------------------------------}      ${ This routine returnes resource numbers and class numbers which were }  $ ${ allocated by router initialization to O.S.                          }  $     
PROCEDURE ReturnResources  
    ( VAR e_result     : Int16 ) ;       VAR      classnum    : Int16 ;         BEGIN  { ReturnResources }   
   e_result := GOOD; 
     
   { return MA resources } 
    DS_RetClass ( NSINIT_AdrOf( Lb_MAHC ), 0, e_result ) ;      DS_RetRn    ( NSINIT_AdrOf( Lb_MARN ), 0, e_result ) ;          { return input/output convertor class numbers }     DS_RetClass ( NSINIT_AdrOf( Lb_INCV ), 0, e_result ) ;      DS_RetClass ( NSINIT_AdrOf( Lb_OTCV ), 0, e_result ) ;          { GRPM's resources are deallocated by S1Kinit }         END;   { ReturnResources }               
$TITLE 'RtrAddrOk ', PAGE$ 
 {------------------------------------------------------------}  {                 R t r A d d r O k                          }  {------------------------------------------------------------}       { PURPOSE:                                                    }     {  The RtrAddrOk function compares the two router addresses   }     {  If the router addresses match then the address is invalid  }     {  and function returns false. It also print an error message }        	FUNCTION RtrAddrOk 	       (     rtr_addr1  : Int16 ;              rtr_addr2  : Int16 ;          VAR e_result   : Int16 ) : Boolean;       { Paramers :  {     rtr_addr1      input      router address  {     rtr_addr2      input      router address  {     e_result       output     error return  {   {}      
BEGIN { RtrAddrOk }  
    RtrAddrOk := TRUE;   
   e_result := GOOD; 
    IF ( rtr_addr1 = rtr_addr2 ) THEN        BEGIN { error }         MsgFilePrint( DUP_RTR_ADDR, PMT_ERROR, 0, e_result);  
      RtrAddrOk := FALSE;  
       END;  { error }   
END;  { RtrAddrOk }  
         $TITLE 'ShutNRV', PAGE$   {------------------------------------------------------------}  {                     S h u t N r v                          }  {------------------------------------------------------------}      &{ This routine  Stops all monitors, return resources to system (class/RN)  } & &{    and clear RES and DSAM globals values.                                } &     	PROCEDURE ShutNRV  	    (    trustvar    : TrustType;      VAR result      : Int16);       {  Parameters :   {     trustvar     input     indicates validity of the tables   {     result       output    error return   {   {}      VAR      e_result : Int16 ;          BEGIN   { ShutNrv }  	   result := GOOD; 	        StopMonitors( e_result ) ;   
   { ignore errors } 
        ReturnResources ( e_result ) ;   
   { ignore errors } 
        END ;  { ShutNrv }           $TITLE 'ShutRtr', PAGE$   {------------------------------------------------------------}  {                      S h u t R t r                         }  {------------------------------------------------------------}      { This routine disables all the links in link vector         }      	PROCEDURE ShutRTR  	    (    trustvar    : TrustType;      VAR result      : Int16);       {  Parameters :   {     trustvar     input     indicates validity of the tables   {     result       output    error return   {   {}      LABEL      99 ;       VAR      e_result  : Int16 ;     ierr      : Int16 ;     index     : Int16 ;     lvbuf     : LvType ;   
   nrrbuf    : NonRrType;  
    nonrrtd   : TableDescriptorType;                   PROCEDURE Exit  
(    exitparm:    Int16 ); 
 
   BEGIN    { Exit } 
        result := exitparm;     GOTO 99;   
   END;     { Exit } 
     $ PAGE $  
   BEGIN { ShutRtr } 
 	   result := GOOD; 	        { first stop #send, and ignore errors }      DS_StopMonitor ( '#SEND ' , e_result ) ;   { for rerouting }           { Note that we depend on MONINIT to shut MATIC }          IF trustvar = TRUST THEN             BEGIN   { tables are good }         e_result := GOOD;             { get number of entries in the link vector }         DS_GetResElement ( NSINIT_AdrOf( Lb_LCNT ), 0, lvents ) ;              { do it for all the links in link vector }        FOR index := 1 TO lvents DO                BEGIN   { for each lv entry }           DS_InitEnterCritical( wkmap , e_result ) ;            IF e_result <> GOOD THEN Exit( CANT_ENTER_CRIT );               Fetch_Lv( index , lvbuf ) ;               DS_InitLeaveCritical( wkmap ) ;               WITH lvbuf DO  Disconnect_LU( lv_lklu , e_result );           { Disconnect_lu prints error messages, if any. }                END;    { for each LV entry }            { get non rerouting table descriptor }        DS_InitEnterCritical( wkmap, e_result );        IF e_result <> 0 THEN Exit( CANT_ENTER_CRIT );      "      DS_FetchTableDescriptor( DS_NON_RR_TD , nonrrtd , e_result );  "       DS_InitLeaveCritical( wkmap );            { if table is initialized ...}        IF (( nonrrtd.td_wordsperelement <> 0 ) AND                                          ( e_result = 0 )) THEN                BEGIN {nonrr table is initialized}                { do it for all non rerouting links  }            FOR index := 1 TO nonrrtd.td_maxelement DO                   BEGIN   { for each nonrr link }               DS_InitEnterCritical( wkmap , e_result ) ;              IF e_result <> GOOD THEN Exit( CANT_ENTER_CRIT );                   Fetch_Nrr_Index( index , nrrbuf ) ;               DS_InitLeaveCritical( wkmap ) ;                   WITH nrrbuf DO Disconnect_LU ( nr_lu , e_result );              { Disconnect_LU will print error msgs, if any }               END;    { for non rerouting link }               END; {nonrr table is initialized}            { clear the entry in res }        DS_StoreResElement(NSINIT_AdrOf( Lb_LCNT ), 0, 0  ) ;             END;   { tables are good }      99:   
   END;  { ShutRtr } 
         
$TITLE 'StopMonitors',PAGE 
 {------------------------------------------------------------}  {         StopMonitors                                       }  {------------------------------------------------------------}      #{ This routine terminates the monitors which were started by router }  # #{ initialization                                                    }  #     PROCEDURE StopMonitors     ( VAR e_result    : Int16 ) ;      {  Paramers :   {     e_result       output      error return   {   {}         BEGIN   { StopMonitors }          { matic and #send are shutdown by ShutRtr }          DS_StopMonitor ( 'INCNV ' , e_result ) ;   { for input cvtr}        DS_StopMonitor ( 'OTCNV ' , e_result ) ;   { for output cvt}           { GRPM is shutdown by S1kinit }         END ;   { StopMonitors }               $TITLE 'StoreResValuesInDsam',PAGE  {------------------------------------------------------------}  {         S t o r e R e s V a l u e s I n D s a m            }  {------------------------------------------------------------}      { PURPOSE                                                    }  {  This routine reads values from RES and initializes some   }  {  entries in the DSAM globals table.  This is done for the  }  {  purpose of ROUTER in INPRO and OUTPRO.  ROUTER must build }  {  a router header for stream 13 messages and therefore      }  {  needs the message format level, the local node number and }  {  the maximum hop count.  The reason for storing these      }  {  values in DSAM is to prevent INPRO and OUTPRO from need-  }  {  ing access to labeled common.                             }      PROCEDURE StoreResValuesInDsam     (VAR e_result : Int16 );   {}  { Parameters:   {  e_result   OUTPUT   error return   {   { Side Effects:   {  NONE   {   
{ Global Data Structures:  
 {  local_node  accessed but not changed   {   	{ Error Handling:  	 {   {}      LABEL      99 ;       VAR      msg_level   :  Int16;     negnrvents  :  Int16;          BEGIN { StoreResValuesInDsam }         DS_InitEnterCritical ( wkmap , e_result ) ;     IF e_result <> GOOD  THEN GOTO 99 ;         msg_level := NS_MSG_LEVEL;      DS_StoreGlobal(DS_MSG_LEVEL,1,msg_level);      
   negnrvents := -nrvents; 
    DS_StoreGlobal(DS_MAX_HOP,1,negnrvents);          DS_StoreGlobal(DS_LOCAL_NODE,1,local_node);      %   IF NOT InitGlobals.IG_1k50_enable THEN   { grpm is started by router }  %       DS_StoreGlobal ( DS_GRPM_CLASS , 1 , grpmclass );          DS_InitLeaveCritical ( wkmap ) ;       99 :      END;  { StoreResValuesInDsam }          $TITLE 'SynNRV',PAGE$   {------------------------------------------------------------}  {         SynNRV                                             }  {------------------------------------------------------------}      PROCEDURE SynNRV     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);       { PURPOSE:                                                   }  {  SynNrv is responsible for prompting the user for informa- }  {  tion about the router network configuration.  The infor-  }  {  mation is retrieved from one question (see below). In this}  {  question the user supplies the node number, lu, timeout,  }  {  level, etc.                                               }      {  The information supplied in this question is the basis for}  {  four tables, the nodal routing vector (NRV), the message  }  {  accounting table (MA), the cost matrix (CM) and in part   }  {  the non-rerouting table (NONRR).  The NonRrList may be    }  {  reduced by the SynRtr routine which prompts the user for  }  {  link information.  [Note: The cost matrix is also based   }  {  on the size of the link vector (no. rerouting links).]    }  {  SynNrv builds linked lists in EMA to preserve the user    }  {  input.  InitNrv will later traverse the list and actually }  {  build the tables in DSAM.  Rather than build three linked }  {  lists in EMA, SynNrv uses a hybrid data structure contain-}  {  ing information about an NRV entry and any corresponding  }  {  MA table entry.  This is called appropriately NrvMaList.  }      {  The NonRrList is built at this time to prevent loss of    }  {  information. It is possible for the user to provide a link}  {  LU in the NRV question and not enable it later.  If that  }  {  occurs this will be the only place the LU can be recorded.}      $PAGE$  {}  { Parameters:   {  smbsize       OUTPUT  required SMB size in words   {  dsamtbsize    OUTPUT  required DSAM table size in words  {  socketcnt     OUTPUT  required number of sockets   {  classcnt      OUTPUT  required number of class numbers   {  rsncnt        OUTPUT  required number of resource numbers  {  result        OUTPUT  good/bad result return   {   { Side Effects:   {   {   
{ Global Data Structures:  
 {  lvents        used by InitNrv to build the cost matrix   {   	{ Error Handling:  	 {   {   { Algorithm:  {   {}      LABEL      99;      CONST   
   NUMBERMSGS = 13 ; 
     TYPE     msgarraytype = ARRAY [1..NUMBERMSGS] OF IStringType;       CONST      { prompt header for NRV questions }     PMSG = msgarraytype[      IStringType[   ''* Enter the Nodal Routing Vector (NRV) information. Type /E to end. Format:'  ' 	               ],  	    IStringType[   %   '* <Node Number>, <IP addr>, <LU>, <LU T/O>, <Level>, N, MA, <MA T/O>'  % 	               ],  	    IStringType[      '*'  	               ],  	    IStringType[      '* Where: '  	               ],  	    IStringType[      '*    node number: Router/1000 node address'   	               ],  	    IStringType[   "   '*    IP Address : IP Address. Format: n.n.n.n where n = 1..255'  " 	               ],  	    IStringType[   %   '*    LU         : Link LU if rerouting is not used to access the node' % 	               ],  	    IStringType[      '*    LU T/O     : Link timeout in seconds'  	               ],  	    IStringType[      '*    level      : DS/1000 software level'   	               ],  	    IStringType[   ''*    N          : Neighbor bit, set if this node is a neighbor to local node' ' 	               ],  	    IStringType[   %   '*    MA         : Use Message Accounting in transactions to this node' % 	               ],  	    IStringType[      '*    MA T/O     : Message Accounting timeout in seconds'  	               ],  	    IStringType[      '*'  	               ]]; 	         VAR      casefold          :   Boolean;      default           :   Boolean;      e_result          :   Int16;      response          :   Int16;      linktype          :   Int16;      index             :   Int16;      nrvma_prev        :   NrvMaLinkType;      nrvma_save        :   NrvMaLinkType;      prompt_flag       :   Boolean;      terminator        :   Boolean;      user_input_c      :   IStringType;      valid             :   Boolean;               	BEGIN  { SynNRV }  	     { check if router is needed }   IF InitGlobals.IG_need_RTR THEN      BEGIN { router is needed }           
   casefold := TRUE; 
    default  := FALSE;           { Initialize the table size counters and the list pointers. }      Initialize;         FOR index := 1 TO LASTRTRBANNER DO         BEGIN    { print banner }             PrintPrompt( FALSE, RTRBANNER[index], e_result );         IF e_result <> GOOD THEN GOTO 99;         END;     { print banner }           { Prompt user for local node's router address and insert it }       { as the first entry in the EMA list.                       }   
   GetLocalNode(e_result); 
    IF (e_result <> GOOD) THEN GOTO 99;          { get ma retry limmit only if old services are enable       }      IF InitGlobals.IG_1k50_enable THEN             BEGIN { it is ok yo have ma }         GetMaRetryLimit ( e_result ) ;        IF ( e_result <> GOOD ) THEN GOTO 99 ;        END ; { it is ok to have ma }          { print banner information about NRV input  }  
   prompt_flag := FALSE ;  
    FOR index := 1 TO NUMBERMSGS DO        BEGIN         PrintPrompt ( prompt_flag , pmsg[index] , e_result );         IF e_result <> GOOD THEN GOTO 99;         END;         REPEAT { until terminator or error }       
      terminator := TRUE;  
       CharInput(NRV_PROMPT,casefold,default,terminator,                   user_input_c,e_result);             IF (e_result <> GOOD) THEN GOTO 99;             IF (NOT terminator) THEN           BEGIN { parse the user input }                ParseNRV(user_input_c,nrvparsebuf,response);                IF response = GOOD THEN              BEGIN { check if address valid }      '            NrvValidateAnswer(nrvparsebuf,linktype,nrvma_prev,valid,e_result); '             IF e_result <> GOOD THEN GOTO 99 ;      
            IF valid THEN  
                BEGIN { insert into EMA list }                      InsertNrvMa(nrvma_prev,nrvparsebuf,linktype);                      { if user specified LU then assume it is nonrr }                   WITH nrvparsebuf DO                    IF np_lu <> 0 THEN                           BEGIN { non rerouting LU }                        InsertNonRr(nrvparsebuf,e_result);                            { it is OK if e_result is duplicate }  $                     IF e_result = DUPLICATELU  THEN e_result := GOOD ;  $                          END ;  { insert into EMA list }                     END   { insert into EMA list }                   ELSE                     BEGIN   { not a valid answer }                  PostErrorProc( e_result ) ;                 END ;   { not a valid answer }                   END { GOOD response }                ELSE                   BEGIN   { not a good response }               PostErrorProc ( e_result ) ;              IF ( e_result = ERRUSERINPUT ) THEN GOTO 99 ;                   IF response <> ICANHANDLEIT THEN                     BEGIN { I can't handle the error }                  e_result := response ;                  END; { I can't handle the error }               END;  { not a good response }            END;  { parse the user input }             UNTIL (terminator OR ( e_result <> GOOD ));             { Return the total DSAM size (words) required by the NRV, }     { MA and NONRR Tables.  Set the SynNrv result parameter.  }         IF ( e_result = GOOD ) THEN            BEGIN { calculate the needed resources    }             { if only local node is in nrv then we wont have nrv }        IF nrvents = 1 THEN ClearNrvMaList ;            { if we have a valid NRV we better have 'queue'.  }         IF nrvents > 1 THEN InitGlobals.IG_need_queue := TRUE ;             { DSAM needed for non_router table will be asked at }         { SynRtr because more entries may be added later    }         dsamtbsize :=  NRVELEMENTSIZE * nrvents +                        MAELEMENTSIZE * maents ;         { find needed resourcenumbers and classnumbers }            IF have_ma THEN       
         BEGIN { have ma } 
          rsncnt := rsncnt + MANEEDEDRESOURCENUMBERS ;            classcnt := classcnt + MANEEDEDCLASSNUMBERS ;  
         END;  { have ma } 
         
      IF need_convtrs THEN 
              BEGIN  { need convertors }            rsncnt := rsncnt + CVTSNEEDEDRESOURCENUMBERS ;            classcnt := classcnt + CVTSNEEDEDCLASSNUMBERS ;           END; { need convertors }       '      {if we don't have old services then router should allocate classnumber } ' '      { for grpm                                                             } ' $      IF ( ( NOT InitGlobals.IG_1k50_enable ) AND ( nrvents > 1 ) ) THEN $          classcnt := classcnt + GRPMNEEDEDCLASSNUMBERS ;            END;  { calculate the needed resources   }      99:      result := e_result ;      END ; { router is needed }       	END;   { SynNrv }  	     $TITLE 'SynRtr',PAGE$   {------------------------------------------------------------}  {                       S y n R t r                          }  {------------------------------------------------------------}      PROCEDURE SynRtr     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);       { PURPOSE:                                                   }  {  SynRtr is responsible for prompting the user for router   }  {  link information.  The information is retrieved from one  }  {  question (see below).  This question most closely resem-  }  {  bles the "link enable" question asked by DINIT.           }      {  SynRtr builds the link vector (LvList) in EMA and adds to }  {  the NonRrList if it has been started by SynNrv.  If a user}  {  specifies a link as a rerouting link, SynRtr will scan    }  {  the NonRrList to check is the link was specified by the   }  {  user in the NRV question.  If so the rerouting character- }  {  istic of the link will override and the NonRrList entry   }  {  is marked invalid (i.e. the router address is set equal   }  {  to NOTUSED).  When the actual NonRr table is built in }  {  DSAM the bogus entries in the NonRr list is EMA are       }  {  skipped.                                                  }  {   { Parameters:   {  smbsize       OUTPUT  required SMB size in words   {  dsamtbsize    OUTPUT  required DSAM table size in words  {  socketcnt     OUTPUT  required number of sockets   {  classcnt      OUTPUT  required number of class numbers   {  rsncnt        OUTPUT  required number of resource numbers  {  result        OUTPUT  good/bad result return   {   {   {}      LABEL      99;      CONST   
   NUMBERMSGS = 6 ;  
     TYPE     msgarraytype = ARRAY [1..NUMBERMSGS] OF IStringType;       CONST      { Link vector prompt header }     PMSG = msgarraytype[      IStringType[       '* Enter the LU information for Router/1000. Type /E to end.'   	               ],  	    IStringType[      '* Format: <Link LU>, (E)/NE, (RR)/NR, <cost: [(1)..99]>'  	               ],  	    IStringType[      '*'  	               ],  	    IStringType[      '* Where: '  	               ],  	    IStringType[      '*    E = Enable, NE = do Not Enable '   	               ],  	    IStringType[      '*   RR = use ReRouting, NR = do Not use ReRouting'  	               ]]; 	         VAR      casefold          :   Boolean;      default           :   Boolean;      e_result          :   Int16;      index             :   Int16;      prompt_flag       :   Boolean;      response          :   Int16;      terminator        :   Boolean;      user_input_c      :   IStringType;      valid             :   Boolean ;      	BEGIN  { SynRTR }  	     { if no entries in the nrv, do nothing }  IF ( ( NOT InitGlobals.IG_need_RTR ) OR ( nrvents = 0 ) ) THEN         BEGIN  { empty nrv }          e_result := GOOD ;      GOTO 99 ;         END;   { empty nrv }           { print banner information about links }  prompt_flag := FALSE ;  FOR index := 1 TO NUMBERMSGS DO      BEGIN     PrintPrompt ( prompt_flag , pmsg[index] , e_result );     IF e_result <> GOOD THEN GOTO 99 ;      END;       REPEAT  { until terminator or error }      terminator := TRUE ;   !   CharInput ( LINK_LU_PROMPT , casefold , default , terminator ,  !                user_input_c  , e_result );         IF  e_result <> GOOD THEN GOTO 99 ;      
   IF NOT terminator THEN  
       BEGIN         { insert the entry in the lvlist }        ParseLV ( user_input_c , lvparsebuf , response ) ;            IF response = GOOD THEN       
         BEGIN { IF GOOD } 
              LvValidateAnswer( Lvparsebuf , valid , e_result ) ;           IF e_result <> GOOD THEN GOTO 99 ;                IF valid THEN                  BEGIN { valid answer }                  WITH lvparsebuf DO                     BEGIN { WITH lvparsebuf }                     IF lp_rr THEN                        BEGIN  { rerouting }                        have_rr := TRUE ;       #                  { if in nonrr list then mark the entry in the list } # #                  { because rereouting over ride non rerouting       } #                   NonRrCheckLu ( lp_lu ) ;                        InsertLv ( lvparsebuf , e_result ) ;                        { print an error if LU is already enter }                     IF e_result = DUPLICATELU  THEN                            BEGIN  { duplicate LU }  #                     MsgFilePrint( DUPLUERR, PMT_ERROR, 0, e_result);  #                      PostErrorProc ( e_result ) ;   $     (*!!!!!         IF e_result = ERRUSERINPUT THEN GOTO 99 ;   !!!!!*) $                      END;    { duplicate LU }                         END    { rerouting }      
               ELSE  
                       BEGIN  { non rerouting }      #                  { the LU should be in the nonrr list otherwise is }  # #                  { meaningless , go update it .                    }  #                   IF NOT LuInNonRr ( lvparsebuf ) THEN                           BEGIN  { not in nonrr list }   $                     MsgFilePrint( NOTINNONRR, PMT_ERROR, 0, e_result);  $                      PostErrorProc ( e_result ) ;   %     {!!!!!!!        IF e_result = ERRUSERINPUT THEN GOTO 99 ;    !!!!!!}  %                      END;    { not in nonrr list }                        END ; { non rerouting }                      END; { WITH lvparsebuf }                   END   { valid answers }                ELSE    { not a valid answer }                   PostErrorProc( e_result ) ;       
         END   { IF GOOD } 
           ELSE               BEGIN  { bad response }           PostErrorProc ( e_result ) ;                IF ( e_result = ERRUSERINPUT ) THEN GOTO 99 ;               IF response <> ICANHANDLEIT THEN                   BEGIN { I can't handle the error }              e_result := response ;              END; { I can't handle the error }                END;  { bad response }             END ;  { parse the user input }              UNTIL ( terminator OR ( e_result <> GOOD) );           IF e_result = GOOD THEN      BEGIN  { calculate size of needed resources }      !   { size of DSAM neede for router table consist of entries from } ! !   { NRV initialization also                                     } !    dsamtbsize := LVELEMENTSIZE * lvents                  + lvents * nrvents * 2  { for cost matrix }                 + NONRRELEMENTSIZE * nonrrents ;           	   IF have_rr THEN 	           BEGIN  { have rr }        classcnt := classcnt + RRNEEDEDCLASSNUMBERS ;         rsncnt := rsncnt + RRNEEDEDRESOURCENUMBERS ;  
      END;    { have rr }  
        END;   { calculate size of needed resources }  99:      result := e_result ;       END;  { SynRTR }          $TITLE 'ValidAddrs ', PAGE$   {------------------------------------------------------------}  {                 V a l i d A d d r s                        }  {------------------------------------------------------------}      { PURPOSE:                                                   }  {  Scan the NrvMa list being created in EMA.  Search for the }  {  position in the list where the router address belongs.    }  {  Verify that the router address and the IP address supplied}  {  by the user are acceptable.  The router address must be   }  {  unique.  The IP address must be unique if the network por-}  {  tion of the IP address is the same as the network portion }  {  of the local node's IP address. It also returns a pointer }  {  to node before the position of the router address in the  }  {  list.                                                     }      PROCEDURE  ValidAddrs      (    nrvparsebuf : NrvParseType;       VAR nrvma_prev  : NrvMaLinkType;      VAR valid       : Boolean;      VAR result      : Int16) ;      {}  {  return values for valid :  {  TRUE          The router and ip address are legal addresses  {   "{  FALSE         Either the router or ip address failed the validity " {                  check  {   { Parameters:   #{  nrvparsebuf   INPUT   buffer with user responses to this NRV ques.  # #{  nrvma_prev    OUTPUT  pointer to entry in the list we insert after  # {  valid         OUTPUT  return value   {  result        OUTPUT  catastrophic error return  {   
{ Global Data Structures:  
 {  nrvma_head    used to initialize pointers, not changed.  {   {}      LABEL      99;      VAR      ip_addr          :   Int32;     e_result         :   Int16;     nrvma_ptr        :   NrvMaLinkType;     rtr_addr         :   Int16;     search_not_done  :   Boolean;     valid_ip         :   Boolean;     valid_ip_rtr     :   Boolean;      
BEGIN { ValidAddrs } 
     { initialize the varaiables }   nrvma_prev := NrvMaHeadPtr ;  
valid_ip   := TRUE ; 
 
e_result   := GOOD ; 
     
WITH nrvparsebuf DO  
    BEGIN { search for the proper position in the list }       "   WHILE ( ( nrvma_prev^.nml_fptr <> NIL )  AND  { not end of list } "     %         ( nrvma_prev^.nml_fptr^.nml_nrv.nrv_rtr_addr < np_rtr_addr ) AND  % %                                { not passed the right position to insert} % "         ( valid_ip ) ) DO                   { ip address is valid } "           BEGIN  { WHILE }            WITH nrvma_prev^.nml_fptr^.nml_nrv DO                BEGIN { WITH }   &         { dirconnet is set by parsenrv and it is true if np_ip_addr is on } &          { a direct connect network }   %         IF (NOT IpAddrOk(np_ip_addr,nrv_ip_addr,dirconnet,e_result)) THEN % 	            BEGIN  	             valid_ip := FALSE ;               END;           IF e_result <> GOOD THEN GOTO 99 ;            END ; { WITH }             { advance the pointer }         nrvma_prev := nrvma_prev^.nml_fptr;       
      END; { WHILE } 
     #   { so far we haven't found any problem and nrvma_prev is pointing }  # #   { to the node where new entry should be inserted after.  Now save}  # #   { this position and use another pointer.                         }  #        nrvma_ptr := nrvma_prev^.nml_fptr;       
   IF valid_ip THEN  
 	      BEGIN { IF } 	       valid_ip_rtr := TRUE ;      &      { check the next entry for duplicate router address                 }  &       IF ( ( nrvma_ptr <> NIL ) AND   &           ( NOT RtrAddrOk( np_rtr_addr , nrvma_ptr^.nml_nrv.nrv_rtr_addr ,  &                           e_result ) ) ) THEN            BEGIN { duplicate router address }            valid_ip_rtr := FALSE ;           END;  { duplicate router address }             WHILE ( ( nrvma_ptr <> NIL ) AND                ( valid_ip_rtr ) ) DO   
         BEGIN  { WHILE }  
              WITH nrvma_ptr^.nml_nrv DO                   BEGIN  { WITH }       &            IF(NOT IpAddrOk(np_ip_addr,nrv_ip_addr,dirconnet,e_result)) THEN & 
               BEGIN 
                valid_ip_rtr := FALSE ;  
               END ; 
                 IF e_result <> GOOD THEN GOTO 99 ;      
            END ; { WITH } 
              { advance the pointer }           nrvma_ptr := nrvma_ptr^.nml_fptr;               END ; { WHILE }      	      END ; { IF } 	     	   END ; { WITH }  	     99:   
result := e_result ; 
 Valid := valid_ip AND valid_ip_rtr ;  
END ; { ValidAddrs } 
         $TITLE 'ValidCost',PAGE$  ${----------------------------------------------------------------------} $ ${        ValidCost                                                     } $ ${----------------------------------------------------------------------} $     ${ validate the cost entry                                              } $         
PROCEDURE ValidCost  
    (     lvparsebuf   : LvParseType ;        VAR valid        : Boolean ;        VAR e_result     : Int16 ) ;       {  Parameters:  "{     lvparsebuf     input    parsed user input to "LINK: " question " {     valid          output   true if valid respond   {     e_result       output   error return  {   {}         BEGIN  { ValidCost }          { it only needs to be in range which already tested for }  	   valid := TRUE ; 	    e_result := GOOD ;          END ;  { ValidCost }           
$TITLE 'ValidEnable',PAGE$ 
 ${----------------------------------------------------------------------} $ ${      ValidEnable                                                     } $ ${----------------------------------------------------------------------} $     ${ this routine validate the enable answer                              } $     PROCEDURE ValidEnable      (     lvparsebuf  : LvParseType ;       VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;      {  Parameters:  "{     lvparsebuf     input    parsed user input to "LINK: " question " {     valid          output   true if valid respond   {     e_result       output   error return  {   {}      
   BEGIN  { ValidEnable }  
     	   { No checking } 	 	   valid := TRUE ; 	    e_result := GOOD ;          END ; { ValidEnable }          
$TITLE 'ValidLevel',PAGE$  
 ${----------------------------------------------------------------------} $ ${     ValidLevel                                                       } $ ${----------------------------------------------------------------------} $     ${ This routine validate the level                                      } $     
PROCEDURE ValidLevel 
    (     nrvparsebuf : NrvParseType ;        VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;          {  Parameters:  "{     nrvparsebuf    input    parsed user input to "NRV: " question  " {     valid          output   true if valid respond   {     e_result       output   error return  {   {}      
   BEGIN    { ValidLevel } 
     #   { must have old services if old level }     {!!!!!! ******* !!!!!!} # 	   valid := TRUE ; 	    e_result := GOOD ;          WITH  nrvparsebuf DO             BEGIN { WITH nrvparsebuf }        { we should have old services to talk to 91740 node }   %      IF ( ( np_msg_lev = 0 ) AND ( NOT InitGlobals.IG_1k50_enable ) )THEN %              BEGIN { don't have old services }           MsgFilePrint( BAD_LEVEL, PMT_ERROR, 0, e_result ) ;  
         valid := FALSE ;  
          END ; { don't have old services }            END ; { WITH nrvparsebuf }      
   END;     { ValidLevel } 
             $TITLE 'ValidDsLu',PAGE$  ${----------------------------------------------------------------------} $ ${      ValidDsLu                                                       } $ ${----------------------------------------------------------------------} $     ${ This routine validates the LU                                        } $     
PROCEDURE ValidDsLu  
    (     LU          : Int16 ;       VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;          {  Parameters:  {     LU             input    LU to be validated  {     valid          output   true if valid respond   {     e_result       output   error return  {   {}      VAR      error  :    Int16;       
   BEGIN     { ValidDsLu } 
        { assume everything is OK }  	   valid := TRUE ; 	    e_result := GOOD ;       	   IF LU > 0 THEN  	           BEGIN  { LU is specified }        CheckDriverType( LU, DRIVER66, e_result );        IF e_result <> 0  THEN           BEGIN    { error from routine }           IF e_result = CHKDRIVER_BADTYPE THEN               BEGIN  { bad driver type }                  outstring := BAD_LU_MSG;              END    { bad driver type }             ELSE               BEGIN  { other lu error }                   outstring := STAT_LU_ERR_MSG1 + STAT_LU_ERR_MSG2;               e_result := ERR_ALREADY_PRINTED;              END;   { other lu error }                 Strwrite ( outstring , Strlen(outstring),  npos , lu:1,   $                                                       END_OF_ERR_MSG ); $          PrintError ( outstring , error );  
         valid := FALSE ;  
              END;   { error from routine }        END ;    { LU is specified }      
   END;      { ValidDsLu } 
             $TITLE 'ValidIpLu',PAGE$  ${----------------------------------------------------------------------} $ ${         ValidIpLu                                                    } $ ${----------------------------------------------------------------------} $     ${ This routine verifies that linktype and ip address match. That is , }  $ ${ if the link type is not roter link then LU should be 0. if LU <> 0  }  $ ${ then it must be router link                                         }  $         
PROCEDURE ValidIpLu  
    (     nrvparsebuf : NrvParseType ;        VAR linktype    : Int16 ;       VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;      {  Parameters:  "{     nrvparsebuf    input    parsed user input to "NRV: " question  " {     linktype       output   link type of the first hop  {     valid          output   true if valid respond   {     e_result       output   error return  {   {}          
   BEGIN     { ValidIpLu } 
        { assume everything is OK }  	   valid := TRUE ; 	    e_result := GOOD ;          WITH nrvparsebuf DO            BEGIN  { WITH nrvparsebuf }             IF ( np_ip_addr = DEFIPADDRESS ) THEN                BEGIN { no ip address to check }                { use default link type }           linktype := ROUTER ;       (*       IF ( np_lu <> 0 ) THEN    NO NEED FOR THIS CHECK                   BEGIN { error }                   MsgFilePrint( BADIPLU, PMT_ERROR, 0, e_result ) ;               valid := FALSE ;                  END ; { error }          *)                END   { no ip address to check }             ELSE               BEGIN { there is an ip address to check }      
         { get link type } 
          GetLinkType ( np_ip_addr , linktype , e_result) ;               { only router lu's should be specified }            IF ( ( e_result <> GOOD ) OR   !              ( ( np_lu <> 0 ) AND ( linktype <> ROUTER ) ) ) THEN !                 BEGIN  { non router LU }      !            MsgFilePrint( BADLINKTYPE, PMT_ERROR, 0, e_result ) ;  !             valid := FALSE ;                  END ;  { non router LU }               END; { there is an ip address to check }             END ;  { WITH nrvparsebuf }       
   END;      { ValidIpLu } 
             
$TITLE 'ValidLuTout',PAGE$ 
 ${----------------------------------------------------------------------} $ ${      ValidluTout                                                     } $ ${----------------------------------------------------------------------} $     ${ validate the LU timeout                                              } $     PROCEDURE ValidLuTout      (     nrvparsebuf : NrvParseType ;        VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;      {  Parameters:  "{     nrvparsebuf    input    parsed user input to "NRV: " question  " {     valid          output   true if valid respond   {     e_result       output   error return  {   {}             BEGIN { ValidLuTout }      	   { no checking } 	 	   valid := TRUE ; 	    e_result := GOOD ;          END;  { ValidLuTout }              $TITLE 'ValidMa',PAGE$  ${----------------------------------------------------------------------} $ ${    ValidMa                                                           } $ ${----------------------------------------------------------------------} $     ${ Validate the ma variables                                            } $     	PROCEDURE ValidMa  	    ( VAR nrvparsebuf : NrvParseType ;        VAR valid_ma    : Boolean ;       VAR e_result    : Int16 ) ;      {  Parameters:  {     nrvparsebuf    input    parsed nrv answer   {     valid_ma       output   true if valid respond   {     e_result       output   error return  {   {}      VAR      msgbuffer         : IStringType ;         BEGIN   { Valid Ma }          { assume everything is OK }     valid_ma := TRUE ;      e_result := GOOD ;          WITH nrvparsebuf DO            BEGIN  { WITH parsed buffer }       
      IF np_ma THEN  
     
         BEGIN  { IF ma }  
               IF  ( np_ma_tout * maretry > InitGlobals.IG_msto ) THEN                   BEGIN  { invalid ma timeout/retry }                   MsgFilePrint( BAD_MA, PMT_ERROR, 0, e_result );               valid_ma := FALSE ;                   END;   { invalid ma timeout/retry }       
         END;   { IF ma }  
           END ;  { WITH parsed buffer }          END ;   { Valid Ma }                   $TITLE 'ValidNeighbor',PAGE$  ${----------------------------------------------------------------------} $ ${         Validneighbor                                                } $ ${----------------------------------------------------------------------} $     PROCEDURE Validneighbor      (     nrvparsebuf : NrvParseType ;        VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;          {  Parameters:  "{     nrvparsebuf    input    parsed user input to "NRV: " question  " {     valid          output   true if valid respond   {     e_result       output   error return  {   {}      VAR      ptr     : NrvMaLinkType ;             BEGIN   { ValidNeighbor }         { assume everything is OK }  	   valid := TRUE ; 	    e_result := GOOD ;          WITH nrvparsebuf DO            BEGIN   { WITH nrvparsebuf }            { only do it if user specified 'N' }        IF np_nbr_nd THEN                BEGIN  { user specified 'N' }               ptr := nrvmaheadptr^.nml_fptr ;               WHILE ptr <> NIL DO                  BEGIN  { WHILE not end of list }                  WITH ptr^.nml_nrv DO                     BEGIN  { with each node in the list }                     { can have one neighbor on each LU }   #               IF ( ( nrv_nbr_nd ) AND         { neighbor bit is set } # #                    ( nrv_lu = np_lu ) AND     { lu's are the same   } # #                    ( nrv_lu <> 0 ) ) THEN     { LU is not unKnown   } #                       BEGIN  { multiple neighbor }      $                  MsgFilePrint( BAD_NEIGHBOR, PMT_ERROR, 0, e_result );  $                   valid := FALSE ;                        END;   { multiple neighbor }                     ptr := ptr^.nml_fptr ;                      END ;  { with each node in the list }                  END;  { WHILE not end of list }                END;  { user specified 'N'}            END;    { WITH nrvparsebuf }         END;    { ValidNeighbor }          $TITLE 'ValidRtr',PAGE$   ${----------------------------------------------------------------------} $ ${     ValidRtr                                                         } $ ${----------------------------------------------------------------------} $         	PROCEDURE ValidRtr 	    (     lvparsebuf  : LvParseType ;       VAR valid       : Boolean ;       VAR e_result    : Int16 ) ;      {  Parameters:  "{     lvparsebuf     input    parsed user input to "LINK: " question " {     valid          output   true if valid respond   {     e_result       output   error return  {   {}         BEGIN   { ValidRtr }       	   { no checking } 	 	   valid := TRUE ; 	    e_result := GOOD ;          END;    { ValidRtr }           END. 