 $PASCAL '91790-1X198 REV.4010 <860227.1103> '   $STANDARD_LEVEL 'HP1000'  $debug$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	     MODULE S1KInit;   	$ALIAS 'N$S1KInit' 	     {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  {     NAME:   S1KINIT   
{     SOURCE: 91790-18198  
 	{     RELOC:  NONE 	 	{     PGMR:   EMS  	 {}          {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date   PCO  Prgmr Description  ${  860225      lms   Put errors in NSINIT.MSG, enhance startup/shutdown  $ ${                    error reporting. Stop clearing GRPM class in DSAM,  $ {                    Make ShutSM in-line code (n356).   {  Last edit: <860227.1103>   {   {------------------------------------------------------------   {}      {}  {   "{  This module contains the DS/1000-IV Compatible Services routines  " {  for NSINIT.  {   {}      IMPORT     $SEARCH 'phtm/bodec.rel'      bodec,      $SEARCH 'phtm/mmdec.rel'      mmdec,      $SEARCH 'phtm/mmext.rel'      ds_mm,      $SEARCH 'phtm/init_dec.rel'     init_dec,     $SEARCH 'phtm/initmulti.xpt'      initmulti,      $SEARCH 'phtm/parsdd.xpt'     parser,     $SEARCH 'phtm/filemad.xpt'      fileman,      $ SEARCH 'phtm/dres.xpt' $      dres,     $ SEARCH 'phtm/init_rte_if.xpt'     init_rte_if,      $ SEARCH 'phtm/alloc.xpt' $     alloc,      $ SEARCH 'phtm/s3kinit.xpt' $     s3kinit;           $SUBTITLE ' Export procedures ', PAGE$      EXPORT      {--------------------------------------------------------}  {                                                        }  {          EXPORT   PROCEDURES                           }  {                                                        }  {--------------------------------------------------------}          PROCEDURE Syn1Ks     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);           	PROCEDURE Shut1Ks  	    (    trustvar    : TrustType;      VAR result      : Int16);           	PROCEDURE Init1Ks  	    (VAR result : Int16);          {----------------------------------------------------}  {               Implement Section                    }  {----------------------------------------------------}      IMPLEMENT       CONST      EXEC12 = 12+BIT15;      ONESEC = -1;      ONCE   = 0;     SECS   = 2;  
   TCBENTRYSIZE = 6; 
     
   LASTTIMEMSG =  9; 
     TYPE     TimeMsgArray = Array[1..LASTTIMEMSG] OF IStringType;       CONST      FIRSTTIMEOUTQ =   7;      LASTTIMEOUTQ =    9;      LASTTIMEBANNER =  5;      TIMEQ        =    6;   
   TIMEMSG= TimeMsgArray[  
 IStringType['*++   DS/1000-IV Timeout Values    ++*'],  IStringType['* Master timeout in seconds:      45'],  IStringType['* Slave timeout in seconds:       30'],  IStringType['* Idle "session" timer in hours:   5'],  	IStringType['* '], 	 IStringType['* Do you want to modify these values [Y/(N)]?_'],  $IStringType['* Enter the master timeout in seconds [5..(45)..1275]:_'],  $ #IStringType['* Enter the slave timeout in seconds [5..(30)..1275]:_'], # &IStringType['* Enter the idle "session" timeout in hours [0..(5)..45]:_'] ]; &     TYPE     TimeQArray = Array[FIRSTTIMEOUTQ..LASTTIMEOUTQ] OF Int16;  VAR   
   have91750:     Boolean; 
 
   have1000:      Boolean; 
    tcbcount:      Int16;  "   timevalue:           Array[FIRSTTIMEOUTQ..LASTTIMEOUTQ] OF Int16; "    updatetimeouts:      Boolean;     smb_block:         Int16;     numofpool:         Int16;      $ SUBTITLE 'Slave Monitor Variables', PAGE $  CONST   	   STREAM1 =   1;  	 	   STREAM2 =   2;  	 	   STREAM3 =   3;  	 	   STREAM4 =   4;  	 	   STREAM5 =   5;  	 	   STREAM6 =   6;  	 	   STREAM7 =   7;  	 	   STREAM8 =   8;  	 	   STREAM9 =   9;  	 	   STREAM10 =  10; 	 	   STREAM11 =  11; 	 	   STREAM12 =  12; 	 	   RFAMSTREAM = 6; 	 
   CNSLMSTREAM = 2;  
     	   FIRSTSLAVE = 1; 	 	   LASTSLAVE = 12; 	 #{ Note that although Stream 13 is a valid stream it is not handled in  # #   this module.  Inpro is the monitor that handles stream 13 (router)  # !   messages.  It is not a slave monitor at all, but is the inbound ! "   protocol process for NS/1000.  For this reason the Inpro's class  "     number is allocated when Outpro's is.  At this time the name    #   'INPRO' is moved into res at the stream 13 location.              } #     
   RESSLAVELEN = 5;  
         SCHEDQ1 =   &'* Should NSINIT try to schedule all the DS/1000-IV monitors (VCPMN, TRFAS'; & SCHEDALLQ =   &'* RDBAM, RFAM, PROGL, PTOPM, OPERM, EXECW, EXECM, DLIST, CNSLM) [(Y)/N]?_'; & SCHEDALLBUTCNQ =  #'* RDBAM, RFAM, PROGL, PTOPM, OPERM, EXECW, EXECM, DLIST) [(Y)/N]?_';  #     GETMONNAME = '* Enter a monitor name.  Type /E to end:_';       TYPE  !   SlaveNameArrayType = Array[FIRSTSLAVE..LASTSLAVE] OF PNameType; !    SlaveFlagsType = Array[FIRSTSLAVE..LASTSLAVE] OF Boolean;      CONST      SLAVEMON_NAME = SlaveNameArrayType[     { 1 }        PNameType[ 'DLIST ' ],     { 2 }        PNameType[ 'CNSLM ' ],     { 3 }        PNameType[ 'EXECW ' ],     { 4 }        PNameType[ 'PTOPM ' ],     { 5 }        PNameType[ 'EXECM ' ],     { 6 }        PNameType[ 'RFAM  ' ],     { 7 }        PNameType[ 'OPERM ' ],     { 8 }        PNameType[ 'VCPMN ' ],     { 9 }        PNameType[ 'PROGL ' ],     { 10 }         PNameType[ 'RDBAM ' ],     { 11 there is no monitor for this stream in an A-Series }        PNameType[ '      ' ],     { 12 }         PNameType[ 'TRFAS ' ] ];     { 13 Inpro: is handled in moninit. }           SLAVEABORTABLE = SlaveFlagsType[  { 1: DLIST  }      FALSE,   { 2: CNSLM  }      TRUE,  { 3: EXECW  }      TRUE,  { 4: PTOPM  }      FALSE,   { 5: EXECM  }      FALSE,   { 6: RFAM   }      FALSE,   { 7: OPERM  }      TRUE,  { 8: VCPMN  }      FALSE,   { 9: PROGL  }      FALSE,   { 10: RDBAM  }     FALSE,   { 11: there is no monitor for this stream in an A-Series }     FALSE,   { 12: TRFAS  }     TRUE ];      VAR      message:       IStringType;     mainres:       Int16;  
   schedallmon:   Boolean; 
    slaveflags:    SlaveFlagsType;       $ SUBTITLE 'Procedure Declarations', PAGE $       PROCEDURE HandleSlaveMonitors   ( VAR classcount:    Int16;     VAR ierr:          Int16 );      FORWARD;      { Ask if user wants DS/1000-IV Compatible monitors }       PROCEDURE InitSM     (VAR result      : Int16);      FORWARD;      { Initialize remote session pool }       PROCEDURE InitTcbs                 $ ALIAS 'D$TCB' $  (     tcbcount:      Int16;     VAR result:        Int16 );   EXTERNAL;      { Initialize the TCBS in smb. }      PROCEDURE SchedSlaveMonitors  (VAR ierr:           Int16 );      FORWARD;      { Initialize DS/1000-IV compatible slave monitors }      
PROCEDURE SetAllSlaveFlags 
 
( VAR classcount:   Int16; 
   VAR result:       Int16 );     FORWARD;   !   { Set flags indicating all slave monitors are to be scheduled } !     PROCEDURE SetASlaveFlag   
( VAR monname:    String;  
   VAR classcount: Int16;  
  VAR ierr:       Int16 ); 
    FORWARD;   %   { Set a flag indicating one particular slave monitor is to be sched. }  %     PROCEDURE StopSlaveMonitors;     FORWARD;      { Shut down DS/1000-IV compatible slave monitors }       PROCEDURE SynSM      (VAR smbsize     : int16;      VAR dsamtbsize  : int16;      VAR socketcnt   : int16;      VAR classcnt    : int16;      VAR resourcnt   : int16;      VAR result      : int16);      FORWARD;      { Ask the remote session pool question }       PROCEDURE WaitASec                        $ ALIAS 'EXEC' $  $ NOABORT $      (     ecode:      Int16;            name:       Int16;            units:      Int16;            often:      Int16;            delay:      Int16 );      EXTERNAL;     { Wait one second before shooting the other processes }      $ SUBTITLE 'CleanupAMonitor', PAGE $  
PROCEDURE CleanupAMonitor  
 (     index:      Int16;  
  VAR ierr:       Int16 ); 
     VAR   
   offset:   Int16;  
        BEGIN    { CleanupAMonitor }          ierr := 0;      offset := index * RESSLAVELEN;          DS_StopMonitor( SLAVEMON_NAME[index], ierr );  "   DS_MoveCharsToRes( NSINIT_AdrOf( Lb_ST00 ), NAMEOFFSET + offset,  "                   PNAMEZEROED.PNAsCharType, PNAMELEN DIV 2 );   #   DS_RetClass( NSINIT_AdrOf( Lb_ST00 ), offset + CLASSOFFSET, ierr ); #        END;     { CleanupAMonitor }           $ SUBTITLE 'HandleSlaveMonitors', PAGE $  PROCEDURE HandleSlaveMonitors   ( VAR classcount:    Int16;     VAR ierr:          Int16 );       LABEL      99;      VAR      default:          Boolean;      internal_result:  Int16;      terminator:       Boolean;      usersname:        IStringType;      yesnoresponse:    OneCharType;       $ SUBTITLE 'AskWhichMonitors(HSM)', PAGE $  PROCEDURE AskWhichMonitors;       VAR      ask_result:    Int16;         BEGIN    { AskWhichMonitors }         PrintPrompt( FALSE, SCHEDQ1, ask_result );      IF ask_result = GOOD THEN        BEGIN    { ask question }         default := TRUE;            IF initglobals.IG_HP3000_enable THEN           BEGIN    { add CNSLM }                message := SCHEDALLQ;           END      { add CNSLM }           ELSE           BEGIN    { no CNSLM }               message := SCHEDALLBUTCNQ;            END;     { no CNSLM }             YesNoInput( message, default, yesnoresponse, ask_result );         { hand error back to caller }             END;     { ask question }          internal_result := ask_result;      END;     { AskWhichMonitors }      $ SUBTITLE 'ClearSlaveFlags(HSM)', PAGE $   
PROCEDURE ClearSlaveFlags; 
 VAR      index:         Int16;         BEGIN    { ClearSlaveFlags }          FOR index := FIRSTSLAVE TO LASTSLAVE DO        BEGIN    { FOR }            slaveflags[index] := FALSE;         END;     { FOR }     END;     { ClearSlaveFlags }       $ SUBTITLE 'HandleSlaveMonitors', PAGE $  BEGIN { HandleSlaveMonitors }       internal_result := GOOD;      "{ print messages, find out which monitors the user wants scheduled } " 	AskWhichMonitors;  	 IF internal_result <> GOOD THEN GOTO 99;      { AskWhichMonitors will get default and yesnoresponse }   IF ( default ) OR ( yesnoresponse = 'Y' ) THEN     BEGIN    { schedule all }         SetAllSlaveFlags( classcount, internal_result );      END      { schedule all }    ELSE     BEGIN    { ask for monitors }         { first clear all slave schedule flags }   
   ClearSlaveFlags;  
 
   classcount := 0;  
    schedallmon := FALSE;         REPEAT             default := FALSE;   
      terminator := TRUE;  
           CharInput( GETMONNAME, TRUE, default, terminator,                  usersname, internal_result);         IF internal_result <> GOOD THEN GOTO 99;            IF NOT terminator THEN           BEGIN    { save the monitor name to be scheduled }       !         SetASlaveFlag( usersname, classcount, internal_result );  !          END;     { save the monitor name to be scheduled }              UNTIL    (( terminator ) OR ( internal_result <> GOOD ));       END;     { ask for monitors }      99:   ierr := internal_result;      END;  { HandleSlaveMonitors }       
$SUBTITLE 'Init1ks', PAGE$ 
 {------------------------------------------------------------}  {               1Ks Initialization                           }  {------------------------------------------------------------}      	PROCEDURE Init1Ks  	    (VAR result      : Int16);       LABEL      99;      VAR   
   classnum: Int16;  
 
   ierr:     Int16;  
 
   rn:       Int16;  
 
   wkmap:    Int16;  
     $ SUBTITLE 'GetClass_Sched (Init1ks)', PAGE $   PROCEDURE GetClass_Sched  (    ResAccess:             Int16;       monname:               PNameType;       abortflg:              Boolean;       classbits:             Int16;   VAR classnum:              Int16;   VAR result:                Int16 );      VAR      message:       IStringType;         BEGIN    { GetClass_Sched }  	   result := GOOD; 	        DS_GetClass( ResAccess, 0, classbits, classnum, result );     IF result = GOOD THEN        BEGIN    { schedule the program }             DS_StartMonitor( monname, 0, TRUE, result );        IF result <> GOOD THEN           BEGIN    { scheduling error }  
         IF abortflg THEN  
             BEGIN    { print aborting message }                   PrintError( NO_REQ_MON_ABORTMSG, result );               IF result = GOOD THEN result := ERR_ALREADY_PRINTED;               END      { print aborting message }              ELSE               { Hand not dormant error back to caller,                print message for other errors.       }               IF result <> NOTDORMANT THEN                 BEGIN    { print warning message }       #               { don't abort for these errors, but print a warning. }  #                result := GOOD;                 PrintError( NO_REQ_MONMSG, result );                  { hand any errors back to the caller }                  END;     { print warning message }            END;     { scheduling error }        END;     { schedule the program }          END;     { GetClass_Sched }      $ SUBTITLE 'SaveNewTimeoutValues (Init1ks)', PAGE $   PROCEDURE SaveNewTimeoutValues  (VAR result:   Int16 );          BEGIN    { SaveNewTimeoutValues }  	   result := GOOD; 	     '   DS_StoreResElement( NSINIT_AdrOf( Lb_MSTO ), 0, timevalue[FIRSTTIMEOUTQ] ); ' (   DS_StoreResElement( NSINIT_AdrOf( Lb_SVTO ), 0, timevalue[FIRSTTIMEOUTQ+1] ); ( (   DS_StoreResElement( NSINIT_AdrOf( Lb_ISTO ), 0, timevalue[FIRSTTIMEOUTQ+2] ); (        END;     { SaveNewTimeoutValues }      $ SUBTITLE 'SetupTCBS (Init1ks)', PAGE $  
PROCEDURE SetupTCBS  
 (    tcbcount: Int16;    VAR result:   Int16 );       VAR      smbaddr:    Int16;       
   BEGIN    { SetupTCBs }  
 	   result := GOOD; 	     "   { NOTE that inittcbs counts on the fact that it will be the first " $      routine to access smb.  The tcbs MUST be the first table allocated $ &      in smb.  #NULL is set to #FWAM by InitTcbs.                         }  &        DS_GetSMBAddr( tcbcount * TCBENTRYSIZE, smbaddr, result );      IF result = GOOD THEN        BEGIN    { init tcbs }            InitTcbs( tcbcount, result );         { pass error back to caller }         END;     { init tcbs }      
   END;     { SetupTCBs }  
     $ SUBTITLE 'Init1ks', PAGE $      	BEGIN { Init1Ks }  	 result := GOOD;       	IF have91750 THEN  	    BEGIN    { initialize DS/1000-IV }          { get a table access rn }     DS_GetRN( NSINIT_AdrOf( Lb_TBRN ), 0, rn, result );     IF result <> GOOD THEN GOTO 99;     { check for queue }         SetupTCBS( tcbcount, result );      IF result <> GOOD THEN GOTO 99;      
   InitSM( result ); 
    IF result <> GOOD THEN GOTO 99;      
   IF updatetimeouts THEN  
       BEGIN    { save new timeouts }        SaveNewTimeoutValues( result );         IF result <> GOOD THEN GOTO 99;         END;     { save new timeouts }      
   IF have1000 THEN  
       BEGIN    { do 1k specifics }      	      { do grpm }  	       GetClass_Sched( NSINIT_AdrOf( Lb_GRPM ), 'GRPM  ', TRUE,            SAVECLASSBUFBIT + SAVECLASSNUMBIT, classnum, result );          IF result <> GOOD THEN GOTO 99;         DS_InitEnterCritical( wkmap, ierr );        IF ierr <> GOOD THEN GOTO 99;             { store class in dsam }         DS_StoreGlobal( DS_GRPM_Class, 1, classnum );         DS_InitLeaveCritical( wkmap );        END;     { do 1k specifics }         Init3k1( result );      IF result <> GOOD THEN GOTO 99;         SchedSlaveMonitors( result );     IF result <> GOOD THEN GOTO 99;         { initialize #NODE to indicate that 91750 is up }     DS_StoreResElement( NSINIT_AdrOf( Lb_NODE ), 0, 0 );       
   END;     { have 91750 } 
 99:   END; { Init1Ks }  $SUBTITLE ' InitSM procedure ', PAGE$       PROCEDURE InitSM     (VAR result      : Int16);           {}  { Description: Initialize the POOL table area   {   { Parameters:   {   result     (output)   set to zero if successfull.   {}      LABEL      99;      VAR          pooladd:    Int16;       PROCEDURE ExitInit;  { Exits InitSM }          BEGIN         GOTO 99;          END;    { ExitInit }           
   BEGIN  { InitSM } 
        IF smb_block >0 THEN         BEGIN    { set up the pool }            { get the pointer to the pool table }         DS_GetSMBAddr( smb_block, pooladd, result );        IF result <> GOOD THEN ExitInit;            { store the address of the block in res }   "      DS_StoreResElement( NSINIT_AdrOf( Lb_POOL ), NULL, pooladd );  "     %      { stuff negative number of pool entries in first word of the table } %       DS_MoveIntoSMB ( -numofpool, pooladd );             END      { set up the pool }       ELSE         BEGIN    { zero pool ptr }            DS_StoreResElement( NSINIT_AdrOf( Lb_POOL ), 0, 0 );        END;     { zero pool ptr }      99:   	   result := GOOD; 	        END; {InitSM}      $ SUBTITLE 'SchedSlaveMonitors', PAGE $   PROCEDURE SchedSlaveMonitors  (VAR ierr:           Int16 );   {}  ${  There is a slave monitor table in RES.  It has a five word entry for  $ {  each slave monitor.  Each entry looks like this:   {    {  | WORD 0    | WORD 1     |  WORD 2-5                        |    {  |-----------|------------|----------------------------------|    {  |  tcb link |  mon class |  monitor name                    |    {  |   word    |   number   |                                  |   {   #{  This routine moves the class number and the monitor name into RES.  # {   {}      LABEL      99;      VAR      classnum:   Int16;      index:      Int16;      resoffset:  Int16;      startofname:Int16;          BEGIN { SchedSlaveMonitors }      ierr := GOOD;         FOR index := FIRSTSLAVE TO LASTSLAVE DO        BEGIN    { FOR }            { increment res offset }        resoffset := index * RESSLAVELEN;             IF slaveflags[index] = TRUE THEN           BEGIN    { start this monitor }               { get a class number, save it in res }   $         DS_GetClass( NSINIT_AdrOf( Lb_ST00 ), resoffset + CLASSOFFSET,  $ #                  SAVECLASSNUMBIT + SAVECLASSBUFBIT, classnum, ierr ); #          IF ierr <> GOOD THEN GOTO 99;      &         DS_MoveCharsToRes( NSINIT_AdrOf( Lb_ST00 ), resoffset + NAMEOFFSET, &                SLAVEMON_NAME[index], PNAMELEN DIV 2 );               IF SLAVEABORTABLE[index] THEN              BEGIN    { set slave abortable bit in name }                  DS_GetResElement( NSINIT_AdrOf( Lb_ST00 ),                          resoffset + NAMEOFFSET, startofname );                  DS_StoreResElement( NSINIT_AdrOf( Lb_ST00 ),  #                        resoffset + NAMEOFFSET, startofname + BIT15 ); #                 END;     { set slave abortable bit in name }               DS_StartMonitor( SLAVEMON_NAME[index],   !                                          classnum, TRUE, ierr );  !          IF ierr = NOTDORMANT THEN GOTO 99;            IF (( ierr <> GOOD ) AND ( schedallmon )) THEN               BEGIN    { delete monitor }                   { take this monitor out of the list in Res }                  CleanupAMonitor( index, ierr );               { ignore errors }                   END;     { delete monitor }                ierr := GOOD;               IF index = RFAMSTREAM THEN               BEGIN    { store rfam's file count }                   DS_StoreResElement( NSINIT_AdrOf( Lb_RFSZ ), 0, 0 );               END;     { store rfam's file count }               END;     { start this monitor }        END;     { FOR }      99:      END;  { SchedSlaveMonitors }       $ SUBTITLE 'SetAllSlaveFlags', PAGE $   
PROCEDURE SetAllSlaveFlags 
 ( VAR classcount: Int16;  
  VAR result :    Int16 ); 
     VAR      index:      Int16;          BEGIN { SetAllSlaveFlags }   	   result := GOOD; 	        { Tell caller need classnumbers for all the slaves. }     { That's 11 for the monitors +2 for EXECM.          }  
   classcount := 13; 
        { also set boolean to indicate caller used '/D' }     schedallmon := TRUE;           { set flag so we'll attempt to schedule each slave monitors }      FOR index := FIRSTSLAVE TO LASTSLAVE DO        BEGIN    { FOR }            slaveflags[index] := TRUE;            END;     { FOR }      %   { always want to clear stream 11, there is no monitor on that stream. } %    slaveflags[STREAM11] := FALSE;          IF NOT initglobals.IG_HP3000_enable THEN         BEGIN    { clear CNSLM flag }             slaveflags[CNSLMSTREAM] := FALSE;       #      { decrement the number of class numbers, CNSLM won't need one }  #       classcount := classcount -1 ;         END;     { clear CNSLM flag }          END;  { SetAllSlaveFlags }       $ SUBTITLE 'SetASlaveFlag', PAGE $  PROCEDURE SetASlaveFlag   
( VAR monname:    String;  
   VAR classcount: Int16;  
  VAR ierr:       Int16 ); 
     LABEL      99;      VAR      internal_result:     Int16;     namelen:             Int16;     streamno:            Int16;         BEGIN    { SetASlaveFlag }          internal_result := 0;         { Truncate the monitor name string if necessary }     IF Strlen( monname ) > PNAMELEN THEN         SetStrlen( monname, PNAMELEN );       
   streamno := NONE; 
        IF monname = 'DLIST' THEN  
      BEGIN    { stream1 } 
 
      streamno := STREAM1; 
 
      END;     { stream1 } 
        IF monname= 'CNSLM' THEN   
      BEGIN    { stream2 } 
 
      streamno := STREAM2; 
 
      END;     { stream3 } 
        IF monname = 'EXECW' THEN  
      BEGIN    { stream3 } 
 
      streamno := STREAM3; 
 
      END;     { stream3 } 
        IF monname = 'PTOPM' THEN  
      BEGIN    { stream4 } 
 
      streamno := STREAM4; 
 
      END;     { stream4 } 
        IF monname = 'EXECM' THEN  
      BEGIN    { stream5 } 
 
      streamno := STREAM5; 
       { EXECM has 2 extra class numbers }         classcount := classcount + 2;   
      END;     { stream5 } 
        IF monname = 'RFAM' THEN   
      BEGIN    { stream6 } 
 
      streamno := STREAM6; 
 
      END;     { stream6 } 
        IF monname = 'OPERM' THEN  
      BEGIN    { stream7 } 
 
      streamno := STREAM7; 
 
      END;     { stream7 } 
        IF monname = 'VCPMN' THEN  
      BEGIN    { stream8 } 
 
      streamno := STREAM8; 
 
      END;     { stream8 } 
        IF monname = 'PROGL' THEN  
      BEGIN    { stream9 } 
 
      streamno := STREAM9; 
 
      END;     { stream9 } 
        IF monname = 'RDBAM' THEN        BEGIN    { stream10 }         streamno := STREAM10;         END;     { stream10 }       !   { There is no valid monitor name for stream 11 in an A-Series } !        IF monname = 'TRFAS' THEN        BEGIN    { stream12 }         streamno := STREAM12;         END;     { stream12 }       %   { stream 13: Inpro is always scheduled.  It is scheduled in Moninit. }  %     
   IF streamno = NONE THEN 
       BEGIN    { not found }             MsgFilePrint( BADMONNAME, PMT_ERROR, 0, internal_result );   
      SayOutputNeedsEdit;  
           IF NOT initglobals.IG_interactive THEN           BEGIN    { no error recovery; abort }      "         { Even though this is not a truly fatal error it indicates  "             an error from the input device. To be safe program  #            execution is terminated.                                }  #          internal_result := ERRUSERINPUT;            END;     { no error recovery; abort }            END      { not found }       ELSE         BEGIN    { have a monitor name }            { set the schedule bit in the slave flags array }         slaveflags[streamno] := TRUE;             { increment the total number of class numbers required }        classcount := classcount + 1;         END;     { have a monitor name }      99:      ierr := internal_result;      END;     { SetASlaveFlag }       
$SUBTITLE 'Shut1k', PAGE$  
 {-------------------------------------------}   {                Shut1Ks                    }   {-------------------------------------------}       	PROCEDURE Shut1Ks  	    (    trustvar    : TrustType;      VAR result      : Int16);       LABEL      99;      VAR      temp:       Int16;      wkmap:      Int16;           	BEGIN { Shut1Ks }  	 result := 0;  temp := 0;      DS_StoreResElement( NSINIT_AdrOf( Lb_NMSC ), 0, 0 );  DS_StoreResElement( NSINIT_AdrOf( Lb_NULL ), 0, 0 );      
DS_StopPtopSlave( temp );  
 { need to say if no sam was the error condition }       
DS_StopRDBA( temp ); 
 { again check for sam errors }      
DS_TimeoutMasters( temp ); 
 	{ ignore errors }  	     !{ need to wait a second here for the above requests to complete }  ! WaitASec( EXEC12, 0, SECS, ONCE, ONESEC );  
   BEGIN    { exec error } 
 
   { ignore errors } 
 
   END;     { exec error } 
     DS_StopMonitor( 'GRPM ', temp );  	{ ignore errors }  	     { return class, clear class number in res }   DS_RetClass( NSINIT_AdrOf( Lb_GRPM ), 0, temp );      DS_StopMonitor( 'LUMAP', temp );  	{ ignore errors }  	     DS_RetClass( NSINIT_AdrOf( Lb_LUMP ), 0, temp );  	{ ignore errors }  	     	StopSlaveMonitors; 	     { reset #pool to NULL }   DS_StoreResElement( NSINIT_AdrOf( Lb_POOL ), NULL, NULL );       { Note that DS/1000-IV 1000-3000 shutdown is called directly by    $ the shutdown routines in NSINIT.                                      } $     %{ change #NODE to indicate that 91750 services are no longer initialized } % DS_StoreResElement( NSINIT_AdrOf( Lb_NODE ), 0, -1 );       !{ Now return #TBRN to the system.  We are banking on the fact that ! $   most people accessing #TBRN first access #QRN, and should be blocked  $ "   there before ever getting here.  The one second wait should allow " #   any program that already passed its #QRN check to finish its #TBRN  # %   use.  Deallocating it here should be safe.  Note that this is a timing  % &   window....                                                             }  &     DS_RetRN( NSINIT_AdrOf( Lb_TBRN ), 0, temp );   	{ ignore errors }  	     99:   	END;  { Shut1Ks }  	     $ SUBTITLE 'StopSlaveMonitors', PAGE $  PROCEDURE StopSlaveMonitors;      VAR   
   ierr:     Int16;  
 
   index:    Int16;  
        BEGIN    { StopSlaveMonitors }          FOR index := FIRSTSLAVE TO LASTSLAVE DO        BEGIN    { FOR }            IF index <> STREAM11 THEN            BEGIN    { have monitor to clean up }           CleanupAMonitor( index, ierr );           END;     { have monitor to clean up }        END;     { FOR }         { also clear RFAM's number of files }     DS_StoreResElement( NSINIT_AdrOf( Lb_RFSZ ), 0, 0 );          { need to clean up EXECM's hold class and work class }      DS_RetClass( NSINIT_AdrOf( Lb_EXHC ), 0, ierr );      DS_RetClass( NSINIT_AdrOf( Lb_EXTC ), 0, ierr );          END;     { StopSlaveMonitors }       $SUBTITLE 'Syn1k',PAGE$   {-------------------------------------------}   {              Syn1Ks                        }  {-------------------------------------------}       PROCEDURE Syn1Ks     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);       LABEL      99;      CONST   	   LASTBANN =  3;  	     TYPE     BannerType = Array[1..LASTBANN] OF IStringType;      CONST      BANNR = BannerType[  	      IStringType[ 	          '*'],  	      IStringType[ 	          '*++   DS/1000-IV Compatible Services    ++*'],  	      IStringType[ 	          '*']];       $   SERVQ = '* Do you want any DS/1000-IV compatible services [Y/(N)]?_'; $ !   TCBQ1 = '* Enter the maximum number of concurrent DS/1000-IV '; !    TCBQ2 = 'transactions on this node [1..(20)..100]:_';     SERV1KQ =  % '* Do you want any DS/1000-IV 1000-1000 compatible services [(Y)/N] ?_';  %     
   DEFTCBCOUNT = 20; 
     VAR      tempclasscnt :    Int16;      internal_result:  Int16;      userresponse:     OneCharType;      default:          Boolean;      terminator:       Boolean;      smb3k:            Int16;      dsam3k:           Int16;      socket3k:         Int16;      class3k:          Int16;      rsn3k:            Int16;      index:            Int16;       $ SUBTITLE 'Internal Syn1k Procedures', PAGE $  	PROCEDURE ExitSyn; 	        BEGIN    { ExitSyn }      GOTO 99;      END;     { ExitSyn }       PROCEDURE CheckTimeoutValues  ( VAR internal_result:  Int16 );      CONST      TIMEQHI  = TimeQArray[1275,1275,45];      TIMEQLO  = TimeQArray[5,5,0];     TIMEQDEF = TimeQArray[45,30,5];      VAR      index:      Int16;          BEGIN    { CheckTimeoutValues }         FOR index := 1 TO LASTTIMEBANNER DO        BEGIN    { print timeout banner }             PrintPrompt( FALSE, TIMEMSG[index], internal_result );        IF internal_result <> GOOD THEN ExitSyn;        END;     { print timeout banner }       
   default := TRUE;  
 $   YesNoInput( TIMEMSG[TIMEQ], default, userresponse, internal_result ); $    IF userresponse = 'Y' THEN         BEGIN    { get non-default values }         updatetimeouts := TRUE;         FOR index := FIRSTTIMEOUTQ TO LASTTIMEOUTQ DO            BEGIN    { get user's timeout }  
         default := TRUE;  
          terminator := FALSE;       $         IntInput( TIMEMSG[index], default, terminator, TIMEQHI[index],  $              TIMEQLO[index], timevalue[index], internal_result );            IF internal_result <> GOOD THEN ExitSyn;                IF default THEN timevalue[index] := TIMEQDEF[index];            END;     { get user's timeout }        END      { get non-default values }        ELSE         BEGIN    { use defaults }   "      { If the user wants to use the defaults they have already been " #        set when smb was allocated.  Set up the timevalue array.     } #       updatetimeouts := FALSE;        FOR index := FIRSTTIMEOUTQ TO LASTTIMEOUTQ DO            timevalue[index] := TIMEQDEF[index];         END;     { use defaults }          { save master timeout in global for rtrinit. }      { Note that this is in seconds not in uplin tics }      initglobals.IG_MSTO := timevalue[FIRSTTIMEOUTQ];           { Convert the master and slave timeouts to be in UPLIN tics,         rounding up.  Uplin runs every 5 secs, so divide by 5.   !     Uplin also uses the count as a byte count, not a word count,  ! !     so add 400 octal (256 decimal) to the count.  Make the count  ! #     negative so uplin can increment the value easily as a counter. }  #        timevalue[FIRSTTIMEOUTQ] :=        - (( timevalue[FIRSTTIMEOUTQ] +2 ) DIV 5 ) +256;         timevalue[FIRSTTIMEOUTQ+1] :=        - (( timevalue[FIRSTTIMEOUTQ+1] +2 ) DIV 5 ) +256;         END;     { CheckTimeoutValues }  $ PAGE $  BEGIN {syn1Ks}  internal_result := GOOD;      FOR index := 1 TO LASTBANN DO      BEGIN    { print DS/1000-IV banner }          PrintPrompt( FALSE, BANNR[index], internal_result );      IF internal_result <> GOOD THEN ExitSyn;      END;     { print DS/1000-IV banner }       default := TRUE;  YesNoInput( SERVQ, default, userresponse, internal_result );  IF internal_result <> GOOD THEN ExitSyn;      IF default THEN userresponse := 'N';      
IF userresponse = 'N' THEN 
    BEGIN    { no 91750 services }      have91750 := FALSE;     ExitSyn;      END;     { no 91750 services }       	have91750 := TRUE; 	         { need a resource numbers for table access }  rsncnt := rsncnt + 1;       default := TRUE;  
terminator := FALSE; 
 IntInput( TCBQ1 + TCBQ2, default, terminator, 100, 1,   $                                           tcbcount, internal_result );  $ IF internal_result <> GOOD THEN ExitSyn;      IF default THEN tcbcount := DEFTCBCOUNT;      
{ update smb size }  
 smbsize := smbsize + tcbcount * TCBENTRYSIZE;       { Always need to set up the pool }  SynSM( smbsize, dsamtbsize, socketcnt, tempclasscnt, rsncnt,  "                                                  internal_result ); " IF internal_result <> GOOD THEN ExitSyn;      classcnt := classcnt + tempclasscnt;      CheckTimeoutValues( internal_result );  IF internal_result <> GOOD THEN ExitSyn;      default := TRUE;  	have1000 := FALSE; 	     YesNoInput( SERV1KQ, default, userresponse, internal_result );  IF internal_result <> GOOD THEN ExitSyn;      IF default THEN userresponse := 'Y';  	tempclasscnt := 0; 	     
IF userresponse = 'Y' THEN 
    BEGIN    { ask 1k-1k questions }       
   have1000 := TRUE; 
        { need a class number for GRPM }      classcnt := classcnt + 1;         IF internal_result <> GOOD THEN ExitSyn;          classcnt := classcnt + tempclasscnt;      tempclasscnt := 0;          { set flag for IFP initialization code }      initglobals.IG_1K50_enable := TRUE;         { set flag for Router/1000 code }     initglobals.IG_need_RTR := TRUE;          END;     { ask 1k-1k questions }       { ask if they have any DS/1000-IV 1000-1000 connections }   "Syn3k1( smb3k, dsam3k, socket3k, class3k, rsn3k, internal_result );  " IF internal_result <> GOOD THEN ExitSyn;      { update the counts for the caller. }   smbsize := smbsize + smb3k;   socketcnt := socketcnt + socket3k;  classcnt := classcnt + class3k;   
rsncnt := rsncnt + rsn3k;  
     { note that Syn3k sets initglobals.IG_HP3000_enable }   !IF ( NOT initglobals.IG_HP3000_enable ) AND ( NOT have1000 ) THEN  !    BEGIN    { input discrepancy }          { The user asked for 91750 but doesn't want 1k-1k OR 1k-3k.  !     Print a warning indicating that no services were requested. } !        MsgFilePrint( NO91750WARN, PMT_ERROR, 0, internal_result );     IF internal_result <> GOOD THEN ExitSyn;      END;     { input discrepancy }       { these guys only require class numbers }   HandleSlaveMonitors( tempclasscnt, internal_result );   IF internal_result <> GOOD THEN ExitSyn;  classcnt := tempclasscnt + classcnt;      99:      result := internal_result;   END;  {syn1Ks}          
$SUBTITLE ' SynSM ', PAGE$ 
 PROCEDURE SynSM      (VAR smbsize     : int16;      VAR dsamtbsize  : int16;      VAR socketcnt   : int16;      VAR classcnt    : int16;      VAR resourcnt   : int16;      VAR result      : int16);           {}  #{ Description: Get user input to "Max # of local session for remote" ; # ${   perform validity check on the input ; return DSAM table size to the  $     {   smbsize    (output)   size of pool  {   dsamtbsize (output)   set to zero   {   socketcnt  (output)   set to zero   {   classcnt   (output)   set to zero   {   resourcnt  (output)   set to zero   {   result     (output)   set to zero if successfull.   {   #{  This routine assumes the above return parameters were zeroed by the # {  caller.  {}      LABEL      99;      CONST          POOLENTRYSIZE = 7;      MAXNUMOFPOOL  = 253;      MINNUMOFPOOL  = 1;      DEFNUMOFPOOL  = 7;   	   REMSESSIONMSG1= 	 !    '* Enter the maximum number of concurrent DS/1000-IV remote '; ! 	   REMSESSIONMSG2= 	     'transactions to access this node [1..(7)..253]:_';           VAR          default:          Boolean;      terminator:       Boolean;      message:          PromptType;      PROCEDURE Exitsyn;  { Exits SynSM }          BEGIN         GOTO 99;          END;    { Exitsyn }              
   BEGIN   { SynSM } 
        default := TRUE;        { /D is valid }     terminator := FALSE;    { /E is not valid }     message := REMSESSIONMSG1 + REMSESSIONMSG2 ;       { prompt user and get an answer for number of pool entries }    $   IntInput( message, default, terminator, MAXNUMOFPOOL, MINNUMOFPOOL,   $             numofpool, result );         { check the result }      if result <> GOOD THEN Exitsyn;         { check for default }     if default THEN numofpool := DEFNUMOFPOOL;          { calculate the amount of DSAM requiered }      smb_block := numofpool * POOLENTRYSIZE + 1;     smbsize := smbsize + smb_block;         { don't need anything else }      result := 0;     { no error return}      99:      END; {SynSM}       END   .  