 $PASCAL '91790-1X217 REV.4010 <860724.1300>'$   $STANDARD_LEVEL 'HP1000'  $debug$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	         MODULE tl;  $ALIAS 'N$TL'$      {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}      {}  {       NAME: TCPLB.PAS                              }  {     SOURCE: 91790-18217                            }  {      RELOC: NONE                                   }  {       PGMR: MCL                                    }  {}      {}  {  Modification History:  {   %{  Mar. 15th 1986: Import INVALIDTIMERID form TMRDEC instead of using TCP  % ${     constant -3 which is no longer a valid error code return by TIMER  $ ${     calls. This error can cause TCP to set the KEEPALIVE timer twice.  $ {   %{  Apr 1st 1986 (PCO 2626): Change Abortrace, Badreference and Pathaborted % #{     to be logged as PROLOG rather than warning because they are used # {     for testing purpose only.   {   ${  Jul 24th 1986 (PCO 4010): Plug the hole in TCPRespond(); the problem  $ "{     is that TCP did not de-allocate the path if the connection has " #{     been aborted by the TCPInbound(). The change is to clean up the  # {     path when the connection was closed.  {}      IMPORT     $SEARCH 'phtm/BODEC.REL'      bodec,      $SEARCH 'phtm/SODEC.REL'      sodec,      $SEARCH 'phtm/MMDEC.REL'      mmdec,      $SEARCH 'phtm/MMEXT.REL'      ds_mm,      $SEARCH 'phtm/Trcmod.rel'     trcmod,     $SEARCH 'phtm/SIGMOD.REL'     sigmod,     $SEARCH 'phtm/TMRDEC.REL'     tmrdec,     $SEARCH 'phtm/TCPGB.REL'      tg,     $SEARCH 'phtm/TUSER.REL'      tuser;               $SUBTITLE ' Export procedures ', PAGE$      EXPORT      {--------------------------------------------------------}  {                                                        }  {          EXPORT   PROCEDURES                           }  {                                                        }  {--------------------------------------------------------}          {--------------------------------------------------------}  { The following function  provides TCP modules with      }  { modular arithmatic operation on the packet sequence    }  { number. As long as the TCP sequence is not greater     }  { than 2**32 -1, the functions are adequate.             }  {--------------------------------------------------------}          FUNCTION Seq_Gt      (seq1: TCPSeqType;       seq2: TCPSeqType ): BOOLEAN;          FUNCTION Seq_Lt      (seq1: TCPSeqType;       seq2: TCPSeqType ): BOOLEAN;          FUNCTION Seq_LEq     (seq1: TCPSeqType;       seq2: TCPSeqType ): BOOLEAN;          FUNCTION Seq_GEq     (seq1: TCPSeqType;       seq2: TCPSeqType ): BOOLEAN;          PROCEDURE SendSeqInit      (VAR sv    : StateVectorType);           
PROCEDURE RcvSeqInit 
    (VAR sv   : StateVectorType);          PROCEDURE RecordFmSize     (VAR head        : Int16;      VAR tail        : Int16;      VAR queue       : TCPMsgAryType;      VAR frm_cnt     : Int16;          data_len    : Int16;          push_flag   : BOOLEAN);       PROCEDURE UpdateFmCnt      (VAR head       : Int16;       VAR tail       : Int16;       VAR queue      : TCPMsgAryType;       VAR frm_cnt    : Int16;           data_len   : Int16;       VAR queueddata : Int16);          
PROCEDURE InsertList 
    (Table           : TableDescriptorIDTYPE;      list_ptr        : Int16;      element_ptr     : Int16);           
PROCEDURE DeleteList 
    (Table          : TableDescriptorIDType;       list_ptr       : Int16;       element_ptr    : Int16 );           PROCEDURE TcpCancelTimer  
   (    timer_type: Int16; 
     VAR rtn_err   : Int16);       PROCEDURE TCPLogError   
   (error_code   : Int16;  
 
    error_loc    : Int16); 
         PROCEDURE TcpSetTimer      ( type_of_timer : Int16;        timer_value   : Int32 );           PROCEDURE TcpResetTimer      (    timer_value   : Int32;      VAR tmr_id        : TimerIdType;      VAR tmr_err       : Int16 );          PROCEDURE TcpCancelAllTimer      ( VAR sv:  StateVectorType);           FUNCTION GetTimerValue     (input_val :  Int32;       min_val   :  Int32;       max_val   :  Int32 ) : INT32;           PROCEDURE UpdateRTTime     ( VAR sv  : StateVectorType);          PROCEDURE GetChecksum      (VAR headers   : IPTCPHdrType;   
        opt_len   : Int16; 
 
        data_ptr  : Int16; 
 
        offset    : Int16; 
 
        data_len  : Int16; 
     VAR cksumword : Int16     );          FUNCTION GetTCPSeq: TCPSeqType;           
PROCEDURE GetTCPHdr  
    (VAR mbufid  : Int16;  
    VAR result  : Int16);  
         PROCEDURE GetTCPGlobals;          
PROCEDURE TCPRespond 
    ( dnpth_ptr : Int16      ;        path_ptr  : Int16      ;        mbuf_ptr  : Int16      ;        ack       : TCPSeqType ;        seq       : TCPSeqType ;        flags     : OneOrBitType );          
PROCEDURE AllocatePortAddr 
    (VAR  portnumber: Int16);          
PROCEDURE AllocateSV 
    (VAR sv_ptr: Int16);           PROCEDURE TCPDynamicAddr  
   (    pathref   : Int16; 
     VAR dynaddr   : AddressType;      VAR addrlen   : Int16       );          PROCEDURE TCPAddElement      ( VAR sp        : Int16;        VAR stack     : TemplateControlStack;       VAR crec      : TemplateControlRecord;        VAR vnarec    : VNARecord;        VAR pathstart : Int16;        VAR rptr      : Int16;        VAR report    : PathReportRecord;       VAR dynamicptr: Int16;        VAR ierr      : Int16 );           PROCEDURE TcpBuildPath     ( VAR pathreport  : PathReportRecord;           vnaptr      : Int16;            elementptr  : Int16;            uppid       : Int16;        VAR downpid     : Int16;        VAR downref     : Int16;        VAR options     : PathOptionsRecord;        VAR bpwkmap     : Int16;        VAR ierr        : Int16 );           
PROCEDURE TCPClose;  
         PROCEDURE TCPConnDrop      (VAR tcp_port: TCPPathRecType;           pointer : Int16;          error   : Int16           );          PROCEDURE TCPClosePath     (VAR tcp_port : TCPPathRecType;      VAR port_ptr : Int16           );           PROCEDURE FreeSVector;          PROCEDURE SetContextok     (    event_type    : Int16;          ulp_refr      : Int16;          my_refr       : Int16;      VAR error         : Int16 );          PROCEDURE GetResource   
   (    option     :Int16; 
 
    VAR sv_ptr     :Int16; 
 
    VAR port_ptr   :Int16; 
     VAR error      :Int16 );          
PROCEDURE PortLookUp 
    (    s_key      : ConnIdType;      VAR error      : Int16     );           PROCEDURE SSendAbortInd(VAR error : Int16);           
PROCEDURE SSDisconnectCfm; 
         PROCEDURE SSendConfirm;           PROCEDURE SSendConnInd;           
PROCEDURE TCPSearch  
    (    list_ptr   : Int16;       VAR search_key : ConnIdType;      VAR pointer    : Int16;       VAR pathrec    : TCPPathRecType);           
PROCEDURE TCPOutStub 
    (VAR e_msg    : EventMessageType;      VAR result   : Int16           );           
PROCEDURE TCPInStub  
    (VAR e_msg    : EventMessageType;      VAR result   : Int16           );           $SUBTITLE ' Forward procedures ', PAGE$       IMPLEMENT       {--------------------------------------------------------}  {                                                        }  {           FORWARD AND EXTERNAL PROCEDURES              }  {                                                        }  {--------------------------------------------------------}      
PROCEDURE PrintLine  
 	   $ALIAS 'REIO'$  	    (    icode, cnwd : int16;      VAR line : LineType; length: Int16);     EXTERNAL;      
PROCEDURE PrintOcto  
 	   $ALIAS 'PROCT'$ 	    (VAR buffer: IntOrTCPHdrType; length: Int16);     EXTERNAL;      
PROCEDURE Printword2 
 	   $ALIAS 'PROCT'$ 	    (VAR word: Int32; length: Int16);     EXTERNAL;      
PROCEDURE Printword1 
 	   $ALIAS 'PROCT'$ 	    (VAR word: Int16; length: Int16);     EXTERNAL;      	PROCEDURE PrintPcb 	 	   $ALIAS 'PROCT'$ 	    (VAR pcb : StateVectorTYpe; length: Int16);     EXTERNAL;      PROCEDURE ProSw      (VAR e_msg  : EventMessageType;      VAR error  : Int16);     EXTERNAL;      PROCEDURE AdrOf      (VAR bufr    : Int16;      VAR offset  : Int16;  
    VAR addr    : Int16);  
    EXTERNAL;      PROCEDURE GetSystemTime   	   $ALIAS 'D$TIM'$ 	 
   (VAR sys_time : Int32); 
    EXTERNAL;              $SUBTITLE 'TCP seq. functions', PAGE $  !{----------------------------------------------------------------} ! !{                                                                } ! !{                        Seq_Gt                                  } ! !{                                                                } ! !{----------------------------------------------------------------} !     FUNCTION Seq_Gt      (seq1: TCPSeqType;       seq2: TCPSeqType ): BOOLEAN;  {}  { Description:  {    Compare seq1 and seq2; if seq1 > seq2 return true.   {   { Parameters:   {    seq1       INPUT   tcp sequence number   {    seq2       INPUT   tcp sequence number   {    Seq_GT     OUTPUT  true or false   {   {}      BEGIN {seq_gt}  Seq_Gt := (seq1 - seq2) > 0 ;   END;{seq_gt}              !{----------------------------------------------------------------} ! !{                                                                } ! !{                        Seq_Lt                                  } ! !{                                                                } ! !{----------------------------------------------------------------} !     FUNCTION Seq_Lt      (seq1: TCPSeqType;       seq2: TCPSeqType ): BOOLEAN;  {}  { Description:  {    Compare seq1 and seq2; if seq1 < seq2 return true.   {   { Parameters:   {    seq1       INPUT   {    seq2       INPUT   {    Seq_Lt     OUTPUT  true or false   {   {}          BEGIN {seq_lt}  Seq_Lt := (seq1 - seq2) < 0 ;   END;{seq_lt}              !{----------------------------------------------------------------} ! !{                                                                } ! !{                        Seq_LEq                                 } ! !{                                                                } ! !{----------------------------------------------------------------} !     FUNCTION Seq_LEq     (seq1: TCPSeqType;       seq2: TCPSeqType ): BOOLEAN;  {}  { Description:  {    Compare seq1 and seq2; if seq1 <= seq2 return true.  {   { Parameters:   {    seq1       INPUT   {    seq2       INPUT   {    Seq_LEq    OUTPUT  true or false   {   {}          BEGIN {seq_leq}   Seq_LEq := (seq1 - seq2) <= 0 ;   END;{seq_leq}               !{----------------------------------------------------------------} ! !{                                                                } ! !{                        Seq_GEt                                 } ! !{                                                                } ! !{----------------------------------------------------------------} !     FUNCTION Seq_GEq     (seq1: TCPSeqType;       seq2: TCPSeqType ): BOOLEAN;  {}  { Description:  {    Compare seq1 and seq2; if seq1 >= seq2 return true.  {   { Parameters:   {    seq1       INPUT   {    seq2       INPUT   {    Seq_GEt    OUTPUT  true or false   {   {}      BEGIN {seq_geq}   Seq_GEq := (seq1 - seq2) >= 0 ;   END;{seq_geq}           $SUBTITLE 'Initialize send & receive', PAGE$  !{----------------------------------------------------------------} ! !{                                                                } ! !{                       SendSeqInit                              } ! !{                                                                } ! !{----------------------------------------------------------------} !     PROCEDURE SendSeqInit      (VAR sv    : StateVectorType);   {}  { Description:  {    Initialize the send variables for a new connection.  {    The routine is called when a new connection request  {    arrives or a new connection is offer from remote.  {    The system time is used as the initial sequence number.  {   {   { Parameters:   {    sv         INPUT/OUTPUT  Connection control block  {   {}      
BEGIN {sendseqinit}  
 WITH sv DO     BEGIN {init}      sv_snd_una:= sv_iss;      sv_snd_nxt:= sv_snd_una;      sv_snd_max:= sv_snd_nxt;      END; {init}  	END; {sendseqinit} 	             !{----------------------------------------------------------------} ! !{                                                                } ! !{                       RcvSeqInit                               } ! !{                                                                } ! !{----------------------------------------------------------------} !     
PROCEDURE RcvSeqInit 
    (VAR sv   : StateVectorType);  {}  { Description:  {    This procedure initialize the receive variables for new  {    connection. It is called by: TCPInput  {   { Parameters:   {    sv       INPUT/OUTPUT  Connection control block.   {   {}      	BEGIN {rcvseqinit} 	 WITH sv DO     BEGIN {init}      sv_rcv_nxt:= sv_irs + 1;      sv_rcv_frm_adv := sv_max_rcvs + 1;      sv_rcv_frm_nxt := 1;      END; {init}  	END; {rcvseqinit}  	         $SUBTITLE 'Path list routines' ,PAGE$       !{----------------------------------------------------------------} ! !{                                                                } ! !{                       InsertList                               } ! !{                                                                } ! !{----------------------------------------------------------------} !     
PROCEDURE InsertList 
    (Table           : TableDescriptorIDType;      list_ptr        : Int16;      element_ptr     : Int16);   {}  { Description:  !{  This procedure insert the list element addressed by element_ptr ! {  into the tail of the list pointed at by list_ptr.  {   { Parameters:   {  list_ptr      INPUT   Pointer to head of a list  {  element_ptr   INPUT   Pointer to an element  {   {}      VAR      temp_ptr  : Int16;       	BEGIN {insertlist} 	 DS_FetchFields(Table, list_ptr, temp_ptr, 0, 1);  DS_StoreFields(Table, list_ptr, element_ptr, 0, 1);   DS_StoreFields(Table, temp_ptr, element_ptr, 1, 1);   DS_StoreFields(Table, element_ptr, list_ptr, 1, 1);   DS_StoreFields(Table, element_ptr, temp_ptr, 0, 1);   	END;  {insertlist} 	             !{----------------------------------------------------------------} ! !{                                                                } ! !{                       DeleteList                               } ! !{                                                                } ! !{----------------------------------------------------------------} !     
PROCEDURE DeleteList 
    (Table          : TableDescriptorIDType;       list_ptr       : Int16;       element_ptr    : Int16 );   {}  { Description:   {    This procedure delete an the element 'element_ptr' from the   {    list pointed to by 'list_ptr'.   {   { Parameters:   {    list_ptr       INPUT    list pointer {not used}  {    element_ptr    INPUT    element pointer  {   {}      VAR      temp_ptr : ReassPtrType;       	BEGIN {Deletelist} 	 WITH temp_ptr DO     BEGIN     DS_FetchFields(Table, element_ptr, temp_ptr.int, 0, 2);     DS_StoreFields(Table, previous, next, 1, 1);      DS_StoreFields(Table, next, previous, 0, 1);      END;   	END;  {Deletelist} 	         $SubTitle 'Log Link level error', page$   {-------------------------------------------------}   {              TCPLogError                        }   {-------------------------------------------------}       PROCEDURE TCPLogError   
   {error_code   : Int16;  
 
    error_loc    : Int16}; 
     {}  { Description: Call message logger to log the error   {    message. The severity is set to "error" (4) except   {    for the following message type: BADREFERENCE, NOTALIVE   {    PATHABORTED and ABORTRACE. These are not error but   {    warning messages.  {}          CONST      OUR_PID        = TCP; {TCP's PID }      MSG_LEN        = SIZEOFTCPPATH + 2;      VAR      err_type   : Int16;     dummy_err  : Int16;     pathrefr   : ContextWords;      tcpevinfo  : TCPEvInfoType;      BEGIN {panic}   IF port_ptr <> 0 THEN      BEGIN  #   {DS_FetchElement(DS_tcp_pathtd, port_ptr, tcpevinfo.pathrec.int);}  #    tcpevinfo.pathrec := tcp_port;      END;       tcpevinfo.err_code := error_code;   pathrefr.longint   := port_ptr;       IF (error_code = BADREFERENCE) OR (error_code = NOTALIVE)   "      OR (error_code = PATHABORTED) OR (error_code = ABORTRACE) THEN "    BEGIN  
   err_type := EL_PROLOG;  
    END  ELSE     BEGIN     err_type := EL_ERROR;     END;       Log_Event(err_type, OUR_PID, error_loc, pathrefr,                MSG_LEN, tcpevinfo.int, dummy_err);  END;  {panic}               $SUBTITLE ' TCP Panic Routine', PAGE$   {------------------------------------------------------------}  {                         Panic                              }  {------------------------------------------------------------}      PROCEDURE Panic   
   (panic_num    : Int16); 
     {}  { Desciption:   {  Called to print a error message on the console.  {   { Parameters:   {  panic_num   Input  error indication number.  {   {}      BEGIN {panic}   {Send message to error logger}  END;  {panic}               $SUBTITLE 'Record frame enrty', PAGE$   {-------------------------------------------------}   {              RecordFmSize                       }   {-------------------------------------------------}       PROCEDURE RecordFmSize     {VAR head        : Int16;      VAR tail        : Int16;      VAR queue       : TCPMsgAryType;      VAR frm_cnt     : Int16;          data_len    : Int16;          push_flag   : BOOLEAN};               {}  { Description:  {  The routine assumes there is no more than 7 outstanding  "{  sends or receives allowed in our message mode implementation. It  " {  records the entry (the message size) in a circular buffer  {  which is part of the protocol connection control block.  {  IF the data is part of a message then it will be   {  added to the queue element in negative # of bytes other-   {  wise a positive number of bytes will be entered.   {   { Parameters:   {  head       INPUT/OUTPUT   circular queue HEAD pointer  {  tail       INPUT/OUTPUT   circular queue TAIL pointer  {  queue      INPUT/OUTPUT   message queue to be operated on.   {  frm_cnt    INPUT/OUTPUT   message count  {  data_len   INPUT          number of user data bytes sent.  {  push_flag  INPUT          end of message marker.   {   
{ Global structures: 
 {  sv    : connection control block   {   {}          
BEGIN {recordfmsize} 
 {Do not bump the pointer if the previous entry is a partial}  {message. Make the partial count be positive.              }  IF queue[tail] >= 0 THEN     BEGIN {no partial message}      tail := (tail + 1) MOD 8;     END  ELSE     BEGIN     queue[tail] := -queue[tail];      END;       {Add the count to the entry}  queue[tail] := queue[tail] + data_len;      {If the current entry is a partial make it negative}  IF NOT push_flag THEN      BEGIN     {Not a entire message, will not decrement}      {the message count and make count -ve.   }      queue[tail] := -queue[tail];      END  ELSE     BEGIN     IF ((tail + 1) MOD 8) = head THEN        BEGIN         {if tail = head, signifies overflow}        {we should panic...                }        TCPLogError(SEVEREDSERROR, TL_RECORDFMSIZE);        END;  
   frm_cnt := frm_cnt - 1; 
    END;   
END;  {recordfmsize} 
             $SUBTITLE 'Update frame count', PAGE$   {-------------------------------------------------}   {              UpdateFmCnt                        }   {-------------------------------------------------}       PROCEDURE UpdateFmCnt      {VAR head       : Int16;       VAR tail       : Int16;       VAR queue      : TCPMsgAryType;       VAR frm_cnt    : Int16;           data_len   : Int16;       VAR queueddata : Int16};      {}  { Description:  {  The routine assumes there is no more than 7 outstanding  {  sends allowed in our message mode implementation. It   {  updates the available frame count in the pcb; if the   {  the peer's window opens up by one or more frame sizes,   {  the completely covered frame will be free and the partial  	{  frame adjusted. 	 {   { Parameters:   {  head       INPUT/OUTPUT  queue HEAD pointer  {  tail       INPUT/OUTPUT  queue TAIL pointer  "{  queue      INPUT/OUTPUT  message queue (length of 7 message max.) " {  frm_cnt    INPUT/OUTPUT  message count (to be incremented)   {  data_len   INPUT   the difference (positive) between the   {                     old and new window offered by peer.    {  queueddata OUTPUT  total # bytes queued in the message queue    #{                     from the first entry to the sv_min_frames entry  # 
{ Global structures: 
 {  sv    : connection control block   {   {}      LABEL      99;      VAR          i    : Int16;     j    : Int16;  	   quit : Boolean; 	     
BEGIN {updatefmcnt}  
 quit := false;      WHILE (NOT quit) AND (data_len > 0) DO  BEGIN {while not finish}     IF head = (tail + 1) MOD 8 THEN        BEGIN         {the queue is empty,bail out. When sending the CALL}        {packet, the SYN flag occupy a sequence space and we}         {can be enter even the queue is empty...            }         queueddata := 0;        goto 99;        END;         IF queue[head] <= 0 THEN         BEGIN {partial or outdated}         IF queue[head] < 0 THEN            BEGIN  "         {We have a partial message; it has to be the last message}  " "         {and the count is maintained as negative Do not increment}  " "         {the available counter because we do not decrement it when} " "         {we have not see the eom flags yet. Log it as an error if } " "         {peer's update window is expanded....                     } "          queue[head] := queue[head] + data_len;            IF queue[head] > 0 THEN  	            BEGIN  	             {Guard against message count overflow}              queue[head] := 0;               TCPLogError(PEEREXPWND, TL_UPDATEFMCNT);              END;           END        ELSE           BEGIN            {The queue is empty and have a expanded window update}              {we just return in this case.                        }             END;   
      quit := true;  
       END  {partial or outdated}     ELSE   
      BEGIN {whole } 
       data_len := data_len - queue[head];         IF data_len >= 0 THEN   
         BEGIN {fi}  
          frm_cnt     := frm_cnt + 1;  
         queue[head] := 0; 
          head        := (head + 1) MOD 8;            IF head = (tail + 1) MOD 8 THEN  	            BEGIN  	             IF queue[head] <> 0 THEN  
               BEGIN 
                {Message queue overflow; log the error}                 TCPLogError(SEVEREDSERROR, TL_UPDATEFMCNT);  
               END;  
 
            quit := true;  
             END;  
         END   {fi}  
       ELSE           BEGIN  !         {A partial message is acked; update the remaining count}  !          queue[head] := -data_len;           quit := true;           END;   
      END; {whole }  
    END;  {while not finish}       !{Here find out the number of bytes queued upto the sv_min_frames}  ! !{Partial frame (message) do not count.                          }  ! IF queue[head] <= 0 THEN  
   queueddata  := 0  
 ELSE     BEGIN  
   queueddata  := 0; 
 
   i           := 0; 
    j           := head;          REPEAT   
      BEGIN {repeat} 
       queueddata  := queueddata + queue[j];         j           := (j + 1) MOD 8;         i           := i + 1;         IF queue[j] <= 0 THEN            i        := sv.sv_min_frames;  
      END;  {repeat} 
    UNTIL (i = sv.sv_min_frames) OR (j = tail + 1);     END;       99:;      
END;  {updatefmcnt}  
         $SUBTITLE ' TCP Timer routines', PAGE$  {------------------------------------------------------------}  {                                                            }  {                 TcpCancelTimer                             }  {                                                            }  {------------------------------------------------------------}      PROCEDURE TcpCancelTimer  
   {    timer_type: Int16; 
     VAR rtn_err   : Int16};       {}  { Description:  {    This routine calls the timer routine to cancel a active  {    timer specified by timer_type. It calls the timer to   {    cancel the timeout and clear the timer id word in the  {    tcp connection control block sv. If timer is not active  {    ie, no timer id then it just return.   {    It is called by: TCPInput, TCPOput   {   { Parameters:   {    timer_type      INPUT    Type of timer:  {   
{ Global variables:  
 {    tcp_error : Global error parameter.  !{    sv        : tcp control block which contains the timer id of  ! {                the particular timer type.   {}      VAR   
   timer_id : TimerIdType; 
     
BEGIN {canceltimer}  
 WITH sv DO  	   BEGIN {with sv} 	 	   rtn_err   := 0; 	        CASE timer_type OF   
      REXMTTYPE   :  
          BEGIN           timer_id := sv_t_rexmt;           sv_t_rexmt.index  := -1;            sv_t_rexmt.key    := -1;            END;   
      PERSISTTYPE :  
          BEGIN           timer_id  := sv_t_persist;            sv_t_persist.index := -1;           sv_t_persist.key   := -1;           END;   
      KEEPTYPE    :  
          BEGIN           timer_id := sv_t_keep;            sv_t_keep.index    := -1;           sv_t_keep.key      := -1;           END;   
      MSLTYPE     :  
          BEGIN            DS_FetchElement(DS_TCP_TCBTD, tcpgbls.i_thead, sv.int);            timer_id := sv.msltimer;            sv.msltimer.index   := -1;            sv.msltimer.key     := -1;            END;   
      IDLETYPE    :  
          BEGIN           timer_id := sv_t_idle;            sv_t_idle.index   := -1;            sv_t_idle.key     := -1;            END;   
      DELACKTYPE  :  
          BEGIN           timer_id := sv_t_delack;            sv_t_delack.index := -1;            sv_t_delack.key   := -1;            END;         OTHERWISE            BEGIN {unknown}           timer_id.index := -1;           timer_id.key   := -1;           END;  {unknown}        END; {case timer_type}  	   END;  {with sv} 	     {If timer_id is valid then call timer to cancel it}   IF timer_id.index >= 0 THEN      BEGIN     {call the real timer routine here}      CancelTimer(timer_id, rtn_err);         {Here we ignore the error return because it may due to}     {the cancelation of an expired timer.                 }     END;   
END;  {canceltimer}  
             !{----------------------------------------------------------------} ! !{                                                                } ! !{                     TcpSetTimer                                } ! !{                                                                } ! !{----------------------------------------------------------------} !     PROCEDURE TcpSetTimer      ( type_of_timer : Int16;        timer_value   : Int32 );   {}  { Description:   {    This routine calls timer routine to set a specific timeout    {    with respect to the type of timer indicated. The return  {    timer ID is saved in a specific field in the tcp control   {    block sv.  {   { Parameters:   {    type_of_timer   INPUT    Type of Timer:  {    timer_value     INPUT    Value in centisecond  {   
{ Global Variables:  
 {    sv  : tcp connection control blaock.   {   {}      LABEL 99;       VAR      timermsg : TimerMsgType;       BEGIN {settimer}      {If no timer option then return}  IF tcpgbls.tcp_debug < 0 THEN      GOTO 99;       WITH sv DO  	   BEGIN {with sv} 	        {Build the timer message first}      
   WITH timermsg DO  
       BEGIN         socket     := tcp_port.p_up_refr;         direction  := OUTBOUND_SIG;         END;         {Get the correct timeout value }          CASE type_of_timer OF            REXMTTYPE:           BEGIN {set retransmit timer}            {set timer and get timer id}            timermsg.signal := TIMERABLE_3;           ActivateTimer(timer_value, timermsg,               sv_t_rexmt, tcp_error);            END;  {set retransmit timer}       	      PERSISTTYPE: 	          BEGIN {set persist timer}           {call timer with value = TCPTV_PERSMIN}           timermsg.signal := TIMERABLE_3;           ActivateTimer(timer_value, timermsg,               sv_t_persist, tcp_error);            END;  {set persist timer}            KEEPTYPE:            BEGIN {set keep alive timer}            {call timer with vale = TCPTV_KEEP}           timermsg.signal := TIMERABLE_2;           ActivateTimer(timer_value, timermsg,               sv_t_keep, tcp_error);           END;  {set keep alive timer}             MSLTYPE:           BEGIN {set time wait timer}           {call timer with value = 2 * TCPTV_MSL}           timermsg.socket := tcpgbls.tcpsocket;           timermsg.signal := TIMERABLE_1;           ActivateTimer(timer_value, timermsg,               sv.msltimer, tcp_error);           END;  {set time wait timer}            IDLETYPE:            BEGIN {set idle timer}            {call timer with value = TCPTV_MAXIDLE}           {ActivateTimer(timer_value, timermsg,              sv_t_idle, tcp_error);}            END;       	      DELACKTYPE:  	          BEGIN {delack}            timermsg.signal := TIMERABLE_1;           ActivateTimer(timer_value, timermsg,               sv_t_delack, tcp_error);           END;  {delack}             OTHERWISE            BEGIN           {unknown timer type}            tcp_error := SEVEREDSERROR;           END;   	      END; {case}  	        {Log error if any}   
   IF tcp_error <> 0 THEN  
       BEGIN         TCPLogError(tcp_error, TL_SETTIMER);        tcp_error := 0;         END;  	   END;  {with sv} 	     99:;  END; {settimer}           {------------------------------------------------------------}  {                TCP Reset Timer                             }  {------------------------------------------------------------}      PROCEDURE TcpResetTimer      {    timer_value   : Int32;      VAR tmr_id        : TimerIdType;      VAR tmr_err       : Int16 };      LABEL      99;      BEGIN   tmr_err := 0;   {If no timer option then return}  IF tcpgbls.tcp_debug < 0 THEN      GOTO 99;       IF tmr_id.index < 0 THEN     BEGIN     tmr_err := INVALIDTIMERID;      END  ELSE     BEGIN     ResetTimer(timer_value, tmr_id, tmr_err);     END;   99:;  END;          !{----------------------------------------------------------------} ! !{                                                                } ! !{                    TcpCancelAllTimer                           } ! !{                                                                } ! !{----------------------------------------------------------------} !     PROCEDURE TcpCancelAllTimer      {VAR sv:  StateVectorType};      {}  { Description:  {    This procedure is called to cancel all active TCP timers   {    on a connection.   {   { parameters:   {    sv  : tcp connection control block.  {}      BEGIN {cancelalltimer}  WITH sv DO  	   BEGIN {cancel}  	        IF sv_t_rexmt.index >= 0 THEN        BEGIN {*}         {call timer routine to cancel}        CancelTimer(sv_t_rexmt, tcp_error);         sv_t_rexmt.index := -1;         sv_t_rexmt.key   := -1;         END;  {*}          IF sv_t_persist.index >= 0 THEN        BEGIN {*}         {call timer to cancel}        CancelTimer(sv_t_persist, tcp_error);         sv_t_persist.index := -1;         sv_t_persist.key   := -1;         END; {*}         IF sv_t_keep.index >= 0 THEN         BEGIN {*}         {call timer routine to cancel}        CancelTimer(sv_t_keep, tcp_error);        sv_t_keep.index := -1;        sv_t_keep.key   := -1;        END;  {*}          IF sv_t_2msl.index >= 0 THEN         BEGIN {*}   
      {call timer routine} 
       CancelTimer(sv_t_2msl, tcp_error);        sv_t_2msl.index := -1;        sv_t_2msl.key   := -1;        END;  {*}          IF sv_t_idle.index >= 0 THEN         BEGIN {*}   
      {call timer routine} 
       CancelTimer(sv_t_idle, tcp_error);        sv_t_idle.index := -1;        sv_t_idle.key   := -1;        END; {*}         {Here we choose to ignore error return because it is most}      {likely due to the cancelling of an expired timer entry. }   	   END;  {cancel}  	 END;  {cancelalltimer}              $SUBTITLE 'Function GetTimerValue', PAGE$   !{----------------------------------------------------------------} ! !{                                                                } ! !{                       GetTimerValue                            } ! !{                                                                } ! !{----------------------------------------------------------------} !     FUNCTION GetTimerValue     (input_val :  Int32;       min_val   :  Int32;       max_val   :  Int32 ) : INT32;   {}  { Description:  {   The tcp retransmit timeout value is bounded by  {   some predetermined values, min_val and max_val. This  {   routine set the range of the retransmit timeout.  {   { Parameters:   { Input  : input_val - input timeout value  {          min_val   - lower bound  {          max_val   - upper bound  {   { Output : None      - if input_val is within range   {          min_val   - if input_val is too small  {          max_val   - if input_val is too big  {}      BEGIN {gettimervalue}   IF input_val < min_val THEN   
   BEGIN {too small} 
    GetTimerValue := min_val;  
   END   {too small} 
 ELSE IF input_val > max_val THEN           BEGIN {too big}           GetTimerValue := max_val;           END   {too big}       ELSE GetTimerValue := input_val;   END;  {gettimervalue}                   $SUBTITLE 'Procedure UpdateRTTime', PAGE$   !{----------------------------------------------------------------} ! !{                                                                } ! !{                       UpdateRTTimer                            } ! !{                                                                } ! !{----------------------------------------------------------------} !     PROCEDURE UpdateRTTime     ( VAR sv  : StateVectorType);      {}  { Description:  {    This routine update the retransmit time based on the   {    algorithm in the ARPA TCP specification.   {   { Parameters:   
{    sv  :    INPUT   use  
 {   {}  VAR   
   sys_time : Int32; 
     
BEGIN {updaterttime} 
 WITH sv DO     BEGIN {with}          {Call asmb routine to get the value of $time.}          GetSystemTime(sys_time);          {get the absolute difference of the old and new $time}      {update t_rtt...                                     }          sv_t_rtt:= sys_time - sv_rt_time;         {Check if mid night wrap-around case}     IF sv_t_rtt < 0 THEN         BEGIN         sv_t_rtt := 864000 - sv_t_rtt;        END;      
   IF sv_srt_time = 0 THEN 
       BEGIN {initial}         sv_srt_time := sv_t_rtt;        END   {initial}      ELSE   
      BEGIN {not initial}  
       sv_srt_time := Round(tcpgbls.tcp_alpha * sv_srt_time +                            (1.0 - tcpgbls.tcp_alpha) * sv_t_rtt);    
      END;  {not initial}  
           sv_rt_time:= 0;      END;  {with}   
END;  {updaterttime} 
         $SUBTITLE 'TCP checksum routine', PAGE$   "{-----------------------------------------------------------------}  " "{                     GetCheckSum                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE GetChecksum      (VAR headers   : IPTCPHdrType;   
        opt_len   : Int16; 
 
        data_ptr  : Int16; 
 
        offset    : Int16; 
 
        data_len  : Int16; 
     VAR cksumword : Int16     );      {}  {    { Description: Calculate tcp checksum and return checksum value    {   in the output variable cksum. The procedure perform the   !{   calculation in two steps. Firstly, it calculates the checksum  !  {   on the IP psuedo header and the TCP header which are in the     {   local code space. The resultant checksum is used as an input    {   to another procedure DS_MOnesSum which in turn completes the   {   calculation with the data in the DSAM area.   {   !{ Calculated checksum is retuned in cksumword and error is return  ! { in the Global error variable tcp_error.   {   {   {}      VAR   	   error : Int16;  	 	   sum   : Int16;  	     
BEGIN {getchecksum}  
 WITH headers DO      BEGIN {with}   	   sum       := 0; 	 	   error     := 0; 	        {Calculate the tcp header locally}          IF opt_len >= 0 THEN         BEGIN   #      DS_LOnesSum(headers.int, 0, IPTCPHDRSIZE + opt_len, sum, error); #       END;         {Call DS_CheckSum if there is data}  
   IF error = 0 THEN 
       BEGIN   
      IF data_len > 0 THEN 
          DS_MOnesSum(data_ptr, offset, data_len, sum, error);         END;         cksumword := (-sum) - 1;      tcp_error := error;         END;  {with}   
END;  {getchecksum}  
         $SUBTITLE 'Function GetTCPSeq', PAGE$   !{----------------------------------------------------------------} ! !{                                                                } ! !{                       GetTCPSeq                                } ! !{                                                                } ! !{----------------------------------------------------------------} !     FUNCTION GetTCPSeq: TCPSeqType;       {}  { Description:   {    This procedure obtains the initial receive sequennce number   {    for a newly created connection. We assume the sequence is  
{    changing over timer.  
 {   { Parameters:   {    none   {   {}      VAR      sys_time  :  Int32;      	BEGIN {gettcpseq}  	 GetSystemTime ( sys_time );   GetTCPSeq := sys_time;  	END;  {gettcpseq}  	                 $Subtitle ' SetContextOK '$       {----------------------------------------------}  {            SetContextok                      }  {----------------------------------------------}      PROCEDURE SetContextok     {    event_type    : Int16;          ulp_refr      : Int16;          my_refr       : Int16;      VAR error         : Int16 };      {}  { Description:  {  The module perform the folowing tasks  {    1. Verify path pointer.  {    2. Verify pcb pointer.   {    3. If ok, copy path record and pcb into local space.   {   { Parameters:   !{  event_type   INPUT  Event message type from ipc or lower level  ! {                      protocol.  {  ulp_refr     INPUT  Upper level protocol reference.  {  my_refr      INPUT  tcp path reference.  {  error        OUTPUT error return.  {   
{ Global Variables:  
 {  port_ptr    TCP path record pointer.   {  tcp_port    TCP path record structure (local copy).  {  sb_ptr      socket record pointer (write port).  {  sb_ptr2     socket record pointer (read port).   {  sv_ptr      pcb (connection control block) pointer.  {  sv          pcb structure local copy.  {   {   { Return  : error = 0 if ok.  {           error = 1 if not ok.  {}      LABEL      66;      BEGIN  {setcontextok}       
{initialize all pointers}  
 error    := 0;  port_ptr := 0;  sv_ptr   := 0;  sb_ptr   := 0;  sb_ptr2  := 0;      
IF my_refr <> 0 THEN 
 	   BEGIN {ref ok}  	        {Fetch the path record and check if it is avalid path.}     DS_FetchElement(DS_tcp_pathtd, my_refr, tcp_port.int);       
   WITH tcp_port DO  
       BEGIN {check path & pcb}        IF p_port_type = UNDEFINEDTYPE THEN            BEGIN  !         {It is not an error condition; it may cause by the race}  ! !         {between two peer abort request and the Satbeam arrives}  ! !         {after the path has just been aborted.                 }  !          error := ABORTRACE;           goto 66; {bail out}           END;                 {set path pointer and get tcp control block}  
       port_ptr:= my_refr; 
           {reocrd the ulp reference}        IF (event_type = U_ACCEPT_CONNECT) OR              (event_type = U_DELAY_ACCEPT) OR               (event_type = CONNECT_REQUEST) THEN            BEGIN           p_up_refr := ulp_refr;            END;             p_msg_cnt := p_msg_cnt + 1;             {sets up the both send & receive sbuf ids}        sb_ptr  := p_up_refr * 2;         sb_ptr2 := sb_ptr - 1;            {See if the path is still ok; it may be aborted  }        {by the inbound peer; in that case we just return}        {a error...                                      }        IF p_syn_bits[-14] THEN            BEGIN           error     := PATHABORTED;           END        ELSE           BEGIN {path ok}           IF p_tcp_pcb <> 0 THEN   
            BEGIN {pcb ok} 
             sv_ptr:= p_tcp_pcb;               DS_FetchElement(DS_TCP_TCBTD, sv_ptr, sv.int);  
            END   {pcb ok} 
          ELSE               BEGIN {null pcb}               {This indicate that the connection has been dropped}                {by the inbound routine. Requests other than abort }                {and graceful release is illegal.                  }               IF (event_type = ABORT_REQUEST) OR                    (event_type = GRACEFUL_RELEASE_REQUEST) THEN                 BEGIN {true}                  {It ok to abort the partilly opened path}                 END   {true}               ELSE  
               BEGIN 
                error     := CONNDROPPED;  
               END;  
             END;  {null pcb}           END;  {path ok}        END;  {check path & pcb}  	   END   {ref ok}  	 ELSE     BEGIN {null pointer}   
   error := BADREFERENCE;  
    TCPLogError(error, TL_SETCONTEXTOK);      END;  {null pointer}       66:;      
END;  {setcontextok} 
             $Subtitle ' gettcpglobals'$   "{------------------------------------------------------------------} " "{                        GetTCPGlobals                             } " "{------------------------------------------------------------------} "     PROCEDURE GetTCPGlobals;      {}  { Description:  {    Initialize local copy of tcp's global variables.   {    These variables consists of various list pointers  	{    and options.  	 {   
{ Global Variables:  
 {  f_path_list_head        Free path structure list head.   {  i_path_list_head        Indeterminant path list head.  {  d_path_list_head        Determinant path list head.  {  f_tcb_list_head         Free tcb structure list head.  {  i_tcb_list_head         in_use tcb list head.  {  port_seed               next available tcp port address.   "{  expretxbackoff          Flags to use exponential backoff or not.  " {  debug                   tcp debug flag to execute trigger.   {}      	BEGIN {getglobals} 	 DS_FetchElement(DS_TCP_LISTHDTD, 1, tcpgbls.int);   WITH tcpgbls DO      BEGIN     f_path_list_head := f_phead;      i_path_list_head := i_phead;      d_path_list_head := d_phead;      f_tcb_list_head  := f_thead;      i_tcb_list_head  := i_thead;      port_seed        := port_addr;   
   null_ptr         := 0;  
        IF (tcp_debug = -1) OR (tcp_debug = 1) THEN  
      debug := true  
    ELSE         debug := false;          IF expbkof <> 0 THEN         expretxbackoff := true     ELSE         expretxbackoff := false;     END;   	END;  {getglobals} 	         $SUBTITLE 'Routine to get TCP Header', PAGE$  !{----------------------------------------------------------------} ! !{              Get TCP Header                                    } ! !{----------------------------------------------------------------} ! { Description: Allocate a mbuf for tcp reassembly; it is used    {   as the list head for the queue. It is tied to the connection   {   via the sv_template pointer.  {   {}      
PROCEDURE GetTCPHdr  
    {VAR mbufid  : Int16;  
    VAR result  : Int16};  
     VAR      mc          : Int16;      initial_ptr : ReassPtrType;     mmflg       : MMFlagsType;       	BEGIN {gettcphdr}  	 AdrOf(sv.int, null_ptr, vdbuf[1]);  
vdbuf[2] := IPTCPHDRSIZE;  
 mc       := vdbuf[2];   
mmflg.int     := 0;  
 mmflg.bits[0] := true;  mmflg.bits[-1]:= true;  DS_SBPut(vdbuf, 4, sb_ptr2, mmflg, mbufid, mc, result);       	IF result = 0 THEN 	 	   BEGIN {got mem} 	    {initialize the reassembly queue ptrs here}     initial_ptr.previous:= mbufid;      initial_ptr.next    := mbufid;      DS_MBOverWrite(initial_ptr.int, 4, mbufid, 0, result);   	   END;  {got mem} 	 	END;  {gettcphdr}  	         $SUBTITLE 'Routine to send response to remote', PAGE$   !{----------------------------------------------------------------} ! !{                                                                } ! !{                       TCPRespond                               } ! !{                                                                } ! !{----------------------------------------------------------------} !     
PROCEDURE TCPRespond 
    ( dnpth_ptr : Int16      ;        path_ptr  : Int16      ;        mbuf_ptr  : Int16      ;        ack       : TCPSeqType ;        seq       : TCPSeqType ;        flags     : OneOrBitType );  {}  { Description:   {    This routine formats and sends a tcp response to its peer;    {    the control flags are passed along by the caller.  {    It is called by: TCPInput  {   { Parameters:   {    dnpth_ptr: INPUT down path pointer.  {    path_ptr : INPUT pointer to the tcp path record.   {    mbuf_ptr : INPUT pointer to the incoming message buffer.   {    ack      : INPUT acknowledgement sequence number.  {    seq      : INPUT seq. # for the response packet.   {    flags    : INPUT Control flags for reponse packet.   {   {   
{ Global Variables:  
 {    port_ptr  : Path record pointer.   #{    tcp_port  : Path record; used when response is triggered locally. # {    sv        : protocol control block.  {   {}      VAR      mc,     len,      cksumword,      error,   
   window   : Int16; 
    path     : TCPPathRecType;   
   buf_ptr  : Int16; 
    iptcphdr : IPTCPHdrType;      msg      : EventMessageType;   
   mmflg    : MMFlagsType; 
 
   temp_var1: Int32; 
     CONST      INITHDRBUFF = IPTCPHdrType         [Hdr1: OvlyHdrType            [ih_prev : 0,              ih_next : 0,              ih_x1   : 0,              ih_pr   : TCP_PTCL,             ih_adj  : 0,              ih_len  : TCPHEADERSIZE,              ih_pad  : 0,              ih_src  : 0,              ih_dst  : 0],         Hdr2: TCPHdrType             [th_sport : 0,             th_dport : 0,             th_seq   : 0,             th_ack   : 0,             th_x2    : 0,             th_off   : 5,             th_flags : OneOrBitType [w : 0],              th_win   : 0,             th_sum   : 0,  
           th_urp   : 0]]; 
         	BEGIN {tcprespond} 	 error             := 0;   len               := 0;   cksumword         := 0;   mmflg.int         := 0;   iptcphdr          := INITHDRBUFF;       {Set flag to say borrow if needed and no overhead mbufs}  mmflg.bits[0]  := true;   mmflg.bits[-1] := true;       IF path_ptr <> 0 THEN   
   BEGIN {get path}  
    {We have a path to use and we should use it}      DS_FetchElement(DS_tcp_pathtd, path_ptr, path.int);      
   WITH path, sv DO  
       BEGIN {valid pcb}             {If we have a valid PCB then the global local copy is}        {good and should use that copy...                    }        IF p_tcp_pcb = 0 THEN            BEGIN           {Set connection pcb to its initial state}           sv := INITSTATEVECTOR;            END;                 {use the down path from our path record}        ip_path_refr := p_dn_refr;            {If we are in message mode, the window is the absolute}         {window ie, sv_rcv_wnd; if in stream mode, the window }         {is the available window, ie sv_av_wnd. For now just  }         {use the absolute window. Nonetheless, check the input}         {space and see how much is there.                     }             DS_SBSpace(sb_ptr2, sv_av_wnd, dataread, tcp_error);        sv_rcv_wnd := sv_rcv_wnd + dataread;        window     := sv_rcv_wnd;         END;  {valid pcb}   
   END   {get path}  
 ELSE     BEGIN {use incoming path}     ip_path_refr:= dnpth_ptr;     END;  {use incoming path}      {get a local copy of the incoming headers if there is one.}   {We may not have one if the response results from a timer }   {action, eg. keep alive. In the latter case we just fix   }   {up the local header.                                     }       IF mbuf_ptr <> 0 THEN      BEGIN     DS_MRead(iptcphdr.int, IPTCPHDRSIZE, mbuf_ptr, 0,  
      mmflg, error); 
    END;       {If no flags present, then we know that it is a zero window}  {probe or keep alive message. The flag is TH_ACK.          }      
IF flags.w = 0 THEN  
    BEGIN  
   flags.w:= TH_ACK; 
    END;       WITH iptcphdr.hdr1, iptcphdr.hdr2 DO     BEGIN {*}     {Use the incoming header if there is one, because we}     {may not have the context informatiom.              }     IF mbuf_ptr <> 0 THEN        BEGIN   
      temp_var1:= ih_src;  
 
      ih_src   := ih_dst;  
       ih_dst   := temp_var1;        temp_var1:= th_sport;         th_sport := th_dport;         th_dport := temp_var1;        END      ELSE         BEGIN         WITH tcp_port DO           BEGIN {with tcport}           ih_src   := p_si_addr;            ih_dst   := p_di_addr;            th_sport := p_s_port;           th_dport := p_d_port;           END;  {with tcport}        END;         {fix things up for checksum purpose}      ih_prev:= 0;      ih_next:= 0;      ih_adj := 0;      ih_len := TCPHEADERSIZE + len;       
   {set up the tcp header} 
 	   th_seq := seq;  	 	   th_ack := ack;  	    th_x2  := 0;      th_off := 5;      th_flags.w:= flags.w;  
   th_win := window; 
    th_urp := 0;      th_sum := 0;          {Calculate checksum. Here will do not worry about checksum}     {optioning. All response packet will be checksumed locally}         GetChecksum(iptcphdr, 0, null_ptr, 0, len, cksumword);          {Check if we need to comply to optional checksumming}     IF path_ptr <> 0 THEN        BEGIN {valid path}        IF (NOT sv.sv_t_flags.rmcksum) AND               (NOT sv.sv_t_flags.cksumopt) THEN           BEGIN           {If optional checksum is requested check for}           {zero checksum and make it be -1.           }           IF cksumword = 0 THEN  	            BEGIN  	             cksumword := -1;              END            ELSE   	            BEGIN  	             cksumword := 0;               END;           END;         END; {valid path}          {asssign the checksum word}     th_sum := cksumword;      END; {*}       {write the buffer out to dsam}  
vdbuf[3] := IPHEADERSIZE;  
 AdrOf(iptcphdr.int, vdbuf[3], vdbuf[1]);  
vdbuf[2] := TCPHEADERSIZE; 
     {Get tcp's special sbuf from the global table}  tcp_sb        := tcpgbls.tcpsocket + tcpgbls.tcpsocket;       mc            := TCPHEADERSIZE;        {mmflg says borrow if needed; don't allocate overhead space and}    {don't have to worry about the reserved mbufs.                 }   
mmflg.int     := 0;  
 mmflg.bits[0] := true;  mmflg.bits[-1] := true;   mmflg.bits[-2] := true;       DS_SBPut(vdbuf, 4, tcp_sb, mmflg, buf_ptr, mc, error);      	IF error = 0 THEN  	 	   BEGIN {sendit}  	    WITH msg DO  
      BEGIN {format e_msg} 
       ehport           := IPOUTBOUNDIDX;        em_event         := SEND_REQUEST;         emsr_down_ref    := ip_path_refr;         emsr_mbufid      := buf_ptr;        emsr_flags.int   := TCPDEFAULTTOS;        emsr_dlen        := iptcphdr.hdr1.ih_len;         emsr_opt_mbufid  := 0;        emsr_killsnd_cnt := 1;        emsr_killrcv_cnt := 0;  
      END;  {format e_msg} 
        {need to save our connection and path context information}      {before calling IP.                                      }          IF port_ptr <> null_ptr THEN         BEGIN         tcp_port.p_syn_bits[0] := true;   "      DS_StoreFields(DS_TCP_PATHTD, Port_ptr, tcp_port.startofdata,  "          DATAOFFSET, PATHDATASIZE);         END;         IF sv_ptr <> null_ptr THEN         BEGIN         DS_StoreFields(DS_TCP_TCBTD, sv_ptr, sv.startofdata,           DATAOFFSET, SVDATASIZE);         END;         {}      DS_LeaveCritical ( tcp_wkmap );     ProSw(msg, error);      DS_EnterCritical ( tcp_wkmap, tcp_ierr );     {}       !   {If it is a connection assurance or window probe response, we}  ! !   {need to get the context blocks again.                       }  !    IF path_ptr <> 0 THEN        BEGIN         DS_FetchElement(DS_tcp_pathtd, port_ptr, tcp_port.int);         sv_ptr := tcp_port.p_tcp_pcb;         tcp_port.p_syn_bits[0] := false;  
      IF sv_ptr <> 0 THEN  
          BEGIN           DS_FetchElement(DS_TCP_TCBTD, sv_ptr, sv.int);            END        ELSE           BEGIN           {The connection has been aborted by our inbound peer}           {so just clean up the path.                         }           TCPClosePath(tcp_port, path_ptr);           END;         END;  	   END   {send it} 	 ELSE  
   BEGIN {no memory} 
    {Log the MMGR error}      TCPLogError(error, TL_TCPRESPOND);   
   END;  {no memory} 
 	END;  {tcprespond} 	         $SUBTITLE 'allocate a tcp port', PAGE$  !{----------------------------------------------------------------} ! !{                                                                } ! !{                       AllocatePortAddr                         } ! !{                                                                } ! !{----------------------------------------------------------------} !     
PROCEDURE AllocatePortAddr 
    (VAR  portnumber: Int16);  {}  { Description:  {    This routine allocate a unique port address for a new TCP  {    connection. It also search the limbo list which contains   {    a list of addresses not to be used for awhile.   {   { Parameters:   {    portnumber  : OUTPUT  tcp port address.  {   
{  Global variable:  
 !{    port_seed :   16 bit port address stored in the global table  ! !{                  area and read in locally whenever the protocol  ! {                  is entered.  {}      VAR         i:            Int16;    rtn_err:      Int16;    rtn_idx:      Int16;    path_buf:     TCPPathRecType;       BEGIN {allocateportaddr}      REPEAT    {Get a port address}     IF port_seed = MAX_DYNAMIC THEN        BEGIN {exceed max}        port_seed:= MIN_DYNAMIC;        END {exceed max}     ELSE         BEGIN {not exceed}        port_seed:= port_seed + 1;        END; {not exceed}       
   portnumber:= port_seed; 
        {search the d_rec list first}     rtn_err := 0;     rtn_idx := 0;     i       := d_path_list_head;          DS_LinkedFindAndFetchFields( DS_TCP_PathTD, i,          i, 1, 3, 1, portnumber, 0, 0,             path_buf.int, rtn_idx, rtn_err);           {search the i_rec list if cannot find one in the d_rec list}       IF rtn_err <> 0 THEN   
      BEGIN {i_rec}  
 
      rtn_err := 0;  
       i       := i_path_list_head;            DS_LinkedFindAndFetchFields( DS_TCP_PathTD, i,            i, 1, 3, 1, portnumber, 0, 0,                 path_buf.int, rtn_idx, rtn_err);  
      END;  {i_rec}  
        {If no duplicate so far, search the limbo list}     IF rtn_err <> 0 THEN   
      BEGIN {limbo}  
       DS_FetchElement(DS_TCP_TCBTD, i_tcb_list_head, sv.int);   
      rtn_idx := 0;  
       For i := 0 TO LIMBOLSTSIZE - 1 DO             BEGIN             IF sv.limbolist[i] = portnumber THEN  
             rtn_idx := 1; 
           END;  
      END;  {limbo}  
     	UNTIL rtn_idx = 0; 	     {Write the port_seed value back to dssm table}  DS_StoreFields(DS_TCP_ListHdTd, 1, port_seed, 7, 1);  END; {allocateportaddr}           $SUBTITLE 'Routine to allocate a state vector', PAGE$   !{----------------------------------------------------------------} ! !{                                                                } ! !{                       AllocateSV                               } ! !{                                                                } ! !{----------------------------------------------------------------} !     
PROCEDURE AllocateSV 
    (VAR sv_ptr: Int16);   {}  { Description:  {    This routine allocate a free tcp control block sv.   {   { Parameters:    {    sv_ptr   : OUTPUT  address of the allocated control block.    {}      VAR      ptr_buf     : ReassPtrType;      	BEGIN {allocatesv} 	 DS_FetchFields(DS_tcp_tcbtd, f_tcb_list_head,      ptr_buf.int, 0, 2);      
WITH sv, ptr_buf DO  
    BEGIN {with ptr_buf}      IF next <> f_tcb_list_head THEN  
      BEGIN {*free entry*} 
           {delete the first free entry from the list}         DeleteList(DS_tcp_tcbtd, f_tcb_list_head, next);            {put it in the in_use list}         InsertList(DS_tcp_tcbtd, i_tcb_list_head, next);            {initialize the local copy of the tcb}        sv     := INITSTATEVECTOR;        sv_ptr := next;             {Get the linkages ...}  &      DS_FetchFields(DS_tcp_tcbtd, sv_ptr, ptr_buf.int, 0, SIZEOFPOINTERS);  &       sv_pre_ptr := previous;   
      sv_nxt_ptr := next;  
           {initialize our max. segment size}        sv_maxseg.word := tcpgbls.segsize;            {Write this local copy into dssm}         DS_StoreFields(DS_TCP_TCBTD, sv_ptr, sv.startofdata,           DATAOFFSET, SVDATASIZE);   
      END  {*free entry*}  
    ELSE         BEGIN {no free entry}   	      sv_ptr := 0; 	       END;  {no free entry}      END; {with ptr_buf}  	END; {allocatesv}  	             !{----------------------------------------------------------------} ! !{                                                                } ! !{                       TCPClose                                 } ! !{                                                                } ! !{----------------------------------------------------------------} !     
PROCEDURE TCPClose;  
 {}  { Description:  {    Release the protocol control block sv; discard all space   {    held by the tcp on that connection.  {   
{ Global Variables:  
 {    sv  :  {   {}      VAR   
   error   : Int16;  
 
   pointer : Int16;  
 
   mm_flags: MMFlagsType;  
 
   newptr  : ReassPtrType; 
     BEGIN {tcpclose}  
mm_flags.bits[0] := true;  
 {flush any undelivered input data}  IF sv.sv_template <> 0 THEN   
   BEGIN {has queue} 
    WITH sv, newptr DO         BEGIN {with sv}          DS_Mread(newptr.int, 4, sv_template, 0, mm_flags, error);          pointer := next;            WHILE pointer <> sv_template DO            BEGIN {flush}           DS_Mread(newptr.int, 4, pointer, 0, mm_flags, error);           DS_MDispose(pointer, error);            pointer:= next;           END; {flush}        DS_MDispose (sv_template, error);  
     END;  {with sv} 
 
  END;  {has queue}  
     
{Cancel any active timers} 
 TcpCancelAllTimer( sv );      {Update TCP global statistics}  WITH tcpgbls.stats DO      BEGIN     badsum  :=  badsum + sv.sv_tcpstat.badsum;      badoff  :=  badoff + sv.sv_tcpstat.badoff;      hdrop   :=  hdrop + sv.sv_tcpstat.hdrop;      badsegs :=  badsegs + sv.sv_tcpstat.badsegs;      unack   :=  unack + sv.sv_tcpstat.unack;      END;       DS_StoreElement(DS_TCP_ListHdTd, 1, tcpgbls.int);       {return connection control block}   FreeSVector;      END;  {tcpclose}              $SUBTITLE 'Routine to release tcp connection', PAGE$  !{---------------------------------------------------------------}  ! !{                         TCPConnDrop                           }  ! !{---------------------------------------------------------------}  !     PROCEDURE TCPConnDrop      {VAR tcp_port: TCPPathRecType;           pointer : Int16;          error   : Int16           };  {}  {   { Description:  {  This procedure is called to release all resource tied  {  to a connection which consist of a state vector structure  {  and all memory associated with the sv; keep path structure   {  until handshake is over. Send an abort indication to ipc.  {   { Parameters:   {  tcp_port  INPUT  tcp Path structure  {  pointer   INPUT  tcp path pointer  {  error     INPUT  error return to ULP   {   {}      VAR      panic_num : Int16;       
BEGIN {tcpconndrop}  
 IF tcp_port.p_tcp_pcb <> sv_ptr THEN     BEGIN     panic_num := SEVEREDSERROR;     TCPLogError(panic_num, TL_TCPCONNDROP);     END  ELSE     BEGIN {release sv}       {Marked that connection has been dropped; drop all resource}        {associated with the connection. Update the global stats   }        {and write the globals back to DSAM table.                 }        
   tcp_port.p_tcp_pcb:= 0; 
     DS_StoreFields(DS_TCP_PathTD, pointer, tcp_port.startofdata,          DATAOFFSET, PATHDATASIZE);         {Close the connection and discard all resources}      TCPClose;         {If it a graceful release, send a confirm else send ulp}      {a abort indication.                                   }      IF sv.sv_t_flags.graceful THEN         BEGIN         SSDisconnectCfm;        END      ELSE         BEGIN         SSendAbortInd(error);         END;  
   END; {release sv} 
 
END;  {tcpconndrop}  
              {--------------------------------------------------------------}    {                     TCPClosePath                             }    {--------------------------------------------------------------}       PROCEDURE TCPClosePath     (VAR tcp_port : TCPPathRecType;      VAR port_ptr : Int16           );   {}  {   { Description:  {  Delete the path record from respective tcp path list.  {  If the port type is Call then delete from the i_list   {  otherwise delete it from the d_list.   {   { Parameters:   {  tcp_port   INPUT tcp path record local copy.   {  port_ptr   INPUT tcp path record pointer.  {   {}      LABEL      89;      VAR   	   temp   : Int16; 	 	   error  : Int16; 	    rp_msg : EventMessageType;       {---------------------------------------------}   {           EnterLimboList                    }   {---------------------------------------------}       
PROCEDURE EnterLimboList;  
     {}  #{ Description: This procedure is called by TCP to put the source port  # #{   number in a 'limbo' list when a connection is terminated; the TCP  # #{   spec. recommend that the system should refrain from re-allocating  # "{   the port number for at least 2 max. segment life-time (2msl = 4  " #{   minutes). The list is circular and is purged every 4 minutes. The  # "{   list is implemented as part of the active protocol control list; " #{   It resides in the unused portion of the active PCB list sentinel.  # {   The limbo list is searched by the TCP port allocation.  {   { Parameter:  !{   tcp_port.p_s_port:  TCP port number to be enter into the list. ! {   {}      	BEGIN  {enterlist} 	 {Fetch the list in the active PCB list sentinel}  DS_FetchElement(DS_TCP_TCBTD, tcpgbls.i_thead, sv.int);   sv.limbolist[sv.limboptr] := tcp_port.p_s_port;   sv.limboptr := (sv.limboptr + 1) MOD LIMBOLSTSIZE;  	END;   {enterlist} 	     {-------------------------}   {Main Code of TCPClosePath}   {-------------------------}       
BEGIN {tcpclosepath} 
     {Fetch the path record}   DS_FetchElement(DS_tcp_pathtd, port_ptr, temp_path.int);      IF temp_path.p_port_type = UNDEFINEDTYPE THEN      BEGIN     TCPLogError(ABORTRACE, TL_TCPCLOSEPATH);      GOTO 89;      END;       IF temp_path.p_port_type = CALL_PORT THEN      BEGIN {call}      DeleteList(DS_tcp_pathtd, i_path_list_head, port_ptr);      END   {call}   ELSE  
   BEGIN {not call}  
    temp_path.p_snd_cnt := temp_path.p_snd_cnt + 1;     DeleteList(DS_tcp_pathtd, d_path_list_head, port_ptr);   
   END;  {not call}  
     {Intialize the path record to a undefined state}  	WITH temp_path DO  	    BEGIN     p_port_type := UNDEFINEDTYPE;     END;       DS_StoreFields(DS_TCP_PathTD, port_ptr, temp_path.startofdata,                    DATAOFFSET, PATHDATASIZE);  InsertList(DS_tcp_pathtd, f_path_list_head, port_ptr);      {Enter the source tcp port address into the limbo list}   {and reset the timer.                                 }   TCPCancelTimer(MSLTYPE,tmr_err);  EnterLimboList;   TCPSetTimer(MSLTYPE,TCPTV_MSL);   DS_StoreFields(DS_TCP_TCBTD, tcpgbls.i_thead, sv.startofdata,      DATAOFFSET, SVDATASIZE);       sv       := INITSTATEVECTOR;      IF temp_path.p_dn_refr <> 0 THEN     BEGIN  	   WITH rp_msg DO  	       BEGIN {abort dn_path}         ehport           := IPOUTBOUNDIDX;        em_event         := KILL_REQUEST;         emkr_down_ref    := temp_path.p_dn_refr;        emkr_msg_rcv_cnt := temp_path.p_ref_cnt;        emkr_msg_snd_cnt := temp_path.p_snd_cnt;            {}        DS_LeaveCritical ( tcp_wkmap );         ProSw(rp_msg, error);         DS_EnterCritical ( tcp_wkmap, tcp_ierr );         {}        END;  {abort_dn_path}      END;       89:;      sv_ptr   := null_ptr;   port_ptr := null_ptr;   
END;  {tcpclosepath} 
         $SUBTITLE 'FreeSVector Routine', PAGE$  {------------------------------------------------------------}  {                     FreeSVector                            }  {------------------------------------------------------------}      PROCEDURE FreeSVector;      {}  { Description:  {  Release the connection control block tcb to the free list.   {   
{ Global Parameters: 
 {  sv_ptr  INPUT  Pointer to the tcb.   {   {}      VAR   
   rtn_idx : Int16;  
 
   rtn_err : Int16;  
     
BEGIN {freesvector}  
 {Perform validity check on the pointer...this is a paronoid}  {check; it can be taken out for performance.               }  
IF sv_ptr <> 0 THEN  
    BEGIN     {Check if the PCB is really in the active list}     DS_LinkedFindAndFetchFields( DS_TCP_TCBTD, i_tcb_list_head,         i_tcb_list_head, 1, 1, 1, sv_ptr, 0, 0,             sv.int, rtn_idx, rtn_err);          IF rtn_err = 0 THEN        BEGIN         DeleteList (DS_tcp_tcbtd, i_tcb_list_head, sv_ptr);             {Write the content of the PCB back to DSAM}         DS_StoreElement(DS_TCP_TCBTd, sv_ptr, sv.int);            InsertList (DS_tcp_tcbtd, f_tcb_list_head, sv_ptr);         END      ELSE         BEGIN         {Log the MMGR error and complain}         TCPLogError(rtn_err, TL_FREESVECTOR);         END;     sv_ptr := null_ptr;     END;   
END;  {freesvector}  
             $SUBTITLE 'Routine to allocate tcp resources', PAGE$  {------------------------------------------------------------}  {                      GetResource                           }  {------------------------------------------------------------}      PROCEDURE GetResource   
   (    option     :Int16; 
 
    VAR sv_ptr     :Int16; 
 
    VAR port_ptr   :Int16; 
     VAR error      :Int16 );      {}  {   { Description:  { This function try to allocate the following resources:  {   {    1. allocate a state vector structure   {    2. allocate a path structure   {   {    If option =  0 then get all and d_rec  {              <> 1 then get all and i_rec  { Parameters:   {  option     INPUT    0 used for d_path; 1 used for i_path;  {  sv_ptr     OUTPUT   connection control block pointer.  {  port_ptr   OUTPUT   path record pointer (path reference).  {  error      OUTPUT   successful = 0 else = NOCONNRESRC  {   {}      VAR   
  ptr_buf :  ReassPtrType; 
     
BEGIN {getresource}  
 sv_ptr   := 0;  port_ptr := 0;  error    := NOCONNRESRC;      DS_FetchFields(DS_tcp_pathtd, f_path_list_head,      ptr_buf.int, 0, 2);      WITH ptr_buf DO   
   BEGIN {check free list} 
    IF next <> f_path_list_head THEN   
      BEGIN {*free*} 
 
      AllocateSV(sv_ptr);  
 
      IF sv_ptr <> 0 THEN  
          BEGIN {got it}   
         port_ptr:= next;  
           DeleteList(DS_tcp_pathtd, f_path_list_head, port_ptr);                 {Initialize the path structure}           temp_path := INITTCPPATH;  $         DS_StoreFields(DS_TCP_PathTD, port_ptr, temp_path.startofdata,  $             DATAOFFSET, PATHDATASIZE);               IF option = 0 THEN               BEGIN {for d_rec}               {put it in the d_path list}   !            InsertList(DS_tcp_pathtd, d_path_list_head, port_ptr); !             END   {for d_rec}            ELSE               BEGIN {for i_rec}               {put it in i_path list}   !            InsertList(DS_tcp_pathtd, i_path_list_head, port_ptr); !             END;  {for i_rec}   
         error:= 0;  
          END {got it}         ELSE           BEGIN {no sv}           {Out of tcb control blocks}           END;  {no sv}  	      END {*free*} 	    ELSE   
      BEGIN {no free path} 
       {out of path structures}  
      END;  {no free path} 
 
   END; {check free list}  
 	END; {getresource} 	             $SUBTITLE 'Routine to locate a connection', PAGE$   "{-----------------------------------------------------------------}  " "{                     PortLookUp                                  }  " "{-----------------------------------------------------------------}  "     
PROCEDURE PortLookUp 
    {    s_key      : ConnIdType;      VAR error      : Int16     };   {}  {   { Description:  {  The routine performs the following tasks.  {   1. Search the vc port for existing connection; get the  {      state vector (tcb) if found.   {   2. If no existing connection, search the call port list.  {   3. Allocate port address, state vector, path reference  {      and other resource if it's a new connection.   {   4. Error return: NOENDPOINT   {                    NOCONNRESC   { Parameters:   #{  s_key        INPUT   Search key containing the tcp port addrees and # {                       IP addresses.   !{  error        OUPUT   not successful -> no endpoint or noconnrsc ! {   
{ Global Variables:  
 {   port_ptr, sv_ptr, tcp_port, sv, c_port_ptr,   {   d_path_list_head, i_path_rec_head.  {   {}      VAR   
   portaddr : int16; 
     	BEGIN {portlookup} 	 {Initialize the local and global variables}   
error          := 0; 
 
portaddr       := 0; 
 sb_ptr         := 0;  {global}  sb_ptr2        := 0;  {global}  c_port_ptr     := 0;  {global}      !{Search for active connection port entry first. We always assume}  ! !{the incoming packet is for an existing connection; there is a  }  ! !{valid reason to do that. If the packet is a call packet and    }  ! !{ the address match one of our active connection, we have to    }  ! !{drop the packet and also send a RESET to the sender.           }  !     DS_LinkedFindAndFetchFields( DS_TCP_PathTD, d_path_list_head,       d_path_list_head, 1, 3, 6, s_key.int, 0, SIZEOFTCPPATH,           tcp_port.int, portaddr, error);       IF (error = 0) AND (portaddr <> 0) THEN   	   BEGIN {get sv}  	    port_ptr:= portaddr;          {increment the message count and set the inbound and    }     {outbound socket buffer pointers for further processing.}  
   WITH tcp_port DO  
       BEGIN         sb_ptr    := p_up_refr * 2;         sb_ptr2   := sb_ptr - 1;        p_ref_cnt := p_ref_cnt + 1;         sv_ptr    := p_tcp_pcb;         END;         {Here we check to see if the connection is in the  }      {time_wait state ie, the cnnection has already been}      {aborted and the PCB has been released. In that case}     {will set the local copy of the PCB to its initial }      {(closed) state.                                   }              IF sv_ptr <> 0 THEN        BEGIN {tcb open}        {The connection is open, fetch the PCB from DSAM}         DS_FetchElement(DS_tcp_tcbtd, sv_ptr, sv.int);        END      ELSE         BEGIN         {Set connection control block to CLOSED state}        sv  := INITSTATEVECTOR;         END;     END {get sv}   ELSE     BEGIN {search call port}   	   error    := 0;  	 	   portaddr := 0;  	     !   {Look at the ipath list (THE CALL PORTS); try to find a match}  ! !   {if the incoming segment has the SYN flag (a call packet)    }  !    IF inseghdr.hdr2.th_flags.b.syn THEN         BEGIN   "      {replace the addresses with wildcard and then search the list} " 
      WITH s_key DO  
          BEGIN           c_d_port  := TCPWILDCARD;           c_di_addr := IPWILDCARD;            c_si_addr := IPWILDCARD;            END;       "      DS_LinkedFindAndFetchFields( DS_TCP_PathTD, i_path_list_head,  "           i_path_list_head, 1, 3, 6, s_key.int, 0, SIZEOFTCPPATH,                tcp_port.int, portaddr, error);        END;         {If located, the call port path structure is in temp_path}      IF (error = 0) AND (portaddr <> 0) THEN        BEGIN {allocate resources}        {Try to allocate the connection resources; we need}         {a path structure and a PCB record to succeed.    }         GetResource(DPATHOPTION, sv_ptr, port_ptr, error);            IF (port_ptr <> 0) AND (error = 0) THEN            BEGIN {got it}            {We got what we needed for a new connection.}           {Go ahead and set both structures to their  }           {initial states.                            }               WITH tcp_port, search_key DO               BEGIN {build path record}                    {Remember the ipath reference. We need it later for}                {delivery of the connect request to ULP (ipc).     }               c_port_ptr := portaddr;                   {Fetch the newly created path record which has}               {the linkages...                              }   "            DS_FetchElement(DS_tcp_pathtd, port_ptr, tcp_port.int);  "     "            {Initialize the new path for this connection. The port}  " "            {is set to be a CIRCUIT_PORT and set the from_llp_msg }  " "            {count to 1.                                          }  "             p_port_type   := CIRCUIT_PORT;              p_s_port      := c_s_port;              p_d_port      := c_d_port;              p_ref_cnt     := 1;               p_dn_refr     := ip_path_refr;              p_si_addr     := c_si_addr;               p_di_addr     := c_di_addr;               p_tcp_pcb     := sv_ptr;              END;  {build path record}                {Put it back in DSAM, so that we will lose it.}  #         DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata, #             DATAOFFSET, PATHDATASIZE);               {setup state vector for input processing}           DS_FetchElement(DS_tcp_tcbtd, sv_ptr, sv.int);            sv.sv_state:= CLOSED;           END   {got it}         ELSE           BEGIN {no resource}           {Cannot obtain the resources we needed}           error:= NOCONNRESRC;            END;  {no resource}        END   {allocate resources}     ELSE         BEGIN         {Searched the whole world; cound't find the path or}        {a CALL socket for this packet. Return error.      }            {We should search the limbo list here to see if the}        {packet is for a closed connection which is actually}         {in the time_wait state. If so set the local copy of}         {the sv to a time_wait state... not now.            }   
      error:= NOENDPOINT;  
       END;  
   END; {search call port} 
 	END; {portlookup}  	         $Subtitle 'tcp Return Address',PAGE$  {----------------------------}  {   TCPDYNAMICADDR           }  {----------------------------}      PROCEDURE TCPDynamicAddr  
   {    pathref   : Int16; 
     VAR dynaddr   : AddressType;      VAR addrlen   : Int16       };      {}  { Description: Return dynamic TCP port address to caller.   {   No error checking is performed on this call; no user  {   is allowed to use this routine.   {}      	BEGIN {tcpdynamic} 	 DS_FetchElement(DS_TCP_PATHTD, pathref, tcp_port.int);  dynaddr.int := tcp_port.p_s_port;   	addrlen     := 2;  	 	END;  {tcpdynamic} 	         $Subtitle 'TCP Add Path Element', page$   {---------------------------}   {   TCPADDELEMENT           }   {---------------------------}       PROCEDURE TCPAddElement      { VAR sp        : Int16;        VAR stack     : TemplateControlStack;       VAR crec      : TemplateControlRecord;        VAR vnarec    : VNARecord;        VAR pathstart : Int16;        VAR rptr      : Int16;        VAR report    : PathReportRecord;       VAR dynamicptr: Int16;        VAR ierr      : Int16 };       {}  { Abstract:   {  Called to add protocol elements to path report templates.  {}      LABEL 99;       VAR      i           : Int16;      protorec    : ProtocolRecord;     temprptr    : Int16;      tempcrec    : TemplateControlRecord;       PROCEDURE Escape ( error  : Int16 );     BEGIN  	   ierr := error;  	    GOTO 99;      END; {Escape}      BEGIN   { Add a TCP protocol element to the path report buffer.}  temprptr := (rptr + 1) DIV 2;   
report.bytes[rptr] := TCP; 
 	rptr := rptr + 1;  	 report.bytes[rptr] := 4; {element length}   	rptr := rptr + 1;  	 
temprptr := temprptr + 1;  
 report.ints[temprptr] := 0; {service map}   rptr := rptr + 2; {index dispatch address field}  IF (crec.tc_uppid = IPC) THEN      BEGIN     { We're supposed to add a dynamic element.}     temprptr := temprptr + 1;     report.ints[temprptr] := dynamicptr;      dynamicptr := rptr;  
   rptr := rptr + 2; 
    END  ELSE     BEGIN  
   Escape (SEVEREDSERROR); 
 
   END; {IF crec.tc_uppid} 
      {Now fetch the TCP protocol record & use it to determine which }    {protocols support TCP. Push a control record onto the template}    {control stack for each one that does.                         }       DS_FetchElement ( DS_ProtosTD, TCP, protorec.int);  FOR i := 0 TO LAST_INDIVIDUAL_PID DO     BEGIN     WITH protorec, tempcrec DO         BEGIN         IF pr_supportingpids.bits[i] THEN            BEGIN           { We've found a supporting protocol.}           tc_activepid := i;   
         tc_uppid := TCP;  
              {Always assume we have to copy}           tc_pathoffset := rptr - pathstart;            sp := sp + 1;           stack[sp] := tempcrec;            END; {IF pr_supportingpids}  	      END; {WITH}  	    END; {FOR i}       {Alway do a no copy on the last one}  stack[sp].tc_pathoffset := 0;   ierr := 0;      99:;  
END; {TcpAddElement} 
             $Subtitle 'tcp build path routine'$   {--------------------------------------------}  {    TCPBUILDPATH                            }  {--------------------------------------------}      PROCEDURE TcpBuildPath     { VAR pathreport  : PathReportRecord;           vnaptr      : Int16;            elementptr  : Int16;            uppid       : Int16;        VAR downpid     : Int16;        VAR downref     : Int16;        VAR options     : PathOptionsRecord;        VAR bpwkmap     : Int16;        VAR ierr        : Int16 };       {}  { Description:  {  TCPBuildPath is called by ipc to build a tcp path  {  (dpath) and link it to the lower path reference  {  given.   {   { Output:   {    ierr : If successful is set to 0   {           If Not successful is set to NOCONNRESRC   {}      TYPE      
   IntOrAddrType = RECORD  
       CASE BOOLEAN OF         true:  (addr : ARRAY [1..2] OF Int32);        false: (int  : ARRAY [1..4] OF Int16);        END;      VAR   
   i       : Int16;  
    ipaddr  : IntOrAddrType;       BEGIN {tcpbuild}  GetTCPGlobals;  GetResource(DPATHOPTION, sv_ptr, port_ptr, tcp_error);  IF tcp_error = 0 THEN   	   BEGIN {got rsc} 	    {Get the dpath rec with link words}     DS_FetchELement(DS_tcp_pathtd, port_ptr, tcp_port.int);         {Get a source port address}     AllocatePortAddr(portnumber);      
   {Get pcb control block} 
    DS_FetchElement(DS_TCP_TCBTD, sv_ptr, sv.int);          {Get IP addresses}      FOR i := 1 to 4 DO         BEGIN         ipaddr.int[i] := options.ints[i];         END;      
   WITH tcp_port DO  
       BEGIN {build path record}         p_port_type := CIRCUIT_PORT;        p_s_port    := portnumber;        {get tcp dest. port and service map}        {See if ULP reference well-knwon address}         IF elementptr < 0 THEN           BEGIN           {DS_FetchFields(DS_STDADR_TD, -elementptr,      }           {                  p_d_port, 0, 1);             }               {Kludge for testing}            p_d_port    := HP_NFT; {should be address}            p_s_flags   := 0; {should be a constant}            END        ELSE           BEGIN            p_d_port    := pathreport.ints[(elementptr + 4) DIV 2];             p_s_flags   := pathreport.ints[(elementptr + 2) DIV 2];            END;         p_ref_cnt   := 1;         p_up_pid    := uppid;         p_dn_pid    := downpid;         p_up_refr   := 0;         p_dn_refr   := downref;         p_up_cnt    := 1;         p_si_addr   := ipaddr.addr[1];        p_di_addr   := ipaddr.addr[2];        p_tcp_pcb   := sv_ptr;        END;  {build path record}           {write path record into dssm and return parameters to caller}       DS_StoreFields(DS_TCP_PATHTD, Port_ptr, tcp_port.startofdata,         DATAOFFSET, PATHDATASIZE);         ierr := 0;   	   downpid := TCP; 	    downref := port_ptr;   	   END  {got rsc}  	 ELSE     BEGIN {no resources}   	   WITH rp_msg DO  	       BEGIN         ehport         := IPOUTBOUNDIDX;        em_event       := KILL_REQUEST;         emkr_down_ref  := downref;        emkr_msg_rcv_cnt   := 1;        emkr_msg_snd_cnt   := 0;        END;         {}      DS_LeaveCritical ( bpwkmap );     ProSw(rp_msg, tcp_ierr);      DS_EnterCritical ( bpwkmap, tcp_ierr );     {}          ierr :=  131{NOCONNRESRC};      END;  {no resources}   END;  {tcpbuild}          $SUBTITLE 'send abort indication', PAGE$  !{---------------------------------------------------------------}  ! !{                   SSendAbortInd                               }  ! !{---------------------------------------------------------------}  !     PROCEDURE SSendAbortInd {VAR error : Int16};      {}  { Description:  {  Send abort indication; wait for an abort reply.  {   {}      BEGIN {ssendabortind}       WITH rp_msg, tcp_port DO     BEGIN  {with}     p_up_cnt       := p_up_cnt + 1;     ehport         := IPCINBOUNDIDX;      em_event       := ABORT_INDICATION;     emai_up_ref    := p_up_refr;   
   emai_down_pid  := TCP;  
    emai_down_ref  := port_ptr;     emai_msg_cnt   := p_up_cnt;     {map TCP error to IPC error}      IF (error = CONNREFUSED) OR (error = CONNRESET) THEN          BEGIN         emai_reason    := 65;         END     ELSE         BEGIN         emai_reason     := 34;        END;     END;   {with}          	{Save context...}  	 
IF sv_ptr <> 0 THEN  
 
   BEGIN {valid PCB} 
    DS_StoreFields(DS_TCP_TCBTD, sv_ptr, sv.startofdata,          DATAOFFSET, SVDATASIZE);      END;       IF port_ptr <> 0 THEN      BEGIN      DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata,         DATAOFFSET, PATHDATASIZE);     END;       {}  DS_LeaveCritical ( tcp_wkmap );   ProSw(rp_msg, tcp_ierr);  DS_EnterCritical ( tcp_wkmap, tcp_ierr );   {}      {Get context...}  IF port_ptr <> 0 THEN      DS_FetchElement(DS_tcp_pathtd, port_ptr, tcp_port.int);      
IF sv_ptr <> 0 THEN  
    DS_FetchElement(DS_TCP_TCBTD, sv_ptr, sv.int);       
END; {ssendabortind} 
             $SUBTITLE 'SSDisconnectCfm Routine', PAGE$   {--------------------------------------------------------------}    {                    SSDisconnectCfm                           }    {--------------------------------------------------------------}       
PROCEDURE SSDisconnectCfm; 
     {}  {   { Description:  {  Send graceful release confirmaationto ipc.   {}      BEGIN {ssdisconnectcfm}   {In our version of graceful release, there is no need to}   {handshake the graceful release. We always rely on the  }   {user to initiate a release when the user is done with  }   {the connection.                                        }       WITH rp_msg DO     BEGIN     ehport         := IPCINBOUNDIDX;      em_event       := GRACEFUL_CONFIRM;     emgc_up_ref    := tcp_port.p_up_refr;     END;       tcp_port.p_up_cnt := tcp_port.p_up_cnt + 1;           	{Save context...}  	 
IF sv_ptr <> 0 THEN  
 
   BEGIN {valid PCB} 
    DS_StoreFields(DS_TCP_TCBTD, sv_ptr, sv.startofdata,          DATAOFFSET, SVDATASIZE);      END;       IF port_ptr <> 0 THEN      BEGIN      DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata,         DATAOFFSET, PATHDATASIZE);     END;       {}  DS_LeaveCritical ( tcp_wkmap );   ProSw(rp_msg, tcp_ierr);  DS_EnterCritical ( tcp_wkmap, tcp_ierr );   {}          {Get context...}  IF port_ptr <> 0 THEN      DS_FetchElement(DS_tcp_pathtd, port_ptr, tcp_port.int);      
IF sv_ptr <> 0 THEN  
    DS_FetchElement(DS_TCP_TCBTD, sv_ptr, sv.int);       END;  {ssdisconnectCfm}           $SUBTITLE 'send confirmation', PAGE$  {----------------------------------------------------------}  {                 SSendConfirm                             }  {----------------------------------------------------------}      PROCEDURE SSendConfirm;       {}  { Description:  {  Send ipc the connection confirmation.  {}      
BEGIN {ssendconfirm} 
 WITH rp_msg DO     BEGIN     ehport         := IPCINBOUNDIDX;      em_event       := CONNECT_CONFIRM;      emcc_up_ref    := tcp_port.p_up_refr;     emcc_down_ref  := port_ptr;     END;       tcp_port.p_up_cnt := tcp_port.p_up_cnt + 1;           	{Save context...}  	 
IF sv_ptr <> 0 THEN  
 
   BEGIN {valid PCB} 
    DS_StoreFields(DS_TCP_TCBTD, sv_ptr, sv.startofdata,          DATAOFFSET, SVDATASIZE);      END;       IF port_ptr <> 0 THEN      BEGIN      DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata,         DATAOFFSET, PATHDATASIZE);     END;       {}  DS_LeaveCritical ( tcp_wkmap );   ProSw(rp_msg, tcp_ierr);  DS_EnterCritical ( tcp_wkmap, tcp_ierr );   {}      {Get context...}  IF port_ptr <> 0 THEN      DS_FetchElement(DS_tcp_pathtd, port_ptr, tcp_port.int);      
IF sv_ptr <> 0 THEN  
    DS_FetchElement(DS_TCP_TCBTD, sv_ptr, sv.int);       
END;  {ssendconfirm} 
             $SUBTITLE 'send Connect indication', PAGE$  {-----------------------------------------------------------}   {                      SSendConnInd                         }   {-----------------------------------------------------------}       PROCEDURE SSendConnInd;       {}  { Description:  {  This routine sends connect indication to IPC.  {   {  temp_path : has the path context block for the call port   {  port_ptr  : our path reference for ipc   {}      
BEGIN {ssendconnind} 
 {Get the call port path structure}  DS_FetchElement(DS_TCP_PathTD, c_port_ptr, temp_path.int);      WITH rp_msg,temp_path DO     BEGIN     ehport         := IPCINBOUNDIDX;      em_event       := CONNECT_INDICATION;     emci_call_ref  := p_up_refr;      emci_down_ref  := port_ptr;     emci_mbufid    := 0;      emci_options   := 0;           {We don't need to bump the message counter here anymore; we}        {say the indication is for a new path so the count has     }        {alreay been take into account in the new path record......}       END;           	{Save context...}  	 
IF sv_ptr <> 0 THEN  
 
   BEGIN {valid PCB} 
    DS_StoreFields(DS_TCP_TCBTD, sv_ptr, sv.startofdata,          DATAOFFSET, SVDATASIZE);      END;       IF port_ptr <> 0 THEN      BEGIN      DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata,         DATAOFFSET, PATHDATASIZE);     END;           {}  DS_LeaveCritical ( tcp_wkmap );   ProSw(rp_msg, tcp_ierr);  DS_EnterCritical ( tcp_wkmap, tcp_ierr );   {}      {Get context...}  IF port_ptr <> 0 THEN      DS_FetchElement(DS_tcp_pathtd, port_ptr, tcp_port.int);      
IF sv_ptr <> 0 THEN  
    DS_FetchElement(DS_TCP_TCBTD, sv_ptr, sv.int);       
END; {ssendconnind}  
             $SUBTITLE 'TCP port search routine', PAGE$  {------------------------------------------------------------}  {                       TCPSearch                            }  {------------------------------------------------------------}      
PROCEDURE TCPSearch  
    {    list_ptr   : Int16;       VAR search_key : ConnIdType;      VAR pointer    : Int16;       VAR pathrec    : TCPPathRecType};       {}  { Description:  {  The function returns an index (address) of the entry and   {  content of the entry if found, otherwise null is returned  {   { Parameters:   {  list_ptr    INPUT   List identifier.   
{  search_key  INPUT 
 {  pointer     OUTPUT  pointer to the path record.  {  tcp_port    OUTPUT  local copy of the located path record.   {   {}       VAR      match    : BOOLEAN;       temp_var : TCPPathRecType;      temp_ptr : Int16;       
 BEGIN { tcpsearch } 
  match:= false; {assume no match}        {Get the list sentinel}   DS_FetchElement(DS_tcp_pathtd, list_ptr, temp_var.int);       {IF the list is not empty then we will search the list}   IF temp_var.p_nxt_ptr <> list_ptr THEN       BEGIN {not empty}       temp_ptr := temp_var.p_nxt_ptr;       REPEAT { search }          WITH temp_var, search_key DO   
          BEGIN {compare}  
            {May eventually use the memory manager search routine}              {beacuse it will be faster...                        }   !          DS_FetchElement(DS_tcp_pathtd, temp_ptr, temp_var.int);  !           IF ((p_d_port = TCPWILDCARD) OR                (c_s_port = p_d_port)) AND                 (c_d_port = p_s_port) AND                  ((c_si_addr = p_di_addr) OR                  (p_di_addr = IPWILDCARD)) AND                    ((c_di_addr = p_si_addr) OR                    (p_si_addr = IPWILDCARD)) THEN  
             BEGIN {match} 
 
             match:= true; 
 
             END   {match} 
           ELSE  	             BEGIN 	              temp_ptr:= p_nxt_ptr;  	             END;  	           END; {compare}      UNTIL (match) OR (temp_ptr = list_ptr);       END;  {not empty}    IF match THEN      BEGIN       pointer:= temp_ptr;       pathrec := temp_var;      END    ELSE       BEGIN       pointer:= 0;      END;  
 END; { tcpsearch }  
         $SUBTITLE 'TCP outbound stub', page$  !{---------------------------------------------------------------}  ! !{                       TCPOUTSTUB                              }  ! !{---------------------------------------------------------------}  !     
PROCEDURE TCPOutStub 
    {VAR e_msg    : EventMessageType;      VAR result   : Int16           };       {}  { Description:  {  TCP outbound stub called by tcp inbound process; it  {  sends a signal to the TCP outbound process or tears  {  down a broken path.  {}      VAR      longtemp    : Int32;      rsp_flag    : OneOrBitType;          {-----------------------------------}   {         UserDelay                 }   {-----------------------------------}       
PROCEDURE UserDelay  
    (VAR e_msg :  EventMessageType);       {}  { Description:  {   Handle temporary accept connection response from  {   ipc, up_refr should be provided at this point. The  {   connection has not been fully open and it is timed  {   for IDLE seconds. If ipc does not accept the offer  {   in IDLE seconds the connection will discard.  {   { Parameters:   {   e_msg   INPUT  Event message from ipc.  {   
{  Global variables: 
 {     sv       : protocol control block (State Vector).   {     tcp_port : path record.   {     port_ptr : path pointer.  {}      	BEGIN {userdelay}  	 WITH e_msg DO      BEGIN {with}      SetContextOk(U_DELAY_ACCEPT, emctr_up_ref,         emctr_down_ref, tcp_error);      IF tcp_error = 0 THEN        BEGIN {found context}         {Time this offer and update both the PCB   }        {and the path record for this connection.  }        TcpSetTimer(KEEPTYPE, TCPTV_KEEP);      "      DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata,  "          DATAOFFSET, PATHDATASIZE);             DS_StoreFields(DS_TCP_TCBTD, sv_ptr, sv.startofdata,           DATAOFFSET, SVDATASIZE);         END   {found context}      ELSE         BEGIN         {Whatever the error, log it}        TCPLogError(tcp_error, TL_USDELAY);         END;     END;  {with}   	END;  {userdelay}  	             {----------------------------------------}  {    Main code of the outbound stub      }  {----------------------------------------}      BEGIN {outbound stub}       DS_EnterCritical(tcp_wkmap, tcp_ierr);      {Log the Event message if tracing is on}  Log_Event(EL_EVENT, TCP, 0, dummyrefr,               EMSG_WORD_LEN, e_msg.int, tcp_error);      {get and initialize all globals}  GetTCPGlobals;  sv_ptr    := 0;   port_ptr  := 0;   tcp_error := 0;       WITH e_msg DO      BEGIN {with e_msg}       
   CASE em_event OF  
           CONNECT_IGNORED:           BEGIN           SetContextOk(CONNECT_IGNORED, 0,               e_msg.emcig_down_ref, tcp_error);                {If context is OK then release all resources}           IF tcp_error = 0 THEN  	            BEGIN  	             DS_MDispose (sv.sv_template, tcp_error);                  {Cancel any active timers}              TcpCancelAllTimer( sv );                  {return connection control block}               FreeSVector;                  {Free the path record}              TCPClosePath(tcp_port, port_ptr);               END;           END;                 {This piece of code should never executed in the stub}            U_ACCEPT_CONNECT:            BEGIN {useraccept}            END;  {useraccept}           #      {This is the case where the call socket has been aborted but  }  # #      {we does not know it yet; so the ULP aborts our the connection}  # #      {we offered.                                                  }  #     
      ABORT_REQUEST: 
          BEGIN           SetContextOk(ABORT_REQUEST, 0,               e_msg.emareq_down_ref, tcp_error);  "         {Send a reset packet to the remote and drop the connection} "          IF tcp_error = 0 THEN  
            BEGIN {valid}  
             rsp_flag.w := TH_RST;   "            TCPRespond(null_ptr, port_ptr, null_ptr, sv.sv_rcv_nxt,  "                sv.sv_snd_una, rsp_flag);              TCPClose;   #            {We really don't care about the event message count here}  # #            {just shutdown the path and be done with.               }  #             TCPClosePath(tcp_port, port_ptr);   
            END   {valid}  
          ELSE   	            BEGIN  	             TCPLogError(tcp_error, TL_OUTSTBEVENT);               END;           END;                 ABORT_RESPONSE:            BEGIN {abort}           port_ptr := e_msg.emarep_down_ref;                DS_FetchElement(DS_TCP_PATHTD, port_ptr,   
            tcp_port.int); 
              IF tcp_port.p_port_type = UNDEFINEDTYPE THEN   	            BEGIN  	             TCPLogError(ABORTRACE, TL_OUTSTBEVENT);   
            port_ptr := 0; 
             END            ELSE   	            BEGIN  	             tcp_port.p_msg_cnt := tcp_port.p_msg_cnt + 1;   %            DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata,  %                DATAOFFSET, PATHDATASIZE);                   IF tcp_port.p_syn_bits[0] THEN  
               BEGIN 
                {Say we have touch the PCB}                 tcp_port.p_syn_bits[-1] := true;   	               END 	             ELSE  
               BEGIN 
                {outbound is not busy, close the path}                  TCPClosePath(tcp_port, port_ptr);  
               END;  
             END;           END;  {abort}            U_DELAY_ACCEPT:            BEGIN           {IPC decide that it has to wait for the user to come}           {and get the connection. Meanwhile we allow them to }           {wait for MAX_IDLE timeout value.                   }  
         UserDelay(e_msg); 
          END;       
      INTERNAL_MSG:  
          BEGIN {internal msg}   #         {An internal message is used by the inbound segment to tell}  # $         {the outbound stub to relate the message to the real outbound}  $ $         {segment. Using the internal message this way has the        }  $ $         {advantage of isolating the inbound from the awareness of the}  $ $         {presence of the stub.                                       }  $          CASE e_msg.emim_intdata[0] OF              SAT_BEAM :  
               BEGIN 
 $               {Well send a signal to our outbound peer via the user's}  $ $               {outbound socket.                                      }  $ #               DS_SatBeamSignal(e_msg.emim_intdata[1], OUTBOUND_SIG);  # 
               END;  
     	         OTHERWISE 	 	            BEGIN  	             {Definitely a problem; log the error and assume }               {everything is okidoki.                         }               tcp_error := SEVEREDSERROR;               TCPLogError(tcp_error, TL_OUTSTBEVENT);               END;           END; {end case internal msg}            END;  {internal msg}             OTHERWISE            BEGIN           {Unknown message; probably something has screwed up.}           {Sent a severe internal error message to logger.    }           tcp_error := UNKNOWNEVENT;            TCPLogError(tcp_error, TL_OUTSTBEVENT);           END;         END; {end case event type}         END;  {with e_msg}           {Need to update both PCB and PATH in DSAM table area}       IF port_ptr <> null_ptr THEN     BEGIN     {Say that the path has beeb touch by us.}     tcp_port.p_syn_bits[-1] := true;       DS_StoreFields(DS_TCP_PATHTD, Port_ptr, tcp_port.startofdata,         DATAOFFSET, PATHDATASIZE);     END;       
IF sv_ptr <> null_ptr THEN 
    BEGIN     DS_StoreFields(DS_TCP_TCBTD, sv_ptr, sv.startofdata,         DATAOFFSET, SVDATASIZE);     END;       DS_LeaveCritical(tcp_wkmap);      END;  {outbound stub}           {-----------------------------------------------------------}   {                  TCPINSTUB                                }   {-----------------------------------------------------------}       
PROCEDURE TCPInStub  
    {VAR e_msg    : EventMessageType;      VAR result   : Int16           };   {}  {  Description:   #{    The tcp inbound stub is used to handle error & status indications # {    from lower level protocol.   {}      VAR      temp_ptr  : Int16;       
BEGIN {inbound stub} 
     DS_EnterCritical(tcp_wkmap, tcp_ierr);          {Log the Event message if tracing is on}  Log_Event(EL_EVENT, TCP, 0, dummyrefr,               EMSG_WORD_LEN, e_msg.int, tcp_error);          	{get tcp globals}  	 tcp_error := 0;   GetTCPGlobals;      CASE e_msg.em_event OF      
   KILL_INDICATION:  
 	      BEGIN {kill} 	 #      {Go down the active connection list - the Dpath list; and mark}  # #      {the down path aborted bit and let the outbound routine do the}  # #      {actual abort processing.                                     }  #     #      DS_FetchElement(DS_TCP_PATHTD, d_path_list_head, temp_path.int); #       WITH temp_path DO            BEGIN {with temp_path}            WHILE p_nxt_ptr <> d_path_list_head DO   
            BEGIN {while}  
             temp_ptr := p_nxt_ptr;              DS_FetchElement(DS_TCP_PATHTD,                                temp_ptr, temp_path.int);               IF p_dn_refr = e_msg.emki_down_ref THEN   
               BEGIN {fi}  
                p_syn_bits[-1]  := true;                  p_syn_bits[-15] := true;   '               DS_StoreFields(DS_TCP_PATHTD, temp_ptr, temp_path.startofdata,  '                  DATAOFFSET, PATHDATASIZE);   
               END;  {fi}  
 
            END;  {while}  
          END;  {with temp_path}   	      END;  {kill} 	             STATUS_INDICATION:        BEGIN   !      {Ip tell us the optimal segment size; chase down the Dpath } ! !      {list and update the max_seg_size on all connection control} ! !      {blocks.                                                   } !           DS_FetchElement(DS_TCP_PATHTD, d_path_list_head,                           temp_path.int);        WITH temp_path, sv DO            BEGIN {with}            WHILE p_nxt_ptr <> d_path_list_head DO   
            BEGIN {while}  
             temp_ptr := p_nxt_ptr;              DS_FetchElement(DS_TCP_PATHTD,                                temp_ptr, temp_path.int);               IF p_dn_refr = e_msg.emsi_dn_ref THEN   
               BEGIN {fi}  
                {Could use a DS_StoreField () here instaed}                 DS_FetchElement(DS_TCP_TCBTD,                                  p_tcp_pcb, sv.int);       &               {Ignore the indication if the size is some ridiculous value}  &                IF e_msg.emsi_segsize > TCPHEADERSIZE THEN   
                  BEGIN {} 
 %                  {The segment size is what IP tells us minus our header}  % $                  sv_maxseg.word := e_msg.emsi_segsize - TCPHEADERSIZE;  $ %                  DS_StoreFields(DS_TCP_TCBTD, p_tcp_pcb, sv.startofdata,  %                                     DATAOFFSET, SVDATASIZE);                    p_syn_bits[-1]  := true;                    DS_StoreFields(DS_TCP_PATHTD, temp_ptr,   #                     temp_path.startofdata, DATAOFFSET, PATHDATASIZE); # 
                  END;  {} 
 
               END;  {fi}  
 
            END;  {while}  
          END;  {with}         END;         OTHERWISE       BEGIN       {Unkown event message type, log it}       TCPLogError(SEVEREDSERROR, TL_INSTBEVENT);        END;   	   END; {end case} 	     DS_LeaveCritical(tcp_wkmap);      
END;  {inbound stub} 
     END   .  