 $PASCAL '91790-1X218 REV.4010 <860401.1300>'$   $TITLE 'OutBound Handler 07/08/85'$   $STANDARD_LEVEL 'HP1000'  $debug$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	         MODULE tob;   $ALIAS 'N$TO'$      {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}      {}  {       NAME: TCPOUT.PAS                             }  {     SOURCE: 91790-18218                            }  {      RELOC: NONE                                   }  {       PGMR: MCL                                    }  {}      {}  { Modification History  { --------------------  {   !{ Feb 24th 1986: Fix looping problem between IPC and TCP when the  !  {     sb_dropcc is not reset to zero by TCPOUT. The fix is to do   "{     a SB_Space call when we enforcing the silly window avoidance.  " {   "{ Mar 07th 1986: Correct source part number; Allow IPC abort request " "{     to complete even if TCP encountered error on sending the RESET " 
{     packet. SR# 034777.  
 {   #{ Mar 17th 1986: Keepalive packet is not generated with correct packet # !{     SEQ number (snd_una - 1 is used). The correct SEQ should be  ! "{     snd_una for the connection. The problem can cause half-opened  " ${     connection to stay up as long as the remote node remain connected. $ {   ${ Apr 1st 1986: TCP reports BADREFERENCE error while the actual code is  $ #{     an ABORTRACE warning in the RcvReponse routine; correct code not # {     to mask the warning. SR# (no received yet).   {}      IMPORT     $SEARCH 'phtm/BODEC.REL'      bodec,      $SEARCH 'phtm/SODEC.REL'      sodec,      $SEARCH 'phtm/MMDEC.REL'      mmdec,      $SEARCH 'phtm/MMEXT.REL'      ds_mm,      $SEARCH 'phtm/trcmod.rel'     trcmod,     $SEARCH 'phtm/SIGMOD.REL'     sigmod,     $SEARCH 'phtm/TMRDEC.REL'     tmrdec,     $SEARCH 'phtm/TCPGB.REL'      tg,     $SEARCH 'phtm/TUSER.REL'      tuser,      $SEARCH 'phtm/TCPLB.REL'      tl;          $SUBTITLE 'Export Section', PAGE$       EXPORT      PROCEDURE TCPOutBound      (VAR e_msg  : EventMessageType;      VAR result : Int16            );          $SUBTITLE 'Implement', PAGE$      IMPLEMENT               {----------------------------------------------}  {              AdrOf                           }  {----------------------------------------------}      PROCEDURE AdrOf      (VAR bufr   : Int16;       VAR offset : Int16;   
    VAR addr   : Int16 );  
    EXTERNAL;          {----------------------------------------------}  {             ProSw                            }  {----------------------------------------------}      PROCEDURE ProSw      (VAR e_msg     : EventMessageType;       VAR result    : Int16             );     EXTERNAL;      {----------------------------------------------}  {             GetSystemTime                    }  {----------------------------------------------}      PROCEDURE GetSystemTime  $ALIAS 'D$TIM'$     (VAR sys_time  : Int32);      EXTERNAL;      {----------------------------------------------}  {                TCPOutput                     }  {----------------------------------------------}      
PROCEDURE TCPOutput  
     (VAR sv       : StateVectorType;  
     VAR sb_ptr   : Int16; 
 
     VAR port_ptr : Int16; 
      VAR user_err : int16           );      FORWARD;          {-------------------------------------------------}   {               SetPersist                        }   {-------------------------------------------------}   PROCEDURE SetPersist;   {   { Decription:   {    Start and restart persistance timer.   {   
{ Global Variables:  
 {    timer_value : time out value.  {    sv          : protocol control block.  {   {}      	BEGIN {setpersist} 	 WITH sv DO     BEGIN {with}      timer_value:= Round(tcpgbls.tcp_beta * sv_srt_time                       * EXP_VALUE[sv_retry_cnt]);      timer_value:= GetTimerValue(timer_value,                       TCPTV_PERSMIN, TCPTV_MAX);         {Set timer and increment the retry counter}     TcpSetTimer(PERSISTTYPE, timer_value);      sv_retry_cnt:= sv_retry_cnt + 1;      IF sv_retry_cnt >= TCPTV_MAXRXT THEN         BEGIN         sv_retry_cnt:= 0;         END;     END;  {with}   	END;  {setpersist} 	             $SUBTITLE 'Event Handling Routines', PAGE$  {-------------------------------------------------}   {             DisconnectReq                       }   {-------------------------------------------------}       PROCEDURE DisconnectReq      (VAR e_msg : EventMessageType);      {}  {   { Description:  {  Initiate disconnect; if we are in embryonic state, just   {  drop the connection. Otherwise, drop current unread data from   {  input queue,and switch states and send segment (FIN) to  {  peer.  {   { Parameters:   {  e_msg    INPUT   event message from ipc.   {   { Note: this routine relies on tcpoutput to update the pcb in   {       dssm !!   {}      VAR      rp_msg : EventMessageType;       BEGIN {disconnectreq}   	WITH e_msg ,sv DO  	    BEGIN {with e_msg}      SetContextOk(GRACEFUL_RELEASE_REQUEST, emgr_up_ref,        emgr_down_ref, tcp_error);     IF tcp_error = 0 THEN        BEGIN {context ok}            CASE sv_state OF               {If there is no pcb then setcontextok will}           {set sv to it's initial state for us...and}           {we had already sent the abort indication }           {there is no need to send another one.    }           CLOSED:  	            BEGIN  	             TCPClosePath(tcp_port, port_ptr);               END;               LISTEN,  	         SYN_SENT: 	             BEGIN {*}               sv_state:= CLOSED;              TCPClose;               TCPClosePath(tcp_port, port_ptr);                   {build and send graceful confirm msg}               rp_msg.ehport      := IPCINBOUNDIDX;              rp_msg.em_event    := GRACEFUL_CONFIRM;               rp_msg.emgc_up_ref := emgr_up_ref;              {}              DS_LeaveCritical ( tcp_wkmap );               {}              ProSw(rp_msg, tcp_ierr);              {}              DS_EnterCritical ( tcp_wkmap, tcp_ierr );               {}              END;  {*}                SYN_RECEIVED,           ESTABLISHED:               BEGIN {**}              sv_state:= FIN_WAIT_1;              END;  {**}      
         CLOSE_WAIT: 
             BEGIN {***}               sv_state:= LAST_ACK;              END;  {***}            END; {end case}      "      {we will let the user exit when our fin has been acked       } " "      {IF sv.state >= FIN_WAIT_2 THEN                              } " "      {   BEGIN                                                    } " "      {   SSDisconnectInd(sb_ptr);                                 } " "      {   END;                                                     } "     "      {Sent fin to peer if necessary; in our implementation, there } " "      {is no such time_wait or closed state recorded in the pcb.   } " "      {Whenever the connection enters the time_wait or closed state} " "      {both the pcb and path structures are discarded; only the    } " "      {tcp source port address is entered into the limbo list so   } " "      {that it will not be reused for at least 2 msl time interval.} "           IF sv_state <> CLOSED THEN           BEGIN           TCPOutput(sv, sb_ptr, port_ptr, tcp_error);           END;         END   {context ok}     ELSE         TCPLogError(BADREFERENCE, TOB_DISCONNECTREQ);      END;  {with e_msg}   END;  {disconnectreq}               {------------------------------------------}  {            OpenReq                       }  {------------------------------------------}      	PROCEDURE OpenReq  	    (VAR e_msg : EventMessageType);      {}  { Description:  {  Handles request to establish a call socket contact   {  ie, create a i_path record, for TCP.   {   { Parameters:   {  e_msg    INPUT  Event message from ipc.  {}      VAR      rp_msg   : EventMessageType;   
   ipathadr : Int16; 
         BEGIN {openreq}   WITH e_msg DO       
   BEGIN {with emsg} 
    {set up socket buffer ids}      sb_ptr  := emri_up_ref * 2;  
   sb_ptr2 := sb_ptr - 1;  
     	   ipathadr := 0;  	        {If user want to bind a well-known address to the port}     {we check if the address has already been entered.    }     IF emri_flags.bits[0] AND (emri_path_len <> 0) THEN        BEGIN {len <> 0}        WITH search_key DO           BEGIN           c_s_port  := emri_path_report;            c_d_port  := TCPWILDCARD;           c_si_addr := IPWILDCARD;            c_di_addr := IPWILDCARD;            END;       "      DS_LinkedFindAndFetchFields( DS_TCP_PathTD, i_path_list_head,  " #         i_path_list_head, 1, 3, 6, search_key.int, 0, SIZEOFTCPPATH,  #             temp_path.int, ipathadr, tcp_error);        END; {len <> 0}         {See if we already have an ipath; if we do tell user so}    {tcp_error should have a 1025 error if it's not there. }    IF (tcp_error = 0) AND (ipathadr <> 0) THEN   
     BEGIN {path existed}  
      {Build a reply to user request}       rp_msg.em_event      := IPATH_ABORTED;        rp_msg.emai_up_ref   := emri_root_ref;        rp_msg.emai_reason   := U_ADDR_INUSE;  
     END   {pat  existed}  
   ELSE       BEGIN {new path}   
     tcp_error := 0; 
          {Try to get a path and tcb structure}       GetResource(IPATHOPTION, sv_ptr,                     port_ptr, tcp_error);       
     IF tcp_error = 0 THEN 
         BEGIN {has resource}          {Get the blank i_path with linkages.}            DS_FetchElement(DS_tcp_pathtd, port_ptr, tcp_port.int);                {We has got all the necessary resource}           {Get a port address for him too.      }           IF emri_flags.bits[0] AND (emri_path_len <> 0) THEN              BEGIN             tcp_port.p_s_port := emri_path_report;              END          ELSE             BEGIN             AllocatePortAddr(tcp_port.p_s_port);              END;           DS_FetchElement(DS_tcp_TCBTD, sv_ptr, sv.int);              {initialize the path record.}           WITH tcp_port DO             BEGIN {build i_path}              p_port_type  := CALL_PORT;              p_root_pid   := emri_root_pid;              p_root_ref   := emri_root_ref;              p_up_pid     := emri_up_pid;              p_up_refr    := emri_up_ref;              p_s_flags    := emri_flags.int;             p_ref_cnt    := 0;              p_msg_cnt    := 1;              p_up_cnt     := 1;              p_d_port     := TCPWILDCARD;              p_si_addr    := IPWILDCARD;             p_di_addr    := IPWILDCARD;             p_tcp_pcb    := sv_ptr;             END;  {build i_path}               {Write the path record to DS table are }  #        DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata,  #                           DATAOFFSET, PATHDATASIZE);              {Build a reply to user request}           rp_msg.em_event      := CONFIRM_IPATH;          rp_msg.emcip_root_ref := emri_root_ref;           rp_msg.emcip_up_ref   := emri_up_ref;           rp_msg.emcip_down_ref := port_ptr;          END   {has resource}       ELSE           BEGIN {no resource}           {Build a reply to user request}           rp_msg.em_event      := IPATH_ABORTED;          rp_msg.emai_up_ref   := emri_root_ref;          rp_msg.emai_reason   := 131; {NOCONNRESRC;}           END;  {no resource}        END;  {new path}         {Return the reply to ipc.}    rp_msg.ehport := IPCINBOUNDIDX;         {}    DS_LeaveCritical ( tcp_wkmap );     {}  
  ProSw(rp_msg, tcp_ierr); 
   {}    DS_EnterCritical ( tcp_wkmap, tcp_ierr );     {}  
  END;  {with e_msg} 
 END;  {openreq}           {-------------------------------------------------}   {                   UserAccept                    }   {-------------------------------------------------}       
PROCEDURE UserAccept 
    (VAR e_msg : EventMessageType);  {}  {  Description:   {     Handle ipc's accept connection response.  {   {  Parameter:   {     e_msg   INPUT  Event mesage from ipc.   {   
{  Global variables: 
 {   sv       : protocol control block (State Vector).   {   tcp_port : path record.   {   port_ptr : path pointer.  {   tcp_error: global error   {}      VAR   
   longtemp : Int32; 
     	BEGIN {useraccept} 	 WITH e_msg, tcp_port, sv DO      BEGIN {with}      SetContextOk(U_ACCEPT_CONNECT, emcrs_up_ref,         emcrs_down_ref, tcp_error);      IF tcp_error = 0 THEN        BEGIN {ok}        {update the path record for this connection}  "      DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata,  "                         DATAOFFSET, PATHDATASIZE);           {Get an anchor block for reassembly purpose}         GetTCPHdr(sv_template, tcp_error);            IF tcp_error = 0 THEN            BEGIN           {Clear flag, cancel timer and send a segment to peer}           sv_rcv_max  := emcrs_max_window;            sv_av_wnd   := sv_rcv_max;            sv_rcv_wnd  := sv_av_wnd;           sv_t_flags.ipcwait:= false;               {TCP supports a max. of 7 outstanding sends only}           IF emcrs_max_snds > 7 THEN               sv_max_snds := 7           ELSE               sv_max_snds := emcrs_max_snds;               sv_t_flags.cksumopt := emcrs_options.bits[-1];                    IF emcrs_options.bits[0] THEN  	            BEGIN  	             sv_t_flags.msg_mode := true;              sv_max_rcvs         := sv_max_snds;               sv_frame_cnt        := sv_max_snds;               sv_rcv_frames       := sv_max_rcvs;               sv_max_msgsize      := sv_rcv_max DIV sv_max_rcvs;              sv_min_frames       := 1;               END;               {need to change for message mode}  !         longtemp      := (sv_rcv_max  * tcpgbls.wnd_ps) DIV 100;  !          sv_min_wnd    := longtemp;                TcpCancelTimer(KEEPTYPE, tmr_err);            TCPOutput(sv, sb_ptr, port_ptr, tcp_error);           END;         END;  {ok}     END;  {with}   	END;  {useraccept} 	         {-------------------------------------------------}   {             RcvResponse                         }   {-------------------------------------------------}           PROCEDURE RcvResponse      (VAR e_msg : EventMessageType);  {}  {  Description:   {     Handle inbound peer's signal for response.  {   {  Parameter:   {     e_msg   INPUT  Event mesage from ipc.   {   
{  Global variables: 
 {   sv       : protocol control block (State Vector).   {   tcp_port : path record.   {   port_ptr : path pointer.  {}      
BEGIN {rcvresponse}  
 WITH e_msg, tcp_port, sv DO      BEGIN {with}      IF e_msg.em_event = INTERNAL_MSG THEN        SetContextOk(INTERNAL_MSG, 0,            emim_intdata[0], tcp_error)     ELSE         SetContextOk(RCV_RESPONSE, 0,            emsb_down_ref, tcp_error);          IF tcp_error = 0 THEN        BEGIN {ok}        IF tcp_port.p_syn_bits[-13] THEN           BEGIN           {If we need to offer the connection then do it}           {But for now we do not have to do it this way }           END        ELSE           BEGIN           TCPOutput(sv, sb_ptr, port_ptr, tcp_error);           END;         END   {ok}     ELSE TCPLogError(tcp_error, TOB_RCVRESPONSE);     END;  {with}   
END;  {rcvresponse}  
         {---------------------------------------------------}   {                      UserDelay                    }   {---------------------------------------------------}       
PROCEDURE UserDelay  
    (VAR e_msg :  EventMessageType);       {}  { Description:  {   Handle temporary accept connection response from  {   ipc, up_refr should be provided at this point. The  {   connection has not been fully open and it is timed  {   for IDLE seconds. If ipc does not accept the offer  {   in IDLE seconds the connection will discard.  {    {  NOTE: This procedure should never be called in the outbound.    {        The actual code is commented out.  {   { Parameters:   {   e_msg   INPUT  Event message from ipc.  {   
{  Global variables: 
 {     sv       : protocol control block (State Vector).   {     tcp_port : path record.   {     port_ptr : path pointer.  {}      	BEGIN {userdelay}  	 {}  {WITH e_msg DO  {   BEGIN   {   SetContextOk(U_DELAY_ACCEPT, emctr_up_ref,  {      emctr_down_ref, tcp_error);  
{   IF tcp_error = 0 THEN  
 {      BEGIN  {      DS_StoreElement(DS_TCP_PathTD, port_ptr, tcp_port.int);  {      END;   {   END;  {}  	END;  {userdelay}  	         {--------------------------------------------------}  {                 ConnectReq                       }  {--------------------------------------------------}      
PROCEDURE ConnectReq 
    (VAR e_msg : EventMessageType);      {}  { Description:  {   Handle connect request from user; gets required resource,   {   sets up path and send a segment to remote. If any error   {   occur the path is destroyed and an internal error code  {   is logged.  {   { Parameters:   {  e_msg    INPUT   Event mesasge from ipc.   {   {   
{ Global variables:  
 {  sv       : protocol control block (State Vector).  
{  tcp_port : path record. 
 {  port_ptr : path pointer.   {}      CONST   
   DPATHOPTION = 0;  
     VAR      temp32    : Int32;       	BEGIN {connectreq} 	 	WITH e_msg, sv DO  	    BEGIN {with}      {Get the context structures}      SetContextOk(CONNECT_REQUEST, emcr_up_ref,         emcr_dst_ref, tcp_error);          IF tcp_error = 0 THEN        BEGIN {accept req}        {get a reserved buffer in dssm for re-assembly}         {and we charge the memory to the user's socket}         {For now, we charge it to the inbound sb.     }             GetTCPHdr(sv_template, tcp_error);            IF tcp_error = 0 THEN            BEGIN {got mem}           {We have what we need for the connection. }           {Initialize connection parameters         }           sv_state:= SYN_SENT;            sv_rcv_max  := emcr_max_window;           sv_av_wnd   := sv_rcv_max;            sv_rcv_wnd  := sv_av_wnd;               {TCP supports a max. of 7 outstanding sends only}           IF emcr_max_snds > 7 THEN              sv_max_snds := 7           ELSE               sv_max_snds := emcr_max_snds;                sv_t_flags.cksumopt := emcr_options.bits[-1];               IF emcr_options.bits[0] THEN   	            BEGIN  	             sv_t_flags.msg_mode := true;              sv_max_rcvs         := sv_max_snds;               sv_frame_cnt        := sv_max_snds;               sv_rcv_frames       := sv_max_rcvs;               sv_max_msgsize      := sv_rcv_max DIV sv_max_rcvs;                   {Minimum ack message is set to 1 or the value the }                 {user has specified.                              }    "            sv_min_frames := (sv_max_rcvs * tcpgbls.wnd_ps) DIV 100; "             IF sv_min_frames = 0 THEN                  sv_min_frames       := 1;              END;      !         {This is the acknowlege threshold for stream connection}  ! !         {currently the default is 25%.                         }  ! !         temp32        := (sv_rcv_max  * tcpgbls.wnd_ps) DIV 100;  !          sv_min_wnd    := temp32;                TcpSetTimer(KEEPTYPE, TCPTV_KEEP);            sv_iss:= 531000; {GetTCPseq;}  
         SendSeqInit(sv);  
          TCPOutput(sv, sb_ptr, port_ptr, tcp_error);               END  {got mem}         ELSE           BEGIN {no mem}            {Can't get mem user's credit is screwed up}           END;  {no mem}         END; {accept req}      END; {with}         {If there is an error; tear down the connection and }     {log the error.                                     }     IF (tcp_error <> 0) AND (port_ptr <> 0) THEN         BEGIN         TCPLogError(SEVEREDSERROR, TOB_CONNECTREQ);         TCPClose;         TCPClosePath(tcp_port, port_ptr);         END;  	END; {connectreq}  	             {-------------------------------------------------}   {                 UserRcvReq                      }   {-------------------------------------------------}       
PROCEDURE UserRcvReq 
    (VAR e_msg:  EventMessageType);  {}  { Description:  {  It is called when user receives data from us, and  {  the total amount received since last invocation is   {  greater than or equal to our write_threshold.  {   { Parameters:   {  e_msg   INPUT   Event message from ipc.  {   
{ Global variables:  
 {  sv       : protocol control block (State Vector).  
{  tcp_port : path record. 
 {  port_ptr : path pointer.   {}          	BEGIN {userrcvreq} 	 {call the output routine to send update if necessary}   WITH e_msg DO      BEGIN {with}      SetContextOk(U_RCV_REQUEST, null_ptr,        emwn_down_ref, tcp_error);     IF tcp_error = 0 THEN        BEGIN {ok}        {See if we have something to send to peer}        TCPOutput(sv, sb_ptr, port_ptr, tcp_error);         END   {ok}     ELSE        BEGIN       {We can get into a loop here because we do not}       {know what socket it is for and hence cannot  }       {disable the write select signal.             }           TCPLogError(tcp_error, TOB_USERRCVREQ);           IF tcp_error = CONNDROPPED THEN          BEGIN           SoWriteSelect(tcp_port.p_up_refr, -1, tcp_error);           END;       END;      END;  {with}   	END;  {userrcvreq} 	         {---------------------------------------------------}   {                   SendReq                         }   {---------------------------------------------------}       	PROCEDURE SendReq  	    (VAR e_msg : EventMessageType);  {}  { Description:  {  Handle user send request.  {   { Parameters:   {  e_msg     INPUT   Event message from IPC.  {   {   
{  Global variables: 
 {     sv       : protocol control block (State Vector).   {     tcp_port : path record.   {     port_ptr : path pointer.  {}      VAR      ipc_flags : IPCFlagsType;      BEGIN {sendreq}   	WITH e_msg ,sv DO  	    BEGIN {with}      SetContextOk(SEND_REQUEST, null_ptr,         emsr_down_ref, tcp_error);     IF tcp_error = 0 THEN        BEGIN {context ok}        ipc_flags.int := emsr_flags.int;            {This flag may not be of any use because we will}         {rely on memory manager to tell us whether we hit}        {a push mark or not.                             }            IF ipc_flags.bts[-15] THEN           BEGIN           sv_t_flags.push:= true;           END;             {Say the read select is not on anymore}         sv_t_flags.rselect := false;            {Try to send something...}        TCPOutput(sv, sb_ptr, port_ptr, tcp_error);             IF tcp_error <> 0 THEN           BEGIN           TCPLogError(tcp_error, TOB_SENDREQ);            END;         END   {context ok}     ELSE         {There is no way TCP can disable the read select}         {signal. May get into a infinite loop !!!       }         BEGIN         TCPLogError(SEVEREDSERROR, TOB_SENDREQ);        END;     END;  {with}   END;  {sendreq}           {--------------------------------------------------}  {                 AbortReq                         }  {--------------------------------------------------}      	PROCEDURE AbortReq 	    (VAR e_msg: EventMessageType);       {}  { Description:  {  Handle user abort request; reset connection which  {  has already entered synchronized state.  {   { Parameters:   {  e_msg     INPUT  Event message from ipc.   {   
{ Global variables:  
 {  sv       : protocol control block (State Vector).  
{  tcp_port : path record. 
 {  port_ptr : path pointer.   {}      LABEL      99;      BEGIN {abort}   WITH e_msg, sv, tcp_port DO      BEGIN     {Set up our context information}      SetContextOk(ABORT_REQUEST, null_ptr,        emareq_down_ref, tcp_error);         IF tcp_error = 0 THEN        BEGIN {context found}         {Subtract the ulp message count}        tcp_port.p_msg_cnt           := tcp_port.p_msg_cnt - emareq_msg_cnt;            IF sv_ptr = 0 THEN           BEGIN           {The connection has been dropped by the inbound and}            {abort indication has been sent. Here we just drop }            {the path and no need to send an abort confirm to  }            {IPC.                                              }                {Delete the path structure if msg_cnt matches}            IF tcp_port.p_msg_cnt = 0 THEN   	            BEGIN  	             {Now we can destroy the path}               TCPClosePath(tcp_port, port_ptr);               END;      	         GOTO 99;  	          END;             {Regardless, if we shutting down a VC connection }        {and the connction is in synchronized state we   }        {have to hit our peer on the head with RST packet}        {If a vc port is not synchronized, either it has }        {been reset or have never established, so just   }        {close the path...                               }            IF (sv_state > SYN_SENT)              AND (p_port_type = CIRCUIT_PORT) THEN            BEGIN {synchronized}            {Set state to CLOSED; send peer a segment with RST}           sv_state  := CLOSED;       "         {If the user had not accept the connect offer, there is no} " #         {socket to use for charging the RST packet to the our remote} # #         {peer. We have to use TCP's socket for that.               }  #          IF sv_t_flags.ipcwait THEN   	            BEGIN  	             sv_t_flags.ipcwait := false;              sb_ptr := tcpgbls.tcpsocket + tcpgbls.tcpsocket;              {TCP does not have a inbound socket so fake it}               sb_ptr2 := sb_ptr;              END;                {Call the ouput routine to send a RST packet to remote}            TCPOutput(sv, sb_ptr, port_ptr, tcp_error);               {delete all tcb asociated resources, ie, pcb, memory}           IF sv_ptr <> 0 THEN  	            BEGIN  	             TCPClose;               END;           END   {synchronized}         ELSE           BEGIN            {If the connection is not in a synchronized state yet}              {,return the PCB if it is a CALL port otherwise do a }              {TCPClose to return all resource.                    }             IF p_port_type = CALL_PORT THEN  	            BEGIN  	             FreeSVector;              END            ELSE   	            BEGIN  	             IF sv_ptr <> 0 THEN                  TCPClose;              END;           END;             {We have already release the PCB}         p_tcp_pcb := 0;             {Write the path back to DSAM}   "      DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata,  "                         DATAOFFSET, PATHDATASIZE);            {delete the path structure if msg_cnt matches}        IF tcp_port.p_msg_cnt = 0 THEN           BEGIN {match}               {Send abort confirmation to ipc}            WITH rp_msg DO   
            BEGIN {reply}  
             ehport      := IPCINBOUNDIDX;               em_event    := ABORT_CONFIRM;               emac_up_ref := tcp_port.p_up_refr;              emac_msg_cnt:= tcp_port.p_up_cnt + 1;   
            END;  {reply}  
                  {Now we can destroy the path}           TCPClosePath(tcp_port, port_ptr);               {}            DS_LeaveCritical ( tcp_wkmap );           ProSw(rp_msg, tcp_ierr);            DS_EnterCritical ( tcp_wkmap, tcp_ierr );           {}            END;  {match}        END   {context found}      ELSE         BEGIN         {If we ever get here we have a problem}         {May want to sent ulp something..god knows}         TCPLogError(tcp_error, TOB_ABORTREQ);         END;         99:;      END;  {with}   END;  {abort}               {-----------------------------------------------}   {               KillIndication                  }   {-----------------------------------------------}       PROCEDURE KillIndication     (VAR e_msg: EventMessageType);       {}  { Description:  {  Handle abort indication from below ie, ip may send   {  us an abort message from time to time. If we are busy,   {  defer the abort processing after we are done. If we  {  are not doing anything, scan the active dpath list   {  and mark all pcbs with same down path reference as   {  abort indication received.   {   { Parameters:   {   {   
{ Global variables:  
 {  sv       : protocol control block (State Vector).  
{  tcp_port : path record. 
 {  port_ptr : path pointer.   {}      BEGIN   {We will not do anything for the time being; we may   }   {send abort indication to all connections which are   }   {linked to the indicated down path reference.         }   END;              {--------------------------------------------------}  {                  TimerInd                        }  {--------------------------------------------------}      	PROCEDURE TimerInd 	    (VAR e_msg: EventMessageType);       {}  { Description:  {  Find out what kind of timer has expired; take appropriate  {  action based on the the state of the connection.   {  TCP uses 3 timers on each VC port (socket) and it also   {  uses timerable_1 at its 'root' socket for 2MLS timer.  {   {  The Keepalive timer is on most of the time and gets reset  {  when there is activity. The retransmit timer is turn on  {  when there is unacknowleged data. The pereist timer is   {  activated when we have data to send and the peer's window   {  is closed. The delay ack timer is used on inbound if a packet   "{  is received and the TCP is configured to delay the acknowlegement " !{  of the packet. Not all the timer are active at the same timer.  ! !{  Some of them are mutually exclusive. The 3 timer signals on the ! 
{  VC is used as follows:  
 {   {     Timerable_1 : Delayack only.  {     Timerable_2 : Keepalive only.   {     Timerable_3 : Retransmit or Persist.  {   !{  A (-1) in the emtr_down_ref field indicates the timer signal is ! %{  from TCP's own root socket and is treated differently from the others.  % #{  The timer signal from TCP's root socket has the following meanings: # {   [     Timerable_1 : 2MSL timer on the limbo list.   [     Timerable_2 : Undefined.  [     Timerable_3 : Undefined.  {   { Parameters:   {  e_msg    INPUT   Event Message from ipc.   {   
{     +------------------+ 
 
{     | ehport           | 
 
{     +------------------+ 
 
{     | em_event         | 
 
{     +------------------+ 
 
{     | emtr_down_ref    | 
 
{     +------------------+ 
 
{     | Timer Type       | 
 
{     +------------------+ 
 {   
{ Global variables:  
 {  sv       : protocol control block (State Vector).  
{  tcp_port : path record. 
 {  port_ptr : path pointer.   {}      LABEL      89;      VAR      i           : Int16;      timer_type  : Int16;      rsp_flags   : OneOrBitType;   {rsp_flags for tcp peer}       BEGIN {timerind}  	WITH e_msg, sv DO  	    BEGIN {with e_msg}   
   timer_type := 0;  
        {Check for special timer from the root socket.}     IF emtr_down_ref = -1 THEN         BEGIN         timer_type := MSLTYPE;        END      ELSE         BEGIN {regular}         SetContextOk(TIMER_INDICATION, null_ptr,           emtr_down_ref, tcp_error);             IF tcp_error = 0 THEN            BEGIN {good context}            {Need to nail down the exact timer type}            IF emtr_data[0] = TIMERABLE_1 THEN               timer_type := DELACKTYPE           ELSE               IF emtr_data[0] = TIMERABLE_2 THEN                 timer_type := KEEPTYPE               ELSE                 IF emtr_data[0] = TIMERABLE_3 THEN                     BEGIN                     IF sv_t_rexmt.index >= 0 THEN                        timer_type := REXMTTYPE                    ELSE                      timer_type := PERSISTTYPE;                    END;           END; {good context}        END;  {regular}              CASE timer_type OF             {delay ack timer expired}   	      DELACKTYPE:  	          BEGIN {delay}           WITH sv.sv_t_flags DO              BEGIN {htiw}  
            IF delack THEN 
 
               BEGIN 
                 {Don't do any check on this timer; if for some  }                   {reason the timer signal is blocked then we just}                   {processs it a bit late.                        }                  {sv.sv_t_delack.index := -1;}                 {sv.sv_t_delack.key   := -1;}                 TCPOutput(sv, sb_ptr, port_ptr, tcp_error);  
               END;  
             END;  {htiw}           END;  {delay}            {Retransmit timer}        REXMTTYPE:           BEGIN {retx}   #         {Message not acknowledged, back off to longer retransmit   }  # #         {interval and retransmit all message in the window; if the }  # #         {max. retransmit interval is exceeded, drop the connection.}  # 
         WITH sv DO  
             BEGIN {htiw}              IF tcp_port.p_syn_bits[-REXMTTYPE] THEN   
               BEGIN 
                {Timer has popped and we try to cancel it in}                 {in the inbound. In this case we just ignore}                 {this one...                                }                 timer_value := TCPTV_MIN;                  TCPResetTimer(timer_value, sv_t_rexmt, tmr_err);                   tcp_port.p_syn_bits[-REXMTTYPE] := FALSE;                 IF tmr_err = 0 THEN  
                  goto 89; 
 
               END;  
                 sv_t_rexmt.index := -1;               sv_t_rexmt.key   := -1;               sv_tcpstat.unack := sv_tcpstat.unack + 1;               sv_retry_cnt:= sv_retry_cnt + 1;                  IF sv_retry_cnt > TCPTV_MAXRXT THEN                  BEGIN {exceed retry}   "               {Do not drop the connection for now; just rerty and}  " "               {see why we can't send anymore...                  }  "                    IF tcpgbls.tcp_debug = 2 THEN                    BEGIN                     TCPLogError(sv_retry_cnt, TOB_RTXMTDBG);                    sv_retry_cnt := 1;                    timer_value := TCPTV_MIN;                     TCPSetTimer(REXMTTYPE, timer_value);                    TCPOutput(sv, sb_ptr, port_ptr, tcp_error);                     END   
               ELSE  
                   TCPConnDrop(tcp_port, port_ptr, TIMEOUT);                  END   {exceed retry}               ELSE                 BEGIN {retransmit}   !               timer_value:= GetTimerValue(sv_srt_time, TCPTV_MIN, !                                 TCPTV_MAX);                  IF expretxbackoff THEN                     BEGIN {exp}   $                  timer_value := Round(timer_value * tcpgbls.tcp_beta *  $ "                                          EXP_VALUE[sv_retry_cnt]);  "                   END   {exp}   	              ELSE 	                   BEGIN {mpy}   #                  timer_value:= Round(timer_value * tcpgbls.tcp_beta * #                                     BACKOFF_VALUE[sv_retry_cnt]);                     END;  {mpy}                     timer_value:= GetTimerValue(timer_value,                                 TCPTV_MIN, TCPTV_MAX);                      sv_snd_nxt:= sv_snd_una;                  TcpSetTimer(REXMTTYPE, timer_value);                  TCPOutput(sv, sb_ptr, port_ptr, tcp_error);                 END;  {retransmit}               END;  {htiw}           END;  {retx}             {persistant timer expired}  	      PERSISTTYPE: 	          BEGIN {persist}           IF tcp_port.p_syn_bits[-PERSISTTYPE] THEN  	            BEGIN  	             {Timer has popped and we try to cancel it in}               {in the inbound. In this case we just have  }               {to do it again                             }               timer_value := TCPTV_PERSMIN;               TCPResetTimer(timer_value, sv_t_persist, tmr_err);              tcp_port.p_syn_bits[-PERSISTTYPE] := FALSE;               END            ELSE   	            BEGIN  	             Setpersist;                   {Send a probe  packet using our path}               WITH sv DO  
               BEGIN 
                {save the path info...}  &               DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata, &                                 DATAOFFSET, PATHDATASIZE);                 rsp_flags.w := 0;                 TCPRespond(null_ptr, port_ptr, null_ptr,                     sv_rcv_nxt - 1, sv_snd_una - 1, rsp_flags);   
               END;  
             END;           END;  {persist}            {keep alive timer expired}        KEEPTYPE:            BEGIN {keep}   
         WITH sv DO  
             BEGIN {with sv}               IF tcp_port.p_syn_bits[-KEEPTYPE] THEN  
               BEGIN 
                {Timer has popped and we try to cancel it in}                 {in the inbound. In this case we just have  }                 {to do this one again                       }                 timer_value := TCPTV_KEEP;                  TCPResetTimer(timer_value, sv_t_keep, tmr_err);                 tcp_port.p_syn_bits[-KEEPTYPE] := FALSE;                  IF tmr_err = 0 THEN  
                  goto 89; 
 
               END;  
                 sv_t_keep.index := -1;              sv_t_keep.key   := -1;              IF sv_state < ESTABLISHED THEN                 BEGIN {drop it}                 IF sv_state <= LISTEN THEN                     BEGIN                     {Here we never offer the connection to ipc,}                    {and we abandon the half open connection   }                    {due to bad incoming call packet.          }                    DS_MDispose(sv_template, tcp_error);                    TcpCancelAllTimer(sv);                    FreeSVector;                    TCPClosePath(tcp_port, port_ptr);                     END   
               ELSE  
                   BEGIN   %                  {IF retry count exceeded, drop the connection resources} %                   IF sv_keep_cnt = TCPTV_MAXKEEP THEN   
                     BEGIN 
                      TCPConnDrop(tcp_port, port_ptr, TIMEOUT);                       END                    ELSE                       sv_keep_cnt := sv_keep_cnt + 1;                    END;                 END   {drop it}              ELSE                 BEGIN {check count}                 IF NOT sv_t_flags.nokeep THEN                    BEGIN {keep option}                     IF (sv_keep_cnt = TCPTV_MAXKEEP) THEN   
                     BEGIN 
                      TCPlogError(NOTALIVE, TOB_TIMERIND);                         TCPConnDrop(tcp_port, port_ptr, NOTALIVE);                         END                    ELSE  
                     BEGIN 
                      {sv_idle_cnt:= sv_idle_cnt + 1;}                        sv_keep_cnt:= sv_keep_cnt + 1;   !                     {use rcv_nxt-1 so that remote has to respond; ! !                     use snd_una-1 because we may not has a byte.} !                      rsp_flags.w:= 0;                            {Send a response packet using our path}                       {and reset the keepalive timer.       }                       TcpSetTimer(KEEPTYPE, TCPTV_KEEP);                            {save the path info...}                           DS_StoreFields(DS_TCP_PATHTD, port_ptr,  '                              tcp_port.startofdata, DATAOFFSET, PATHDATASIZE); '                      TCPRespond(null_ptr, port_ptr, null_ptr,   !                        sv_rcv_nxt - 1, sv_snd_una -1, rsp_flags); ! 
                     END;  
                   END;  {keep option}                  END;  {check count}              END;  {with sv}            END;  {keep}             {time wait timer expired}         MSLTYPE:  
         BEGIN {msl} 
 "         {All resources have been released, just clean up the list}  "           DS_FetchElement(DS_TCP_TCBTD, i_tcb_list_head, sv.int);            sv.msltimer.index := -1;            sv.msltimer.key   := -1;                For i := 0 TO LIMBOLSTSIZE - 1 DO               sv.limbolist[i] := 0;           limboptr := 0;            DS_StoreFields(DS_TCP_TCBTD, i_tcb_list_head,              sv.startofdata, DATAOFFSET, SVDATASIZE);  
         END;  {msl} 
     	      {Idle timer} 	       IDLETYPE:            BEGIN {idle}            {A idle count is used instead of a idle timer; if}            {one finds that using a dedicated timer is better}            {then we will make the change.                   }            END;  {idle}             OTHERWISE            BEGIN           {do nothing, unknown timer message}           {or bogus path reference...       }           TCPLogError(UNKNOWNEVENT, TOB_TIMERIND);            END;             89:;            END; {case timer_type}     END;  {with e_msg}   END;  {timerind}              "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                        TCPOutput                                }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE TCPOutput  
     {VAR sv       : StateVectorType;       VAR sb_ptr   : AddrType;   
     VAR port_ptr : Int16; 
      VAR tcp_error: int16           };      {}  {   { Description:  {   Figure out what should be sent and send it; It  !{   assume the user data is queued up in multiple mbuf chains with ! !{   each chain representing one or more user sends and a push flag ! !{   set. If there is only one chain or it is the last chain, then  ! {   the push flag may or may not be present.   {   The algorithm used here is adopted from Berkeley's implemem-   !{   tation. Out of band (urgent) data will be handled as in-line.  ! {   {   Option is supported but will not be used by OneNet at its   	{   first release. 	 {   {   sv and sb are local copies of the state vector and socket   {   buffer address of structure.  {   { Parameters:   !{   sv         INPUT  Protocol's connection control block (local). ! {   sb_ptr     INPUT  Socket reference (write sb).  {   port_ptr   INPUT  Pointer to path structure.  {   tcp_error  OUTPUT error return to caller  {   {}      LABEL      777;       VAR   !   fg:       OneOrBitType;   {tcp control flags                 }  ! !   done:     BOOLEAN;        {flag to exit the output routine   }  ! !   sendalot: BOOLEAN;        {flag to exit the send process     }  ! !   push:     BOOLEAN;        {push flag                         }  ! !   sendit:   BOOLEAN;        {send control variable             }  ! !   leftover: Int16;          {remainder of the msg in bytes     }  ! !   off:      Int16;          {data offset into mbuf chain       }  ! !   len:      Int16;          {TCP send length                   }  ! !   percent:  Int32;          {% of max. available window        }  ! !   window:   Int16;          {window size for peer              }  ! !   useful_wnd : Int16;       {Available space                   }  ! !   wsthreshold : Int16;      {Write Select threshold            }  ! !   data:     Int16;          {total size in send queue          }  ! "   send_ptr: Int16;          {address of the send buffer for xmit  } " "   mbuf:     AddrType;       {start of data buffer for testing only} " "   to_msg:   EventMessageType; {tcp outbound event message         } " "   tcpsk:    Int16;          {Special tcp outbound sbuf id.        } "             $SUBTITLE 'MsgWSCheck Routine', PAGE$   {--------------------------------------------}  {           MsgWSCheck                       }  {--------------------------------------------}      
PROCEDURE MsgWSCheck 
    (VAR sv         : StateVectorType;       VAR threshold  : Int16;       VAR av_wnd     : Int16;           dropcc     : Int16);  {}  ${ Description: The routine updates the receive message queue; calculate  $ "{    the available (new) window and determine the amount of data TCP " ${    should write select on the User's inbound socket. The write select  $ "{    threshold is some amount of data in bytes, if read by the user, " {    TCP would like the to know about as soon as possible.  {   { Parameters:   {   sv            Input  - Protocol control block.  {   threshold     Output - Write Select threshold   {   av_wnd        Output - Available space in message frames.   {   dropcc        Input  - number of bytes user has read  {   {}      VAR      data_in_q       : Int16;       BEGIN {msg mode}  WITH sv DO  	   BEGIN {with sv} 	    UpdateFmCnt(sv_rcv_qhead, sv_rcv_qtail,        sv_rcv_msg_ary, sv_rcv_frames, dropcc, data_in_q);          av_wnd := sv_rcv_frames - (sv_rcv_frm_adv - sv_rcv_frm_nxt);           {If window is wide open send a packet and set}      {write select threshold to the sv_min_wnd.   }      threshold := sv_min_wnd;          IF av_wnd <= sv_min_frames THEN        BEGIN         {If window is not wide open, set WS threshold}        {to sv_min_wnd if unacknowleged frame count  }        {is less than sv_min_frames. If unacknowledged}         {frames count is >= sv_min_frames we write   }        {select on the amount in the message queue   }        {calculated by UpdateFmCnt().                }        IF (sv_max_rcvs - sv_rcv_frames) >= sv_min_frames THEN           BEGIN           IF data_in_q > 0 THEN              threshold := data_in_q;            END;         END;  	   END; {with sv}  	 END;  {msg mode}              $SUBTITLE 'Rountine TCPSend', PAGE$   {---------------------------------------------}   {           TCPSend                           }   {---------------------------------------------}       	PROCEDURE TCPSend  	    (VAR tcp_error  : Int16);  {}  { Description:  {  This routine is called by TCPOutPut. Tasks performed are:  {   - get tcp header and initialize it  {   - fill in fields on the header and ckecksum data  {   - start necessary timer and send the data   {   - update various send variables   {   { Parameters:   {  tcp_error  OUTPUT   Error return to user.  {   
{ Global variables:  
 {   sv       : protocol control block (State Vector).   {   tcp_port : path record.   {   port_ptr : path pointer.  {   tcpgbls  : tcp global parameters.   {   {}      LABEL      99;      CONST   
   INITBUFF = IPTCPHdrType 
       [Hdr1: OvlyHdrType            [ih_prev : 0,              ih_next : 0,              ih_x1   : 0,              ih_pr   : TCP_PTCL,             ih_adj  : 0,              ih_len  : TCPHEADERSIZE,              ih_pad  : 0,              ih_src  : 0,              ih_dst  : 0],         Hdr2: TCPHdrType             [th_sport : 0,             th_dport : 0,             th_seq   : 0,             th_ack   : 0,             th_x2    : 0,             th_off   : 5,             th_flags : OneOrBitType [w : 0],              th_win   : 0,             th_sum   : 0,  
           th_urp   : 0]]; 
        TCP_OPTION_LEN = 4;      VAR      iptcpheader: IPTCPHdrType;     {buffer for tcp header}      mc         : Int16;            {number of free mbufs }      window     : Int16;            {receive window       }      opt_len    : Int16;            {tcp option length    }      error      : Int16;            {local error          }      cksumword  : Int16;            {checksum word        }      sys_time   : Int32;            {system time @ send   }      mmflg      : MMFlagsType;      {mm flags word        }           {---------------------------}   { Escape routine on error   }   {---------------------------}       PROCEDURE PsuedoSend;       BEGIN   {Update the path structure because we have already updated}   {some of the fields and we sure don't want to update the  }   {TCB which may have bogus info.                           }   DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata,                     DATAOFFSET, PATHDATASIZE);  Goto 99;  END;          BEGIN {tcpsend}      {initialize the header from the template for sends on this      connection.}          iptcpheader := INITBUFF;   
   opt_len     := 0; 
 
   mmflg.int   := 0; 
        WITH iptcpheader, tcp_port DO        BEGIN {create headers}        hdr1.ih_src  := p_si_addr;        hdr1.ih_dst  := p_di_addr;        hdr2.th_sport:= p_s_port;         hdr2.th_dport:= p_d_port;         END;  {create headers}         {Fill in fields, remembering max, advertised window}      {for use in delaying messages about window size.   }          WITH iptcpheader.hdr2, sv DO         BEGIN {with tcpheadr}   
      th_seq:= sv_snd_nxt; 
 
      th_ack:= sv_rcv_nxt; 
       IF sv_state < ESTABLISHED THEN           BEGIN {check options}           IF NOT sv_t_flags.noopt THEN               BEGIN {set options}               {These piece of code is here for completeness }               {and for testing purpose; normally we will not}               {carry tcp options.                           }               {opt_len:= TCP_OPTION_LEN;                    }               {iptcpheader.opt:= TCP_INITOPT;               }               {th_off := th_off + 1;                        }               END;  {set options}            END   {check options}        ELSE           BEGIN {other option}            {Other options may be tied to sb, pcb,or path.}           {For future, if there are options defined,    }           {send  append option buffer if there is one.  }           END;  {other option}             {Get control flags according to our state; Find out}        {available receiving space and number of cc read by}        {user.                                             }      
      th_flags.w := fg.w;  
       DS_SBSpace(sb_ptr2, sv_av_wnd, dataread, tcp_error);            IF tcp_error <> 0 THEN  
         PsuedoSend; 
           {If we are not in msg mode then there is no need}         {to use absolute window; just use the current   }         {available free space as the receive window.    }             {For now we only use the absolute window for both}        {stream and message mode; may change later...    }        sv_rcv_wnd := sv_rcv_wnd + dataread;            IF sv_t_flags.msg_mode THEN            BEGIN           {Calculate the window and the write select threshold}           {sv_rcv_wnd := sv_rcv_wnd + dataread;}            MsgWSCheck(sv, wsthreshold, useful_wnd, dataread);            END        ELSE           BEGIN  {stream mode}            {sv_rcv_wnd := sv_av_wnd;}            useful_wnd := sv_rcv_wnd - (sv_rcv_adv - sv_rcv_nxt);           IF useful_wnd >= sv_min_wnd THEN   	            BEGIN  	             wsthreshold := sv_min_wnd;              END            ELSE               wsthreshold := sv_min_wnd - useful_wnd;            END;  {stream node}            {Do a Write Select here}         SoWriteSelect(tcp_port.p_up_refr, wsthreshold, tcp_error);         window := sv_rcv_wnd;             {Avoid silly window if at least 25% space available.}         {If we are in message mode, don't shrink the window.}             IF NOT sv_t_flags.msg_mode THEN            IF window < (sv_rcv_max DIV 4) THEN              window := 0;            IF window > 0 THEN  
         th_win := window; 
           IF Seq_Gt(sv_snd_up, sv_snd_nxt) THEN   
         BEGIN {if urgent} 
          th_urp := sv_snd_up - sv_snd_nxt;           th_flags.w := th_flags.w + TH_URG;            END {if urgent}        ELSE            {No urgent data, pull the urgent ptr to the left edge}              {of the send window so that it doesn't drift into the}              {send window on sequence number wraparound.          }                 BEGIN {else}            sv_snd_up:= sv_snd_una;           END;  {else}       	      IF push THEN 	          BEGIN {push}            th_flags.b.push:= true;           END;  {push}                 {TCP header all filled in, set send_ptr to null}        send_ptr := null_ptr;             {If we have data to send, do a copy of the data and }         {append the tcp header to it. Negative sb means     }         {using the sub-queue 3 of the sbuf.                 }             IF len <> 0 THEN  
         BEGIN {copy data} 
          DS_MBCopy (-sb_ptr, off, len, send_ptr, tcp_error);               IF tcp_error <> 0 THEN   	            BEGIN  	             TCPLogError(tcp_error, TOB_TCPSEND1);               PsuedoSend;               END;  
         END   {copy data} 
       ELSE           BEGIN {append hdr}                 {Put the buffer address and the length in the vectored}             {data descriptor buffer.                              }            vdbuf[3] := IPHEADERSIZE;           AdrOf(iptcpheader.int, vdbuf[3], vdbuf[1]);           vdbuf[2] := TCPHEADERSIZE + opt_len;            mc       := vdbuf[2];           END;  {append hdr}              {Here we look at checksum optioning. The algorithm is:   }          {If the connection is not fully established (ie state <  }          {ESTABLISHED), always do checksum; otherwise if the state}          {is established or beyond then we will do checksum if the}          {connection is in 'checksum mode'. Checksum mode is      }          {indicated by the fact that sv.sv_t_flags.cksum = false. }          {The flag is set by the user or default to checksum mode.}          {If checksum option is on (ie, the flag is set to true)  }          {then the final value of the flag is determined when the }          {connection enters the established state.                }             cksumword := 0;             IF sv_t_flags.cksumopt OR (sv_state < ESTABLISHED) THEN            BEGIN {have to}           WITH iptcpheader.hdr1 DO   	            BEGIN  	             ih_len := ih_len + (opt_len + len);               GetChecksum(iptcpheader, opt_len,                              send_ptr, 0, len, cksumword);              END;               IF tcp_error = 0 THEN              BEGIN {ok}               {If cksum is zero and we are in non-checksum mode  }                {then make cksum be all ones. If the checksum is   }                {not zero and we are in non-checksum mode then just}                {use zero checksum value.                          }                   IF (NOT sv_t_flags.rmcksum) AND                     (NOT sv_t_flags.cksumopt) THEN                 BEGIN {no cksum}                  IF cksumword = 0 THEN                    BEGIN                     cksumword := -1                     END   
               ELSE  
                   BEGIN                     cksumword := 0;                     END;                 END;  {no cksum}               END   {ok}           ELSE   	            BEGIN  	 !            {MMGR does not like our call; dispose the mbuf chain}  ! !            {and panic.                                         }  !             TCPLogError(tcp_error, TOB_TCPSEND2);               DS_MDispose(send_ptr, error);               PsuedoSend;               END;           END;  {have to}            {Fix the checksum word before output the TCP header}  
      th_sum := cksumword; 
           IF len <> 0 THEN           BEGIN {do appn}           {Append our header and options to the data chain}           {For our first release, there will not be any   }           {options sent to remote peer. Option length is  }           {always zero. In the future, the iprcpheader.hdr2}            {should has space for tcp options...a few bytes.}               DS_MAppendHead(iptcpheader.int2[11], opt_len +               TCPHEADERSIZE, send_ptr, tcp_error);               END  {do appn}         ELSE  
         BEGIN {do sbput}  
          {Set MMGR flags: Borrow if needed,  overhead and use}           {reserved mbuf.                                     }           mmflg.bits[0]  := true;           mmflg.bits[-1] := false;            mmflg.bits[-2] := true;               {Charge the memory to the TCP's socket.}            tcpsk := tcpgbls.tcpsocket + tcpgbls.tcpsocket;  "         DS_SBPut(vdbuf, 4, tcpsk, mmflg, send_ptr, mc, tcp_error);  " 
         END;  {do sbput}  
           {Any error?, bail out}        IF tcp_error <> 0 THEN           BEGIN           TCPLogError(tcp_error, TOB_TCPSEND3);           DS_MDispose(send_ptr, error);  
         PsuedoSend; 
          END;           !      {Update send variables; time the transmission and arrange }  ! !      {for the retransmit. If in persist state, reset time for  }  ! !      {next persist.                                            }  !           IF sv_forced = 0 THEN            BEGIN {not persist}           IF fg.b.syn OR fg.b.fin THEN               BEGIN {syn or fin}              {Either flag occupies a seq. space}               sv_snd_nxt:= sv_snd_nxt + 1;              END;  {syn or fin}               {Update snd_nxt seqence number}           sv_snd_nxt:= sv_snd_nxt + len;       !         {Time this transmission if not a retransmission and not } ! !         {currently timing anything. Record our starting time and} ! !         {sequence number. Keep track of the total bytes sent.   } !          IF Seq_Gt(sv_snd_nxt, sv_snd_max)                 AND (sv_rt_time = 0) THEN              BEGIN {set time}              GetsystemTime(sys_time);              sv_rt_time:= sys_time;              sv_t_rtseq:= sv_snd_nxt - len;              END; {set time}                {Need to remember the highest send sequence number}           {and remember the frame size if we are in message }           {mode.                                            }               IF Seq_Gt(sv_snd_nxt, sv_snd_max) THEN   	            BEGIN  	             sv_snd_max:= sv_snd_nxt;                  IF sv_t_flags.msg_mode AND (len > 0) THEN   
               BEGIN 
 $               RecordFmSize(sv_snd_qhead, sv_snd_qtail, sv_snd_msg_ary,  $                               sv_frame_cnt, len, push);                  sv_old_wnd := sv_old_wnd - len;  
               END;  
             END;      $         {Set retransmit timer if not currently set.                  }  $ $         {Initial value for retransmit timer is equal to              }  $ $         {tcpgbls.tcp_beta * t_rtt. Initialize the retry_cnt which    }  $ $         {is used for backoff of retransmit time.                     }  $              IF (sv_t_rexmt.index < 0)                 AND (sv_snd_nxt <> sv_snd_una) THEN  
            BEGIN {remxt}  
 
            timer_value := 
 "               GetTimerValue(Round(tcpgbls.tcp_beta * sv_srt_time),  "                                 TCPTV_MIN, TCPTV_MAX);              sv_retry_cnt:= 1;               TcpSetTimer(REXMTTYPE, timer_value);              END  {remxt}           ELSE   	            BEGIN  	 $            {If there is data to send and we are in message mode, then}  $ $            {we should reset the timer.                               }  $ #            IF (sv_snd_nxt <> sv_snd_una) AND sv_t_flags.msg_mode THEN #             {timer_value :=   "               GetTimerValue(Round(tcpgbls.tcp_beta * sv_srt_time),  "                                 TCPTV_MIN, TCPTV_MAX);}               {sv_retry_cnt:= 1;              IF sv_t_rexmt.index >= 0 THEN                   TCPResetTimer(timer_value, sv_t_rexmt, tmr_err);}               END;               TcpCancelTimer(PERSISTTYPE, tmr_err);           IF sv_t_flags.delack THEN  	            BEGIN  	             TcpCancelTimer(DELACKTYPE, tmr_err);              END;  
         END {not persist} 
       ELSE           BEGIN {persist}           IF Seq_Gt(sv_snd_una + 1, sv_snd_max) THEN   	            BEGIN  	             sv_snd_max:= sv_snd_una + 1;              END;           END;  {persist}            {need to define parameters}   
      WITH rp_msg DO 
          BEGIN {setup e_msg}           ehport         := IPOUTBOUNDIDX;            em_event       := SEND_REQUEST;           emsr_down_ref  := tcp_port.p_dn_refr;           emsr_mbufid    := send_ptr;           emsr_dlen      := len + TCPHEADERSIZE + opt_len;            emsr_flags.int := TCPDEFAULTTOS;            emsr_killsnd_cnt := 0;            emsr_killrcv_cnt := 0;            END;  {setup e_msg}            {update the send count... for kill_request}         tcp_port.p_snd_cnt := tcp_port.p_snd_cnt + 1;       "      {Data sent as far as we can tell. If this advertise a larger}  " "      {window than any segment, then remember the size of the     }  " "      {advertised window.                                         }  "     
      IF (window > 0) AND  
           Seq_Gt(sv_rcv_nxt + window, sv_rcv_adv) THEN           BEGIN           sv_rcv_adv:= sv_rcv_nxt + window;           END;             IF sv_t_flags.msg_mode THEN            BEGIN           IF (sv_rcv_frames > 0) AND   $            Seq_Gt(sv_rcv_frm_nxt + sv_rcv_frames, sv_rcv_frm_adv) THEN  $ 	            BEGIN  	             sv_rcv_frm_adv := sv_rcv_frm_nxt + sv_rcv_frames;               END;           END;             {Reset the tcp acknowledgement control flags}         sv_t_flags.acknow:= false;        sv_t_flags.delack:= false;            {*}         {we need to update & save the path record}        tcp_port.p_syn_bits[0] := true;       "      DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata,  "                         DATAOFFSET, PATHDATASIZE);            {Save the connection control block too.. May have to}         {store the send variables only so that we will not  }         {screw up the receive vaiables.                     }             DS_StoreFields(DS_TCP_TCBTD, sv_ptr, sv.startofdata,                          DATAOFFSET, SVDATASIZE);            {}        DS_LeaveCritical ( tcp_wkmap );         {}        ProSw(rp_msg, tcp_ierr);        {}        DS_EnterCritical ( tcp_wkmap, tcp_ierr );         {}          END; {with tcpheadr}      99:;      END; {tcpsend}                      $SUBTITLE 'Main body of TCPOutput', PAGE$   !{----------------------------------------------------------------} ! !{                                                                } ! !{          Main Body Of TCPOutput                                } ! !{                                                                } ! !{----------------------------------------------------------------} !     BEGIN {start tcp_output}  
   done    := FALSE; 
    WITH sv DO             BEGIN {with sv}             REPEAT  {repeat}           {If sbuf is valid then find out the}            {total data bytes queued for send. }            DS_SBDataChar(sb_ptr, data, tcp_error);           sv_snd_cnt := data;               IF tcp_error <> 0 THEN   	            BEGIN  	             panic_num:= BADULPREFERENCE;              TCPLogError( panic_num , TOB_TCPOUTMAIN);               END;               leftover := 0;            sendalot := false;            push     := false;       "         {For our 1st release, we do not send pre-established data}  "          IF sv_state < ESTABLISHED THEN   	            BEGIN  	             off := data;              END            ELSE   	            BEGIN  	             off := sv_snd_nxt - sv_snd_una;               END;               window:= sv_snd_wnd;                IF data < window THEN  	            BEGIN  	             {use the whole thing}               len:= data - off;               END            ELSE   	            BEGIN  	             {use the send window}               len:= window - off;               END;               IF len < 0 THEN  
            BEGIN {PANIC}  
             len := 0;   
            END;  {PANIC}  
              IF len > sv_maxseg.word THEN               {use max tcp segment}               BEGIN {*}               sendalot := true;               len      := sv_maxseg.word;               END;  {*}                {We have to make sure that tcp does not send more}            {than one push worth of data on each individual  }            {send and try to send as many times as the window}            {permits.                                        }                IF (len > 0) AND sv_t_flags.msg_mode THEN              BEGIN {push check}              {In message mode and sending new data, check if }               {we have any frame available. If none clear push}               {flag and set len to zero.                      }                   IF Seq_GEq(sv_snd_nxt, sv_snd_max) THEN   
               BEGIN 
                IF sv_frame_cnt = 0 THEN                     BEGIN                     len      := 0;                    sendalot := false;                    END;  
               END;  
                 DS_CharsInMbuf(-sb_ptr, off, leftover, tcp_error);              IF leftover > 0 THEN                 BEGIN {check push & length}                 sendalot := false;                  IF len >= leftover THEN                    BEGIN {fi}                    push := true;                     IF len > leftover THEN  
                     BEGIN 
                      sendalot := true;                       len      := leftover;  
                     END;  
                   END   {fi}  
               ELSE  
                   BEGIN {no push}                     {We end up here because the window is too}                    {small to accommodate an entire message..}                    END;  {no push}                  END; {check push & length}               END; {push check}       "         {Get possible flags which are totally dictated by the    }  " "         {state of the connection. send if critical flags are set.}  "              fg.w:= OUTFLAGS[sv_state];            sendit:= false;               IF (sv_snd_nxt + len) < (sv_snd_una + data) THEN               BEGIN {clear flag}              {not finish yet, clear possible FIN flag}               fg.b.fin:= false;               END;  {clear flag}      !         {Check for syn, rst, fin or push flags and urgent data;}  ! !         {if any of these presents then need to send a segment. }  !              IF fg.b.rst OR push OR                  fg.b.fin OR fg.b.syn OR                    Seq_Gt(sv_snd_up, sv_snd_una) THEN  
            BEGIN {} 
 
            sendit:= true; 
 
            END   {} 
          ELSE               BEGIN {else}                   {Try to avoid silly window syndrom. If can send all}                {data, a segment's worth, at least 1/4 of window or}                {forced, then send the segment.                    }               IF (len > 0) THEN                  BEGIN {avoid sw}                  IF ((len = sv_maxseg.word)                      OR ((off + len) >= data))                      OR ((len * 4 >= sv_snd_wnd)                        OR (sv_forced <>0)) THEN                     BEGIN                     sendit:= true;                    END   
               ELSE  
                   BEGIN   $                  {Here we refraim from sending but need to recalculate} $ $                  {the write select threshold for the inbound data...  } $ #                  DS_SBSpace(sb_ptr2, sv_av_wnd, dataread, tcp_error); #                       IF tcp_error <> 0 THEN                       TCPLogError(tcp_error, TOB_TCPOUTMAIN1)                    ELSE                       sv_rcv_wnd := sv_rcv_wnd + dataread;                         IF sv_t_flags.msg_mode THEN                        BEGIN {msg mode}   $                     MsgWSCheck(sv, wsthreshold, useful_wnd, dataread);  $                      END  {msg mode}                    ELSE                       BEGIN  {stream}  "                     {Updata byte window and write select threshold} " &                      useful_wnd := sv_rcv_wnd - (sv_rcv_adv - sv_rcv_nxt);  &                       IF useful_wnd >= sv_min_wnd THEN                           BEGIN                           wsthreshold := sv_min_wnd;                            END  
                      ELSE 
                           wsthreshold := sv_min_wnd - useful_wnd;                         END;  {stream}                    {Here we do a write select.}  &                  SoWriteSelect(tcp_port.p_up_refr, wsthreshold, tcp_error); &                   END;                     END {avoid sw}               ELSE {Send if we owe peer an ACK}                  BEGIN {check ack}                 IF sv_t_flags.acknow THEN                    BEGIN {send it}                     sendit:= true;                    END   {send it}   
               ELSE  
 $                  {Calculate available window in input, and also amount} $ $                  {of window known to peer (as advertised window less  } $ $                  {next expected input.) If this is 35% or more of the } $ $                  {max possible window, then want to send to peer.     } $                       BEGIN {last check}      #                  DS_SBSpace(sb_ptr2, sv_av_wnd, dataread, tcp_error); #                       IF tcp_error <> 0 THEN                       TCPLogError(tcp_error, TOB_TCPOUTMAIN1)                    ELSE                       sv_rcv_wnd := sv_rcv_wnd + dataread;       %                  {For message mode stuff we use the absolute window and}  % %                  {figure the write select threshold based on message   }  % %                  {frames (equivalent number of chars).                 }  %                       IF sv_t_flags.msg_mode THEN                        BEGIN {msg mode}   $                     MsgWSCheck(sv, wsthreshold, useful_wnd, dataread);  $                          IF useful_wnd >= sv_min_frames THEN                          sendit := true;                        END  {msg mode}                    ELSE                       BEGIN  {stream}  "                     {Updata byte window and write select threshold} "                      {sv_rcv_wnd := sv_av_wnd;}   %                     useful_wnd := sv_rcv_wnd - (sv_rcv_adv - sv_rcv_nxt); %                      IF useful_wnd >= sv_min_wnd THEN                           BEGIN                           wsthreshold := sv_min_wnd;                          sendit      := true;                          END   
                     ELSE  
                          wsthreshold := sv_min_wnd - useful_wnd;                         END;  {stream}                         {Here we do a write select.}  &                  SoWriteSelect(tcp_port.p_up_refr, wsthreshold, tcp_error); &                   window := sv_rcv_wnd;       
                 {}  
                  {percent:=                     {   100 * (window - (sv_rcv_adv - sv_rcv_nxt))                     {      DIV sv_rcv_max;   	                 { 	                  {IF (sv_av_wnd > 0) AND (percent >= 35) THEN                    {   sendit:= true;   	                 { 	 
                 {}  
                   END; {last check}                  END; {check ack}               END; {else}                IF NOT sendit THEN                {If window closed and there is data to send, and  }                 {there is no retransmission timer or persist timer}                 {set, then go to persist state and arrange to poke}                 {the peer for window update. In the case of message}                {mode, out of frame is considered as closed window.}                   BEGIN {if not sendit}               IF sv_t_flags.msg_mode THEN   
               BEGIN 
                window := sv_frame_cnt;  	               END 	             ELSE  
               BEGIN 
                window := sv_snd_wnd;  
               END;  
                 IF (window = 0) AND (data > 0)                  AND (sv_t_rexmt.index < 0)                   AND (sv_t_persist.index < 0) THEN                 BEGIN {}                  sv_retry_cnt:= 1;  
               SetPersist; 
 
               END;  
             END {if not sendit}            ELSE               BEGIN {send it}               IF NOT sv_t_flags.ipcwait THEN  
               BEGIN 
                    out_path := port_ptr;                 TCPSend(tcp_error);                 port_ptr := out_path;                     IF tcp_error <> 0 THEN                     BEGIN                     sendalot := false;                    TCPLogError(SEVEREDSERROR, TOB_TCPOUTMAIN2);                    END;                     {Get out path record again to see if it has}                  {been touched when we are busy...          }                  {and clear these bits.                     }       #               DS_FetchElement(DS_TCP_PATHTD, port_ptr, tcp_port.int); #                WITH tcp_port DO                     BEGIN {with tcp_port}   #                  {See if the data structure has been touched by the}  # #                  {the inbound; if so see if the path is still ok.  }  #                       {Clear the busy flag}                     p_syn_bits[0]   := false;                     sv_ptr          := p_tcp_pcb;                         IF p_syn_bits[-1] THEN                       BEGIN {dirty}                       {Clear the dirty flag}                        p_syn_bits[-1]  := false;                           IF sv_ptr <> 0 THEN                          BEGIN {check path}  "                        {The inbound has not destroy the path yet,}  " "                        {but it may say the down path is no good. }  "                         IF p_syn_bits[-15] THEN                              BEGIN  !                           {Down path no good; ignore it for now}  !                            p_syn_bits[-15] := false;                             END;       $                        {inbound may have changed the connection state}  $ $                        {get the protocol control block.              }  $                         DS_FetchElement(DS_TCP_TCBTD,                                            p_tcp_pcb, sv.int);                          END  {check path}   
                     ELSE  
                         BEGIN                            {our connection has been dropped; just}                             {drop our path.                       }                            sendalot := false;                          TCPClosePath (tcp_port, port_ptr);                          tcp_error := PATHABORTED;                           END;                       END;  {dirty}                    END; {with tcp_port}  
               END;  
             END;  {send it}                     {If there's not a whole lot to send or we are in the }              {persistant state (peer's window closed), then we are}              {done.                                               }                  IF sendalot AND (sv_forced = 0) AND (sv_ptr <> 0) THEN                BEGIN {not done}  
            done:= false;  
             END   {not done}           ELSE               BEGIN {all done}              done:= true;              END;  {all done}  
      UNTIL done; {repeat} 
     !   {If state = ESTABLISHED, send window is open and rsleect is  }  ! !   {off then we want to re-enable read select. For the time     }  ! !   {being we set the read threshold to one byte. In the future  }  ! !   {the amount should be tied to our send policy which may be   }  ! !   {1/4 of the available send window ie, snd_wnd + snd_una -    }  ! !   {snd_nxt. The read select issued here also served the purpose}  ! !   {of reseting the newcc count (data tcp do not know about yet)}  ! !   {If the window has closed, the Setpersist has already disable}  ! !   {the read select and thus reset newcc.                       }  !        IF (sv_ptr <> 0) AND (sv_state = ESTABLISHED) THEN         BEGIN         IF sv_snd_wnd <> 0 THEN            BEGIN           sv_t_flags.rselect := true;           SoReadSelect(tcp_port.p_up_refr, 1, tcp_error);           END        ELSE           BEGIN           sv_t_flags.rselect := false;            SoReadSelect(tcp_port.p_up_refr, -1, tcp_error);            END;         END;      	   END; {with sv}  	     777:  END; {start tcp_output}           $SUBTITLE 'tcpoutbound routine', PAGE$  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                 TCPOutBound                                     }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE TCPOutBound      {VAR e_msg  : EventMessageType;      VAR result : Int16            };      {}  { Description:  {  This is the event handler for tcp; it identify the event   {  and call the event handling routine; it also set up the  {  appropriate environment for the handling routine.  {   { Parmaeters:   {  e_msg     INPUT  Event message from ipc.   {   
{ Global variables:  
 {  sv       : protocol control block (State Vector).  
{  tcp_port : path record. 
 {  port_ptr : path pointer.   {   { Note: we need a close_dpath msg for graceful release  {   {}      
BEGIN  {tcpoutbound} 
  {For open request, connect request and abort indication there  }    {is no specific context info which has to be established before}    {calling the event routines.                                   }       {}  DS_EnterCritical ( tcp_wkmap, tcp_ierr );   {}      {Log the Event message if tracing is on}  Log_Event(EL_EVENT, TCP, 0, dummyrefr,               EMSG_WORD_LEN, e_msg.int, tcp_error);      {Initialize global variables}   GetTCPGlobals;  tcp_error := 0;   sv_ptr    := 0;   port_ptr  := 0;   
tcp_port  := INITTCPPATH;  
 sv        := INITSTATEVECTOR;       CASE e_msg.em_event OF         OPEN_REQUEST:           {ie, request_ipath}        BEGIN         OpenReq(e_msg);         END;         CONNECT_REQUEST:        {ie, request_dpath}        BEGIN         ConnectReq(e_msg);        END;         SEND_REQUEST:           {ie, send_request}         BEGIN         SendReq(e_msg);         END;         U_RCV_REQUEST:          {ie, rvc_wnd_update}         BEGIN         UserRcvReq(e_msg);        END;         GRACEFUL_RELEASE_REQUEST: {ie, close_dpath}        BEGIN         DisconnectReq(e_msg);         END;      
   CONNECT_IGNORED:  
       BEGIN   {}  {     SetContextOk(CONNECT_IGNORED, 0,  {         e_msg.emcig_down_ref, tcp_error);   {      IF tcp_error = 0 THEN  
{         BEGIN {no error} 
 {         DS_MDispose (sv.sv_template, tcp_error);  {         TcpCancelAllTimer( sv );  {         FreeSVector;  {         TCPClosePath(tcp_port, port_ptr);}  {   {         TCPLogError(tcp_error, CONNECTIGN);   
{         END   {no error} 
 {      ELSE   {         BEGIN   {         TCPLogError(tcp_error, CONNECTIGN);   {         END;  {}         END;          U_ACCEPT_CONNECT:         {ie, accept_dpath}         BEGIN         UserAccept(e_msg);        END;         U_DELAY_ACCEPT:           {ie, delate_dpath}         BEGIN   
      {UserDelay(e_msg);}  
       END;         ABORT_REQUEST:            {ie, abort_dpath}        BEGIN         AbortReq(e_msg);        END;      	   ABORT_RESPONSE: 	       BEGIN         SetContextOk(ABORT_RESPONSE, 0,            e_msg.emarep_down_ref, tcp_error);         TCPClosePath(tcp_port, port_ptr);         END;         INTERNAL_MSG,      RCV_RESPONSE:   {ie, return_response_for_inbound - SAT_BEAM}          BEGIN   
      RcvResponse(e_msg);  
       END;         TIMER_INDICATION:         {ie, timer_response}         BEGIN         TimerInd(e_msg);        END;  OTHERWISE          BEGIN  
   {unknown message type}  
    TCPLogError(UNKNOWNEVENT, TOB_TCPOUTBOUND);     END;       
END; {case of e_msg} 
     {if PCB is still valid, update the copy in DSAM}  
IF sv_ptr <> 0 THEN  
    BEGIN     DS_StoreFields(DS_TCP_TCBTD, sv_ptr, sv.startofdata,         DATAOFFSET, SVDATASIZE);     END;       IF port_ptr <> 0 THEN      BEGIN      DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata,         DATAOFFSET, PATHDATASIZE);     END;       {}   DS_LeaveCritical ( tcp_wkmap );  {}  
END;  {tcpoutbound}  
     END {end of the module}   .  