 '{***************************************************************************}  ' $PASCAL '91751-1X047 REV.5010 <880708.1705>'  '{***************************************************************************}  ' '{                                                                           }  ' '{      FILE:   XINNG.PAS                                                    }  ' '{      SOURCE: 91751-18047                                                  }  ' '{      RELOC.: 91751-1X047                                                  }  ' '{                                                                           }  ' '{  ***************************************************************          }  ' '{  * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1982.  ALL RIGHTS     *          }  ' '{  * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,      *          }  ' '{  * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT*          }  ' '{  * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.       *          }  ' '{  ***************************************************************          }  ' '{                                                                           }  ' '{---------------------------------------------------------------------------}  ' '{                                                                           }  ' '{  Contains the following procedures and functions :                        }  ' '{                                                                           }  ' '{  - CARD_CONF   Configure the card and read back configuration data.       }  ' '{                called from step2_init.                                    }  ' '{                                                                           }  ' '{  - STEP1_INIT  Get network name, type and LAP-B LU's, network buffer opt. }  ' '{                                                                           }  ' '{  - STEP2_INIT  Get network line speed, level II parameters.               }  ' '{                                                                           }  ' '{  - STEP3_INIT  Get network local address, PVCs and SVCs numbers.          }  ' '{                                                                           }  ' '{  - STEP4_INIT  Get flow control and level III configuration information.  }  ' '{                                                                           }  ' '{  - STEP5_INIT  Get SVC global facility options.                           }  ' '{                                                                           }  ' '{---------------------------------------------------------------------------}  ' '{                                                                           }  ' '{ History :                                                                 }  ' '{   Original version                   Rev 2201                             }  ' '{   Revision #1                        Rev 2226                             }  ' '{    .Support of RTE-A1                                                     }  ' '{   Revision #2                        Rev 2326                             }  ' '{    .Support of RTE-A                                                      }  ' '{   Revision #3                        Rev 2401                             }  ' '{    .User accessible Q-bit data packet.                                    }  ' '{    .Flow control enhancement.                                             }  ' '{    .Add inactivity timer T3                                               }  ' '{   Revision #4                        Rev 2440                             }  ' '{    .new PASCAL support                                                    }  ' '{   Revision #5                        Rev 5.0    (BG)                      }  ' '{    .Change Austpacnet type from 17 to 6. (M2)                             }  ' '{    .Add Timer_T3 in NetworkHeaderEntry   (M13)                            }  ' '{    .Change variable zeroto5 to zeroto10. (M18)                            }  ' '{    .Add $private_types$ in Function card_conf,                            }  ' '{     for DEBUG to operate correctly.      (M19)                            }  ' '{    .Add a Modem Signals Timer.           (M20)                            }  ' '{    .Modified to correct the no abort error processing. (M25)              }  ' '{   Revision #6                        Rev 5.1    (BG)                      }  ' '{    .Correct adjustment of T1 timer in function of packet size only if     }  ' '{     specific timer value has not been requested.  (M59)                   }  ' '{    .Allow for output of calculated T1 when specified value is too small.  }  ' '{                                                                   (M60)   }  ' '{                                                                           }  ' '{***************************************************************************}  '     
$STANDARD_LEVEL 'HP1000'$  
 $SEGMENT$   $AUTOPAGE ON, HEAP 1, LINESIZE 80, RECURSIVE OFF$   $CDS OFF$   	$HEAP_DISPOSE OFF$ 	     PROGRAM XINNG (Answer_file);      { includes XTBLG.PASI, XTBLV.PASI, XINGB.PASI }   $LIST OFF$       { subdirectory must be provided in the installation procedure.}    $INCLUDE 'XTBLG.PASI'$  $INCLUDE 'XTBLV.PASI'$  $INCLUDE 'XINGB.PASI'$      $LIST ON$   $TITLE 'Network GLOBAL parameters'$   $SUBTITLE 'External procedures', PAGE$      '{ ...........  XINIT .....  EXTERNAL PROCEDURES ........................... }  '     {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       PROCEDURE MESS_WRITER ( msg_type : Xinit_msg_type ;                               msg  : Xinit_msg_list ;                               val  : twoWord  
                      ) ;  
 
                EXTERNAL ; 
     {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       PROCEDURE QUEST_ANSWER ( prmpt : Xinit_msg_list ;                           anschk : answer_check_list ;                       VAR answr : Reply_type   
                       ) ; 
 
                EXTERNAL ; 
     {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       FUNCTION LU_VERIFY  ( VAR eqtlunum ,                            eqtadd   : ONEWORD                      ) : BOOLEAN ;               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       FUNCTION NET_ADD_VERIFY          ( netadd : Net_add_entry_type  
       ) : BOOLEAN ; 
             EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       PROCEDURE FLOW_CNTRL_QS          ( VAR flqset     :  Flow_cntrl_Q_SET_type ;                  q1      :  prmpt_msg_list        ;                  a1      :  Answer_check_list     ;           VAR PTW_tab    :  PTWType               ;           VAR FAC_tab    :  Facilitiestype        ;           VAR Max_PKSize : ONEWORD              ) ;  
                EXTERNAL ; 
     {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       
PROCEDURE CU_MRC_ARC 
         ( VAR cmaset    :  Facil_opt_Q_SET_type  ;                  q1      :  prmpt_msg_list        ;                  a1      :  Answer_check_list     ;                  a2      :  Answer_check_list     ;            VAR Fac_tab   :  Facilitiestype        ;            VAR CUGnumber :  OCTET               ) ;  
                EXTERNAL ; 
     {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}   $PAGE$      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       FUNCTION CN35 ( lunumber : ONEWORD                ) : BOOLEAN ;               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       FUNCTION CN33 ( lunumber : ONEWORD ;                  config   : ONEWORD                ) : BOOLEAN ;               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       FUNCTION CN30 ( lunumber : ONEWORD ;                  lutype   : ONEWORD                ) : BOOLEAN ;               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       FUNCTION CN10 ( lunumber : ONEWORD ;                  timerval : ONEWORD                ) : BOOLEAN ;               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}   $PAGE$  {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       PROCEDURE CONT_ABORT         $DIRECT$     ( VAR err_path : poss_return_type ) ;               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       FUNCTION DIALOG : BOOLEAN ;  $DIRECT$   
                EXTERNAL ; 
     {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       PROCEDURE ENDLINE;           $DIRECT$               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       PROCEDURE Test_Line_count ;  $DIRECT$               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       
PROCEDURE exec_error 
  ( A_reg, B_reg, LuNumber : oneword ) ;    {M25 BG 17FEB87}                              EXTERNAL ;       {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       PROCEDURE XINHALT            $DIRECT$           ( msgind : XINIT_msg_list ) ;               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       FUNCTION Switch_parm (           Oneword_value : ONEWORD                       ) : ONEWORD ;              EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       $PAGE$      ${.................... RTE ... EXTERNAL PROCEDURE ......................} $     {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}      PROCEDURE ABREG ( VAR A_reg ,                         B_reg : ONEWORD  ) ;              EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}      "PROCEDURE WRITE_CARD_DATA $ALIAS 'XLUEX', NOABORT$  {M25 BG 17FEB87} "         ( Class_Write_code  :   ONEWORD     ;             Control_word      :   WORDARRAY2  ;             Card_conf_data    :   LAP_B_conf_parm_type    ;             Card_conf_data_len,             parm1, parm2      :   ONEWORD     ;         VAR Card_conf_class   :   ONEWORD     ) ;               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}      "PROCEDURE READ_CARD_DATA $ALIAS 'XLUEX', NOABORT$  {M25 BG 17FEB87}  "         ( Class_Read_code   :   ONEWORD     ;             Control_word      :   WORDARRAY2  ;         VAR Card_status_data  :   LAP_B_board_status_type ;             Card_status_len   ,             Parm1, Parm2      :   ONEWORD     ;             Card_conf_class   :   ONEWORD     ) ;               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}      PROCEDURE GET_CARD_DATA  $ALIAS 'EXEC'$           ( Class_get_code    ,             Card_conf_class   :   ONEWORD    ;        VAR Card_status_data  :   LAP_B_board_status_type ;             Card_status_len   ,             Parm1, Parm2      :   ONEWORD    ) ;              EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}      $SUBTITLE 'CONFIGURE LAP-B CARD', PAGE$   {+---------------------------------------------------------!}   {!                                                         !}   {!} FUNCTION CARD_CONF  : BOOLEAN ;                       {!}   {!                                                         !}   {!  Called from Step2_init                                 !}   {!                                                         !}   {!  Modified to correct no abort processing M25 BG 17FEB87 !}   {+---------------------------------------------------------+}       TYPE      nboftypeofstat = 1..4 ;           stat_type =  PACKED RECORD          CASE nboftypeofstat OF  #            1 : ( W : ONEWORD   )       ;  2 : ( O1, O2 : OCTET )    ; #     #            3 : ( S1,S2,S3,S4 : NIBLE ) ;  4 : ( N1,N2,N3,N4 : NIBLE ) #     END ;       devstat_type = PACKED RECORD          upperbyte : OCTET ;  b7,b6,b5,b4,b3,b2,b1,b0 : Boolean      END ;           Areg_Type = RECORD                    CASE boolean OF                       true  : ( W : ONEWORD ) ;                       false : ( S : devstat_type ) ;                    END ;           SwitchCode_type = 0..9 ;      BitRate_type = PACKED ARRAY [ 1..6 ] OF CHAR ;      BitRate_array_type = ARRAY [ SwitchCode_type ]                           OF BitRate_type ;      CONST           Write_code = 18 + no_abort_bit ;      Read_code  = 17 + no_abort_bit ;      No_wait_bit = no_abort_bit     ;      Get_code   = 21 ;   !    Card_conf_data_len  = - (  2 + ( XTBLCardParmLength * 2 ) ) ;  ! !    Card_status_len     = - ( 14 + ( XTBLCardParmLength * 2 ) ) ;  !     Write_conf_data_function_code   = 384 ;   { 600B }      Read_board_status_function_code = 384 ;   { 600B }          BitRate_array = BitRate_array_type           [ BitRate_type [ '  300 '] , BitRate_type [ ' 1200 '] ,               BitRate_type [ ' 2400 '] , BitRate_type [ ' 4800 '] ,               BitRate_type [ ' 9600 '] , BitRate_type [ ' 19.2K'] ,               BitRate_type [ ' 38.4K'] , BitRate_type [ ' 48.0K'] ,    !          BitRate_type [ ' 57.6K'] , BitRate_type [ '230.0K'] ] ;  !     VAR       Card_conf_data   : LAP_B_conf_parm_type ;       Card_status_data : LAP_B_board_status_type ;      control_word     : WORDARRAY2 ;       msgid            : err_msg_list ;   '    Card_conf_class, Opt1, Opt2, error, lunumber : ONEWORD ; {M25 BG 17FEB87}  '     stat : stat_type  ;       A_reg : Areg_Type  ;  $PAGE$  BEGIN         CARD_CONF := true ;   	  msgid := noerr ; 	       IF NOT ( prep IN Run_option ) THEN  #  WITH Xinit_gbl_entry, gbl_entry, curr_net_ptr^, Xinit_net, Cardparm, #       Card_conf_data, Card_parm  DO     BEGIN     {}  !  {} Opt1 := 0 ; Opt2 := 0 ; Card_conf_class := 0 + no_wait_bit ;  !   {} sec_code  := security_code ;     {}    {} control_word [ 2 ] := Write_conf_data_function_code ;    {} control_word [ 1 ] := CardWriteLUByte + Nonsession  ;    {}    {} card_parm.T := cardparm.T ; { get conf data }    {}    {} WRITE_CARD_DATA ( Write_code, control_word,    {}                   Card_conf_data, Card_conf_data_len,    {}                   Opt1, Opt2, Card_conf_class       ) ;    {}    {} begin  { no abort error processing }     {} {} ABREG ( A_reg.W , B_reg ) ;     {} {} LuNumber := CardWriteLuByte ;     {} {} exec_error ( A_reg.W , B_reg, LuNumber ) ;    {} {} msgid := WDfailed ;     {} end ;  { end of no abort error processing }    {}    {} ABREG ( A_reg.W, B_reg ) ;     {}    {} IF ( msgid = noerr )  THEN     {} BEGIN    {}  
  {}   IF ( A_reg.W = -1 ) 
   {}   THEN XINHALT ( NOCLavail )     {}   ELSE     {}     IF ( A_reg.W < - 1 ) THEN XINHALT ( OutofSAM ) ;     {}    {}   Card_conf_class := Card_conf_class - no_wait_bit ;     {}    {}   GET_CARD_DATA ( Get_code, Card_conf_class,     {}                   Card_status_data, Card_status_len,     {}                   Opt1, Opt2                       ) ;     {}    {}   ABREG ( A_reg.W, B_reg ) ;     {}   WITH A_reg.S DO IF b7 OR b1 THEN msgid := WDfailed ;     {}  $PAGE$    {} IF ( msgid = noerr )  THEN     {} BEGIN    {}    {}   Card_conf_class := 0 + no_wait_bit ;     {}   control_word [ 2 ] := Read_board_status_function_code ;    {}    {}   READ_CARD_DATA ( Read_code, control_word,    {}                    Card_status_data, Card_status_len,    {}                    Opt1, Opt2, Card_conf_class    ) ;    {}    {}   begin  { no abort error processing }     {}   {} ABREG ( A_reg.W , B_reg ) ;     {}   {} LuNumber := CardWriteLuByte ;     {}   {} exec_error ( A_reg.W , B_reg, LuNumber ) ;    {}   {} msgid := RDfailed ;     {}   end ;  { end of no abort error processing }    {}    {}   ABREG ( A_reg.W, B_reg ) ;     {}    {} IF ( msgid = noerr )  THEN     {} BEGIN    {}    {}   IF ( A_reg.W = - 1 )     {}   THEN XINHALT ( NOCLavail )     {}   ELSE IF ( A_reg.W < - 1 ) THEN XINHALT ( OutofSAM ) ;    {}    {}   Card_conf_class := Card_conf_class - no_wait_bit  ;    {}    {}   GET_CARD_DATA ( Get_code, Card_conf_class,     {}                   Card_status_data, Card_status_len,     {}                   Opt1, Opt2                       ) ;     {}    {}   ABREG ( A_reg.W, B_reg ) ;     {}   WITH A_reg.S DO IF b7 OR b1 THEN msgid := RDfailed ;   $PAGE$    {} IF ( msgid = noerr )  THEN     {} BEGIN    {}    {}   WITH Card_status_data, stat DO     {}   BEGIN    {}   {} W := Board_type ;     {}   {} MESS_WRITER ( part1msg, boardtype, 0 ) ;    {}   {} IF DIALOG THEN writeln ( Output_lu , O2 : 6 ) ;     {}   {}     {}   {} IF List IN Run_option THEN  "  {}   {} BEGIN Write ( List_file, O2 : 6 ) ; Test_line_count END ;  "   {}   {}   !  {}   {} IF ( O2 <> LAP_B_boardtype )  THEN  msgid := invboard ;  !   {}   {}     {}   {} IF ( msgid = noerr )  THEN    {}   {} BEGIN     {}   {}     {}   {}   W := Switch_parm ( Firm_rev_code ) ;    {}   {}     {}   {}   MESS_WRITER ( part1msg, firmcode, 0 ) ;     {}   {}   IF DIALOG      {}   {}   THEN writeln ( Output_lu, N1:4, N2:2, N3:2, N4:2 ) ;     {}   {}     {}   {}   IF List IN Run_option THEN  	  {}   {}   BEGIN  	   {}   {}       Write ( List_file, N1:4, N2:2, N3:2, N4:2 ) ;     {}   {}       Test_line_count   	  {}   {}   END ;  	   {}   {}     {}   {}   O2 := Switch_reg ;    {}   {}   MESS_WRITER ( part1msg, swsetting, 0 ) ;    {}   {}   IF DIALOG   $  {}   {}   THEN writeln ( Output_lu, BitRate_array [ S3 ], ' Baud' ) ;  $   {}   {}     {}   {}   IF List IN Run_option  THEN   	  {}   {}   BEGIN  	 "  {}   {}       Write ( List_file, BitRate_array [ S3 ], ' Baud' ) ; "   {}   {}       Test_line_count   	  {}   {}   END ;  	   {}   {}   Endline ; { skip a line }     {}   {}     {}   {} END ; { if msgid = noerr , invboard }     {}   {}     {}   END ; { WITH Card_status_data }    {}    {} END   { if msgid = noerr , WDfailed }    {} END   { if msgid = noerr , WDfailed }    {} END   { if msgid = noerr , RDfailed }    {} END   { if msgid = noerr , RDfailed }    {}    {} ELSE     {}   BEGIN    {}     MESS_WRITER ( ermsg, msgid, 0 ) ;    {}     CARD_CONF := false ;     {}   END ;    {}    END   { WITH current_net_ptr^}  
END ; { Card_conf }  
     $SUBTITLE 'STEP_1: Net type and lu'$  !PROCEDURE step1_init ;  { .......... global parameters ........ }  ! LABEL       100 ;       CONST   &    HPnetwork   =   0 ; { .... network types for LAP-B configuration .... }  &     Telenetnet  =   1 ;       Datapacnet  =   2 ;       Transpacnet =   3 ;       PSSnet      =   4 ;       Bellnet     =   5 ;       Datexpnet   =   6 ;       Tymnetnet   =   7 ;       Dcsnet      =   8 ;       Dn1net      =   9 ;       Uninetnet   =  10 ;       Telepacnet  =  11 ;       Retdnet     =  12 ;       Arpacnet    =  13 ;       Saponetnet  =  14 ;       Venuspnet   =  15 ;       Ddxnet      =  16 ;   $$skip_text on$                                          {M2 BG 24apr85}  $     Austpacnet  =  17 ;   $skip_text off$   $    Austpacnet  =   6 ;                                 {M2 BG 24apr85}  $     Norpaknet   =  18 ;       Edwpnet     =  19 ;       Bernetnet   =  20 ;       Publicnet   = 253 ;       Privatenet  = 254 ;  { 376B }       loopback    = 255 ;  { 377B }                           { ..... private network type ....... }  
    DTEtype     = false ;  
 
    DCEtype     = true  ;  
                             { DVM00 configuration word : 122220B }      CN33conf_word = -23408 ;                              { LAP_B port configuration }      Write_port = 0  ;       Read_port  = 1  ;       VAR   
    previous_free ,  
 
    dummy         ,  
     savelu_number : ONEWORD ;           net_space_allocated : BOOLEAN ;       #BEGIN     { step1... get network name, network type, LAP-B lu's and  } # #          { ........ network buffer option.......................... } #         Curr_step := step1 ;                              { output step header }      MESS_WRITER ( stepheader, Stp1hdr, 0 ) ;      #                        { no space allocated for network header yet }  #     net_space_allocated := false ;          WITH LU_EQT_table, Xinit_gbl_entry, gbl_entry, answr, val       DO      BEGIN   &    {}  mark ( net_marker ) ; { keep track of beginning of net definition }  &     {}      {}  next_free := LEtble_index ; { in case of restart }      {}       {}  previous_free := next_free ;  { set to next free entry }       {}                                { in LU_EQT_table }       {}  $PAGE$      {}  100 :   	    {}  {}  REPEAT 	     {}  {}  {}      {}  {}  {}  '    {}  {}  {}  {-----------------------------------------------------------}  ' #    {}  {}  {}                                  { Network name or /E } #     {}  {}  {}  QUEST_ANSWER ( q1_1, nettype, answr )  ;      {}  {}  {}  '    {}  {}  {}  {-----------------------------------------------------------}  '     {}  {}  {}      {}  {}  {}  CASE rep OF       {}  {}  {}      {}  {}  {}  again :       {}  {}  {}      {}  {}{}{}{}{}{}GOTO 100 ;      {}  {}  {}      {}  {}  {}  exit  :       {}  {}  {}      {}  {}  {}      IF NbofNetworks = 0 THEN  
    {}  {}  {}      BEGIN  
     {}  {}  {}          CONT_ABORT (local_rep) ;      {}  {}  {}          rep := local_rep ;      {}  {}  {}          MESS_WRITER ( ermsg, nonetdef, 0 )  
    {}  {}  {}      END ;  
     {}  {}  {}  
    {}  {}  {}  ranking :  
     {}  {}  {}  
    {}  {}  {}      BEGIN  
     {}  {}  {}          IF NOT net_space_allocated THEN       {}  {}  {}          BEGIN   { space allocation }      {}  {}  {}              new ( curr_net_ptr ) ;      {}  {}  {}      {}  {}  {}              WITH curr_net_ptr^,Xinit_net DO       {}  {}  {}              BEGIN       {}  {}  {}      {}  {}  {}          { set_up linked list of networks }      {}  {}  {}      {}  {}  {}              next_net_ptr := net_head_ptr ;      {}  {}  {}              net_head_ptr := curr_net_ptr ;      {}  {}  {}              eqt_head_ptr := NIL ;       {}  {}  {}  #    {}  {}  {}          { initialize XNET retry count and time out's } #     {}  {}  {}  !    {}  {}  {}              RestartRetryNb := STDRESTARTRETRYNB ;  !     {}  {}  {}              RestConfTO     := STDRESTCONFTO ;       {}  {}  {}              CallRetryNb    := STDCALLRETRYNB ;      {}  {}  {}              CallConfTO     := STDCALLCONFTO ;        {}  {}  {}              ClearRetryNb   := STDCLEARRETRYNB ;        {}  {}  {}              ClearConfTO    := STDCLEARCONFTO ;       {}  {}  {}              ResetRetryNb   := STDRESETRETRYNB ;        {}  {}  {}              ResetConfTO    := STDRESETCONFTO ;      {}  {}  {}      {}  {}  {}          { update XTBL total length }      {}  {}  {}  &    {}  {}  {}              Net_Totallength := XTBLNetworkHeaderEntryLength  &     {}  {}  {}  #    {}  {}  {}          END ; { network header table initialization }  #     {}  {}  {}      {}  {}  {}          net_space_allocated := true ;       {}  {}  {}      {}  {}  {}      END ; { space allocation }  $PAGE$      {}  {}  {}  "    {}  {}  {}      { set up network type for LAP-B configuration }  "      {}  {}  {}      WITH curr_net_ptr^, Xinit_net, CardParm  DO    
    {}  {}  {}      BEGIN  
     {}  {}  {}          CardP := DTEtype  ;       {}  {}  {}      {}  {}  {}          CASE rank [ 1 ] OF  
    {}  {}  {}          {} 
     {}  {}  {}          {}  0 :       {}  {}  {}          {}      NetworkType := HPnetwork   ;      {}  {}  {}          {}  1 :       {}  {}  {}          {}      NetworkType := transpacnet ;      {}  {}  {}          {}  2 :       {}  {}  {}          {}      NetworkType := telenetnet  ;      {}  {}  {}          {}  3 :       {}  {}  {}          {}      NetworkType := datapacnet  ;      {}  {}  {}          {}  4 :       {}  {}  {}          {}      NetworkType := PSSnet      ;      {}  {}  {}          {}  5 :       {}  {}  {}          {}      NetworkType := Bellnet     ;  &    {}  {}  {}          {}  6 :                              {M2 BG 25apr85} & '    {}  {}  {}          {}      NetworkType := Datexpnet   ; { now also for }  ' '    {}  {}  {}          {}  7 :                              { Austpacnet   }  '     {}  {}  {}          {}      NetworkType := Tymnetnet   ;      {}  {}  {}          {}  8 :       {}  {}  {}          {}      NetworkType := Dcsnet      ;      {}  {}  {}          {}  9 :       {}  {}  {}          {}      NetworkType := Dn1net      ;      {}  {}  {}          {} 10 :       {}  {}  {}          {}      NetworkType := Uninetnet   ;      {}  {}  {}          {} 11 :       {}  {}  {}          {}      NetworkType := Telepacnet  ;      {}  {}  {}          {} 12 :       {}  {}  {}          {}      NetworkType := Retdnet     ;      {}  {}  {}          {} 13 :       {}  {}  {}          {}      NetworkType := Arpacnet    ;      {}  {}  {}          {} 14 :       {}  {}  {}          {}      NetworkType := Saponetnet  ;      {}  {}  {}          {} 15 :       {}  {}  {}          {}      NetworkType := Venuspnet   ;      {}  {}  {}          {} 16 :       {}  {}  {}          {}      NetworkType := DDXnet      ;  &    $skip_text on$                                           {M2 BG 25apr85} &     {}  {}  {}          {} 17 :       {}  {}  {}          {}      NetworkType := Austpacnet  ;  
    $skip_text off$  
     {}  {}  {}          {} 18 :       {}  {}  {}          {}      NetworkType := Norpaknet   ;      {}  {}  {}          {} 19 :       {}  {}  {}          {}      NetworkType := Edwpnet     ;      {}  {}  {}          {} 20 :       {}  {}  {}          {}      NetworkType := Bernetnet   ;      {}  {}  {}          {} 21 :       {}  {}  {}          {}      NetworkType := Publicnet   ;      {}  {}  {}          {} 22 :       {}  {}  {}          {}      NetworkType := privatenet  ;  
    {}  {}  {}          {} 
     {}  {}  {}          {} 23 :       {}  {}  {}          {}      NetworkType := loopback ;   
    {}  {}  {}          {} 
 %    {}  {}  {}          OTHERWISE                          {M2 BG25apr85}  % 
    {}  {}  {}          {} 
 %    {}  {}  {}          {}      NetworkType := HPnetwork ; {M2 BG25apr85}  % 
    {}  {}  {}          {} 
     {}  {}  {}          END ; { network type CASE }       {}  {}  {}      END ; { WITH curr_net_ptr^ }      {}  {}  {}      END ; { ranking option }      {}  {}  {}  END ; { return option CASE }      {}  {}  UNTIL rep <> none ;       {}  {}      {}  {}  IF rep = abort       { set by CONT_ABORT }      {}  {}  THEN      {}  {}      XINHALT ( noerr) ; { stop everything }  $PAGE$      {}  {}  IF ( rep <> exit ) THEN       {}  {}  WITH curr_net_ptr^, Xinit_net, CardParm  DO   	    {}  {}  BEGIN  	     {}  {}  {}  IF ( NetworkType = HPnetwork )      {}  {}  {}      OR      {}  {}  {}         ( NetworkType = privatenet )   
    {}  {}  {}          OR 
     {}  {}  {}             ( NetworkType = Loopback ) THEN      {}  {}  {}  BEGIN   	    {}  {}  {}  {} 	 #    {}  {}  {}  {}  {------------------------------------------------} # #    {}  {}  {}  {}                       { DTE /DCE private net type } #     {}  {}  {}  {}  QUEST_ANSWER ( q1_2, dtedce, answr ) ;  	    {}  {}  {}  {} 	 #    {}  {}  {}  {}  {------------------------------------------------} # 	    {}  {}  {}  {} 	     {}  {}{}{}{}{}{}IF rep = again  THEN GOTO 100 ;   	    {}  {}  {}  {} 	     {}  {}  {}  {}  IF rank [ 1 ] = 0       {}  {}  {}  {}  THEN      {}  {}  {}  {}      CardP := DCEtype      {}  {}  {}  {}  ELSE      {}  {}  {}  {}      CardP := DTEtype      {}  {}  {}  END ;       {}  {}  {}  $PAGE$      {}  {}  {}  REPEAT      {}  {}  {}  '    {}  {}  {}  next_free := previous_free ; { reset pointer in LU_EQT_TABLE } '     {}  {}  {}  '    {}  {}  {}  {-----------------------------------------------------------}  ' $    {}  {}  {}                              { LAP-B read & write LU's }  $     {}  {}  {}  QUEST_ANSWER ( q1_3, lutype, answr ) ;      {}  {}  {}  '    {}  {}  {}  {-----------------------------------------------------------}  '     {}  {}  {}      {}  {}{}{}{}IF rep = again THEN GOTO 100 ;      {}  {}  {}  &    {}  {}  {}  CardWriteLUbyte := num [ 1 ] ; { set LAP_B Write LU number } &     {}  {}  {}      {}  {}  {}  num [ 2 ] := num [ 1 ] + 1 ;  { lu & lu + 1 }       {}  {}  {}      {}  {}  {}  IF NOT ( LU_VERIFY ( num [ 1 ], dummy )       {}  {}  {}          AND       {}  {}  {}             LU_VERIFY ( num [ 2 ], dummy ) )   
    {}  {}  {}  THEN 
     {}  {}  {}     begin      {}  {}  {}       CONT_ABORT (local_rep) ;       {}  {}  {}       rep := local_rep ;       {}  {}  {}     end  
    {}  {}  {}  ELSE 
     {}  {}  {}    IF NOT ( prep IN Run_option )       {}  {}  {}    THEN      {}  {}  {}      { eqt number are not contiguous }       {}  {}  {}      IF  NOT ( num [ 2 ] = num [ 1 ] + 1 ) THEN  
    {}  {}  {}      BEGIN  
     {}  {}  {}          CONT_ABORT (local_rep) ;      {}  {}  {}          rep := local_rep ;      {}  {}  {}          MESS_WRITER ( ermsg, eqtnotcont, 0 )      {}  {}  {}      END ELSE      {}  {}  {}        IF NOT ( CN33 ( CardWriteLUbyte,  $    {}  {}  {}                        DDX60_entry_num + CN33conf_word )  $     {}  {}  {}                   AND       {}  {}  {}                      CN33 ( CardWriteLUbyte + 1,    &    {}  {}  {}                          DDX60_entry_num + CN33conf_word ) )  & 
    {}  {}  {}        THEN 
     {}  {}  {}          begin       {}  {}  {}            CONT_ABORT (local_rep) ;      {}  {}  {}            rep := local_rep ;      {}  {}  {}          end   
    {}  {}  {}        ELSE 
     {}  {}  {}          IF NOT ( CN35 ( CardWriteLUbyte ) )       {}  {}  {}          THEN      {}  {}  {}             begin      {}  {}  {}               CONT_ABORT (local_rep) ;       {}  {}  {}               rep := local_rep ;       {}  {}  {}             end      {}  {}  {}          ELSE  $    {}  {}  {}            IF NOT ( CN30 ( CardwriteLUbyte, Write_port )  $     {}  {}  {}                   AND  '    {}  {}  {}                       CN30 ( CardwriteLUbyte + 1, Read_port ) ) '     {}  {}  {}                  THEN      {}  {}  {}                    begin       {}  {}  {}                      CONT_ABORT (local_rep) ;      {}  {}  {}                      rep := local_rep ;      {}  {}  {}                    end;      {}  {}  {}  UNTIL rep <> none ;       {}  {}  {}      {}  {}  {}  IF rep = abort THEN  XINHALT ( noerr ) ;  $PAGE$      {}  {}  {}  '    {}  {}  {}  {-----------------------------------------------------------}  '     {}  {}  {}  %    {}  {}  {}                                  { NETWORK BUFFER (Y/N) ? } %     {}  {}  {}  QUEST_ANSWER ( q1_4, yesno, answr ) ;       {}  {}  {}  '    {}  {}  {}  {-----------------------------------------------------------}  '     {}  {}  {}      {}  {}  {}  CASE rep OF       {}  {}  {}      {}  {}  {}      again   :       {}  {}  {}      {}  {}{}{}{}{}{}{}{}GOTO 100 ;      {}      {}      {}      {}      yes     :       {}      {}      {}      {}          Net_buff_size := Dflt_netbuff_size ;      {}      {}      {}      {}      no      :       {}      {}  '    {}      {}          Net_buff_size := 0   ;  { no network buffer required } '     {}      {}      {}      {}   END ;  { net BUFF CASE }       {}      END; { WITH curr_net_ptr^ }       END;  $SUBTITLE 'STEP 2: Level II parms'$   END ;  { stpe1_init }       !PROCEDURE step2_init ;  { .......... global parameters ........ }  ! LABEL       100 ;       VAR       timer_T3   ,  
    dfltvalue  : ONEWORD ; 
    $skip_text on$ { moved to XINGB as global variable }       Dble_T1    : INTEGER ;             {M60 BG 08JUL88}   	   $skip_text off$ 	         !BEGIN  { step2 .. get network line speed, LEVEL II parameters : }  ! !       {          TIMER T1, RETRY N2, ACK COUNT K   ........... }  !         Curr_step := step2 ;                              { output step header }      MESS_WRITER ( stepheader, Stp2hdr, 0 ) ;          WITH answr, val, Xinit_gbl_entry, gbl_entry,           curr_net_ptr^, Xinit_net, CardParm DO      BEGIN       {}      {}      {}  100 :       {}  {}      {}  {}      {}  {}  %    {}  {}  {-----------------------------------------------------------}  % !    {}  {}                                  { network line speed } !     {}  {}  QUEST_ANSWER ( q2_1, linespeed, answr ) ;       {}  {}  %    {}  {}  {-----------------------------------------------------------}  %     {}  {}      {}  {}  CASE rep OF       {}  {}      {}  {}      again :       {}  {}      {}  {}{}{}{}{}{}GOTO 100 ;      {}  {}  
    {}  {}      ranking :  
     {}  {}  
    {}  {}          BEGIN  
     {}  {}          {}  max_thruput_class := rank [ 1 ] + 3 ;       {}  {}          {}  '    {}  {}          {}          { line speed is divided by 25 to save space }  ' "    {}  {}          {}          { we use twice the time to be safe } " $    {}  {}          {}          { we convert to 10 ms RTE timer units }  $     {}  {}          {}      {}  {}          {}  Line_speed := num [ 1 ] * 25 ;      {}  {}          {}  %    {}  {}          {}  Real_T1 := ( ( Dflt_T1_multiplier / Line_speed ) ) %     {}  {}          {}              * 2 * 100  ;      {}  {}          {}      {}  {}          {}  Int_T1 := round ( Real_T1 ) ;       {}  {}          {}  !    {}  {}          {}  Dble_T1 := Int_T1 * 10      ; { in msec }  !     {}  {}          {}  "    {}  {}          {}     { set up of default level II parameters } "     {}  {}          {}  $    {}  {}          {}  Specific_T1 := false ;          {M59 BG 07JUL88} $     {}  {}          {}      {}  {}          {}  CardT1 := Switch_parm ( Int_T1 ) ;      {}  {}          {}  !    {}  {}          {}  CardT2 := Switch_parm ( Dflt_timer_t2 ) ;  !     {}  {}          {}      {}  {}          {}  CardK := Dflt_level_II_window_size ;      {}  {}          {}      {}  {}          {}  CardN2 := Dflt_level_II_retry_count ;       {}  {}          {}      {}  {}          {}  Reserved2 := 0 ;      {}  {}          {}      {}  {}          {}  { printing default parameters }       {}  {}          {}          { header }  $    {}  {}          {}  MESS_WRITER ( fullmsg, dflthdr1, 0 ) ; endline ; $     {}  {}          {}      {}  {}          {}          { Timer  }      {}  {}          {}  MESS_WRITER ( part1msg, q2_2_1, 0 )  ;      {}  {}          {}  IF DIALOG       {}  {}          {}  THEN  write ( Output_lu, Dble_T1:6 ) ;      {}  {}          {}  IF ( List IN Run_option )       {}  {}          {}  THEN  write ( List_file, Dble_T1:6 ) ;      {}  {}          {}  MESS_WRITER ( eolmsg, msec, 0 ) ;       {}  {}          {}      {}  {}          {}          { retry count }       {}  {}          {}  MESS_WRITER ( fullmsg, q2_2_2,  &    {}  {}          {}                        Dflt_level_II_retry_count ) ;  &     {}  {}          {}          { unacknowledged frames }       {}  {}          {}  MESS_WRITER ( fullmsg, q2_2_3,  &    {}  {}          {}                        Dflt_level_II_window_size ) ;  &     {}  {}          {}  EndLine     { Skip a line }       {}  {}          END     { ranking option }      {}  {}      END ;   { case }  $PAGE$      {}  {}                  { STANDARD LEVEL II DEFAULTS }      {}  {}  {-----------------------------------}       {}  {}  QUEST_ANSWER ( q4_3, yesno, answr ) ;       {}  {}  {-----------------------------------}       {}  {}  Endline ;   {skip a line}       {}  {}      {}  {}  CASE rep OF   
    {}  {}  again :  
 
    {}  {}{}{}{}GOTO 100 ; 
 
    {}  {}  yes   :  
 	    {}  {}      ;  	 
    {}  {}  no    :  
     {}  {}      BEGIN        {}  {}      {}REPEAT                    { TIMER : T1       }        {}  {}      {}{}{------------------------------------------}        {}  {}      {}{}QUEST_ANSWER ( q2_2_1, oneto32767, answr ) ;        {}  {}      {}{}{------------------------------------------}   
    {}  {}      {}{} 
     {}  {}      {}{}IF rep = again THEN       {}  {}{}{}{}{}{}GOTO 100 ;      {}  {}      {}{}IF ( num [ 1 ] < Int_T1 )       {}  {}      {}{}THEN BEGIN  $    {}  {}      {}{}   $skip_text on$                  {M60 BG 08JUL88}  $     {}  {}      {}{}    MESS_WRITER ( ermsg, T1toosmall, 0 ) ;      {}  {}      {}{}   $skip_text off$  "    {}  {}      {}{}    MESS_WRITER ( ermsg, T1toosmall, Dble_T1 ) ; "     {}  {}      {}{}    CONT_ABORT (local_rep) ;      {}  {}      {}{}    rep := local_rep ;  
    {}  {}      {}{}  END  
     {}  {}      {}{}ELSE      {}  {}      {}{}  BEGIN   $    {}  {}      {}{}    Specific_T1 := true ;          {M59 BG 07JUL88}  $     {}  {}      {}{}    CardT1 := Switch_parm ( num [ 1 ] ) ;       {}  {}      {}{}  END ;       {}  {}      {}UNTIL NOT ( Rep = none ) ;  	    {}  {}      {} 	      {}  {}      {}  IF ( rep = abort ) THEN XINHALT ( noerr ) ;        {}  {}      {}                          { RETRY COUNT: N2}      {}  {}      {}  {----------------------------------------}      {}  {}      {}  QUEST_ANSWER ( q2_2_2, oneto255, answr ) ;      {}  {}      {}  {----------------------------------------}  	    {}  {}      {} 	     {}  {}      {}  IF rep = again THEN       {}  {}{}{}{}{}{}GOTO 100 ;      {}  {}      {}  CardN2 := num [ 1 ] ;       {}  {}      {}                          { WINDOW SIZE: K }      {}  {}      {}  {----------------------------------------}      {}  {}      {}  QUEST_ANSWER ( q2_2_3, windowsz, answr ) ;      {}  {}      {}  {----------------------------------------}  	    {}  {}      {} 	     {}  {}      {}  IF rep = again THEN       {}  {}{}{}{}{}{}GOTO 100 ;      {}  {}      {}  Cardk := num [ 1 ]  
    {}  {}      END  
     {}  {}  END ; { LAP_B card parameters definition }      {}  {}      {}  {}  { Allows the LAP-B card to detect }       {}  {}  { that the Host CPU is halted.    }       {}  {}      {}  {}              { INACTIVITY TIMER: T3  }       {}  {}  {-----------------------------------}       {}  {}  QUEST_ANSWER ( q2_2_4, zeroto10, answr ) ;      {}  {}  {-----------------------------------}       {}  {}      {}  {}  IF rep = again THEN   
    {}  {}{}{}{}GOTO 100 ; 
     {}  {}      {}  {}  timer_T3 := num [ 1 ] ;       {}  {}  Xinit_net.Timer_T3 := timer_T3 ; { M13 BG22apr86 }      {}  {}  #    {}  {}  { Modem Signals Timer }      { new question M20 BG07JAN87} #     {}  {}      {}  {}  {----------------------------------------}      {}  {}  QUEST_ANSWER ( q2_2_5, zeroto15, answr ) ;      {}  {}  {----------------------------------------}      {}  {}      {}  {}  IF rep = again THEN   
    {}  {}{}{}{}GOTO 100 ; 
     {}      {}      modem_signals_timer := num [ 1 ] ;  $PAGE$      {}      Reserved := 0 ;       {}      ExtdPktNb     := false ;      {}      {}      IF ExtdPktNb   { Set default N1 parameter }       {}      THEN  !    {}          CARDN1 := Switch_parm ( X25_standard_packet_size + !     {}                          Ext_pkt_nbrng_hdr_size )      {}      ELSE  !    {}          CARDN1 := Switch_parm ( X25_standard_packet_size + !     {}                          Std_pkt_nbrng_hdr_size ) ;      {}      {}      IF NOT CARD_CONF      {}      THEN XINHALT ( noerr ) ;      {}      {}      IF NOT ( CN10 ( CardWriteLUbyte, timer_T3 ) )       {}      THEN XINHALT ( noerr ) ;      END   { With Current_net_ptr^ }       $SUBTITLE 'STEP 3: VC specifications'$  
END;  { step2_init } 
 !PROCEDURE step3_init ;  { .......... global parameters ........ }  !     LABEL       100 ;       VAR       curr_free, ptr, curr_maxvcnum, prev_maxvcnum : ONEWORD ;      vcqa     : prmpt_msg_list  ;      wevegotavcnumber : BOOLEAN ;      BEGIN     { step3_init ... get network local address,                              PVC and SVC numbers }      Curr_step := step3 ;                          { output step header }      MESS_WRITER ( stepheader, Stp3hdr, 0 ) ;          WITH answr, val, Xinit_gbl_entry, gbl_entry,           curr_net_ptr^, Xinit_net  DO       BEGIN       {}  Net_add_table.next_free := 1         ;  #    {}  curr_free := Net_add_table.next_free ;  { save current free }  #     {}                                          {   position }      {}  100 :       {}  {}      {}  {}  prev_maxvcnum := -1 ;  { startover }      {}  {}      {}  {}  WITH nea, Net_add_table DO  	    {}  {}  REPEAT 	 "    {}  {}  {}  next_free := curr_free ;    { reset to position on } "     {}  {}  {}                              { entry }   #    {}  {}  {}  {---------------------------------------------------}  # !    {}  {}  {}                          { network local address }  !     {}  {}  {}  QUEST_ANSWER ( q3_1, addofnet, answr ) ;      {}  {}  {}  #    {}  {}  {}  {---------------------------------------------------}  #     {}  {}  {}      {}  {}  {}  IF rep = again THEN       {}  {}{}{}{}{}{}GOTO 100 ;      {}  {}  {}      {}  {}  {}  IF NOT ( NET_ADD_VERIFY ( N ) )   
    {}  {}  {}  THEN 
     {}  {}  {}    begin       {}  {}  {}      CONT_ABORT (local_rep) ;      {}  {}  {}      rep := local_rep ;      {}  {}  {}    end       {}  {}  {}  ELSE  LocalAddr.ADD := Net_address ;      {}  {}  {}      {}  {}  UNTIL rep <> none ;       {}  {}  $PAGE$      {}  {}  
    {}  {}  WITH VCinfo DO 
 	    {}  {}  BEGIN  	 "    {}  {}  {}REPEAT  {}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{} "     {}  {}  {}  #    {}  {}  {}  vcqa := q3_2 ; ptr  := 1 ; wevegotavcnumber := false ; #     {}  {}  {}      {}  {}  {}  WHILE ( ord ( vcqa ) <= ord ( q3_5 ) )  DO      {}  {}  {}  BEGIN   
    {}  {}  {}  {}  REPEAT 
     {}  {}  {}  {}      curr_maxvcnum := prev_maxvcnum ;  	    {}  {}  {}  {} 	 #    {}  {}  {}  {}      {-------------------------------------------}  # #    {}  {}  {}  {}      {!} QUEST_ANSWER ( vcqa, vcnum, answr ) ; {!}  # #    {}  {}  {}  {}      {+-----------------------------------------+}  # 	    {}  {}  {}  {} 	     {}  {}  {}  {}      IF rep = again  THEN      {}  {}{}{}{}{}{}{}{}GOTO 100 ;  	    {}      {}  {} 	 $    {}      {}  {}      IF rep = no THEN { First VC # }   { # of VC's }  $ #    {}      {}  {}      BEGIN  W [ ptr ] := 0 ; W [ ptr + 1 ] := 0 END #     {}      {}  {}      ELSE      {}      {}  {}      BEGIN  { we've got a vc number }  !    {}      {}  {}      {}  IF ( num [ 1 ] <= curr_maxvcnum ) THEN !     {}      {}  {}      {}  BEGIN   #    {}      {}  {}      {}      MESS_WRITER ( ermsg, vcnumovlap, 0 ) ; #     {}      {}  {}      {}      CONT_ABORT (local_rep) ;      {}      {}  {}      {}      rep := local_rep ;      {}      {}  {}      {}  END  ELSE       {}      {}  {}      {}  BEGIN   '    {}      {}  {}      {}      W [ ptr ] := num [ 1 ] ; W [ ptr + 1 ] := 1 ;  '     {}      {}  {}      {}      curr_maxvcnum := num [ 1 ] ;      {}      {}  {}      {}      IF ( Log = 2 )      {}      {}  {}      {}      THEN  !    {}      {}  {}      {}          IF num [ 2 ] <= num [ 1 ] THEN !     {}      {}  {}      {}          BEGIN   '    {}      {}  {}      {}              MESS_WRITER (ermsg, vcnumovlap, 0 ) ;  '      {}      {}  {}      {}              CONT_ABORT (local_rep) ;       {}      {}  {}      {}              rep := local_rep ;      {}      {}  {}      {}          END ELSE      {}      {}  {}      {}          BEGIN       {}      {}  {}      {}              W [ ptr + 1 ] :=  &    {}      {}  {}      {}                      num [ 2 ] - num [ 1 ] + 1 ;  & !    {}      {}  {}      {}              curr_maxvcnum := num [ 2 ] !     {}      {}  {}      {}          END ;       {}      {}  {}      {}      IF ( rep { still } = numeric )      {}      {}  {}      {}      THEN  wevegotavcnumber := true      {}      {}  {}      {}  END       {}      {}  {}      END ;   (    {}      {}  {}  UNTIL rep <> none ; IF rep = abort THEN XINHALT ( noerr ) ;  ( 	    {}      {}  {} 	     {}      {}  {}  vcqa := succ ( vcqa ) ;  ptr := ptr + 2 ;       {}      {}  {}  prev_maxvcnum := curr_maxvcnum      {}      {}  END ;       {}      {}  IF NOT wevegotavcnumber THEN  
    {}      {}      begin  
     {}      {}        MESS_WRITER ( ermsg, novcnum, 0 ) ;       {}      {}        CONT_ABORT (local_rep) ;      {}      {}        rep := local_rep ;      {}      {}      end;  #    {}      {}UNTIL rep <> none ; {}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{}{} # $PAGE$      {}      {}      {}      {}  IF rep = abort THEN XINHALT ( noerr ) ;       {}      {}  "    {}      {}  NbofSVC.W[2] := NbofSVCin + NbofSVC2w + NbofSVCout ; "      {}      {}                  { OUTPUT number of SVC defined }   !    {}      {}  IF ( nbofSVC.W[2] <> 0 ) THEN         {CC 23Nov82} !     {}      {}  BEGIN       {}      {}      ENDLINE ;   !    {}      {}      MESS_WRITER ( fullmsg, defsvc1, nbofSVC.L ) ;  ! "    {}      {}      ENDLINE                             {CC 23Nov82} " 
    {}      {}  END  
     {}      END ;   { WITH VCinfo }       {}  $    {}  { .........  INITIALIZE rest of network header table ......... } $     {}      {}      eqt_head_ptr  := NIL ;      {}      eqt_curr_ptr  := NIL ;      {}      {}      NbofactivePVC := 0  ;       {}      NbofSVCwadd   := 0  ;       {}      NbofPOOLSVC   := 0  ;       {}      nbofPADSVC    := 0  ;       {}      {}      curr_mpksz    := X25_standard_packet_size       {}      END  { With Current_net_ptr^ }  $SUBTITLE 'STEP 4: Flow controls'$  END ;  { step3_init }   #PROCEDURE step4_init ;  { Network standard/nonstandard flow controls } # LABEL 100 ;       TYPE      flwarray_type = ARRAY [ flq1..flq3 ] OF ONEWORD ;   VAR            dflthdg       : prmpt_msg_list ; flwarray : flwarray_type ;        Curr_PTWFAC   : PTW_FAC_Type   ;          Max_buff_size : ONEWORD        ;      'BEGIN     { step4 .... get flow control & configuration information ....... }  '         Curr_step := step4 ;                          { output step header }      MESS_WRITER ( stepheader, Stp4hdr, 0 ) ;      %    WITH answr, val, Xinit_gbl_entry, gbl_entry, curr_net_ptr^, Xinit_net, %          Curr_PTWFAC DO       BEGIN   #    {}       { ........ Initialize flow control defaults .......... }  #     {}  !    {}  WITH DefaultPTW DO  { initialize default flow control to } !     {}  BEGIN   { X.25 standard default }   #    {}  {}  OutPktSize := Log2_of_X25_standard_packet_size ;  { 128 }  #     {}  {}  InPktSize  := OutPktSize                       ;      {}  {}  $    {}  {}  OutTHCl    := Max_thruput_class                ;  { speed }  $ &    {}  {}  InTHCl     := OutTHCl                          ;  { dependent }  &     {}  {}  "    {}  {}  OutWDWSize := X25_standard_window_size         ;  { 2 }  "     {}  {}  InWDWSize  := OutWDWSize                       ;      {}  {}      { initialize array of defaults to print }       {}  {}  flwarray [ flq1 ] := X25_standard_packet_size  ;      {}  {}  flwarray [ flq2 ] := OutWDWSize                ;      {}  {}  flwarray [ flq3 ] := OutTHCl      {}  END ;       {}      {}  100 :       {}  {}  $PAGE$  $    {}  {}     { ......... Output flow control defaults .............. } $     {}  {}      {}  {}              { .... print default header .... }      {}  {}      {}  {}  MESS_WRITER ( fullmsg, dflthdr2, 0 ) ; endline ;        {}  {}      {}  {}           { .... print flow control default .... }       {}  {}      {}  {}  dflthdg := flq1 ;       {}  {}  WHILE dflthdg <= ackynq DO  	    {}  {}  BEGIN  	     {}  {}  {}  MESS_WRITER ( part1msg, dflthdg, 0 ) ;      {}  {}  {}  IF ( dflthdg <> ackynq ) THEN       {}  {}  {}  BEGIN       {}  {}  {}      IF DIALOG       {}  {}  {}      THEN  write ( Output_lu, ' : ',   #    {}  {}  {}                           flwarray [ dflthdg ] : 4 ) ;  #     {}  {}  {}      IF ( List IN Run_option )       {}  {}  {}      THEN  write ( List_file, ' : ',   $    {}  {}  {}                               flwarray [ dflthdg ] : 4 )  $     {}  {}  {}      END ELSE  
    {}  {}  {}      BEGIN  
     {}  {}  {}          IF DIALOG   !    {}  {}  {}          THEN  write ( Output_lu, ' : ', Ndflt ) ;  !     {}  {}  {}          IF ( List IN Run_option )        {}  {}  {}          THEN  write ( List_file, ' : ', Ndflt )        {}  {}  {}  END ;       {}  {}  {}  
    {}  {}  {}  ENDLINE ;  
     {}  {}  {}      {}  {}  {}  dflthdg := succ ( dflthdg ) ;   	    {}  {}  END ;  	     {}  {}      {}  {}  ENDLINE ; { skip a line }       {}  {}  $    {}  {}      { ....... reset all flow control options ............ }  $     {}  {}  "    {}  {}  PTWQset   := Flow_cntrl_Q_SET_type [ PS, WS, TC, AK ] ;  "     {}  {}  PTWRec    := DefaultPTW ;       {}  {}  FACQset   := []         ;       {}  {}  FACWord.T := 0          ;       {}  {}  $    {}  {}      { ........  reset network buffer size if nessary .... }  $     {}  {}      {}  {}  Max_buff_size := curr_mpksz ;       {}  {}  $PAGE$      {}  {}  "    {}  {}  {------------------------------------------------------} " "    {}  {}                  { use standard flow control values  ? }  "     {}  {}  QUEST_ANSWER ( q4_1, yesno, answr ) ;       {}  {}  "    {}  {}  {------------------------------------------------------} "     {}  {}      {}  {}  CASE rep OF       {}  {}  {}again   :       {}  {}{}{}{}{}GOTO 100;       {}  {}  {}       {}  {}  {}yes     :           { use standard flow control }        {}  {}  {}    PTWqset := [] ;       {}  {}  {}  $    {}  {}  {}no      :           { nonstandard flow control facility }  $     {}  {}  {}    BEGIN   %    {}  {}  {}    {+----------------------------------------------------+} % %    {}  {}  {}    {}  FLOW_CNTRL_QS ( PTWqset, q4_1_1, Npacketsz, PTWRec,  % &    {}  {}  {}    {}                             FACword, Max_buff_size ) ;  & %    {}  {}  {}    {+----------------------------------------------------+} %     {}  {}  {}    {}  IF ( rep = again )      {}  {}{}{}{}{}{}{}THEN GOTO 100 ;   
    {}      {}    {} 
     {}      {}    {}  IF ( Max_buff_size > curr_mpksz )       {}      {}    {}  THEN  curr_mpksz := Max_buff_size       {}      {}    {}END       {}      END ; { CASE flow control default processing }      {}  $    {}          {  ......... Set new flow control defaults .......... }  $     {}      {}      DefaultPTW := PTWRec ;      {}  $    {}          {  ........... Set Network wide defaults ............ }  $     {}      {}      PVC_DfltPTWFAC := Curr_PTWFAC ;       {}      SVC_DfltPTWFAC := Curr_PTWFAC ;       END { WITH }  $SUBTITLE 'STEP 5: Negociation'$  END ;  { step4_init }   "PROCEDURE step5_init ;  { ..... SVC global facility options ..... }  " LABEL       100 ;   VAR       Curr_PTWFAC  : PTW_FAC_Type ;       Max_packetsz : ONEWORD      ;       Dummy        : OCTET        ;       BEGIN   { step5_init }          Curr_step := step5 ;          MESS_WRITER ( stepheader, Stp5hdr, 0 ) ;      $PAGE$  %    WITH answr, val, Xinit_gbl_entry, gbl_entry, curr_net_ptr^, Xinit_net, %          Curr_PTWFAC DO       BEGIN   {}{}{}{}100 :   {}  {}      Curr_PTWFAC := SVC_DfltPTWFAC ;   {}  {}  !{}  {}  {+------------------------------------------------------+} ! !{}  {}  {!                      FLOW CONTROL NEGOCIATION ?      !} ! !{}  {}  {!} QUEST_ANSWER ( q6_1, yesno, answr ) ;           {   !} ! !{}  {}  {!                                                      !} ! !{}  {}  {+------------------------------------------------------+} ! {}  {}      CASE rep OF   {}  {}      again   :   
{}{}{}{}{}{}{}{}GOTO 100 ; 
 {}  {}  {}  {}      no      : ;   {}  {}  {}  {}      yes     :   {}  {}          BEGIN   %{}  {}          {}  PTWQset := Flow_cntrl_Q_SET_type [ neg, PS, WS, TC ] ; % 	{}  {}          {} 	 #{}  {}          {}  FLOW_CNTRL_QS ( PTWQset, q6_1_1, NPCpktsz, PTWRec, # ${}  {}          {}                             FACWord, max_packetsz ) ; $ 	{}  {}          {} 	 {}  {}          {}  IF ( rep = again ) THEN   {}{}{}{}{}{}{}{}{}{}GOTO 100  {}  {}          END     { FLOW control negociation }  {}  {}      END;    { CASE flow control negociation }   {}  {}  {}  {}  {}  {}      FACqset := Facil_opt_Q_SET_type [ cu, mrc, arc ] ;  {}  {}  &{}  {}      CU_MRC_ARC ( FACqset, cugynq, yesno, yesnopc, FACWord, dummy ) ; & {}  {}  {}  {}      IF ( rep = again ) THEN   {}{}{}{}{}{}GOTO 100 ;  $PAGE$      {}  "    {}  { ..... Update SVC Default flowcontrol & facilities ..... }  "     {}       {}      PTWQset        := PTWQset + SVC_DfltPTWFAC.PTWQset ;        {}      SVC_DfltPTWFAC := Curr_PTWFAC                      ;       {}      {}      IF ( max_packetsz > curr_mpksz )      {}      THEN  curr_mpksz := max_packetsz ;      {}      END  { WITH answer }  END ; { procedure step5 init }  .  