/* Parity check on a file */

#include <stdio.h>
#include <process.h>

#define NOERR	0xFFFF

int main(int argc, char *argv[])
{
    FILE *f;
    int c, d, i, oldc, t;
    unsigned int j, k;
    int ok = 1;

    printf("Checking parity on %s\n", argv[1]);
    f = fopen(argv[1], "rb");
    if (f == NULL) { printf("\nFile Not Found\n"); exit(1); }
    j = 0;
    k = NOERR;
    while ((c = fgetc(f)) != EOF)
    {
	t = c;
	for (i = d = 0; i < 8; i++)
	{
	    d += t & 1;
	    t = t >> 1;
	}
	if (d & 1)		/* Odd (good) parity */
	{
	    if (k != NOERR)	/* There was an error */
	    {
		if (k == j - 1)	/* It was just last char */
		    printf ("%u(0x%X) ", k, oldc);
		else		/* There was a block of errors */
		    printf ("%u-%u ", k, j - 1);
		k = NOERR;	/* Reset error flag */
	    }
	}
	else			/* Bad parity (even) */
	{
	    ok = 0;		/* Flag for final printout */
	    if (k == NOERR)	/* Not in a block of errors */
		k = j;		/* Mark start of block */
	}
	oldc = c;		/* Remember erring char in case just one */
	j++;			/* Advance char count */
    }
    if (k != NOERR)	/* There was an error */
    {
	if (k == j - 1)	/* It was just last char */
	    printf ("%u(0x%X) ", k, oldc);
	else		/* There was a block of errors */
	    printf ("%u-%u ", k, j - 1);
	k = NOERR;	/* Reset error flag */
    }
    if (ok)
	printf("OK");
    return 0;
}