	.XLIST
;;**********************************************************************
;;*								       *
;;* MODULE NAME = UUMCPRB.INC					       *
;;*								       *
;;* DESCRIPTIVE NAME = CPRB Structure and Return Codes Definition      *
;;*								       *
;;* COPYRIGHT = (C) COPYRIGHT IBM CORP. 1984,1987		       *
;;*		LICENSED MATERIAL - PROGRAM PROPERTY OF IBM	       *
;;*		ALL RIGHTS RESERVED				       *
;;*								       *
;;*								       *
;;* FUNCTION = Define the CPRB Structure and Return Code Values        *
;;*								       *
;;* NOTES =							       *
;;*								       *
;;*   DEPENDENCIES = This definition requires version 1.00 or 2.00     *
;;*		     of the Macro Assembler.			       *
;;*								       *
;;*   RESTRICTIONS = None					       *
;;*								       *
;;*   REGISTER CONVENTIONS = ES:[DI] points to the CPRB structure when *
;;*			     any of the interface macros are invoked.  *
;;*								       *
;;* MODULE TYPE = Include					       *
;;*								       *
;;*   PROCESSOR = IBM Personal Computer MACRO Assembler 	       *
;;*   MODULE SIZE = 0 Bytes					       *
;;*   ATTRIBUTES  = N/A 					       *
;;*								       *
;;* ENTRY POINT = N/A						       *
;;*								       *
;;*   PURPOSE = N/A						       *
;;*   LINKAGE = N/A						       *
;;*								       *
;;* INPUT = None						       *
;;*								       *
;;* OUTPUT = Assembler psuedo-ops to define the CPRB and return codes. *
;;*								       *
;;* NORMAL RETURN = N/A 					       *
;;*								       *
;;* ERROR RETURN = N/A						       *
;;*								       *
;;* EXTERNAL REFERENCES 					       *
;;*								       *
;;*   OTHER ROUTINES = N/A					       *
;;*   DATA AREAS = N/A						       *
;;*   CONTROL BLOCKS = N/A					       *
;;*								       *
;;* TABLES = N/A						       *
;;*								       *
;;* MACROS = N/A						       *
;;*								       *
;;* CHANGE ACTIVITY =						       *
;;*								       *
;;**********************************************************************
	.LIST
uercprb        STRUC
uerrbsiz	dw    ? 		;Size of CPRB in bytes
uerversion	dw    ? 		;Version Number
;uerversnum	EQU   0100H		;Current version value

uerretcode	dd    ? 		;Return Code

uerverbtyp	db    ? 		;Verb Type
;uersendreq	EQU   1 		;Send_Request

		db    ? 		;Reserved

uerfunct	dw    ? 		;Function ID

		dw    ? 		;Reserved

uerqparml	dw    ? 		;Request Parameters Length
uerqparmad	dd    ? 		;Request Parameters Address

uerqdatal	dw    ? 		;Request Data Length
uerqdataad	dd    ? 		;Request Data Address

uerrparml	dw    ? 		;Reply Parameters Length
uerrparmad	dd    ? 		;Reply Parameters Address

uerrdatal	dw    ? 		;Reply Data Length
uerrdataad	dd    ? 		;Reply Data Address

		dw    ? 		;Reserved

uerservrc	dd    ? 		;Server Return Code

uerrepldplen	dw    ? 		;Replied Parameters Length
uerreplddlen	dw    ? 		;Replied Data Length

uerwkarea	db    46 dup(?) 	;Work Area

uersrvnml	dw    ? 		;Server Name field length
uerserver	db    8 dup(?)		;Server Name
uercprb 	ENDS
;  -----------	Field Definitions  -----------
uerversnum	EQU   0100H		;Current version value
uersendreq	EQU   1 		;Send_Request
uersubfunct	EQU   0103H		;Sub function (register AX)
uerinterrupt	EQU   07FH		;Call/Return interrupt value
; ---------------------  Return Codes  ---------------------
; Error Types
uererrokeq	EQU	0000H		;Successful
uererrt1eq	EQU	0100H		;Error Type 1 - request failed
uererrt2eq	EQU	02H		;Error Type 2 - acknowledge sent
uererrt3eq	EQU	03H		;Error Type 3 - acknowledge recd

; Type 1 Errors - low word of return code
uererrt1start	EQU	0402H		;not started
uererrt1load	EQU	0404H		;not loaded
uererrt1busy	EQU	0408H		;busy
uererrt1ver	EQU	040AH		;Unsupported version ID
uererrt1emu	EQU	040CH		;PC 3270 Emulation not loaded
uererrt1qplen	EQU	0602H		;Request parameters length too large
uererrt1rplen	EQU	0604H		;Reply parameters length too large
uererrt1verb	EQU	0606H		;Invalid verb type
uererrt1serv	EQU	0608H		;Invalid server name
uererrt1qpad	EQU	060CH		;Invalid request parameters address
uererrt1qdad	EQU	060EH		;Invalid request data address
uererrt1rpad	EQU	0610H		;Invalid reply parameters address
uererrt1rdad	EQU	0612H		;Invalid reply data address
uererrt1topv	EQU	0616H		;TOPVIEW not supported
uererrt1cncl	EQU	0802H		;Cancelled by host
uererrt1conv	EQU	0C00H		;Unable to maintain conversation
uererrt1ise	EQU	0C02H		;Internal software error
uererrt1prot	EQU	0C04H		;Protocol violation
uererrt1syin	EQU	0C06H		;System inconsistency
                                                           