/*
 *	@(#) h/user.h 1.14 84/09/16 Copyright Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE WHICH IS SPECIFIC TO THE
 * INTEL 80286 CPU AND MAY REQUIRE MODIFICATION
 * WHEN ADAPTING XENIX TO NEW HARDWARE.
 */


/*
** U area-
**	On the 286, we keep the kernel stack in the first part of
**	the u area, and the LDT for the process lives above it.
**	The kernel stack lives at the start of the u and grows down so that
**	if it overflows, we get a fault instead of trashing the u area.
**	Note that the LDT is not part of the u area proper,
**	it just tags along for the ride during swapping, etc.
**	When we save and resume we don't move the LDT, we just 
**	set the LDT register to point to wherever the LDT 
**	happens to be in memory.	
*/
/*
 * The user structure.
 * One allocated per process.
 * Contains all per process data that doesn't need to be referenced
 * while the process is swapped.
 * The user block is USIZE*click bytes long;
 * contains the system stack per user; is cross referenced
 * with the proc structure for the same process.
 */

typedef	char far	*faddr_t;

#ifndef X_MAGIC
#include "a.out.h"
#endif
 
struct	user
{                               /* octal offset */
	char	u_kstack[KSSIZE];   /* kernel stack */
	label_t u_rsav;             /* save info when exchanging stacks */
	label_t u_qsav;             /* label variable for quits and interrupts*/
	label_t u_ssav;             /* label variable for swapping */
	char    u_segflg;           /* IO flag: 0:user D; 1:system; 2:user I */
	char    u_error;            /* return error code */
	ushort  u_uid;              /* effective user id */
	ushort  u_gid;              /* effective group id */
	ushort  u_ruid;             /* real user id */
	ushort  u_rgid;             /* real group id */
	struct proc *u_procp;       /* pointer to proc structure */
	int     *u_ap;              /* pointer to arglist */
	union {                     /* syscall return values */
		struct	{
			int     r_val1;  
			int     r_val2; 
		}r_reg;
		off_t	r_off;
		time_t	r_time;
		long	r_long;
		faddr_t	r_faddr;
	} u_r;
	faddr_t u_base;             /* base address for IO */
	unsigned u_count;           /* bytes remaining for IO */
	off_t   u_offset;           /* offset in file for IO */
	short   u_fmode;            /* file mode for IO */
	short   u_errcnt;           /* syscall error count */
	struct inode *u_cdir;       /* pointer to inode of current directory */
	struct inode *u_rdir;       /* root directory of current process */
	faddr_t u_dirp;             /* pathname pointer */
	struct direct u_dent;       /* current directory entry */
	struct inode *u_pdir;       /* inode of parent directory of dirp */
	struct file *u_ofile[NOFILE];/* pointers to file structures of open files */
	char    u_pofile[NOFILE];   /* per-process flags of open files */
	int     u_arg[16];          /* arguments to current system call */
	unsigned u_tsize;           /* text size (clicks) */
	unsigned u_dsize;           /* data size (clicks) */
	unsigned u_ssize;           /* stack size (clicks) */
	faddr_t u_signal[NSIG];     /* disposition of signals */
	time_t  u_utime;            /* this process user time */
	time_t  u_stime;            /* this process system time */
	time_t  u_cutime;           /* sum of childs' utimes */
	time_t  u_cstime;           /* sum of childs' stimes */
	int     *u_ar0;             /* address of users saved R0 */
	struct {                    /* profile arguments */
		faddr_t  pr_base;   /* buffer base */
		unsigned pr_size;   /* buffer size */
		long     pr_off;    /* pc offset */
		unsigned pr_scale;  /* pc scaling */
		faddr_t  pr_syspc;  /* address of user pc during syscall */
	} u_prof;
	char    u_intflg;           /* catch intr from sys */
	char    u_sep;              /* flag for I and D separation */
	unsigned short	u_renv;	    /* runtime environment */ 
	struct tty *u_ttyp;         /* controlling tty pointer */
	dev_t   u_ttyd;             /* controlling tty dev */
	struct xexec u_exdata;      /* header of executable file */
	struct xext     u_exext;    /* extension to header */
	char    u_comm[DIRSIZ];     
	time_t  u_start;            
	time_t  u_ticks;           
	long    u_mem;            
	long    u_ior;           
	long    u_iow;          
	long    u_iosw;        
	long    u_ioch;       
	char    u_acflag;    
	short   u_cmask;            /* mask for file creation */
	daddr_t u_limit;            /* maximum write address */
	int     u_t[32];            /* (see iupdat) */
	int     u_sdsaved;          /* we have saved the shared data */
/* machine dependent fields */
	int     u_fper;             /* FP error register */
	char    u_fpsaved;          /* FP regs saved for this proc */
	char    u_fpused;           /* FP used for this process    */
	struct {                    /* 80287 save status */
		int	fp_cntrl;	/* control word */
		int	fp_stat;	/* status word */
		int	fp_tag;		/* tag word */
		int	fp_ip[2];	/* instruction pointer */
		int	fp_op[2];	/* operand pointer */
		char    fp_regs[100];   /* temporary registers */
		int     fp_spare;       /*   (2 xtra for emulator)      */
	} u_fps;
	unsigned short  u_lxrw;     /* R/W access of text segments */ 
	faddr_t	 u_stkbot;	    /* start or bottom of user stack */
	faddr_t	 u_edata;	    /* bottom of user data before brks */
	long 	 u_segoff[NUSEGS];  /* for exec of x.out seg files */
};
extern struct user u;

#define	u_rval1	u_r.r_reg.r_val1
#define	u_rval2	u_r.r_reg.r_val2
#define	u_roff	u_r.r_off
#define	u_rtime	u_r.r_time
#define	u_rlong	u_r.r_long
#define	u_rfaddr u_r.r_faddr

/* u_error codes */
#define	EPERM	1
#define	ENOENT	2
#define	ESRCH	3
#define	EINTR	4
#define	EIO	5
#define	ENXIO	6
#define	E2BIG	7
#define	ENOEXEC	8
#define	EBADF	9
#define	ECHILD	10
#define	EAGAIN	11
#define	ENOMEM	12
#define	EACCES	13
#define	EFAULT	14
#define	ENOTBLK	15
#define	EBUSY	16
#define	EEXIST	17
#define	EXDEV	18
#define	ENODEV	19
#define	ENOTDIR	20
#define	EISDIR	21
#define	EINVAL	22
#define	ENFILE	23
#define	EMFILE	24
#define	ENOTTY	25
#define	ETXTBSY	26
#define	EFBIG	27
#define	ENOSPC	28
#define	ESPIPE	29
#define	EROFS	30
#define	EMLINK	31
#define	EPIPE	32
#define	EDOM	33
#define	ERANGE	34
#define	EUCLEAN	35
#define EDEADLOCK 36
#define ENOTNAM 37
#define ENAVAIL 38
#define EISNAM  39


/* u_segflg values: Read/Write, User/Kernel, Ins/Data */
#define U_WRITE	0
#define U_READ	1

#define U_UD	0	/* user data */
#define U_KD	1	/* kernel data */
#define U_UI	2	/* user code */

#define	U_WUD	((U_UD << 1) | U_WRITE)		/* 0 */
#define	U_RUD	((U_UD << 1) | U_READ)		/* 1 */
#define	U_WKD	((U_KD << 1) | U_WRITE)		/* 2 */
#define	U_RKD	((U_KD << 1) | U_READ)		/* 3 */
#define	U_WUI	((U_UI << 1) | U_WRITE)		/* 4 */
#define	U_RUI	((U_UI << 1) | U_READ)		/* 5 */

#define	EXCLOSE	01
