/*
 *	@(#) h/filsys.h 1.2 84/09/16 Copyright Microsoft Corporation, 1983
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/*
 *	@(#) h/filsys.h 1.2 84/09/16 Copyright Microsoft Corporation, 1983
 */




/*
 * THIS FILE CONTAINS CODE WHICH IS DESIGNED TO BE
 * PORTABLE BETWEEN DIFFERENT MACHINE ARCHITECTURES
 * AND CONFIGURATIONS. IT SHOULD NOT REQUIRE ANY
 * MODIFICATIONS WHEN ADAPTING XENIX TO NEW HARDWARE.
 */



/*
 * Structure of the super-block
 */
struct	filsys
{
	ushort	s_isize;	/* size in blocks of i-list */
	daddr_t	s_fsize;	/* size in blocks of entire volume */
	short	s_nfree;	/* number of addresses in s_free */
	daddr_t	s_free[NICFREE];	/* free block list */
	short	s_ninode;	/* number of i-nodes in s_inode */
	ino_t	s_inode[NICINOD];	/* free i-node list */
	char	s_flock;	/* lock during free list manipulation */
	char	s_ilock;	/* lock during i-list manipulation */
	char  	s_fmod; 	/* super block modified flag */
	char	s_ronly;	/* mounted read-only flag */
	time_t	s_time; 	/* last super block update */
	daddr_t	s_tfree;	/* total free blocks*/
	ino_t	s_tinode;	/* total free inodes */
	short   s_dinfo[4];     /* device information */
	char	s_fname[6];	/* file system name */
	char	s_fpack[6];	/* file system pack name */
	/* remainder is maintained for xenix */
	char   	s_clean;   	/* S_CLEAN if structure is properly closed */
	char    s_fill[NSBFILL];/* space to make sizeof filsys be BSIZE */
	long    s_magic;        /* indicates version of filsys */
	long	s_type;		/* type of new file system */
};

#define	S_CLEAN	0106        	/* arbitrary magic value  */

/* s_magic, magic value for file system version */
#define	S_S3MAGIC	0x2b5544	/* system 3 arbitrary magic value */

/* s_type, block size of file system */
#define	S_B512		1	/* 512 byte block */
#define	S_B1024		2	/* 1024 byte block */

/* codes for file system version (for utilities) */
#define	S_V2		1		/* version 7 */
#define	S_V3		2		/* system 3 */
