/*
 *	@(#) h/mmu.h 1.10 84/09/16 Copyright Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE SPECIFIC TO THE IBM PC/AT
 * COMPUTER. IT MAY REQUIRE MODIFICATION WHEN MOVING
 * XENIX TO DIFFERENT MACHINE ARCHITECTURES OR CONFIGURATIONS.
 */


/*
 * mmu.h
 *	Memory Management Definitions
 *
 * used by mmu.c
 * param.h has basic page-size/etc definitions.
 *
 * definitions for 286 memory managment model
 */

/*
 * descriptor table defines
 * NOTE: the RPL in USEG_SEL and ULDT_SEL is 0. This
 *	 does not ENFORCE protection
 */
#define	NULL_SEL	0	/* 'invalid' selector */
/* gdt defines
 * WARNING - these must agree with the layout of the gdt in tabs.s
 */
#define	GDT_SEL		0x8	/* selector for GDT alias */
#define	IDT_SEL		0x10	/* selector for IDT alias */
#define KDS_SEL		0x18	/* Kernel data seg selector */
#define	KCS_SEL		0x20	/* Kernel code seg selector for SEG 1 */
#define	KSS_SEL		0x48	/* Kernel stack seg selector */
#define	KTSS		0x50	/* Kernel TSS selector */
#define	KTSS_SEL	0x58	/* Kernel TSS alias selector */
#define	KWORK0		0x60	/* work segment selector */
#define	KWORK1		0x68	/* work segment selector */
#define	KWORK2		0x70	/* work segment selector */
#define	SWAP1_SEL	0x78	/* work segment selector - swap */
#define	SWAP2_SEL	0x80	/* work segment selector - swap */
#define	CLDT_SEL	0x88	/* current process' ldt selector */
#define	KENTRY		0x90	/* kernel entry selector (call gate) */
#define	MAPWKSEL	0x98	/* selector for map work */
#define COPY_SEL	0xA0	/* selector for copyio */
#define BUF_SEL		0xA8	/* selector for mapped out bufers */
#define BUF2_SEL	0xB0	/* selector for mapped out bufers */
#define BUF3_SEL	0xB8	/* selector for mapped out bufers */
#define	MONO_DSEL	0xC0	/* monochrome monitor selector */
#define	COLOR_DSEL	0xC8	/* color monitor selector */
#define	HDIO_SEL	0xD0	/* hard disk driver selector */
#define	DEV_DSEL	0xD8	/* first device driver selector */
#define	LAST_SEL	0xE8	/* marks last slot in the gdt */
/* 
 * ldt defines 
 * These selector definitions should not be touched - they are chip
 * and linker defined
 */
#define	ULDT_SEL	0x0C	/* ldt based, ldt alias */
#define	USEG_SEL	0x14	/* LDT based U seg selector */
#define	UEXEC_SEL	0x1C	/* used for execing */
#define	UTEMP_SEL	0x2C	/* used for swapping, etc */
#define	UOVRLY_SEL	0x34	/* used with overlay files */
#define	FIRSTU_SEL	0x3F	/* user's initial selector */

#define NCSEGS		5	/* number of text segments the kernel may have*/

/*
 * Descriptor Types
 */
#define	DST_ATASK	0x1	/* avail task */
#define	DST_TABLE	0x2	/* descriptor table */
#define	DST_BTASK	0x3	/* busy task */
#define	DST_CGATE	0x4	/* call gate */
#define	DST_TAGATE	0x5	/* task context gate */
#define	DST_IGATE	0x6	/* interrupt gate */
#define	DST_TRGATE	0x7	/* trap gate */


#include "relsym86.h"

/*
 * access byte fields (DSA_*) are defined in relsym86.h
 */

/*
 * flag register bits
 */
#define	FL_NCX		0x4000	/* nested context */
#define	FL_IOPL		0x3000	/* I/O priv level - must not be set for users */
#define	FL_OFLOW	0x800	/* overflow bit */
#define	FL_DIR		0x400	/* direction of string ops */
#define	FL_INTEN	0x200	/* interrupt enable */
#define	FL_TRAP		0x100	/* single step flag */
#define	FL_SIGN		0x80	/* sign bit */
#define	FL_ZERO		0x40	/* zero bit */
#define	FL_AUXCARRY	0x10	/* auxillary carry */
#define	FL_PARITY	0x4	/* parity bit */
#define	FL_CARRY	0x1	/* carry bit */

/*
 * parts of a selector see relsym86.h
 */
#define	SEL_TI		SEL_LDT	/* table indicator (0-gdt,1-ldt) */

/*
 * descriptor table structure: see relsym86.h
 */
#define NPSEGM	0		/* no segments */

/*
 * Misc constants.
 */
#define OFFMASK	(MMPGSZ-1)	/* develop offset within page from addr */

#define RO (DSA_CODE|DSA_RING3) /* tells mmuset to setup code to make */
#define RW (DSA_DATA|DSA_RING3) /* kernel access read-only, or rd/wr */

#define	MMUOK	((mloc_t) 0)
#define	MMUERR	((mloc_t) -1)
extern mloc_t mmupget();
extern mloc_t mmuget();

/*
 * macros to determine the size and location of the U seg
 */

extern long dscraddr();
extern unsigned short dscrlimit();
