/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE WHICH IS DESIGNED TO BE
 * PORTABLE BETWEEN DIFFERENT MACHINE ARCHITECTURES
 * AND CONFIGURATIONS. IT SHOULD NOT REQUIRE ANY
 * MODIFICATIONS WHEN ADAPTING XENIX TO NEW HARDWARE.
 */

/*
 * Random set of variables used by more than one routine.
 */
struct inode *rootdir;		/* pointer to inode of root directory */
struct proc *runq;		/* head of linked list of running processes */
struct proc *Hogproc;           /* if non-NULL, schedule only this process */
short   cputype;                /* type of cpu */
time_t	lbolt;			/* time in HZ since last boot */
time_t	time;			/* time in sec from 1970 */
int     Hz;                     /* configurable clock speed */
int     Timezone;               /* configurable timezone */
int     Dstflag;                /* configurable DST flag  */

int	mpid;			/* generic for unique process id's */
char	runin;			/* scheduling flag */
char	runout;			/* scheduling flag */
char	runrun;			/* scheduling flag */
char    runtxt;                 /* scheduling flag */
char	curpri;			/* more scheduling */
unsigned maxmem;		/* actual max memory per process */
int	physmem;		/* physical memory on this CPU */
daddr_t	swplo;			/* block number of swap space */
int	nswap;			/* size of swap space */
int	updlock;		/* lock for sync */
daddr_t	rablock;		/* block to be read ahead */
int     Cmask;                  /* default creation mask */
extern	char	regloc[];	/* locs of saved user registers (trap.c) */
extern short	reglocc;	/* size of regloc array */
dev_t	rootdev;		/* device of the root */
dev_t	swapdev;		/* swapping device */
dev_t	pipedev;		/* pipe device */
extern	short   icode[];	/* user init code */
ushort  szicode;                /* its size */
int	blkacty;		/* active block devices */

/* machine dependent part */


/* function defs */
dev_t getmdev();
daddr_t	bmap();
struct inode *ialloc();
struct inode *iget();
struct inode *owner();
struct inode *maknode();
struct inode *namei();
struct buf *alloc();
struct buf *getblk();
struct buf *getablk();
struct buf *bread();
struct buf *breada();
struct file *getf();
struct file *falloc();
int	uchar();

extern	char	maxmask[]; 	/* 8259 dependent flag set in init8259.c*/

/*
 * Structure of the system-entry table
 */

struct sysent {
	char	 sy_nlarg;	/* large model arg word count */
	char	 sy_nmarg;	/* middle model arg words (if reg overflow) */
	unsigned sy_argmask;	/* mask to show type of argument(s) */
	int	 (*sy_call)();	/* handler */
};

/*	idt table entry format */

struct idt {
	int	(far *i_func)();
	char	i_hbase;
	char	i_type;
	short	i_pad;
};
