/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE WHICH IS DESIGNED TO BE
 * PORTABLE BETWEEN DIFFERENT MACHINE ARCHITECTURES
 * AND CONFIGURATIONS. IT SHOULD NOT REQUIRE ANY
 * MODIFICATIONS WHEN ADAPTING XENIX TO NEW HARDWARE.
 */

#ifdef M_KERNEL

#ifndef OLDSD			/* for 68000 compatability */
struct sd {                 /* shared data table */
	struct inode *sd_inode;	/* pointer to inode for segment */
	faddr_t	     sd_addr;	/* address in this procs data space */
	ushort       sd_vnum;	/* version # for local copy */
	char	     sd_flags;	/* describing state of this proc */
	char	     sd_res;	/* reserved field to word align */
	struct sd    *sd_link;	/* ptr to next shared data seg for this proc */
};

struct	shmid_ds {
	struct	ipc_perm shm_perm;	/* operation permission struct */
	unsigned int	 shm_segsz;	/* segment size */
	ushort	shm_ptbl;		/* addr of sd segment */
	ushort	shm_lpid;		/* pid of last shared mem op */
	ushort	shm_cpid;		/* creator pid */
	ushort	shm_nattch;		/* current # attached */
	ushort	shm_cnattch;		/* in-core # attached */
	time_t	shm_atime;		/* last attach time */
	time_t	shm_dtime;		/* last detach time */
	time_t	shm_ctime;		/* last change time */
};		

struct  shmid_ent {	/* shared data identifier table for SysV */
	key_t	key;
	struct	inode	*ip;
	char	shmid_flag;
	char	shm_res;	/* reserved field to word align */
};

extern struct sd sdtab[];	/* the shared data table itself */
extern struct shmid_ent shmid_tab[];
extern int shmid_pos;
#endif				/* OLDSD */


/* Shared Data flags */

#define SDI_SWAPPING	0x01
#define SDI_SHMV	0x02	/* denotes system V */
#define SDI_LOCKED	0x10
#define	SDI_NTFY	0x20
#define SDI_DEST	0x40
#define SDI_CLEAR	0x80

/* system V defines */
#define SHM_RDONLY	010000	 /* attach read-only, else read-write */
#define SHM_RND		020000	 /* round the attach address to start of seg. */
#define SHMLBA		0x10000	 /* sd segs start at addr given by */ 
				 /*    (addr - (addr % SHMLBA)) */
#define SHMID_ORPHAN	0x01 	 /* no procs are attached anymore, but it has */
				 /*    not been removed via shmctl() yet      */	
#define	SD_BTWN		0x40

/* shmctl cmds */
#define SHM_LOCK	3
#define SHM_UNLOCK	4

#else				 /* M_KERNEL end of kernel-only defines */

extern char *sdget();

#endif

#define	SD_RDONLY	0x00
#define	SD_WRITE	0x01
#define	SD_CREAT	0x02
#define	SD_UNLOCK	0x04
#define	SD_NOWAIT	0x08

