/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/***	stand.h
 *
 *	MODIFICATION HISTORY
 *	M000	14 Apr 83	andyp
 *	- 3.0 upgrade.  (uncommented).  Structs changed a bit, including
 *	  members moving from one struct to another.  Net effect is loss
 *	  of 'cyloff' field, addition of [amc]time fields.  Global names
 *	  changed some, usually with addition of leading "_".  Global
 *	  names added are errno, mtab.  Global names removed are "b",
 *	  "blocknos".  "segflag" is now M_PDP11.  Defines added are BLKSIZ,
 *	  NAMSIZ, NDEV. Defines removed are NBUFS.
 */

#define	SCCSID	@(#)saio.h	4.2

/*
 * Header file for standalone package
 */

#include	<errno.h>
#include	<sys/param.h>
#include	<sys/inode.h>

/*
 * I/O block flags
 */

#define	F_READ	01
#define	F_WRITE	02
#define	F_ALLOC	04
#define	F_FILE	010

/*
 * Request codes -- must be
 * the same as an F_XXX above
 */

#define	READ	1
#define	WRITE	2

/*
 * Buffer sizes
 */

#define	BLKSIZ	512
#define	NAMSIZ	60

/*
 * devsw table --
 * initialized in conf.c
 */

struct devsw {
	int	(*dv_strategy)();
	int	(*dv_open)();
	int	(*dv_close)();
};

struct devsw	_devsw[];

/*
 * dtab table -- entries
 * are created by MKNOD
 */

#define	NDEV	6

struct dtab {
	char		*dt_name;
	struct devsw	*dt_devp;
	int		dt_unit;
	daddr_t		dt_boff;
} _dtab[NDEV];

/*
 * mtab table -- entries
 * are created by mount
 */

#define	NMOUNT	4

struct mtab {
	char		*mt_name;
	struct dtab	*mt_dp;
} _mtab[NMOUNT];

/*
 * I/O block: includes an inode,
 * cells for the use of seek, etc,
 * and a buffer.
 */

struct iob {
	char		i_flgs;
	struct inode	i_ino;
	time_t		i_atime;
	time_t		i_mtime;
	time_t		i_ctime;
	struct dtab	*i_dp;
	off_t		i_offset;
	daddr_t		i_bn;
	char		*i_ma;
	int		i_cc;
	char		i_buf[512];	/* M000 why isn't this BLKSIZ ??? */
};

#define	NFILES	6
struct iob	_iobuf[NFILES];

#ifdef	M_PDP11
/*
 * Set to which 32Kw segment the code is physically running in.
 * Must be set by the user's main (or thereabouts).
 */

int	segflag;
#endif

/*
 * Set to the error type of the routine that
 * last returned an error -- may be read by perror.
 */

int	errno;
