
/*
 *	$Header: /b/sns/usr/sys/h/RCS/machdep.h,v 1.13 85/12/11 10:13:02 snapshot Exp $
 *
 *	Copyright (C) Microsoft Corporation, 1983, 1984, 1985
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/*
 *	Various machine dependent things
 */

/*
 *	MODIFICATION HISTORY
 *	M000	05/24/85	lees
 *	- Added MCAIOC defines.
 *	M001	10/22/85	lees
 *	- Added KBENABLED.
 */

/* PC/AT Hard disk control */
#define HDIO	('H' << 8)
#define HDIORST	(HDIO|1)	/* hard disk reset */
#define HDIOPAR	(HDIO|2)	/* hard disk parameters */

/* PC/AT Floppy disk control  */
#define FDIO	('F' << 8)
#define FDFMTON		(FDIO|1)	/* formatting on */
#define FDFMTOFF	(FDIO|2)	/* formatting off */

/* PC/AT Cga adapter control */
#define	CGAIOC	('C' << 8)	
#define	CGAMODE (CGAIOC | 1)		/* change cga mode */
#define CGAIO	(CGAIOC | 2)		/* do inb/outb on cga port */
#define CGA_GET (CGAIOC | 3)		/* get cga mode setting */

/* PC/AT Pga adapter control */
#define PGAIOC	('P' << 8)
#define PGAMODE (PGAIOC | 1)		/* change pga mode */
#define PGAIO	(PGAIOC | 2)		/* do inb/outb on pga port */
#define PGA_GET (PGAIOC | 3)		/* get pga mode setting */

/* PC/AT Ega adapter control */
#define EGAIOC	('E' << 8)
#define EGAMODE (EGAIOC | 1)		/* change ega mode */
#define EGAIO	(EGAIOC | 2)		/* do inb/outb on ega port */
#define EGA_GET (EGAIOC | 3)		/* get ega mode setting */

/* PC/AT Mca adapter control */
#define MCAIOC	('M' << 8)
#define MCAMODE	(MCAIOC | 1)		/* change mca mode */
#define MCAIO	(MCAIOC | 2)		/* do inb/outb on mca port */
#define MCA_GET (MCAIOC | 3)		/* get mca mode setting */


/* Common PC/AT adapter control */

#include "comcrt.h"

/* Defines for console-switching ioctl -- MONO, CGA, PGA, and EGA */
/* definitions are in comcrt.h  				  */	
#define SWAPCONS ('s' << 8)
#define SWAPMONO (SWAPCONS | MONO)
#define SWAPCGA  (SWAPCONS | CGA)
#define SWAPPGA  (SWAPCONS | PGA)
#define SWAPEGA  (SWAPCONS | EGA)

/* defines for mode-switching ioctl -- modes are defined in comcrt.h */
#define MODESWITCH ('S' << 8)
#define SW_B40x25  (MODESWITCH | M_B40x25)
#define SW_C40x25  (MODESWITCH | M_C40x25)
#define SW_B80x25  (MODESWITCH | M_B80x25)
#define SW_C80x25  (MODESWITCH | M_C80x25)
#define SW_BG320   (MODESWITCH | M_BG320)
#define SW_CG320   (MODESWITCH | M_CG320)
#define SW_BG640   (MODESWITCH | M_BG640)
#define SW_EGAMONO80x25 (MODESWITCH | M_EGAMONO80x25)
#define SW_CG320_D    (MODESWITCH | M_CG320_D)
#define SW_CG640_E    (MODESWITCH | M_CG640_E)
#define SW_EGAMONOAPA (MODESWITCH | M_EGAMONOAPA)
#define SW_CG640x350  (MODESWITCH | M_CG640x350)
#define SW_ENH_MONOAPA2 (MODESWITCH | M_ENHMONOAPA2)
#define SW_ENH_CG640  (MODESWITCH | M_ENH_CG640)
#define SW_ENHB40x25  (MODESWITCH | M_ENH_B40x25)
#define SW_ENHC40x25  (MODESWITCH | M_ENH_C40x25)
#define SW_ENHB80x25  (MODESWITCH | M_ENH_B80x25)
#define SW_ENHC80x25  (MODESWITCH | M_ENH_C80x25)
#define SW_MCAMODE    (MODESWITCH | M_MCA_MODE)

/* defines for display memory mapping ioctl (see consioctl in console.c) */
#define MAPADAPTER ('m' << 8)
#define MAPCONS (MAPADAPTER)  
#define MAPMONO (MAPADAPTER | MONO)
#define MAPCGA  (MAPADAPTER | CGA) 
#define MAPPGA  (MAPADAPTER | PGA)
#define MAPEGA  (MAPADAPTER | EGA)

				/* M000 */
/* defines for ibm keyboard ioctls (see consioctl in console.c) */
#define FKEYIOC   ('k' << 8)
#define GETFKEY   (FKEYIOC)
#define SETFKEY   (FKEYIOC | 1)
#define TIOCKBON  (TIOC|8)	/* M000 */
#define TIOCKBOF  (TIOC|9)	/* M000 */
#define KBENABLED (TIOC|10)	/* M001 */

#ifndef _GRAPHICS
#define _GRAPHICS
/* structure used for SETFKEY and GETFKEY ioctls */
struct fkeyarg {	
	unsigned int	keynum;
	char	 	keydef[MAXFK];
	char		flen;			
};

/* defines for ibm console ioctls (see consioctl in console.c) */
#define CONSIOC		('c' << 8)
#define CONS_CURRENT 	(CONSIOC|1)
#define CONS_GET	(CONSIOC|2)

/* defines for inb/outb ioctls for graphics adapter ports */
#define IN_ON_PORT	1
#define OUT_ON_PORT	0

/* structure used for inb/outb ioctls for graphics adapter ports */
struct port_io_struct {
	char	dir;	/* direction flag (in vs. out) */
	unsigned int port;
	char	data;
};
struct port_io_arg {
	struct port_io_struct args[4];
};	
#endif /* _GRAPHICS */

/*
 *  Number of GDT entries. This value must be at least 24. 
 *  Descriptor table entries 25 through NGDT are allocated to drivers as 
 *  needed by means of the dscralloc  and dscrfree routines.
 */

#define NGDT	50

/*
 * Initalize clock constant for 50msec clock interrupts.
 * Magic value to cause proper interrupt interval - used
 * by mdep/mch.s/clkstart().
 * Assumes a 1.19MHz clock input. (1190000 / HZ)
 */
#define CLKNUM 23850

/* 
 * Various defines for 8259 special fully nested support
 */
#define NUM_8259	2	/* number of 8259s on this system */
#define MAX8259		9 	/* max number of 8259s possible */
#define MAXLEV		8	/* max interrupt levels on an 8259 */
#define MAXVEC		72	/* max vectors on fully cascaded system */

#define	HAS_REBOOT	/* This system has a software reboot capability */

#define CTLR_16BIT	/* This system has a device controller that cannot */
		   	/* handle transfers across a 64k boundary. */

#define AUTOBOOT	/* This system has autoboot support */
#define	AUTOFLAG	0xbe11	/* 3rd argument to shutdn() */
