
/*
 *	<sys/relsym.h> - Declarations for symbol table
 *		and relocation record structures.
 *
 *	Copyright (C) Microsoft Corporation, 1982
 */


/*
 *	Symbol table for x.out.
 *	Each symbol in the table has the below structure, followed
 *	immediately by its name in the form of a null terminated string.
 *	No effort is made to word align subsequent "sym" structures in
 *	the symbol table.  The contents of the s_seg field is defined
 *	for XS_SXSEG symbols only.  For XR_S86ABS symbols, the segment
 *	is stored in the high 16 bits of the s_value field, and the offset
 *	in the low 16 bits.
 */

struct sym {			    /* symbol management */
	unsigned short	s_type;		/* type */
	unsigned short	s_seg;		/* file segment table index */
	long		s_value;	/* address or value */
};


#define SYMLENGTH	50	/* max symbol name length */


/*
 *	Definitions for sym.s_type:
 *
 *	xxxxxxxxxx          extra
 *	          e         external
 *	           ttttt    type
 */

#define S_UNDEF		0x0000
#define S_ABS		0x0001
#define S_TEXT		0x0002
#define S_DATA		0x0003
#define S_BSS		0x0004
#define S_COMM		0x0005	/* for internal use only */
#define S_REG		0x0006
#define S_COMB		0x0007  /* for internal use only */
#define S_SEG		0x0008	/* segment name */
#define S_FN		0x001f
#define S_TYPE		0x001f	/* mask */

#define S_EXTERN	0x0020

#define FORMAT	"%08lx"	/* symbol value format */
#define FWIDTH	8	/* symbol value width  */


/*
 *	Relocation table entry for x.out and x.out segmented, long form.
 *	This form is normally attached to ".o" files and may also be found
 *	in segmented executables.
 */

struct reloc {
	unsigned short	r_desc;     /* descriptor */
	unsigned short	r_symbol;   /* if extern, sym id; else segment id */
	long		r_pos;	    /* position of reloc in segment */
};


/*
 *	Definitions for reloc.r_desc (short).
 *
 *	ss                  segment type
 *	  ss                size
 *	    d               displacement
 *	     rrr	    reference type
 *	        xxxxxxxx    extra
 */


			    /* type of segment referenced */
#define RD_TEXT	0x0000		/* text */
#define RD_DATA	0x4000		/* data */
#define RD_BSS	0x8000		/* bss */
#define RD_EXT	0xc000		/* unknown, use type of reloc.r_symbol */
#define RD_SEG	0xc000		/* segment type mask */

			    /* number of bytes involved in reference */
#define RD_BYTE	0x0000		/* 1 */
#define RD_WORD	0x1000		/* 2 */
#define RD_LONG	0x2000		/* 4 */
#define RD_SIZE	0x3000		/* size mask */

#define RD_DISP	0x0800		/* set if self relative (pc relative) */

			    /* type of reference */
#define RD_ROFF	0x0000		/* offset only */
#define RD_RSEG	0x0100		/* segment only */
#define RD_RFAR	0x0200		/* segment and offset */
#define RD_REFT	0x0700		/* reference type mask */


/*
 *	Relocation table entry for x.out, short form.
 *	This form is normally attached to non-segmented executable files.
 */

struct xreloc {
	long	xr_cmd;	    /* reloc command */
};


/*
 *	Definitions for xreloc.xr_cmd (long).
 *
 *	c                                   set if code segment
 *	 l                                  set if long operand
 *	  oooooooooooooooooooooooooooooo    offset
 */

#define XR_CODE	0x80000000L	/* code/data segment */
#define XR_LONG	0x40000000L	/* long/short operand */
#define XR_OFFS	0x3fffffffL	/* 30 bit offset mask */


/*
 *	Group structure for segmented x.out.
 *	A segment of type XS_TGRPS contains an array of struct xgroup.
 */

struct xgroup {
	unsigned short	xg_gnoff;	/* string table group name offset */
	unsigned short	xg_snoff;	/* string table segment name offset */
};




/*
 *	All of the following are provided for compatibility only.
 */

struct asym {			    /* a.out, modified from struct nlist */
	char		sa_name[8];	/* symbol name */
	unsigned short	sa_type;	/* type flag */
	unsigned short	sa_value;	/* value */
};


/*	Definitions for asym.sa_type and nlist.n_type.	*/

#define	N_UNDF	0	/* undefined */
#define	N_ABS	01	/* absolute */
#define	N_TEXT	02	/* text symbol */
#define	N_DATA	03	/* data symbol */
#define	N_BSS	04	/* bss symbol */
#define	N_TYPE	037
#define	N_REG	024	/* register name */
#define	N_FN	037	/* file name symbol */
#define	N_EXT	040	/* external bit, or'ed in */


struct bsym {		    /* b.out, non-portable version of x.out */
	char	sb_type;	/* use definitions for sym.s_type */
	long	sb_value;
};


/*
 *	Definitions for reloc.r_desc, compatible with bitfield
 *		allocation from the low end of a word (pdp11).
 */

#define RD_BTEXT	0x0000
#define RD_BDATA	0x0001
#define RD_BBSS		0x0002
#define RD_BEXT		0x0003
#define RD_BSEG		0x0003

#define RD_BBYTE	0x0000
#define RD_BWORD	0x0004
#define RD_BLONG	0x0008
#define RD_BSIZE	0x000c

#define RD_BDISP	0x0010
