/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1985
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

#define	IDD_NIL		0

/* current version */
#define	IDD_VERS	1

/* idd_tag (enumeration) */
#define	IDD_IDD		1

/* idd_type (bit field) */
#define	IDD_BDEV	0x0001
#define	IDD_CDEV	0x0002
#define	IDD_LINE	0x0004

/* idd_mask (bit field) */
#define	IDD_TTY		        0x0080
#define	IDD_INIT		0x0040
#define	IDD_POWER		0x0020
#define	IDD_OPEN		0x0010
#define	IDD_CLOSE		0x0008
#define	IDD_READ		0x0004
#define	IDD_WRITE		0x0002
#define	IDD_IOCTL		0x0001

/* idd_cmd (bit field) */
#define	IDD_ADD			0x0001
#define	IDD_REP			0x0002
#define	IDD_SHR			0x0004

#define	IDD_LNAME	(4 + 1)		/* entry point prefix (xx in xxopen) */
#define	IDD_LIDENT	(4 + 8 + 1)	/* max entry point name (xxstrategy) */
#define	IDD_NVEC	4		/* 4 vectors maximum */

/*
 * found in each idd.o under name 'xxiddsw'.
 * placed into iddsw[] by boot.
 */
struct iddsw {
	/* following specified in idd.o */
	ushort	idd_tag;		/* always IDD_IDD */
	ushort	idd_vers;
	ushort	idd_type;		/* device type(s) */
	ushort	idd_mask;		/* device entry point(s) */
	struct bdevsw	*idd_bdevsw;	/* ptr to xxbdevsw */
	struct cdevsw	*idd_cdevsw;	/* ptr to xxcdevsw */
	struct linesw	*idd_linesw;	/* ptr to xxlinesw */
	int 	(far *idd_init)( );	/* ptr to xxinit */
	int	(far *idd_intr)( );	/* ptr to xxintr */
	/* following specified in config.sys */
	int	idd_bdev;		/* bdev major # */
	int	idd_cdev;		/* cdev ... */
	int	idd_line;		/* line discipline # */
	int	idd_ivec[IDD_NVEC];	/* intr vector(s) */
	int	idd_cmd;		/* [bcl]dev,ivec command */
	char	idd_name[IDD_LNAME];	/* name (must agree w/ idd.o) */
};
