/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/*
 *	%Z% %M% %I% %D% %Q%
 */




/*
 * THIS FILE CONTAINS CODE WHICH IS DESIGNED TO BE
 * PORTABLE BETWEEN DIFFERENT MACHINE ARCHITECTURES
 * AND CONFIGURATIONS. IT SHOULD NOT REQUIRE ANY
 * MODIFICATIONS WHEN ADAPTING XENIX TO NEW HARDWARE.
 */


/*
**	MODIFICATION HISTORY
**
**	M000	12/19/84	lees
**	- Added support for System V shared data.
**	M001	04/25/85	lees
**	- Changed shmat() to return char far *.
**
*/


/*
 *	NOTE:  This file becomes /usr/include/sys/shm.h.  It includes
 *             only the System V parts of the kernel sd.h that users
 *             need to have.
 *
 */

/* System V defines */
#define SHM_RDONLY	010000	 /* attach read-only, else read-write */
#define SHM_RND		020000
#define SHMLBA		0x10000

/* shmctl cmds:  NOT YET IMPLEMENTED -- EINVAL IF USED */
#define SHM_LOCK	3
#define SHM_UNLOCK	4

struct	shmid_ds {
	struct	ipc_perm shm_perm;	/* operation permission struct */
	int	shm_segsz;		/* segment size */
	ushort	shm_ptbl;		/* addr of sd segment */
	ushort	shm_lpid;		/* pid of last shared mem op */
	ushort	shm_cpid;		/* creator pid */
	ushort	shm_nattch;		/* current # attached */
	ushort	shm_cnattch;		/* in-core # attached */
	time_t	shm_atime;		/* last attach time */
	time_t	shm_dtime;		/* last detach time */
	time_t	shm_ctime;		/* last change time */
};		

	/* M001 */
extern	char far *shmat();
