#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <machineio/scsiio.h>

main (argc, argv)
int argc;
char *argv[];
{
	struct scsiformat fmt;
	u_char atoi();
	char *drive;
	int interleave = 0;
	int level = 0;
	int fd; 

	switch (argc) {
	case 4:
		interleave = atoi (argv[3]);
	case 3:
		drive = argv[1];
		level = atoi (argv[2]);
		break;
	default:
		usage(argv[0]);
		exit (1);
		break;
	}

	if (interleave < MIN_INTERLEAVE || interleave > MAX_INTERLEAVE) {
		printf ("Level must be between %d and %d\n",
			MIN_INTERLEAVE, MAX_INTERLEAVE);
		usage(argv[0]);
		exit (2);
	}

	if ((fd = open (drive, O_RDWR)) < 0) {
		printf ("Could not open drive (%s)\n", drive);
		usage(argv[0]);
		exit(2);
	}

	fmt.interleave = interleave;

	if (interleave) {
		printf ("Using interleave (%d) ok?  ", interleave);
		if (!ok())
			exit (3);
	}


	switch (level) {
	case 1:
		fmt.level = FL_CHIL;
		printf ("Only changing interleave on disk ok? ");
		if (!ok())
			exit (3);
		break;
	case 2:
		fmt.level = FL_ONLYP;
		printf("Format just with manufactures list ok? ");
		if (!ok())
			exit (3);
		break;
	case 3:
		fmt.level = FL_PANDG;
		printf("Format with manufactures and grown list ok? ");
		if (!ok())
			exit (3);
		break;
	default:
		printf ("Illegal level (%d) must be between 1 and 3\n", level);
		usage(argv[0]);
		exit (3);
		break;
	}
	if (ioctl(fd, SCSIIOCFORMAT, &fmt) < 0) {
		perror ("format ioctl");
		exit (4);
	}
}
usage(prog)
	char *prog;
{
	printf ("usage: %s device level [interleave]\n",prog);
}

ok()
{
	char buf[100];

	while (gets(buf) != NULL) {
		switch (buf[0]) {
		case 'y':
		case 'Y':
			return (1);
		case 'n':
		case 'N':
			return (0);
		default:
			printf ("Types yes or no:  ");
			break;
		}
	}
}
