#! /bin/sh
#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
#$Header:bitprt.sh 12.0$
#$ACIS:bitprt.sh 12.0$
#$Source: /ibm/acis/usr/src/ibm/bitprt_ca/RCS/bitprt.sh,v $
#
# bitprt  -a | -8 | -8c | -16 [-t | [-Lp][-Pxx]]
#
# dump bitmap image of display to local printer or IBM 3812 printer
#  -a  dump the aed display
#  -8  dump the apa8 display (IBM 6153)
#  -8c  dump the apa8c display (IBM 6154)
#  -16  dump the apa16 display (IBM 6155)
#  -t  send output to standard out
#  -Lp pass parameter p to lpr
#  -Pxx use printer xx 
#
trap 'rm -f /tmp/$$.* ; exit 1' 1 2 3 15 
PATH="/bin:/usr/ucb:/usr/ibm:/usr/lib/ibmlp:/usr/lib/p3812:./:"
font="/usr/lib/p3812/usqzpmp_font"
dispcmd=""
printer="-P${PRINTER-lp}"
printcmd="lpr"
lopts=""
scalecmd="scale"
# save options are used by scale to preserve information
#	during image reduction
save="-b -w"
# scale values (scalelx,scalely for local printer;
#	scalepx,scalepy for IBM 3812 Pageprinter)
#	are chosen to try and preserve the aspect ratio
#	seen on the display screen.
scalelx=""
scalely=""
scalepx=""
scalepy=""

while true; do
	case $1 in

	"-a")
		dispcmd="dumpaed"
		scalelx="-x700"
		shift
		;;

	"-16")
		dispcmd="dumpapa16"
		scalelx="-x700"
		shift
		;;

	"-8")
		dispcmd="dumpapa8"
		scalelx="-x700"
		scalely="-y800"
		scalepx="-x1024"
		scalepy="-y768"
		shift
		;;

	"-8c")
		dispcmd="dumpapa8c"
		scalelx="-x700"
		scalely="-y800"
		scalepx="-x1024"
		scalepy="-y768"
		shift
		;;

	"-t")
		printcmd=""
		printer=""
		shift
		;;

	-L*)
		lopts="$lopts `echo $1 | \
			 sed -e 's;-L;;' `"
		shift
		;;

	-P*)
		printer=$1
		shift
		;;
	*)
		break
		;;
	esac
done
if [ $dispcmd ]; then
	$dispcmd > /tmp/$$.bitprt.out &&
	(
	if [ $printcmd ]; then
		if [ $printer = "-Plp" ]; then
  			cat /tmp/$$.bitprt.out | \
				$scalecmd $scalelx $scalely $save | \
			lpr -v $printer $lopts 
		else 
			if [ $scalepx  ]; then
#				### do something to satisfy if clause ###
				scalelx=""
			else
				scalecmd="cat"
				scalepy=""
				save=""
			fi
			( cat $font ;
			cat /tmp/$$.bitprt.out | \
				$scalecmd $scalepx $scalepy $save | \
				sqzpmp ) | lpr -v $printer 
		fi
	else
		cat /tmp/$$.bitprt.out
	fi
	rm -f /tmp/$$.*
	) 
else
	echo "bitprt  -a | -8 | -8c | -16 [-t | [ -L* ][ -P* ]]"
fi
