/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:ibmbit.c 12.0$ */
/* $ACIS:ibmbit.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/bitprt_ca/RCS/ibmbit.c,v $ */

#ifndef lint
static char *rcsid = "$Header:ibmbit.c 12.0$";
#endif

#define MAXCOLUMN 1584/8
#define MAXROWS 960
#define NOMINALROWS	900
#define NOMINALCOLUMNS MAXCOLMNS
#define	HIGHSPEED	'Y'
#define	HIGHRES		'L'
#define BYTESIZE 8
#define BASE 8
#define SPACING 24
#define ESC 27
#define FF 12
#include <stdio.h>

char rows[MAXROWS][MAXCOLUMN]; 

#define lfeed(space) putchar(ESC); putchar('J'); putchar(space);
#define graphout(width,gchar) putchar(ESC); putchar(gchar); putchar(width%256); putchar(width/256);

/* variables for output filters */
char	*name = "";			/* user's login name */
char	*host = "";			/* user's machine name */
char	*acctfile = "/dev/null";	/* accounting information file */
int	npages = 0;

main(argc,argv) char *argv[]; 
{
	register char *cp;
	unsigned int	length,width;
	int		i,j;
	int		xcount,ycount,c;
	int		gchar=HIGHRES;

	while (--argc) {
		if (*(cp = *++argv) == '-') {
			switch (cp[1]) {
				/* flag to indicate alternate dots for speed */
			case 'f':
				gchar=HIGHSPEED;
				break;
				/*
				 * The remaining flags are for ibmbit to meet
				 * output filter specifications 
				 */
			case 'n':
				argc--;
				name = *++argv;
				break;

			case 'h':
				argc--;
				host = *++argv;
				break;

				/* ignore next two ditroff/troff options */
			case 'x':
				break;

			case 'y':
				break;

			}
		} 
		else
			acctfile = cp;
	}

	/* get screen width from image file header */
	width=0;
	for (i=0; i < 4; i++) {
		if ((c=getchar()) == EOF) {
			fprintf(stderr,"ibmbit: imcomplete file header\n");
			exit(2);
			}
		width=width*256+c;
		}

	/* get length from image file header */
	length=0;
	for (i=0; i < 4; i++) {
		if ((c=getchar()) == EOF) {
			fprintf(stderr,"ibmbit: imcomplete file header\n");
			exit(2);
			}
		length=length*256+c;
		}

	/* initialize counters */
	xcount = 0;
	ycount = 0;

	/* loop while data is available or data is satisfied */
	while ((c=getchar()) != EOF) {
		/* reverse the order of bits, and change 1's to 0's */
		rows[xcount][ycount] = 255-reverse(c);
		if (++ycount >= width/BASE) {
			ycount = 0;
			if (++xcount >= length)
				break;
		}
	}
	/* Remove any trailing bytes from input */
	while ((c=getchar()) !=EOF);

	/* Scale output to fit on printer page */

	/*  dump out the bit map (turning one's to zero's and vice versa) */
	for (i=width/BASE-1; i>=0 ; i--) {
		graphout(length,gchar);
		for (j=0; j < length; j++)
			putchar(rows[j][i]);
		lfeed(SPACING);
		for (j=0;j==1000; j++); /* give printer breathing space */
	}
	putchar(FF);
	/* finish by reporting accounting information */
	npages++; /* assume only one page per image */
	if (name && acctfile && access(acctfile, 02) >= 0 &&
	    freopen(acctfile, "a", stdout) != NULL) {
		printf("%7.2f\t%s:%s\n", (float)npages, host, name);
	}
	exit(0);
}

reverse(c)
int c;
{
	int i,ret=0;
	for (i=0 ; i < BASE ; i++)
		if (c & (1<<i)) ret += (1 << (BASE-i-1));
	return(ret);
}

